/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import model2.Audit;
import model2.DEXFile;
import model2.Discipline;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDUnit;
import model2.IGDUnitBase;
import model2.SBdb;
import model2.Surface;
import model2.Userdef;
import model2.Well;
import model2.WellInterp;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.InvalidFieldException;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsStatus;

public class IGDScheme
extends Observable
implements SbugsStatus,
Comparable {
    private final SBdb sbdb;
    private final int igdType;
    private String name;
    private int schID;
    private SequenceType sqType;
    private Discipline discID;
    private List<IGDUnit> units;
    private List<Surface> surfaces;
    private Audit audit;
    private Color status;
    private IGDScheme link;
    private boolean interpRefresh;
    static final double SMALL = 1.0E-6;
    static final boolean DEBUG = false;

    public static void fixMfs(SBdb db, IGDScheme scheme) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        Statement stmt2 = db.getDatabase().createStatement();
        String sql = "SELECT surface_id, name FROM " + db.DBTableName("SURFACE") + " WHERE sch_id=" + scheme.getID() + " AND type=3";
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        while (rs.next()) {
            int id = rs.getInt("surface_id");
            String name = rs.getString("name");
            sql = "SELECT count(*) AS nOccs FROM " + db.DBTableName("sqpick") + " WHERE surface_id=" + id;
            ResultSet rs2 = stmt2.executeQuery(db.modQuery(sql));
            int nOccs = 0;
            if (rs2.next()) {
                nOccs = rs2.getInt("nOccs");
            }
            if (nOccs <= 0) continue;
            System.out.println("Processing: " + name);
            if (name.endsWith("SB")) {
                name = name.substring(0, name.lastIndexOf("SB")).trim();
            }
            if ((rs2 = stmt2.executeQuery(db.modQuery(sql = "SELECT surface_id, name FROM " + db.DBTableName("SURFACE") + " WHERE sch_id=" + scheme.getID() + " AND type=1 AND name like " + SB.DBString((String)(name + "%"))))).next()) {
                int mfsID = rs2.getInt("surface_id");
                System.out.println("Switching to: " + mfsID + " name: " + rs2.getString("name"));
                sql = "UPDATE " + db.DBTableName("sqpick") + " SET surface_id=" + mfsID + " WHERE surface_id=" + id;
                int nRows = stmt2.executeUpdate(db.modQuery(sql));
                System.out.println("" + nRows + " rows updated");
                continue;
            }
            System.out.println("Cannot find MFS for: " + name);
        }
        stmt.close();
        stmt2.close();
    }

    public List<ShadeInterval> getShadingIntervals(float min, float max) {
        LinkedList<ShadeInterval> list = new LinkedList<ShadeInterval>();
        for (int hier = IGDIntervalZone.getNHier(this.igdType, true); hier > 0; --hier) {
            for (IGDUnit unit : this.units) {
                if (unit.getHier() != hier || !(unit.getLage() > (double)min) || !(unit.getUage() < (double)max)) continue;
                float top = Math.max((float)unit.getUage(), min);
                float base = Math.min((float)unit.getLage(), max);
                if (list.isEmpty()) {
                    list.add(new ShadeInterval(top, base, unit.getColour()));
                    continue;
                }
                ShadeInterval si = (ShadeInterval)list.get(0);
                if (si.uAge > min && top < si.uAge) {
                    list.add(0, new ShadeInterval(top, Math.min(si.uAge, base), unit.getColour()));
                }
                if ((si = (ShadeInterval)list.get(list.size() - 1)).lAge < max && base > si.lAge) {
                    list.add(new ShadeInterval(Math.max(si.lAge, top), base, unit.getColour()));
                }
                boolean added = true;
                block2: while (added) {
                    added = false;
                    for (int i = 0; i < list.size() - 1; ++i) {
                        si = (ShadeInterval)list.get(i);
                        ShadeInterval siNext = (ShadeInterval)list.get(i + 1);
                        if (!(si.lAge < siNext.uAge) || !(top < siNext.uAge) || !(base > si.lAge)) continue;
                        list.add(i + 1, new ShadeInterval(Math.max(si.lAge, top), Math.min(siNext.uAge, base), unit.getColour()));
                        added = true;
                        continue block2;
                    }
                }
            }
        }
        return list;
    }

    void setSchID(int schID) {
        if (this.schID != 0) {
            throw new IllegalStateException("Attempt to set schID on saved scheme " + this);
        }
        if (schID <= 0) {
            throw new IllegalArgumentException("Attempt to set schID to " + schID);
        }
        this.schID = schID;
    }

    public IGDScheme(SBdb ws, int igdType, String name, Discipline disc, SequenceType sqType) {
        this.name = "";
        this.units = null;
        this.surfaces = null;
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.link = null;
        this.interpRefresh = false;
        this.sbdb = ws;
        this.igdType = igdType;
        this.name = name;
        if (this.isBiozone() && disc == null) {
            throw new IllegalArgumentException("No discipline set for biozone scheme '" + name + "'");
        }
        this.discID = disc;
        if (this.isSequence() && sqType == null) {
            throw new IllegalArgumentException("No sequence type set for sequence scheme '" + name + "'");
        }
        this.sqType = sqType;
        this.units = new LinkedList<IGDUnit>();
        this.surfaces = new LinkedList<Surface>();
    }

    static IGDScheme parseDEX(DEXFile.DEXsection section, SBdb db) throws SBException, SQLException {
        int igdType;
        try {
            igdType = IGDInterval.getIGDType(section.type.substring(0, section.type.lastIndexOf("SCHEME")).trim());
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new SBException("Scheme in DEX file of type: " + section.type + " is not recognised.");
        }
        IGDScheme scheme = new IGDScheme(db, igdType, "", igdType == 4 ? Discipline.MICRO : null, igdType == 10 ? SequenceType.DEPOSITIONAL : null);
        scheme.units = new LinkedList<IGDUnit>();
        IGDUnit.Builder builder = null;
        int unitID = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Scheme name")) {
                scheme.name = value;
                continue;
            }
            if (label.equalsIgnoreCase("Scheme ID")) {
                scheme.schID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Discipline")) {
                scheme.discID = Discipline.getDisc(value);
                continue;
            }
            if (label.equalsIgnoreCase("Number of units")) {
                int noofUnits = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Unit")) {
                if (builder != null) {
                    try {
                        scheme.addUnit(builder, unitID);
                    }
                    catch (InvalidFieldException e) {
                        System.out.println("Error parsing unit: " + e.getMessage());
                    }
                }
                builder = new IGDUnit.Builder(db).name(value);
                continue;
            }
            if (label.equalsIgnoreCase("Abbreviation")) {
                if (builder == null) continue;
                builder.abr(value);
                continue;
            }
            if (label.equalsIgnoreCase("Type")) {
                if (builder == null) continue;
                builder.hier(IGDIntervalZone.getHierNumber(igdType, value, true));
                continue;
            }
            if (label.equalsIgnoreCase("Youngest")) {
                if (builder == null) continue;
                builder.uAge(Double.parseDouble(value));
                continue;
            }
            if (label.equalsIgnoreCase("Oldest")) {
                if (builder == null) continue;
                builder.lAge(Double.parseDouble(value));
                continue;
            }
            if (label.equalsIgnoreCase("Colour")) {
                if (builder == null) continue;
                StringTokenizer tok = new StringTokenizer(value, ",");
                int red = Integer.parseInt(tok.nextToken());
                int green = Integer.parseInt(tok.nextToken());
                int blue = Integer.parseInt(tok.nextToken());
                builder.colour(new Color((char)red, (char)green, (char)blue));
                continue;
            }
            if (!label.equalsIgnoreCase("Dictionary ID")) continue;
            unitID = Integer.parseInt(value);
        }
        if (builder != null) {
            try {
                scheme.addUnit(builder, unitID);
            }
            catch (InvalidFieldException e) {
                System.out.println("Error parsing unit: " + e.getMessage());
            }
        }
        if (scheme.schID <= 0) {
            throw new IllegalStateException("No scheme ID found during DEX parsing for scheme: " + scheme.name);
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDScheme(SBdb db, int schID, int igdType, char discID, String name, SequenceType sqType, Date created, Userdef creator) throws SQLException {
        this.name = "";
        this.units = null;
        this.surfaces = null;
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.link = null;
        this.interpRefresh = false;
        this.sbdb = db;
        this.igdType = igdType;
        this.discID = Discipline.getDisc(discID);
        this.schID = schID;
        this.name = name;
        this.sqType = sqType;
        this.audit.created = created;
        this.audit.creator = creator != null ? creator.getUsrID() : db.getUser().getUsrID();
        this.audit.modified = created;
        this.audit.modifier = this.audit.creator;
        Statement stmt = db.getDatabase().createStatement();
        String sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_SCH") + " (sch_id,name,igd_type,disc_id,sqtype," + Audit.sqlFieldString() + ") VALUES (" + this.schID + "," + SB.DBString((String)this.name) + "," + this.igdType + "," + SB.DBChar((char)Discipline.getChar(this.discID)) + "," + SB.DBChar((char)SequenceType.getChar(this.sqType)) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
        this.status = STORED;
        this.units = new LinkedList<IGDUnit>();
        this.surfaces = new LinkedList<Surface>();
    }

    IGDScheme(SBdb ws, Element xml) throws ParseException, SQLException, SBException {
        IGDUnit igdUnit;
        Element el;
        this.name = "";
        this.units = null;
        this.surfaces = null;
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.link = null;
        this.interpRefresh = false;
        this.sbdb = ws;
        this.units = new LinkedList<IGDUnit>();
        this.surfaces = new LinkedList<Surface>();
        String strg = xml.getChildTextNormalize("SchemeType");
        if (strg == null) {
            throw new SBException("No igdType found");
        }
        this.igdType = IGDInterval.getIGDType(strg);
        strg = xml.getChildText("SchemeName");
        if (strg != null) {
            this.name = strg;
        }
        if ((strg = xml.getChildTextNormalize("SchemeID")) != null) {
            this.schID = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("Discipline")) != null) {
            this.discID = Discipline.getDisc(strg);
        }
        if ((strg = xml.getChildTextNormalize("SequenceModel")) != null && strg.length() > 0) {
            this.sqType = SequenceType.get(strg.charAt(0));
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for Scheme: " + this);
        }
        Iterator it = xml.getDescendants((Filter)new ElementFilter("Unit"));
        while (it.hasNext()) {
            igdUnit = new IGDUnit(ws, this.schID, this.igdType, (Element)it.next());
            try {
                this.checkUnit(igdUnit);
            }
            catch (InvalidFieldException e) {
                throw new SBException("Could not insert unit into scheme " + this + " : " + e.getMessage());
            }
            IGDUnit.insert(igdUnit, this.units);
        }
        it = xml.getDescendants((Filter)new ElementFilter("LithostratUnit"));
        while (it.hasNext()) {
            igdUnit = new IGDUnit(ws, this.schID, this.igdType, (Element)it.next());
            try {
                this.checkUnit(igdUnit);
                IGDUnit.insert(igdUnit, this.units);
            }
            catch (InvalidFieldException e) {
                System.out.println("Error inserting unit: " + igdUnit + " into scheme: " + e.getMessage());
            }
        }
        it = xml.getDescendants((Filter)new ElementFilter("Surface"));
        while (it.hasNext()) {
            this.surfaces.add(new Surface(ws, this.schID, (Element)it.next()));
        }
    }

    public static IGDScheme copyToWorkspace(SBdb ws, IGDScheme rhs) throws SQLException, SBException {
        Object b;
        if (ws.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy scheme to connected workspace");
        }
        IGDScheme scheme = new IGDScheme(ws, rhs.igdType, rhs.name, rhs.discID, rhs.sqType);
        scheme.schID = rhs.schID;
        scheme.units = new LinkedList<IGDUnit>();
        for (IGDUnit unit : rhs.getUnits()) {
            b = IGDUnit.Builder.copyOf(unit, ws);
            ((IGDUnit.Builder)b).getAudit().fillWorkspace(rhs.sbdb, scheme.sbdb);
            scheme.units.add(((IGDUnit.Builder)b).build(unit.getUnitID(), scheme.schID));
        }
        scheme.surfaces = new LinkedList<Surface>();
        for (Surface surface : rhs.getSurfaces()) {
            b = Surface.Builder.copyOf(ws, surface);
            ((Surface.Builder)b).getAudit().fillWorkspace(rhs.sbdb, scheme.sbdb);
            scheme.surfaces.add(((Surface.Builder)b).build(surface.getSurfaceID(), scheme.schID));
        }
        scheme.audit = new Audit(rhs.audit);
        scheme.audit.fillWorkspace(rhs.sbdb, scheme.sbdb);
        scheme.link = rhs;
        return scheme;
    }

    public static IGDScheme copyToDatabase(SBdb db, IGDScheme rhs) throws SQLException, SBException {
        if (!db.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy scheme to unconnected database");
        }
        IGDScheme scheme = new IGDScheme(db, rhs.igdType, rhs.name, rhs.discID, rhs.sqType);
        scheme.storeDetails();
        assert (scheme.schID > 0);
        scheme.units = new LinkedList<IGDUnit>();
        for (IGDUnit unit : rhs.getUnits()) {
            IGDUnit.Builder builder = IGDUnit.Builder.copyOf(unit, scheme.sbdb);
            scheme.units.add(builder.store(scheme.igdType, scheme.schID));
        }
        scheme.surfaces = new LinkedList<Surface>();
        for (Surface surface : rhs.getSurfaces()) {
            Surface.Builder b = Surface.Builder.copyOf(scheme.sbdb, surface);
            scheme.surfaces.add(b.store(scheme.schID));
        }
        scheme.audit = new Audit(rhs.audit);
        return scheme;
    }

    private void copyPrimitives(IGDScheme rhs) {
        this.discID = rhs.discID;
        this.sqType = rhs.sqType;
        this.name = rhs.name;
    }

    public boolean needsRefresh() {
        return this.interpRefresh;
    }

    public Surface addSurface(Surface.Builder builder) throws InvalidFieldException, SQLException, SBException {
        Surface surface;
        if (builder.getOriginalID() > 0) {
            throw new IllegalArgumentException("Attempt to update original surface in IGDScheme.addSurface");
        }
        if (builder.getModel() != this.sbdb) {
            throw new IllegalArgumentException("Attempt to add surface to scheme from different workspace");
        }
        if (!this.isSequence()) {
            throw new IllegalArgumentException("Attempt to add surface to non-sequence scheme: " + this);
        }
        if (this.getSurface(builder.getName()) != null) {
            throw new InvalidFieldException("Surface '" + builder.getName() + "' already exists in scheme: " + this);
        }
        if (this.sbdb.isConnected()) {
            surface = builder.store(this.schID);
        } else {
            builder.status(NOTSTORED);
            surface = builder.build(this.getNewSurfaceID(), this.schID);
        }
        Surface.insert(this.surfaces, surface);
        this.setChanged();
        return surface;
    }

    private int getNewSurfaceID() throws SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to get workspace ID for new surface in connected database");
        }
        int max = 1;
        if (this.surfaces.isEmpty()) {
            return max;
        }
        for (Surface surface : this.surfaces) {
            if (surface.getSurfaceID() <= max) continue;
            max = surface.getSurfaceID() + 1;
        }
        return max;
    }

    private int getNewUnitID() throws SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to get workspace ID for new unit in connected database");
        }
        int max = 1;
        if (this.units.isEmpty()) {
            return max;
        }
        for (IGDUnit unit : this.units) {
            if (unit.getUnitID() < max) continue;
            max = unit.getUnitID() + 1;
        }
        return max;
    }

    public Surface getSurface(IGDUnit unit, char which) throws SQLException, SBException {
        if (this.igdType != 10) {
            return null;
        }
        if (which == 'T' || which == ' ') {
            if (unit.getUage() < 1.0E-6) {
                if (which == 'T') {
                    return null;
                }
            } else {
                for (Surface surface : this.getSurfaces()) {
                    if (!(Math.abs(surface.getAge() - unit.getUage()) < 1.0E-6)) continue;
                    return surface;
                }
            }
        }
        if (which == 'B' || which == ' ') {
            if (unit.getLage() < 1.0E-6) {
                return null;
            }
            for (Surface surface : this.getSurfaces()) {
                if (!(Math.abs(surface.getAge() - unit.getLage()) < 1.0E-6)) continue;
                return surface;
            }
        }
        return null;
    }

    public String getSurfaces(IGDUnit unit) throws SQLException, SBException {
        String string = "";
        if (this.igdType != 10) {
            return null;
        }
        for (Surface surface : this.getSurfaces()) {
            if (!(surface.getAge() > 1.0E-6) || !(surface.getAge() >= unit.getUage()) || !(surface.getAge() <= unit.getLage())) continue;
            if (string.length() > 0) {
                string = string + ",";
            }
            string = string + surface.getName();
        }
        return string;
    }

    void insert(Surface surface) {
        boolean inserted = false;
        int i = 0;
        for (Surface s : this.surfaces) {
            if (s.getSortEntry().compareTo(surface.getSortEntry()) > 0) {
                this.surfaces.add(i, surface);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            this.surfaces.add(surface);
        }
    }

    public IGDUnit getHigherUnit(IGDUnit unit, int genHier) {
        for (IGDUnit u : this.units) {
            if (u.getHier() != genHier || !(unit.getUage() >= u.getUage()) || !(unit.getLage() <= u.getLage())) continue;
            return u;
        }
        return null;
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    public static IGDScheme copyToSequence(SBdb ws, IGDScheme scheme) throws SQLException, SBException {
        if (scheme.igdType == 10) {
            throw new IllegalArgumentException("Attempt to convert sequence scheme to sequence scheme");
        }
        IGDScheme sqSch = new IGDScheme(ws, 10, scheme.name, null, SequenceType.DEPOSITIONAL);
        sqSch.schID = scheme.getSchID();
        int oldMaxHier = IGDIntervalZone.getNHier(scheme.getIGDType(), true);
        int maxHier = IGDIntervalZone.getNHier(10, true);
        int factor = oldMaxHier - maxHier;
        sqSch.units = new LinkedList<IGDUnit>();
        for (IGDUnit unit : scheme.units) {
            IGDUnit.Builder copy = IGDUnit.Builder.copyOf(unit, ws);
            if (copy.getHier() - factor > 0) {
                copy.hier(unit.getHier() - factor);
            }
            if (copy.getHier() == 0) {
                copy.hier(1);
            }
            sqSch.units.add(copy.build(unit.getUnitID(), sqSch.getSchID()));
        }
        sqSch.surfaces = new LinkedList<Surface>();
        return sqSch;
    }

    public List<MatchSchemes> findMatches(SBdb db, List<IGDIntervalZone> informalTerms) throws SQLException {
        if (this.units.isEmpty()) {
            return null;
        }
        LinkedList<MatchSchemes> matchSchemes = new LinkedList<MatchSchemes>();
        Statement stmt = db.getDatabase().createStatement();
        for (IGDUnit unit : this.units) {
            String sql = "SELECT sch_id FROM " + db.DBTableName("IGD_DICT") + " WHERE ucase(name)=" + SB.DBString((String)unit.getName().toUpperCase()) + " AND igd_type=" + this.igdType;
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                int msSchID = rs.getInt("sch_id");
                boolean found = false;
                for (MatchSchemes ms : matchSchemes) {
                    if (ms.scheme.getSchID() != msSchID) continue;
                    ++ms.nMatches;
                    found = true;
                    break;
                }
                if (found) continue;
                matchSchemes.add(new MatchSchemes(db.getIGDScheme(msSchID)));
            }
        }
        HashSet<String> uniqueNames = new HashSet<String>();
        for (IGDIntervalZone zone : informalTerms) {
            if (zone.getUppInf() != null && zone.getUppInf().length() > 0 && !uniqueNames.contains(zone.getUppInf().toUpperCase())) {
                uniqueNames.add(zone.getUppInf().toUpperCase());
            }
            if (zone.getLowInf() == null || zone.getLowInf().length() <= 0 || uniqueNames.contains(zone.getLowInf().toUpperCase())) continue;
            uniqueNames.add(zone.getLowInf().toUpperCase());
        }
        for (String term : uniqueNames) {
            String sql = "SELECT sch_id FROM " + db.DBTableName("IGD_DICT") + " WHERE ucase(name)=" + SB.DBString((String)term) + " AND igd_type=" + this.igdType;
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                int msSchID = rs.getInt("sch_id");
                boolean found = false;
                for (MatchSchemes ms : matchSchemes) {
                    if (ms.scheme.getSchID() != msSchID) continue;
                    ++ms.nInformalMatches;
                    found = true;
                    break;
                }
                if (found) continue;
                matchSchemes.add(new MatchSchemes(db.getIGDScheme(msSchID), uniqueNames.size()));
            }
        }
        if (matchSchemes.isEmpty()) {
            System.out.println("No Matching schemes");
        }
        for (MatchSchemes ms : matchSchemes) {
            System.out.println("Scheme name: " + ms.scheme.toString() + "\t\tNo. Matches: " + ms.nMatches);
        }
        stmt.close();
        return matchSchemes;
    }

    public List<MatchSchemes> findMatches(SBdb db) throws SQLException, SBException {
        if (this.igdType != 10) {
            throw new SBException("Attempt to findMatches on non-sequence scheme");
        }
        if (this.surfaces.isEmpty()) {
            return null;
        }
        LinkedList<MatchSchemes> matchSchemes = new LinkedList<MatchSchemes>();
        Statement stmt = db.getDatabase().createStatement();
        for (Surface surface : this.surfaces) {
            String sql = "SELECT sch_id FROM " + db.DBTableName("SURFACE") + " WHERE ucase(name)=" + SB.DBString((String)surface.getName().toUpperCase());
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                int msSchID = rs.getInt("sch_id");
                boolean found = false;
                for (MatchSchemes ms : matchSchemes) {
                    if (ms.scheme.getSchID() != msSchID) continue;
                    ++ms.nMatches;
                    found = true;
                    break;
                }
                if (found) continue;
                matchSchemes.add(new MatchSchemes(db.getIGDScheme(msSchID)));
            }
        }
        stmt.close();
        if (matchSchemes.isEmpty()) {
            System.out.println("No Matching schemes");
        }
        for (MatchSchemes ms : matchSchemes) {
            System.out.println("Scheme name: " + ms.scheme.toString() + "\t\tNo. Matches: " + ms.nMatches);
        }
        return matchSchemes;
    }

    public List<Surface> getSurfaces() throws SQLException {
        if (this.surfaces == null) {
            this.loadSurfaces();
        }
        return this.surfaces;
    }

    public List<Surface> getSurfacesX() {
        LinkedList<Surface> newList = new LinkedList<Surface>();
        newList.addAll(this.surfaces);
        return newList;
    }

    public int getID() {
        return this.schID;
    }

    public char getDiscID() {
        return this.discID.getChar();
    }

    public Discipline getDiscipline() {
        return this.discID;
    }

    public SequenceType getSqType() {
        return this.sqType;
    }

    public int compareTo(Object rhs) {
        return this.name.compareToIgnoreCase(rhs.toString());
    }

    IGDUnit findUnit(double uAge, double lAge, int hier) {
        int upper = (int)(uAge * 1000000.0);
        int lower = (int)(lAge * 1000000.0);
        if (lower == 0) {
            return null;
        }
        for (IGDUnit unit : this.units) {
            if (unit.getHier() != hier || unit.getUageInt() > upper || unit.getLageInt() < lower) continue;
            return unit;
        }
        return null;
    }

    int getSchID() {
        return this.schID;
    }

    public List<IGDUnit> getUnits() throws SQLException {
        if (this.units == null) {
            this.loadUnits();
        }
        return this.units;
    }

    public List<IGDUnit> getUnitsX() {
        LinkedList<IGDUnit> newList = new LinkedList<IGDUnit>();
        newList.addAll(this.units);
        return newList;
    }

    public double getMinAge() throws SQLException {
        double minAge = 99999.0;
        boolean assigned = false;
        for (IGDUnit unit : this.getUnits()) {
            if (!(unit.getUage() < minAge)) continue;
            minAge = unit.getUage();
            assigned = true;
        }
        if (assigned) {
            return minAge;
        }
        return 0.0;
    }

    public double getMaxAge() throws SQLException {
        double maxAge = 0.0;
        boolean assigned = false;
        for (IGDUnit unit : this.getUnits()) {
            if (!(unit.getLage() > maxAge)) continue;
            maxAge = unit.getLage();
            assigned = true;
        }
        if (assigned) {
            return maxAge;
        }
        return 500.0;
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    private void checkUnit(IGDUnitBase b) throws InvalidFieldException {
        for (IGDUnit u : this.units) {
            if (u.getSortEntry().equals(b.getSortEntry())) {
                throw new InvalidFieldException("Unit '" + u.getName() + "' already exists in scheme: " + this.name);
            }
            if (b.getName().compareToIgnoreCase(u.getName()) != 0) continue;
            throw new InvalidFieldException("Unit: '" + b.getName() + "' already exists in scheme as: " + u.getName() + " in scheme: " + this.name);
        }
    }

    int checkUnitUnique(IGDUnit unit) throws SBException, SQLException {
        IGDUnit tmp;
        this.getUnits();
        for (int i = 0; i < this.units.size(); ++i) {
            tmp = this.units.get(i);
            if (tmp.getSortEntry().equals(unit.getSortEntry())) {
                throw new SBException("Unit: '" + tmp.getName() + "' already exists in scheme");
            }
            if (unit.getName().compareToIgnoreCase(tmp.getName()) != 0) continue;
            throw new SBException("Unit: '" + tmp.getName() + "' already exists in scheme as: " + unit.getName());
        }
        int insertionPoint = -1;
        for (int i = 0; i < this.units.size(); ++i) {
            tmp = this.units.get(i);
            if (tmp.getSortEntry().compareTo(unit.getSortEntry()) <= 0) continue;
            insertionPoint = i;
            break;
        }
        if (insertionPoint < 0) {
            insertionPoint = this.units.size();
        }
        return insertionPoint;
    }

    public Surface getSurface(int surfaceID) throws SQLException {
        for (Surface surface : this.getSurfaces()) {
            if (surface.getSurfaceID() != surfaceID) continue;
            return surface;
        }
        return null;
    }

    public Surface getSurface(String surfaceName) throws SQLException {
        for (Surface surface : this.getSurfaces()) {
            if (!surface.getName().equals(surfaceName)) continue;
            return surface;
        }
        return null;
    }

    public int findSurfaceID(int unitID, Surface.SurfaceType type) throws SQLException, SBException {
        IGDUnit unit = this.findUnit(unitID);
        if (unit != null) {
            return this.findSurfaceID(unit.getName() + ' ' + (Object)((Object)type), type, true);
        }
        System.out.println("IGDScheme.getSurfaceID Attempt to get surface ID for unknown unit: " + unitID);
        return 0;
    }

    public int findSurfaceID(String unitName, Surface.SurfaceType type, boolean create) throws SQLException, SBException {
        for (Surface surface : this.getSurfaces()) {
            if (!surface.getName().equals(unitName) && !surface.getName().equals(unitName + " " + (Object)((Object)type))) continue;
            return surface.getSurfaceID();
        }
        if (create) {
            try {
                Surface surface = this.addSurface(new Surface.Builder(this.sbdb).name(unitName + " " + (Object)((Object)type)).type(type));
                return surface.getSurfaceID();
            }
            catch (InvalidFieldException e) {
                throw new SBException(e.getMessage());
            }
        }
        return 0;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    void refresh(Statement stmt) throws SQLException, SBException {
        Comparable notifier;
        if (this.units != null && (notifier = IGDUnit.refresh(this.sbdb, this.schID, this.units, stmt)) != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
        if (this.surfaces != null && (notifier = Surface.refresh(stmt, this.sbdb, this.schID, this.surfaces)) != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
        this.interpRefresh = false;
    }

    public void loadSurfaces() throws SQLException {
        if (this.surfaces != null) {
            return;
        }
        this.loadUnits();
        this.surfaces = new LinkedList<Surface>();
        if (this.sbdb != null && this.sbdb.isConnected()) {
            Surface.load(this.sbdb, this.schID, this.surfaces, this);
        }
    }

    final int insertUnit(IGDUnit unit) throws SBException, SQLException {
        if (this.units == null) {
            throw new IllegalStateException("units null in IGDScheme.insertUnit");
        }
        int insertionPoint = this.checkUnitUnique(unit);
        this.units.add(insertionPoint, unit);
        return insertionPoint;
    }

    public IGDUnit addUnit(IGDUnit.Builder builder) throws InvalidFieldException, SQLException, SBException {
        return this.addUnit(builder, -1);
    }

    public IGDUnit addUnit(IGDUnit.Builder builder, int workspaceUnitID) throws InvalidFieldException, SQLException, SBException {
        IGDUnit unit;
        if (builder.getOriginalID() > 0) {
            throw new IllegalArgumentException("Attempt to update original unit in IGDScheme.addSurface");
        }
        if (builder.getModel() != this.sbdb) {
            throw new IllegalArgumentException("Attempt to add unit to scheme from different workspace");
        }
        if (workspaceUnitID > 0 && this.findUnit(workspaceUnitID) != null) {
            throw new IllegalArgumentException("Unit with ID " + workspaceUnitID + " already exists in scheme as " + this.findUnit(workspaceUnitID));
        }
        this.checkUnit(builder);
        if (this.sbdb.isConnected()) {
            unit = builder.store(this.igdType, this.schID);
        } else {
            builder.status(NOTSTORED);
            if (workspaceUnitID <= 0) {
                workspaceUnitID = this.getNewUnitID();
            }
            unit = builder.build(workspaceUnitID, this.schID);
        }
        IGDUnit.insert(unit, this.units);
        this.setChanged();
        return unit;
    }

    public void deleteUnit(IGDUnit unit) throws SQLException {
        if (this.units == null) {
            throw new IllegalStateException("units null in IGDScheme.deleteUnit");
        }
        if (!this.units.contains(unit)) {
            throw new IllegalStateException("Attempt to delete unit when not in scheme");
        }
        unit.delete(null);
        this.units.remove(unit);
        this.setChanged();
    }

    public void deleteSurface(Surface surface) throws SQLException {
        if (this.surfaces == null) {
            throw new IllegalStateException("surfaces null in IGDScheme.deleteSurface");
        }
        if (!this.surfaces.contains(surface)) {
            throw new IllegalStateException("Attempt to delete surface when not in scheme");
        }
        surface.delete(null);
        this.surfaces.remove(surface);
        this.setChanged();
    }

    public IGDUnit updateUnit(IGDUnit.Builder builder) throws SQLException, InvalidFieldException, SBException {
        if (this.units == null) {
            throw new IllegalStateException("units null in IGDScheme.updateUnit");
        }
        if (builder.getOriginalID() < 0) {
            throw new IllegalArgumentException("Attempt to update unit using builder with no original link");
        }
        if (this.findUnit(builder.getOriginalID()) == null) {
            throw new IllegalArgumentException("Scheme can only update its own units");
        }
        if (!this.findUnit(builder.getOriginalID()).getName().equals(builder.getName()) && this.findUnit(builder.getName()) != null) {
            throw new InvalidFieldException("Cannot update unit: new name already exists in scheme");
        }
        IGDUnit original = this.findUnit(builder.getOriginalID());
        if (builder.getHier() != original.getHier() || Math.abs(builder.getUage() - original.getUage()) > 1.0E-7 || Math.abs(builder.getLage() - original.getLage()) > 1.0E-7) {
            LinkedList<IGDUnitBase> bases = new LinkedList<IGDUnitBase>();
            bases.addAll(this.units);
            bases.remove(original);
            bases.add(builder);
            IGDScheme.checkSchemeUnitsBase(bases);
        }
        IGDUnit unit = builder.store(this.igdType, this.schID);
        this.setChanged();
        this.sbdb.refreshIntervals(this);
        return unit;
    }

    public IGDUnit findUnit(String unitName) throws SQLException {
        for (IGDUnit unit : this.getUnits()) {
            if (!unit.getName().equalsIgnoreCase(unitName)) continue;
            return unit;
        }
        return null;
    }

    public Surface findSurface(String surfaceName, Surface.SurfaceType type) throws SBException, SQLException {
        if (surfaceName == null || surfaceName.isEmpty()) {
            return null;
        }
        this.getSurfaces();
        for (int i = 0; i < this.surfaces.size(); ++i) {
            Surface surface = this.surfaces.get(i);
            if (surface.getName().compareToIgnoreCase(surfaceName) != 0 || surface.getType() != type) continue;
            return surface;
        }
        return null;
    }

    public Surface findSurface(double age, Surface.SurfaceType type) throws SBException, SQLException {
        this.getSurfaces();
        for (int i = 0; i < this.surfaces.size(); ++i) {
            Surface surface = this.surfaces.get(i);
            if (!(Math.abs(surface.getAge() - age) < 0.001) || surface.getType() != type) continue;
            return surface;
        }
        return null;
    }

    public IGDUnit findUnit(int unitID) throws SQLException {
        if (unitID == 0) {
            return null;
        }
        this.getUnits();
        for (int i = 0; i < this.units.size(); ++i) {
            IGDUnit unit = this.units.get(i);
            if (unit.getUnitID() != unitID) continue;
            return unit;
        }
        return null;
    }

    public IGDUnit findUnit(double age) throws SBException, SQLException {
        return this.findUnit(age, false);
    }

    public IGDUnit findUnit(double age, boolean upper) throws SQLException {
        this.getUnits();
        if (age < 1.0E-6) {
            return null;
        }
        IGDUnit match = null;
        for (int i = 0; i < this.units.size(); ++i) {
            IGDUnit unit = this.units.get(i);
            if (upper) {
                if (!(age >= unit.getUage()) || !(age < unit.getLage())) continue;
                match = unit;
                continue;
            }
            if (!(age > unit.getUage()) || !(age <= unit.getLage())) continue;
            match = unit;
        }
        return match;
    }

    public static IGDUnit.Builder findUnit(LinkedList<IGDUnit.Builder> list, double age, boolean upper) {
        if (age < 1.0E-6) {
            return null;
        }
        IGDUnit.Builder match = null;
        for (IGDUnit.Builder unit : list) {
            if (upper) {
                if (!(age >= unit.getUage()) || !(age < unit.getLage())) continue;
                match = unit;
                continue;
            }
            if (!(age > unit.getUage()) || !(age <= unit.getLage())) continue;
            match = unit;
        }
        return match;
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public Color getStatus() {
        if (this.status == UNKNOWN && this.name.length() > 0) {
            this.status = this.schID != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUnits() throws SQLException {
        if (this.units != null) {
            return;
        }
        this.units = new LinkedList<IGDUnit>();
        if (!this.sbdb.isConnected()) {
            return;
        }
        String sql = "SELECT igd_id,hier,name,abr,u_age,l_age,red,green,blue," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("IGD_DICT") + " WHERE sch_id=" + this.schID + " ORDER BY u_age,hier,l_age";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                IGDUnit.Builder b = new IGDUnit.Builder(this.sbdb);
                int igdID = rs.getInt("igd_id");
                int hier = rs.getInt("hier");
                if (this.igdType == 10 && hier == 0) {
                    hier = 1;
                }
                b.hier(hier);
                b.name(rs.getString("name"));
                b.abr(rs.getString("abr"));
                b.uAge(rs.getDouble("u_age"));
                b.lAge(rs.getDouble("l_age"));
                b.colour(new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue")));
                b.audit(new Audit(rs)).status(STORED);
                try {
                    IGDUnit unit = b.build(igdID, this.schID);
                    IGDUnit.insert(unit, this.units);
                }
                catch (RuntimeException re) {
                    SB.showStackError((String)"", (Exception)re);
                }
            }
            rs.close();
        }
        finally {
            stmt.close();
        }
    }

    public boolean checkDeletedUnits(IGDScheme rhs) throws SQLException, SBException {
        if (this.sbdb == null || this.sbdb.getDatabase() == null) {
            return true;
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        for (IGDUnit unit : this.units) {
            String sql;
            ResultSet rs;
            if (rhs.findUnit(unit.getUnitID()) != null || !(rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT top_id FROM " + this.sbdb.DBTableName("IGD") + " WHERE upp_zone=" + unit.getUnitID() + " OR low_zone=" + unit.getUnitID()))).next()) continue;
            stmt.close();
            return false;
        }
        stmt.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDeletedUnits(LinkedList<IGDUnit.Builder> list) throws SQLException {
        if (!this.sbdb.isConnected()) {
            return true;
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            for (IGDUnit unit : this.units) {
                String sql;
                ResultSet rs;
                boolean deleted = true;
                for (IGDUnit.Builder builder : list) {
                    if (builder.getOriginalID() != unit.getUnitID()) continue;
                    deleted = false;
                    break;
                }
                if (!deleted || !(rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT top_id FROM " + this.sbdb.DBTableName("IGD") + " WHERE upp_zone=" + unit.getUnitID() + " OR low_zone=" + unit.getUnitID()))).next()) continue;
                stmt.close();
                boolean bl = false;
                return bl;
            }
        }
        finally {
            stmt.close();
        }
        return true;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getSchemes(SBdb sbdb, int igdType) throws SQLException {
        if (!sbdb.isConnected()) {
            return null;
        }
        LinkedList<IGDScheme> schemes = new LinkedList<IGDScheme>();
        String sql = "SELECT sch_id,igd_type,disc_id,sqtype,name," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("IGD_SCH");
        if (igdType > 0) {
            sql = sql + " WHERE igd_type=" + igdType;
        }
        sql = sql + " ORDER BY name";
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int schID = rs.getInt("sch_id");
                int type = rs.getInt("igd_type");
                char discID = SB.getDBChar((ResultSet)rs, (String)"disc_id");
                char sqType = SB.getDBChar((ResultSet)rs, (String)"sqtype");
                String name = rs.getString("name");
                IGDScheme scheme = null;
                try {
                    scheme = new IGDScheme(sbdb, type, name, Discipline.getDisc(discID), SequenceType.get(sqType));
                }
                catch (IllegalArgumentException e) {
                    if (type == 4 && Discipline.getDisc(discID) == null) {
                        SB.showStackError((String)"Error loading scheme", (Exception)((Object)new SBException(e.getMessage() + "\n Discipline reset to 'Micro'. You must open and save this scheme.")));
                        scheme = new IGDScheme(sbdb, type, name, Discipline.MICRO, SequenceType.get(sqType));
                    }
                    throw e;
                }
                scheme.schID = schID;
                scheme.audit = new Audit(rs);
                scheme.units = null;
                scheme.surfaces = null;
                scheme.status = STORED;
                schemes.add(scheme);
            }
        }
        finally {
            stmt.close();
        }
        return schemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IGDScheme(SBdb sbdb, int schID) throws SQLException, SBException {
        block4: {
            this.name = "";
            this.units = null;
            this.surfaces = null;
            this.audit = new Audit();
            this.status = UNKNOWN;
            this.link = null;
            this.interpRefresh = false;
            String sql = "SELECT name,igd_type,disc_id,sqtype," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("IGD_SCH") + " WHERE sch_id=" + schID;
            Statement stmt = sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                if (rs.next()) {
                    this.sbdb = sbdb;
                    this.name = rs.getString("name");
                    this.igdType = rs.getInt("igd_type");
                    this.discID = Discipline.getDisc(SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                    this.sqType = SequenceType.get(SB.getDBChar((ResultSet)rs, (String)"sqtype"));
                    this.schID = schID;
                    this.audit = new Audit(rs);
                    break block4;
                }
                throw new SBException("Scheme with ID=" + schID + ", not found in database");
            }
            finally {
                stmt.close();
            }
        }
    }

    static IGDScheme load(SBdb sbdb, int schID, IGDScheme scheme) throws SQLException, SBException {
        if (scheme != null && scheme.getSchID() != schID) {
            throw new IllegalArgumentException("Attempt to refresh scheme using different ID");
        }
        IGDScheme temp = new IGDScheme(sbdb, schID);
        if (scheme != null) {
            scheme.name = temp.name;
            scheme.discID = temp.discID;
            scheme.sqType = temp.sqType;
            scheme.audit = new Audit(temp.audit);
        } else {
            scheme = temp;
        }
        return scheme;
    }

    public void checkSurfaces() throws SBException {
        for (Surface surface : this.surfaces) {
            if (surface.getName() == null || surface.getName().length() == 0) {
                throw new SBException("Surface name missing");
            }
            for (Surface compare : this.surfaces) {
                if (compare == surface) continue;
                if (compare.getName().equalsIgnoreCase(surface.getName())) {
                    throw new SBException("Duplicate surface name: " + compare.getName());
                }
                if (!(compare.getAge() > 0.0) || !(Math.abs(compare.getAge() - surface.getAge()) < 1.0E-5)) continue;
                throw new SBException("Duplicate ages in surfaces: " + compare.getName() + " / " + surface.getName());
            }
        }
    }

    private static IGDUnit.Builder findBuilder(LinkedList<IGDUnit.Builder> list, int unitID) {
        for (IGDUnit.Builder b : list) {
            if (b.getOriginalID() != unitID) continue;
            return b;
        }
        return null;
    }

    private static Surface.Builder findBuilder(int surfaceID, LinkedList<Surface.Builder> list) {
        for (Surface.Builder b : list) {
            if (b.getOriginalID() != surfaceID) continue;
            return b;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(LinkedList<IGDUnit.Builder> builders, LinkedList<Surface.Builder> surfaceBuilders, String name, Discipline discID, SequenceType sqType) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit temp = new Audit(this.audit);
        LinkedList<IGDUnit> newUnits = new LinkedList<IGDUnit>();
        for (IGDUnit.Builder builder : builders) {
            newUnits.add(builder.store(this.igdType, this.schID));
        }
        Collections.sort(newUnits);
        LinkedList<Surface> newSurfaces = null;
        if (this.isSequence()) {
            newSurfaces = new LinkedList<Surface>();
            for (Surface.Builder builder : surfaceBuilders) {
                newSurfaces.add(builder.store(this.schID));
            }
            Collections.sort(newSurfaces);
        }
        try {
            if (!name.equals(this.name) || sqType != this.getSqType() || discID != this.discID) {
                String sql = "UPDATE " + this.sbdb.DBTableName("IGD_SCH") + " set name=" + SB.DBString((String)name) + ",sqtype=" + SB.DBChar((char)SequenceType.getChar(sqType)) + ",disc_id=" + SB.DBChar((char)Discipline.getChar(discID)) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            Iterator<IGDUnit> itr = this.units.iterator();
            while (itr.hasNext()) {
                IGDUnit unit = itr.next();
                if (IGDScheme.findBuilder(builders, unit.getUnitID()) != null) continue;
                unit.delete(stmt);
                itr.remove();
            }
            if (this.isSequence()) {
                Iterator<Surface> itrS = this.surfaces.iterator();
                while (itrS.hasNext()) {
                    Surface surface = itrS.next();
                    if (IGDScheme.findBuilder(surface.getSurfaceID(), surfaceBuilders) != null) continue;
                    surface.delete(stmt);
                    itrS.remove();
                }
            }
        }
        finally {
            stmt.close();
        }
        this.units = newUnits;
        this.surfaces = newSurfaces;
        this.name = name;
        this.sqType = sqType;
        this.discID = discID;
        this.audit = temp;
        if (!this.isSequence()) {
            this.sbdb.refreshIntervals(this);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoccs() throws SQLException {
        String sql = this.igdType == 10 ? "SELECT count(s.surface_id) as nOcc FROM " + this.sbdb.DBTableName("SURFACE") + " s, " + this.sbdb.DBTableName("SQPICK") + " p WHERE " + "p.surface_id=s.surface_id AND s.sch_id=" + this.schID : "SELECT count(sch_id) as nOcc FROM " + this.sbdb.DBTableName("IGD") + " WHERE sch_id=" + this.schID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            int nOccs = 0;
            if (rs.next()) {
                nOccs = rs.getInt("nOcc");
            }
            int n = nOccs;
            return n;
        }
        finally {
            stmt.close();
        }
    }

    public List<String> getOccs() throws SQLException {
        ResultSet rs;
        String sql;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ArrayList<String> occs = new ArrayList<String>();
        if (this.igdType != 10) {
            sql = "SELECT DISTINCT v.well_id,w.well_name,v.well_code FROM " + this.sbdb.DBTableName("IGD") + " i," + this.sbdb.DBTableName("WELL_IDENT") + " v," + this.sbdb.DBTableName("WELLS") + " w" + " WHERE i.sch_id=" + this.schID + " AND i.well_id=v.well_id AND v.well_code=w.well_code ORDER BY well_name";
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                occs.add((this.igdType == 10 ? "Intervals: " : "") + rs.getString("well_name") + " (" + rs.getString("well_code") + ")");
            }
        }
        if (this.igdType == 10) {
            sql = "SELECT DISTINCT v.well_id,w.well_name,v.well_code FROM " + this.sbdb.DBTableName("SQPICK") + " i," + this.sbdb.DBTableName("SURFACE") + " s," + this.sbdb.DBTableName("WELL_IDENT") + " v," + this.sbdb.DBTableName("WELLS") + " w" + " WHERE i.surface_id=s.surface_id AND s.sch_id=" + this.schID + " AND i.well_id=v.well_id AND v.well_code=w.well_code ORDER BY well_name";
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                rs.getInt("well_id");
                occs.add("Picks: " + rs.getString("well_name") + " (" + rs.getString("well_code") + ")");
            }
        }
        stmt.close();
        return occs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNHdrOccs() throws SQLException {
        String sql = "SELECT count(sch_id) as nOcc FROM " + this.sbdb.DBTableName("IGD_HDR") + " WHERE sch_id=" + this.schID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            int nOccs = 0;
            if (rs.next()) {
                nOccs = rs.getInt("nOcc");
            }
            int n = nOccs;
            return n;
        }
        finally {
            stmt.close();
        }
    }

    public List<Well> getWellOccs() throws SQLException, SBException {
        String sql = this.igdType != 10 ? "SELECT DISTINCT v.well_id,w.well_name FROM " + this.sbdb.DBTableName("IGD") + " i," + this.sbdb.DBTableName("WELL_IDENT") + " v," + this.sbdb.DBTableName("WELLS") + " w" + " WHERE i.sch_id=" + this.schID + " AND i.well_id=v.well_id AND v.well_code=w.well_code ORDER BY well_name" : "SELECT DISTINCT v.well_id,w.well_name,v.well_code FROM " + this.sbdb.DBTableName("SQPICK") + " i," + this.sbdb.DBTableName("SURFACE") + " s," + this.sbdb.DBTableName("WELL_IDENT") + " v," + this.sbdb.DBTableName("WELLS") + " w" + " WHERE i.surface_id=s.surface_id AND s.sch_id=" + this.schID + " AND i.well_id=v.well_id AND v.well_code=w.well_code ORDER BY well_name";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        ArrayList<Well> occs = new ArrayList<Well>();
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            occs.add(this.sbdb.getAddWell(wellID));
        }
        stmt.close();
        return occs;
    }

    public List getWellInterps(Well well) throws SQLException, SBException {
        String sql = this.igdType == 10 ? "SELECT DISTINCT i.interp_id FROM " + this.sbdb.DBTableName("SQPICK") + " i," + this.sbdb.DBTableName("SURFACE") + " s" + " WHERE i.surface_id=s.surface_id AND s.sch_id=" + this.schID + " AND i.well_id=" + well.wellID : "SELECT DISTINCT i.interp_id FROM " + this.sbdb.DBTableName("IGD") + " i" + " WHERE i.sch_id=" + this.schID + " AND i.well_id=" + well.wellID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        ArrayList<WellInterp> occs = new ArrayList<WellInterp>();
        boolean hasDefaultInterp = false;
        while (rs.next()) {
            int interpID = rs.getInt("interp_id");
            if (interpID <= 0 && hasDefaultInterp) continue;
            occs.add(well.getAddInterp(this.sbdb.getInterp(interpID)));
            if (interpID != 0) continue;
            hasDefaultInterp = true;
        }
        stmt.close();
        return occs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeDetails() throws SQLException {
        String sql;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        if (this.schID <= 0) {
            this.schID = this.sbdb.nextControl("IGD_SCH", "SCH_ID");
            sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_SCH") + " (sch_id,name,igd_type,disc_id,sqtype," + Audit.sqlFieldString() + ") VALUES (" + this.schID + "," + SB.DBString((String)this.name) + "," + this.igdType + "," + SB.DBChar((char)Discipline.getChar(this.discID)) + "," + SB.DBChar((char)SequenceType.getChar(this.sqType)) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        } else {
            sql = "UPDATE " + this.sbdb.DBTableName("IGD_SCH") + " set name=" + SB.DBString((String)this.name) + ",sqtype=" + SB.DBChar((char)this.sqType.getCharType()) + ",disc_id=" + SB.DBChar((char)Discipline.getChar(this.discID)) + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID;
        }
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    public void setName(String name) throws SBException, SQLException {
        if (this.schID > 0 && this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set name");
        }
        this.name = name;
    }

    public static void checkSchemeUnits(LinkedList<IGDUnit.Builder> units) throws InvalidFieldException {
        IGDScheme.checkSchemeUnitsBase(units);
    }

    static void checkSchemeUnitsBase(List<? extends IGDUnitBase> units) throws InvalidFieldException {
        if (units.isEmpty()) {
            return;
        }
        for (IGDUnitBase iGDUnitBase : units) {
            if (iGDUnitBase.getName().isEmpty()) {
                throw new InvalidFieldException("No name for unit with age: " + iGDUnitBase.getUage() + "-" + iGDUnitBase.getLage());
            }
            if (iGDUnitBase.getHier() == 0) {
                throw new InvalidFieldException("Hierarchy level not specified for unit: '" + iGDUnitBase.getName() + "'");
            }
            if (iGDUnitBase.getUage() > iGDUnitBase.getLage()) {
                throw new InvalidFieldException("Youngest age is greater than oldest age for unit : '" + iGDUnitBase.getName() + "'");
            }
            for (IGDUnitBase iGDUnitBase2 : units) {
                if (iGDUnitBase2 == iGDUnitBase) continue;
                if (iGDUnitBase.getName().equalsIgnoreCase(iGDUnitBase2.getName())) {
                    throw new InvalidFieldException("Duplicate unit name: " + iGDUnitBase.getName());
                }
                if (iGDUnitBase.getHier() != iGDUnitBase2.getHier()) continue;
                if (iGDUnitBase.getUage() < iGDUnitBase2.getUage() && iGDUnitBase.getLage() > iGDUnitBase2.getUage()) {
                    throw new InvalidFieldException("Unit : '" + iGDUnitBase.getName() + "' overlaps unit : '" + iGDUnitBase2.getName() + "' (check unit type).");
                }
                if (iGDUnitBase.getUage() != iGDUnitBase2.getUage() || !(iGDUnitBase.getLage() > iGDUnitBase.getUage()) || !(iGDUnitBase2.getLage() > iGDUnitBase2.getUage())) continue;
                throw new InvalidFieldException("Unit : '" + iGDUnitBase.getName() + "' overlaps unit : '" + iGDUnitBase2.getName() + "' (check unit type).");
            }
        }
    }

    public void checkSchemeSurfaces() throws SBException {
        for (Surface surface : this.surfaces) {
            if (surface.getName().isEmpty()) {
                throw new SBException("Surface name blank at age: " + surface.getAge());
            }
            this.updateSurfaceStatus(surface);
        }
    }

    public static void checkSchemeSurfaces(LinkedList<Surface.Builder> surfaces) throws InvalidFieldException {
        if (surfaces.isEmpty()) {
            return;
        }
        for (Surface.Builder surface : surfaces) {
            if (surface.getName().isEmpty()) {
                throw new InvalidFieldException("Surface name blank at age: " + surface.getAge());
            }
            for (Surface.Builder builder : surfaces) {
                if (builder == surface || !surface.getName().equalsIgnoreCase(builder.getName())) continue;
                throw new InvalidFieldException("Duplicate surface: " + surface.getName() + " " + surface.getTypeString());
            }
        }
    }

    private void updateUnitStatus(IGDUnit unit) throws SBException {
        Iterator<IGDUnit> it2 = this.units.iterator();
        unit.status = IGDUnit.NOTSTORED;
        while (it2.hasNext()) {
            IGDUnit unit2 = it2.next();
            if (unit == unit2) continue;
            if (unit.getName().equalsIgnoreCase(unit2.getName())) {
                unit.status = IGDUnit.CONFLICT;
                throw new SBException("Duplicate unit name: " + unit.getName());
            }
            if (unit.getHier() != unit2.getHier()) continue;
            if (unit.getUage() < unit2.getUage() && unit.getLage() > unit2.getUage()) {
                unit.status = IGDUnit.CONFLICT;
                throw new SBException("Unit : '" + unit.getName() + "' overlaps unit : '" + unit2.getName() + "' (check unit type). Scheme name: " + this.name);
            }
            if (unit.getUage() != unit2.getUage() || !(unit.getLage() > unit.getUage()) || !(unit2.getLage() > unit2.getUage())) continue;
            unit.status = IGDUnit.CONFLICT;
            throw new SBException("Unit : '" + unit.getName() + "' overlaps unit : '" + unit2.getName() + "' (check unit type). Scheme name: " + this.name);
        }
    }

    private void updateSurfaceStatus(Surface surface) throws SBException {
        Iterator<Surface> it2 = this.surfaces.iterator();
        surface.setStatus(NOTSTORED);
        while (it2.hasNext()) {
            Surface surface2 = it2.next();
            if (surface == surface2 || !surface.getName().equalsIgnoreCase(surface2.getName()) || surface.getType() != surface2.getType()) continue;
            surface.setStatus(CONFLICT);
            throw new SBException("Duplicate surface: " + surface.getName() + " " + surface.getTypeString());
        }
    }

    public static boolean isOverlap(List<IGDUnit.Builder> list, IGDUnit.Builder newUnit) {
        if (newUnit.getUage() < 1.0E-6 && newUnit.getLage() < 1.0E-6) {
            return false;
        }
        for (IGDUnit.Builder unit : list) {
            if (unit.getHier() != newUnit.getHier() || unit.getUage() < newUnit.getUage() && unit.getLage() <= newUnit.getUage() || unit.getLage() > newUnit.getLage() && unit.getUage() >= newUnit.getLage()) continue;
            return true;
        }
        return false;
    }

    void updateUnitStatus(IGDUnit unit, IGDScheme comp) {
        for (IGDUnit unit2 : comp.units) {
            if (!unit.getSortEntry().equals(unit2.getSortEntry())) {
                if (!unit.getName().equals(unit2.getName())) continue;
                unit.status = IGDUnit.STORED;
                if (unit.getHier() != unit2.getHier()) {
                    unit.status = IGDUnit.CONFLICT;
                }
                if (unit.getUage() > 0.0 && Math.abs(unit.getUage() - unit2.getUage()) > 0.0) {
                    unit.status = IGDUnit.CONFLICT;
                }
                if (!(unit.getLage() > 0.0) || !(Math.abs(unit.getLage() - unit2.getLage()) > 0.0)) continue;
                unit.status = IGDUnit.CONFLICT;
                continue;
            }
            unit.status = IGDUnit.STORED;
            MergeStatus m = new MergeStatus(unit.status);
            m.compareStringField("Abr", unit.getAbr() == null ? null : unit.getAbr().toUpperCase(), unit2.getAbr() == null ? null : unit2.getAbr().toUpperCase(), false);
            unit.status = m.getStatus();
        }
    }

    void deleteUnits() throws SQLException {
        if (this.schID > 0) {
            String sql = "DELETE FROM " + this.sbdb.DBTableName("IGD") + " WHERE sch_id=" + this.schID;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() throws SQLException {
        if (this.schID <= 0) {
            throw new IllegalStateException("Attempt to delete unstored scheme");
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_DICT") + " WHERE sch_id=" + this.schID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            int nHdrs;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (this.igdType == 10) {
                sql = "DELETE FROM " + this.sbdb.DBTableName("SURFACE") + " WHERE sch_id=" + this.schID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            if ((nHdrs = stmt.executeUpdate(this.sbdb.modQuery(sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_HDR") + " WHERE sch_id=" + this.schID))) > 0) {
                System.out.println("Number of header records delted with scheme: " + nHdrs);
            }
            sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_SCH") + " WHERE sch_id=" + this.schID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.status = NOTSTORED;
        this.setChanged();
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("[" + IGDInterval.getIGDName(this.igdType) + " Scheme]" + eol);
        out.write("Scheme name = " + this.name + eol);
        out.write("Scheme ID : " + this.schID + eol);
        if (this.discID != null) {
            out.write("Discipline: " + this.discID.getAdj() + eol);
        }
        out.write("Number of units : " + this.units.size() + eol);
        out.write(eol);
        Iterator<IGDUnit> it = this.units.iterator();
        while (it.hasNext()) {
            it.next().writeDEX(out, eol, this.igdType);
        }
        out.write(eol);
    }

    void writeXML(BufferedWriter out, int indent) throws IOException, SQLException, SBException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<StratigraphicScheme Name=\"" + SB.getXMLstring((String)this.name) + "\">\n");
        out.write(ind + "<SchemeType>" + IGDInterval.getIGDName(this.igdType) + "</SchemeType>\n");
        out.write(ind + "<SchemeName>" + SB.getXMLstring((String)this.name) + "</SchemeName>\n");
        out.write(ind + "<SchemeID>" + this.schID + "</SchemeID>\n");
        if (this.discID != null) {
            out.write(ind + "<Discipline>" + this.discID.getNoun() + "</Discipline>\n");
        }
        if (this.sqType != null) {
            out.write(ind + "<SequenceModel>" + this.sqType.getCharType() + "</SequenceModel>\n");
        }
        this.audit.writeXML(out, indent);
        Iterator<IGDUnit> it = this.getUnits().iterator();
        while (it.hasNext()) {
            out.write(ind + "<Unit>\n");
            it.next().writeXML(out, indent + indent, this.igdType);
            out.write(ind + "</Unit>\n");
        }
        Iterator<Surface> its = this.getSurfaces().iterator();
        while (its.hasNext()) {
            out.write(ind + "<Surface>\n");
            its.next().writeXML(out, indent + indent);
            out.write(ind + "</Surface>\n");
        }
        out.write("</StratigraphicScheme>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkInformal(UnlinkedInterval interval, IGDUnit unit, boolean updateInformal) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit intervalAudit = new Audit();
        String sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET upp_zone=" + unit.getUnitID() + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false);
        if (updateInformal) {
            sql = sql + ",upp_inf=" + SB.DBString((String)unit.getName());
        }
        sql = sql + " WHERE sch_id=" + this.schID + " AND upp_zone is null AND upp_inf=" + SB.DBString((String)interval.name);
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET low_zone=" + unit.getUnitID() + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false);
            if (updateInformal) {
                sql = sql + ",low_inf=" + SB.DBString((String)unit.getName());
            }
            sql = sql + " WHERE sch_id=" + this.schID + " AND low_zone is null AND low_inf=" + SB.DBString((String)interval.name);
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.sbdb.refreshIntervals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkInformal(UnlinkedInterval interval) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit intervalAudit = new Audit();
        String sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET upp_zone=" + interval.igdID + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID + " AND upp_zone is null AND upp_inf=" + SB.DBString((String)interval.name);
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET low_zone=" + interval.igdID + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID + " AND low_zone is null AND low_inf=" + SB.DBString((String)interval.name);
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.interpRefresh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UnlinkedInterval> getUnlinkedIntervals() throws SQLException {
        LinkedList<UnlinkedInterval> list = new LinkedList<UnlinkedInterval>();
        String sql = "SELECT upp_inf FROM " + this.sbdb.DBTableName("IGD") + " WHERE sch_id=" + this.schID + " AND upp_zone is null";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            IGDUnit unit;
            UnlinkedInterval item;
            boolean occurs;
            String infName;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                infName = rs.getString("upp_inf");
                if (infName == null || infName.length() <= 0) continue;
                occurs = false;
                for (UnlinkedInterval item2 : list) {
                    if (!item2.name.equals(infName)) continue;
                    ++item2.occs;
                    occurs = true;
                    break;
                }
                if (occurs) continue;
                item = new UnlinkedInterval();
                item.name = infName;
                item.occs = 1;
                unit = this.findUnit(infName);
                if (unit != null) {
                    item.linked = true;
                    item.igdID = unit.getUnitID();
                }
                list.add(item);
            }
            rs.close();
            sql = "SELECT low_inf FROM " + this.sbdb.DBTableName("IGD") + " WHERE sch_id=" + this.schID + " AND low_zone is null";
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                infName = rs.getString("low_inf");
                if (infName == null || infName.length() <= 0) continue;
                occurs = false;
                for (UnlinkedInterval item2 : list) {
                    if (!item2.name.equals(infName)) continue;
                    ++item2.occs;
                    occurs = true;
                    break;
                }
                if (occurs) continue;
                item = new UnlinkedInterval();
                item.name = infName;
                item.occs = 1;
                unit = this.findUnit(infName);
                if (unit != null) {
                    item.linked = true;
                    item.igdID = unit.getUnitID();
                }
                list.add(item);
            }
            rs.close();
        }
        finally {
            stmt.close();
        }
        Collections.sort(list);
        return list;
    }

    static void fixDictIGDtype(SBdb SB2) throws SQLException {
        String sql = "SELECT DISTINCT s.sch_id, s.igd_type FROM " + SB2.DBTableName("IGD_SCH") + " s, " + SB2.DBTableName("IGD_DICT") + " d WHERE d.sch_id=s.sch_id AND (d.igd_type is null OR d.igd_type=0)";
        Statement stmt = SB2.getDatabase().createStatement();
        Statement stmt2 = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int schID = rs.getInt("sch_id");
            int igdType = rs.getInt("igd_type");
            sql = "UPDATE " + SB2.DBTableName("IGD_DICT") + " SET igd_type=" + igdType + " WHERE sch_id=" + schID + " AND (igd_type is null OR igd_type=0)";
            stmt2.executeUpdate(SB2.modQuery(sql));
        }
        rs.close();
        stmt.close();
        stmt2.close();
    }

    public int getIGDType() {
        return this.igdType;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public void setLink(IGDScheme dbScheme) {
        if (this.link != null && this.link != dbScheme) {
            for (IGDUnit unit : this.units) {
                unit.link = null;
                unit.status = SbugsStatus.NOTSTORED;
            }
        }
        this.link = dbScheme;
    }

    public IGDScheme getLink() {
        return this.link;
    }

    String statusString(Color status) {
        if (status == NOTSTORED) {
            return "NOT STORED";
        }
        if (status == STORED) {
            return "STORED";
        }
        if (status == PARTSTORED) {
            return "PARTSTORED";
        }
        if (status == CONFLICT) {
            return "CONFLICT";
        }
        return " NOT SET";
    }

    public void updateStatus() throws SQLException, SBException {
        if (this.link == null) {
            this.status = NOTSTORED;
            if (this.units != null) {
                for (IGDUnit unit : this.units) {
                    unit.status = IGDUnit.NOTSTORED;
                    try {
                        this.updateUnitStatus(unit);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.surfaces != null) {
                for (Surface surface : this.surfaces) {
                    surface.setStatus(NOTSTORED);
                }
            }
            return;
        }
        this.status = STORED;
        try {
            for (IGDUnit unit : this.units) {
                this.updateUnitStatus(unit);
                unit.updateStatusLink();
                this.status = MergeStatus.merge((Color)this.status, (Color)unit.status);
            }
            for (Surface surface : this.surfaces) {
                this.updateSurfaceStatus(surface);
                if (surface.getStatus() != CONFLICT) {
                    if (surface.getLink() == null) {
                        surface.setStatus(NOTSTORED);
                    } else {
                        surface.setStatus(STORED);
                        if (!surface.getName().equals(surface.getLink().getName())) {
                            surface.setStatus(CONFLICT);
                        }
                        if (surface.getType() != surface.getLink().getType()) {
                            surface.setStatus(CONFLICT);
                        }
                        if (Math.abs(surface.getAge() - surface.getLink().getAge()) > 0.001) {
                            if (surface.getAge() > 0.001) {
                                surface.setStatus(CONFLICT);
                            } else {
                                surface.setStatus(PARTSTORED);
                            }
                        }
                    }
                }
                this.status = MergeStatus.merge((Color)this.status, (Color)surface.getStatus());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setChanged();
    }

    public IGDScheme recalibrate(SBdb db, IGDScheme chronoOld, IGDScheme chronoNew, String newSchemeName) throws SQLException, SBException {
        if (chronoOld.getIGDType() != 3 || chronoNew.getIGDType() != 3) {
            throw new IllegalArgumentException("Attempt to recalibrate scheme using non-chronostrat schemes");
        }
        SBdb ws = new SBdb();
        IGDScheme wsScheme = IGDScheme.copyToWorkspace(ws, this);
        wsScheme.name = newSchemeName;
        for (IGDUnit unit : wsScheme.units) {
            unit.setUage(chronoNew.getRecalibratedAge(chronoOld, unit.getUage()));
            unit.setLage(chronoNew.getRecalibratedAge(chronoOld, unit.getLage()));
            if (!(unit.getLage() < unit.getUage())) continue;
            unit.setLage(unit.getUage());
        }
        if (this.igdType == 10) {
            for (Surface surface : wsScheme.surfaces) {
                surface.setAge(chronoNew.getRecalibratedAge(chronoOld, surface.getAge()));
            }
        }
        IGDScheme dbScheme = IGDScheme.copyToDatabase(db, wsScheme);
        db.addIGDScheme(dbScheme);
        db.commit();
        return dbScheme;
    }

    double getRecalibratedAge(IGDScheme chronoOld, double oldAge) throws SQLException {
        double newAge = oldAge;
        if (oldAge < 1.0E-6) {
            return 0.0;
        }
        IGDUnit nearest = null;
        double unitSpan = -1.0;
        for (IGDUnit unit : chronoOld.getUnits()) {
            IGDUnit newUnit = this.findUnit(unit.getName());
            if (newUnit == null) continue;
            if (Math.abs(unit.getUage() - oldAge) < 1.0E-6) {
                return newUnit.getUage();
            }
            if (Math.abs(unit.getLage() - oldAge) < 1.0E-6) {
                return newUnit.getLage();
            }
            if (!(unit.getUage() < oldAge) || !(unit.getLage() > oldAge) || !(unitSpan < 0.0) && !(unit.getLage() - unit.getUage() < unitSpan)) continue;
            unitSpan = unit.getLage() - unit.getUage();
            nearest = unit;
        }
        if (nearest != null) {
            IGDUnit newUnit = this.findUnit(nearest.getName());
            newAge = (oldAge - nearest.getUage()) * (newUnit.getLage() - newUnit.getUage()) / (nearest.getLage() - nearest.getUage()) + newUnit.getUage();
            newAge = SB.roundToSignificantFigures((double)newAge, (int)4);
        }
        return newAge;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for scheme: " + this);
        }
        for (IGDUnit unit : this.getUnits()) {
            unit.setAnalyst(analyst);
        }
        for (Surface surface : this.getSurfaces()) {
            surface.setAnalyst(analyst);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public final boolean isSequence() {
        return this.igdType == 10;
    }

    public final boolean isBiozone() {
        return this.igdType == 4;
    }

    public class UnlinkedInterval
    implements Comparable {
        public String name;
        public int occs;
        public boolean linked;
        int igdID;

        public int compareTo(Object rhs) {
            if (rhs instanceof UnlinkedInterval) {
                return this.name.compareTo(((UnlinkedInterval)rhs).name);
            }
            return 0;
        }
    }

    public static enum SequenceType {
        DEPOSITIONAL('D'),
        GENETIC('G');

        char charType;

        private SequenceType(char charType) {
            this.charType = charType;
        }

        public char getCharType() {
            return this.charType;
        }

        static SequenceType get(char c) {
            switch (c) {
                case 'g': {
                    return GENETIC;
                }
            }
            return DEPOSITIONAL;
        }

        public static char getChar(SequenceType t) {
            if (t == null) {
                return '\u0000';
            }
            return t.getCharType();
        }
    }

    public class MatchSchemes {
        IGDScheme scheme;
        int nMatches;
        int nInformalMatches;
        int nUniqieInformal;

        public IGDScheme getScheme() {
            return this.scheme;
        }

        public int getNMatches() {
            return this.nMatches;
        }

        public int getNInformal() {
            return this.nInformalMatches;
        }

        public int getnUniqiueInformal() {
            return this.nUniqieInformal;
        }

        private MatchSchemes(IGDScheme iGDScheme2) {
            this.scheme = iGDScheme2;
            this.nMatches = 1;
        }

        private MatchSchemes(IGDScheme iGDScheme2, int unique) {
            this.scheme = iGDScheme2;
            this.nUniqieInformal = unique;
            this.nInformalMatches = 1;
        }
    }

    public static class ShadeInterval {
        private float uAge;
        private float lAge;
        Color colour;

        public ShadeInterval(float uAge, float lAge, Color colour) {
            this.uAge = uAge;
            this.lAge = lAge;
            this.colour = colour;
        }

        public float getUage() {
            return this.uAge;
        }

        public float getLage() {
            return this.lAge;
        }

        public Color getColour() {
            return this.colour;
        }
    }
}

