/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.SBException;

public class IGDSchemeXLSReader {
    private IGDSchemeXLSReader() {
    }

    public static List<IGDUnit.Builder> read(SBdb ws, File file, int igdType) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException {
        FileInputStream is = new FileInputStream(file);
        Workbook wb = WorkbookFactory.create((InputStream)is);
        ((InputStream)is).close();
        LinkedList<SchemeUnitBuilder> unitBuilders = new LinkedList<SchemeUnitBuilder>();
        IGDSchemeXLSReader.parseSheet(ws, wb.getSheetAt(0), igdType, unitBuilders);
        return SchemeUnitBuilder.getBuilders(unitBuilders);
    }

    public static void read(SBdb ws, File file, int igdType, boolean addToWs) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException {
        FileInputStream is = new FileInputStream(file);
        Workbook wb = WorkbookFactory.create((InputStream)is);
        ((InputStream)is).close();
        IGDScheme scheme = new IGDScheme(ws, igdType, wb.getSheetName(0), null, null);
        scheme.setSchID(1);
        scheme = IGDSchemeXLSReader.parseSheet(ws, wb.getSheetAt(0), igdType, scheme);
        if (scheme != null && !scheme.getUnits().isEmpty()) {
            ws.addIGDScheme(scheme);
        }
    }

    private static void parseSheet(SBdb ws, Sheet sheet, int igdType, LinkedList<SchemeUnitBuilder> unitBuilders) throws SBException, FileNotFoundException, IOException, SQLException {
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null");
            return;
        }
        String[] colNames = new String[30];
        int maxCol = 0;
        for (short cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
            Cell cell = titleRow.getCell((int)cellNum);
            if (cellNum >= colNames.length) {
                System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
            }
            if (cell == null) continue;
            colNames[cellNum] = cell.getStringCellValue();
            maxCol = cellNum;
        }
        ColType[] columns = new ColType[maxCol + 1];
        for (int i = 0; i <= maxCol; ++i) {
            try {
                columns[i] = ColType.getColumnType(colNames[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                columns[i] = null;
            }
        }
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            SchemeUnitBuilder b;
            Row row = sheet.getRow(nRow);
            if (row == null || (b = IGDSchemeXLSReader.parseIGDUnit(ws, igdType, row, columns)) == null) continue;
            unitBuilders.add(b);
        }
    }

    private static IGDScheme parseSheet(SBdb ws, Sheet sheet, int igdType, IGDScheme scheme) throws SBException, FileNotFoundException, IOException, SQLException {
        int titleRowNum = 0;
        Row titleRow = sheet.getRow(titleRowNum);
        if (titleRow == null) {
            System.out.println("column titles in row 1 are null");
            return null;
        }
        Cell topLeft = titleRow.getCell(0);
        if (topLeft != null && topLeft.getCellType() == 1 && topLeft.getStringCellValue().trim().equalsIgnoreCase("strat_column")) {
            LinkedList<SchemeUnitBuilder> unitBuilders = new LinkedList<SchemeUnitBuilder>();
            IGDSchemeXLSReader.parseSheet(ws, sheet, igdType, unitBuilders);
            String lastScheme = null;
            for (SchemeUnitBuilder builder : unitBuilders) {
                try {
                    if (lastScheme == null) {
                        lastScheme = builder.schemeName;
                        if (builder.schemeName != null && !builder.schemeName.isEmpty()) {
                            scheme.setName(builder.schemeName);
                        }
                    } else if (!lastScheme.equals(builder.schemeName)) {
                        if (!scheme.getUnits().isEmpty()) {
                            ws.addIGDScheme(scheme);
                        }
                        int schID = scheme.getID();
                        scheme = new IGDScheme(ws, igdType, builder.schemeName, null, null);
                        scheme.setSchID(++schID);
                        lastScheme = builder.schemeName;
                    }
                    scheme.addUnit(builder.builder);
                }
                catch (Exception ex) {
                    System.out.println("Failed to add unit: " + ex.toString());
                }
            }
        } else {
            titleRowNum = 2;
            titleRow = sheet.getRow(titleRowNum);
            if (titleRow == null) {
                System.out.println("column titles in row 3 are null");
                return null;
            }
            for (short cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
                Cell cell = titleRow.getCell((int)cellNum);
                if (cell == null) continue;
                String title = cell.getStringCellValue();
                if (title.equalsIgnoreCase("Group")) {
                    IGDSchemeXLSReader.parseColumns(ws, sheet, scheme, titleRowNum, cellNum, IGDIntervalZone.getHierNumber(igdType, title, true));
                    continue;
                }
                if (title.toLowerCase().startsWith("formation")) {
                    IGDSchemeXLSReader.parseColumns(ws, sheet, scheme, titleRowNum, cellNum, IGDIntervalZone.getHierNumber(igdType, "Formation", true));
                    continue;
                }
                if (title.toLowerCase().startsWith("member")) {
                    IGDSchemeXLSReader.parseColumns(ws, sheet, scheme, titleRowNum, cellNum, IGDIntervalZone.getHierNumber(igdType, "Member", true));
                    continue;
                }
                if (!title.toLowerCase().startsWith("bed")) continue;
                IGDSchemeXLSReader.parseColumns(ws, sheet, scheme, titleRowNum, cellNum, IGDIntervalZone.getHierNumber(igdType, "Bed", true));
            }
        }
        return scheme;
    }

    private static void parseColumns(SBdb ws, Sheet sheet, IGDScheme scheme, int titleRowNum, short nameColNum, int hier) {
        for (int nRow = titleRowNum + 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            String name;
            Cell nameCell;
            Row row = sheet.getRow(nRow);
            if (row == null || (nameCell = row.getCell((int)nameColNum)) == null || (name = nameCell.getStringCellValue()) == null || (name = name.trim()).isEmpty()) continue;
            IGDUnit.Builder builder = new IGDUnit.Builder(ws).hier(hier).name(name);
            double top = -1.0;
            double base = -1.0;
            block12: for (int i = 1; i < 4; i = (int)((short)(i + 1))) {
                Cell cell = row.getCell(nameColNum + i);
                if (cell == null) continue;
                block1 : switch (i) {
                    case 1: {
                        top = IGDSchemeXLSReader.getNumericCell(cell);
                        continue block12;
                    }
                    case 2: {
                        base = IGDSchemeXLSReader.getNumericCell(cell);
                        continue block12;
                    }
                    case 3: {
                        switch (cell.getCellType()) {
                            case 0: {
                                builder.abr("" + cell.getNumericCellValue());
                                break block1;
                            }
                            case 1: {
                                builder.abr(cell.getStringCellValue());
                            }
                        }
                    }
                }
            }
            if (base < 0.0) {
                base = top;
            }
            if (top < 0.0) {
                top = base;
            }
            if (top >= 0.0 && base >= 0.0) {
                builder.age(top, base);
            }
            try {
                scheme.addUnit(builder);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Failed to add unit: " + ex.toString());
            }
        }
    }

    private static Double getNumericCell(Cell cell) {
        double number = 0.0;
        switch (cell.getCellType()) {
            case 0: {
                number = cell.getNumericCellValue();
                break;
            }
            case 1: {
                String sBase = cell.getStringCellValue().trim();
                if (sBase == null || sBase.length() == 0) break;
                sBase = sBase.replace(',', '.');
                number = Double.parseDouble(sBase);
            }
        }
        return number;
    }

    private static SchemeUnitBuilder parseIGDUnit(SBdb ws, int igdType, Row row, ColType[] columns) throws SBException, SQLException {
        IGDUnit.Builder builder = new IGDUnit.Builder(ws);
        SchemeUnitBuilder sBuilder = new SchemeUnitBuilder(null, builder);
        block10: for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null || columns[cellNum] == null) continue;
            switch (columns[cellNum]) {
                case SCHEME_NAME: {
                    sBuilder.schemeName = cell.getStringCellValue();
                    continue block10;
                }
                case NAME: {
                    builder.name(cell.getStringCellValue());
                    continue block10;
                }
                case TYPE: {
                    String unitTypeString = cell.getStringCellValue();
                    int hier = IGDIntervalZone.getHierNumber(igdType, unitTypeString, true);
                    builder.hier(hier);
                    continue block10;
                }
                case U_AGE: {
                    builder.uAge(IGDSchemeXLSReader.getNumericCell(cell));
                    continue block10;
                }
                case L_AGE: {
                    builder.lAge(IGDSchemeXLSReader.getNumericCell(cell));
                    continue block10;
                }
                case ABR: {
                    try {
                        builder.abr(cell.getStringCellValue());
                        continue block10;
                    }
                    catch (Exception ex) {
                        builder.abr("" + cell.getNumericCellValue());
                    }
                }
            }
        }
        if (builder.getName().isEmpty()) {
            System.out.println("Didn't build: '" + builder.getName());
            return null;
        }
        return sBuilder;
    }

    private static enum ColType {
        SCHEME_NAME(new String[]{"STRAT_COLUMN"}),
        NAME(new String[]{"NAME", "UNIT_NAME"}),
        TYPE(new String[]{"TYPE", "UNIT TYPE", "HIER", "STRAT_UNIT_KIND"}),
        U_AGE(new String[]{"U_AGE", "TOP", "YOUNGEST", "AGE_AT_TOP"}),
        L_AGE(new String[]{"L_AGE", "BASE", "OLDEST", "AGE_AT_BASE"}),
        ABR(new String[]{"ABBREV", "ABR", "LOCAL_NAME"});

        private final String[] titles;

        private ColType(String[] titles) {
            this.titles = titles;
        }

        static ColType getColumnType(String title) {
            title = title.trim().toUpperCase();
            for (ColType col : ColType.values()) {
                for (int i = 0; i < col.titles.length; ++i) {
                    if (!title.equals(col.titles[i])) continue;
                    return col;
                }
            }
            throw new IllegalArgumentException("Unrecognised column title: " + title);
        }
    }

    private static class SchemeUnitBuilder {
        String schemeName;
        IGDUnit.Builder builder;

        SchemeUnitBuilder(String s, IGDUnit.Builder b) {
            this.schemeName = s;
            this.builder = b;
        }

        public static List<IGDUnit.Builder> getBuilders(List<SchemeUnitBuilder> list) {
            LinkedList<IGDUnit.Builder> unitBuilders = new LinkedList<IGDUnit.Builder>();
            for (SchemeUnitBuilder s : list) {
                unitBuilders.add(s.builder);
            }
            return unitBuilders;
        }
    }
}

