/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import model2.Audit;
import model2.IGDIntervalZone;
import model2.IGDUnitBase;
import model2.SBdb;
import model2.Userdef;
import org.jdom.Element;
import util.AgeFormat;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class IGDUnit
implements SbugsStatus,
SortEntry,
IGDUnitBase,
Comparable {
    private final SBdb sbdb;
    private final int schID;
    private final int unitID;
    private int hier;
    private String name;
    private String abr;
    private double u_age;
    private double l_age;
    private Color colour;
    IGDUnit link;
    private Audit audit;
    Color status;
    static final double AGE_PRECISION = 1000000.0;
    private int nOccs;

    public static IGDUnit convert(Builder builder, int unitID, int schID, int igdType, Date created, Userdef creator, Statement stmt) throws SQLException {
        builder.status = IGDUnit.NOTSTORED;
        IGDUnit unit = builder.build(unitID, schID);
        if (creator != null) {
            unit.audit.creator = creator.getUsrID();
        }
        unit.audit.created = created;
        unit.storeDB(igdType, stmt);
        return unit;
    }

    public int getSchID() {
        return this.schID;
    }

    public int getUnitID() {
        return this.unitID;
    }

    @Override
    public int getHier() {
        return this.hier;
    }

    public String getAbr() {
        return this.abr;
    }

    public IGDUnit getLink() {
        return this.link;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getUage() {
        return this.u_age;
    }

    public void setUage(double uAge) throws SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Cannot assign to IGDUnit in database");
        }
        this.u_age = uAge;
    }

    @Override
    public double getLage() {
        return this.l_age;
    }

    public void setLage(double lAge) throws SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Cannot assign to IGDUnit in database");
        }
        this.l_age = lAge;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IGDUnit(SBdb sbdb, int igdID) throws SQLException, SBException {
        block6: {
            this.name = "";
            this.abr = "";
            this.colour = Color.WHITE;
            this.link = null;
            this.audit = new Audit();
            this.status = UNKNOWN;
            this.nOccs = -1;
            this.sbdb = sbdb;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            String sql = "SELECT sch_id,hier,name,abr,u_age,l_age,red,green,blue," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("IGD_DICT") + " WHERE igd_id=" + igdID;
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    this.unitID = igdID;
                    this.schID = rs.getInt("sch_id");
                    this.hier = rs.getInt("hier");
                    this.name = rs.getString("name");
                    this.abr = rs.getString("abr");
                    if (this.abr == null) {
                        this.abr = "";
                    }
                    this.u_age = rs.getDouble("u_age");
                    this.l_age = rs.getDouble("l_age");
                    this.colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
                    if (this.colour.equals(Color.BLACK)) {
                        this.colour = Color.WHITE;
                    }
                    this.audit = new Audit(rs);
                    this.status = STORED;
                    break block6;
                }
                throw new SBException("No unit found with ID: " + igdID);
            }
            finally {
                stmt.close();
            }
        }
    }

    private static IGDUnit load(SBdb sbdb, int unitID, IGDUnit unit) throws SQLException, SBException {
        if (unit != null && unit.getUnitID() != unitID) {
            throw new IllegalArgumentException("Attempt to refresh unit with incorrect ID");
        }
        IGDUnit temp = new IGDUnit(sbdb, unitID);
        if (unit != null) {
            unit.hier = temp.hier;
            unit.name = temp.name;
            unit.abr = temp.abr;
            unit.u_age = temp.u_age;
            unit.l_age = temp.l_age;
            unit.audit = new Audit(temp.audit);
            unit.status = STORED;
            unit.colour = temp.colour;
        } else {
            unit = temp;
        }
        return unit;
    }

    static IGDUnit refresh(SBdb sbdb, int schID, List<IGDUnit> units, Statement stmt) throws SQLException, SBException {
        String sql = "SELECT igd_id,updated FROM " + sbdb.DBTableName("IGD_DICT") + " WHERE sch_id=" + schID;
        sql = sbdb.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        IGDUnit notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("igd_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDUnit o : units) {
                if (o.getUnitID() != key) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                IGDUnit.load(sbdb, key, o);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = IGDUnit.load(sbdb, key, null);
            IGDUnit.insert(notifier, units);
        }
        if (keys.size() < units.size()) {
            Iterator<IGDUnit> it = units.iterator();
            while (it.hasNext()) {
                IGDUnit o = it.next();
                if (keys.contains(o.getUnitID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    static synchronized void insert(IGDUnit unit, List<IGDUnit> units) {
        boolean inserted = false;
        int i = 0;
        for (IGDUnit u : units) {
            if (u.getSortEntry().compareTo(unit.getSortEntry()) > 0) {
                units.add(i, unit);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            units.add(unit);
        }
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public Color getStatus() {
        if (this.status == UNKNOWN && this.getSchID() != 0) {
            this.status = this.getUnitID() != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.getName();
    }

    public String toString(boolean useAge) {
        return this.toString(useAge, AgeFormat.MA);
    }

    public String toString(boolean useAge, AgeFormat ageFormat) {
        if (useAge) {
            return this.getName() + " (" + ageFormat.toAgeString(this.u_age, 2) + " - " + ageFormat.toAgeString(this.l_age, 2) + ")";
        }
        return this.toString();
    }

    public List<String> getOccs() throws SQLException, SBException {
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            throw new SBException("Attempt to get occurrences when connection is: " + this.sbdb);
        }
        String sql = "SELECT DISTINCT v.well_id,w.well_name,v.well_code FROM " + this.sbdb.DBTableName("IGD") + " i," + this.sbdb.DBTableName("WELL_IDENT") + " v," + this.sbdb.DBTableName("WELLS") + " w" + " WHERE (i.upp_zone=" + this.unitID + " OR i.low_zone=" + this.unitID + ")" + " AND i.well_id=v.well_id AND v.well_code=w.well_code ORDER BY well_name";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        ArrayList<String> occs = new ArrayList<String>();
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            occs.add(rs.getString("well_name") + "(" + rs.getString("well_code") + ")");
        }
        stmt.close();
        return occs;
    }

    public int getNoccs(boolean refresh) throws SQLException {
        if (this.nOccs < 0 || refresh) {
            this.nOccs = 0;
            if (this.sbdb != null && this.sbdb.isConnected()) {
                String sql;
                Statement stmt = this.sbdb.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT count(top_id) AS nOccs FROM " + this.sbdb.DBTableName("IGD") + " WHERE upp_zone=" + this.unitID + " OR low_zone=" + this.unitID));
                if (rs.next()) {
                    this.nOccs = rs.getInt("nOccs");
                }
                stmt.close();
            }
        }
        return this.nOccs;
    }

    int getLageInt() {
        return (int)(this.l_age * 1000000.0);
    }

    int getUageInt() {
        return (int)(this.u_age * 1000000.0);
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Builder builder) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("igd_dict") + " set name=" + SB.DBString((String)builder.name) + ",abr='" + builder.abr + "',u_age=" + builder.u_age + ",l_age=" + builder.l_age + ",hier=" + builder.hier + ",red=" + builder.colour.getRed() + ",green=" + builder.colour.getGreen() + ",blue=" + builder.colour.getBlue() + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE igd_id=" + this.unitID;
        String sqlLinkRefreshUpp = null;
        String sqlLinkRefreshLow = null;
        if (!this.name.equals(builder.name)) {
            sqlLinkRefreshUpp = "UPDATE " + this.sbdb.DBTableName("igd") + " set upp_inf=" + SB.DBString((String)builder.name) + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID + " AND upp_zone=" + this.unitID + " AND upp_inf=" + SB.DBString((String)this.name);
            sqlLinkRefreshLow = "UPDATE " + this.sbdb.DBTableName("igd") + " set low_inf=" + SB.DBString((String)builder.name) + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID + " AND low_zone=" + this.unitID + " AND low_inf=" + SB.DBString((String)this.name);
        }
        try {
            int i = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (i != 1) {
                throw new SBException("Could not update unit: " + this);
            }
            if (sqlLinkRefreshUpp != null) {
                stmt.executeUpdate(this.sbdb.modQuery(sqlLinkRefreshUpp));
            }
            if (sqlLinkRefreshLow != null) {
                stmt.executeUpdate(this.sbdb.modQuery(sqlLinkRefreshLow));
            }
        }
        finally {
            stmt.close();
        }
        this.hier = builder.hier;
        this.name = builder.name;
        this.abr = builder.abr;
        this.l_age = builder.l_age;
        this.u_age = builder.u_age;
        this.colour = builder.colour;
        this.status = STORED;
    }

    public void copyLink() {
        if (this.link == null || this.status != CONFLICT) {
            return;
        }
        this.name = this.link.getName();
        this.abr = this.link.getAbr();
        this.u_age = this.link.getUage();
        this.l_age = this.link.getLage();
        this.status = STORED;
    }

    public void store(int igdType) throws SQLException {
        if (this.status == STORED) {
            return;
        }
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store workspace IGDUnit");
        }
        if (this.status == NOTSTORED) {
            this.storeDB(igdType, null);
        } else {
            this.updateDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDB() throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit temp = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("igd_dict") + " set name=" + SB.DBString((String)this.getName()) + ",abr='" + this.getAbr() + "',u_age=" + this.getUage() + ",l_age=" + this.getLage() + ",hier=" + this.getHier() + ",red=" + this.colour.getRed() + ",green=" + this.colour.getGreen() + ",blue=" + this.colour.getBlue() + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID + " AND igd_id=" + this.unitID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.audit = temp;
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDB(int igdType, Statement statement) throws SQLException {
        Statement stmt = statement == null ? this.sbdb.getDatabase().createStatement() : statement;
        String sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_DICT") + " (igd_id,sch_id,igd_type,hier,name,abr,u_age,l_age,red,green,blue," + Audit.sqlFieldString() + ") VALUES (" + this.unitID + "," + this.schID + "," + igdType + "," + this.hier + "," + SB.DBString((String)this.name) + "," + SB.DBString((String)this.abr) + "," + this.u_age + "," + this.l_age + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(Statement stmt) throws SQLException {
        int updated;
        Statement statement = stmt == null ? this.sbdb.getDatabase().createStatement() : stmt;
        try {
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET upp_zone=NULL WHERE upp_zone=" + this.unitID;
            updated = statement.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET low_zone=NULL WHERE low_zone=" + this.unitID;
            updated += statement.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_DICT") + " WHERE igd_id=" + this.unitID;
            statement.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        if (updated > 0) {
            System.out.println("WARNING: IGD table updated during delete unit '" + this.getName() + "'");
        }
        this.status = NOTSTORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(int igdType, int schID) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_DICT") + " (igd_id,sch_id,igd_type,hier,name,abr,u_age,l_age,red,green,blue," + Audit.sqlFieldString() + ") VALUES (" + this.unitID + "," + schID + "," + igdType + "," + this.hier + "," + SB.DBString((String)this.name) + "," + SB.DBString((String)this.abr) + "," + this.u_age + "," + this.l_age + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.status = STORED;
    }

    void writeDEX(FileWriter out, String eol, int igdType) throws IOException {
        out.write("Unit = " + this.getName() + eol);
        if (this.getAbr() != null) {
            out.write("  Abbreviation : " + this.getAbr() + eol);
        }
        out.write("  Type = " + IGDIntervalZone.getHierName(igdType, this.getHier(), true) + eol);
        out.write("  Youngest : " + this.getUage() + eol);
        out.write("  Oldest : " + this.getLage() + eol);
        out.write("  Dictionary ID : " + this.unitID + eol);
        if (this.colour != Color.WHITE) {
            out.write("  Colour : " + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + eol);
        }
    }

    void writeXML(BufferedWriter out, int indent, int igdType) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<UnitName>" + SB.getXMLstring((String)this.getName()) + "</UnitName>\n");
        if (this.getAbr() != null) {
            out.write(ind + "<Abbreviation>" + SB.getXMLstring((String)this.getAbr()) + "</Abbreviation>\n");
        }
        out.write(ind + "<Type>" + IGDIntervalZone.getHierName(igdType, this.getHier(), true) + "</Type>\n");
        out.write(ind + "<Youngest>" + this.getUage() + "</Youngest>\n");
        out.write(ind + "<Oldest>" + this.getLage() + "</Oldest>\n");
        out.write(ind + "<DictionaryID>" + this.unitID + "</DictionaryID>\n");
        if (this.colour != Color.WHITE) {
            SB.writeXMLColour((Color)this.colour, (BufferedWriter)out, (String)ind);
        }
        this.audit.writeXML(out, indent);
    }

    IGDUnit(SBdb ws, int schID, int igdType, Element xml) throws ParseException, SQLException, SBException {
        Element el;
        this.name = "";
        this.abr = "";
        this.colour = Color.WHITE;
        this.link = null;
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.nOccs = -1;
        this.schID = schID;
        this.sbdb = ws;
        String strg = xml.getChildTextNormalize("UnitName");
        if (strg != null) {
            this.name = strg;
        }
        if ((strg = xml.getChildTextNormalize("Abbreviation")) != null) {
            this.abr = strg;
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            this.hier = IGDIntervalZone.getHierNumber(igdType, strg, true);
        }
        if ((strg = xml.getChildTextNormalize("DictionaryID")) == null) {
            throw new SBException("No unitID found for unit: " + this.name);
        }
        this.unitID = Integer.parseInt(strg);
        strg = xml.getChildTextNormalize("Youngest");
        if (strg != null) {
            this.u_age = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("Oldest")) != null) {
            this.l_age = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("YoungestWest")) != null) {
            double u_ageW;
            double u_ageE = u_ageW = Double.parseDouble(strg);
            strg = xml.getChildTextNormalize("YoungestEest");
            if (strg != null) {
                u_ageE = Double.parseDouble(strg);
            }
            this.u_age = Math.min(u_ageW, u_ageE);
        }
        if ((strg = xml.getChildTextNormalize("OldestWest")) != null) {
            double l_ageW;
            double l_ageE = l_ageW = Double.parseDouble(strg);
            strg = xml.getChildTextNormalize("OldestEest");
            if (strg != null) {
                l_ageE = Double.parseDouble(strg);
            }
            this.l_age = Math.max(l_ageW, l_ageE);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for IGDUnit: " + this);
        }
        el = xml.getChild("Colour");
        if (el != null) {
            this.colour = SB.parseColour((Element)el);
        }
        this.status = NOTSTORED;
    }

    public Color getColour() {
        return this.colour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColour(Color colour) throws SQLException {
        if (colour.equals(this.colour)) {
            return;
        }
        if (this.sbdb.isConnected()) {
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD_DICT") + " SET red=" + colour.getRed() + ", green=" + colour.getGreen() + ", blue=" + colour.getBlue() + " WHERE igd_id=" + this.unitID;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                stmt.executeUpdate(sql);
            }
            finally {
                stmt.close();
            }
        }
        this.colour = colour;
    }

    public void setLink(IGDUnit linkUnit) {
        this.link = linkUnit;
        this.updateStatusLink();
    }

    public void updateStatusLink() {
        if (this.link != null) {
            this.status = STORED;
            if (!this.name.toUpperCase().equals(this.link.name.toUpperCase())) {
                this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
            } else if (Math.abs(this.u_age - this.link.u_age) > 0.001) {
                this.status = this.u_age > 0.001 ? MergeStatus.merge((Color)this.status, (Color)CONFLICT) : MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
            } else if (Math.abs(this.l_age - this.link.l_age) > 0.001) {
                this.status = this.l_age > 0.001 ? MergeStatus.merge((Color)this.status, (Color)CONFLICT) : MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
            } else if (!(this.abr == null || this.abr.isEmpty() || this.link.abr == null || this.link.abr.isEmpty() || this.abr.equals(this.link.abr))) {
                this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
            } else if (this.abr != null && this.abr.isEmpty() && this.link.abr != null && !this.link.abr.isEmpty()) {
                this.status = MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
            }
        } else {
            this.status = NOTSTORED;
        }
    }

    public void setLink(IGDUnit linkUnit, boolean updateStatus) {
        this.link = linkUnit;
        if (updateStatus && this.link != null) {
            this.status = STORED;
        }
    }

    @Override
    public String getSortEntry() {
        return IGDUnit.getSortEntry(this.u_age, this.l_age, this.hier, this.name);
    }

    private static String getSortEntry(double u_age, double l_age, int hier, String name) {
        long uAgeInt = Math.round(u_age * 1000000.0);
        String uAge = "" + uAgeInt;
        while (uAge.length() < 10) {
            uAge = '0' + uAge;
        }
        long lAgeInt = Math.round(l_age * 1000000.0);
        String lAge = "" + lAgeInt;
        while (lAge.length() < 10) {
            lAge = '0' + lAge;
        }
        String entry = uAge + '-' + hier + '-' + lAge + '-' + name.toUpperCase();
        return entry;
    }

    public void setNoccs(int i) {
        this.nOccs = i;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return true;
        }
        IGDUnit unit = (IGDUnit)e;
        return this.name.toUpperCase().equals(unit.getName().toUpperCase());
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for scheme unit: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAllLstrat(SBdb db, DefaultComboBoxModel comboBoxModelUnits) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        try {
            String sql = "SELECT DISTINCT name FROM " + db.DBTableName("IGD_DICT") + " WHERE igd_type=" + 2 + " ORDER BY name";
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                comboBoxModelUnits.addElement(rs.getString("name"));
            }
        }
        finally {
            stmt.close();
        }
    }

    private IGDUnit(Builder builder, int ID, int schID) {
        this.name = "";
        this.abr = "";
        this.colour = Color.WHITE;
        this.link = null;
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.nOccs = -1;
        this.sbdb = builder.sbdb;
        this.unitID = ID;
        this.schID = schID;
        this.hier = builder.hier;
        this.name = builder.name;
        this.abr = builder.abr;
        this.l_age = builder.l_age;
        this.u_age = builder.u_age;
        this.colour = builder.colour;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    public int compareTo(Object o) {
        if (o instanceof IGDUnit) {
            IGDUnit comp = (IGDUnit)o;
            return this.getSortEntry().compareTo(comp.getSortEntry());
        }
        return -1;
    }

    public static class Builder
    implements IGDUnitBase {
        private final SBdb sbdb;
        private int hier;
        private String name = "";
        private String abr = "";
        private double u_age;
        private double l_age;
        private Color colour = Color.WHITE;
        private Audit audit = new Audit();
        private Color status = SbugsStatus.UNKNOWN;
        private int nOccs;
        private IGDUnit original;

        public Builder(SBdb sbdb) {
            if (sbdb == null) {
                throw new IllegalArgumentException("Illegal argument to IGDUnit.Builder: sbdb must not be null");
            }
            this.sbdb = sbdb;
        }

        public Builder hier(int hier) {
            if (hier > 0) {
                this.hier = hier;
            }
            return this;
        }

        public Builder colour(Color colour) {
            if (colour != null && !colour.equals(Color.BLACK)) {
                this.colour = colour;
            }
            return this;
        }

        public Builder name(String name) {
            if (name != null) {
                if (name.length() > 80) {
                    name = name.substring(0, 80);
                }
                this.name = name.trim().replaceAll("\\s+", " ");
            } else {
                this.name = "";
            }
            return this;
        }

        public Builder abr(String abr) {
            if (abr != null) {
                if (abr.length() > 80) {
                    abr = abr.substring(0, 80);
                }
                this.abr = abr.trim().replaceAll("\\s+", " ");
            } else {
                this.abr = "";
            }
            return this;
        }

        public Builder age(double u_age, double l_age) {
            this.uAge(u_age);
            this.lAge(l_age);
            return this;
        }

        public Builder uAge(double u_age) {
            if (u_age >= 0.0) {
                this.u_age = u_age;
            }
            return this;
        }

        public Builder lAge(double l_age) {
            if (l_age >= 0.0) {
                this.l_age = l_age;
            }
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        Builder status(Color status) {
            if (status != null) {
                this.status = status;
            }
            return this;
        }

        private void validateFields() {
            if (this.name.isEmpty()) {
                throw new IllegalStateException("Attempt to build IGD Unit with empty name");
            }
            if (this.hier < 1) {
                throw new IllegalStateException("Attempt to build IGD Unit '" + this.name + "' with illegal hierarchy: " + this.hier);
            }
            if (this.u_age > this.l_age) {
                throw new IllegalStateException("Attempt to build IGD Unit '" + this.name + "' with upper age greater than lower age");
            }
        }

        IGDUnit build(int ID, int schID) {
            if (ID <= 0) {
                throw new IllegalArgumentException("Cannot build IGDUnit with ID " + ID);
            }
            if (schID <= 0) {
                throw new IllegalArgumentException("Cannot build IGDUnit with schID " + ID);
            }
            try {
                this.validateFields();
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage() + " (scheme ID: " + schID + ")");
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                System.out.println("WARNING: building IGDUnit with unknown status...");
            }
            return new IGDUnit(this, ID, schID);
        }

        IGDUnit store(int igdType, int schID) throws SQLException, SBException {
            IGDUnit unit;
            if (!this.sbdb.isConnected()) {
                throw new IllegalStateException("Attempt to store IGDUnit in workspace");
            }
            if (this.original != null) {
                this.validateFields();
                if (!this.name.equals(this.original.name) || !this.abr.equals(this.original.abr) || Math.abs(this.u_age - this.original.u_age) > 0.001 || Math.abs(this.l_age - this.original.l_age) > 0.001 || !this.colour.equals(this.original.colour) || this.hier != this.original.hier) {
                    this.original.update(this);
                }
                unit = this.original;
            } else {
                this.status = SbugsStatus.NOTSTORED;
                int ID = this.sbdb.nextControl("IGD_DICT", "IGD_ID");
                unit = this.build(ID, schID);
                unit.store(igdType, schID);
            }
            return unit;
        }

        public static Builder copyOf(IGDUnit unit, SBdb sbdb) throws SQLException, SBException {
            Builder builder = new Builder(sbdb);
            builder.hier(unit.hier).name(unit.name).abr(unit.abr).age(unit.u_age, unit.l_age).colour(unit.colour).audit(new Audit(unit.audit));
            builder.status = SbugsStatus.STORED;
            if (builder.sbdb == unit.sbdb) {
                builder.original = unit;
            } else if (!unit.sbdb.isConnected() && builder.sbdb.isConnected()) {
                builder.audit(new Audit(builder.sbdb, unit.sbdb, unit.audit));
            }
            return builder;
        }

        public int getOriginalID() {
            if (this.original != null) {
                return this.original.getUnitID();
            }
            return 0;
        }

        public void setNOccs(int nOccs) {
            this.nOccs = nOccs;
        }

        @Override
        public String getSortEntry() {
            return IGDUnit.getSortEntry(this.u_age, this.l_age, this.hier, this.name);
        }

        @Override
        public int getHier() {
            return this.hier;
        }

        public Color getColour() {
            return this.colour;
        }

        @Override
        public double getUage() {
            return this.u_age;
        }

        @Override
        public double getLage() {
            return this.l_age;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getAbr() {
            return this.abr;
        }

        public int getNOccs() {
            return this.nOccs;
        }

        SBdb getModel() {
            return this.sbdb;
        }

        Audit getAudit() {
            return this.audit;
        }
    }
}

