/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model2.Biocom;
import model2.Discipline;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.Surface;
import model2.Well;
import model2.WellEvent;
import model2.WsWell;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class IGDXLSReader {
    List nonInserts = new LinkedList();
    List dataTypes;
    SBdb ws;

    public IGDXLSReader(SBdb ws, File file, List dataTypes) throws SBException, SQLException, IOException, InvalidFormatException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        WsWell well = new WsWell(ws, file.getPath());
        ws.getProject(0).addWell(well);
        FileInputStream is = new FileInputStream(file);
        Workbook wb = WorkbookFactory.create((InputStream)is);
        ((InputStream)is).close();
        String exceptionMessage = "";
        for (int j = 0; j < wb.getNumberOfSheets(); ++j) {
            Sheet sheet = wb.getSheetAt(j);
            System.out.println("processing sheet: " + wb.getSheetName(j) + "\n");
            try {
                this.parseSheet(well, wb.getSheetName(j), sheet);
                continue;
            }
            catch (RuntimeException e) {
                if (!exceptionMessage.isEmpty()) {
                    exceptionMessage = exceptionMessage + "\n";
                }
                exceptionMessage = exceptionMessage + "Error reading sheet '" + wb.getSheetName(j) + "': " + e.getMessage();
                e.printStackTrace();
                System.out.println("Continuing after sheet error.\n\n");
            }
        }
        well.updateStatus();
        if (!exceptionMessage.isEmpty()) {
            throw new SBException(exceptionMessage);
        }
    }

    private void parseSheet(WsWell well, String sheetName, Sheet sheet) throws SBException, FileNotFoundException, IOException, SQLException {
        String[] columns = new String[20];
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null for sheet: " + sheetName);
            return;
        }
        for (short cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
            Cell cell = titleRow.getCell((int)cellNum);
            if (cellNum >= columns.length) {
                System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
            }
            if (cell == null) {
                System.out.println("Can't get cell for cellNum: " + cellNum);
                continue;
            }
            columns[cellNum] = cell.getStringCellValue();
        }
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            if (sheetName.equalsIgnoreCase("Age") || sheetName.equalsIgnoreCase("Chronostratigraphy")) {
                this.parseZone(3, 7, well, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase("Biozone")) {
                this.parseZone(4, 2, well, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase("Group")) {
                this.parseZone(2, 1, well, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase("Formation")) {
                this.parseZone(2, 2, well, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase("Member")) {
                this.parseZone(2, 3, well, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase("Sequence")) {
                this.parseSQPick(well, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase("Paly Comments")) {
                this.parseBiocom(Discipline.PALY, well, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase("Micro Comments")) {
                this.parseBiocom(Discipline.MICRO, well, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase("Nanno Comments")) {
                this.parseBiocom(Discipline.MICRO, well, row, columns);
                continue;
            }
            if (sheetName.indexOf("Events") >= 0) {
                this.parseWellEvents(sheetName, well, row, columns);
                continue;
            }
            System.out.println("Cannot parse row in sheet called: " + sheetName);
        }
    }

    void parseZone(int igdType, int hier, Well well, Row row, String[] columns) throws SBException, SQLException {
        Sample topSample = null;
        Sample baseSample = null;
        int topBnd = -1;
        int baseBnd = -1;
        String uppInf = "";
        String lowInf = "";
        boolean qUzone = false;
        boolean qLzone = false;
        block8: for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null || columns[cellNum] == null) continue;
            XLSColumn type = XLSColumn.getColumnType(columns[cellNum]);
            switch (type) {
                case TOPDEPTH: {
                    topSample = this.parseSample(well, cell, "LOG", true, columns[cellNum].contains("ft") ? (char)'F' : 'M');
                    continue block8;
                }
                case BASEDEPTH: {
                    baseSample = this.parseSample(well, cell, "LOG", true, columns[cellNum].contains("ft") ? (char)'F' : 'M');
                    continue block8;
                }
                case TOPBND: {
                    topBnd = this.parseBnd(cell.getStringCellValue());
                    continue block8;
                }
                case BASEBND: {
                    baseBnd = this.parseBnd(cell.getStringCellValue());
                    continue block8;
                }
                case LEGEND: {
                    String text = cell.getStringCellValue();
                    if (text.indexOf(" - ") > 0) {
                        uppInf = text.substring(0, text.indexOf(" - ")).trim();
                        lowInf = text.substring(text.indexOf(" - ") + 3).trim();
                    } else {
                        uppInf = text;
                    }
                    if (uppInf.startsWith("?")) {
                        qUzone = true;
                        uppInf = uppInf.substring(1).trim();
                    }
                    if (!lowInf.startsWith("?")) continue block8;
                    qLzone = true;
                    lowInf = lowInf.substring(1).trim();
                    continue block8;
                }
                case HIER: {
                    String htext = cell.getStringCellValue();
                    int h = IGDIntervalZone.getHierNumber(igdType, htext, true);
                    if (h <= 0) continue block8;
                    hier = h;
                }
            }
        }
        IGDScheme scheme = this.ws.getIGDScheme("Unassigned " + IGDInterval.getIGDName(igdType), igdType);
        if (scheme == null) {
            scheme = this.ws.addIGDScheme(igdType, "Unassigned " + IGDInterval.getIGDName(igdType));
        }
        if (topSample == null || baseSample == null || topBnd == -1 || baseBnd == -1) {
            this.nonInserts.add(uppInf);
            System.out.println("Cannot insert zone: " + uppInf);
        } else {
            IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.ws, igdType, topSample, baseSample, hier, scheme.getSchID()).topBnd(topBnd).baseBnd(baseBnd);
            builder.uppInf(uppInf).lowInf(lowInf).qUzone(qUzone).qLzone(qLzone);
            well.getAddInterp(this.ws.getInterp(0)).getIGDList(igdType).add(builder.build());
            this.addDataType(IGDInterval.igdType2dType(igdType));
        }
    }

    void parseSQPick(Well well, Row row, String[] columns) throws SBException, SQLException {
        Surface surface;
        Sample sample = null;
        int bnd = -1;
        String name = "";
        boolean qUzone = false;
        block9: for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null) continue;
            XLSColumn type = XLSColumn.getColumnType(columns[cellNum]);
            switch (type) {
                case TOPDEPTH: {
                    sample = this.parseSample(well, cell, "LOG", true, columns[cellNum].contains("ft") ? (char)'F' : 'M');
                    continue block9;
                }
                case LEGEND: {
                    String text = cell.getStringCellValue();
                    name = text.indexOf(" - ") > 0 ? text.substring(0, text.indexOf(" - ")).trim() : text;
                    if (!name.startsWith("?")) continue block9;
                    qUzone = true;
                    name = name.substring(1).trim();
                    continue block9;
                }
                case TOPBND: {
                    bnd = this.parseBnd(cell.getStringCellValue());
                }
            }
        }
        IGDScheme scheme = this.ws.getIGDScheme("Unassigned " + IGDInterval.getIGDName(10), 10);
        if (scheme == null) {
            scheme = this.ws.addIGDScheme(10, "Unassigned " + IGDInterval.getIGDName(10));
        }
        if ((surface = scheme.getSurface(name)) == null) {
            try {
                surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(name).type(Surface.SurfaceType.parseType(name, Surface.SurfaceType.SB)));
            }
            catch (InvalidFieldException e) {
                e.printStackTrace();
            }
        }
        if (sample == null) {
            this.nonInserts.add(name);
            System.out.println("Cannot insert sequence pick: " + name);
        } else {
            try {
                well.getAddInterp(this.ws.getInterp(0)).addSQPick(well, sample, surface, name, qUzone, IGDIntervalZone.getBoundary(bnd));
                this.addDataType(14);
            }
            catch (InvalidFieldException ex) {
                System.out.println("Exception inserting sequence pick: " + ex.toString());
                this.nonInserts.add(name);
            }
        }
    }

    private void parseBiocom(Discipline discID, Well well, Row row, String[] columns) throws SQLException, SBException, FileNotFoundException, IOException {
        Sample topSample = null;
        Cell sampleCell = null;
        String sampleType = "CU";
        String text = null;
        block5: for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null) continue;
            XLSColumn col = XLSColumn.getColumnType(columns[cellNum]);
            switch (col) {
                case TYPE: {
                    sampleType = cell.getStringCellValue();
                    continue block5;
                }
                case DEPTH: {
                    sampleCell = cell;
                    if (sampleCell == null) continue block5;
                    topSample = this.parseSample(well, sampleCell, sampleType, false, columns[cellNum].contains("ft") ? (char)'F' : 'M');
                    continue block5;
                }
                case LEGEND: {
                    text = cell.getStringCellValue();
                }
            }
        }
        if (topSample == null) {
            this.nonInserts.add(text);
        } else {
            int userID = this.ws.getUserID();
            if (userID == 0) {
                userID = this.ws.getAddUserID("ANON");
            }
            Biocom biocom = new Biocom.Builder(this.ws, discID, userID, topSample, text).build();
            well.getAddInterp(this.ws.getInterp(0)).insertBiocom(biocom);
            this.addDataType(SBdb.did2comType(discID.getChar()));
        }
    }

    void parseWellEvents(String sheetName, Well well, Row row, String[] columns) throws SBException, SQLException {
        Sample sample = null;
        String name = "";
        String eventType = "";
        String disc = sheetName.substring(0, sheetName.indexOf("Events")).trim();
        Discipline.getDisc(disc);
        block5: for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null) continue;
            XLSColumn type = XLSColumn.getColumnType(columns[cellNum]);
            switch (type) {
                case DEPTH: {
                    sample = this.parseSample(well, cell, "CU", true, columns[cellNum].contains("ft") ? (char)'F' : 'M');
                    continue block5;
                }
                case TYPE: {
                    eventType = cell.getStringCellValue();
                    continue block5;
                }
                case LEGEND: {
                    String text;
                    name = text = cell.getStringCellValue();
                }
            }
        }
        if (sample == null) {
            this.nonInserts.add(name);
            System.out.println("Cannot insert sequence wellEvent: " + name);
        } else {
            System.out.println("Parsing event at sample: " + sample.toString() + ", Name: " + name);
            SBEvent sbEvent = this.ws.getSBEvent(name);
            if (sbEvent == null) {
                sbEvent = this.ws.addSBEvent(new SBEvent.Builder().name(name).isGenerate(true));
            }
            WellEvent.Builder eventBuilder = new WellEvent.Builder().sample(sample).event(sbEvent).type(SBEvent.EventType.getType(eventType));
            well.getAddInterp(this.ws.getInterp(0)).insertEvent(eventBuilder.build(this.ws));
            this.addDataType(16);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sample parseSample(Well well, Cell cell, String type, boolean useAnyType, char units) throws SBException, SQLException {
        Sample sample;
        String text;
        if (cell.getCellType() == 1) {
            Pattern p;
            Matcher m;
            text = cell.getStringCellValue();
            if (text == null) return null;
            if (!(text = text.trim()).matches("[0-9.]") && (m = (p = Pattern.compile("[a-zA-Z]+")).matcher(text)).find()) {
                String sType = m.group();
                Sample.SampleType sampleType = Sample.SampleType.parseType(sType);
                type = sampleType.toString();
                text = text.substring(0, text.indexOf(32));
            }
        } else {
            if (!(cell.getNumericCellValue() > 0.0)) return null;
            text = "" + cell.getNumericCellValue();
        }
        well.getSamples();
        Sample.SampleType sampleType = Sample.SampleType.parseType(type);
        type = sampleType != null ? sampleType.toString() : null;
        double depth = SB.parseDepthString((String)text);
        if (units == 'F' && SB.parseDepthUnitsFromString((String)text) != 'F') {
            depth = SB.convToM((double)depth, (char)units);
        }
        if ((sample = well.getSample(depth, depth, type, useAnyType)) != null) return sample;
        if (type == null) {
            throw new SBException("Unrecognised sample type at depth: " + text);
        }
        sample = well.addSample(depth, depth, type, null);
        sample.displayUnits = units == 'F' ? units : SB.parseDepthUnitsFromString((String)text);
        well.getHeader().setWellUnits(sample.displayUnits);
        return sample;
    }

    private int parseBnd(String bnd) throws SBException {
        if (bnd.endsWith(".")) {
            bnd = bnd.substring(0, bnd.length() - 2);
        }
        for (int i = 0; i < IGDIntervalZone.bnds.length; ++i) {
            String compare = IGDIntervalZone.bnds[i];
            if (bnd.length() < compare.length()) {
                compare = compare.substring(0, bnd.length());
            }
            if (!compare.equalsIgnoreCase(bnd)) continue;
            return i + 1;
        }
        if (bnd.equalsIgnoreCase("absent")) {
            return -1;
        }
        throw new SBException("Unrecognised boundary type: " + bnd);
    }

    private void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
        if (!this.dataTypes.contains(new Integer(1))) {
            this.dataTypes.add(new Integer(1));
        }
    }

    private static enum XLSColumn {
        TOPDEPTH(new String[]{"TOP DEPTH"}),
        BASEDEPTH(new String[]{"BASE DEPTH", "BOTTOM DEPTH"}),
        TOPBND(new String[]{"TOP BOUNDARY"}),
        BASEBND(new String[]{"BASE BOUNDARY", "BOTTOM BOUNDARY", "LOWER BOUNDARY"}),
        LEGEND(new String[]{"TEXT", "UNIT", "AGE", "LEGEND", "COMMENT", "EVENT"}),
        HIER(new String[]{"HIER", "LEVEL"}),
        DEPTH(new String[]{"DEPTH", "MD", "SAMPLE"}),
        TYPE(new String[]{"TYPE", "SAMPLE TYPE"}),
        NULLCOLUMN(new String[]{"XXXXXXXXXXXXXXXXXXX"});

        private String[] titles;

        private XLSColumn(String[] titles) {
            this.titles = titles;
        }

        static XLSColumn getColumnType(String title) {
            if ((title = title.toUpperCase().trim()).isEmpty()) {
                return NULLCOLUMN;
            }
            for (XLSColumn col : XLSColumn.values()) {
                for (int i = 0; i < col.titles.length; ++i) {
                    if (!title.startsWith(col.titles[i])) continue;
                    return col;
                }
            }
            throw new IllegalArgumentException("Unrecognised column title: " + title);
        }
    }
}

