/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import model2.SBImage;
import model2.SBdb;
import util.SBException;

public class ImageSet
extends Observable {
    private SBdb SB;
    private int ID = 0;
    private LinkedList<SBImage> images = null;
    private LinkedList<SBImage> deletedImages = null;

    public ImageSet(SBdb db) {
        this.SB = db;
    }

    public ImageSet(SBdb SB2, int ID) throws SQLException {
        this.SB = SB2;
        this.ID = ID;
        this.load();
    }

    public ImageSet(SBdb SB2, String imgRootName) throws SQLException, SBException {
        this.SB = SB2;
        this.load(imgRootName);
    }

    public ImageSet(SBdb SB2, ImageSet imageSet) throws SQLException, SBException, FileNotFoundException, IOException {
        this.SB = SB2;
        this.images = new LinkedList();
        for (SBImage image : imageSet.images) {
            this.images.add(new SBImage(this.SB, image));
        }
        this.ID = imageSet.getID();
        this.store();
    }

    void unstore() {
        for (SBImage image : this.images) {
            image.setUnstored();
        }
        this.ID = 0;
    }

    public int getID() {
        return this.ID;
    }

    public SBImage getImage(int sort) throws SQLException {
        if (this.images == null) {
            System.out.println("images null, loading images");
            this.load();
        }
        if (sort < 0) {
            return this.images.getFirst();
        }
        if (sort >= this.images.size()) {
            return null;
        }
        return this.images.get(sort);
    }

    public int getSize() throws SQLException {
        if (this.images == null) {
            this.load();
        }
        return this.images.size();
    }

    public int getSize(boolean load) throws SQLException {
        if (this.images == null && load) {
            this.load();
        }
        if (this.images == null) {
            return 0;
        }
        return this.images.size();
    }

    public int insert(int i, SBImage image) throws SQLException {
        if (this.images == null) {
            this.load();
        }
        if (i > this.images.size()) {
            i = this.images.size();
        }
        this.images.add(i, image);
        return i;
    }

    public boolean isUnreferenced() {
        return this.images != null && !this.images.isEmpty() && this.images.get((int)0).isUnreferenced;
    }

    public void load() throws SQLException {
        if (this.images == null) {
            this.images = new LinkedList();
        }
        if (this.ID > 0 && this.SB != null && this.SB.isConnected()) {
            this.images.clear();
            String sql = "SELECT image_id, sort FROM " + this.SB.DBTableName("IMAGE_SETMBR") + " WHERE image_set_id=" + this.ID + " ORDER BY sort";
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                int imageID = rs.getInt("image_id");
                SBImage sbimage = this.SB.getImage(imageID);
                this.images.add(sbimage);
            }
        }
    }

    public void load(String imgPrefix) throws SQLException, SBException {
        String imageFolder;
        if (this.images == null) {
            this.images = new LinkedList();
        }
        if ((imageFolder = this.SB.getImageFolder()) != null) {
            this.images.clear();
            File dir = new File(imageFolder);
            if (!dir.exists()) {
                throw new SBException("Specified image folder '" + dir.getPath() + "' does not exist.\nSet image storage option in Control Panel config menu.");
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getPath().toLowerCase().startsWith((imageFolder + "\\" + imgPrefix + "_").toLowerCase())) continue;
                this.images.add(new SBImage(this.SB, files[i].getPath()));
            }
        }
    }

    public void delete() throws SQLException, SBException {
        if (this.SB.isConnected()) {
            Statement stmt = this.SB.getDatabase().createStatement();
            if (this.ID > 0) {
                String sql = "DELETE FROM " + this.SB.DBTableName("image_setmbr") + " WHERE image_set_id=" + this.ID;
                stmt.executeUpdate(this.SB.modQuery(sql));
                for (SBImage image : this.images) {
                    this.SB.deleteImage(image.getImageID());
                }
                this.images.clear();
                sql = "DELETE FROM " + this.SB.DBTableName("tximage") + " WHERE image_set_id=" + this.ID;
                stmt.executeUpdate(this.SB.modQuery(sql));
                sql = "UPDATE " + this.SB.DBTableName("taxonocc") + " SET image_set_id=null WHERE image_set_id=" + this.ID;
                stmt.executeUpdate(this.SB.modQuery(sql));
                sql = "DELETE FROM " + this.SB.DBTableName("image_set") + " WHERE image_set_id=" + this.ID;
                stmt.executeUpdate(this.SB.modQuery(sql));
            }
            this.SB.removeImageSetTxRefs(this.ID);
        }
    }

    static void delete(SBdb db, int id) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "SELECT image_id FROM " + db.DBTableName("IMAGE_SETMBR") + " WHERE image_set_id=" + id;
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        LinkedList<Integer> ids = new LinkedList<Integer>();
        while (rs.next()) {
            ids.add(rs.getInt("image_id"));
        }
        sql = "DELETE FROM " + db.DBTableName("image_setmbr") + " WHERE image_set_id=" + id;
        stmt.executeUpdate(db.modQuery(sql));
        for (Integer i : ids) {
            sql = "DELETE FROM " + db.DBTableName("SBIMAGE") + " WHERE image_id=" + i;
            stmt.executeUpdate(db.modQuery(sql));
        }
        sql = "DELETE FROM " + db.DBTableName("tximage") + " WHERE image_set_id=" + id;
        stmt.executeUpdate(db.modQuery(sql));
        sql = "DELETE FROM " + db.DBTableName("image_set") + " WHERE image_set_id=" + id;
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
    }

    static void deleteWithTypeCheck(SBdb db, int id, int wellID) throws SQLException {
        String sql;
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql = "SELECT image_set_id FROM " + db.DBTableName("TXIMAGE") + " WHERE image_set_id=" + id));
        if (rs.next()) {
            String newCaption = "Original occurrence in well ";
            sql = "SELECT well_name FROM " + db.DBTableName("WELLS") + " WHERE well_code IN (SELECT well_code FROM " + db.DBTableName("WELL_IDENT") + " WHERE well_id=" + wellID + ")";
            rs = stmt.executeQuery(db.modQuery(sql));
            if (rs.next()) {
                newCaption = newCaption + rs.getString("well_name") + " deleted.";
            }
            LinkedHashMap<Integer, String> captions = new LinkedHashMap<Integer, String>();
            sql = "SELECT caption,image_id from " + db.DBTableName("SBIMAGE") + " WHERE image_id IN (SELECT image_id FROM " + db.DBTableName("IMAGE_SETMBR") + " WHERE image_set_id=" + id + ") ORDER BY image_id";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String cap = newCaption + " " + rs.getString("caption");
                int j = rs.getInt("image_id");
                captions.put(j, cap.substring(0, cap.length() > 255 ? 254 : cap.length()));
            }
            for (Map.Entry e : ((HashMap)captions).entrySet()) {
                sql = "UPDATE " + db.DBTableName("SBIMAGE") + " SET caption='" + e.getValue() + "' WHERE image_id=" + e.getKey();
                stmt.executeUpdate(db.modQuery(sql));
            }
        } else {
            ImageSet.delete(db, id);
        }
        stmt.close();
    }

    public void removeImage(int i) {
        if (this.deletedImages == null) {
            this.deletedImages = new LinkedList();
        }
        this.deletedImages.add(this.images.get(i));
        this.images.remove(i);
    }

    public boolean hasDeletedImages() {
        return this.deletedImages != null && this.deletedImages.size() > 0;
    }

    public void restoreDeletedImages() {
        if (!this.hasDeletedImages()) {
            return;
        }
        for (SBImage i : this.deletedImages) {
            this.images.add(i);
        }
        this.deletedImages = null;
    }

    public void store() throws SQLException, SBException, FileNotFoundException, IOException {
        if (this.ID == 0 && this.images.size() == 0) {
            return;
        }
        if (this.SB.isConnected()) {
            String sql;
            Statement stmt = this.SB.getDatabase().createStatement();
            if (this.ID == 0) {
                this.ID = this.SB.nextControl("image_set", "image_set_id");
                sql = "INSERT INTO " + this.SB.DBTableName("image_set") + " (image_set_id) VALUES (" + this.ID + ")";
                stmt.executeUpdate(this.SB.modQuery(sql));
            } else {
                sql = "DELETE FROM " + this.SB.DBTableName("image_setmbr") + " WHERE image_set_id=" + this.ID;
                stmt.executeUpdate(this.SB.modQuery(sql));
            }
            Iterator it = this.images.iterator();
            int sort = 1;
            while (it.hasNext()) {
                SBImage image = (SBImage)it.next();
                if (image.getImageID() == 0) {
                    image.store(this.SB.storeImage());
                }
                sql = "INSERT INTO " + this.SB.DBTableName("image_setmbr") + " (image_set_id,image_id,sort) VALUES (" + this.ID + "," + image.getImageID() + "," + sort + ")";
                stmt.executeUpdate(this.SB.modQuery(sql));
                ++sort;
            }
            if (this.hasDeletedImages()) {
                for (SBImage delete : this.deletedImages) {
                    sql = "DELETE FROM " + this.SB.DBTableName("sbimage") + " WHERE image_id=" + delete.getImageID();
                    stmt.executeUpdate(this.SB.modQuery(sql));
                    this.deletedImages = null;
                }
            }
            if (this.images.size() == 0) {
                this.delete();
            }
            stmt.close();
        }
    }

    Iterator<SBImage> getIterator() throws SQLException {
        if (this.images == null) {
            this.load();
        }
        return this.images.iterator();
    }

    void update() throws SQLException, SBException, FileNotFoundException, IOException {
        System.out.println("In ImageSet update...");
        if (this.SB.isConnected()) {
            Statement stmt = this.SB.getDatabase().createStatement();
            String sql = "DELETE FROM " + this.SB.DBTableName("image_setmbr") + " WHERE image_set_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            int sort = 1;
            for (SBImage image : this.images) {
                if (image.getImageID() == 0) {
                    image.store(this.SB.storeImage());
                }
                sql = "INSERT INTO " + this.SB.DBTableName("image_setmbr") + " (image_set_id,image_id,sort) VALUES (" + this.ID + "," + image.getImageID() + "," + sort + ")";
                stmt.executeUpdate(this.SB.modQuery(sql));
                ++sort;
            }
            if (this.deletedImages != null) {
                for (SBImage image : this.deletedImages) {
                    if (image.getImageID() <= 0) continue;
                    this.SB.deleteImage(image.getImageID());
                }
                this.deletedImages = null;
            }
        }
    }

    void writeXML(BufferedWriter out, String ind, List<File> files, boolean writeSetWrapper) throws IOException, SQLException, SBException {
        if (this.images == null) {
            this.load();
        }
        if (writeSetWrapper) {
            out.write(ind + "<ImageSet>\r\n");
        }
        String indind = ind + "   ";
        for (SBImage image : this.images) {
            SBImage imageToWrite = image.link == null ? image : image.link;
            out.write(ind + "<Image>\r\n");
            File file = imageToWrite.writeXML(out, indind);
            if (file != null) {
                files.add(file);
            }
            out.write(ind + "</Image>\r\n");
        }
        if (writeSetWrapper) {
            out.write(ind + "</ImageSet>\r\n");
        }
    }

    public void clearImages() {
        if (this.images == null || this.images.isEmpty()) {
            return;
        }
        for (SBImage sbi : this.images) {
            sbi.clearImage();
        }
    }
}

