/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import model2.Audit;
import model2.SBdb;
import model2.Userdef;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class Intcom
implements SbugsStatus,
SortEntry {
    private SBdb sbdb;
    private double topDepth;
    private double baseDepth;
    private String comments;
    private Color status = UNKNOWN;
    private Audit audit = new Audit();

    Intcom(SBdb db, double topDepth, double baseDepth, String comments, Audit audit) {
        this.sbdb = db;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.comments = comments;
        this.audit = audit;
        this.status = NOTSTORED;
    }

    static Intcom load(SBdb db, int wellID, int interpID, double topDepth, Intcom i) throws SQLException, SBException {
        String sql = "SELECT base_depth,comments," + Audit.sqlFieldString() + " FROM " + db.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND top_depth >= " + (topDepth - (double)0.0029f) + " AND top_depth <=" + (topDepth + (double)0.0029f);
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        Builder builder = null;
        if (rs.next()) {
            builder = new Builder(db, topDepth);
            builder.baseDepth(rs.getDouble("base_depth"));
            builder.comments(rs.getString("comments"));
            builder.audit = new Audit(rs);
        }
        stmt.close();
        if (builder == null) {
            return null;
        }
        if (i == null) {
            return builder.build();
        }
        if (Math.abs(builder.topDepth - i.topDepth) > 0.001) {
            throw new SBException("Attempt to copy fields to unequivalent Intcom object");
        }
        i.baseDepth = builder.baseDepth;
        i.comments = builder.comments;
        i.audit = builder.audit;
        return i;
    }

    Intcom(SBdb ws, Intcom dbIntcom) throws SQLException, SBException {
        this.sbdb = ws;
        this.copyPrimitives(dbIntcom);
        this.audit = new Audit(dbIntcom.audit);
        this.audit.fillWorkspace(dbIntcom.sbdb, ws);
        this.status = STORED;
    }

    Intcom(Intcom wsIntcom, SBdb db) throws SQLException, SBException {
        this.sbdb = db;
        this.copyPrimitives(wsIntcom);
        this.audit = new Audit(this.sbdb, wsIntcom.sbdb, this.audit);
        this.status = NOTSTORED;
    }

    private void copyPrimitives(Intcom rhs) {
        this.topDepth = rhs.topDepth;
        this.baseDepth = rhs.baseDepth;
        this.comments = rhs.comments;
    }

    public String getSortEntry() {
        int top = (int)Math.round(this.getTopDepth() * 100.0);
        String entry = "" + top;
        while (entry.length() < 8) {
            entry = ' ' + entry;
        }
        int base = (int)Math.round(this.getBaseDepth() * 100.0);
        String sbase = "" + base;
        while (sbase.length() < 8) {
            sbase = ' ' + sbase;
        }
        return entry + '-' + sbase;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.comments;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    void writeDEX(FileWriter out, String eol, char units) throws SBException {
        throw new SBException("Interval comments cannot be exported to DEX files.");
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String bdepth;
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<IntervalComment>\n");
        String tdepth = SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim();
        if (tdepth != null && tdepth.length() > 0) {
            out.write(ind + "<TopDepth>" + tdepth + "</TopDepth>\n");
        }
        if ((bdepth = SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim()) != null && bdepth.length() > 0) {
            out.write(ind + "<BaseDepth>" + bdepth + "</BaseDepth>\n");
        }
        out.write(ind + "<Comment>" + SB.getXMLstring((String)this.comments) + "</Comment>\n");
        this.audit.writeXML(out, indent);
        out.write("</IntervalComment>\n");
    }

    Intcom(SBdb db, Element xml) throws SBException, ParseException, SQLException {
        Element el;
        this.sbdb = db;
        String strg = xml.getChildTextNormalize("TopDepth");
        if (strg != null) {
            this.topDepth = SB.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("BaseDepth")) != null) {
            this.baseDepth = SB.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildText("Comment")) != null) {
            this.comments = strg;
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for interval comment: " + this);
        }
    }

    public void store(int wellID, int interpID) throws SQLException {
        if (this.status == NOTSTORED) {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            String sql = "INSERT INTO " + this.sbdb.DBTableName("INTCMMNTS") + " (well_id,interp_id,top_depth,base_depth,comments," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + this.topDepth + "," + this.baseDepth + "," + SB.DBString((String)this.comments) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to interval comment deletion from well: " + wellID + ", interp: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND top_depth >=" + (this.topDepth - (double)0.0029f) + " AND top_depth <=" + (this.topDepth + (double)0.0029f);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.status = NOTSTORED;
    }

    static void load(List<Intcom> list, SBdb db, int wellID, int interpID) throws SQLException {
        String sql = "SELECT top_depth, base_depth,comments," + Audit.sqlFieldString() + " FROM " + db.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        while (rs.next()) {
            Intcom intcom;
            Builder builder = new Builder(db, rs.getDouble("top_depth"));
            builder.baseDepth(rs.getDouble("base_depth"));
            builder.comments(rs.getString("comments"));
            builder.audit(new Audit(rs)).status(STORED);
            try {
                intcom = builder.build();
            }
            catch (IllegalStateException e) {
                System.out.println("Did not build illegal intcom: " + builder.comments);
                e.printStackTrace();
                continue;
            }
            Intcom.insert(list, intcom);
        }
        stmt.close();
    }

    static void insert(List<Intcom> list, Intcom intcom) {
        int insertPos = 0;
        for (Intcom ic : list) {
            if (intcom.getSortEntry().compareTo(ic.getSortEntry()) < 0) break;
            ++insertPos;
        }
        list.add(insertPos, intcom);
    }

    static void deleteAll(SBdb SB2, int wellID, int interpID) throws SQLException, SBException {
        if (wellID == 0) {
            throw new SBException("Attempt to delete null well_id comment interval from well");
        }
        String sql = "DELETE FROM " + SB2.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    public String getComments() {
        return this.comments;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public String getModifierString() throws SQLException, SBException {
        return this.sbdb.getUser(this.audit.modifier).getAbr();
    }

    public int getUpdater() {
        return this.audit.updater;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public Date getUpdated() {
        return this.audit.updated;
    }

    void updateStatus(List<Intcom> intcoms) throws SQLException, SBException {
        this.status = NOTSTORED;
        int nzTD = (int)(100.0 * this.topDepth);
        int nzBD = (int)(100.0 * this.baseDepth);
        for (Intcom zone : intcoms) {
            if (zone == this) continue;
            if (zone.getSortEntry().equals(this.getSortEntry())) {
                this.status = STORED;
                if (this.comments.equalsIgnoreCase(zone.comments)) break;
                this.status = CONFLICT;
                break;
            }
            int cTD = (int)(100.0 * zone.topDepth);
            int cBD = (int)(100.0 * zone.baseDepth);
            try {
                SB.checkOverlap((int)cTD, (int)cBD, (int)nzTD, (int)nzBD);
            }
            catch (SBException sbe) {
                this.status = CONFLICT;
                break;
            }
        }
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(int wellID, int interpID, int newInterpID) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0 || newInterpID < 0) {
            throw new IllegalArgumentException("Illegal argument to Intcom.move: wellID is " + wellID + ", interpID is " + interpID + ", newInterpID is " + newInterpID);
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit tempAudit = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("INTCMMNTS") + " SET" + " interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND top_depth=" + this.topDepth + " AND interp_id=" + interpID;
        try {
            int nRow = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nRow < 1) {
                throw new SBException("Cannot update interval comment: " + this);
            }
        }
        finally {
            stmt.close();
        }
        this.audit = tempAudit;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for interval comment: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private Intcom(Builder builder) {
        this.sbdb = builder.sbdb;
        this.topDepth = builder.topDepth;
        this.baseDepth = builder.baseDepth;
        this.comments = builder.comments;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    public static class Builder {
        private final double topDepth;
        private final SBdb sbdb;
        private double baseDepth;
        private String comments = "";
        private Audit audit = new Audit();
        private Color status = SbugsStatus.UNKNOWN;

        public Builder(SBdb sbdb, double topDepth) {
            this.sbdb = sbdb;
            this.topDepth = topDepth;
        }

        public Builder baseDepth(double depth) {
            if (!(this.baseDepth >= 0.0)) {
                throw new IllegalStateException("Attempt to set intcom base depth to " + depth);
            }
            this.baseDepth = depth;
            return this;
        }

        public Builder comments(String comments) {
            if (comments != null) {
                this.comments = comments;
            }
            return this;
        }

        Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        Builder status(Color status) {
            if (status != null) {
                this.status = status;
            }
            return this;
        }

        public static Builder copyOf(Intcom intcom) {
            Builder builder = new Builder(intcom.sbdb, intcom.topDepth).baseDepth(intcom.baseDepth).comments(intcom.comments);
            builder.audit = intcom.audit;
            return builder;
        }

        Intcom build() {
            if (this.sbdb == null) {
                throw new IllegalStateException("Attempt to build Intcom with no data model");
            }
            if (this.baseDepth < this.topDepth) {
                throw new IllegalStateException("Attempt to build Intcom with illegal base depth less than top depth");
            }
            if (this.comments.isEmpty()) {
                System.out.println("WARNING: building Intcom with empty comment");
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new Intcom(this);
        }

        Intcom build(int wellID, int interpID) throws SQLException {
            Intcom intcom = this.build();
            intcom.store(wellID, interpID);
            return intcom;
        }

        public double getTopDepth() {
            return this.topDepth;
        }

        public double getBaseDepth() {
            return this.baseDepth;
        }
    }
}

