/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2.Audit;
import model2.SBdb;
import model2.Userdef;
import util.SB;
import util.SBException;

public class InterpHdr
extends Observable
implements Comparable {
    public static final String defaultText = "Default Version";
    SBdb SB;
    private int interpID;
    private String description;
    private Audit audit = new Audit();
    InterpHdr link = null;
    private static final String DEFAULT_SUFFIX_STRING = " (Default)";
    private static boolean DEFAULT_SUFFIX = false;

    InterpHdr(SBdb ws, InterpHdr hdr) throws SQLException, SBException {
        this.copy(hdr);
        this.SB = ws;
        this.link = hdr;
    }

    public InterpHdr getLink() {
        return this.link;
    }

    public SBdb getDatabase() {
        return this.SB;
    }

    public void setLink(InterpHdr hdr) {
        this.link = hdr;
    }

    public int getInterpID() {
        return this.interpID;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public InterpHdr(SBdb Sb, int interpID, String description, Audit audit) {
        this.SB = Sb;
        this.interpID = interpID;
        this.description = description;
        this.audit = audit;
    }

    void copy(InterpHdr rhs) {
        this.interpID = rhs.interpID;
        this.description = rhs.description;
        this.audit = new Audit(rhs.audit);
    }

    public InterpHdr(SBdb SB2, int ID) throws SQLException {
        this.SB = SB2;
        if (SB2 != null && SB2.isConnected()) {
            String sql = "SELECT descrip," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("INTERP") + " WHERE interp_id=" + ID;
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            if (rs.next()) {
                this.interpID = ID;
                this.description = rs.getString("descrip");
                if (this.description == null || this.description.length() == 0) {
                    this.description = defaultText;
                }
                this.audit = new Audit(rs);
            } else {
                this.description = defaultText;
                this.interpID = 0;
            }
            stmt.close();
        } else {
            this.description = defaultText;
            this.interpID = 0;
        }
    }

    public InterpHdr(SBdb model, String description, char sectionType) throws SQLException {
        this.description = description;
        this.SB = model;
        String sql = "SELECT interp_id," + Audit.sqlFieldString() + " FROM " + model.DBTableName("INTERP") + " WHERE descrip=" + util.SB.DBString((String)description);
        Statement stmt = model.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(model.modQuery(sql));
        if (rs.next()) {
            this.interpID = rs.getInt("interp_id");
            this.audit = new Audit(rs);
        } else {
            this.interpID = 0;
        }
        rs.close();
        stmt.close();
    }

    public static void setDisplayDefault(boolean displayDefault) {
        DEFAULT_SUFFIX = displayDefault;
    }

    public String toString() {
        if (this.interpID == 0 && DEFAULT_SUFFIX && !this.description.equalsIgnoreCase(defaultText)) {
            return this.description + " " + DEFAULT_SUFFIX_STRING;
        }
        return this.description;
    }

    public int hashCode() {
        return this.interpID;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        InterpHdr rhs = (InterpHdr)o;
        return this.interpID == rhs.interpID && this.description.equals(rhs.description);
    }

    public InterpHdr(SBdb SB2, String description) throws SBException, SQLException {
        this.description = description;
        this.SB = SB2;
        if (SB2 != null && SB2.isConnected()) {
            this.create(false);
        }
        SB2.getInterpHdrs().put(this.interpID, this);
    }

    public InterpHdr(SBdb SB2, int interpID, String description) throws SBException, SQLException {
        this.description = description;
        this.SB = SB2;
        this.interpID = interpID;
        SB2.getInterpHdrs().put(interpID, this);
    }

    public boolean setDescription(String description) throws SBException, SQLException {
        if (description.equals(this.description)) {
            return false;
        }
        List<InterpHdr> c = this.SB.getInterps();
        for (Object e : c) {
            InterpHdr h = (InterpHdr)e;
            if (!h.description.equals(description)) continue;
            throw new SBException("Version already exists (ID=" + h.interpID);
        }
        if (this.SB != null && this.SB.isConnected()) {
            this.update(description);
        } else {
            this.description = description;
        }
        this.setChanged();
        return true;
    }

    public List findWells() throws SQLException {
        LinkedList wellList = new LinkedList();
        Statement stmt = this.SB.getDatabase().createStatement();
        this.queryInterpTable(stmt, wellList, "IGD", "Zones");
        this.queryInterpTable(stmt, wellList, "IGD_ENV", "Palaeonvironments");
        this.queryInterpTable(stmt, wellList, "BCMMNTS", "Comments");
        this.queryInterpTable(stmt, wellList, "SQPICK", "Picks");
        this.queryInterpTable(stmt, wellList, "INTCMMNTS", "Interval Comments");
        this.queryInterpTable(stmt, wellList, "EVENTS", "Events");
        this.queryInterpTable(stmt, wellList, "FAULTS", "Faults");
        this.queryInterpTable(stmt, wellList, "LOC", "LOCs");
        stmt.close();
        return wellList;
    }

    private void queryInterpTable(Statement stmt, List wellList, String table, String tag) throws SQLException {
        String sql = "SELECT DISTINCT w.well_name,v.well_code FROM " + this.SB.DBTableName(table) + " i," + this.SB.DBTableName("WELLS") + " w," + this.SB.DBTableName("WELL_IDENT") + " v " + " WHERE i.well_id=v.well_id AND i.interp_id=" + this.interpID + " AND v.well_code=w.well_code ORDER BY well_name";
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            String item = rs.getString("well_name") + " (" + rs.getString("well_code") + ")" + " - " + tag;
            wellList.add(item);
        }
        rs.close();
    }

    public void delete() throws SQLException, SBException {
        if (this.interpID == 0) {
            throw new SBException("You cannot delete the default version");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD") + " WHERE interp_id=" + this.interpID;
        int nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted IGD intervals: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("SQPICK") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted SQPicks: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("SBSSR") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted Sample ages: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted Env intervals: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("IGD_COLMAP") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted Colmap: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("INTCMMNTS") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted interval comments: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted comments: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("IGD_HDR") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted headers: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("FAULTS") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted faults: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("SBCHCLIN") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted correlation lines: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("EVENTS") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted QS events: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("LOCNODE") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted LOC nodes: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("SBSSR") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted Sample ages: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("LOC") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted LOCs: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("INTERP") + " WHERE interp_id=" + this.interpID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.SB.removeInterp(this);
    }

    public void create(boolean refreshUser) throws SBException, SQLException {
        String sql = "SELECT interp_id FROM " + this.SB.DBTableName("INTERP") + " WHERE ucase(descrip)=" + util.SB.DBString((String)this.description.toUpperCase());
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            int tempInterpID = rs.getInt("interp_id");
            throw new SBException("A version of the name '" + this.description + "' already exists: ID number " + tempInterpID);
        }
        this.interpID = this.SB.nextControl("INTERP", "INTERP_ID");
        sql = "INSERT INTO " + this.SB.DBTableName("INTERP") + " (interp_id,descrip," + Audit.sqlFieldString() + ") VALUES (" + this.interpID + "," + util.SB.DBString((String)this.description) + "," + this.audit.sqlInsert(this.SB, stmt) + ")";
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.SB.getDatabase().commit();
    }

    void update(String description) throws SBException, SQLException {
        Audit temp = new Audit(this.audit);
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("INTERP") + " SET descrip='" + description + "'," + temp.sqlUpdate(this.SB, stmt, false) + " WHERE interp_id=" + this.interpID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.description = description;
        this.audit = temp;
        this.SB.getDatabase().commit();
    }

    public int compareTo(Object rhs) {
        return this.description.compareToIgnoreCase(((InterpHdr)rhs).description);
    }

    public static void loadAll(SBdb SB2, HashMap<Integer, InterpHdr> interps) throws SQLException {
        interps.put(0, new InterpHdr(SB2, 0));
        if (SB2 != null && SB2.isConnected()) {
            String sql = "SELECT interp_id,descrip," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("INTERP");
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                int interpID = rs.getInt("interp_id");
                String description = rs.getString("descrip");
                InterpHdr interp = new InterpHdr(SB2, interpID, description, new Audit(rs));
                interps.put(interp.getInterpID(), interp);
            }
            stmt.close();
        }
    }

    static InterpHdr refresh(Statement stmt, SBdb SB2, HashMap<Integer, InterpHdr> interpHdrs) throws SQLException {
        String sql = "SELECT interp_id,updated ";
        sql = sql + " FROM " + SB2.DBTableName("INTERP");
        sql = SB2.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        InterpHdr notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("interp_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (InterpHdr o : interpHdrs.values()) {
                if (o.getInterpID() != key) continue;
                found = true;
                if (time == null || !time.after(o.getUpdated())) break;
                InterpHdr hdr = new InterpHdr(SB2, key);
                o.copy(hdr);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = new InterpHdr(SB2, key);
            interpHdrs.put(key, notifier);
        }
        if (keys.size() < interpHdrs.size()) {
            Iterator<InterpHdr> it = interpHdrs.values().iterator();
            while (it.hasNext()) {
                InterpHdr o = it.next();
                if (keys.contains(o.getInterpID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    public String getCreatorString() throws SQLException, SBException {
        Userdef user = this.SB.getUser(this.getCreator());
        if (user == null) {
            return "";
        }
        return user.getAbr();
    }

    public String getCreatedString() {
        if (this.getCreated() != null) {
            return util.SB.df.format(this.getCreated());
        }
        return "";
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to set analyst on connected interpHdr: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }
}

