/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import model2.LOC;
import model2.SBdb;
import model2.Well;
import util.SB;
import util.SBException;

public class LASFile {
    int nCurves;
    int FIELD_WIDTH = 10;
    String eol = "\r\n";
    TreeSet depths = new TreeSet(new CompareLogValue());
    List fileHeaders = new LinkedList();
    ArrayList curveHeaders = new ArrayList();
    final int CURVE_INFORMATION = 1;
    final int PARAMETERS = 2;
    final int WELL_INFORMATION = 3;
    final int VERSION_INFORMATION = 4;
    int headerType = 0;

    public LASFile(String path, SBdb db, LOC loc, Well well, char units, String UWI) throws IOException, SQLException, SBException {
        FileWriter out = new FileWriter(path);
        out.write("#----------------------------------------------------------" + this.eol);
        out.write("#Created with StrataBugs 2.0" + this.eol);
        out.write("#on: " + new Date().toString() + this.eol);
        out.write("#----------------------------------------------------------" + this.eol);
        out.write("~VERSION INFORMATION" + this.eol);
        out.write("VERS.  1.2: CWLS LOG ASCII STANDARD - VERSION 1.2" + this.eol);
        out.write("WRAP. NO  : One line per depth step" + this.eol);
        out.write("#----------------------------------------------------------" + this.eol);
        out.write("~WELL INFORMATION" + this.eol);
        out.write("#MNEM.UNIT\tData Type\tInformation" + this.eol);
        out.write("#---------\t-------------\t----------------------" + this.eol);
        out.write("STRT." + units + "           " + SB.convFromM((double)loc.getTopDepth(), (char)units) + this.eol);
        out.write("STOP." + units + "           " + SB.convFromM((double)loc.getBaseDepth(), (char)units) + this.eol);
        out.write("STEP." + units + "           " + 0 + this.eol);
        out.write("NULL.             -999.25" + this.eol);
        out.write("COMP.             COMPANY:      " + well.getHeader().getOper() + this.eol);
        out.write("WELL.                WELL:      " + well.getWellName() + this.eol);
        out.write("FLD .               FIELD:      " + well.getHeader().getField() + this.eol);
        out.write("LOC .            LOCATION:      " + this.eol);
        out.write("CNTY.              COUNTY:      " + well.getHeader().getCounty() + this.eol);
        out.write("STAT.               STATE:      " + this.eol);
        out.write("CTRY.             COUNTRY:      " + well.getHeader().getCountry() + this.eol);
        out.write("SRVC.     SERVICE COMPANY:      " + this.eol);
        out.write("DATE.            LOG DATE:      " + this.eol);
        out.write("UWI .      UNIQUE WELL ID:      " + UWI + this.eol);
        out.write("#----------------------------------------------------------" + this.eol);
        out.write("~CURVE INFORMATION" + this.eol);
        out.write("#MNEM.UNIT\tCurve Description" + this.eol);
        out.write("#---------   -------------------------------" + this.eol);
        out.write("DEPTH." + units + "      :    DEPTH" + this.eol);
        out.write("AGE          :    AGE in millions of years" + this.eol);
        out.write("#----------------------------------------------------------" + this.eol);
        out.write("~A" + this.eol);
        Iterator<LOC.LOCNode> it = loc.getNodeIterator();
        while (it.hasNext()) {
            LOC.LOCNode node = it.next();
            String depth = SB.floatString((double)SB.convFromM((double)node.getDepth(), (char)units), (int)6);
            String age = SB.floatString((double)node.getAge(), (int)6);
            out.write(depth + "\t" + age + this.eol);
        }
        out.flush();
        out.close();
    }

    public LASFile(String filePath) throws IOException {
        String buff;
        BufferedReader in = new BufferedReader(new FileReader(filePath));
        boolean dataBlock = false;
        int curveCounter = 0;
        LogValue logValue = null;
        while ((buff = in.readLine()) != null) {
            if (!dataBlock) {
                if (buff.length() <= 0) continue;
                block0 : switch (buff.charAt(0)) {
                    case '~': {
                        if (buff.substring(1).toLowerCase().startsWith("c")) {
                            this.headerType = 1;
                            break;
                        }
                        if (buff.substring(1).toLowerCase().startsWith("p")) {
                            this.headerType = 2;
                            break;
                        }
                        if (buff.substring(1).toLowerCase().startsWith("w")) {
                            this.headerType = 3;
                            break;
                        }
                        if (buff.substring(1).toLowerCase().startsWith("v")) {
                            this.headerType = 4;
                            break;
                        }
                        if (buff.substring(1).toLowerCase().startsWith("a")) {
                            this.headerType = 0;
                            dataBlock = true;
                            break;
                        }
                        this.headerType = 0;
                        break;
                    }
                    case '#': {
                        break;
                    }
                    default: {
                        switch (this.headerType) {
                            case 1: {
                                CurveHeader header = new CurveHeader();
                                int dotInd = buff.indexOf(46);
                                int colonInd = buff.indexOf(58);
                                header.mnem = buff.substring(0, dotInd).trim();
                                header.units = buff.substring(dotInd, dotInd + 7).trim();
                                header.SPIcodes = buff.substring(dotInd + 7, colonInd).trim();
                                header.description = buff.substring(colonInd);
                                if (header.mnem.startsWith("DEPT")) break block0;
                                this.curveHeaders.add(header);
                                ++this.nCurves;
                                break block0;
                            }
                            default: {
                                break block0;
                            }
                            case 4: {
                                if (!buff.trim().toUpperCase().startsWith("WRAP.")) break block0;
                                buff = buff.replaceFirst("YES", "NO ");
                            }
                        }
                    }
                }
                if (dataBlock) continue;
                this.fileHeaders.add(buff);
                continue;
            }
            StringTokenizer tok = new StringTokenizer(buff);
            while (tok.hasMoreTokens()) {
                float value = Float.parseFloat(tok.nextToken().trim());
                if (curveCounter > 0 && curveCounter <= this.nCurves) {
                    logValue.values[curveCounter - 1] = value;
                } else {
                    curveCounter = 0;
                    logValue = new LogValue();
                    logValue.depth = value;
                    this.depths.add(logValue);
                }
                ++curveCounter;
            }
        }
    }

    void write(String filePath) throws IOException {
        FileWriter out = new FileWriter(filePath);
        Iterator ith = this.fileHeaders.iterator();
        while (ith.hasNext()) {
            out.write(ith.next() + this.eol);
        }
        out.write("~A   DEPTH");
        for (CurveHeader h : this.curveHeaders) {
            out.write(this.pad(h.mnem));
        }
        out.write(this.eol);
        for (LogValue logValue : this.depths) {
            out.write(this.pad(SB.floatString((double)logValue.depth, (int)3)));
            for (int j = 0; j < this.nCurves; ++j) {
                out.write(this.pad(SB.floatString((double)logValue.values[j], (int)3)));
            }
            out.write(this.eol);
        }
        out.close();
    }

    String pad(String s) {
        while (s.length() < this.FIELD_WIDTH) {
            s = ' ' + s;
        }
        return s;
    }

    class CurveHeader {
        String mnem;
        String units;
        String SPIcodes;
        String description;

        CurveHeader() {
        }
    }

    class CompareLogValue
    implements Comparator {
        CompareLogValue() {
        }

        public int compare(Object l1, Object l2) {
            LogValue log1 = (LogValue)l1;
            LogValue log2 = (LogValue)l2;
            if (log1.depth < log2.depth) {
                return -1;
            }
            if (log1.depth > log2.depth) {
                return 1;
            }
            return 0;
        }
    }

    class LogValue {
        double depth;
        double[] values;

        LogValue() {
            this.values = new double[LASFile.this.nCurves];
        }
    }
}

