/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import model2.LithBase;
import model2.Lithdesc;
import model2.Lithology;
import model2.SBdb;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SortEntry;

public class LithQualifier
extends LithBase {
    char qType = (char)81;
    char alignment = (char)76;
    float xPlotPos;

    public LithQualifier(SBdb SB2) {
        super(SB2);
    }

    public LithQualifier(SBdb SB2, LithQualifier rhs) {
        super(SB2, rhs);
        this.qType = rhs.qType;
        this.alignment = rhs.alignment;
        this.xPlotPos = rhs.xPlotPos;
    }

    LithQualifier(SBdb SB2, int wellID, LithQualifier rhs) throws SQLException, SBException {
        super(rhs, SB2);
        this.qType = rhs.qType;
        this.alignment = rhs.alignment;
        this.xPlotPos = rhs.xPlotPos;
        this.status = NOTSTORED;
        this.store(SB2, wellID);
    }

    public char getType() {
        return this.qType;
    }

    public void setType(char type) throws SBException {
        if (this.getSbdb() != null) {
            throw new SBException("Attempt to update lith qualifier directly");
        }
        this.qType = type;
    }

    public char getAlignment() {
        return this.alignment;
    }

    public Alignment getAlignmentType() {
        return Alignment.getAlignmentType(this.alignment);
    }

    public String getAlignmentString() {
        switch (this.alignment) {
            case 'L': {
                return "Left";
            }
            case 'R': {
                return "Right";
            }
            case 'C': {
                return "Centre";
            }
        }
        return "";
    }

    @Override
    public void setLithology(Lithology lith) throws SBException, SQLException {
        super.setLithology(lith);
        if (lith != null) {
            this.qType = lith.getCmp();
            if (this.qType == 'Y') {
                this.qType = (char)81;
            }
        }
    }

    public void setAlignment(char alignment) throws SBException {
        if (this.getSbdb() != null) {
            throw new SBException("Attempt to update lith qualifier directly");
        }
        this.alignment = alignment;
    }

    public float getXpos() {
        return this.xPlotPos;
    }

    public void setXpos(float xPos) throws SBException {
        if (this.getSbdb() != null) {
            throw new SBException("Attempt to update lith qualifier directly");
        }
        this.xPlotPos = xPos;
    }

    public String getSortEntry() {
        int top = (int)Math.round(this.getTopDepth() * 100.0) + 10000000;
        String entry = "" + top;
        while (entry.length() < 8) {
            entry = ' ' + entry;
        }
        return entry + '-' + entry + '-' + this.getLithCode();
    }

    @Override
    final void store(SBdb SB2, int wellID) throws SQLException {
        if (this.getLithCode() > 0 && this.status == NOTSTORED) {
            if (this.qType == '\u0000' && this.desc != null) {
                this.qType = this.desc.getCmp();
            }
            if (this.qType == 'Y') {
                this.qType = (char)81;
            }
            if (this.alignment == '\u0000') {
                this.alignment = (char)76;
            }
            String sql = "INSERT INTO " + SB2.DBTableName("SBQLITH") + " (well_id,type,top_depth,alignment,plotpos,lith_id) VALUES (" + wellID + "," + SB.DBChar((char)this.qType) + "," + this.topDepth + "," + SB.DBChar((char)this.alignment) + "," + this.xPlotPos + "," + this.getLithCode() + ")";
            Statement stmt = SB2.getDatabase().createStatement();
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    public static void deleteAll(SBdb SB2, int wellID) throws SQLException, SBException {
        if (wellID == 0) {
            throw new SBException("Attempt to delete null lithology qualifers from well");
        }
        String sql = "DELETE FROM " + SB2.DBTableName("SBQLITH") + " WHERE well_id=" + wellID;
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int wellID, Statement stmt) throws SQLException {
        if (wellID <= 0) {
            throw new IllegalArgumentException("Attempt to delete lithology qualifier from wellID: " + wellID);
        }
        String sql = "DELETE FROM " + this.getSbdb().DBTableName("SBQLITH") + " WHERE well_id=" + wellID + " AND top_depth >=" + (this.topDepth - (double)0.0029f) + " AND top_depth <=" + (this.topDepth + (double)0.0029f) + " AND type='" + this.qType + "'";
        Statement statement = stmt == null ? this.getSbdb().getDatabase().createStatement() : stmt;
        try {
            statement.executeUpdate(this.getSbdb().modQuery(sql));
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        this.status = NOTSTORED;
    }

    @Override
    public void updateStatus(List<LithBase> oldData, boolean oldDataStored) {
        Iterator<LithBase> en = oldData.iterator();
        int nzTD = (int)Math.round(this.topDepth * 100.0);
        this.status = NOTSTORED;
        while (en.hasNext()) {
            int cTD;
            LithQualifier lithQual;
            LithBase lith = en.next();
            if (!(lith instanceof LithQualifier) || (lithQual = (LithQualifier)lith) == this || (cTD = (int)Math.round(lithQual.topDepth * 100.0)) != nzTD || this.qType != lithQual.qType || !(Math.abs(this.xPlotPos - lithQual.xPlotPos) < 0.0029f) || this.alignment != lithQual.alignment) continue;
            if (oldDataStored) {
                this.status = STORED;
            }
            if (this.getLithCode() == lithQual.getLithCode()) break;
            this.status = CONFLICT;
            break;
        }
    }

    @Override
    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[INTERVAL " + SB.getDepthString((double)this.topDepth, (char)units, (int)2) + " - " + SB.getDepthString((double)this.topDepth, (char)units, (int)2) + "]" + eol);
        out.write("Lithology ");
        switch (this.qType) {
            case 'A': {
                out.write("Accessory");
                break;
            }
            case 'S': {
                out.write("Stringer");
                break;
            }
            case 'Q': {
                out.write("Qualifier");
            }
        }
        out.write(" = " + this + eol);
        out.write("  Top depth : " + SB.getDepthString((double)this.topDepth, (char)units, (int)2) + eol);
        out.write("  Dictionary ID : " + this.getLithCode() + eol);
        if (this.qType == 'A' || this.qType == 'Q') {
            out.write("  Plot position : " + this.xPlotPos + eol);
        }
        if (this.qType == 'S') {
            out.write("  Alignment : ");
            if (this.alignment == 'L') {
                out.write("Left");
            } else {
                out.write("Right");
            }
            out.write(eol);
            out.write("  Width : " + this.xPlotPos + eol);
        }
        out.write(eol);
    }

    LithQualifier(SBdb db, Element xml) throws SBException, SQLException {
        super(db);
        String strg = xml.getChildTextNormalize("Depth");
        if (strg != null) {
            this.topDepth = SB.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("LithologyID")) != null) {
            int lithCode = Integer.parseInt(strg);
            this.desc = db.getLithdesc().getLithology(lithCode);
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null && strg.length() > 0) {
            this.qType = strg.charAt(0);
        }
        if ((strg = xml.getChildTextNormalize("Alignment")) != null && strg.length() > 0) {
            this.alignment = strg.charAt(0);
        }
        if ((strg = xml.getChildTextNormalize("PlotPosition")) != null) {
            this.xPlotPos = Float.parseFloat(strg);
        }
        if ((strg = xml.getChildTextNormalize("Width")) != null) {
            this.xPlotPos = Float.parseFloat(strg);
        }
    }

    @Override
    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<LithologyQualifier Depth=\"" + SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim() + "\">\n");
        out.write(ind + "<Lithology>");
        out.write("" + this);
        out.write("</Lithology>\n");
        out.write(ind + "<Type>");
        switch (this.qType) {
            case 'A': {
                out.write("Accessory");
                break;
            }
            case 'S': {
                out.write("Stringer");
                break;
            }
            case 'Q': {
                out.write("Qualifier");
            }
        }
        out.write("</Type>\n");
        String tdepth = SB.getDepthString((double)this.topDepth, (char)units, (int)2);
        if (tdepth != null && tdepth.length() > 0) {
            out.write(ind + "<Depth>" + tdepth + "</Depth>\n");
        }
        if (this.getLithCode() > 0) {
            out.write(ind + "<LithologyID>" + this.getLithCode() + "</LithologyID>\n");
        }
        if (this.qType == 'A' || this.qType == 'Q') {
            out.write(ind + "<PlotPosition>" + this.xPlotPos + "</PlotPosition>\n");
        }
        if (this.qType == 'S') {
            out.write(ind + "<Alignment>");
            if (this.alignment == 'L') {
                out.write("Left");
            } else if (this.alignment == 'C') {
                out.write("Centre");
            } else {
                out.write("Right");
            }
            out.write("</Alignment>\n");
            if (this.xPlotPos > 0.0f) {
                out.write(ind + "<Width>" + this.xPlotPos + "</Width>\n");
            }
        }
        out.write("</LithologyQualifier>\n");
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    private LithQualifier(Builder builder) {
        super(builder);
        this.alignment = builder.alignment;
        this.qType = builder.qType;
        this.xPlotPos = builder.xPlotPos;
    }

    public static class Builder
    extends LithBase.Builder {
        char alignment = (char)76;
        final char qType;
        float xPlotPos;

        public Builder(SBdb sbdb, double topDepth, Lithology desc) throws SBException {
            super(sbdb, topDepth, desc);
            char q = desc.getCmp();
            if (q == 'Y') {
                q = 'Q';
            }
            assert (Lithdesc.getLithType(q).isQualifier());
            this.qType = q;
            this.xPlotPos = this.qType == 'S' ? 100.0f : 0.0f;
        }

        @Override
        LithQualifier build() {
            return new LithQualifier(this);
        }

        public Builder alignment(Alignment a) {
            this.alignment = a.getCharType();
            return this;
        }

        public Builder xPos(float xPos) {
            if (this.qType == 'S') {
                return this;
            }
            if (xPos > 100.0f) {
                xPos = 100.0f;
            }
            this.xPlotPos = Math.round(xPos);
            return this;
        }
    }

    public static final class Alignment
    extends Enum<Alignment> {
        public static final /* enum */ Alignment LEFT = new Alignment('L');
        public static final /* enum */ Alignment RIGHT = new Alignment('R');
        public static final /* enum */ Alignment CENTRE = new Alignment('C');
        private final char charType;
        private static final /* synthetic */ Alignment[] $VALUES;

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String name) {
            return Enum.valueOf(Alignment.class, name);
        }

        private Alignment(char charType) {
            this.charType = charType;
        }

        char getCharType() {
            return this.charType;
        }

        static Alignment getAlignmentType(char type) {
            switch (type) {
                case 'L': {
                    return LEFT;
                }
                case 'R': {
                    return RIGHT;
                }
                case 'C': {
                    return CENTRE;
                }
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new Alignment[]{LEFT, RIGHT, CENTRE};
        }
    }
}

