/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import model2.LithScheme;
import model2.Lithology;
import model2.SBdb;
import util.SBException;

public class Lithdesc {
    SBdb SB;
    List<LithScheme> schemes = new ArrayList<LithScheme>();
    LithScheme currentScheme = null;
    Vector<Lithology> lithologies = new Vector();
    List<Lithology> stringers = new ArrayList<Lithology>();
    List<Lithology> qualifiers = new ArrayList<Lithology>();
    List<Lithology> accessories = new ArrayList<Lithology>();
    static final String ACCESSORY_PREFIX = "Accessory : ";
    static final String STRINGER_PREFIX = "Stringer : ";
    static final String QUALIFIER_PREFIX = "Qualifier : ";
    int trnLoaded = 0;

    public Lithdesc(SBdb SB2, boolean extendedSet) throws SQLException, SBException {
        this.SB = SB2;
        String sql = "SELECT lith_id,descr,abr,cmp,grain_size,sort_order";
        sql = sql + " FROM " + SB2.DBTableName("LITHDESC");
        sql = sql + " ORDER BY sort_order,lith_id";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int lithID = rs.getInt("lith_id");
            String descr = rs.getString("descr");
            String abr = rs.getString("abr");
            char cmp = rs.getString("cmp").charAt(0);
            float grainSize = rs.getFloat("grain_size");
            int sortOrder = rs.getInt("sort_order");
            Lithology lithology = new Lithology(SB2, lithID, descr, abr, cmp, grainSize, sortOrder);
            this.lithologies.add(lithology);
            switch (lithology.getCmp()) {
                case 'A': {
                    this.accessories.add(lithology);
                    break;
                }
                case 'S': {
                    this.stringers.add(lithology);
                    break;
                }
                case 'Q': 
                case 'Y': {
                    this.qualifiers.add(lithology);
                    break;
                }
            }
        }
        sql = "SELECT lthsch_id, descr FROM " + SB2.DBTableName("SBLTHSCH");
        rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            LithScheme scheme = new LithScheme();
            scheme.ID = rs.getInt("lthsch_id");
            scheme.descr = rs.getString("descr");
            this.schemes.add(scheme);
            if (!scheme.descr.equalsIgnoreCase("All")) continue;
            this.currentScheme = scheme;
        }
        sql = "SELECT lthsch_id, lith_id FROM " + SB2.DBTableName("SBLTHMBR");
        rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int schemeID = rs.getInt("lthsch_id");
            int lithID = rs.getInt("lith_id");
            Iterator<LithScheme> it = this.schemes.iterator();
            LithScheme scheme = null;
            while (it.hasNext()) {
                scheme = it.next();
                if (scheme.ID != schemeID) continue;
            }
            if (scheme == null) continue;
            Enumeration<Lithology> en = this.lithologies.elements();
            while (en.hasMoreElements()) {
                Lithology lith = en.nextElement();
                if (lith.getLithID() != lithID) continue;
                scheme.lithologies.add(lith);
            }
        }
    }

    public String getQualifiedLithdesc(Lithology lithology) {
        if (lithology == null) {
            return "";
        }
        if (this.accessories.contains(lithology)) {
            return ACCESSORY_PREFIX + lithology.getDescr();
        }
        if (this.qualifiers.contains(lithology)) {
            return QUALIFIER_PREFIX + lithology.getDescr();
        }
        if (this.stringers.contains(lithology)) {
            return STRINGER_PREFIX + lithology.getDescr();
        }
        return lithology.getDescr();
    }

    public Lithology getLithologyFromDescription(String descr) {
        if (descr.startsWith(ACCESSORY_PREFIX)) {
            descr = descr.substring(ACCESSORY_PREFIX.length());
            for (Lithology acc : this.accessories) {
                if (!acc.getDescr().equalsIgnoreCase(descr)) continue;
                return acc;
            }
        } else if (descr.startsWith(STRINGER_PREFIX)) {
            descr = descr.substring(STRINGER_PREFIX.length());
            for (Lithology acc : this.stringers) {
                if (!acc.getDescr().equalsIgnoreCase(descr)) continue;
                return acc;
            }
        }
        if (descr.startsWith(QUALIFIER_PREFIX)) {
            descr = descr.substring(QUALIFIER_PREFIX.length());
            for (Lithology acc : this.qualifiers) {
                if (!acc.getDescr().equalsIgnoreCase(descr)) continue;
                return acc;
            }
        }
        for (int i = 0; i < this.lithologies.size(); ++i) {
            Lithology lith = this.lithologies.elementAt(i);
            if (lith.getLithID() < 1000 || lith.getLithID() >= 2000 || lith.getDescr().compareToIgnoreCase(descr) != 0) continue;
            return lith;
        }
        return null;
    }

    public Lithology getLithology(int lithCode) {
        for (Lithology lith : this.lithologies) {
            if (lith.getLithID() != lithCode) continue;
            return lith;
        }
        return null;
    }

    public List<Lithology> getBase() {
        LinkedList<Lithology> list = new LinkedList<Lithology>();
        for (Lithology lithology : this.lithologies) {
            if (lithology.getLithID() >= 2000) continue;
            list.add(new Lithology(lithology));
        }
        return list;
    }

    public static LithType getLithType(char qType) {
        switch (qType) {
            case 'A': {
                return LithType.ACCESSORY;
            }
            case 'Q': {
                return LithType.QUALIFIER;
            }
            case 'S': {
                return LithType.STRINGER;
            }
        }
        assert (false);
        return LithType.MAIN;
    }

    public List<Lithology> getList(LithType type) {
        LinkedList<Lithology> list = new LinkedList<Lithology>();
        switch (type) {
            case MAIN: {
                for (Lithology lithology : this.lithologies) {
                    if (lithology.getLithID() >= 2000) continue;
                    list.add(new Lithology(lithology));
                }
                break;
            }
            case QUALIFIER: {
                list.addAll(this.qualifiers);
                break;
            }
            case ACCESSORY: {
                list.addAll(this.accessories);
                break;
            }
            case STRINGER: {
                list.addAll(this.stringers);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return list;
    }

    public void storeGrainSize() throws SQLException {
        String sql = "UPDATE " + this.SB.DBTableName("lithdesc") + " SET grain_size=? WHERE lith_id=?";
        PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
        for (Lithology lithology : this.lithologies) {
            System.out.println("Saving lithology: " + lithology);
            pStmt.setFloat(1, lithology.getGrainSize());
            pStmt.setInt(2, lithology.getLithID());
            pStmt.execute();
        }
        pStmt.close();
    }

    public static enum LithType {
        MAIN("Main", false),
        QUALIFIER("Qualifiers", true),
        ACCESSORY("Accessories", true),
        STRINGER("Stringers", true);

        private final boolean isQualifier;
        private final String noun;

        private LithType(String noun, boolean isQualifier) {
            this.noun = noun;
            this.isQualifier = isQualifier;
        }

        public String getNoun() {
            return this.noun;
        }

        public boolean isQualifier() {
            return this.isQualifier;
        }
    }
}

