/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.awt.Graphics;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import model2.SBdb;
import util.SB;
import util.SBException;

public class Lithology {
    SBdb SB;
    private int lithID;
    private String descr;
    private String abr;
    private char cmp;
    private float grainSize = 0.0f;
    private String patDescr;
    private float magnif;
    private Color backColour;
    private int nLines;
    private float width;
    private float height;
    private int myRed = 0;
    private int myGreen = 0;
    private int myBlue = 0;
    private float[] x1 = null;
    private float[] x2 = null;
    private float[] y1 = null;
    private float[] y2 = null;
    private String[] oType = null;
    private Color[] colour = null;
    private float[] lineWidth = null;
    private int[] style = null;
    private String r;
    private String g;
    private String b;
    private int sortOrder;

    public Lithology(SBdb SB2, int lithID, String descr, String abr, char cmp, float grainSize, int sortOrder) throws SQLException, SBException {
        this.SB = SB2;
        this.lithID = lithID;
        this.descr = descr;
        this.abr = abr;
        this.cmp = cmp;
        this.grainSize = grainSize;
        this.sortOrder = sortOrder;
        this.loadPattern();
    }

    public Lithology(int lithID) {
        this.lithID = lithID;
    }

    public Lithology(Lithology rhs) {
        this.copy(rhs);
    }

    final void copy(Lithology rhs) {
        this.lithID = rhs.lithID;
        this.descr = rhs.descr;
        this.abr = rhs.abr;
        this.cmp = rhs.cmp;
        this.grainSize = rhs.grainSize;
        this.patDescr = rhs.patDescr;
        this.magnif = rhs.magnif;
        this.backColour = rhs.backColour;
        this.nLines = rhs.nLines;
        this.width = rhs.width;
        this.height = rhs.height;
        this.myRed = rhs.myRed;
        this.myGreen = rhs.myGreen;
        this.myBlue = rhs.myBlue;
        this.x1 = new float[rhs.x1.length];
        int i = 0;
        for (float f : rhs.x1) {
            this.x1[i++] = f;
        }
        this.x2 = new float[rhs.x2.length];
        i = 0;
        for (float f : rhs.x2) {
            this.x2[i++] = f;
        }
        this.y1 = new float[rhs.y1.length];
        i = 0;
        for (float f : rhs.y1) {
            this.y1[i++] = f;
        }
        this.y2 = new float[rhs.y2.length];
        i = 0;
        for (float f : rhs.y2) {
            this.y2[i++] = f;
        }
        this.oType = new String[rhs.oType.length];
        i = 0;
        for (String s : rhs.oType) {
            this.oType[i++] = s;
        }
        this.colour = new Color[rhs.colour.length];
        i = 0;
        for (Color c : rhs.colour) {
            this.colour[i++] = c;
        }
        this.lineWidth = new float[rhs.lineWidth.length];
        i = 0;
        for (float f : rhs.lineWidth) {
            this.lineWidth[i++] = f;
        }
        this.style = new int[rhs.style.length];
        i = 0;
        for (int k : rhs.style) {
            this.style[i++] = k;
        }
        this.r = rhs.r;
        this.g = rhs.g;
        this.b = rhs.b;
        this.sortOrder = rhs.sortOrder;
    }

    private void loadPattern() throws SQLException, SBException {
        String sql = "SELECT descr FROM " + this.SB.DBTableName("SBLTHPAT") + " WHERE lith_id=" + this.lithID + " AND line=0";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (!rs.next()) {
            throw new SBException("Attempt to load lithology pattern with no line descriptor: " + this.lithID);
        }
        this.patDescr = rs.getString("descr");
        boolean returndelim = false;
        StringTokenizer token = new StringTokenizer(this.patDescr, ", ", returndelim);
        int ptr = 0;
        float m = 1.0f;
        float patWidth = 0.0f;
        float patHeight = 0.0f;
        int znl = 0;
        Color bc = null;
        while (token.hasMoreTokens()) {
            switch (ptr) {
                case 0: {
                    m = Float.parseFloat(token.nextToken());
                    break;
                }
                case 1: {
                    patWidth = m * Float.parseFloat(token.nextToken());
                    break;
                }
                case 2: {
                    patHeight = m * Float.parseFloat(token.nextToken());
                    break;
                }
                case 3: {
                    znl = Integer.parseInt(token.nextToken());
                    break;
                }
                case 4: {
                    bc = null;
                    String colourToken = token.nextToken();
                    colourToken = colourToken.toUpperCase();
                    try {
                        this.r = colourToken.substring(2, 4);
                        this.g = colourToken.substring(4, 6);
                        this.b = colourToken.substring(6, 8);
                        int red = Integer.parseInt(this.r, 16);
                        int green = Integer.parseInt(this.g, 16);
                        int blue = Integer.parseInt(this.b, 16);
                        bc = new Color(blue, green, red);
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("Error decoding colour for lith pattern: " + this.lithID + "," + this.patDescr);
                    }
                }
            }
            ++ptr;
        }
        this.magnif = m;
        this.backColour = bc;
        this.nLines = znl;
        this.width = patWidth;
        this.height = patHeight;
        this.x1 = new float[this.nLines];
        this.y1 = new float[this.nLines];
        this.x2 = new float[this.nLines];
        this.y2 = new float[this.nLines];
        this.colour = new Color[this.nLines];
        this.lineWidth = new float[this.nLines];
        this.oType = new String[this.nLines];
        this.style = new int[this.nLines];
        rs.close();
        sql = "SELECT line, descr FROM ";
        sql = sql + this.SB.DBTableName("SBLTHPAT") + " WHERE lith_id=" + this.lithID + " AND line > 0 ORDER BY line";
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int i = rs.getInt("line") - 1;
            this.patDescr = rs.getString("descr");
            ptr = 0;
            this.lineWidth[i] = 0.1f;
            this.colour[i] = null;
            this.style[i] = 0;
            StringTokenizer token2 = new StringTokenizer(this.patDescr, ", ", returndelim);
            while (token2.hasMoreTokens()) {
                switch (ptr) {
                    case 0: {
                        this.oType[i] = token2.nextToken();
                        if (this.oType[i] != null) break;
                        System.out.println("oType null for lithID: " + this.lithID + " , line=" + (i + 1));
                        break;
                    }
                    case 1: {
                        if (this.oType[i].compareTo("CP") == 0 || this.oType[i].compareTo("CB") == 0) {
                            this.style[i] = Integer.parseInt(token2.nextToken());
                            break;
                        }
                        this.x1[i] = this.magnif * Float.parseFloat(token2.nextToken());
                        break;
                    }
                    case 2: {
                        if (this.oType[i].compareTo("CP") == 0 || this.oType[i].compareTo("CB") == 0) {
                            this.lineWidth[i] = Float.parseFloat(token2.nextToken());
                            break;
                        }
                        this.y1[i] = this.magnif * Float.parseFloat(token2.nextToken());
                        break;
                    }
                    case 3: {
                        if (this.oType[i].compareTo("CP") == 0 || this.oType[i].compareTo("CB") == 0) {
                            this.myRed = Integer.parseInt(token2.nextToken());
                            break;
                        }
                        this.x2[i] = this.magnif * Float.parseFloat(token2.nextToken());
                        break;
                    }
                    case 4: {
                        if (this.oType[i].compareTo("CP") == 0 || this.oType[i].compareTo("CB") == 0) {
                            this.myGreen = Integer.parseInt(token2.nextToken());
                            break;
                        }
                        this.y2[i] = this.magnif * Float.parseFloat(token2.nextToken());
                        break;
                    }
                    case 5: {
                        if (this.oType[i].compareTo("CP") == 0 || this.oType[i].compareTo("CB") == 0) {
                            this.myBlue = Integer.parseInt(token2.nextToken());
                            break;
                        }
                        this.y2[i] = this.magnif * Float.parseFloat(token2.nextToken());
                    }
                }
                ++ptr;
                if (this.oType[i].compareTo("CP") != 0 && this.oType[i].compareTo("CB") != 0) continue;
                this.colour[i] = new Color(this.myRed, this.myGreen, this.myBlue);
            }
        }
        stmt.close();
    }

    public boolean isQual() {
        switch (this.cmp) {
            case 'A': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'Q': 
            case 'Y': {
                return true;
            }
        }
        return false;
    }

    public float getMagnif() {
        return this.magnif;
    }

    public Color getBackColour() {
        return this.backColour;
    }

    public int getNLines() {
        return this.nLines;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float[] getX1() {
        return this.x1;
    }

    public float[] getY1() {
        return this.y1;
    }

    public float[] getX2() {
        return this.x2;
    }

    public float[] getY2() {
        return this.y2;
    }

    public String[] getOType() {
        return this.oType;
    }

    public Color[] getPenColour() {
        return this.colour;
    }

    public int[] getStyle() {
        return this.style;
    }

    public float[] getLineWidth() {
        return this.lineWidth;
    }

    public String getPatDescr() {
        return this.patDescr;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public String toString() {
        return this.descr;
    }

    public Color getColour() {
        switch (this.lithID) {
            case 1001: {
                return Color.LIGHT_GRAY;
            }
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1018: {
                return Color.YELLOW;
            }
            case 1003: 
            case 1005: 
            case 1006: 
            case 1007: {
                return Color.GREEN;
            }
            case 1030: 
            case 1031: 
            case 1032: 
            case 1033: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1037: 
            case 1038: 
            case 1039: 
            case 1040: 
            case 1041: {
                return Color.CYAN;
            }
            case 1020: {
                return Color.BLACK;
            }
            case 1043: 
            case 1044: {
                return new Color(200, 255, 200);
            }
            case 1047: {
                return Color.ORANGE;
            }
            case 1053: {
                return Color.LIGHT_GRAY;
            }
        }
        return Color.GRAY;
    }

    public void paintComponent(Graphics g, int left, int top, int width, int height) {
        g.setColor(this.getColour());
        g.fillRect(left, top, width, height);
    }

    public int getLithID() {
        return this.lithID;
    }

    public String getDescr() {
        return this.descr;
    }

    public String getAbr() {
        return this.abr;
    }

    public char getCmp() {
        return this.cmp;
    }

    public float getGrainSize() {
        return this.grainSize;
    }

    public void setGrainSize(float f) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to modify lithology");
        }
        this.grainSize = f;
    }

    public void setSortOrder(int i) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to modify lithology");
        }
        this.sortOrder = i;
    }

    public void update(Lithology rhs) throws SQLException, SBException {
        if (this.lithID != rhs.lithID) {
            throw new SBException("Attempt to update lithology with wrong matching ID: " + this.lithID + "/" + rhs.lithID);
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("lithdesc") + " SET descr=" + util.SB.DBString((String)rhs.descr) + ",abr=" + util.SB.DBString((String)rhs.abr) + ",grain_size=" + rhs.getGrainSize() + ",sort_order=" + rhs.sortOrder + " WHERE lith_id=" + this.lithID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.descr = rhs.descr;
        this.abr = rhs.abr;
        this.grainSize = rhs.grainSize;
        this.sortOrder = rhs.sortOrder;
    }

    public void setDescr(String toString) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to modify lithology");
        }
        this.descr = toString;
    }

    public void setAbr(String toString) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to modify lithology");
        }
        this.abr = toString;
    }

    void setLithID(int lithID) {
        this.lithID = lithID;
    }
}

