/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import util.SB;
import util.SBException;

public class LogFile {
    int nCurves;
    int FIELD_WIDTH = 10;
    int headerType = 0;
    boolean isLAS = false;
    String filePath;
    char depthUnits = '\u0000';
    private boolean hasFormatException = false;
    TreeSet<LogValue> records = new TreeSet(new CompareLogValue());
    List fileHeaders = new LinkedList();
    ArrayList<CurveHeader> curveHeaders = new ArrayList();
    final int CURVE_INFORMATION = 1;
    final int PARAMETERS = 2;
    final int WELL_INFORMATION = 3;
    final int VERSION_INFORMATION = 4;

    public String getPath() {
        return this.filePath;
    }

    public String getMnem(int curve) {
        return this.curveHeaders.get(curve).getMnem();
    }

    public Iterator<CurveHeader> getCurveHeaders() {
        return this.curveHeaders.iterator();
    }

    public char getDepthUnits() {
        return this.depthUnits;
    }

    public TreeSet<LogValue> getRecords() {
        return this.records;
    }

    public boolean hasformatException() {
        return this.hasFormatException;
    }

    public LogFile(File file) throws IOException {
        String buff;
        this.filePath = file.getPath();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((buff = in.readLine()) != null) {
            if (buff.trim().length() == 0) continue;
            if (buff.startsWith("~V")) {
                this.isLAS = true;
                in.close();
                this.readLAS(file);
                break;
            }
            if (buff.startsWith("#")) continue;
            in.close();
            this.readFlat(file);
            break;
        }
    }

    private void readLAS(File file) throws IOException {
        String buff;
        BufferedReader in = new BufferedReader(new FileReader(file));
        boolean dataBlock = false;
        int curveCounter = 0;
        LogValue logValue = null;
        while ((buff = in.readLine()) != null) {
            if (!dataBlock) {
                if (buff.length() <= 0) continue;
                block2 : switch (buff.charAt(0)) {
                    case '~': {
                        if (buff.substring(1).toLowerCase().startsWith("c")) {
                            this.headerType = 1;
                            break;
                        }
                        if (buff.substring(1).toLowerCase().startsWith("p")) {
                            this.headerType = 2;
                            break;
                        }
                        if (buff.substring(1).toLowerCase().startsWith("w")) {
                            this.headerType = 3;
                            break;
                        }
                        if (buff.substring(1).toLowerCase().startsWith("v")) {
                            this.headerType = 4;
                            break;
                        }
                        if (buff.substring(1).toLowerCase().startsWith("a")) {
                            this.headerType = 0;
                            dataBlock = true;
                            break;
                        }
                        this.headerType = 0;
                        break;
                    }
                    case '#': {
                        break;
                    }
                    default: {
                        switch (this.headerType) {
                            case 1: {
                                CurveHeader header = new CurveHeader();
                                int dotInd = buff.indexOf(46);
                                int colonInd = buff.indexOf(58);
                                try {
                                    header.mnem = buff.substring(0, dotInd).trim();
                                    header.units = buff.substring(dotInd + 1, dotInd + 7).trim();
                                    if (header.units != null) {
                                        header.units = header.units.toUpperCase();
                                    }
                                    header.SPIcodes = buff.substring(dotInd + 7, colonInd).trim();
                                    header.description = buff.substring(colonInd + 1).trim();
                                }
                                catch (StringIndexOutOfBoundsException ex) {
                                    System.out.println("Out of bounds exception for string: " + buff);
                                }
                                if (header.mnem == null || !header.mnem.startsWith("DEPT") && !header.mnem.equals("MD")) {
                                    this.curveHeaders.add(header);
                                    ++this.nCurves;
                                    break block2;
                                }
                                if (header.units == null) break block2;
                                if (header.units.startsWith("F")) {
                                    this.depthUnits = (char)70;
                                    break block2;
                                }
                                if (!header.units.startsWith("M")) break block2;
                                this.depthUnits = (char)77;
                                break block2;
                            }
                            default: {
                                break block2;
                            }
                            case 3: {
                                if (!buff.trim().toUpperCase().startsWith("STRT")) break block2;
                                String units = buff.substring("STRT".length()).trim();
                                if (units.startsWith(".F")) {
                                    this.depthUnits = (char)70;
                                    break block2;
                                }
                                if (!units.startsWith(".M")) break block2;
                                this.depthUnits = (char)77;
                                break block2;
                            }
                            case 4: {
                                if (!buff.trim().toUpperCase().startsWith("WRAP.")) break block2;
                                buff = buff.replaceFirst("YES", "NO ");
                            }
                        }
                    }
                }
                if (dataBlock) continue;
                this.fileHeaders.add(buff);
                continue;
            }
            try {
                StringTokenizer tok = new StringTokenizer(buff);
                while (tok.hasMoreTokens()) {
                    double value = Double.parseDouble(tok.nextToken().trim());
                    if (curveCounter > 0 && curveCounter <= this.nCurves) {
                        logValue.values[curveCounter - 1] = value;
                    } else {
                        curveCounter = 0;
                        logValue = new LogValue();
                        logValue.depth = value;
                        this.records.add(logValue);
                    }
                    ++curveCounter;
                }
            }
            catch (NumberFormatException ex) {
                this.hasFormatException = true;
                System.out.println("Problem reading line: " + buff + ", error=" + ex.getMessage());
            }
        }
        in.close();
    }

    private void readFlat(File file) throws IOException {
        String buff;
        BufferedReader in = new BufferedReader(new FileReader(file));
        boolean dataBlock = false;
        int curveCounter = 0;
        LogValue logValue = null;
        while ((buff = in.readLine()) != null) {
            if (!dataBlock) {
                if (buff.length() <= 0) continue;
                boolean first = true;
                StringTokenizer tok = new StringTokenizer(buff, " ,;\t");
                while (tok.hasMoreTokens()) {
                    CurveHeader header = new CurveHeader();
                    header.mnem = tok.nextToken();
                    if (!first) {
                        this.curveHeaders.add(header);
                        ++this.nCurves;
                    } else if (header.mnem.toUpperCase().contains("F")) {
                        this.depthUnits = (char)70;
                    } else if (header.mnem.toUpperCase().contains("M")) {
                        this.depthUnits = (char)77;
                    }
                    first = false;
                }
                dataBlock = true;
                continue;
            }
            curveCounter = 0;
            try {
                StringTokenizer tok = new StringTokenizer(buff, " ,;\t");
                while (tok.hasMoreTokens()) {
                    String strg = tok.nextToken().trim();
                    if (strg.length() > 0) {
                        double value = Double.parseDouble(strg);
                        if (curveCounter > 0 && curveCounter <= this.nCurves) {
                            logValue.values[curveCounter - 1] = value;
                        } else {
                            curveCounter = 0;
                            logValue = new LogValue();
                            logValue.depth = value;
                            this.records.add(logValue);
                        }
                    }
                    ++curveCounter;
                }
            }
            catch (NumberFormatException ex) {
                this.hasFormatException = true;
                System.out.println("Problem reading line: " + buff + ", error=" + ex.getMessage());
            }
        }
        in.close();
    }

    void writeLAS(String filePath) throws IOException, SBException {
        if (!this.isLAS) {
            throw new SBException("Cannot write LAS file from non-LAS source file");
        }
        FileWriter out = new FileWriter(filePath);
        String eol = "\r\n";
        Iterator ith = this.fileHeaders.iterator();
        while (ith.hasNext()) {
            out.write(ith.next() + eol);
        }
        out.write("~A   DEPTH");
        for (CurveHeader h : this.curveHeaders) {
            out.write(this.pad(h.mnem));
        }
        out.write(eol);
        for (LogValue logValue : this.records) {
            out.write(this.pad(SB.floatString((double)logValue.depth, (int)3)));
            for (int j = 0; j < this.nCurves; ++j) {
                out.write(this.pad(SB.floatString((double)logValue.values[j], (int)3)));
            }
            out.write(eol);
        }
        out.close();
    }

    String pad(String s) {
        while (s.length() < this.FIELD_WIDTH) {
            s = ' ' + s;
        }
        return s;
    }

    public class CurveHeader {
        String mnem;
        String units;
        String SPIcodes;
        String description;

        public String getMnem() {
            return this.mnem;
        }
    }

    class CompareLogValue
    implements Comparator {
        CompareLogValue() {
        }

        public int compare(Object l1, Object l2) {
            LogValue log1 = (LogValue)l1;
            LogValue log2 = (LogValue)l2;
            if (log1.depth < log2.depth) {
                return -1;
            }
            if (log1.depth > log2.depth) {
                return 1;
            }
            return 0;
        }
    }

    public class LogValue {
        double depth;
        double[] values;

        public LogValue() {
            this.values = new double[LogFile.this.nCurves];
        }
    }
}

