/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import model2.Audit;
import model2.SBdb;
import model2.SeismicMarker;
import model2.Userdef;
import util.SBException;

public class Markers
extends Observable {
    private SBdb SB;
    private ArrayList<SeismicMarker> list = new ArrayList();

    public Markers(SBdb SB2) {
        this.SB = SB2;
    }

    void clear() {
        this.list.clear();
    }

    public SeismicMarker get(int i) {
        return this.list.get(i);
    }

    public int getSize() {
        return this.list.size();
    }

    public List<SeismicMarker> getList() {
        return this.list;
    }

    public boolean add(SeismicMarker seismicMarker) throws SBException {
        this.list.add(this.checkOverlap(seismicMarker), seismicMarker);
        this.setChanged();
        return true;
    }

    public int checkOverlap(SeismicMarker marker) throws SBException {
        Iterator<SeismicMarker> it = this.list.iterator();
        int insertPoint = 0;
        int nzD = (int)(marker.getDepth() * 100.0);
        while (it.hasNext()) {
            SeismicMarker compareWith = it.next();
            if (compareWith == marker || !marker.getName().equals(compareWith.getName())) continue;
            throw new SBException("Seismic marker already exists: " + marker.toString() + "/" + compareWith);
        }
        for (SeismicMarker compareWith : this.list) {
            if (compareWith != marker) {
                int cD = (int)(compareWith.getDepth() * 100.0);
                if (nzD == cD) {
                    throw new SBException("Seismic marker depth already exists: " + marker.toString());
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return -1;
        }
        return insertPoint;
    }

    public void load(int wellID) throws SQLException {
        String sql = "SELECT depth, name, red, green, blue," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("WELLSMARK") + " WHERE well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            double depth = rs.getDouble("depth");
            String name = rs.getString("name");
            Color colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
            SeismicMarker seismicMarker = new SeismicMarker(depth, name, colour, new Audit(rs));
            seismicMarker.status = SeismicMarker.STORED;
            try {
                this.add(seismicMarker);
            }
            catch (SBException e) {
                System.out.println("Error adding marker: " + e.getMessage());
            }
        }
        stmt.close();
    }

    public void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("WELLSMARK") + " WHERE well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.setChanged();
    }

    public void delete(int wellID, SeismicMarker marker) throws SQLException, SBException {
        if (this.SB != null && this.SB.isConnected()) {
            marker.delete(this.SB, wellID);
        }
        this.list.remove(marker);
        this.setChanged();
    }

    public void store(int wellID) throws SQLException {
        Iterator<SeismicMarker> it = this.list.iterator();
        boolean refresh = false;
        while (it.hasNext()) {
            if (it.next().status != SeismicMarker.NOTSTORED) continue;
            refresh = true;
            break;
        }
        if (!refresh) {
            return;
        }
        this.deleteAll(wellID);
        it = this.list.iterator();
        while (it.hasNext()) {
            it.next().store(this.SB, wellID);
        }
    }

    void refresh(Statement stmt, int wellID) throws SQLException, SBException {
        String sql = "SELECT depth,updated ";
        sql = sql + " FROM " + this.SB.DBTableName("WELLSMARK") + " WHERE well_id=" + wellID;
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        SeismicMarker notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        boolean reload = false;
        while (rs.next()) {
            int key = (int)(rs.getDouble("depth") * 1000.0);
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (SeismicMarker o : this.list) {
                if ((int)(o.getDepth() * 1000.0) != key) continue;
                found = true;
                if (time == null || !time.after(o.getUpdated())) break;
                reload = true;
                notifier = o;
                break;
            }
            if (found) continue;
            reload = true;
            break;
        }
        if (reload || keys.size() < this.list.size()) {
            if (notifier == null) {
                notifier = this.list.get(0);
            }
            this.load(wellID);
            this.setChanged();
            if (notifier == null) {
                notifier = this.list.get(0);
            }
            this.notifyObservers(notifier);
        }
    }

    void setIntervalStatus(Color status) {
        Iterator<SeismicMarker> it = this.list.iterator();
        while (it.hasNext()) {
            it.next().status = status;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        Iterator<SeismicMarker> it = this.list.iterator();
        while (it.hasNext()) {
            it.next().writeDEX(out, eol, units);
        }
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        Iterator<SeismicMarker> it = this.list.iterator();
        while (it.hasNext()) {
            it.next().writeXML(out, indent, units);
        }
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for seismic markers");
        }
        Iterator<SeismicMarker> it = this.list.iterator();
        while (it.hasNext()) {
            it.next().setAnalyst(analyst);
        }
    }
}

