/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import model2.Audit;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.InterpHdr;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WsWell;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class OWXLSReader {
    SBdb ws;
    char units;
    IGDScheme scheme;
    int igdType;
    List<String> nonInserts = new LinkedList<String>();
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public List getNonInserts() {
        return this.nonInserts;
    }

    public OWXLSReader(SBdb ws, File file, char units, IGDScheme scheme, int igdType) throws SBException, SQLException, IOException, InvalidFieldException, InvalidFormatException {
        this.ws = ws;
        this.units = units;
        this.scheme = scheme;
        this.igdType = igdType;
        Workbook wb = WorkbookFactory.create((File)file);
        for (int j = 0; j < wb.getNumberOfSheets(); ++j) {
            Sheet sheet = wb.getSheetAt(j);
            System.out.println("processing sheet: " + wb.getSheetName(j) + "\n");
            this.parseSheet(sheet);
        }
    }

    final void parseSheet(Sheet sheet) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFieldException {
        String[] usedColumns = new String[]{"Well name", "Surface name", "Obs", "Depth", "Create date", "Update date"};
        int[] cellIndex = new int[]{0, 0, 0, 0, 0, 0};
        boolean WELL_NAME = false;
        boolean SURFACE_NAME = true;
        int OBS = 2;
        int DEPTH = 3;
        int CREATED = 4;
        int UPDATED = 5;
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null for sheet: " + sheet.getSheetName());
            return;
        }
        for (int cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); ++cellNum) {
            Cell cell = titleRow.getCell(cellNum);
            if (cell == null) {
                System.out.println("Can't get cell for cellNum: " + cellNum);
                continue;
            }
            System.out.println("Cell " + cellNum + " content: " + cell.toString());
            System.out.println("Cell value: " + cell.getStringCellValue());
            for (int i = 0; i < usedColumns.length; ++i) {
                String columnTitle = cell.getStringCellValue().trim();
                if (!columnTitle.equalsIgnoreCase(usedColumns[i])) continue;
                cellIndex[i] = cellNum;
            }
        }
        for (int i = 0; i < cellIndex.length; ++i) {
            if (cellIndex[i] != 0) continue;
            throw new SBException("Can't find a column in spreasheet with title: " + usedColumns[i]);
        }
        String lastWellName = null;
        LinkedList<OWPick> wellData = new LinkedList<OWPick>();
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            String dateString;
            String wellName;
            Row row = sheet.getRow(nRow);
            if (row == null || (wellName = row.getCell(cellIndex[0]).getStringCellValue()) == null) continue;
            if (lastWellName != null && !wellName.equalsIgnoreCase(lastWellName)) {
                this.processWell(wellData, lastWellName);
                wellData.clear();
            }
            OWPick rowData = new OWPick();
            rowData.surfaceName = row.getCell(cellIndex[1]).getStringCellValue().trim();
            rowData.depth = SB.convToM((double)row.getCell(cellIndex[3]).getNumericCellValue(), (char)this.units);
            System.out.println("Surface name & depth: " + rowData.surfaceName + " " + rowData.depth);
            rowData.obs = (int)row.getCell(cellIndex[2]).getNumericCellValue();
            Cell cell = row.getCell(cellIndex[4]);
            if (cell != null) {
                try {
                    dateString = row.getCell(cellIndex[4]).getStringCellValue();
                    try {
                        if (dateString != null && dateString.length() > 0) {
                            rowData.created = this.df.parse(dateString);
                        }
                    }
                    catch (ParseException pe) {
                        System.out.println("Can't parse date: " + dateString);
                    }
                }
                catch (IllegalStateException ise) {
                    try {
                        rowData.created = row.getCell(cellIndex[4]).getDateCellValue();
                    }
                    catch (Exception ex) {
                        System.out.println("Can't parse date, exception: " + ex.toString());
                    }
                }
            }
            if ((cell = row.getCell(cellIndex[5])) != null) {
                try {
                    dateString = row.getCell(cellIndex[5]).getStringCellValue();
                    try {
                        if (dateString != null && dateString.length() > 0) {
                            rowData.modified = this.df.parse(dateString);
                        }
                    }
                    catch (ParseException pe) {
                        System.out.println("Can't parse date: " + dateString);
                    }
                }
                catch (IllegalStateException ise) {
                    try {
                        rowData.modified = row.getCell(cellIndex[5]).getDateCellValue();
                    }
                    catch (Exception ex) {
                        System.out.println("Can't parse date, exception: " + ex.toString());
                    }
                }
            }
            wellData.add(rowData);
            lastWellName = wellName;
        }
        if (lastWellName != null) {
            this.processWell(wellData, lastWellName);
        }
    }

    private void processWell(List<OWPick> wellData, String wellName) throws SQLException, SBException, FileNotFoundException, IOException, InvalidFieldException {
        WsWell well = new WsWell(this.ws);
        well.getHeader().setWellName(wellName);
        for (int row = 0; row < wellData.size(); ++row) {
            String uppInf;
            OWPick rowData = wellData.get(row);
            if (rowData.paired || !(uppInf = rowData.surfaceName.trim()).endsWith("Top")) continue;
            uppInf = uppInf.substring(0, uppInf.length() - "Top".length()).trim();
            Sample topSample = this.parseSample(well, rowData.depth, "LOG", true);
            Sample baseSample = null;
            boolean paired = false;
            for (int compare = 0; compare < wellData.size(); ++compare) {
                String baseRoot;
                OWPick compareData = wellData.get(compare);
                if (rowData.obs != compareData.obs || compareData.paired || rowData == compareData || !rowData.surfaceName.endsWith("Top") || !compareData.surfaceName.endsWith("Base") || !uppInf.equals(baseRoot = compareData.surfaceName.substring(0, compareData.surfaceName.length() - "Base".length()).trim())) continue;
                baseSample = this.parseSample(well, compareData.depth, "LOG", true);
                paired = true;
                compareData.paired = true;
                break;
            }
            if (!paired) {
                baseSample = topSample;
            }
            int topBnd = 3;
            int baseBnd = 3;
            int hier = IGDIntervalZone.getDefaultHier(this.igdType);
            IGDUnit unit = this.scheme.findUnit(uppInf);
            if (unit != null) {
                hier = unit.getHier();
            }
            IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.ws, this.igdType, topSample, baseSample, hier, this.scheme.getSchID()).topBnd(topBnd).baseBnd(baseBnd);
            builder.uppInf(uppInf).qUzone(false).qLzone(false).audit(new Audit(0, rowData.created, 0, rowData.modified));
            if (unit != null) {
                builder.uppZone(unit.getUnitID());
            }
            InterpHdr interp = this.ws.getInterp(0);
            if (rowData.obs > 1 && (interp = this.ws.getInterp("Version " + rowData.obs)) == null) {
                interp = new InterpHdr(this.ws, rowData.obs - 1, "Version " + rowData.obs);
            }
            try {
                well.getAddInterp(interp).addZone(builder, well);
                continue;
            }
            catch (SBException ex) {
                this.nonInserts.add("Well: " + well.toString() + " Interval: " + uppInf + " Depth: " + rowData.depth + " Reason: " + ex.getMessage());
                System.out.println(ex.toString());
                continue;
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (InvalidFieldException ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Adding well: " + well);
        this.ws.getProject(0).addWell(well);
        well.updateStatus();
    }

    Sample parseSample(Well well, double depth, String type, boolean useAnyType) throws SBException, SQLException, FileNotFoundException, IOException {
        well.getSamples();
        Sample sample = well.getSample(depth, type, useAnyType);
        if (sample == null) {
            sample = well.addSample(this.ws.useSampleTops() ? Double.valueOf(depth) : null, this.ws.useSampleTops() ? null : Double.valueOf(depth), type, null);
        }
        return sample;
    }

    class OWPick {
        String surfaceName;
        double depth;
        int obs;
        boolean paired = false;
        Date created;
        Date modified;

        OWPick() {
        }
    }
}

