/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2.AbnScheme;
import model2.Audit;
import model2.CoOccurrence;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.Userdef;
import model2.Well;
import model2.WellHeader;
import util.SB;
import util.SBException;

public class Project
extends Observable
implements Comparable {
    private int ID = 0;
    private String name = "<none>";
    private List<Well> wells = null;
    private Audit audit = new Audit();

    public Project(SBdb SB2, String name) throws SQLException, SBException {
        this.wells = new LinkedList<Well>();
        this.store(SB2, name);
        this.name = name;
    }

    public Project(SBdb SB2, String name, Userdef creator, Date created) throws SQLException, SBException {
        this.wells = new LinkedList<Well>();
        this.audit.creator = creator.getUsrID();
        this.audit.created = created;
        this.store(SB2, name);
        this.name = name;
    }

    public Project(SBdb SB2, int ID, boolean load) throws SQLException, SBException {
        if (ID > 0) {
            String sql = "SELECT name," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("SBWLLST") + " WHERE id=" + ID;
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            if (rs.next()) {
                this.name = rs.getString("name").trim();
                this.ID = ID;
                this.audit = new Audit(rs);
            }
            rs.close();
            if (load) {
                this.loadWells(SB2, stmt);
            }
            stmt.close();
        } else {
            this.wells = new LinkedList<Well>();
        }
    }

    public String getName() {
        return this.name;
    }

    public void writeWellLocations(BufferedWriter out, String eol) throws IOException {
        if (this.ID > 0) {
            out.write("<name>" + this.name + "</name>" + eol);
        }
        if (this.wells == null) {
            return;
        }
        for (Well w : this.wells) {
            WellHeader h = w.getHeader();
            if (h.getLat_dec() == null || h.getLong_dec() == null) continue;
            out.write("<Placemark>" + eol);
            out.write("<name>" + w.getWellName() + "</name>" + eol);
            out.write("<description>");
            String descrip = "";
            descrip = descrip + "Well code: " + w.getWellCode() + eol;
            if (w.getHeader().getDescrip() != null) {
                descrip = descrip + w.getHeader().getDescrip();
            }
            descrip = descrip + h.getCountry() + eol;
            descrip = descrip + h.getField() + eol;
            descrip = descrip + h.getOper() + eol;
            out.write(SB.getXMLstring((String)descrip) + "</description>" + eol);
            out.write("<Point>" + eol);
            out.write("<coordinates>" + h.getLong_dec() + "," + h.getLat_dec() + "</coordinates>" + eol);
            out.write("</Point>" + eol);
            out.write("</Placemark>" + eol);
        }
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public void update(SBdb SB2, String name) throws SQLException {
        Statement stmt = SB2.getDatabase().createStatement();
        Audit temp = new Audit(this.audit);
        String sql = "UPDATE " + SB2.DBTableName("SBWLLST") + " SET name=" + SB.DBString((String)name) + "," + temp.sqlUpdate(SB2, stmt, false) + " WHERE id=" + this.ID;
        stmt.executeUpdate(SB2.modQuery(sql));
        this.name = name;
        this.audit = temp;
        stmt.close();
        this.setChanged();
    }

    public Iterator<Well> getWellIterator() {
        if (this.wells == null) {
            this.wells = new LinkedList<Well>();
        }
        return this.wells.iterator();
    }

    public synchronized Well getWellAt(int index) {
        if (this.wells == null) {
            return null;
        }
        return this.wells.get(index);
    }

    void copy(Project rhs) {
        this.ID = rhs.ID;
        this.name = rhs.name;
        this.audit = new Audit(rhs.audit);
        this.wells = null;
    }

    void mergeOcc(SBdb db, CoOccurrence coOcc, boolean mergeAbundance) throws SQLException, SBException {
        Smpdtl smpdtl;
        Sample sample;
        Well well;
        boolean loaded = true;
        if (!this.contains(coOcc.getWellID())) {
            well = this.getWell(db, coOcc.getWellID());
            loaded = false;
        } else {
            well = this.getWell(db, coOcc.getWellID());
            well.loadSamples();
        }
        AbnScheme abn = db.getAbnScheme(well.getAnalystHeader(coOcc.analyID, true).getAbnSchID(), true);
        if (abn == null) {
            abn = db.getDefaultAbnScheme();
        }
        if (mergeAbundance) {
            coOcc.target.merge(coOcc.donor, abn);
        }
        coOcc.donor.delete(coOcc.wellID, coOcc.sampID, coOcc.analyID);
        if (mergeAbundance) {
            coOcc.target.delete(coOcc.wellID, coOcc.sampID, coOcc.analyID);
            coOcc.target.store(null, coOcc.wellID, coOcc.sampID, coOcc.analyID, abn);
        }
        if (loaded && (sample = well.getSample(coOcc.sampID)) != null && (smpdtl = sample.getSmpdtl(coOcc.analyID)) != null) {
            if (mergeAbundance) {
                smpdtl.replaceOcc(coOcc.wellID, coOcc.target);
            }
            smpdtl.removeOcc(coOcc.donor);
            smpdtl.notifyObservers();
        }
    }

    void updateTaxonRef(Taxon donor, Taxon target) throws SBException {
        if (this.wells == null) {
            return;
        }
        for (Well w : this.wells) {
            w.updateTaxonRef(donor, target);
        }
    }

    public int getSize() {
        return this.wells.size();
    }

    public int getID() {
        return this.ID;
    }

    public String toString() {
        return this.name;
    }

    public final void loadWells(SBdb SB2, Statement stmt) throws SQLException, SBException {
        if (this.wells == null) {
            this.wells = new LinkedList<Well>();
            if (this.ID > 0) {
                String sql = "SELECT well_id FROM " + SB2.DBTableName("SBWLMB") + " WHERE id=" + this.ID;
                boolean createdStatement = false;
                if (stmt == null) {
                    stmt = SB2.getDatabase().createStatement();
                    createdStatement = true;
                }
                ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
                while (rs.next()) {
                    this.addWell(SB2.getAddWell(rs.getInt("well_id")));
                }
                rs.close();
                if (createdStatement) {
                    stmt.close();
                }
            }
        }
    }

    public synchronized Well getWell(SBdb SB2, int wellID) throws SQLException, SBException {
        if (this.wells == null && this.ID == 0) {
            this.wells = new LinkedList<Well>();
        }
        for (Well well : this.wells) {
            if (well.wellID != wellID) continue;
            return well;
        }
        if (this.ID == 0) {
            Well well = new Well(SB2, wellID);
            this.addWell(well);
            this.setChanged();
            return well;
        }
        return null;
    }

    void updateAudit(SBdb SB2) throws SQLException {
        Audit temp = new Audit(this.audit);
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "UPDATE " + SB2.DBTableName("SBWLLST") + " SET " + temp.sqlUpdate(SB2, stmt, false) + " WHERE id=" + this.ID;
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
        this.audit = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(SBdb sbdb, Well well) throws SQLException {
        if (this.wells == null) {
            throw new IllegalStateException("Attempt to remove well from project when project not loaded");
        }
        if (this.wells.contains(well)) {
            if (sbdb.isConnected()) {
                Statement stmt = sbdb.getDatabase().createStatement();
                String sql = "DELETE FROM " + sbdb.DBTableName("SBWLMB") + " WHERE ID=" + this.ID + " AND WELL_ID=" + well.wellID;
                try {
                    stmt.executeUpdate(sbdb.modQuery(sql));
                }
                finally {
                    stmt.close();
                }
                this.updateAudit(sbdb);
            }
            this.wells.remove(well);
            this.setChanged();
            this.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeWell(SBdb SB2, Well well) throws SQLException {
        if (this.wells == null) {
            return false;
        }
        if (this.wells.contains(well)) {
            if (this.ID > 0) {
                Statement stmt = SB2.getDatabase().createStatement();
                String sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE ID=" + this.ID + " AND well_id=" + well.wellID;
                try {
                    stmt.executeUpdate(SB2.modQuery(sql));
                }
                finally {
                    stmt.close();
                }
                this.updateAudit(SB2);
            }
            this.wells.remove(well);
            this.setChanged();
            return true;
        }
        return false;
    }

    public synchronized void addWell(SBdb SB2, Well well) throws SQLException {
        if (this.wells == null) {
            this.wells = new LinkedList<Well>();
        }
        if (!this.wells.contains(well)) {
            if (this.ID > 0) {
                Statement stmt = SB2.getDatabase().createStatement();
                String sql = "INSERT INTO " + SB2.DBTableName("SBWLMB") + " (ID,well_id) VALUES (" + this.ID + "," + well.wellID + ")";
                stmt.executeUpdate(SB2.modQuery(sql));
                stmt.close();
                this.updateAudit(SB2);
            }
            this.wells.add(well);
            this.setChanged();
        }
    }

    public synchronized void addWells(SBdb SB2, List<Well> wells) throws SQLException {
        if (wells == null && this.ID == 0) {
            wells = new LinkedList<Well>();
        }
        for (Well w : wells) {
            this.addWell(SB2, w);
        }
        this.notifyObservers();
    }

    synchronized void addWell(Well well) {
        if (this.wells == null) {
            this.wells = new LinkedList<Well>();
        }
        if (!this.wells.contains(well)) {
            int insertPoint = 0;
            for (Well w : this.wells) {
                if (w.getWellCode().equals(well.getWellID())) {
                    System.out.println("Cannot add well: " + well + ", already loaded in project.");
                    return;
                }
                if (w.toString().compareToIgnoreCase(well.toString()) > 0) break;
                ++insertPoint;
            }
            this.wells.add(insertPoint, well);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public synchronized boolean contains(Well well) {
        return this.wells.contains(well);
    }

    public synchronized boolean contains(int wellID) {
        if (this.wells != null) {
            for (Well well : this.wells) {
                if (well == null) {
                    System.out.println("Well ID Null in Project.contains()!");
                    continue;
                }
                if (well.wellID != wellID) continue;
                return true;
            }
        }
        return false;
    }

    public final synchronized void store(SBdb SB2, String name) throws SQLException, SBException {
        String sql;
        if (name == null || name.length() == 0) {
            throw new SBException("Attempt to store well list with no name");
        }
        if (this.wells == null) {
            throw new SBException("No Database well list initiated");
        }
        Statement stmt = SB2.getDatabase().createStatement();
        if (this.ID > 0) {
            sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE id=" + this.ID;
            stmt.executeUpdate(SB2.modQuery(sql));
        } else {
            this.ID = SB2.nextControl("SBWLLST", "ID");
            sql = "INSERT INTO " + SB2.DBTableName("SBWLLST") + " (ID,name," + Audit.sqlFieldString() + ") VALUES (" + this.ID + "," + SB.DBString((String)name) + "," + this.audit.sqlInsert(SB2, stmt) + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        Iterator<Well> it = this.wells.iterator();
        while (it.hasNext()) {
            sql = "INSERT INTO " + SB2.DBTableName("SBWLMB") + " (ID,well_id) VALUES (" + this.ID + "," + it.next() + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        stmt.close();
    }

    public static void delete(SBdb SB2, String name) throws SQLException {
        int ID = 0;
        String sql = "SELECT id FROM " + SB2.DBTableName("SBWLLST") + " WHERE name='" + name + "'";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            ID = rs.getInt("id");
        }
        rs.close();
        if (ID > 0) {
            sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE id=" + ID;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SBWLLST") + " WHERE id=" + ID;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
    }

    public int compareTo(Object o) {
        if (o instanceof Project) {
            return this.name.compareToIgnoreCase(((Project)o).name);
        }
        return 0;
    }

    public Well getTopDepth() throws SBException, SQLException {
        return this.getDepth(true, false);
    }

    public Well getBaseDepth(boolean useTVD) throws SBException, SQLException {
        return this.getDepth(false, useTVD);
    }

    private synchronized Well getDepth(boolean top, boolean useTVD) throws SBException, SQLException {
        Double depth = null;
        Well w = null;
        Iterator<Well> wellIterator = this.getWellIterator();
        while (wellIterator.hasNext()) {
            Well well = wellIterator.next();
            if (top) {
                double topDepth = well.getTopSampleDepth();
                if (depth != null && !(topDepth < depth)) continue;
                depth = topDepth;
                w = well;
                continue;
            }
            double baseDepth = 0.0;
            if (useTVD) {
                baseDepth = well.getTVDlist(false).getBaseTVD();
            }
            if (baseDepth == 0.0) {
                baseDepth = well.getBaseSampleDepth();
            }
            if (depth != null && !(baseDepth > depth)) continue;
            depth = baseDepth;
            w = well;
        }
        return w;
    }
}

