/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import model2.Project;
import model2.SBdb;
import model2.Userdef;
import model2.Well;
import util.InvalidFieldException;
import util.SBException;

public class ProjectList
extends Observable {
    SBdb SB;
    private List<Project> projects = new LinkedList<Project>();

    public ProjectList(SBdb db) throws SQLException, SBException {
        this.SB = db;
        if (db != null && db.isConnected()) {
            String sql = "SELECT id FROM " + this.SB.DBTableName("SBWLLST");
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("id");
                Project list = new Project(this.SB, ID, false);
                this.projects.add(list);
            }
            rs.close();
            stmt.close();
        }
        Collections.sort(this.projects);
        this.projects.add(0, new Project(this.SB, 0, false));
    }

    public void removeWell(Well well) throws SQLException {
        for (Project p : this.projects) {
            if (!p.removeWell(this.SB, well)) continue;
            p.notifyObservers();
        }
    }

    public void delete(Project project) throws SQLException, SBException {
        if (project.getID() == 0) {
            throw new SBException("Cannot delete default project (ID=0)");
        }
        for (Project p : this.projects) {
            if (p != project) continue;
            this.projects.remove(p);
            break;
        }
        Project.delete(this.SB, project.getName());
        this.setChanged();
        this.notifyObservers();
    }

    Project getProject(int ID) throws SQLException, SBException {
        Project project = null;
        if (ID == 0) {
            project = this.projects.get(0);
        } else {
            for (Project p : this.projects) {
                if (p.getID() != ID) continue;
                project = p;
                break;
            }
        }
        if (project == null) {
            project = new Project(this.SB, ID, true);
        }
        return project;
    }

    public Project getProject(String name) throws SQLException, SBException {
        Object project = null;
        for (Project p : this.projects) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public void add(String name) throws SQLException, SBException, InvalidFieldException {
        if (this.getProject(name) != null) {
            throw new InvalidFieldException("Project to be added already exists");
        }
        Project project = new Project(this.SB, name);
        int insertPoint = 0;
        for (Project p : this.projects) {
            if (p.getName().compareToIgnoreCase(name) > 0) break;
            ++insertPoint;
        }
        this.projects.add(insertPoint, project);
        this.setChanged();
    }

    public Project add(String name, Userdef creator, Date created) throws SQLException, SBException {
        if (this.getProject(name) != null) {
            throw new SBException("Project to be added already exists");
        }
        Project project = new Project(this.SB, name, creator, created);
        int insertPoint = 0;
        for (Project p : this.projects) {
            if (insertPoint != 0 && p.getName().compareToIgnoreCase(name) > 0) break;
            ++insertPoint;
        }
        this.projects.add(insertPoint, project);
        this.setChanged();
        return project;
    }

    public void loadList(DefaultListModel model, boolean includeDefault) {
        LinkedList<Project> lp = new LinkedList<Project>();
        for (Project p : this.projects) {
            if (p.getID() <= 0 && !includeDefault) continue;
            lp.add(p);
        }
        Collections.sort(lp);
        for (Project p : lp) {
            model.addElement(p);
        }
    }

    public void loadCombo(DefaultComboBoxModel model, boolean includeDefault) {
        for (Project p : this.projects) {
            if (p.getID() <= 0 && !includeDefault) continue;
            model.addElement(p);
        }
    }

    public int size() {
        if (this.projects == null) {
            return 0;
        }
        return this.projects.size();
    }

    synchronized void refresh(Statement stmt, SBdb SB2) throws SQLException, SBException {
        String sql = "SELECT id,updated FROM " + SB2.DBTableName("SBWLLST");
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        Project notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        keys.add(0);
        while (rs.next()) {
            int key = rs.getInt("id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Project o : this.projects) {
                if (o.getID() != key) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                Project project = new Project(SB2, key, false);
                o.copy(project);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = new Project(SB2, key, false);
            this.projects.add(notifier);
        }
        if (keys.size() < this.projects.size()) {
            Iterator<Project> it = this.projects.iterator();
            while (it.hasNext()) {
                Project o = it.next();
                if (keys.contains(o.getID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }
}

