/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import model2.QualComparator;
import model2.TaxonQual;

public class Qualifier {
    private TaxonQual[] quals;
    private final int qual;

    public Qualifier(int qual) {
        this.qual = qual;
    }

    public Qualifier(int qual, TaxonQual tq) {
        this.qual = qual;
        this.quals = new TaxonQual[]{tq};
    }

    Qualifier(String s, int qual) {
        this.qual = qual;
        this.quals = TaxonQual.parse(s, qual);
    }

    public String toString(Boolean start) {
        String s = "";
        if (this.quals == null || this.quals.length == 0) {
            return s;
        }
        for (TaxonQual q : this.quals) {
            if (!s.isEmpty()) {
                s = s + " ";
            }
            s = s + (Object)((Object)q);
        }
        if (start == null) {
            return s;
        }
        if (start.booleanValue()) {
            return s + (this.quals[this.quals.length - 1].whitespace ? " " : "");
        }
        return (this.quals[0].whitespace ? " " : "") + s;
    }

    public String toString() {
        return this.toString(null);
    }

    public boolean hasQuals() {
        return this.quals != null;
    }

    public boolean hasQual(TaxonQual qual) {
        if (this.quals == null) {
            return false;
        }
        for (TaxonQual q : this.quals) {
            if (q != qual) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object q) {
        if (!(q instanceof Qualifier)) {
            return false;
        }
        return this.toString(null).equals(((Qualifier)q).toString(null));
    }

    public Qualifier copy() {
        Qualifier newQual = new Qualifier(this.qual);
        if (this.quals != null) {
            newQual.quals = new TaxonQual[this.quals.length];
            System.arraycopy(this.quals, 0, newQual.quals, 0, this.quals.length);
        }
        return newQual;
    }

    public TaxonQual getSingle() {
        if (this.quals == null) {
            return null;
        }
        if (this.quals.length == 1) {
            return this.quals[0];
        }
        return null;
    }

    public boolean addQual(TaxonQual toAdd) {
        if (this.hasQual(toAdd) || toAdd.position[this.qual] < 0) {
            return false;
        }
        if (this.quals == null) {
            this.quals = new TaxonQual[]{toAdd};
            return true;
        }
        for (int i = 0; i < this.quals.length; ++i) {
            if (!this.quals[i].isMutuallyExclusive(toAdd, this.qual)) continue;
            this.quals[i] = toAdd;
            return false;
        }
        LinkedList<TaxonQual> list = new LinkedList<TaxonQual>();
        list.addAll(Arrays.asList(this.quals));
        list.add(toAdd);
        Collections.sort(list, new QualComparator(this.qual));
        this.quals = list.toArray(new TaxonQual[list.size()]);
        return true;
    }

    int getPos() {
        return this.qual;
    }
}

