/*
 * Decompiled with CFR 0.152.
 */
package model2;

import model2.Project;
import model2.SBdb;

public class Queries {
    private static DBQuery[] queries;
    private static final int nQueries = 2;
    private static final int AGE_AT_FORMATION = 0;
    private static final int TD = 1;

    private Queries() {
    }

    public static DBQuery getAgeAtFormationQuery(Project p, String unit) {
        if (unit == null || unit.isEmpty()) {
            throw new IllegalArgumentException("Illegal unit name to Age at Formation query: " + unit);
        }
        final Project project = p;
        final String unitName = unit;
        if (queries[0] == null) {
            Queries.queries[0] = new DBQuery(){

                @Override
                String getName() {
                    return "Chronostrat/age at formation";
                }

                @Override
                String getQuery(SBdb sbdb) {
                    String sql = "SELECT ip.DESCRIP as Version,w.well_name,nvl(s1.base_depth,s1.top_depth) as top,nvl(s2.base_depth,s2.top_depth) as base,ic.upp_inf as InformalUpper, ic.low_inf as InformalLower,dc.u_age, dc.L_AGE, dc.NAME \nFROM " + sbdb.DBTableName("samples") + " s1, " + sbdb.DBTableName("samples") + " s2, " + sbdb.DBTableName("igd") + " ic, " + sbdb.DBTableName("wells") + " w, " + sbdb.DBTableName("well_ident") + " v, " + sbdb.DBTableName("igd_dict") + " dc, " + sbdb.DBTableName("interp") + " ip ";
                    if (project != null) {
                        sql = sql + ", " + sbdb.DBTableName("sbwllst") + " wl, " + sbdb.DBTableName("sbwlmb") + " wb ";
                    }
                    sql = sql + "\nWHERE ic.igd_type=3 and ip.INTERP_ID=ic.INTERP_ID \nAND ic.TOP_ID=s1.SAMP_ID and ic.BASE_ID=s2.SAMP_ID ";
                    if (project != null) {
                        sql = sql + "\nAND wl.ID=wb.ID and wl.NAME='" + project.getName() + "' AND v.WELL_ID=wb.WELL_ID ";
                    }
                    sql = sql + "\nAND  s1.well_id=ic.well_id and s2.well_id=ic.well_id and ic.well_id=v.well_id  \nAND v.well_code=w.well_code and ic.UPP_ZONE(+)=dc.IGD_ID \nAND nvl(s1.base_depth,s1.top_depth)<= (SELECT nvl(s3.base_depth,s3.top_depth) FROM " + sbdb.DBTableName("samples") + " s3, " + sbdb.DBTableName("igd") + " il, " + sbdb.DBTableName("igd_dict") + " d where il.upp_zone=d.IGD_ID " + "\nAND d.name='" + unitName + "' AND il.well_id=v.WELL_ID and s3.WELL_ID=il.WELL_ID and s3.SAMP_ID=il.TOP_ID) and nvl(s2.base_depth,s2.top_depth)>=(SELECT nvl(s3.base_depth,s3.top_depth) from " + sbdb.DBTableName("samples") + " s3, " + sbdb.DBTableName("igd") + " il, " + sbdb.DBTableName("igd_dict") + " d where il.upp_zone=d.IGD_ID " + "\nAND d.name='" + unitName + "' and il.well_id=v.WELL_ID and s3.WELL_ID=il.WELL_ID and s3.SAMP_ID=il.TOP_ID ) " + "\nORDER BY well_name, top, base";
                    return sql;
                }
            };
        }
        return queries[0];
    }

    public static DBQuery getTDQuery() {
        if (queries[1] == null) {
            Queries.queries[1] = new DBQuery(){

                @Override
                String getName() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                String getQuery(SBdb sbdb) {
                    return "select w.well_name as Well_Name, w.td as TD, i.upp_inf AS Interval_Upper, i.low_inf AS Interval_Lower, s1.base_depth as Top_Depth, s2.base_depth as Base_Depth \nFROM " + sbdb.DBTableName("wells") + " w, " + sbdb.DBTableName("igd") + " i, " + sbdb.DBTableName("well_ident") + " v, " + sbdb.DBTableName("samples") + " s1, " + sbdb.DBTableName("samples") + " s2 " + "\nWHERE v.well_id=i.well_id and v.well_code=w.well_code and s1.well_id=v.well_id and " + "\ns2.well_id=v.well_id and i.top_id=s1.samp_id and i.base_id=s2.samp_id and (s1.base_depth >= w.td-30 or s2.base_depth >= w.td-30)";
                }
            };
        }
        return queries[1];
    }

    public static DBQuery[] getQueries() {
        if (queries == null) {
            queries = new DBQuery[2];
        }
        for (int i = 0; i < 2; ++i) {
            if (queries[i] != null) continue;
            switch (i) {
                default: 
            }
        }
        DBQuery[] retval = new DBQuery[2];
        System.arraycopy(queries, 0, retval, 0, 2);
        return retval;
    }

    public static abstract class DBQuery {
        abstract String getName();

        abstract String getQuery(SBdb var1);

        public String toString() {
            return this.getName();
        }
    }
}

