/*
 * Decompiled with CFR 0.152.
 */
package model2;

import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.PlanarImage;
import javax.swing.ImageIcon;
import model2.SBdb;
import org.jdom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import util.SB;
import util.SBException;

public class SBImage {
    SBdb SB;
    private ImageIcon image = null;
    private ImageIcon imageThumb = null;
    private ImageIcon sizedImage = null;
    private int imageID = 0;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private String picPath;
    private String zipPath;
    private String caption;
    SBImage link = null;
    boolean isUnreferenced = false;

    SBImage(SBdb SB2, int imageID) throws SQLException {
        this.SB = SB2;
        this.imageID = imageID;
        this.loadDetails();
    }

    SBImage(SBdb SB2, String picPath) throws SQLException {
        this.SB = SB2;
        this.picPath = picPath;
        this.caption = picPath;
        this.isUnreferenced = true;
    }

    public SBImage(SBdb SB2, File file, boolean create, boolean storeImageInDatabase) throws SBException, SQLException, FileNotFoundException, IOException {
        this.picPath = file.getPath();
        this.image = this.getImageIcon(this.picPath);
        this.SB = SB2;
        if (create) {
            this.store(storeImageInDatabase);
        }
    }

    public String getZipPath() {
        return this.zipPath;
    }

    ImageIcon getImageIcon(String picPath) throws IOException {
        ImageIcon imageIcon;
        if (picPath.toLowerCase().contains(".tif")) {
            System.out.println("Reading tiff file into buffered image ...");
            FileSeekableStream s = new FileSeekableStream(new File(picPath));
            ImageDecodeParam param = null;
            ImageDecoder dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)s, param);
            RenderedImage op = dec.decodeAsRenderedImage(0);
            imageIcon = new ImageIcon(PlanarImage.wrapRenderedImage((RenderedImage)op).getAsBufferedImage());
        } else {
            System.out.println("Creating image from file: " + picPath);
            imageIcon = new ImageIcon(picPath);
        }
        return imageIcon;
    }

    SBImage(SBdb db, Element xml, ZipFile zip) throws SBException {
        String strg = xml.getChildTextNormalize("ImageID");
        if (strg == null) {
            throw new SBException("ID null in XML - invalid");
        }
        this.imageID = Integer.parseInt(strg);
        this.SB = db;
        String fileName = xml.getChildTextNormalize("File");
        this.caption = xml.getChildTextNormalize("Caption");
        this.picPath = fileName;
        this.zipPath = zip.getName();
    }

    SBImage(SBdb SB2, SBImage rhs) throws SQLException, SBException, FileNotFoundException, IOException {
        this.SB = SB2;
        this.caption = rhs.caption;
        this.zipPath = rhs.zipPath;
        this.picPath = rhs.picPath;
        this.image = rhs.image;
        if (SB2 != null && SB2.isConnected()) {
            this.store(SB2.storeImage());
            this.image = null;
        } else {
            this.link = rhs;
        }
    }

    void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    void displayMetadata(Node node, int level) {
        Node child;
        this.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            System.out.println(">");
            while (child != null) {
                this.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            this.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    void delete() throws SBException, SQLException {
        if (this.imageID == 0) {
            throw new SBException("Attempt to delete image with no ID");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID;
        int nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.imageID = 0;
    }

    public int getImageID() {
        return this.imageID;
    }

    public ImageIcon getImage() throws SQLException, SBException, IOException {
        this.load();
        return this.image;
    }

    public void clearImage() {
        this.image = null;
    }

    public String getCaption() throws SQLException, SBException {
        return this.caption;
    }

    public ImageIcon getImage(int maxWidth, int maxHeight, boolean clearImage) throws SQLException, SBException, IOException {
        if (maxWidth != this.lastWidth || this.lastHeight != maxHeight) {
            this.load();
            if (this.image != null) {
                float overHeight;
                Image i = this.image.getImage();
                float overWidth = (float)this.image.getIconWidth() / (float)maxWidth;
                Image resizedImage = overWidth > (overHeight = (float)this.image.getIconHeight() / (float)maxHeight) ? i.getScaledInstance(maxWidth, -1, 2) : i.getScaledInstance(-1, maxHeight, 2);
                this.sizedImage = new ImageIcon(resizedImage);
                this.lastWidth = maxWidth;
                this.lastHeight = maxHeight;
                if (clearImage) {
                    this.clearImage();
                }
            }
        }
        return this.sizedImage;
    }

    public ImageIcon getThumb(int maxSize) throws SQLException, SBException, IOException {
        if (this.imageThumb != null) {
            return this.imageThumb;
        }
        this.load();
        if (this.image != null) {
            int iHeight;
            Image i = this.image.getImage();
            int iWidth = i.getWidth(null);
            Image resizedImage = iWidth > (iHeight = i.getHeight(null)) ? i.getScaledInstance(maxSize, maxSize * iHeight / iWidth, 2) : i.getScaledInstance(maxSize * iWidth / iHeight, maxSize, 2);
            this.imageThumb = new ImageIcon(resizedImage);
            this.clearImage();
        }
        return this.imageThumb;
    }

    public String getPath() {
        return this.picPath;
    }

    void export(File folder) throws SQLException, SBException, FileNotFoundException, IOException {
        File originalFile;
        String sql;
        ResultSet rs;
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.picPath == null && this.image == null && (rs = stmt.executeQuery(sql = "SELECT pic_path FROM " + this.SB.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID)).next()) {
            this.picPath = rs.getString("pic_path");
        }
        boolean fileExists = false;
        if (this.picPath != null && (originalFile = new File(this.picPath)).exists()) {
            fileExists = true;
        }
        if (fileExists) {
            sql = "UPDATE " + this.SB.DBTableName("SBIMAGE") + " SET image_data=NULL WHERE image_id=" + this.imageID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        } else {
            this.picPath = folder + File.separator + "sbugs_" + this.imageID + ".jpg";
            this.writeImage(new File(this.picPath));
            sql = "UPDATE " + this.SB.DBTableName("sbimage") + " SET pic_path=?, image_data=NULL WHERE image_id=" + this.imageID;
            PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
            pStmt.setString(1, this.picPath);
            pStmt.executeUpdate();
        }
    }

    public void writeImage(File jpeg) throws SQLException, SBException, IOException {
        this.load();
        Image img = this.image.getImage();
        if (img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            System.out.println("Failed to load/write image: " + this.image.getDescription() + " ImageID=" + this.imageID);
        }
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 5);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        ImageIO.write((RenderedImage)bi, "jpg", jpeg);
        this.image = null;
    }

    public void writeImage(int width, int height, OutputStream jpeg) throws SQLException, SBException, IOException {
        this.load();
        if (this.image == null) {
            return;
        }
        ImageIcon icon = this.getImage(width, height, true);
        Image img = icon.getImage();
        BufferedImage bi = new BufferedImage(width, height, 5);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        if (!ImageIO.write((RenderedImage)bi, "jpg", jpeg)) {
            throw new SBException("No image writer found in writeImage");
        }
        this.image = null;
    }

    public String saveToFile() throws SQLException, SBException, IOException {
        String sql;
        ResultSet rs;
        String fileName = null;
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.picPath == null && this.image == null && (rs = stmt.executeQuery(sql = "SELECT pic_path FROM " + this.SB.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID)).next()) {
            this.picPath = rs.getString("pic_path");
        }
        boolean fileExists = false;
        if (this.picPath != null) {
            File originalFile = new File(this.picPath);
            if (originalFile.exists()) {
                fileExists = true;
            }
        } else {
            this.load();
            Image img = this.image.getImage();
            BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 5);
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(img, 0, 0, null);
            g2.dispose();
            this.picPath = File.separator + "sbugs_" + this.imageID + ".jpg";
            ImageIO.write((RenderedImage)bi, "jpg", new File(this.picPath));
            sql = "UPDATE " + this.SB.DBTableName("sbimage") + " SET pic_path=?, image_data=NULL WHERE image_id=" + this.imageID;
            PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
            pStmt.setString(1, this.picPath);
            pStmt.executeUpdate();
        }
        return fileName;
    }

    private void load() throws SQLException, SBException, IOException {
        if (this.image == null && this.imageID == 0 && !this.isUnreferenced) {
            throw new SBException("image is null and imageID is zero in DBImage.load");
        }
        if (this.image == null) {
            if (!this.isUnreferenced) {
                SBdb db;
                if (this.link != null) {
                    db = this.link.SB;
                } else {
                    db = this.SB;
                    if (this.picPath != null && this.picPath.length() > 0 && db == null || !db.isConnected()) {
                        this.loadFromPath();
                        return;
                    }
                }
                Statement stmt = db.getDatabase().createStatement();
                String sql = "SELECT pic_path,image_data,caption FROM " + db.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    this.picPath = rs.getString("pic_path");
                    if (this.picPath != null && this.picPath.length() > 0) {
                        System.out.println("Loading image from file path");
                        File file = new File(this.picPath);
                        if (file.exists()) {
                            this.image = this.getImageIcon(this.picPath);
                        }
                    }
                    if (this.image == null) {
                        System.out.println("Loading image from db");
                        try {
                            byte[] by;
                            if (this.SB.dbType != SBdb.DBType.MSSQLSERVER) {
                                by = rs.getBytes("IMAGE_DATA");
                            } else {
                                int b;
                                InputStream ios = rs.getBinaryStream("IMAGE_DATA");
                                ByteArrayOutputStream bio = new ByteArrayOutputStream();
                                while ((b = ios.read()) >= 0) {
                                    bio.write(b);
                                }
                                by = bio.toByteArray();
                            }
                            if (by != null) {
                                this.image = new ImageIcon(by);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    this.caption = rs.getString("caption");
                }
                stmt.close();
            } else {
                this.loadFromPath();
            }
        }
    }

    private void loadFromPath() throws SBException, IOException {
        if (this.picPath == null || this.picPath.isEmpty()) {
            throw new SBException("Trying to get unreferenced image with no picPath");
        }
        File picFile = new File(this.picPath);
        if (!picFile.exists()) {
            if (this.zipPath != null && this.zipPath.length() > 0) {
                try {
                    int nBytes;
                    ZipFile zip = new ZipFile(this.zipPath);
                    ZipEntry entry = zip.getEntry(this.picPath);
                    if (entry == null) {
                        throw new SBException("Can't find zip file entry for image: " + this.picPath);
                    }
                    InputStream fileIn = zip.getInputStream(entry);
                    picFile = File.createTempFile("SBImage" + this.imageID + "-", ".jpg");
                    picFile.deleteOnExit();
                    String tempPicPath = picFile.getPath();
                    FileOutputStream fos = new FileOutputStream(tempPicPath);
                    byte[] bytes = new byte[Short.MAX_VALUE];
                    while ((nBytes = fileIn.read(bytes, 0, bytes.length)) > 0) {
                        fos.write(bytes, 0, nBytes);
                    }
                    fos.close();
                    this.image = new ImageIcon(tempPicPath);
                }
                catch (IOException ios) {
                    ios.printStackTrace();
                    throw new SBException("IO Exception when reading image from zip file path: " + ios.toString());
                }
            }
        } else {
            this.image = this.getImageIcon(this.picPath);
        }
    }

    private void loadDetails() throws SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            Statement stmt = this.SB.getDatabase().createStatement();
            String sql = "SELECT pic_path,image_data,caption FROM " + this.SB.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID;
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this.picPath = rs.getString("pic_path");
                this.caption = rs.getString("caption");
            }
            stmt.close();
        }
    }

    void importImage() throws SQLException, SBException, FileNotFoundException, IOException {
        File file;
        String sql;
        Statement stmt;
        ResultSet rs;
        if (this.picPath == null && this.image == null && (rs = (stmt = this.SB.getDatabase().createStatement()).executeQuery(sql = "SELECT pic_path FROM " + this.SB.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID)).next()) {
            this.picPath = rs.getString("pic_path");
        }
        if (!(file = new File(this.picPath)).exists()) {
            System.out.println("Cannot import image from file: " + this.picPath);
            return;
        }
        sql = "UPDATE " + this.SB.DBTableName("sbimage") + " SET image_data=? WHERE image_id=" + this.imageID;
        PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
        FileInputStream fileIn = new FileInputStream(this.picPath);
        pStmt.setBinaryStream(1, (InputStream)fileIn, (int)new File(this.picPath).length());
        pStmt.executeUpdate();
        pStmt.close();
        fileIn.close();
    }

    final void store(boolean storeImageInDatabase) throws SQLException, SBException, FileNotFoundException, IOException {
        this.imageID = this.SB.nextControl("sbimage", "image_id");
        String sql = "INSERT INTO " + this.SB.DBTableName("sbimage") + " (image_id,pic_path,caption";
        if (storeImageInDatabase) {
            sql = sql + ",image_data";
        }
        sql = sql + ") VALUES (?, ?, ?";
        if (storeImageInDatabase) {
            sql = sql + ", ?";
        }
        sql = sql + ")";
        PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
        pStmt.setInt(1, this.imageID);
        pStmt.setString(2, this.picPath);
        pStmt.setString(3, this.caption);
        InputStream fileIn = null;
        ZipFile zip = null;
        System.out.println("zipPath: " + this.zipPath);
        System.out.println("picPath: " + this.picPath);
        if (this.zipPath != null) {
            zip = new ZipFile(this.zipPath);
        }
        if (storeImageInDatabase) {
            int len;
            if (zip != null) {
                ZipEntry entry = zip.getEntry(this.picPath);
                if (entry == null) {
                    throw new SBException("Can't find zip file entry for image: " + this.picPath);
                }
                fileIn = zip.getInputStream(entry);
                len = (int)entry.getSize();
            } else if (this.picPath.toLowerCase().contains(".tif")) {
                System.out.println("For Storage, Reading tiff file into buffered image ...");
                FileSeekableStream s = new FileSeekableStream(new File(this.picPath));
                ImageDecodeParam param = null;
                ImageDecoder dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)s, param);
                RenderedImage op = dec.decodeAsRenderedImage(0);
                System.out.println("Writing image output stream");
                JPEGImageWriter jpiw = new JPEGImageWriter(null);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(32768);
                ImageOutputStream ios = ImageIO.createImageOutputStream(bos);
                jpiw.setOutput(ios);
                jpiw.write(op);
                fileIn = new ByteArrayInputStream(bos.toByteArray());
                len = bos.size();
                System.out.println("..done. Bos size is: " + bos.size());
            } else {
                fileIn = new FileInputStream(this.picPath);
                len = (int)new File(this.picPath).length();
            }
            pStmt.setBinaryStream(4, fileIn, len);
        } else if (zip != null) {
            int nBytes;
            ZipEntry entry = zip.getEntry(this.picPath);
            if (entry == null) {
                throw new SBException("Can't find zip file entry for image: " + this.picPath);
            }
            fileIn = zip.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(this.picPath);
            byte[] bytes = new byte[Short.MAX_VALUE];
            while ((nBytes = fileIn.read(bytes, 0, bytes.length)) > 0) {
                fos.write(bytes, 0, nBytes);
            }
            fos.close();
        }
        pStmt.executeUpdate();
        pStmt.close();
        if (fileIn != null) {
            fileIn.close();
        }
        if (zip != null) {
            zip.close();
        }
        this.SB.putImage(this);
    }

    public void setCaption(String text) throws SQLException {
        if (this.caption == null || !this.caption.equals(text)) {
            if (this.imageID > 0 && this.SB != null && this.SB.isConnected()) {
                Statement stmt = this.SB.getDatabase().createStatement();
                String sql = "UPDATE " + this.SB.DBTableName("SBIMAGE") + " SET caption=" + util.SB.DBString((String)text) + " WHERE image_id=" + this.imageID;
                stmt.executeUpdate(this.SB.modQuery(sql));
                stmt.close();
            }
            this.caption = text;
        }
    }

    File writeXML(BufferedWriter out, String ind) throws IOException, SQLException, SBException {
        out.write(ind + "<ImageID>" + this.imageID + "</ImageID>\r\n");
        File tempFile = File.createTempFile("SBImage" + this.imageID + "-", ".jpg");
        System.out.println("Writing image to file: " + tempFile.getAbsolutePath());
        this.writeImage(tempFile);
        out.write(ind + "<File>" + tempFile.getName() + "</File>\r\n");
        if (this.caption != null && this.caption.length() > 0) {
            out.write(ind + "<Caption>" + this.caption + "</Caption>\r\n");
        }
        return tempFile;
    }

    void setUnstored() {
        this.imageID = 0;
    }
}

