/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import model2.AbnScheme;
import model2.AgeCurve;
import model2.AnalystHeader;
import model2.Audit;
import model2.Biocom;
import model2.Category;
import model2.CoOccurrence;
import model2.Column;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.Discipline;
import model2.EnvScheme;
import model2.EventDictionary;
import model2.Genus;
import model2.IGDInterval;
import model2.IGDIntervalEnv;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.ImageSet;
import model2.Intcom;
import model2.InterpHdr;
import model2.Lastval;
import model2.Licence;
import model2.LithTrnScheme;
import model2.Lithdesc;
import model2.Lithology;
import model2.LogDef;
import model2.Overlay;
import model2.Project;
import model2.ProjectList;
import model2.Qualifier;
import model2.SBEvent;
import model2.SBImage;
import model2.SQPick;
import model2.Sample;
import model2.Smpdtl;
import model2.SynonymScheme;
import model2.TaxaMap;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TaxonWellImage;
import model2.TxGroup;
import model2.TxGroupSet;
import model2.Userdef;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import model2.WsWell;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.InvalidFieldException;
import util.ProgressBarMonitor;
import util.SB;
import util.SBException;

public class SBdb
extends Observable
implements Observer {
    private Connection connection = null;
    private Connection connection2 = null;
    private DatabaseMetaData meta = null;
    private String tablePrefix = "";
    public static final String version = "v2.0";
    public long monitorInterval = 0L;
    public long taxaMonitorInterval = 600000L;
    HashMap<Integer, String> sipmDicts = null;
    DBType dbType;
    private boolean emptyConnection;
    Userdef user = null;
    private boolean needsPassword = true;
    public Licence licence = null;
    public static boolean preserveAudit = false;
    private boolean hasTVDplan = false;
    public static final char[] discArr = new char[]{'M', 'N', 'P', 'A'};
    public static final String[] discNounString = new String[]{"Micropalaeontology", "Nannopalaeontology", "Palynology", "Macropalaeontology"};
    public static final int MAXDIS = 4;
    boolean[] hasWeightSplits = new boolean[]{true, true, true, true};
    boolean[] hasFssSplits = new boolean[]{true, true, true, true};
    boolean hasWellsMaster = false;
    boolean hasUserPassword = true;
    boolean hasWellPerm = false;
    boolean hasUserPerm = false;
    boolean hasSIPMdict = false;
    private boolean useSampleTops = false;
    boolean hasSAMBA = false;
    boolean hideDepthRange = false;
    boolean hideCommonSampleTypes = false;
    boolean allowMultipleEnvSchemes = false;
    boolean hasSBimage = false;
    boolean sbwlIsView = false;
    boolean hasCasdiam = true;
    boolean hasCasingView = false;
    boolean storeImage = true;
    public static final int DTSAMPLES = 1;
    public static final int DTMICRO = 2;
    public static final int DTMICROBS = 3;
    public static final int DTNANNO = 4;
    public static final int DTNANNOBS = 5;
    public static final int DTPALY = 6;
    public static final int DTPALYBS = 7;
    public static final int DTMACRO = 8;
    public static final int DTMACROBS = 9;
    public static final int DTCHRONO = 10;
    public static final int DTBIOZONE = 11;
    public static final int DTLITHOSTRAT = 12;
    public static final int DTSEQUENCE = 13;
    public static final int DTSQPICK = 14;
    public static final int DTENV = 15;
    public static final int DTEVENTS = 16;
    public static final int DTQSLOC = 17;
    public static final int DTINTCOM = 18;
    public static final int DTCORES = 19;
    public static final int DTCASING = 20;
    public static final int DTLITHOLOGY = 21;
    public static final int DTSAMPLELITH = 22;
    public static final int DTLOGDATA = 23;
    public static final int DTMARKERS = 24;
    public static final int DTTVD = 25;
    public static final int DTTWT = 26;
    public static final int DTFAULTS = 27;
    public static final int DTWELLHDR = 28;
    public static final String[] dTypeNames = new String[]{"Well/Outcrop", "Samples", "Micro", "Micro. comments", "Nanno", "Nanno. comments", "Paly", "Paly. comments", "Macro", "Macro. comments", "Chronostrat", "Biozone", "Lithostrat", "Sequences", "Sequence Picks", "Palaeoenv.", "Events", "LOCs", "Interval Comments", "Cores", "Casing", "Interpreted Lithology", "Sample Lithology", "Log data", "Markers", "Deviation Survey", "TWT", "Well Header"};
    public static final int NDTYPES = 27;
    public static final int NINTERPDTYPES = 9;
    List wellMasterFields = new ArrayList();
    Well currentWell = null;
    Lithdesc lithdesc = null;
    private final TaxaMap taxa;
    private final EventDictionary events;
    private HashMap<Integer, Overlay> overlays = null;
    private HashMap<String, Color> catColours = null;
    private HashMap<Integer, String> specTypes = null;
    public static final String specTypeDefault = "<no sub-type>";
    HashMap<String, LogDef> logDef = null;
    private TreeMap<Integer, TxGroupSet> sets = null;
    private HashMap<Integer, TxGroup> txGroups = null;
    private HashMap<Integer, SynonymScheme> synSch = null;
    ProjectList projects = null;
    private TreeMap<Integer, Userdef> users = null;
    private List<AbnScheme> abnSchemes = null;
    private List<EnvScheme> envSchemes = null;
    private HashMap<Integer, InterpHdr> interpHdrs = null;
    private HashMap<Integer, IGDScheme> chronoSchemes = null;
    private HashMap<Integer, IGDScheme> lstratSchemes = null;
    private HashMap<Integer, IGDScheme> sequenceSchemes = null;
    private HashMap<Integer, IGDScheme> biozoneSchemes = null;
    private HashMap<Integer, CompositeStandard> compositeStandards = null;
    private List<Integer> chartScales = null;
    List<String> casingDiameters = null;
    private HashMap<Integer, SBImage> images = new HashMap();
    private String imageFolder;
    LinkedList<Integer> userIDs = new LinkedList();
    public static final int CHART_SCALE_MIN = 1;
    public static final int CHART_SCALE_MAX = 100000;
    private String hostName;
    List<AgeCurve> ageCurves = null;
    LinkedList<LithTrnScheme> lithTrnSchemes;
    private static boolean EXPORT_SINGLE_USER = false;
    static String EXPORT_SINGLE_USER_ABR = null;

    public Connection getDatabase() {
        return this.connection;
    }

    public Connection getDatabase(boolean useAlternate) {
        if (useAlternate && this.connection2 != null) {
            return this.connection2;
        }
        return this.connection;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getDatabasePref(String item) throws SQLException {
        String sql = "SELECT pref_value FROM " + this.DBTableName("pref_system") + " WHERE pref_key=" + SB.DBString((String)item);
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        String result = "";
        if (rs.next()) {
            result = rs.getString("pref_value");
        }
        stmt.close();
        return result;
    }

    public Boolean getDatabasePrefBool(String item) throws SQLException {
        String strg;
        String sql = "SELECT pref_value FROM " + this.DBTableName("pref_system") + " WHERE pref_key=" + SB.DBString((String)item);
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        Boolean result = null;
        if (rs.next() && (strg = rs.getString("pref_value")).length() > 0) {
            result = strg.toUpperCase(Locale.ENGLISH).charAt(0) == 'F' ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        stmt.close();
        return result;
    }

    public void putDatabasePref(String item, boolean bool) throws SQLException {
        this.putDatabasePref(item, "" + bool);
    }

    public void putDatabasePref(String item, String pref) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String sql = "DELETE FROM " + this.DBTableName("PREF_SYSTEM") + " WHERE pref_key='" + item + "'";
        stmt.executeUpdate(this.modQuery(sql));
        if (pref != null && pref.length() > 0) {
            sql = "INSERT INTO " + this.DBTableName("PREF_SYSTEM") + " ( pref_key, pref_value ) VALUES ('" + item + "','" + pref + "')";
            stmt.executeUpdate(this.modQuery(sql));
        }
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseInfo() throws SQLException {
        Statement stmt = this.connection.createStatement();
        String info = "";
        String[] tables = new String[]{"WELL_IDENT", "SBWLLST", "SAMPLES", "SMPDTL", "TAXONOCC", "SBIMAGE", "INTERP", "LOC", "IGD", "IGD_Env", "Events", "BCMMNTS", "SQPICK", "INTCMMNTS", "FAULTS", "LOG_CURVE", "SBCHARTS", "USERDEF", "SPECIES", "GENUS", "CATEGORY", "TXGROUP", "IGD_SCH", "CMPSTD", "ENV_SCH", "AGE_CURVE"};
        try {
            for (int i = 0; i < tables.length; ++i) {
                String sql = "SELECT COUNT(*) as result FROM " + this.DBTableName(tables[i]);
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                while (rs.next()) {
                    int j = rs.getInt("result");
                    info = info + j + ",";
                }
            }
        }
        finally {
            stmt.close();
        }
        return info;
    }

    public void setStoreImage(boolean bool) throws SQLException {
        this.putDatabasePref("IMAGEDB", bool);
        this.storeImage = bool;
    }

    public void exportImages(File folder) throws SQLException, SBException, FileNotFoundException, IOException {
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT image_id FROM " + this.DBTableName("SBIMAGE") + " WHERE image_data IS NOT NULL";
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int imageID = rs.getInt("image_id");
            SBImage image = this.getImage(imageID);
            image.export(folder);
            System.out.println("Exporting image: " + image.getPath());
        }
        stmt.close();
    }

    public void importImages() throws SQLException, SBException, FileNotFoundException, IOException {
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT image_id FROM " + this.DBTableName("SBIMAGE") + " WHERE image_data IS NULL";
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int imageID = rs.getInt("image_id");
            SBImage image = this.getImage(imageID);
            image.importImage();
            System.out.println("Importing image: " + image.getPath());
        }
        stmt.close();
    }

    public int getImageCount(boolean b) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT count(image_id) as nitems FROM " + this.DBTableName("SBIMAGE") + " WHERE image_data IS ";
        if (b) {
            sql = sql + "NOT ";
        }
        sql = sql + " NULL";
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        int nItems = 0;
        if (rs.next()) {
            nItems = rs.getInt("nitems");
        }
        stmt.close();
        return nItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() throws SQLException, SBException {
        Statement stmt = this.getDatabase(true).createStatement();
        try {
            Project project0;
            Observable notifier;
            this.refreshAbnSchemes(stmt);
            this.refreshEnvSchemes(stmt);
            this.refreshIGDSchemes(stmt);
            this.refreshEvents(stmt);
            this.refreshCompositeStandards(stmt);
            this.refreshTaxa(stmt);
            if (this.txGroups != null && (notifier = TxGroup.refresh(this, this.txGroups)) != null) {
                this.setChanged();
                this.notifyObservers(notifier);
            }
            if (this.sets != null && (notifier = TxGroupSet.refresh(this, this.sets)) != null) {
                this.setChanged();
                this.notifyObservers(notifier);
            }
            if (this.overlays != null) {
                Overlay.refresh(this, stmt, this.overlays);
            }
            this.refreshInterps(stmt);
            this.refreshProjects(stmt);
            Project project = project0 = this.getProject(0);
            synchronized (project) {
                Iterator<Well> it = project0.getWellIterator();
                while (it.hasNext()) {
                    Well well = it.next();
                    well.refresh(stmt);
                }
            }
        }
        finally {
            stmt.close();
        }
        this.getDatabase(true).commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshTaxa() throws SQLException, SBException {
        Statement stmt = this.getDatabase(true).createStatement();
        try {
            this.refreshTaxa(stmt);
        }
        finally {
            stmt.close();
        }
        this.getDatabase(true).commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refreshIntervals(IGDScheme scheme) throws SQLException, SBException {
        System.out.println("Refreshing linked intervals for scheme '" + scheme + "'");
        Statement stmt = this.getDatabase().createStatement();
        Iterator<Well> it = this.getProject(0).getWellIterator();
        try {
            while (it.hasNext()) {
                Well well = it.next();
                well.getSamples();
                Iterator<WellInterp> interpIterator = well.getInterpIterator();
                while (interpIterator.hasNext()) {
                    WellInterp interp = interpIterator.next();
                    interp.refreshZones(stmt, scheme.getIGDType(), well, scheme.getSchID());
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    public boolean storeImage() {
        return this.storeImage;
    }

    public void cleanTaxon(int specID, boolean convertCase, boolean clearCat, boolean spSpp) {
        this.taxa.cleanTaxon(specID, convertCase, clearCat, spSpp);
    }

    public void updateGenus(int genID, Genus.Builder genBuilder) throws SQLException {
        this.taxa.updateGenus(genID, genBuilder);
    }

    public void updateSpecies(int specID, Taxon.Builder builder) throws SQLException {
        this.taxa.updateSpecies(specID, builder);
    }

    int getAddUserID(String value) throws SQLException {
        int ID = this.getUserID(value);
        if (ID == 0) {
            try {
                ID = this.users.lastKey() + 1;
            }
            catch (Exception e) {
                ID = 1;
            }
            Userdef u = new Userdef(this, ID, value, "", "", Discipline.MICRO, Color.BLACK, "", 0);
            this.getUsers();
            this.users.put(ID, u);
        }
        return ID;
    }

    void setUser(Userdef defaultUser) throws SQLException {
        if (this.user == defaultUser) {
            return;
        }
        if (this.isConnected()) {
            return;
        }
        this.user = this.getUser(defaultUser.getAbr());
        if (this.user == null) {
            this.user = defaultUser;
            this.users.put(defaultUser.getUsrID(), this.user);
        }
    }

    public String getSpecTypeStringv18(char form, char growth) {
        String specTypeString = "";
        if (form != 'C' || growth != 'A') {
            switch (form) {
                case 'E': {
                    specTypeString = "Entire";
                    break;
                }
                case 'C': {
                    specTypeString = "Component";
                    break;
                }
                case 'B': {
                    specTypeString = "Broken";
                    break;
                }
                case 'F': {
                    specTypeString = "Fragment";
                    break;
                }
            }
            switch (growth) {
                case 'A': {
                    if (specTypeString.length() > 0) {
                        specTypeString = specTypeString + '/';
                    }
                    specTypeString = specTypeString + "Adult";
                    break;
                }
                case 'J': {
                    if (specTypeString.length() > 0) {
                        specTypeString = specTypeString + '/';
                    }
                    specTypeString = specTypeString + "Juvenile";
                    break;
                }
            }
        }
        return specTypeString;
    }

    public boolean hasEnvSchemeOccs(EnvScheme scheme) throws SQLException, SBException {
        Iterator<Well> it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            Iterator<WellInterp> iti = well.getInterpIterator();
            while (iti.hasNext()) {
                WellInterp wellInterp = iti.next();
                for (IGDIntervalEnv zone : wellInterp.getEnvs()) {
                    if (zone.getSchID() != scheme.getID()) continue;
                    return true;
                }
            }
            for (Sample sample : well.getSamples()) {
                for (Smpdtl dtl : sample.getAnalyses()) {
                    if (dtl.getProximal() <= 0 || dtl.getHeader().getEnvSchID() != scheme.getID()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addTaxonImageSet(Taxon taxon, ImageSet imageSet) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String sql = "INSERT INTO " + this.DBTableName("TXIMAGE") + " (spec_id, image_set_id) VALUES (" + taxon.getSpecID() + "," + imageSet.getID() + ")";
        stmt.executeUpdate(this.modQuery(sql));
        stmt.close();
        taxon.getImageSetCount(true);
    }

    public void setTaxonImageSetType(Taxon taxon, ImageSet imageSet, boolean isType) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT image_set_id FROM " + this.DBTableName("TXIMAGE") + " WHERE image_set_id=" + imageSet.getID();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        boolean exists = rs.next();
        boolean update = false;
        if (!exists && isType) {
            sql = "INSERT INTO " + this.DBTableName("TXIMAGE") + " (spec_id, image_set_id, type) VALUES (" + taxon.getSpecID() + "," + imageSet.getID() + ",'Y')";
            stmt.executeUpdate(this.modQuery(sql));
        } else if (exists && isType || !exists && !isType) {
            update = true;
        } else if (exists && !isType) {
            sql = "SELECT image_set_id FROM " + this.DBTableName("TAXONOCC") + " WHERE image_set_id=" + imageSet.getID();
            rs = stmt.executeQuery(this.modQuery(sql));
            if (rs.next()) {
                sql = "DELETE FROM " + this.DBTableName("TXIMAGE") + " WHERE image_set_id=" + imageSet.getID();
                stmt.executeUpdate(this.modQuery(sql));
            } else {
                update = true;
            }
        }
        if (update) {
            sql = "UPDATE " + this.DBTableName("TXIMAGE") + " SET type='" + (isType ? "Y" : "N") + "' WHERE spec_id=" + taxon.getSpecID() + " AND image_set_id=" + imageSet.getID();
            stmt.executeUpdate(this.modQuery(sql));
        }
        stmt.close();
        if (isType) {
            taxon.incrementTypeImage();
        } else {
            taxon.decrementTypeImage();
        }
    }

    public boolean hasAbnSchemeOccs(AbnScheme scheme) throws SQLException, SBException {
        Iterator<Well> wit = this.getProject(0).getWellIterator();
        while (wit.hasNext()) {
            Well well = wit.next();
            LinkedList<AnalystHeader> selectedAnalystHeaders = null;
            Iterator<AnalystHeader> ait = well.getAnalystHeaderIterator();
            while (ait.hasNext()) {
                AnalystHeader header = ait.next();
                if (header.getAbnSchID() <= 0 || header.getAbnSchID() != scheme.getID()) continue;
                if (selectedAnalystHeaders == null) {
                    selectedAnalystHeaders = new LinkedList<AnalystHeader>();
                }
                selectedAnalystHeaders.add(header);
            }
            for (Sample sample : well.getSamples()) {
                for (Smpdtl smpdtl : sample.getAnalyses()) {
                    boolean process = false;
                    if (selectedAnalystHeaders != null) {
                        for (AnalystHeader header : selectedAnalystHeaders) {
                            if (header != smpdtl.getHeader()) continue;
                            process = true;
                            break;
                        }
                    }
                    if (!process) continue;
                    for (TaxonOcc occ : smpdtl.getOccur()) {
                        if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0 || occ.getSubAbund().equals("+")) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbnScheme checkDefaultAbnScheme() throws SQLException, SBException {
        Iterator<Well> wit = this.getProject(0).getWellIterator();
        AbnScheme scheme = null;
        int newSchID = 1;
        boolean done = false;
        while (!done) {
            done = true;
            for (AbnScheme sch : this.getAbnSchemes()) {
                if (newSchID > sch.getID()) continue;
                ++newSchID;
                done = false;
            }
        }
        try {
            while (wit.hasNext()) {
                Well well = wit.next();
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.getAnalyses()) {
                        for (TaxonOcc occ : smpdtl.getOccur()) {
                            if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0 || occ.getSubAbund().equals("+")) continue;
                            String subjAbund = occ.getSubAbund();
                            AnalystHeader header = smpdtl.getHeader();
                            if (header == null) {
                                throw new SBException("Analyst header null for Analysis: " + smpdtl);
                            }
                            if (header.getAbnSchID() != 0 && header.getAbnSchID() != newSchID) continue;
                            if (scheme == null) {
                                scheme = new AbnScheme(newSchID);
                                scheme.setName("Default");
                                try {
                                    scheme.addClass(subjAbund, null, 0, 0);
                                }
                                catch (SBException sbe) {
                                    if (sbe.getMessage().startsWith("Abundance scheme classes must consist of letters only")) {
                                        String newMessage = "Error creating class in Default Abundance Scheme using subjective abundance in occurrence: " + occ + " in sample: " + sample.toString() + ".\n";
                                        newMessage = newMessage + sbe.getMessage() + "\n";
                                        newMessage = newMessage + "You should edit your source file and try the import again.";
                                        throw new SBException(newMessage);
                                    }
                                    throw sbe;
                                }
                            } else if (scheme.getIndex(subjAbund) < 0) {
                                scheme.addClass(subjAbund, null, 0, 0);
                            }
                            header.setAbnScheme(newSchID);
                        }
                    }
                }
            }
        }
        finally {
            if (scheme != null) {
                this.addAbnScheme(scheme);
            }
        }
        return scheme;
    }

    public InterpHdr addInterp(InterpHdr hdr) throws SQLException, SBException {
        InterpHdr wsHdr = new InterpHdr(this, hdr);
        if (this.interpHdrs == null) {
            throw new SBException("No versions loaded");
        }
        this.interpHdrs.put(wsHdr.getInterpID(), wsHdr);
        for (InterpHdr whdr : this.interpHdrs.values()) {
            System.out.println("In sbdb.addInterp: " + whdr.getDescription() + "/" + whdr.getInterpID());
        }
        return wsHdr;
    }

    void fillUser(SBdb db, int userID) throws SQLException, SBException {
        Userdef dbUser = db.getUser(userID);
        if (dbUser == null) {
            throw new SBException("User not found for user ID: " + userID + " in SBdb.fillUser");
        }
        if (this.getUser(dbUser.getAbr()) == null) {
            this.users.put(userID, new Userdef(this, dbUser));
        }
    }

    public void parseXMLDocument(Document xmlDocument, List<Integer> dataTypes, ZipFile zip, String fileName) throws SBException, SQLException, ParseException, FileNotFoundException, IOException {
        Element element;
        Element xmlGs;
        Iterator it = xmlDocument.getDescendants((Filter)new ElementFilter("UserList"));
        if (it.hasNext()) {
            this.getUsers();
            Element userList = (Element)it.next();
            for (Element xmlUser : userList.getChildren()) {
                Userdef us = new Userdef(this, xmlUser);
                this.users.put(us.getUsrID(), us);
            }
        }
        if (it.hasNext()) {
            throw new SBException("Error - XML document contains more than one user list");
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("StratigraphicScheme"));
        while (it.hasNext()) {
            this.addIGDScheme(new IGDScheme(this, (Element)it.next()));
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("EnvironmentScheme"));
        while (it.hasNext()) {
            this.addEnvScheme(new EnvScheme(this, (Element)it.next()));
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("AbundanceScheme"));
        while (it.hasNext()) {
            this.getAbnSchemes();
            Element xmlAbn = (Element)it.next();
            AbnScheme abnScheme = new AbnScheme(this, xmlAbn);
            this.abnSchemes.add(abnScheme);
        }
        if (it.hasNext()) {
            throw new SBException("Error - XML document contains more than one abundance scheme list");
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("TaxonList"));
        if (it.hasNext()) {
            Element txList = (Element)it.next();
            for (Element xmlTx : txList.getChildren()) {
                this.taxa.parseTaxon(xmlTx, zip);
            }
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("GroupSet"));
        while (it.hasNext()) {
            xmlGs = (Element)it.next();
            TxGroupSet set = this.parseTxGroupSet(xmlGs, zip);
            this.getTxGroupSets();
            this.sets.put(set.getID(), set);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("TaxonGroup"));
        while (it.hasNext()) {
            xmlGs = (Element)it.next();
            TxGroup group = this.parseTxGroup(xmlGs, zip);
            this.getTxGroups();
            this.txGroups.put(group.getID(), group);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("Event"));
        while (it.hasNext()) {
            element = (Element)it.next();
            this.events.parseEvent(element);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("CompositeStandard"));
        while (it.hasNext()) {
            this.getCompositeStandards();
            element = (Element)it.next();
            CompositeStandard std = new CompositeStandard(this, element);
            if (std.getName() == null) continue;
            this.compositeStandards.put(std.getStdID(), std);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("Well"));
        while (it.hasNext()) {
            Element well = (Element)it.next();
            this.getProject(0).addWell(new WsWell(this, well, dataTypes, zip, fileName));
        }
    }

    private TxGroup parseTxGroup(Element xml, ZipFile zip) throws SBException, ParseException, SQLException {
        TxGroup group = TxGroup.parseTxGroup(xml, this);
        Element taxonList = xml.getChild("TaxonList");
        Iterator it = taxonList.getContent((Filter)new ElementFilter("Taxon")).iterator();
        LinkedList<Taxon> grpTaxa = new LinkedList<Taxon>();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            grpTaxa.add(this.taxa.parseTaxon(el, zip));
        }
        group.addTaxa(grpTaxa);
        return group;
    }

    private TxGroupSet parseTxGroupSet(Element xml, ZipFile zip) throws SBException, ParseException, SQLException {
        String name = xml.getChildText("SetName");
        System.out.println("Set name is: " + name);
        String strgID = xml.getChildTextNormalize("SetID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int grpSetID = Integer.parseInt(strgID);
        Element ela = xml.getChild("Audit");
        Audit audit = null;
        if (ela != null) {
            try {
                audit = new Audit(this, ela);
            }
            catch (SBException sbe) {
                System.out.println("Message from Audit in TxGroupSet (ignored): " + sbe.getMessage());
            }
        } else {
            System.out.println("Warning: no audit info for TxGroupSet: " + this);
        }
        TxGroupSet set = new TxGroupSet(this, grpSetID, name, audit);
        for (Element el : xml.getContent((Filter)new ElementFilter("TaxonGroup"))) {
            TxGroup group = this.parseTxGroup(el, zip);
            set.addGroupID(group.getID());
        }
        return set;
    }

    public void parseTaxonList(File textFile) throws IOException, SQLException, SBException {
        if (this.isConnected() || this.taxa.getSize() > 0) {
            throw new IllegalStateException("Illegal use of taxon list parse in database");
        }
        BufferedReader in = new BufferedReader(new FileReader(textFile));
        String buff = in.readLine();
        int specID = 1;
        while (buff != null) {
            if (this.taxa.parse(buff, specID, false) != null) {
                ++specID;
            }
            buff = in.readLine();
        }
        TxGroup grp = new TxGroup(this, textFile.getName().substring(0, textFile.getName().lastIndexOf(46)), "NEW", this.nextTxGroupID());
        grp.addTaxa(this.taxa.getTaxa());
        this.putTxGroup(grp);
    }

    private int nextTxGroupID() {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to get workspace TxGroup ID in connected database");
        }
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
        }
        int maxID = 1;
        for (Integer i : this.txGroups.keySet()) {
            if (i < maxID) continue;
            maxID = i + 1;
        }
        return maxID;
    }

    public SBEvent fillEvent(SBdb db, SBEvent dbEvent) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill SBEvent into connected workspace");
        }
        SBEvent wsEvent = this.getSBEvent(dbEvent.getEvID());
        if (wsEvent == null) {
            Taxon wsTaxon = null;
            if (dbEvent.getTaxon() != null) {
                wsTaxon = this.fillTaxon(db, dbEvent.getTaxon());
            }
            wsEvent = this.events.copyToWorkspace(dbEvent, db, wsTaxon);
        }
        return wsEvent;
    }

    public Taxon fillTaxon(SBdb db, Taxon dbTaxon) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill taxon into connected workspace");
        }
        Taxon wsTaxon = this.getTaxon(dbTaxon.getSpecID());
        if (wsTaxon == null) {
            wsTaxon = this.taxa.copyToWorkspace(this, dbTaxon, db);
        }
        return wsTaxon;
    }

    public Taxon fillTaxonFromWorkspace(SBdb ws, Taxon wsTaxon, Category cat) throws SQLException, SBException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Attempt to fill taxon to unconnected database");
        }
        return this.taxa.copyToDataBase(wsTaxon, ws, cat);
    }

    void fillAbundanceScheme(SBdb SB2, int abnSchID) throws SQLException, SBException {
        if (this.getAbnScheme(abnSchID, false) == null) {
            AbnScheme abnScheme = new AbnScheme(this, SB2.getAbnScheme(abnSchID, true));
            this.abnSchemes.add(abnScheme);
        }
    }

    void fillEnvScheme(SBdb SB2, int envSchID) throws SQLException, SBException {
        if (this.getEnvScheme(envSchID) == null) {
            EnvScheme envScheme = new EnvScheme(this, SB2.getEnvScheme(envSchID));
            this.envSchemes.add(envScheme);
        }
    }

    public int getAddIGDScheme(String string, int igdType, char discID) throws SQLException, SBException {
        IGDScheme scheme = this.getIGDScheme(string, igdType);
        if (scheme == null) {
            scheme = new IGDScheme(this, igdType, string, Discipline.getDisc(discID), igdType == 10 ? IGDScheme.SequenceType.DEPOSITIONAL : null);
            scheme.storeDetails();
            this.addIGDScheme(scheme);
            System.out.println("Added IGD Scheme: " + scheme);
        }
        return scheme.getSchID();
    }

    private int findMaxID(int schID, HashMap<Integer, IGDScheme> schemeMap) {
        if (schemeMap == null) {
            return schID;
        }
        for (int existingID : schemeMap.keySet()) {
            if (existingID < schID) continue;
            schID = existingID + 1;
        }
        return schID;
    }

    public void deleteSBEvent(SBEvent event) throws SQLException, SBException {
        this.events.deleteEvent(event.getEvID());
        Iterator<Well> wit = this.getProject(0).getWellIterator();
        while (wit.hasNext()) {
            Well well = wit.next();
            Iterator<WellInterp> iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = iit.next();
                if (interp.getEvents() == null) continue;
                Iterator<WellEvent> evIt = interp.getEvents().iterator();
                while (evIt.hasNext()) {
                    WellEvent wellEvent = evIt.next();
                    if (wellEvent.getEvent() != event) continue;
                    evIt.remove();
                }
            }
        }
        if (this.compositeStandards != null) {
            for (CompositeStandard std : this.compositeStandards.values()) {
                std.loadEvents();
                Iterator<CompositeStandardEvent> it = std.getEvents().iterator();
                while (it.hasNext()) {
                    CompositeStandardEvent cmpEvent = it.next();
                    if (cmpEvent.getEvent() != event) continue;
                    it.remove();
                }
            }
        }
        this.setChanged();
    }

    public void clearUsers() {
        if (this.users != null) {
            this.users.clear();
            this.users = null;
        }
    }

    public void deleteOverlay(Overlay overlay) throws SQLException, SBException {
        overlay.delete();
        this.overlays.remove(overlay.getOvrID());
    }

    public void deleteCompositeStandard(CompositeStandard std) throws SQLException {
        std.delete();
        this.compositeStandards.remove(std.getStdID());
    }

    public HashMap<Integer, String> getSIPMDicts() throws SQLException {
        if (this.sipmDicts == null) {
            this.loadSipmDicts();
        }
        return this.sipmDicts;
    }

    private void loadSipmDicts() throws SQLException {
        this.sipmDicts = new HashMap();
        String sql = "SELECT ccode,txt FROM " + this.DBTableName("sipmdict") + " ORDER BY ccode";
        Statement stmt = this.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int countryCode = rs.getInt("ccode");
            String text = rs.getString("txt");
            this.sipmDicts.put(countryCode, text);
        }
        stmt.close();
    }

    public String getSipmDict(int cCode) throws SQLException {
        if (this.sipmDicts == null) {
            this.loadSipmDicts();
        }
        return this.sipmDicts.get(cCode);
    }

    public int addSipmDict(String sipmArea) throws SQLException, SBException {
        String sql;
        Statement stmt = this.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql = "SELECT ccode FROM " + this.DBTableName("sipmdict") + " WHERE ucase(txt)='" + sipmArea.toUpperCase() + "'"));
        if (rs.next()) {
            stmt.close();
            throw new SBException("SIPMDict entry already exists: " + sipmArea);
        }
        int ccode = this.nextControl("sipmdict", "ccode");
        if (this.getSipmDict(ccode) != null) {
            throw new SBException("New ccode in SipmDict already exists");
        }
        sql = "INSERT INTO " + this.DBTableName("sipmdict") + "(ccode,txt) VALUES (" + ccode + "," + SB.DBString((String)sipmArea) + ")";
        stmt.executeUpdate(this.modQuery(sql));
        stmt.close();
        this.sipmDicts.put(ccode, sipmArea);
        return ccode;
    }

    public int deleteSipmDict(int ccode) throws SQLException, SBException {
        Statement stmt = this.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.DBTableName("sipmcode") + " WHERE ccode=" + ccode;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "DELETE FROM " + this.DBTableName("sipmdict") + " WHERE ccode=" + ccode;
        stmt.executeUpdate(this.modQuery(sql));
        stmt.close();
        this.sipmDicts.remove(ccode);
        return ccode;
    }

    public int getSipmDictEntryCount(int ccode) throws SQLException, SBException {
        Statement stmt = this.getDatabase().createStatement();
        String sql = "SELECT count(spec_id) AS nSpec FROM " + this.DBTableName("sipmcode") + " WHERE ccode=" + ccode;
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        int nSpec = 0;
        if (!rs.next()) {
            throw new SBException("Error getting number of species from sipmcode table");
        }
        nSpec = rs.getInt("nSpec");
        stmt.close();
        return nSpec;
    }

    public HashMap<Integer, Integer> getSipmDictEntries(int ccode, boolean keyIsSpecID) throws SQLException {
        Statement stmt = this.getDatabase().createStatement();
        String sql = "SELECT spec_id, sipm_code FROM " + this.DBTableName("sipmcode") + " WHERE ccode=" + ccode;
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        HashMap<Integer, Integer> dict = new HashMap<Integer, Integer>();
        while (rs.next()) {
            int specID = rs.getInt("spec_id");
            int sipmCode = rs.getInt("sipm_code");
            if (keyIsSpecID) {
                dict.put(specID, sipmCode);
                continue;
            }
            dict.put(sipmCode, specID);
        }
        stmt.close();
        return dict;
    }

    public void deleteLogdef(LogDef d) throws SQLException, SBException {
        d.delete();
        this.logDef.remove(d.getAbr());
    }

    public LogDef addLogDef(String abr, String title, String units, float minval, float maxval, boolean asLog, Color backColour, Color lineColour, int penStyle, int traceStyle, float penWidth, boolean wrapTrace, int symbol) throws SQLException, SBException {
        LogDef newEntry = new LogDef(this, abr, title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
        newEntry.store();
        this.logDef.put(abr, newEntry);
        return newEntry;
    }

    public void updateLogDef(LogDef logDefEntry, String abr, String title, String units, float minval, float maxval, boolean asLog, Color backColour, Color lineColour, int penStyle, int traceStyle, float penWidth, boolean wrapTrace, int symbol) throws SQLException, SBException {
        if (!logDefEntry.getAbr().equals(abr)) {
            LogDef replacement = new LogDef(this, abr, title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
            replacement.store();
            replacement.updateCurveAbr(logDefEntry.getAbr());
            this.logDef.remove(logDefEntry.getAbr());
            logDefEntry.delete();
            this.logDef.put(abr, replacement);
        } else {
            logDefEntry.update(this, title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
        }
    }

    void removeImageSetTxRefs(int imageSetID) {
        for (Taxon taxon : this.taxa.getTaxa()) {
            taxon.removeImageType(imageSetID);
        }
    }

    public final void setSampleTops(boolean b) throws SQLException {
        this.useSampleTops = b;
        if (this.isConnected()) {
            this.putDatabasePref("sampletops", this.useSampleTops);
        }
    }

    public boolean getSampleTops() throws SQLException {
        Boolean which = this.getDatabasePrefBool("sampletops");
        if (which != null) {
            this.useSampleTops = which;
        }
        return this.useSampleTops;
    }

    private void setEventPrefixes() throws SQLException {
        String wTop = this.getDatabasePref("EVENTPRXWT");
        String wBase = this.getDatabasePref("EVENTPRXWB");
        WellEvent.setPrefixes(wTop, wBase);
        String sTop = this.getDatabasePref("EVENTPRXCT");
        String sBase = this.getDatabasePref("EVENTPRXCB");
        CompositeStandardEvent.setPrefixes(sTop, sBase);
    }

    public final void setAllowMultipleEnvSchemes(boolean b) throws SQLException {
        this.allowMultipleEnvSchemes = b;
        if (this.isConnected()) {
            this.putDatabasePref("multenvsch", this.allowMultipleEnvSchemes);
        }
    }

    public boolean getAllowMultipleEnvSchemes() throws SQLException {
        Boolean which = this.getDatabasePrefBool("multenvsch");
        if (which != null) {
            this.allowMultipleEnvSchemes = which;
        }
        return this.allowMultipleEnvSchemes;
    }

    public String getDBCharType() {
        if (this.dbType == DBType.ORACLE) {
            return "varchar2";
        }
        if (this.dbType == DBType.MYSQL || this.dbType == DBType.MSSQLSERVER) {
            return "varchar";
        }
        return "text";
    }

    public int setNullSampleDepths(boolean setTops) throws SQLException {
        Statement stmt = this.getDatabase().createStatement();
        String sql = "UPDATE " + this.DBTableName("samples") + " SET ";
        sql = setTops ? sql + " top_depth=NULL " : sql + " base_depth=NULL ";
        sql = sql + " WHERE top_depth=base_depth";
        int nRows = stmt.executeUpdate(this.modQuery(sql));
        System.out.println("First tranche nrows: " + nRows);
        sql = "UPDATE " + this.DBTableName("samples") + " SET ";
        sql = setTops ? sql + " base_depth=top_depth, top_depth=NULL WHERE base_depth is NULL AND top_depth is not NULL" : sql + " top_depth=base_depth, base_depth=NULL WHERE top_depth is NULL AND base_depth is not NULL ";
        stmt.close();
        return nRows += stmt.executeUpdate(this.modQuery(sql));
    }

    public void mergeEvents(SBEvent donorEvent, SBEvent targetEvent) throws SQLException, SBException {
        Statement stmt = this.getDatabase().createStatement();
        Statement auditStmt = this.getDatabase().createStatement();
        TreeSet<String> deleteSql = new TreeSet<String>();
        String sql = "SELECT e1.well_id, e1.interp_id, e1.samp_id, e1.ev_type FROM " + this.DBTableName("events") + " e1, " + this.DBTableName("events") + " e2 " + " WHERE e1.well_id=e2.well_id AND e1.interp_id=e2.interp_id AND e1.samp_id=e2.samp_id AND e1.ev_type=e2.ev_type AND " + " e1.ev_id=" + donorEvent.getEvID() + " AND e2.ev_id=" + targetEvent.getEvID();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            int interpID = rs.getInt("interp_id");
            int sampID = rs.getInt("samp_id");
            char evType = SB.getDBChar((ResultSet)rs, (String)"ev_type");
            Iterator<Well> wit = this.projects.getProject(0).getWellIterator();
            block1: while (wit.hasNext()) {
                Well well = wit.next();
                if (well.getWellID() != wellID) continue;
                Iterator<WellInterp> iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    WellInterp wellInterp = iit.next();
                    if (wellInterp.getHeader().getInterpID() != interpID) continue;
                    Iterator<WellEvent> eit = wellInterp.getEvents().iterator();
                    while (eit.hasNext()) {
                        WellEvent wellEvent = eit.next();
                        if (wellEvent.getSampID() != sampID || wellEvent.getEvent().getEvID() != donorEvent.getEvID() || wellEvent.getCharType() != evType) continue;
                        System.out.println("Removing event from well: " + well + ", sample: " + well.getSample(sampID));
                        eit.remove();
                        break block1;
                    }
                }
            }
            deleteSql.add("DELETE FROM " + this.DBTableName("events") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND samp_id=" + sampID + " AND ev_type=" + SB.DBChar((char)evType) + " AND ev_id=" + donorEvent.getEvID());
        }
        while (!deleteSql.isEmpty()) {
            int nRows = stmt.executeUpdate(this.modQuery((String)deleteSql.pollFirst()));
            if (nRows != 0) continue;
            throw new SBException("Error: no rows deleted in statement: " + SB.sql);
        }
        Audit audit = new Audit();
        sql = "UPDATE " + this.DBTableName("events") + " SET ev_id=" + targetEvent.getEvID() + "," + audit.sqlUpdate(this, auditStmt, true) + " WHERE ev_id=" + donorEvent.getEvID();
        stmt.executeUpdate(this.modQuery(sql));
        if (this.projects != null && this.projects.getProject(0) != null) {
            Iterator<Well> wit = this.projects.getProject(0).getWellIterator();
            while (wit.hasNext()) {
                Well well = wit.next();
                Iterator<WellInterp> iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    WellInterp wellInterp = iit.next();
                    for (WellEvent wellEvent : wellInterp.getEvents()) {
                        if (wellEvent.getEvent().getEvID() != donorEvent.getEvID()) continue;
                        wellEvent.setEvent(targetEvent);
                    }
                }
            }
        }
        sql = "SELECT e1.std_id,e1.ev_type FROM " + this.DBTableName("cmpstdev") + " e1, " + this.DBTableName("cmpstdev") + " e2 " + " WHERE e1.std_id=e2.std_id AND e1.ev_type=e2.ev_type AND " + " e1.ev_id=" + donorEvent.getEvID() + " AND e2.ev_id=" + targetEvent.getEvID();
        rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int stdID = rs.getInt("std_id");
            char evType = SB.getDBChar((ResultSet)rs, (String)"ev_type");
            for (CompositeStandard std : this.getCompositeStandards()) {
                if (std.getStdID() != stdID) continue;
                std.loadEvents();
                Iterator<CompositeStandardEvent> cit = std.getEvents().iterator();
                while (cit.hasNext()) {
                    CompositeStandardEvent event = cit.next();
                    if (event.getEvID() != donorEvent.getEvID() || event.getEvType() != evType) continue;
                    cit.remove();
                }
            }
            deleteSql.add("DELETE FROM " + this.DBTableName("cmpstdev") + " WHERE std_id=" + stdID + " AND ev_type=" + SB.DBChar((char)evType) + " AND ev_id=" + donorEvent.getEvID());
        }
        while (!deleteSql.isEmpty()) {
            int nRows = stmt.executeUpdate(this.modQuery((String)deleteSql.pollFirst()));
            if (nRows != 0) continue;
            throw new SBException("Error: no rows deleted in statement: " + SB.sql);
        }
        sql = "UPDATE " + this.DBTableName("cmpstdev") + " SET ev_id=" + targetEvent.getEvID() + "," + audit.sqlUpdate(this, auditStmt, true) + " WHERE ev_id=" + donorEvent.getEvID();
        stmt.executeUpdate(this.modQuery(sql));
        for (CompositeStandard std : this.getCompositeStandards()) {
            std.loadEvents();
            for (CompositeStandardEvent event : std.getEvents()) {
                if (event.getEvID() != donorEvent.getEvID()) continue;
                event.setSBEvent(targetEvent);
            }
        }
        this.events.deleteEvent(donorEvent.getEvID());
        this.setChanged();
    }

    public boolean hasSoundex() {
        switch (this.dbType) {
            case ORACLE: 
            case MSSQLSERVER: 
            case MYSQL: {
                return true;
            }
        }
        return false;
    }

    public Collection<Taxon> getTaxa() {
        return this.taxa.getTaxa();
    }

    public boolean hasTaxa() {
        return this.taxa != null && this.taxa.getSize() > 0;
    }

    public boolean hasTaxon(Taxon taxon) {
        return this.taxa.hasTaxon(taxon);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.taxa) {
            this.setChanged();
            this.notifyObservers(Taxon.class);
        } else if (o == this.events) {
            this.setChanged();
            if (arg != null && arg instanceof SBEvent) {
                this.notifyObservers(arg);
            } else {
                this.notifyObservers(SBEvent.class);
            }
        }
    }

    public boolean restrictedToDiscID(char discID) {
        int priv = this.getUser().getPriv();
        if ((priv & 0x40) > 0) {
            return false;
        }
        return (priv & 4) > 0 && discID != this.getUser().getDiscipline().getChar();
    }

    public boolean restrictedToDiscID(Discipline discID) {
        int priv = this.getUser().getPriv();
        if ((priv & 0x40) > 0) {
            return false;
        }
        return (priv & 4) > 0 && discID != this.getUser().getDiscipline();
    }

    public HashSet<String> getDonorSampleTypes() throws SQLException, SBException {
        HashSet<String> donorTypes = null;
        Iterator<Well> it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            for (Sample sample : well.getSamples()) {
                if (sample.donorSampleType == null) continue;
                if (donorTypes == null) {
                    donorTypes = new HashSet<String>();
                }
                donorTypes.add(sample.donorSampleType);
            }
        }
        return donorTypes;
    }

    public void reloadReassignedEnvScheme(EnvScheme scheme) throws SQLException, SBException {
        if (this.projects != null) {
            Iterator<Well> wit = this.projects.getProject(0).getWellIterator();
            while (wit.hasNext()) {
                Well well = wit.next();
                Iterator<WellInterp> iit = well.getInterpIterator();
                block1: while (iit.hasNext()) {
                    WellInterp wellInterp = iit.next();
                    for (EnvScheme e : wellInterp.getEnvSchemes()) {
                        if (e.getID() != scheme.getID()) continue;
                        wellInterp.loadEnvs(well);
                        wellInterp.setChanged(null);
                        IGDIntervalEnv arg = null;
                        Iterator<IGDIntervalEnv> i$ = wellInterp.getEnvs().iterator();
                        if (i$.hasNext()) {
                            IGDIntervalEnv env;
                            arg = env = i$.next();
                        }
                        if (arg == null) continue block1;
                        wellInterp.notifyObservers(arg);
                        continue block1;
                    }
                }
            }
        }
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public Userdef getUser() {
        return this.user;
    }

    public void setUser(String abr) throws SBException, SQLException {
        this.getUsers();
        for (Userdef temp : this.users.values()) {
            if (!temp.getAbr().equals(abr)) continue;
            this.user = temp;
            break;
        }
        if (this.user == null) {
            throw new SBException("Attempt to set user to invalid abbreviation: " + abr);
        }
    }

    public String getUserObjectTimestamp() throws SBException {
        if (this.getUser() == null) {
            throw new SBException("User not set in sbdb");
        }
        String strg = "'" + SB.DBdf.format(new Date()) + "',";
        strg = strg + this.getUser().getUsrID();
        return strg;
    }

    public boolean needsPassword() {
        return this.needsPassword;
    }

    public boolean hasTVDplan() {
        return this.hasTVDplan;
    }

    public boolean hasWellsMaster() {
        return this.hasWellsMaster;
    }

    public boolean hasCasingView() {
        return this.hasCasingView;
    }

    public static boolean isInterpDataType(int dType) throws SBException {
        switch (dType) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return false;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        throw new SBException("Unknown data type: " + dType + " passed to isInterpDataType");
    }

    public static native String getReg(String var0);

    public static native String getUReg(String var0);

    public static native String getRegOption(String var0);

    public static native String getURegOption(String var0);

    public Taxon getTaxon(int specID) throws SQLException {
        return this.taxa.getTaxon(specID);
    }

    public Taxon getTaxon(String donorString, int specID, boolean notNull) {
        Taxon taxon = this.taxa.getTaxon(donorString, specID);
        if (taxon == null) {
            taxon = this.taxa.parse(donorString, specID, notNull);
        }
        return taxon;
    }

    public Taxon getTaxon(Taxon.Builder builder) {
        return this.taxa.getTaxon(builder);
    }

    public void removeTaxon(Taxon taxon) {
        this.taxa.removeTaxon(taxon);
    }

    public List<Category> getCategoryList() throws SQLException {
        return this.taxa.getCategories();
    }

    public Category addCategory(String mnem, Discipline discID, String name, Color colour) throws SQLException {
        return this.taxa.addCategory(mnem, discID, name, colour);
    }

    public void deleteCategory(Category cat) throws SQLException, SBException {
        this.taxa.deleteCategory(cat);
    }

    public void updateCategory(Category cat, String abr, Discipline discID, String description, Color colour) throws SQLException {
        this.taxa.updateCategory(cat, abr, discID, description, colour);
    }

    public void loadCatGenOcc() throws SQLException {
        this.taxa.loadCatGenOcc();
    }

    public void setTaxonCat(int specID, String cat_mnem) {
        this.taxa.setTaxonCat(specID, cat_mnem);
    }

    public void fillCatCombo(JComboBox combo, boolean mnemOnly, Discipline discID) throws SQLException {
        this.taxa.fillCatCombo(combo, mnemOnly, discID);
    }

    public void setCatSelection(JComboBox combo, String mnem) {
        int selection = 0;
        for (int i = 0; i < combo.getModel().getSize(); ++i) {
            String comboString = (String)combo.getModel().getElementAt(i);
            if (comboString.isEmpty() || !comboString.split(" ")[0].equals(mnem)) continue;
            selection = i;
            break;
        }
        combo.setSelectedIndex(selection);
    }

    public Taxon[] lookupSpecies(String cat_mnem, String genus, String subGenus, String species, String subSpecies, Qualifier gq1, Qualifier gq2, Qualifier gq3, Qualifier gq4, Qualifier sq1, Qualifier sq2, Qualifier sq3, Qualifier sq4) throws SQLException {
        return this.taxa.lookupSpecies(cat_mnem, genus, subGenus, species, subSpecies, gq1, gq2, gq3, gq4, sq1, sq2, sq3, sq4);
    }

    public Genus[] lookupGenus(Genus.Builder genBuilder) throws SQLException {
        return this.taxa.lookupGenus(genBuilder);
    }

    public void checkDeleteGenus(int genID) throws SQLException, SBException {
        this.taxa.checkDeleteGenus(genID);
    }

    public Taxon lookupTaxon(String alphaCode) throws SQLException {
        return this.taxa.lookupTaxon(alphaCode);
    }

    public void lookupTaxonLink(Taxon taxon) throws SQLException {
        this.taxa.lookupTaxonLink(taxon);
    }

    public Genus addGenus(Genus.Builder builder) throws SQLException {
        return this.taxa.addGenus(builder);
    }

    public Taxon addTaxon(Taxon.Builder builder) throws SQLException {
        return this.taxa.addTaxon(builder);
    }

    public Taxon addTaxon(Taxon.Builder txBuilder, Genus.Builder genBuilder, String cat_mnem, int specID, String donorString) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to add Taxon to database");
        }
        Taxon taxon = this.taxa.get(specID);
        if (taxon == null) {
            taxon = this.taxa.addTaxon(txBuilder, genBuilder, cat_mnem, specID, null);
            taxon.donorString = donorString;
        } else {
            Category cat = this.taxa.getCategory(cat_mnem);
            if (cat != null) {
                genBuilder.category(cat);
            }
            if (!taxon.equalsBuilder(txBuilder) || !taxon.getGenus().equalsBuilder(genBuilder, false)) {
                throw new SBException("Duplicate species IDs in workspace for: " + taxon.toString() + " and " + genBuilder.getName() + " " + txBuilder.getName());
            }
        }
        return taxon;
    }

    public void copyLinkedTaxon(int specID) {
        this.taxa.copyLink(specID);
    }

    public void copyLinkedEvent(int evID) {
        this.events.copyLink(evID);
    }

    public Category getCategory(String mnem) throws SQLException {
        return this.taxa.getCategory(mnem);
    }

    public Collection<Overlay> getOverlays() throws SQLException {
        if (this.overlays == null) {
            this.overlays = Overlay.loadAll(this);
        }
        return this.overlays.values();
    }

    public Overlay getOverlay(int ovrID) throws SQLException {
        if (this.overlays == null) {
            this.overlays = Overlay.loadAll(this);
        }
        return this.overlays.get(ovrID);
    }

    public Overlay getOverlay(String name) throws SQLException {
        if (this.overlays == null) {
            this.overlays = Overlay.loadAll(this);
        }
        for (Overlay overlay : this.overlays.values()) {
            if (!overlay.getName().equalsIgnoreCase(name)) continue;
            return overlay;
        }
        return null;
    }

    public void addOverlay(Overlay overlay) throws SBException, SQLException {
        if (this.overlays == null) {
            this.overlays = Overlay.loadAll(this);
        }
        if (this.overlays.put(overlay.getOvrID(), overlay) != null) {
            throw new SBException("Error putting new overlay: Over;lay ID already exists");
        }
    }

    public int getSpecType(char form, char growth) throws SQLException {
        return this.getSpecType(this.getSpecTypeStringv18(form, growth));
    }

    public int getAddSpecType(char form, char growth, String speciesType) throws SQLException, SBException {
        String type = this.getSpecTypeStringv18(form, growth);
        if (speciesType != null) {
            if (!type.isEmpty()) {
                type = type + '/';
            }
            type = type + speciesType;
        }
        return this.getAddSpecType(type);
    }

    public int getSpecType(String specType) throws SQLException {
        if (specType == null || specType.length() == 0) {
            return 0;
        }
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        for (Integer key : this.specTypes.keySet()) {
            if (!this.specTypes.get(key).equalsIgnoreCase(specType)) continue;
            return key;
        }
        return -1;
    }

    public void updateSpecType(int ID, String specType) throws SQLException {
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        String sql = "UPDATE " + this.DBTableName("speciestype") + " SET descr=" + SB.DBString((String)specType) + " WHERE spec_type_id=" + ID;
        Statement stmt = this.getDatabase().createStatement();
        stmt.executeUpdate(this.modQuery(sql));
        stmt.close();
        this.specTypes.remove(ID);
        this.specTypes.put(ID, specType);
    }

    public void deleteSpecType(String specType) throws SQLException {
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        int ID = this.getSpecType(specType);
        String sql = "DELETE FROM " + this.DBTableName("speciestype") + " WHERE spec_type_id=" + ID;
        Statement stmt = this.getDatabase().createStatement();
        stmt.executeUpdate(this.modQuery(sql));
        stmt.close();
        this.specTypes.remove(ID);
    }

    public void clearSpecType() {
        this.specTypes = null;
    }

    public int getSpecTypeUsage(String specType) throws SQLException {
        int iType = this.getSpecType(specType);
        int nOccs = 0;
        if (iType > 0) {
            String sql = "SELECT count(spec_type_id) AS nocc FROM " + this.DBTableName("taxonocc") + " WHERE spec_type_id=" + iType;
            Statement stmt = this.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            if (rs.next()) {
                nOccs = rs.getInt("nocc");
            }
            stmt.close();
        }
        return nOccs;
    }

    public Iterator getSpecTypeIterator() throws SQLException {
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        return this.specTypes.values().iterator();
    }

    public String getSpecType(int typeID) throws SQLException {
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        return this.specTypes.get(typeID);
    }

    public boolean useSampleTops() {
        return this.useSampleTops;
    }

    public boolean allowMultipleEnvSchemes() {
        return this.allowMultipleEnvSchemes;
    }

    public int getAddSpecType(String specType) throws SQLException, SBException {
        int typeID = this.getSpecType(specType);
        if (typeID < 0 && this.isConnected()) {
            typeID = this.nextControl("speciestype", "spec_type_id");
            String sql = "INSERT INTO " + this.DBTableName("speciestype") + " (spec_type_id, descr) VALUES (" + typeID + "," + SB.DBString((String)specType) + ")";
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(this.modQuery(sql));
            stmt.close();
            this.specTypes.put(typeID, specType);
        } else if (typeID < 0) {
            int max = 0;
            for (int i : this.specTypes.keySet()) {
                if (i <= max) continue;
                max = i;
            }
            typeID = max + 1;
            this.specTypes.put(typeID, specType);
        }
        return typeID;
    }

    private void loadSpecTypes() throws SQLException {
        this.specTypes = new HashMap();
        if (this.isConnected()) {
            String sql = "SELECT spec_type_id, descr FROM " + this.DBTableName("speciestype");
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                this.specTypes.put(rs.getInt("spec_type_id"), rs.getString("descr"));
            }
            if (this.specTypes.get(0) == null) {
                sql = "INSERT INTO " + this.DBTableName("speciestype") + " (spec_type_id, descr) VALUES (0," + SB.DBString((String)specTypeDefault) + ")";
                stmt.executeUpdate(this.modQuery(sql));
            }
            stmt.close();
        }
        this.specTypes.put(0, specTypeDefault);
    }

    public HashMap<String, LogDef> getLogDef() throws SQLException {
        if (this.logDef == null) {
            this.logDef = new HashMap();
            LogDef.load(this, this.logDef);
        }
        return this.logDef;
    }

    public Color getColour(String abr) throws SQLException {
        return this.getCatColour(abr);
    }

    public Color getCatColour(String abr) throws SQLException {
        Color colour;
        if (this.catColours == null) {
            this.catColours = new HashMap();
        }
        if ((colour = this.catColours.get(abr)) == null) {
            String sql;
            Statement stmt = this.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.modQuery(sql = "SELECT red, green, blue FROM " + this.DBTableName("CATCOL") + " WHERE Ucase(abr)=" + SB.DBString((String)abr)));
            if (rs.next()) {
                int r = rs.getInt("red");
                int g = rs.getInt("green");
                int b = rs.getInt("blue");
                colour = new Color(r, g, b);
                this.catColours.put(abr, colour);
            }
            stmt.close();
        }
        return colour;
    }

    public Color getCatColour(String abr, Color defaultColor) throws SQLException {
        Color color = this.getCatColour(abr);
        if (color == null) {
            color = defaultColor;
        }
        return color;
    }

    public void setCatColour(String abr, Color colour) throws SQLException {
        if (this.catColours == null) {
            this.catColours = new HashMap();
        }
        if (this.catColours.get(abr) != colour) {
            Category.storeColour(this, colour, abr);
            this.catColours.remove(abr);
            this.catColours.put(abr, colour);
            if (this.getCategory(abr) != null) {
                this.getCategory(abr).setColour(colour);
            }
            this.setChanged();
            this.notifyObservers(colour);
        }
    }

    public TxGroupSet getTxGroupSet(int setID) throws SQLException {
        if (this.sets == null) {
            this.sets = TxGroupSet.loadAll(this);
        }
        return this.sets.get(setID);
    }

    public Collection<TxGroupSet> getTxGroupSets() throws SQLException {
        if (this.sets == null) {
            this.sets = TxGroupSet.loadAll(this);
        }
        return this.sets.values();
    }

    public List<TxGroupSet> getTxGroupSetsSorted() throws SQLException {
        if (this.sets == null) {
            this.sets = TxGroupSet.loadAll(this);
        }
        LinkedList<TxGroupSet> list = new LinkedList<TxGroupSet>(this.sets.values());
        Collections.sort(list);
        return list;
    }

    public TxGroupSet getTxGroupSet(String name) throws SQLException {
        if (this.sets == null) {
            this.sets = TxGroupSet.loadAll(this);
        }
        for (TxGroupSet set : this.sets.values()) {
            if (!set.getName().equalsIgnoreCase(name)) continue;
            return set;
        }
        return null;
    }

    public TxGroupSet addTxGroupSet(String name, Collection<TxGroup> groups) throws SQLException, SBException {
        HashSet<Integer> groupIDs = new HashSet<Integer>();
        for (TxGroup group : groups) {
            groupIDs.add(group.getID());
        }
        return this.addTxGroupSet(name, (Set<Integer>)groupIDs);
    }

    public TxGroupSet addTxGroupSet(String name, Set<Integer> groupIDs) throws SQLException, SBException {
        int setID;
        if (this.getTxGroupSet(name) != null) {
            throw new SBException("Set: " + name + " already exists");
        }
        if (this.isConnected()) {
            setID = this.nextControl("GROUPSET", "GRPSET_ID");
        } else {
            int maxID = 0;
            for (TxGroupSet s : this.sets.values()) {
                if (s.getID() <= maxID) continue;
                maxID = s.getID();
            }
            setID = ++maxID;
        }
        TxGroupSet set = new TxGroupSet(this, name, groupIDs, setID);
        this.getTxGroupSets();
        this.sets.put(setID, set);
        this.setChanged();
        return set;
    }

    public void deleteTxGroupSet(TxGroupSet set) throws SQLException, SBException {
        set.delete();
        this.sets.remove(set.getID());
    }

    public TxGroup getTxGroup(int groupID) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            TxGroup.load(this, this.txGroups);
        }
        return this.txGroups.get(groupID);
    }

    public TxGroup getTxGroup(String name) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            if (this.isConnected()) {
                TxGroup.load(this, this.txGroups);
            }
        }
        for (TxGroup group : this.txGroups.values()) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    public Collection<Taxon> getTxGroupTaxa(TxGroup group) throws SQLException {
        group.load();
        TreeSet<Taxon> set = new TreeSet<Taxon>();
        for (Integer i : group.getSpecIDs()) {
            set.add(this.getTaxon(i));
        }
        return set;
    }

    public void insertGroupTaxa(TxGroup group, Well well, char discID, String analyst) throws SQLException, SBException {
        LinkedList<Taxon> toAdd = new LinkedList<Taxon>();
        List<Integer> wellTaxa = this.getWellSpecIDs(well, discID, analyst);
        for (int specID : wellTaxa) {
            if (group.isMember(specID)) continue;
            toAdd.add(this.getTaxon(specID));
        }
        if (toAdd.size() > 0) {
            group.addTaxa(toAdd);
        }
    }

    public List<Taxon> getWellTaxa(Well well, char discID, String analyst) throws SQLException, SBException {
        LinkedList<Taxon> wellTaxa = new LinkedList<Taxon>();
        List<Integer> wellSpecID = this.getWellSpecIDs(well, discID, analyst);
        for (int specID : wellSpecID) {
            wellTaxa.add(this.getTaxon(specID));
        }
        return wellTaxa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Taxon> getTaxaWithImages() throws SQLException {
        String sql = "SELECT distinct(spec_id) FROM " + this.DBTableName("TXIMAGE");
        Statement stmt = this.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            LinkedList<Taxon> imageTaxa = new LinkedList<Taxon>();
            while (rs.next()) {
                int specID = rs.getInt("spec_id");
                imageTaxa.add(this.getTaxon(specID));
            }
            sql = "SELECT distinct(spec_id) FROM " + this.DBTableName("TAXONOCC") + " WHERE image_set_id IS NOT NULL";
            ResultSet rs2 = stmt.executeQuery(this.modQuery(sql));
            while (rs2.next()) {
                int specID = rs2.getInt("spec_id");
                Taxon t = this.getTaxon(specID);
                if (imageTaxa.contains(t)) continue;
                imageTaxa.add(t);
            }
            LinkedList<Taxon> linkedList = imageTaxa;
            return linkedList;
        }
        finally {
            stmt.close();
        }
    }

    private List<Integer> getWellSpecIDs(Well well, char discID, String analyst) throws SQLException, SBException {
        String sql = "SELECT distinct(spec_id) FROM " + this.DBTableName("TAXONOCC") + " f, " + this.DBTableName("ANALY_HDR") + " h WHERE f.well_id=" + well.wellID;
        sql = sql + " AND f.well_id=h.well_id AND f.analy_id=h.analy_id AND h.disc_id=" + SB.DBChar((char)discID);
        if (analyst != null && analyst.length() > 0) {
            sql = sql + " AND h.analyst=" + this.getUserID(analyst);
        }
        Statement stmt = this.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        LinkedList<Integer> wellTaxa = new LinkedList<Integer>();
        while (rs.next()) {
            int specID = rs.getInt("spec_id");
            wellTaxa.add(specID);
        }
        stmt.close();
        return wellTaxa;
    }

    public void deleteTxGroup(TxGroup group) throws SQLException, SBException {
        group.delete();
        this.txGroups.remove(group.getID());
        this.setChanged();
        this.notifyObservers(group);
    }

    public TxGroup copyToDatabase(SBdb ws, TxGroup wsGroup) throws SQLException, SBException {
        TxGroup dbGroup = TxGroup.copyToDatabase(ws, this, wsGroup);
        this.putTxGroup(dbGroup);
        this.setChanged();
        this.notifyObservers(dbGroup);
        return dbGroup;
    }

    public TxGroup addTxGroup(String name, String abr, int groupID) throws SQLException, SBException {
        if (this.getTxGroup(name) != null) {
            throw new SBException("Group:" + name + " already exists");
        }
        int ID = groupID > 0 ? groupID : (this.isConnected() ? TxGroup.nextControl(this) : this.nextTxGroupID());
        TxGroup group = new TxGroup(this, name, abr, ID);
        this.putTxGroup(group);
        this.setChanged();
        this.notifyObservers(group);
        return group;
    }

    private void putTxGroup(TxGroup group) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
        }
        this.txGroups.put(group.getID(), group);
    }

    public Collection<TxGroup> getTxGroups() throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            if (this.isConnected()) {
                TxGroup.load(this, this.txGroups);
            }
        }
        return this.txGroups.values();
    }

    public List<TxGroup> getTxGroupsSorted() throws SQLException {
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>(this.getTxGroups());
        Collections.sort(groups);
        return groups;
    }

    HashMap<Integer, InterpHdr> getInterpHdrs() throws SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        return this.interpHdrs;
    }

    public synchronized List<EnvScheme> getEnvSchemes() throws SQLException, SBException {
        if (this.envSchemes == null) {
            this.envSchemes = new LinkedList<EnvScheme>();
            if (this.isConnected()) {
                EnvScheme.loadAll(this, this.envSchemes);
            }
        }
        return this.envSchemes;
    }

    public synchronized void addEnvScheme(EnvScheme scheme) throws SBException, SQLException {
        this.getEnvSchemes();
        for (EnvScheme e : this.envSchemes) {
            if (!e.getName().equals(scheme.getName())) continue;
            throw new SBException("New scheme name is not unique");
        }
        if (this.isConnected()) {
            scheme.store(this);
        }
        int index = 0;
        for (EnvScheme e : this.envSchemes) {
            if (e.getName().compareToIgnoreCase(scheme.getName()) > 0) break;
            ++index;
        }
        this.envSchemes.add(index, scheme);
    }

    public void addEnvScheme(EnvScheme scheme, int schemeID) throws SBException, SQLException {
        if (this.envSchemes == null) {
            this.getEnvSchemes();
        }
        for (EnvScheme e : this.envSchemes) {
            if (!e.getName().equals(scheme.getName())) continue;
            throw new SBException("New scheme name is not unique: " + scheme.getName());
        }
        scheme.store(this, schemeID);
        this.envSchemes.add(scheme);
    }

    synchronized void refreshEnvSchemes(Statement stmt) throws SQLException, SBException {
        if (this.envSchemes != null) {
            String sql = "SELECT envsch_id,updated ";
            sql = sql + " FROM " + this.DBTableName("env_sch");
            sql = this.modQuery(sql);
            ResultSet rs = stmt.executeQuery(sql);
            EnvScheme notifier = null;
            HashSet<Integer> keys = new HashSet<Integer>();
            while (rs.next()) {
                int key = rs.getInt("envsch_id");
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (EnvScheme a : this.envSchemes) {
                    if (a.getID() != key) continue;
                    found = true;
                    if (time == null || !time.after(a.getUpdated())) break;
                    EnvScheme scheme = new EnvScheme(this, key);
                    a.copy(scheme, true);
                    notifier = a;
                    break;
                }
                if (found) continue;
                notifier = new EnvScheme(this, key);
                this.envSchemes.add(notifier);
            }
            if (keys.size() < this.envSchemes.size()) {
                Iterator<EnvScheme> it = this.envSchemes.iterator();
                while (it.hasNext()) {
                    EnvScheme a = it.next();
                    if (keys.contains(a.getID())) continue;
                    it.remove();
                    notifier = a;
                }
            }
            if (notifier != null) {
                this.setChanged();
                this.notifyObservers(notifier);
            }
        }
    }

    public void setImageFolder(String imageFolder) {
        this.imageFolder = imageFolder;
    }

    public String getImageFolder() throws SQLException {
        if (this.imageFolder != null) {
            return this.imageFolder;
        }
        if (this.isConnected()) {
            this.imageFolder = this.getDatabasePref("imagefolder");
            if (this.imageFolder.isEmpty()) {
                this.imageFolder = null;
            }
        }
        return this.imageFolder;
    }

    public SBImage getImage(int imageID) throws SQLException {
        SBImage image = this.images.get(imageID);
        if (image == null) {
            image = new SBImage(this, imageID);
            this.images.put(imageID, image);
        }
        return image;
    }

    public void deleteImage(int imageID) throws SQLException, SBException {
        SBImage image = this.images.get(imageID);
        if (image == null) {
            image = new SBImage(this, imageID);
        }
        if (image != null) {
            image.delete();
            this.images.remove(imageID);
        }
    }

    void putImage(SBImage image) {
        this.images.put(image.getImageID(), image);
    }

    public List<AbnScheme> getAbnSchemes() throws SQLException {
        if (this.abnSchemes == null) {
            this.abnSchemes = new LinkedList<AbnScheme>();
            if (this.isConnected()) {
                AbnScheme.loadAll(this, this.abnSchemes);
            }
        }
        return this.abnSchemes;
    }

    public void addAbnScheme(AbnScheme scheme) throws SQLException, SBException {
        this.getAbnSchemes();
        if (this.isConnected()) {
            scheme.store(this);
        }
        this.abnSchemes.add(scheme);
        Collections.sort(this.abnSchemes);
    }

    synchronized void refreshAbnSchemes(Statement stmt) throws SQLException, SBException {
        if (this.abnSchemes != null) {
            String sql = "SELECT scheme_id,updated ";
            sql = sql + " FROM " + this.DBTableName("abnschme");
            sql = this.modQuery(sql);
            ResultSet rs = stmt.executeQuery(sql);
            boolean doNotify = false;
            HashSet<Integer> keys = new HashSet<Integer>();
            while (rs.next()) {
                int key = rs.getInt("scheme_id");
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (AbnScheme a : this.abnSchemes) {
                    if (a.getID() != key) continue;
                    found = true;
                    if (time == null || !time.after(a.getUpdated())) break;
                    AbnScheme scheme = new AbnScheme(this, key);
                    a.copy(scheme);
                    doNotify = true;
                    break;
                }
                if (found) continue;
                doNotify = true;
            }
            if (keys.size() < this.abnSchemes.size()) {
                Iterator<AbnScheme> it = this.abnSchemes.iterator();
                while (it.hasNext()) {
                    AbnScheme a = it.next();
                    if (keys.contains(a.getID())) continue;
                    it.remove();
                    doNotify = true;
                }
            }
            if (doNotify) {
                this.setChanged();
            }
        }
    }

    public void addAbnScheme(AbnScheme scheme, int schemeID) throws SQLException, SBException {
        scheme.store(this, schemeID);
        this.getAbnSchemes();
        this.abnSchemes.add(scheme);
        Collections.sort(this.abnSchemes);
    }

    public void deleteEnvScheme(EnvScheme scheme) throws SQLException, SBException {
        scheme.deleteEntries();
        scheme.delete();
        this.envSchemes.remove(scheme);
    }

    public void deleteIGDScheme(IGDScheme scheme) throws SQLException, SBException {
        if (this.isConnected()) {
            scheme.delete();
        }
        switch (scheme.getIGDType()) {
            case 3: {
                this.chronoSchemes.remove(scheme.getID());
                break;
            }
            case 4: {
                this.biozoneSchemes.remove(scheme.getID());
                break;
            }
            case 2: {
                this.lstratSchemes.remove(scheme.getID());
                break;
            }
            case 10: {
                this.sequenceSchemes.remove(scheme.getID());
                break;
            }
            default: {
                throw new SBException("Cannot remove scheme, unknown IGD type: " + scheme.getIGDType());
            }
        }
        this.setChanged();
        this.notifyObservers(scheme);
    }

    public IGDScheme addIGDScheme(IGDScheme scheme) throws SQLException, SBException {
        if (scheme.getSchID() <= 0) {
            throw new IllegalArgumentException("Attempt to add scheme with ID " + scheme.getSchID());
        }
        this.getIGDSchemes(scheme.getIGDType());
        switch (scheme.getIGDType()) {
            case 3: {
                this.chronoSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 4: {
                this.biozoneSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 2: {
                this.lstratSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 10: {
                this.sequenceSchemes.put(scheme.getID(), scheme);
                break;
            }
            default: {
                throw new SBException("Cannot add new scheme '" + scheme.toString() + "', unknown IGD type: " + scheme.getIGDType());
            }
        }
        this.setChanged();
        this.notifyObservers(scheme);
        return scheme;
    }

    public IGDScheme addIGDScheme(int igdType, String name) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to add workspace scheme to a connected database.");
        }
        int schID = 1;
        schID = this.findMaxID(schID, this.chronoSchemes);
        schID = this.findMaxID(schID, this.lstratSchemes);
        schID = this.findMaxID(schID, this.biozoneSchemes);
        schID = this.findMaxID(schID, this.sequenceSchemes);
        IGDScheme scheme = new IGDScheme(this, igdType, name, igdType == 4 ? Discipline.MICRO : null, igdType == 10 ? IGDScheme.SequenceType.DEPOSITIONAL : null);
        scheme.setSchID(schID);
        return this.addIGDScheme(scheme);
    }

    public void mergeAbnScheme(AbnScheme target, AbnScheme donor) throws SQLException, SBException {
        target.merge(donor);
        this.abnSchemes.remove(donor);
        Iterator<Well> it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            Iterator<AnalystHeader> itra = well.getAnalystHeaderIterator();
            while (itra.hasNext()) {
                AnalystHeader h = itra.next();
                if (h.getAbnSchID() != donor.getID()) continue;
                h.replaceAbnScheme(target.getID());
            }
        }
    }

    public Collection<SynonymScheme> getSynSchemes() throws SQLException {
        if (this.synSch == null) {
            this.synSch = SynonymScheme.getSchemes(this);
        }
        return this.synSch.values();
    }

    public SynonymScheme getSynSch(int schID) throws SQLException {
        if (this.synSch == null) {
            this.synSch = SynonymScheme.getSchemes(this);
        }
        return this.synSch.get(schID);
    }

    public AbnScheme getDefaultAbnScheme() throws SQLException {
        this.getAbnSchemes();
        AbnScheme abnScheme = AbnScheme.getDefault(this, this.abnSchemes);
        return abnScheme;
    }

    public AbnScheme getAbnScheme(int abnSchID, boolean load) throws SQLException {
        this.getAbnSchemes();
        if (load) {
            AbnScheme.loadAll(this, this.abnSchemes);
        }
        for (AbnScheme abnScheme : this.abnSchemes) {
            if (abnScheme.getID() != abnSchID) continue;
            return abnScheme;
        }
        return null;
    }

    public AbnScheme getAbnScheme(Well well, int analyID, boolean useDefault) throws SQLException, SBException {
        AnalystHeader header = well.getAnalystHeader(analyID, true);
        if (header != null) {
            return this.getAbnScheme(header.getAbnSchID(), true);
        }
        if (useDefault) {
            return this.getDefaultAbnScheme();
        }
        return null;
    }

    public LinkedList<TaxonWellImage> getTaxonImages(Taxon taxon) throws SQLException, SBException {
        LinkedList<TaxonWellImage> list = new LinkedList<TaxonWellImage>();
        if (this.isConnected()) {
            Statement stmt = this.getDatabase().createStatement();
            String sql = "SELECT image_set_id, type FROM " + this.DBTableName("TXIMAGE") + " WHERE spec_id=" + taxon.getSpecID() + " ORDER BY type DESC";
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int imageSetID = rs.getInt("image_set_id");
                TaxonWellImage item = new TaxonWellImage();
                item.well = null;
                item.sample = null;
                item.smpdtl = null;
                item.imageSet = new ImageSet(this, imageSetID);
                item.isType = SB.getDBChar((ResultSet)rs, (String)"type") == 'Y';
                list.add(item);
            }
            sql = "SELECT well_id,samp_id,analy_id,image_set_id FROM " + this.DBTableName("TAXONOCC") + " WHERE spec_id=" + taxon.getSpecID() + " AND image_set_id IS NOT NULL";
            rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int sampID = rs.getInt("samp_id");
                int analyID = rs.getInt("analy_id");
                int imageSetID = rs.getInt("image_set_id");
                TaxonWellImage item = new TaxonWellImage();
                item.well = this.getAddWell(wellID);
                item.sample = new Sample(this, wellID, sampID, item.well.getType());
                item.sample.loadDetails(wellID);
                item.smpdtl = item.sample.getSmpdtl(analyID);
                item.imageSet = new ImageSet(this, imageSetID);
                for (TaxonWellImage twi : list) {
                    if (twi.imageSet.getID() != item.imageSet.getID()) continue;
                    if (twi.isType) {
                        item.isType = true;
                    }
                    list.remove(twi);
                    break;
                }
                list.add(item);
            }
            stmt.close();
            ImageSet unreferenced = taxon.getUnreferencedImages();
            if (unreferenced != null && unreferenced.getSize(false) > 0) {
                TaxonWellImage item = new TaxonWellImage();
                item.imageSet = unreferenced;
                item.isType = true;
                list.add(item);
            }
        } else {
            if (taxon.getWsImageSets() != null) {
                for (ImageSet set : taxon.getWsImageSets()) {
                    TaxonWellImage item = new TaxonWellImage();
                    item.well = null;
                    item.sample = null;
                    item.smpdtl = null;
                    item.imageSet = set;
                    list.add(item);
                }
            }
            Iterator<Well> itWell = this.getProject(0).getWellIterator();
            while (itWell.hasNext()) {
                Well well = itWell.next();
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.getAnalyses()) {
                        if (!smpdtl.hasSpecies(taxon.getSpecID())) continue;
                        for (TaxonOcc occ : smpdtl.getOccur()) {
                            if (occ.getSpecID() != taxon.getSpecID() || occ.getImageSet() == null || occ.getImageSet().getSize() <= 0) continue;
                            TaxonWellImage item = new TaxonWellImage();
                            item.well = well;
                            item.sample = sample;
                            item.smpdtl = smpdtl;
                            item.imageSet = occ.getImageSet();
                            list.add(item);
                        }
                    }
                }
            }
        }
        return list;
    }

    public void deleteAbnScheme(AbnScheme scheme) throws SQLException, SBException {
        scheme.delete();
        this.abnSchemes.remove(scheme);
    }

    public boolean hasEvents() {
        return this.events.hasEvents();
    }

    public SBEvent getSBEvent(int evID) throws SQLException {
        return this.events.getEvent(evID);
    }

    public SBEvent getSBEvent(String evName) throws SQLException, SBException {
        return this.events.getEvent(evName, 0, null, null);
    }

    public SBEvent getSBEvent(String evName, boolean single) throws SQLException {
        return this.events.getEvent(evName, 0, single, null);
    }

    public SBEvent getSBEventGenerate(int specID) throws SQLException {
        SBEvent event = this.events.getEvent(null, specID, false, true);
        if (event != null && event.isGenerate()) {
            return event;
        }
        return null;
    }

    public List<SBEvent> getSBEvents(int specID) throws SQLException {
        return this.events.getEvents(specID);
    }

    public List<SBEvent> getSBEvents(boolean loadAll) throws SQLException {
        if (loadAll && this.isConnected()) {
            this.events.loadAll();
        }
        return this.events.getEvents();
    }

    public SBEvent addSBEvent(SBEvent.Builder builder) throws SQLException {
        return this.events.addEvent(builder);
    }

    public SBEvent addSBEvent(SBEvent.Builder builder, int evID) throws SQLException {
        return this.events.addEvent(builder, evID);
    }

    public SBEvent addSBEvent(SBEvent.Builder builder, String taxonName) throws SQLException {
        if (builder.getTaxon() == null && taxonName != null && !taxonName.isEmpty()) {
            builder.taxon(this.taxa.getTaxonFromName(taxonName));
        }
        return this.addSBEvent(builder);
    }

    public void updateSBEventName(SBEvent event, String name) throws SQLException, SBException {
        assert (this.events.getEvent(event.getEvID()) == event);
        event.updateName(name);
        event.notifyObservers();
    }

    public void updateSBEvent(SBEvent event, SBEvent.Builder builder) throws SQLException, SBEvent.GenerateUniqueException {
        this.events.updateEvent(event.getEvID(), builder);
    }

    public EnvScheme getEnvScheme(int schID) throws SQLException, SBException {
        if (this.envSchemes == null) {
            this.envSchemes = new LinkedList<EnvScheme>();
            if (this.isConnected()) {
                EnvScheme.loadAll(this, this.envSchemes);
            }
        }
        for (EnvScheme scheme : this.envSchemes) {
            if (scheme.getID() != schID) continue;
            return scheme;
        }
        return null;
    }

    public EnvScheme getEnvScheme(String schemeName) throws SQLException, SBException {
        if (this.envSchemes == null) {
            this.envSchemes = new LinkedList<EnvScheme>();
            if (this.isConnected()) {
                EnvScheme.loadAll(this, this.envSchemes);
            }
        }
        for (EnvScheme scheme : this.envSchemes) {
            if (!scheme.getName().equals(schemeName)) continue;
            return scheme;
        }
        return null;
    }

    public Collection<CompositeStandard> getCompositeStandards() throws SQLException {
        this.initComposites();
        return new LinkedList<CompositeStandard>(this.compositeStandards.values());
    }

    private void initComposites() throws SQLException {
        if (this.compositeStandards != null) {
            return;
        }
        if (this.compositeStandards == null) {
            this.compositeStandards = new HashMap();
            if (this.isConnected()) {
                List<CompositeStandard> stds = CompositeStandard.loadAll(this);
                for (CompositeStandard std : stds) {
                    this.putComposite(std);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putComposite(CompositeStandard std) {
        if (std.getStdID() <= 0) {
            throw new IllegalArgumentException("Attempt to put composite with ID: " + std.getStdID());
        }
        HashMap<Integer, CompositeStandard> hashMap = this.compositeStandards;
        synchronized (hashMap) {
            CompositeStandard orig = this.compositeStandards.put(std.getStdID(), std);
            if (orig != null && orig != std) {
                throw new IllegalStateException("New composite '" + std + "' replaced old '" + orig + "', ID: " + std.getStdID());
            }
        }
    }

    public CompositeStandard addCompositeStandard(String name, double minAge, double maxAge, double topCSU, double baseCSU, boolean ageScale, List<CompositeStandardEvent.Builder> builders, Audit audit) throws SQLException, InvalidFieldException {
        int stdID = this.isConnected() ? this.nextControl("CMPSTD", "STD_ID") : this.nextStdID();
        CompositeStandard cmpStd = new CompositeStandard(this, stdID, name, minAge, maxAge, topCSU, baseCSU, ageScale, builders, audit);
        this.initComposites();
        for (CompositeStandard std : this.compositeStandards.values()) {
            if (!std.getName().equalsIgnoreCase(cmpStd.getName())) continue;
            throw new InvalidFieldException("Composite Standard to be added already exists in model");
        }
        this.putComposite(cmpStd);
        this.setChanged();
        return cmpStd;
    }

    public CompositeStandard getCompositeStandard(int stdID) throws SQLException {
        this.initComposites();
        return this.compositeStandards.get(stdID);
    }

    public CompositeStandard getCompositeStandard(String name) throws SQLException {
        this.initComposites();
        for (CompositeStandard std : this.compositeStandards.values()) {
            if (!std.getName().equalsIgnoreCase(name)) continue;
            return std;
        }
        return null;
    }

    public CompositeStandard recalibrateComposite(CompositeStandard original, IGDScheme chronoOld, IGDScheme chronoNew, String newName) throws SQLException, InvalidFieldException {
        original.loadEvents();
        LinkedList<CompositeStandardEvent.Builder> cmpEvents = new LinkedList<CompositeStandardEvent.Builder>();
        for (CompositeStandardEvent event : original.getEvents()) {
            CompositeStandardEvent.Builder b = CompositeStandardEvent.Builder.copyOf(event).event(event.getEvent());
            b.csu(chronoNew.getRecalibratedAge(chronoOld, event.getCSU()));
            cmpEvents.add(b);
        }
        CompositeStandard copy = this.addCompositeStandard(newName, original.getMinAge(), original.getMaxAge(), original.getTopCSU(), original.getBaseCSU(), original.isAgeScale(), cmpEvents, null);
        this.commit();
        return copy;
    }

    public CompositeStandard fillCompositeStandard(CompositeStandard std) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill composite to connected workspace");
        }
        if (std.getDatabase() == this) {
            throw new IllegalArgumentException("Attempt to copy composite within same model");
        }
        this.initComposites();
        CompositeStandard wsStd = this.getCompositeStandard(std.getStdID());
        if (wsStd == null) {
            wsStd = new CompositeStandard(this, std);
            this.putComposite(wsStd);
        }
        return wsStd;
    }

    public CompositeStandard copyCompositeStandard(CompositeStandard std, String name) throws InvalidFieldException, SQLException {
        if (std.getDatabase() != this) {
            throw new IllegalStateException("Attempt to copy compositeStandard to a different model");
        }
        this.initComposites();
        if (this.getCompositeStandard(name) != null) {
            throw new InvalidFieldException("A composite with this name already exists");
        }
        LinkedList<CompositeStandardEvent.Builder> cmpEvents = new LinkedList<CompositeStandardEvent.Builder>();
        std.loadEvents();
        for (CompositeStandardEvent event : std.getEvents()) {
            cmpEvents.add(CompositeStandardEvent.Builder.copyOf(event).event(event.getEvent()));
        }
        CompositeStandard copy = this.addCompositeStandard(name, std.getMinAge(), std.getMaxAge(), std.getTopCSU(), std.getBaseCSU(), std.isAgeScale(), cmpEvents, null);
        this.commit();
        this.setChanged();
        this.notifyObservers(copy);
        return copy;
    }

    private int nextStdID() {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to get next composite standard ID in connected database");
        }
        try {
            this.initComposites();
        }
        catch (SQLException e) {
            // empty catch block
        }
        int maxID = 1;
        for (CompositeStandard std : this.compositeStandards.values()) {
            if (std.getStdID() < maxID) continue;
            maxID = std.getStdID() + 1;
        }
        return maxID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshCompositeStandards(Statement stmt) throws SQLException, SBException {
        if (this.compositeStandards == null) {
            return;
        }
        HashMap<Integer, CompositeStandard> hashMap = this.compositeStandards;
        synchronized (hashMap) {
            String sql = "SELECT std_id,updated FROM " + this.DBTableName("CMPSTD");
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            boolean doNotify = false;
            HashSet<Integer> keys = new HashSet<Integer>();
            while (rs.next()) {
                int key = rs.getInt("std_id");
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (CompositeStandard c : this.compositeStandards.values()) {
                    if (c.getStdID() != key) continue;
                    found = true;
                    if (time == null || !time.after(c.getAudit().updated)) break;
                    CompositeStandard.load(this, key, c);
                    doNotify = true;
                    break;
                }
                if (found) continue;
                doNotify = true;
            }
            if (keys.size() < this.compositeStandards.size()) {
                Iterator<CompositeStandard> it = this.compositeStandards.values().iterator();
                while (it.hasNext()) {
                    CompositeStandard c = it.next();
                    if (keys.contains(c.getStdID())) continue;
                    it.remove();
                    doNotify = true;
                }
            }
            if (doNotify) {
                // empty if block
            }
        }
    }

    void refreshEvents(Statement stmt) throws SQLException, SBException {
        this.events.refreshEvents(stmt);
    }

    void refreshTaxa(Statement stmt) throws SQLException, SBException {
        this.taxa.refreshTaxa(stmt);
    }

    public Collection<IGDScheme> getIGDSchemes(int igdType) throws SQLException {
        switch (igdType) {
            case 3: {
                if (this.chronoSchemes == null) {
                    this.loadChronoSchemes();
                }
                return this.chronoSchemes.values();
            }
            case 2: {
                if (this.lstratSchemes == null) {
                    this.loadLstratSchemes();
                }
                return this.lstratSchemes.values();
            }
            case 4: {
                if (this.biozoneSchemes == null) {
                    this.loadBiozoneSchemes();
                }
                return this.biozoneSchemes.values();
            }
            case 10: {
                if (this.sequenceSchemes == null) {
                    this.loadSequenceSchemes();
                }
                return this.sequenceSchemes.values();
            }
        }
        return null;
    }

    public IGDScheme getIGDScheme(int schID) throws SQLException {
        IGDScheme scheme = null;
        if (this.chronoSchemes == null) {
            this.loadChronoSchemes();
        }
        if (this.chronoSchemes != null && (scheme = this.chronoSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.lstratSchemes == null) {
            this.loadLstratSchemes();
        }
        if (this.lstratSchemes != null && (scheme = this.lstratSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.biozoneSchemes == null) {
            this.loadBiozoneSchemes();
        }
        if (this.biozoneSchemes != null && (scheme = this.biozoneSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.sequenceSchemes == null) {
            this.loadSequenceSchemes();
        }
        if (this.sequenceSchemes != null && (scheme = this.sequenceSchemes.get(schID)) != null) {
            return scheme;
        }
        return null;
    }

    public IGDScheme getIGDScheme(String name, int igdType) throws SQLException, SBException {
        Iterator<IGDScheme> it = null;
        switch (igdType) {
            case 3: {
                if (this.chronoSchemes == null) {
                    this.loadChronoSchemes();
                }
                it = this.chronoSchemes.values().iterator();
                break;
            }
            case 2: {
                if (this.lstratSchemes == null) {
                    this.loadLstratSchemes();
                }
                it = this.lstratSchemes.values().iterator();
                break;
            }
            case 4: {
                if (this.biozoneSchemes == null) {
                    this.loadBiozoneSchemes();
                }
                it = this.biozoneSchemes.values().iterator();
                break;
            }
            case 10: {
                if (this.sequenceSchemes == null) {
                    this.loadSequenceSchemes();
                }
                it = this.sequenceSchemes.values().iterator();
                break;
            }
            default: {
                throw new SBException("Unknown IGD type in getIGDScheme: " + igdType);
            }
        }
        while (it.hasNext()) {
            IGDScheme scheme = it.next();
            if (!scheme.toString().equalsIgnoreCase(name)) continue;
            return scheme;
        }
        return null;
    }

    public IGDScheme getIGDScheme(int schID, int igdType) throws SQLException {
        switch (igdType) {
            case 3: {
                if (this.chronoSchemes == null) {
                    this.loadChronoSchemes();
                }
                return this.chronoSchemes.get(schID);
            }
            case 2: {
                if (this.lstratSchemes == null) {
                    this.loadLstratSchemes();
                }
                return this.lstratSchemes.get(schID);
            }
            case 4: {
                if (this.biozoneSchemes == null) {
                    this.loadBiozoneSchemes();
                }
                return this.biozoneSchemes.get(schID);
            }
            case 10: {
                if (this.sequenceSchemes == null) {
                    this.loadSequenceSchemes();
                }
                return this.sequenceSchemes.get(schID);
            }
        }
        return null;
    }

    private synchronized void refreshIGDSchemes(Statement stmt) throws SQLException, SBException {
        if (this.chronoSchemes != null) {
            this.refreshIGDSchemes(stmt, 3, this.chronoSchemes);
        }
        if (this.lstratSchemes != null) {
            this.refreshIGDSchemes(stmt, 2, this.lstratSchemes);
        }
        if (this.biozoneSchemes != null) {
            this.refreshIGDSchemes(stmt, 4, this.biozoneSchemes);
        }
        if (this.sequenceSchemes != null) {
            this.refreshIGDSchemes(stmt, 10, this.sequenceSchemes);
        }
    }

    private synchronized void refreshIGDSchemes(Statement stmt, int igdType, HashMap<Integer, IGDScheme> schemes) throws SQLException, SBException {
        String sql = "SELECT sch_id,updated ";
        sql = sql + " FROM " + this.DBTableName("IGD_SCH") + " WHERE igd_type=" + igdType;
        sql = this.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        IGDScheme notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("sch_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDScheme o : schemes.values()) {
                if (o.getSchID() != key) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                IGDScheme.load(this, key, o);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = IGDScheme.load(this, key, null);
            schemes.put(key, notifier);
        }
        Iterator<IGDScheme> it = schemes.values().iterator();
        while (it.hasNext()) {
            IGDScheme o = it.next();
            if (!keys.contains(o.getSchID())) {
                it.remove();
                if (notifier != null) continue;
                notifier = o;
                continue;
            }
            o.refresh(stmt);
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    private void loadChronoSchemes() throws SQLException {
        this.chronoSchemes = new HashMap();
        if (this.isConnected()) {
            List list = IGDScheme.getSchemes(this, 3);
            for (Object o : list) {
                IGDScheme scheme = (IGDScheme)o;
                this.chronoSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    private void loadLstratSchemes() throws SQLException {
        this.lstratSchemes = new HashMap();
        if (this.isConnected()) {
            List list = IGDScheme.getSchemes(this, 2);
            for (Object o : list) {
                IGDScheme scheme = (IGDScheme)o;
                this.lstratSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    private void loadBiozoneSchemes() throws SQLException {
        this.biozoneSchemes = new HashMap();
        if (this.isConnected()) {
            List list = IGDScheme.getSchemes(this, 4);
            for (Object o : list) {
                IGDScheme scheme = (IGDScheme)o;
                this.biozoneSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    private void loadSequenceSchemes() throws SQLException {
        this.sequenceSchemes = new HashMap();
        if (this.isConnected()) {
            List list = IGDScheme.getSchemes(this, 10);
            for (Object o : list) {
                IGDScheme scheme = (IGDScheme)o;
                this.sequenceSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    public Userdef getUser(int userID) throws SQLException {
        if (this.users == null) {
            this.getUsers();
        }
        return this.users.get(userID);
    }

    public int getUserID(String userAbr) throws SQLException {
        if (userAbr == null || userAbr.length() == 0) {
            return 0;
        }
        Userdef u = this.getUser(userAbr);
        if (u == null) {
            return 0;
        }
        return u.getUsrID();
    }

    public int getUserID() {
        if (this.user == null) {
            return 0;
        }
        return this.user.getUsrID();
    }

    public Userdef getUser(String userAbr) throws SQLException {
        if (this.users == null) {
            this.getUsers();
        }
        for (Userdef temp : this.users.values()) {
            String s = temp.getAbr();
            if (s == null || !s.equals(userAbr)) continue;
            return temp;
        }
        return null;
    }

    public void putUser(Userdef user) throws SQLException {
        if (this.users == null) {
            this.getUsers();
        }
        if (this.users.get(user.getUsrID()) == null) {
            this.users.put(new Integer(user.getUsrID()), user);
        }
    }

    public void putUserIDs(List<Integer> userIDList) {
        for (Integer userID : userIDList) {
            if (this.userIDs.contains(userID)) continue;
            this.userIDs.add(userID);
        }
    }

    public List getUserIDs() {
        return this.userIDs;
    }

    void removeUser(String userID) throws SQLException {
        this.users.remove(this.getUserID(userID));
    }

    public Collection<Userdef> getUsers() throws SQLException {
        if (this.users == null) {
            this.users = new TreeMap();
            if (this.isConnected()) {
                for (Userdef u : Userdef.getUsers(this)) {
                    if (u.getUsrID() <= 0) {
                        throw new IllegalArgumentException("Attempt to add user with ID: " + u.getUsrID());
                    }
                    if (this.users.get(u.getUsrID()) != null) {
                        throw new IllegalArgumentException("Attempt to add duplicate user: " + u.getAbr());
                    }
                    this.putUser(u);
                }
            }
        }
        return this.users.values();
    }

    public void mergeUsers(Userdef donor, Userdef target) throws SQLException {
        int nMatches;
        ResultSet rs2;
        int well_id;
        String[] auditTables = new String[]{"ABNSCHME", "AGE_CURVE", "ANALY_HDR", "BCMMNTS", "CASING", "CMPSTD", "CMPSTDEV", "CORES", "ENV_SCH", "EVENTDIC", "EVENTS", "FAULTS", "GENUS", "GROUPSET", "IGD", "IGD_DICT", "IGD_ENV", "IGD_HDR", "IGD_SCH", "INTCMMNTS", "INTERP", "LOC", "LOG_CURVE", "OVERLAY", "SAMPLES", "SBCHARTS", "SBSLITH", "SBSSR", "SBWLLST", "SMPDTL", "SPECIES", "SQPICK", "SURFACE", "TAXONOCC", "TXGROUP", "WELLS", "WELLSMARK"};
        Statement stmt = this.getDatabase().createStatement(1004, 1008);
        Statement stmt2 = this.getDatabase().createStatement();
        int donorID = donor.getUsrID();
        int targetID = target.getUsrID();
        String sql = "SELECT well_id,disc_id,analy_no,analyst FROM " + this.DBTableName("ANALY_HDR") + " WHERE analyst=" + donorID;
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            well_id = rs.getInt("well_id");
            char disc_id = SB.getDBChar((ResultSet)rs, (String)"disc_id");
            int analy_no = rs.getInt("analy_no");
            int analystTemp = rs.getInt("analyst");
            sql = "SELECT COUNT(analy_id) AS nMatches FROM " + this.DBTableName("ANALY_HDR") + " WHERE analyst=" + targetID + " AND well_id=" + well_id + " AND analy_no=" + analy_no + " AND disc_id=" + SB.DBChar((char)disc_id);
            rs2 = stmt2.executeQuery(this.modQuery(sql));
            nMatches = -1;
            if (rs2.next()) {
                nMatches = rs2.getInt("nMatches");
            }
            rs.refreshRow();
            if (nMatches > 0) {
                boolean allowed = false;
                int matches = -1;
                while (!allowed) {
                    sql = "SELECT COUNT(analy_id) as nMatches FROM " + this.DBTableName("ANALY_HDR") + " WHERE analyst=" + targetID + " AND well_id=" + well_id + " AND analy_no=" + ++analy_no + " AND disc_id=" + SB.DBChar((char)disc_id);
                    rs2 = stmt2.executeQuery(this.modQuery(sql));
                    if (rs2.next()) {
                        matches = rs2.getInt("nMatches");
                    }
                    if (matches != 0) continue;
                    allowed = true;
                }
                rs.updateInt("analy_no", analy_no);
                rs.updateInt("analyst", targetID);
                rs.updateRow();
                continue;
            }
            rs.updateInt("analyst", targetID);
            rs.updateRow();
        }
        sql = "SELECT well_id,usamp_id,interp_id,disc_id,analyst FROM " + this.DBTableName("BCMMNTS") + " WHERE analyst=" + donorID;
        rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            well_id = rs.getInt("well_id");
            int usamp_id = rs.getInt("usamp_id");
            int interp_id = rs.getInt("interp_id");
            char disc_id = SB.getDBChar((ResultSet)rs, (String)"disc_id");
            sql = "SELECT COUNT(1) AS nMatches FROM " + this.DBTableName("BCMMNTS") + " WHERE analyst=" + targetID + " AND well_id=" + well_id + " AND usamp_id=" + usamp_id + " AND interp_id=" + interp_id + " AND disc_id=" + SB.DBChar((char)disc_id);
            rs2 = stmt2.executeQuery(this.modQuery(sql));
            nMatches = -1;
            if (rs2.next()) {
                nMatches = rs2.getInt("nMatches");
            }
            if (nMatches > 0) continue;
            rs.updateInt("analyst", targetID);
            rs.updateRow();
        }
        sql = "DELETE FROM " + this.DBTableName("BCMMNTS") + " WHERE analyst=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        for (int i = 0; i < auditTables.length; ++i) {
            sql = "UPDATE " + this.DBTableName(auditTables[i]) + " SET creator=" + targetID + " WHERE creator=" + donorID;
            stmt.executeUpdate(this.modQuery(sql));
            sql = "UPDATE " + this.DBTableName(auditTables[i]) + " SET modifier=" + targetID + " WHERE modifier=" + donorID;
            stmt.executeUpdate(this.modQuery(sql));
            sql = "UPDATE " + this.DBTableName(auditTables[i]) + " SET updater=" + targetID + " WHERE updater=" + donorID;
            stmt.executeUpdate(this.modQuery(sql));
        }
        sql = "UPDATE " + this.DBTableName("IGD") + " SET top_analy=" + targetID + " WHERE top_analy=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "UPDATE " + this.DBTableName("IGD") + " SET base_analy=" + targetID + " WHERE base_analy=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "UPDATE " + this.DBTableName("EVENTS") + " SET analyst=" + targetID + " WHERE analyst=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "UPDATE " + this.DBTableName("SBTEMPLT") + " SET owner=" + SB.DBString((String)target.getAbr()) + " WHERE owner=" + SB.DBString((String)donor.getAbr());
        stmt.executeUpdate(this.modQuery(sql));
        sql = "DELETE FROM " + this.DBTableName("PREF_USER") + " WHERE user_id=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "DELETE FROM " + this.DBTableName("USERDEF") + " WHERE user_id=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        stmt.close();
        stmt2.close();
    }

    public SBdb() throws SQLException {
        this.taxa = new TaxaMap(this);
        this.events = new EventDictionary(this);
        this.init();
    }

    public SBdb(SBdb db) throws SQLException, SBException {
        this.lithdesc = db.getLithdesc();
        this.setSampleTops(db.getSampleTops());
        this.taxa = new TaxaMap(this);
        this.events = new EventDictionary(this);
        this.init();
    }

    private void init() {
        this.taxa.addObserver(this);
        this.events.addObserver(this);
    }

    public Lithdesc getLithdesc() throws SQLException, SBException {
        if (this.lithdesc == null) {
            this.lithdesc = new Lithdesc(this, false);
        }
        return this.lithdesc;
    }

    public JComboBox getLithologyCombo(boolean includeQualifiers) throws SQLException, SBException {
        JComboBox<String> comboBox = new JComboBox<String>();
        Enumeration<Lithology> en = this.getLithdesc().lithologies.elements();
        while (en.hasMoreElements()) {
            Lithology lith = en.nextElement();
            if (lith.getLithID() < 1000 || lith.getLithID() >= 2000) continue;
            String descr = lith.getDescr();
            boolean inserted = false;
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                String item = (String)comboBox.getItemAt(i);
                if (item.compareTo(descr) > 0) {
                    comboBox.insertItemAt(descr, i);
                    inserted = true;
                    break;
                }
                if (!item.equals(descr)) continue;
                inserted = true;
                break;
            }
            if (inserted) continue;
            comboBox.addItem(descr);
        }
        if (includeQualifiers) {
            comboBox.addItem("----------------");
            for (Lithology lith : this.getLithdesc().accessories) {
                String string = "Accessory : " + lith.getDescr();
                comboBox.addItem(string);
            }
            comboBox.addItem("----------------");
            for (Lithology lith : this.getLithdesc().stringers) {
                String string = "Stringer : " + lith.getDescr();
                comboBox.addItem(string);
            }
            comboBox.addItem("----------------");
            for (Lithology lith : this.getLithdesc().qualifiers) {
                String string = "Qualifier : " + lith.getDescr();
                comboBox.addItem(string);
            }
        }
        comboBox.setMaximumRowCount(25);
        return comboBox;
    }

    public void deleteSpecies(Collection<Integer> specIDs, boolean delFss, ProgressBarMonitor prog) throws SQLException, SBException {
        this.taxa.deleteTaxa(specIDs, delFss, prog);
        for (int specID : specIDs) {
            Iterator<Well> itw = this.getProject(0).getWellIterator();
            while (itw.hasNext()) {
                Well well = itw.next();
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.analyses) {
                        if (!smpdtl.removeSpecies(specID)) continue;
                        smpdtl.notifyObservers();
                    }
                }
            }
        }
        for (TxGroup group : this.txGroups.values()) {
            for (int specID : specIDs) {
                group.removeSpecies(specID);
            }
            group.notifyObservers();
        }
    }

    public int updateOcc(Taxon taxon, String field, char newValue) throws SQLException, SBException {
        int nUpdated = taxon.updateOcc(field, newValue);
        this.updateOcc(taxon, field, newValue, -1);
        return nUpdated;
    }

    public void updateOcc(Taxon taxon, int newSpecType) throws SQLException, SBException {
        taxon.updateOccSpecType(newSpecType);
        this.updateOcc(taxon, null, '\u0000', newSpecType);
    }

    private void updateOcc(Taxon taxon, String field, char newValue, int newSpecType) throws SQLException, SBException {
        Iterator<Well> itw = this.getProject(0).getWellIterator();
        while (itw.hasNext()) {
            Well well = itw.next();
            for (Sample sample : well.getSamples()) {
                for (Smpdtl smpdtl : sample.analyses) {
                    if (!smpdtl.updateOcc(taxon, field, newValue, newSpecType)) continue;
                    smpdtl.notifyObservers();
                }
            }
        }
    }

    public boolean checkAnalystConflicts(int usrID1, int usrID2) throws SQLException, SBException {
        Iterator<Well> itw = this.getProject(0).getWellIterator();
        while (itw.hasNext()) {
            Well well = itw.next();
            for (Sample sample : well.getSamples()) {
                for (Smpdtl smpdtl : sample.analyses) {
                    if (smpdtl.getHeader().getAnalystUsrid() != usrID1) continue;
                    for (Smpdtl smpdtl2 : sample.analyses) {
                        if (smpdtl == smpdtl2 || smpdtl2.getHeader().getAnalystUsrid() != usrID2) continue;
                        return false;
                    }
                }
            }
            Iterator<WellInterp> wellInterpIterator = well.getInterpIterator();
            while (wellInterpIterator.hasNext()) {
                WellInterp interp = wellInterpIterator.next();
                for (Biocom biocom : interp.getComments()) {
                    if (biocom.getAnalyst() != usrID1) continue;
                    for (Biocom biocom2 : interp.getComments()) {
                        if (biocom == biocom2 || biocom.getSample() != biocom2.getSample() || biocom2.getAnalyst() != usrID2) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    void refreshInterps(Statement stmt) throws SQLException {
        if (this.interpHdrs != null) {
            InterpHdr.refresh(stmt, this, this.interpHdrs);
        }
    }

    void loadInterps() throws SQLException {
        if (this.interpHdrs == null) {
            this.interpHdrs = new HashMap();
            InterpHdr.loadAll(this, this.interpHdrs);
        }
    }

    public List<InterpHdr> getInterps() throws SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        LinkedList<InterpHdr> list = new LinkedList<InterpHdr>();
        Collection<InterpHdr> c = this.interpHdrs.values();
        for (InterpHdr o : c) {
            InterpHdr interp = o;
            if (interp.getInterpID() <= 0) continue;
            list.add(interp);
        }
        Collections.sort(list);
        InterpHdr defaultInterp = this.interpHdrs.get(new Integer(0));
        if (defaultInterp != null) {
            list.add(0, defaultInterp);
        }
        return list;
    }

    public InterpHdr getInterp(int interpID) throws SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        return this.interpHdrs.get(new Integer(interpID));
    }

    public InterpHdr getInterp(String name) throws SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        Collection<InterpHdr> c = this.interpHdrs.values();
        for (InterpHdr o : c) {
            InterpHdr interp = o;
            if (!interp.getDescription().equalsIgnoreCase(name)) continue;
            return interp;
        }
        return null;
    }

    public void removeInterp(InterpHdr interp) throws SQLException, SBException {
        Project project = this.getProject(0);
        Iterator<Well> it = project.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            try {
                WellInterp wellInterp = well.getInterp(interp.getInterpID());
                well.removeInterp(wellInterp);
                well.notifyObservers(interp);
            }
            catch (SBException ex) {}
        }
        this.interpHdrs.remove(interp.getInterpID());
    }

    public void loadTaxa() throws SQLException {
        this.taxa.loadAll();
        System.out.println("Number of taxa loaded: " + this.taxa.getSize());
    }

    void loadTaxa(int wellID) throws SQLException {
        this.taxa.loadTaxa(wellID);
    }

    public void load() throws SQLException, SBException {
        Calendar time = Calendar.getInstance();
        this.taxa.loadAll();
        System.out.println("Number of taxa loaded: " + this.taxa.getSize());
        this.lithdesc = new Lithdesc(this, false);
        System.out.println("User: " + this.user.getUsrID());
        this.getAbnSchemes();
        this.getEnvScheme(0);
        String sql = "SELECT well_id FROM " + this.DBTableName("well_ident") + " ORDER BY well_id";
        Statement stmt = this.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            Well well = new Well(this, wellID);
            if (well.wellCode() == null || well.wellCode().length() == 0) {
                System.out.println("Well not found for well_id: " + well.wellID);
                continue;
            }
            this.getProject(0).addWell(well);
        }
        System.out.println("Loaded: " + this.getProject(0).getSize() + " wells");
        int nSamples = Sample.loadAll(this, this.getProject(0));
        System.out.println("Loaded: " + nSamples + " samples");
        System.out.println("Loaded: " + Smpdtl.loadAll(this) + " analyses.");
        System.out.println("Loaded: " + TaxonOcc.loadAll(this, this.taxa) + " occurrences.");
        this.loadInterps();
        HashMap<Integer, Well> wellLookup = new HashMap<Integer, Well>();
        Iterator<Well> it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            wellLookup.put(well.wellID, well);
        }
        System.out.println("Loaded: " + IGDIntervalZone.loadAll(this, wellLookup, this.interpHdrs) + " IGD intervals.");
        System.out.println("Loaded: " + Biocom.loadAll(this, wellLookup, this.interpHdrs) + " Biostrat Comments.");
        it = this.getProject(0).getWellIterator();
        int totalWells = this.getProject(0).getSize();
        int n = 0;
        while (it.hasNext()) {
            Well well = it.next();
            System.out.println("Loading data for well (" + ++n + "/" + totalWells + ") :" + well);
            System.out.flush();
            Iterator<WellInterp> wit = well.getInterpIterator();
            while (wit.hasNext()) {
                WellInterp wellInterp = wit.next();
                wellInterp.loadEnvs(well);
                wellInterp.loadIntcoms(well);
                wellInterp.loadEvents(well);
                wellInterp.loadSQPicks(well);
                wellInterp.loadFaults(well);
                well.loadSampleAges(wellInterp);
            }
            block23: for (int dType = 1; dType < 27; ++dType) {
                switch (dType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        continue block23;
                    }
                    case 14: {
                        continue block23;
                    }
                    case 15: {
                        continue block23;
                    }
                    case 16: {
                        continue block23;
                    }
                    case 17: {
                        continue block23;
                    }
                    case 18: {
                        continue block23;
                    }
                    case 19: {
                        well.getCores();
                    }
                    case 20: {
                        well.getCasing();
                    }
                    case 21: {
                        well.getLithIntervals();
                    }
                    case 22: {
                        continue block23;
                    }
                    case 24: {
                        well.getMarkers();
                        continue block23;
                    }
                    case 25: {
                        well.getTVDlist(true);
                        well.getTVDlist(false);
                        continue block23;
                    }
                    case 26: {
                        well.getTWTlist();
                        continue block23;
                    }
                    case 27: {
                        continue block23;
                    }
                    case 23: {
                        continue block23;
                    }
                    default: {
                        try {
                            throw new SBException("Attempt to load data");
                        }
                        catch (SBException sbe) {
                            System.out.println("Exception while loading data type: " + dType + " : " + sbe.getMessage());
                        }
                    }
                }
            }
            Runtime.getRuntime().gc();
        }
        System.out.println("Elapsed: " + (Calendar.getInstance().getTimeInMillis() - time.getTimeInMillis()) / 1000L + " secs.");
    }

    public void getChartScales(DefaultComboBoxModel model) throws SQLException {
        if (this.chartScales == null) {
            this.loadChartScales();
        }
        model.removeAllElements();
        for (Integer iScale : this.chartScales) {
            model.addElement(((Object)iScale).toString());
        }
    }

    public List getChartScales() throws SQLException {
        if (this.chartScales == null) {
            this.loadChartScales();
        }
        return new ArrayList<Integer>(this.chartScales);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChartScales() throws SQLException {
        if (this.chartScales != null) {
            return;
        }
        this.chartScales = new ArrayList<Integer>();
        String sql = "SELECT scale FROM " + this.DBTableName("SBSCALES") + " ORDER BY scale";
        Statement stmt = this.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int iScale = rs.getInt("scale");
                this.chartScales.add(iScale);
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChartScale(int scale) throws SQLException {
        if (scale < 1 || scale > 100000) {
            throw new IllegalArgumentException("Attempt to add illegal chart scale: " + scale);
        }
        this.loadChartScales();
        for (Integer i : this.chartScales) {
            if (i != scale) continue;
            return;
        }
        String sql = "INSERT INTO " + this.DBTableName("SBSCALES") + " (scale) VALUES (" + scale + ")";
        Statement stmt = this.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.chartScales.add(scale);
        Collections.sort(this.chartScales);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChartScale(int scale) throws SQLException {
        this.loadChartScales();
        Integer found = null;
        for (Integer i : this.chartScales) {
            if (!i.equals(scale)) continue;
            found = i;
        }
        if (found == null) {
            return;
        }
        String sql = "DELETE FROM " + this.DBTableName("SBSCALES") + " WHERE scale=" + scale;
        Statement stmt = this.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.chartScales.remove(found);
    }

    public List<String> getCasingDiameters() throws SQLException {
        if (this.casingDiameters == null) {
            this.casingDiameters = new ArrayList<String>();
            String[] diams = new String[]{"42", "36", "32 3/4", "32", "30", "26", "24", "20", "18 3/4", "18 5/8", "18 1/2", "18", "16", "13 3/8", "10 3/4", "10 3/8", "9 5/8", "8 1/2", "7 5/8", "7", "6", "5 1/2", "5", "4 1/2"};
            this.casingDiameters.addAll(Arrays.asList(diams));
            if (this.isConnected()) {
                String sql = "SELECT diam FROM " + this.DBTableName("casdiam") + " ORDER BY sort_order";
                Statement stmt = this.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                while (rs.next()) {
                    String diam = rs.getString("diam");
                    if (this.casingDiameters.contains(diam)) continue;
                    this.casingDiameters.add(diam);
                }
                stmt.close();
            }
        }
        return this.casingDiameters;
    }

    public void createCasdiam() throws SQLException {
        if (!this.hasCasdiam) {
            Statement stmt = this.getDatabase().createStatement();
            String sql = "CREATE TABLE " + this.DBTableName("casdiam") + " (sort_order number, diam ";
            sql = sql + this.getDBCharType();
            sql = sql + "(10))";
            stmt.executeUpdate(this.modQuery(sql));
            if (this.dbType == DBType.ORACLE) {
                sql = "GRANT SELECT,INSERT,UPDATE,DELETE TO PUBLIC ON " + this.DBTableName("casdiam");
                stmt.executeUpdate(this.modQuery(sql));
            }
            stmt.close();
            this.hasCasdiam = true;
        }
    }

    public void storeCasingDiameters(List<String> diameters) throws SQLException, SBException {
        if (diameters != null && this.hasCasdiam) {
            Statement stmt = this.getDatabase().createStatement();
            String sql = "DELETE FROM " + this.DBTableName("casdiam");
            stmt.executeUpdate(this.modQuery(sql));
            int n = 1;
            for (String d : diameters) {
                if (d == null || d.length() == 0) {
                    throw new SBException("Casing diameter blank");
                }
                sql = "INSERT INTO " + this.DBTableName("casdiam") + " (sort_order, diam) VALUES (" + n + "," + SB.DBString((String)d) + ")";
                stmt.executeUpdate(this.modQuery(sql));
                ++n;
            }
            stmt.close();
        }
        this.casingDiameters = diameters;
    }

    public boolean getHasCasdiam() {
        return this.hasCasdiam;
    }

    public String getSchema() {
        String schema = null;
        if (this.tablePrefix != null && this.tablePrefix.length() > 0) {
            schema = this.tablePrefix.indexOf(46) > 0 ? this.tablePrefix.substring(0, this.tablePrefix.indexOf(46)) : this.tablePrefix;
            schema = schema.toUpperCase(Locale.ENGLISH);
        }
        return schema;
    }

    public Well getCurrentWell() throws SQLException, SBException {
        if (this.currentWell != null) {
            return this.currentWell;
        }
        int wellID = Lastval.getInt(this, "WELL_ID");
        if (wellID > 0) {
            this.currentWell = this.getAddWell(wellID);
            return this.currentWell;
        }
        return null;
    }

    public ProjectList getProjects() throws SQLException, SBException {
        if (this.projects == null) {
            this.projects = new ProjectList(this);
        }
        return this.projects;
    }

    void refreshProjects(Statement stmt) throws SQLException, SBException {
        if (this.projects != null) {
            this.projects.refresh(stmt, this);
        }
    }

    public Project getProject(int ID) throws SQLException, SBException {
        this.getProjects();
        return this.projects.getProject(ID);
    }

    public void deleteWell(Well well) throws SQLException, SBException {
        Well.deleteWell(this, well.getWellCode());
        this.projects.removeWell(well);
    }

    public Well getAddWell(int wellID) throws SQLException, SBException {
        Project project = this.getProject(0);
        return project.getWell(this, wellID);
    }

    public void insertWell(Well well) throws SQLException, SBException {
        Project project = this.getProject(0);
        project.addWell(well);
    }

    public int nextControl(String tableName, String columnName) throws SQLException {
        String sql;
        int oldval = 0;
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql = "SELECT max(" + columnName + ") as conval FROM " + this.DBTableName(tableName)));
        if (rs.next()) {
            oldval = rs.getInt("conval");
        }
        rs.close();
        stmt.close();
        return ++oldval;
    }

    void queryMetaData() throws SQLException, SBException {
        String tableName;
        assert (this.meta != null) : "Metadata not set";
        this.connection.setAutoCommit(false);
        String schema = this.getSchema();
        this.hasUserPassword = false;
        ResultSet rs = this.meta.getColumns(null, schema, "%", "%");
        boolean tablesExist = false;
        while (rs.next()) {
            tablesExist = true;
            tableName = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            if (tableName.equalsIgnoreCase("WELLPERM")) {
                this.hasWellPerm = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("USERPERM")) {
                this.hasUserPerm = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("SBIMAGE")) {
                this.hasSBimage = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLTVD") && columnName.equalsIgnoreCase("PLAN")) {
                this.hasTVDplan = true;
                continue;
            }
            if (!tableName.equalsIgnoreCase("USERDEF") || !columnName.equalsIgnoreCase("PASSWORD")) continue;
            this.hasUserPassword = true;
        }
        rs.close();
        rs = this.meta.getTables(null, schema, "%", null);
        while (rs.next()) {
            tableName = rs.getString("TABLE_NAME");
            String tableType = rs.getString("TABLE_TYPE");
            if (tableName.equalsIgnoreCase("SBWLMB")) {
                if (!tableType.equalsIgnoreCase("VIEW")) continue;
                this.sbwlIsView = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLS_MASTER")) {
                if (tableType.equalsIgnoreCase("VIEW")) {
                    this.hasWellsMaster = true;
                }
                Well.loadWellMasterFields(this, this.wellMasterFields);
                continue;
            }
            if (!tableName.equalsIgnoreCase("CASING_CDS")) continue;
            this.hasCasingView = true;
        }
        rs.close();
        if (!tablesExist) {
            throw new SBException("No tables found for schema: " + schema);
        }
        try {
            Boolean bool = this.getDatabasePrefBool("IMAGEDB");
            if (bool != null) {
                this.storeImage = bool;
            }
        }
        catch (SQLException sqle) {
            throw new SBException("Error querying table: " + this.DBTableName("pref_system") + "\nSQL Error: " + sqle.getMessage());
        }
        if (this.dbType == DBType.ORACLE) {
            rs = this.meta.getTables(null, "EPISAMGR", "CORES", null);
            if (rs.next()) {
                this.hasSAMBA = true;
            }
            rs.close();
        }
    }

    public static String getJregOption(String str) throws UnsatisfiedLinkError {
        String value = SBdb.getURegOption(str);
        if (value == null || value.length() == 0 || value.startsWith("Error")) {
            String setting = SBdb.getRegOption(str);
            return setting;
        }
        return value;
    }

    public static String getJreg(String str) throws UnsatisfiedLinkError {
        String value = SBdb.getUReg(str);
        if (value == null || value.length() == 0 || value.startsWith("Error")) {
            String setting = SBdb.getReg(str);
            return setting;
        }
        return value;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public static String getHostName(String hostName) {
        if (hostName.toLowerCase().endsWith(".mdb")) {
            hostName = "Driver={Microsoft Access Driver (*.mdb)};DBQ=" + hostName;
        }
        return hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public double getFileSize() {
        if (this.hostName.endsWith("mdb")) {
            File file = new File(this.hostName);
            return file.length() / 0x100000L;
        }
        return 0.0;
    }

    public boolean connect(String driverName, String hostName, String instanceName, String instanceLogin, String password) throws SQLException, InstantiationException, IllegalAccessException, Exception {
        String driverString = null;
        this.hostName = hostName;
        boolean createConnection2 = true;
        if (driverName.equalsIgnoreCase("odbc")) {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();
            driverString = "jdbc:odbc:" + SBdb.getHostName(hostName) + ";MARS_Connection=yes";
            if (instanceName != null) {
                this.tablePrefix = instanceName;
            }
        } else if (driverName.startsWith("sqlite")) {
            Class.forName("org." + driverName + ".JDBC").newInstance();
            driverString = "jdbc:" + driverName + ":" + instanceName;
            createConnection2 = false;
        } else if (driverName.contains("mysql")) {
            Class.forName("com." + driverName + ".jdbc.Driver").newInstance();
            driverString = "jdbc:" + driverName + "://" + hostName + "/" + instanceName;
        } else if (driverName.contains("oracle")) {
            Class.forName(driverName + ".jdbc.OracleDriver").newInstance();
            if (instanceName.contains(".")) {
                this.tablePrefix = instanceName.substring(instanceName.lastIndexOf(46) + 1);
                instanceName = instanceName.substring(0, instanceName.lastIndexOf("."));
            }
            driverString = "jdbc:" + driverName + ":thin:@//" + hostName + "/" + instanceName;
        } else if (driverName.contains("sqlserver")) {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver").newInstance();
            driverString = "jdbc:" + driverName + "://" + hostName + ";databaseName=" + instanceName;
        }
        System.out.println("Connecting (v2) with: " + driverString + ", prefix=" + this.tablePrefix + " (user=" + instanceLogin + ", password=" + (password == null ? "" : "(" + password.length() + " chars)") + ")");
        this.connection = DriverManager.getConnection(driverString, instanceLogin, password);
        System.out.println("Connection properties: ");
        if (createConnection2) {
            this.connection2 = DriverManager.getConnection(driverString, instanceLogin, password);
        }
        this.meta = this.connection.getMetaData();
        this.setDBType();
        this.connection.setAutoCommit(false);
        if (this.dbType != DBType.SQLITE) {
            this.connection2.setAutoCommit(false);
        }
        this.emptyConnection = true;
        return true;
    }

    public boolean validSchema() throws SQLException {
        if (!this.isConnected()) {
            return false;
        }
        ResultSet rs = this.meta.getColumns(null, this.getSchema(), "PREF_SYSTEM", "%");
        boolean tablesExist = false;
        while (rs.next()) {
            tablesExist = true;
        }
        return tablesExist;
    }

    public boolean login(String abr, String password) throws SQLException, SBException {
        this.queryMetaData();
        this.emptyConnection = false;
        this.fillUserDetails(abr, password);
        this.licence = new Licence(this);
        this.getSampleTops();
        this.setEventPrefixes();
        this.getAllowMultipleEnvSchemes();
        return true;
    }

    public String getDefaultUser(String sysName) throws SQLException, SBException {
        ResultSet rs;
        Statement stmt;
        String sql;
        if (sysName == null || sysName.length() == 0) {
            if (this.dbType == DBType.ORACLE) {
                sql = "SELECT user FROM DUAL";
                stmt = this.connection.createStatement();
                rs = stmt.executeQuery(this.modQuery(sql));
                if (rs.next()) {
                    sysName = rs.getString("user");
                }
                stmt.close();
                System.out.println("Queried for default Oracle user: " + sysName);
                if (sysName == null || sysName.isEmpty()) {
                    return null;
                }
            } else if (this.dbType == DBType.MSSQLSERVER) {
                sql = "SELECT SYSTEM_USER AS mssqluser";
                stmt = this.connection.createStatement();
                rs = stmt.executeQuery(this.modQuery(sql));
                if (rs.next()) {
                    sysName = rs.getString("mssqluser");
                }
                stmt.close();
                System.out.println("Queried for default SQL Server user: " + sysName);
                if (sysName == null || sysName.isEmpty()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        sql = "SELECT abr, user_priv FROM " + this.DBTableName("USERDEF") + " WHERE ucase(sys_name)=" + SB.DBString((String)sysName.toUpperCase());
        stmt = this.connection.createStatement();
        rs = stmt.executeQuery(this.modQuery(sql));
        int count = 0;
        String abr = null;
        int priv = 0;
        while (rs.next()) {
            ++count;
            abr = rs.getString("abr");
            priv = rs.getInt("user_priv");
        }
        if (count == 1) {
            if (priv == 0) {
                throw new SBException("Database connection successful but no privilege to use StrataBugs.");
            }
            this.needsPassword = false;
            return abr;
        }
        return null;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.connection2 != null) {
            this.connection2.close();
        }
    }

    public void describeText(File file) throws SBException, SQLException, IOException {
        String eol = "\r\n";
        if (this.connection == null) {
            throw new SBException("No connection");
        }
        if (this.meta == null) {
            this.meta = this.connection.getMetaData();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        String lastTable = null;
        String schema = this.tablePrefix;
        System.out.println("Scheme is: " + schema);
        if (schema != null && schema.indexOf(46) >= 0) {
            schema = schema.substring(0, schema.indexOf(46));
        }
        ResultSet rs = this.meta.getColumns(null, schema, "%", "%");
        LinkedList<String> pks = new LinkedList<String>();
        while (rs.next()) {
            String remarks;
            String isNullable;
            int nullable;
            String tableName = rs.getString("TABLE_NAME");
            if (tableName.startsWith("MSys") || tableName.indexOf(32) >= 0) continue;
            String columnName = rs.getString("COLUMN_NAME");
            if (!tableName.equals(lastTable)) {
                lastTable = tableName;
                out.write("#" + eol + tableName);
                pks.clear();
                try {
                    ResultSet rs2 = this.meta.getPrimaryKeys(null, schema, tableName);
                    if (rs2.next()) {
                        pks.add(rs2.getString("COLUMN_NAME"));
                    }
                }
                catch (Exception e) {
                    System.out.println("Warning: primary keys not supported.");
                }
                out.write(eol);
            }
            String paddedColumnName = (columnName + "            ").substring(0, 12);
            String paddedTypName = (rs.getString("TYPE_NAME") + "             ").substring(0, 10);
            out.write("Column\t" + paddedColumnName + "\t\t" + paddedTypName + "\t" + rs.getInt("COLUMN_SIZE"));
            if (pks.contains(columnName)) {
                out.write("\tPRIMARYKEY");
            }
            if ((nullable = rs.getInt("NULLABLE")) == 0) {
                out.write("\tNOTNULL");
            }
            if ((isNullable = rs.getString("IS_NULLABLE")) != null && isNullable.equals("NO")) {
                out.write("\tNOTNULL");
            }
            if ((remarks = rs.getString("REMARKS")) != null) {
                out.write("\t# " + remarks);
            }
            out.write(eol);
        }
        out.write(eol);
        out.close();
    }

    public void createTables(File schemaFile) throws SQLException, IOException, SBException {
        BufferedReader tableDef = new BufferedReader(new FileReader(schemaFile));
        String line = tableDef.readLine();
        boolean requiredTable = true;
        String tableName = null;
        LinkedList<Column> columns = new LinkedList<Column>();
        Statement stmt = this.connection.createStatement();
        while (line != null) {
            if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if (line.equalsIgnoreCase("[OPTIONAL]")) {
                    if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                        tableName = null;
                        break;
                    }
                    tableName = null;
                    requiredTable = false;
                } else if (line.equalsIgnoreCase("[REQUIRED]")) {
                    if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                        tableName = null;
                        break;
                    }
                    tableName = null;
                    requiredTable = true;
                } else if (line.startsWith("Column") || line.startsWith("Optional")) {
                    StringTokenizer tok = new StringTokenizer(line);
                    Column column = new Column();
                    if (tok.nextToken().equals("Optional")) {
                        tok.nextToken();
                    }
                    column.name = tok.nextToken();
                    if (column.name.equalsIgnoreCase("references")) {
                        column.name = "reference";
                    }
                    column.type = tok.nextToken();
                    if (tok.hasMoreTokens()) {
                        column.size = Integer.parseInt(tok.nextToken().trim());
                    }
                    while (tok.hasMoreTokens()) {
                        String constraint = tok.nextToken();
                        if (constraint.equalsIgnoreCase("NOTNULL")) {
                            column.notNull = true;
                            continue;
                        }
                        if (constraint.equalsIgnoreCase("PRIMARYKEY")) {
                            column.primaryKey = true;
                            continue;
                        }
                        throw new SBException("Unrecognised constraint in line: " + line);
                    }
                    columns.add(column);
                } else {
                    if (tableName != null && columns.size() > 0) {
                        if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                            tableName = null;
                            break;
                        }
                        tableName = null;
                    }
                    tableName = line;
                }
            }
            line = tableDef.readLine();
        }
        if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
            return;
        }
        stmt.close();
        this.connection.commit();
        tableDef.close();
    }

    boolean saveTable(boolean requiredTable, Statement stmt, String tableName, List columns) throws SQLException {
        if (tableName == null) {
            return true;
        }
        if (requiredTable || tableName.equalsIgnoreCase("ANALY_HDR") || tableName.equalsIgnoreCase("CASDIAM") || tableName.equalsIgnoreCase("ENVTRN") || tableName.equalsIgnoreCase("IGD_HDR") || tableName.equalsIgnoreCase("SBLTHTRN") || tableName.equalsIgnoreCase("LTHTRNSCH") || tableName.equalsIgnoreCase("SYNSCH")) {
            this.createTable(stmt, tableName, columns, false);
            System.out.println("Created table: " + tableName);
            columns.clear();
        } else {
            columns.clear();
        }
        return true;
    }

    public void copyTables(SBdb newDB) throws SQLException {
        String[] tables = new String[]{"USERDEF", "WELLS", "WELL_IDENT", "INTERP", "SAMPLES", "ABNSCHME", "ABNSCHMBR", "CASDIAM", "CASING", "DISCS", "CATEGORY", "CATCOL", "SMPTYPES", "CHLABELS", "CMPSTD", "CORES", "CORESHIFT", "ENV_SCH", "ENVSCHMBR", "AGE_CURVE", "AGE_TRACE", "ANALY_HDR", "BCMMNTS", "ENVTRN", "FAULTS", "GENUS", "IGD_DEF", "IGD_SCH", "IGD_DICT", "IGD_ENV", "IGD_HDR", "IGD", "IGD_COLMAP", "SBIMAGE", "IMAGE_SET", "IMAGE_SETMBR", "INTCMMNTS", "LICENCE", "LITHDESC", "LOC", "LOCNODE", "LOGDEF", "LOG_CURVE", "LOG_TRACE", "LTHTRNSCH", "PREF_SYSTEM", "PREF_USER", "SBCHARTS", "SBCHCLIN", "SBCHPANL", "SBGS", "SBILITH", "SBLOGTRC", "SBLTHSCH", "SBLTHMBR", "SBLTHPAT", "SBLTHTRN", "SBQLITH", "SBSCALES", "SBSLITH", "SBSSR", "SBTEMPLT", "SBPANELS", "SBLOGTPL", "SBWLLST", "SBWLMB", "SMPDTL", "SOURCE", "SPECIES", "SIPMDICT", "SIPMCODE", "EVENTDIC", "EVENTS", "CMPSTDEV", "OVERLAY", "OVR_MAP", "SPECIESTYPE", "TXGROUP", "GROUPMBR", "GROUPSET", "SETMBR", "SURFACE", "SQPICK", "SYNSCH", "SYNONYMY", "TAXONOCC", "COREIMAGE", "TVDHDR", "TXDEPTH", "TXIMAGE", "TXLOAD", "TXNOTES", "TXREFS", "WELLSMARK", "WELLTVD", "WELLTWT"};
        int opt1 = JOptionPane.showConfirmDialog(null, "Copy all tables?", "New Schema", 1);
        if (opt1 == 2) {
            return;
        }
        boolean allTables = false;
        if (opt1 == 0) {
            allTables = true;
        }
        for (String tableName : tables) {
            boolean repeat = true;
            while (repeat) {
                try {
                    repeat = false;
                    boolean doCopy = allTables;
                    if (!allTables) {
                        int opt = JOptionPane.showConfirmDialog(null, "Copy table: " + tableName + "?", "New Schema", 1);
                        if (opt == 2) {
                            return;
                        }
                        if (opt == 0) {
                            doCopy = true;
                        }
                    }
                    if (!doCopy) continue;
                    this.copyTable(newDB, tableName, null, true);
                }
                catch (SQLException se) {
                    String message = se.getMessage();
                    se.printStackTrace();
                    newDB.getDatabase().rollback();
                    int opt = JOptionPane.showConfirmDialog(null, "Error copying data: " + message + "\nSkip this table?\nClick NO to continue after correcting error.", tableName, 0);
                    if (opt != 1) continue;
                    repeat = true;
                }
            }
        }
    }

    public void copyTable(SBdb newDB, String tableName, String whereClause, boolean clearValues) throws SQLException {
        int i;
        ResultSet rs;
        Statement newStmt = newDB.connection.createStatement();
        if (clearValues) {
            System.out.println("Deleting from table: " + newDB.DBTableName(tableName));
            newStmt.executeUpdate("DELETE FROM " + newDB.DBTableName(tableName));
        }
        String selectQuery = "SELECT * FROM " + newDB.DBTableName(tableName);
        ResultSet rsNew = newStmt.executeQuery(selectQuery);
        ResultSetMetaData copyMeta = rsNew.getMetaData();
        int nCols = copyMeta.getColumnCount();
        selectQuery = "SELECT ";
        for (int i2 = 1; i2 <= nCols; ++i2) {
            String columnName = copyMeta.getColumnName(i2);
            if (columnName.equalsIgnoreCase("PLAN") && this.dbType == DBType.MSSQLSERVER) {
                columnName = "[" + columnName + "]";
            }
            selectQuery = selectQuery + columnName;
            if (i2 >= nCols) continue;
            selectQuery = selectQuery + ",";
        }
        selectQuery = selectQuery + " FROM " + this.DBTableName(tableName);
        Statement stmt = this.getDatabase().createStatement();
        if (whereClause != null) {
            selectQuery = selectQuery + whereClause;
        }
        try {
            System.out.println("Executing query in copyTable: " + selectQuery);
            rs = stmt.executeQuery(selectQuery);
        }
        catch (SQLException se) {
            selectQuery = "SELECT * FROM " + this.DBTableName(tableName);
            if (whereClause != null) {
                selectQuery = selectQuery + whereClause;
            }
            System.out.println("Re-trying: Select query: " + selectQuery);
            rs = stmt.executeQuery(selectQuery);
            copyMeta = rs.getMetaData();
            nCols = copyMeta.getColumnCount();
        }
        String sql = "INSERT INTO " + newDB.DBTableName(tableName) + " (";
        for (i = 1; i <= nCols; ++i) {
            String columnName = copyMeta.getColumnName(i);
            if (columnName.equalsIgnoreCase("PLAN") && newDB.dbType == DBType.MSSQLSERVER) {
                columnName = "[" + columnName + "]";
            }
            sql = sql + columnName;
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + " ) VALUES (";
        for (i = 1; i <= nCols; ++i) {
            sql = sql + "?";
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + ")";
        PreparedStatement pStmt = newDB.getDatabase().prepareStatement(sql);
        while (rs.next()) {
            String paramString = "";
            DBType cfr_ignored_0 = newDB.dbType;
            if (newDB.dbType != DBType.ORACLE) {
                pStmt.clearParameters();
            }
            for (int col = 1; col <= nCols; ++col) {
                Object obj = rs.getObject(col);
                if (obj != null) {
                    String columnName;
                    if (newDB.dbType == DBType.SQLITE && obj instanceof Float) {
                        obj = new Double(((Float)obj).floatValue());
                    }
                    if (obj instanceof String) {
                        obj = ((String)obj).trim();
                    }
                    if (((columnName = copyMeta.getColumnName(col)).equalsIgnoreCase("CREATOR") || columnName.equalsIgnoreCase("MODIFIER") || columnName.equalsIgnoreCase("UPDATER")) && obj.toString().equals("0")) {
                        pStmt.setNull(col, copyMeta.getColumnType(col));
                    } else {
                        pStmt.setObject(col, obj);
                    }
                } else {
                    int type = copyMeta.getColumnType(col);
                    if (type == 3) {
                        type = 8;
                    }
                    pStmt.setNull(col, type);
                }
                paramString = paramString + obj + ",";
            }
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException se) {
                if (newDB.dbType == DBType.ACCESS && se.getMessage().equalsIgnoreCase("GENERAL ERROR")) {
                    System.out.println("Duplicate/General record error when inserting into " + tableName + ": " + paramString);
                    continue;
                }
                if (newDB.dbType == DBType.ORACLE && se.getMessage().indexOf("ORA-00001") >= 0) {
                    System.out.println("Unique constraint error when inserting into " + tableName + ": " + paramString);
                    continue;
                }
                System.out.println("SQL :" + sql + ": " + paramString);
                throw se;
            }
        }
        newStmt.close();
        pStmt.close();
        stmt.close();
        newDB.commit();
    }

    public void setGrants(String grantee) throws SQLException, SBException {
        if (this.dbType != DBType.ORACLE) {
            throw new SBException("Not an Oracle database");
        }
        ResultSet tables = this.meta.getTables(null, this.getSchema(), "%", new String[]{"TABLE"});
        Statement stmt = this.connection.createStatement();
        while (tables.next()) {
            String tableName = tables.getString("table_name");
            String sql = "GRANT ALL ON " + this.DBTableName(tableName) + " TO " + grantee;
            stmt.execute(sql);
        }
        stmt.close();
        this.connection.commit();
    }

    void createTable(Statement stmt, String name, List columns, boolean drop) throws SQLException {
        String sql;
        if (name.equalsIgnoreCase("image")) {
            return;
        }
        if (drop) {
            try {
                sql = "DROP table " + name;
                stmt.executeUpdate(sql);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        sql = "CREATE TABLE " + this.DBTableName(name) + " ( ";
        Iterator it = columns.iterator();
        String pk = " CONSTRAINT " + name + "_pk PRIMARY KEY (";
        boolean hasPk = false;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            sql = sql + column.name + " ";
            sql = sql + column.getType(this.dbType);
            if (column.type.equalsIgnoreCase("text")) {
                sql = sql + "(" + column.size + ")";
            }
            if (column.notNull) {
                sql = sql + " NOT NULL";
            }
            if (column.primaryKey) {
                if (hasPk) {
                    pk = pk + ",";
                }
                pk = pk + column.name;
                hasPk = true;
            }
            if (!it.hasNext()) continue;
            sql = sql + ",";
        }
        if (hasPk) {
            sql = sql + "," + pk + ")";
        }
        sql = sql + ")";
        stmt.executeUpdate(sql);
    }

    private void setDBType() throws Exception {
        String dbTypeName = this.meta.getDatabaseProductName();
        if (dbTypeName.equalsIgnoreCase("ACCESS")) {
            this.dbType = DBType.ACCESS;
        } else if (dbTypeName.equalsIgnoreCase("ORACLE")) {
            this.dbType = DBType.ORACLE;
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate("ALTER SESSION SET NLS_DATE_FORMAT='yyyy-mm-dd HH24:MI:SS'");
            stmt.executeUpdate("ALTER SESSION SET NLS_NUMERIC_CHARACTERS='.,'");
            stmt.close();
        } else if (dbTypeName.equalsIgnoreCase("Microsoft SQL Server")) {
            this.dbType = DBType.MSSQLSERVER;
        } else if (dbTypeName.equalsIgnoreCase("MySQL")) {
            this.dbType = DBType.MYSQL;
            Statement stmt = this.connection.createStatement();
            String mySQLtrans = "SET SESSION TRANSACTION ISOLATION LEVEL READ COMMITTED";
            stmt.executeUpdate(mySQLtrans);
            stmt.close();
            Statement stmt2 = this.connection2.createStatement();
            stmt2.executeUpdate(mySQLtrans);
            stmt2.close();
        } else if (dbTypeName.equalsIgnoreCase("SQLite")) {
            this.dbType = DBType.SQLITE;
            Statement stmt = this.connection.createStatement();
            String pragma = "PRAGMA foreign_keys = ON;";
            stmt.executeUpdate(pragma);
            stmt.close();
        } else {
            throw new Exception("Cannot recognise database type of ODBC connection: " + dbTypeName);
        }
    }

    public String DBTableName(String tableName) {
        tableName = tableName.toUpperCase(Locale.ENGLISH);
        if (this.tablePrefix != null && this.tablePrefix.length() > 0) {
            if (!this.tablePrefix.contains(".")) {
                return this.tablePrefix + "." + tableName;
            }
            return this.tablePrefix + tableName;
        }
        return tableName;
    }

    public String modQuery(String query) {
        if (this.dbType == DBType.ORACLE || this.dbType == DBType.MSSQLSERVER || this.dbType == DBType.MYSQL || this.dbType == DBType.SQLITE) {
            int i;
            while ((i = query.indexOf(" ucase")) >= 0) {
                query = query.substring(0, i) + " upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" lcase")) >= 0) {
                query = query.substring(0, i) + " lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=ucase")) >= 0) {
                query = query.substring(0, i) + "=upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(",ucase")) >= 0) {
                query = query.substring(0, i) + ",upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=lcase")) >= 0) {
                query = query.substring(0, i) + "=lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf(",lcase")) >= 0) {
                query = query.substring(0, i) + ",lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" UCASE")) >= 0) {
                query = query.substring(0, i) + " upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" LCASE")) >= 0) {
                query = query.substring(0, i) + " lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf(",UCASE")) >= 0) {
                query = query.substring(0, i) + ",upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(",LCASE")) >= 0) {
                query = query.substring(0, i) + ",lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=UCASE")) >= 0) {
                query = query.substring(0, i) + "=upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=LCASE")) >= 0) {
                query = query.substring(0, i) + "=lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" Ucase")) >= 0) {
                query = query.substring(0, i) + " upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" Lcase")) >= 0) {
                query = query.substring(0, i) + " lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=Ucase")) >= 0) {
                query = query.substring(0, i) + "=upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=Lcase")) >= 0) {
                query = query.substring(0, i) + "=lower" + query.substring(i + 6);
            }
        } else {
            int i;
            while ((i = query.indexOf("floor(")) >= 0) {
                query = query.substring(0, i) + "int(" + query.substring(i + 6);
            }
        }
        SB.sql = query;
        if (SB.showSql) {
            if (SB.sqlLogFile != null) {
                SB.sqlLogFile.println(SB.sql);
            } else {
                System.out.println(SB.sql);
            }
        }
        return query;
    }

    private void fillUserDetails(String abr, String password) throws SQLException, SBException {
        block12: {
            Statement stmt = this.connection.createStatement();
            String sql = "SELECT user_id,name,sys_name,disc,user_priv,red,green,blue";
            if (this.needsPassword()) {
                sql = sql + ",password";
            }
            sql = sql + " FROM " + this.DBTableName("USERDEF") + " WHERE abr='" + abr + "'";
            try {
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                if (rs.next()) {
                    Color colour;
                    int userID = rs.getInt("user_id");
                    String name = rs.getString("name");
                    String sysName = rs.getString("sys_name");
                    char discID = rs.getString("disc").charAt(0);
                    Discipline disc = Discipline.getDisc(discID);
                    int priv = rs.getInt("user_priv");
                    try {
                        colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
                    }
                    catch (Exception n) {
                        colour = Color.BLACK;
                    }
                    String userPassword = "";
                    if (this.needsPassword() && (userPassword = rs.getString("password")) != null) {
                        userPassword = SB.crypt((boolean)false, (String)"SBPW", (String)userPassword);
                    }
                    if (this.needsPassword() && (userPassword == null || !userPassword.equalsIgnoreCase(password))) {
                        stmt.close();
                        throw new SBException("Password incorrect");
                    }
                    this.user = this.getUser(userID);
                    if (this.user == null) {
                        this.user = new Userdef(this, userID, abr, name, sysName, disc, colour, userPassword, priv);
                    }
                    break block12;
                }
                stmt.close();
                throw new SBException("Login name not recognised");
            }
            catch (NumberFormatException ne) {
                throw new SBException("Problem getting password from database");
            }
            finally {
                stmt.close();
            }
        }
    }

    public Userdef addUser(String abr, String name, String sysName, Discipline discID, Color colour, String pwd, int priv) throws SQLException, SBException {
        if (this.getUser(abr) != null) {
            throw new SBException("User: " + abr + " already exists");
        }
        Userdef u = new Userdef(this, abr, name, sysName, discID, colour, pwd, priv);
        this.putUser(u);
        return u;
    }

    public void deleteUser(String abr) throws SQLException {
        Userdef u = this.getUser(abr);
        u.delete();
        this.users.remove(u.getUsrID());
    }

    public static int did2dtype(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'M': {
                return 2;
            }
            case 'N': {
                return 4;
            }
            case 'P': {
                return 6;
            }
            case 'A': 
        }
        return 8;
    }

    public static int did2comType(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'M': {
                return 3;
            }
            case 'N': {
                return 5;
            }
            case 'P': {
                return 7;
            }
            case 'A': 
        }
        return 9;
    }

    public static String getDiscNoun(char discID) {
        switch (discID) {
            default: {
                return discNounString[0];
            }
            case 'N': {
                return discNounString[1];
            }
            case 'P': {
                return discNounString[2];
            }
            case 'A': 
        }
        return discNounString[3];
    }

    public static char getDiscIDFromNoun(String discAdj) {
        if (discAdj.equalsIgnoreCase(discNounString[0])) {
            return 'M';
        }
        if (discAdj.equalsIgnoreCase(discNounString[1])) {
            return 'N';
        }
        if (discAdj.equalsIgnoreCase(discNounString[2])) {
            return 'P';
        }
        if (discAdj.equalsIgnoreCase(discNounString[3])) {
            return 'A';
        }
        return '\u0000';
    }

    public static int did2i(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'N': {
                return 1;
            }
            case 'P': {
                return 2;
            }
            case 'A': 
        }
        return 3;
    }

    public static char dt2discID(int dataType) {
        switch (dataType) {
            case 2: 
            case 3: {
                return 'M';
            }
            case 4: 
            case 5: {
                return 'N';
            }
            case 6: 
            case 7: {
                return 'P';
            }
            case 8: 
            case 9: {
                return 'A';
            }
        }
        return ' ';
    }

    public static String getDiscAbr(char discID) {
        switch (discID) {
            default: {
                return "Micro.";
            }
            case 'N': {
                return "Nanno.";
            }
            case 'P': {
                return "Paly.";
            }
            case 'A': 
        }
        return "Macro.";
    }

    public static String getDiscAdj(char discID) {
        switch (discID) {
            default: {
                return "Microfaunal";
            }
            case 'N': {
                return "Nannofloral";
            }
            case 'P': {
                return "Palynofloral";
            }
            case 'A': 
        }
        return "Macrofaunal";
    }

    public static char getDiscIDFromAdj(String discAdj) {
        if (discAdj.equalsIgnoreCase("Microfaunal")) {
            return 'M';
        }
        if (discAdj.equalsIgnoreCase("Nannofloral")) {
            return 'N';
        }
        if (discAdj.equalsIgnoreCase("Palynofloral")) {
            return 'P';
        }
        if (discAdj.equalsIgnoreCase("Macrofaunal")) {
            return 'A';
        }
        return '\u0000';
    }

    public void putTableColumnWidths(String name, JTable table) throws SQLException {
        String widths = "";
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int columnWidth = table.getColumnModel().getColumn(i).getWidth();
            widths = widths + columnWidth + " ";
        }
        Lastval.putString(this, name, widths);
    }

    public void setTableColumnWidths(String name, JTable table) throws SQLException {
        String widths = Lastval.getString(this, name);
        if (widths != null && widths.length() > 0) {
            StringTokenizer tok = new StringTokenizer(widths);
            if (tok.countTokens() != table.getColumnCount()) {
                return;
            }
            int i = 0;
            while (tok.hasMoreTokens()) {
                int columnWidth = Integer.parseInt(tok.nextToken());
                table.getColumnModel().getColumn(i++).setPreferredWidth(columnWidth);
            }
        }
    }

    public void commit() throws SQLException {
        this.taxa.clearStatement();
        this.getDatabase().commit();
    }

    public void doRollback() {
        try {
            if (this.getDatabase() != null) {
                this.getDatabase().rollback();
            }
        }
        catch (SQLException sqle) {
            System.out.println("Error rolling back: " + sqle.getMessage());
            sqle.printStackTrace();
        }
    }

    public Taxon getPreferredTerm(int schID, int specID) throws SQLException, SBException {
        SynonymScheme scheme = this.getSynSch(schID);
        if (scheme == null) {
            throw new SBException("Synonym scheme ID: " + schID + " unknown in SBdb.getPreferredTerm");
        }
        int prefID = scheme.getPref(specID);
        if (prefID > 0) {
            return this.getTaxon(prefID);
        }
        return null;
    }

    public void updateSynonymy(int schID, Taxon taxon, Taxon pref, List<Taxon> synonymList) throws SQLException, SBException {
        SynonymScheme scheme = this.getSynSch(schID);
        if (synonymList == null) {
            scheme.remove(taxon.getSpecID());
        } else {
            if (pref == null) {
                throw new SBException("No prefrred term");
            }
            ArrayList<Integer> list = new ArrayList<Integer>(synonymList.size());
            for (Taxon t : synonymList) {
                if (t == pref) {
                    throw new SBException("Synonym is same as preferred term");
                }
                list.add(new Integer(t.getSpecID()));
            }
            Taxon prefPref = this.getPreferredTerm(schID, pref.getSpecID());
            if (prefPref != null) {
                if (!list.contains(prefPref.getSpecID())) {
                    System.out.println("Previous Preferred term: " + prefPref + " is not listed as a junior synonym of: " + pref);
                }
                scheme.deleteSyn(prefPref.getSpecID());
            }
            if (taxon != pref && !list.contains(taxon.getSpecID())) {
                list.add(taxon.getSpecID());
            }
            scheme.updateSyn(pref.getSpecID(), list);
        }
    }

    public List<Taxon> getSynonymy(int schID, int specID) throws SQLException, SBException {
        SynonymScheme scheme = this.getSynSch(schID);
        if (scheme == null) {
            throw new SBException("Synonym scheme ID: " + schID + " unknown in SBdb.getSynonymy");
        }
        LinkedList<Taxon> tSyn = new LinkedList<Taxon>();
        List syn = scheme.getSyn(specID);
        for (Integer synID : syn) {
            tSyn.add(this.getTaxon(synID));
        }
        return tSyn;
    }

    public void deleteSynonymScheme(SynonymScheme scheme) throws SQLException, SBException {
        scheme.delete();
        this.synSch.remove(scheme.getSchID());
    }

    public SynonymScheme addSynonymScheme(String name) throws SQLException, InvalidFieldException {
        Collection<SynonymScheme> c = this.getSynSchemes();
        for (SynonymScheme s : c) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            throw new InvalidFieldException("Scheme '" + name + "' already exists");
        }
        SynonymScheme scheme = new SynonymScheme(this, name);
        this.synSch.put(scheme.getSchID(), scheme);
        return scheme;
    }

    public void mergeOcc(CoOccurrence coOcc, boolean mergeAbundance) throws SQLException, SBException {
        Project project = this.getProjects().getProject(0);
        project.mergeOcc(this, coOcc, mergeAbundance);
    }

    public void mergeTaxa(Taxon donor, Taxon target, int targetSpecType) throws SQLException, SBException {
        this.events.mergeTaxonEvents(donor.getSpecID(), target.getSpecID());
        this.taxa.merge(donor, target, targetSpecType);
        if (this.projects != null) {
            Project project = this.projects.getProject(0);
            project.updateTaxonRef(donor, target);
        }
        if (this.txGroups != null) {
            for (TxGroup group : this.txGroups.values()) {
                if (group.removeSpecies(donor.getSpecID())) {
                    group.insertSpecies(target.getSpecID());
                }
                if (!group.hasChanged()) continue;
                group.notifyObservers();
            }
        }
        if (this.overlays != null) {
            for (Overlay overlay : this.overlays.values()) {
                if (!overlay.isLoaded() || !overlay.hasSpecID(donor.getSpecID())) continue;
                if (overlay.hasSpecID(target.getSpecID())) {
                    overlay.clearTaxon(donor.getSpecID());
                    continue;
                }
                overlay.replaceSpecID(donor.getSpecID(), target.getSpecID());
                overlay.notifyObservers();
            }
        }
        this.setChanged();
        this.notifyObservers(Taxon.class);
    }

    public List<AgeCurve> getAgeCurves() throws SQLException, SBException {
        if (this.ageCurves == null) {
            this.ageCurves = new LinkedList<AgeCurve>();
            if (this.isConnected()) {
                AgeCurve.loadAll(this, this.ageCurves);
            }
        }
        return this.ageCurves;
    }

    public AgeCurve getAgeCurve(int curveID) throws SQLException, SBException {
        for (AgeCurve curve : this.getAgeCurves()) {
            if (curve.getCurveID() != curveID) continue;
            return curve;
        }
        throw new SBException("No age curve found for ID: " + curveID);
    }

    public void addAgeCurve(AgeCurve ageCurve) throws SQLException, SBException {
        ageCurve.store(this);
        if (this.ageCurves == null) {
            this.ageCurves = new LinkedList<AgeCurve>();
        }
        this.ageCurves.add(ageCurve);
    }

    public static void writeXMLHeader(BufferedWriter out, Licence licence) throws IOException {
        out.write("<?xml version = '1.0' encoding ='UTF-8' ?>\n");
        String dir = System.getProperty("user.dir");
        File root = new File(dir);
        while (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        out.write("<StrataBugs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        out.write("xsi:noNamespaceSchemaLocation=\"http://www.stratadata.co.uk/StrataBugs/v2.0/docs/SBugsML2-0.xsd\">\n");
        out.write("<Prologue>\n");
        out.write("   <Organisation>" + licence.getCompany() + "</Organisation>\n");
        out.write("   <Location>" + licence.getLocation() + "</Location>\n");
        out.write("   <Date>" + SB.DBdf.format(new Date()) + "</Date>\n");
        out.write("   <Software>StrataBugs v2.0</Software>\n");
        out.write("</Prologue>\n");
    }

    public void writeXML(BufferedWriter out, List<Integer> dataTypes, SBdb db, List<File> files) throws IOException, SQLException, SBException {
        String abr;
        if (db.getExportSingleUser(false) && !db.getExportSingleUserAbr(false).isEmpty() && (abr = db.getExportSingleUserAbr(false)) != null && !abr.isEmpty()) {
            this.setWorkspaceUserID(abr, dataTypes);
        }
        int INDENT = 3;
        TaxonOcc.SPECIESRECORD.clear();
        SBdb.writeXMLHeader(out, db.licence);
        if (this.chronoSchemes != null) {
            for (IGDScheme iGDScheme : this.chronoSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.lstratSchemes != null) {
            for (IGDScheme iGDScheme : this.lstratSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.biozoneSchemes != null) {
            for (IGDScheme iGDScheme : this.biozoneSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.sequenceSchemes != null) {
            for (IGDScheme iGDScheme : this.sequenceSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.envSchemes != null) {
            for (EnvScheme envScheme : this.envSchemes) {
                envScheme.writeXML(out, 3);
            }
        }
        LinkedList<Integer> abnSchemeList = new LinkedList<Integer>();
        Iterator<Well> iterator = this.getProject(0).getWellIterator();
        while (iterator.hasNext()) {
            WsWell well = (WsWell)iterator.next();
            abnSchemeList.addAll(well.getAbnSchemeList());
        }
        for (AbnScheme abn : this.getAbnSchemes()) {
            if (!abnSchemeList.contains(abn.getID())) continue;
            out.write("   <AbundanceScheme Name=\"" + abn.getName() + "\">\n");
            abn.writeXML(out, 6);
            out.write("   </AbundanceScheme>\n");
        }
        out.write("<TaxonList>\n");
        for (Taxon taxon : this.taxa.getTaxa()) {
            out.write("   <Taxon Species=\"" + SB.getXMLstring((String)taxon.toString()) + "\">\n");
            taxon.writeXML(out, 9, null);
            out.write("   </Taxon>\n");
        }
        out.write("</TaxonList>\n");
        out.write("<UserList>\n");
        for (Userdef userdef : this.getUsers()) {
            userdef.writeXML(out, 3);
        }
        out.write("</UserList>\n");
        for (SBEvent event : this.getSBEvents(false)) {
            event.writeXML(out, 3);
        }
        if (this.compositeStandards != null) {
            for (CompositeStandard std : this.compositeStandards.values()) {
                std.writeXML(out, 3);
            }
        }
        Iterator<Well> iterator2 = this.getProject(0).getWellIterator();
        TaxonOcc.exportImages = null;
        while (iterator2.hasNext()) {
            WsWell well = (WsWell)iterator2.next();
            out.write("<Well Name=\"" + SB.getXMLstring((String)well.getWellName()) + "\">\n");
            this.putUserIDs(well.writeXML(out, 3, well.getWellUnits(), dataTypes, files));
            out.write("</Well>\n");
        }
        out.write("</StrataBugs>\n");
        out.flush();
        out.close();
    }

    public void writeXML(BufferedWriter out, TxGroup group, List<File> files) throws IOException, SQLException, SBException {
        int INDENT = 3;
        SBdb.writeXMLHeader(out, this.licence);
        group.writeXML(out, 3, files);
        out.write("</StrataBugs>\n");
        out.flush();
        out.close();
    }

    public void writeXML(BufferedWriter out, TxGroupSet groupSet, List<File> files) throws IOException, SQLException, SBException {
        int INDENT = 3;
        SBdb.writeXMLHeader(out, this.licence);
        groupSet.writeXML(out, 3, files);
        out.write("</StrataBugs>\n");
        out.flush();
        out.close();
    }

    public LinkedList<LithTrnScheme> getLithTrnSchemes() throws SBException, SQLException {
        if (this.lithTrnSchemes == null) {
            this.lithTrnSchemes = LithTrnScheme.loadSchemes(this);
        }
        return this.lithTrnSchemes;
    }

    public void addLithTrnScheme(LithTrnScheme scheme) throws SBException, SQLException {
        this.getLithTrnSchemes();
        for (LithTrnScheme sch : this.lithTrnSchemes) {
            if (sch.getID() != scheme.getID()) continue;
            return;
        }
        this.lithTrnSchemes.add(scheme);
    }

    public void deleteLithTrnScheme(int schID) throws SBException, SQLException {
        LithTrnScheme scheme = null;
        for (LithTrnScheme sch : this.getLithTrnSchemes()) {
            if (sch.getID() != schID) continue;
            scheme = sch;
            break;
        }
        if (scheme == null) {
            throw new SBException("Cannot delete LithTrnScheme: No scheme with ID: " + schID + " found.");
        }
        LithTrnScheme.delete(this, schID);
        this.commit();
        this.lithTrnSchemes.remove(scheme);
    }

    public boolean decodeChartPrintPrefs() {
        boolean shrink = false;
        try {
            String params = Lastval.getString(this, "CHPRNTPREF");
            if (params.isEmpty()) {
                System.out.println("No chart print parameters to decode");
                return shrink;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                int token = Integer.parseInt(tok.nextToken());
                shrink = token == 1;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return shrink;
    }

    public String getDBDateSQLString(long date) {
        if (this.dbType == DBType.ACCESS) {
            Date utilDate = new Date(date);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "#" + df.format(utilDate) + "#";
        }
        Timestamp stamp = new Timestamp(date);
        return "to_timestamp('" + stamp + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    public boolean getExportSingleUser(boolean load) throws SQLException {
        if (load) {
            EXPORT_SINGLE_USER = Lastval.getInt(this, "EXPSGLUSR") == 1;
        }
        return EXPORT_SINGLE_USER;
    }

    public void setExportSingleUser(boolean exportSingle) throws SQLException {
        if (exportSingle != EXPORT_SINGLE_USER) {
            Lastval.putInt(this, "EXPSGLUSR", exportSingle ? 1 : 0);
        }
        EXPORT_SINGLE_USER = exportSingle;
    }

    public String getExportSingleUserAbr(boolean load) throws SQLException {
        if (load) {
            EXPORT_SINGLE_USER_ABR = this.getDatabasePref("expsglusr");
        }
        return EXPORT_SINGLE_USER_ABR;
    }

    public void setExportSingleUserAbr(String abr) throws SQLException {
        this.putDatabasePref("expsglusr", abr);
    }

    void setWorkspaceUserID(String abr, List<Integer> dTypes) throws SBException, SQLException {
        Well well;
        if (this.isConnected()) {
            throw new SBException("Attempt to change user ID on connected database");
        }
        Iterator<Well> it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            well = it.next();
            Iterator<WellInterp> interpIt = well.getInterpIterator();
            while (interpIt.hasNext()) {
                WellInterp interp = interpIt.next();
                for (Biocom b : interp.getComments()) {
                    for (Biocom comp : interp.getComments()) {
                        if (b == comp || b.getDiscID() != comp.getDiscID() || !b.getTopSample().equals(comp.getTopSample())) continue;
                        throw new SBException("Cannot export with single user ID due to duplicated comments.\nEnsure you export only one comment per discipline/depth.");
                    }
                }
            }
        }
        it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            well = it.next();
            for (Discipline discID : Discipline.values()) {
                LinkedList<AnalystHeader> thisDisc = new LinkedList<AnalystHeader>();
                for (AnalystHeader hdr : well.getAnalystHeaders()) {
                    if (hdr.getDiscipline() != discID) continue;
                    thisDisc.add(hdr);
                }
                if (thisDisc.size() <= 1) continue;
                HashSet<Integer> used = new HashSet<Integer>();
                int newNo = 1;
                for (AnalystHeader h : thisDisc) {
                    if (used.contains(h.getAnalyNumber())) {
                        while (used.contains(newNo)) {
                            ++newNo;
                        }
                        h.setAnalyNo(newNo);
                    }
                    used.add(h.getAnalyNumber());
                }
            }
        }
        Userdef newUser = this.getUser(abr);
        if (newUser == null) {
            int ID = this.users.lastKey() + 1;
            newUser = new Userdef(this, ID, abr, abr, "", Discipline.MICRO, Color.BLACK, null, 0);
            this.putUser(newUser);
        }
        System.out.println("Setting all workspace data to user: " + newUser.getAbr());
        it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well2 = it.next();
            block25: for (Integer i : dTypes) {
                if (SBdb.isInterpDataType(i)) {
                    Iterator<WellInterp> interpIt = well2.getInterpIterator();
                    while (interpIt.hasNext()) {
                        WellInterp interp = interpIt.next();
                        switch (i) {
                            case 10: 
                            case 11: 
                            case 12: {
                                List<IGDIntervalZone> igdList = interp.getIGDList(IGDInterval.dType2IGDtype(i));
                                for (IGDIntervalZone zone : igdList) {
                                    zone.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 3: 
                            case 5: 
                            case 7: 
                            case 9: {
                                for (Biocom comment : interp.getComments(SBdb.dt2discID(i))) {
                                    comment.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 15: {
                                for (IGDIntervalEnv env : interp.getEnvs()) {
                                    env.audit.setAnalyst(newUser.getUsrID());
                                }
                                break;
                            }
                            case 14: {
                                for (SQPick pick : interp.getSQPicks()) {
                                    pick.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 16: {
                                for (WellEvent event : interp.getEvents()) {
                                    event.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 18: {
                                for (Intcom intcom : interp.getIntcoms()) {
                                    intcom.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 17: {
                                interp.getLOC().setAnalyst(newUser);
                                break;
                            }
                        }
                        interp.getHeader().setAnalyst(newUser);
                    }
                    continue;
                }
                switch (i) {
                    case 1: {
                        for (Sample sample : well2.getSamples()) {
                            sample.setAnalyst(newUser);
                        }
                        continue block25;
                    }
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: {
                        for (AnalystHeader hdr : well2.getAnalystHeaders()) {
                            if (hdr.getDiscID() != SBdb.dt2discID(i)) continue;
                            hdr.setAnalyst(newUser);
                        }
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 25: {
                        break;
                    }
                    case 24: {
                        well2.getMarkers().setAnalyst(newUser);
                        break;
                    }
                }
            }
            well2.setAnalyst(newUser);
        }
        LinkedList<Integer> schTypes = new LinkedList<Integer>();
        if (dTypes.contains(10) && this.chronoSchemes != null) {
            schTypes.add(3);
        }
        if (dTypes.contains(12) && this.lstratSchemes != null) {
            schTypes.add(2);
        }
        if (dTypes.contains(11) && this.biozoneSchemes != null) {
            schTypes.add(4);
        }
        if (dTypes.contains(14) && this.sequenceSchemes != null) {
            schTypes.add(10);
        }
        for (Integer i : schTypes) {
            for (IGDScheme s : this.getIGDSchemes(i)) {
                s.setAnalyst(newUser);
            }
        }
        if (dTypes.contains(15)) {
            for (EnvScheme es : this.getEnvSchemes()) {
                es.setAnalyst(newUser);
            }
        }
        if (dTypes.contains(16)) {
            for (SBEvent e : this.getSBEvents(false)) {
                e.setAnalyst(newUser);
            }
            if (this.compositeStandards != null) {
                for (CompositeStandard cmpStd : this.compositeStandards.values()) {
                    cmpStd.setAnalyst(newUser);
                }
            }
        }
        this.users = new TreeMap();
        this.users.put(newUser.getUsrID(), newUser);
    }

    public String DBDate(Date date) {
        String string = SB.DBdf.format(date);
        string = this.dbType == DBType.ACCESS ? "#" + string + "#" : SB.DBString((String)string);
        return string;
    }

    public boolean isNetworkError(SQLException ex) {
        int code = ex.getErrorCode();
        System.out.println("SQLError code is: " + code);
        switch (this.dbType) {
            case ACCESS: {
                return code == -1022 || code == -1023;
            }
            case ORACLE: {
                return code == 3113;
            }
        }
        return false;
    }

    public static enum DBType {
        ORACLE(2, "Oracle"),
        ACCESS(6, "Access"),
        MSSQLSERVER(3, "SQL Server"),
        MYSQL(4, "My SQL"),
        SQLITE(5, "SQLite");

        private int regType;
        private String name;

        private DBType(int regType, String name) {
            this.regType = regType;
            this.name = name;
        }

        public int getRegType() {
            return this.regType;
        }

        public String getName() {
            return this.name;
        }
    }
}

