/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import model2.Audit;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.SBdb;
import model2.Sample;
import model2.SbugsSampleObject;
import model2.Surface;
import model2.Userdef;
import model2.Well;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class SQPick
implements SortEntry,
SbugsStatus,
SbugsSampleObject {
    private final SBdb sbdb;
    private Surface surface;
    private String informalName = "";
    private Sample sample;
    private int bnd;
    private boolean questionable;
    private Audit audit = new Audit();
    Color status = UNKNOWN;

    public SQPick(Statement stmt, SBdb db, int wellID, int interpID, int surfaceID, String name, int sampID, int bnd, boolean questionable, boolean replace) throws SQLException, SBException {
        this.sbdb = db;
        this.questionable = questionable;
        this.informalName = name;
        this.bnd = bnd;
        if (replace) {
            String sql = "SELECT s.sch_id,qualifier," + Audit.sqlFieldString("p");
            sql = sql + " FROM " + db.DBTableName("SQPICK") + " p, " + db.DBTableName("SURFACE") + " s" + " WHERE interp_id=" + interpID + " AND well_id=" + wellID + " AND samp_id=" + sampID + " AND p.surface_id=s.surface_id";
            ResultSet rs = stmt.executeQuery(sql = db.modQuery(sql));
            if (rs.next()) {
                int schID = rs.getInt("sch_id");
                IGDScheme scheme = db.getIGDScheme(schID);
                this.surface = scheme.getSurface(surfaceID);
                if (this.surface == null) {
                    System.out.println("Warning: surface null in query: " + sql);
                }
                if (this.surface == null || this.surface.getType() == Surface.SurfaceType.SB) {
                    sql = "DELETE FROM " + db.DBTableName("SQPICK") + " WHERE interp_id=" + interpID + " AND well_id=" + wellID + " AND samp_id=" + sampID;
                    stmt.executeUpdate(db.modQuery(sql));
                }
            }
        }
        this.store(wellID, interpID, sampID, surfaceID, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SQPick load(SBdb sbdb, Well well, int interpID, int sampID, int surfaceID, SQPick p) throws SQLException, SBException {
        String sql = "SELECT s.sch_id,bnd,qualifier,inf," + Audit.sqlFieldString("p");
        sql = sql + " FROM " + sbdb.DBTableName("SQPICK") + " p, " + sbdb.DBTableName("SURFACE") + " s" + " WHERE interp_id=" + interpID + " AND well_id=" + well.getWellID() + " AND samp_id=" + sampID + " AND p.surface_id=" + surfaceID + " AND p.surface_id=s.surface_id";
        sql = sbdb.modQuery(sql);
        Statement stmt = sbdb.getDatabase().createStatement();
        Builder builder = null;
        try {
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int schID = rs.getInt("sch_id");
                IGDScheme scheme = sbdb.getIGDScheme(schID);
                int bnd = rs.getInt("bnd");
                builder = new Builder(sbdb, scheme.getSurface(surfaceID), well.getSample(sampID), bnd);
                String strg = rs.getString("qualifier");
                if (strg != null && strg.length() > 0 && strg.equals("?")) {
                    builder.questionable(true);
                }
                String infName = rs.getString("inf");
                builder.informalName(infName);
                builder.audit(new Audit(rs, "p"));
                builder.status = SQPick.STORED;
            }
        }
        finally {
            stmt.close();
        }
        if (builder == null) {
            return null;
        }
        if (p == null) {
            return builder.build();
        }
        if (p.surface != builder.surface || p.sample != builder.sample) {
            throw new IllegalArgumentException("Attempt to copy fields to unequivalent Sequence Pick object");
        }
        p.bnd = builder.bnd;
        p.informalName = builder.informalName;
        p.questionable = builder.questionable;
        p.audit = builder.audit;
        return p;
    }

    SQPick(SBdb ws, SQPick dbPick, Well wsWell) throws SQLException, SBException {
        this.sbdb = ws;
        this.copyPrimitives(dbPick);
        this.audit = new Audit(dbPick.audit);
        this.audit.fillWorkspace(dbPick.sbdb, ws);
        IGDScheme dbScheme = dbPick.surface.getScheme();
        if (ws.getIGDScheme(dbScheme.getSchID()) == null) {
            dbScheme.loadUnits();
            IGDScheme wsScheme = IGDScheme.copyToWorkspace(ws, dbScheme);
            ws.addIGDScheme(wsScheme);
        }
        this.surface = ws.getIGDScheme(dbScheme.getSchID()).getSurface(dbPick.getSurfaceID());
        this.sample = wsWell.getSample(dbPick.getSample().getSampID());
        this.status = STORED;
    }

    SQPick(SBdb db, SQPick wsPick) throws SBException, SQLException {
        this.sbdb = db;
        this.copyPrimitives(wsPick);
        this.audit = new Audit(db, wsPick.sbdb, this.audit);
        this.sample = wsPick.sample.link;
        if (this.sample == null) {
            throw new SBException("Pick Sample not linked :" + this.getName());
        }
        this.surface = wsPick.sbdb.getIGDScheme(wsPick.getSurface().getSchID()).getSurface(wsPick.getSurface().getName()).getLink();
        if (this.surface == null) {
            throw new SBException("Surface ID null for db constructor for pick: " + this.getName());
        }
        this.status = NOTSTORED;
    }

    public String getQualifier() {
        if (this.questionable) {
            return "?";
        }
        return "";
    }

    @Override
    public Sample getSample() {
        return this.sample;
    }

    public final String getName() {
        if (this.informalName != null && this.informalName.length() > 0) {
            return this.informalName;
        }
        return this.surface.getName();
    }

    public String toString() {
        if (this.sample != null) {
            return this.sample.toString() + " " + this.getName();
        }
        return this.getName();
    }

    public String getInfName() {
        return this.informalName;
    }

    public int getBndInt() {
        return this.bnd;
    }

    public String getBnd() {
        return IGDIntervalZone.getBoundary(this.bnd);
    }

    public Surface getSurface() {
        return this.surface;
    }

    public Surface.SurfaceType getSurfaceType() {
        if (this.surface == null) {
            return null;
        }
        return this.surface.getType();
    }

    public String getTypeString() {
        if (this.surface == null) {
            return null;
        }
        return this.surface.getTypeString();
    }

    private void copyPrimitives(SQPick rhs) {
        this.informalName = rhs.informalName;
        this.bnd = rhs.bnd;
        this.questionable = rhs.questionable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to SQPick.delete: wellID is " + wellID + ", interpID is: " + interpID);
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.sbdb.DBTableName("sqpick") + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND surface_id=" + this.surface.getSurfaceID() + " AND interp_id=" + interpID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.status = NOTSTORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void store(int wellID, int interpID) throws SQLException {
        if (this.surface == null) {
            throw new IllegalStateException("Attempt to store pick:" + this.toString() + " with no linked surface");
        }
        if (this.sample == null) {
            throw new IllegalStateException("Attempt to store pick: " + this.toString() + " with no linked sample");
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            this.store(wellID, interpID, this.sample.getSampID(), this.surface.getSurfaceID(), stmt);
        }
        finally {
            stmt.close();
        }
    }

    private void store(int wellID, int interpID, int sampID, int surfaceID, Statement stmt) throws SQLException {
        if (surfaceID <= 0) {
            throw new IllegalArgumentException("Attempt to store pick with no surface ID");
        }
        if (sampID <= 0) {
            throw new IllegalArgumentException("Attempt to store pick with no sample ID");
        }
        if (this.informalName != null && this.surface != null && this.informalName.equals(this.surface.getName())) {
            this.informalName = null;
        }
        String sql = "INSERT INTO " + this.sbdb.DBTableName("sqpick") + " (well_id,interp_id,surface_id,inf,samp_id,bnd,qualifier," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + surfaceID + "," + SB.DBString((String)this.informalName) + "," + sampID + "," + this.bnd + "," + (this.questionable ? "'?'" : "NULL") + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(int wellID, int interpID, int newInterpID) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0 || newInterpID < 0) {
            throw new IllegalArgumentException("Illegal argument to SQPick.move: wellID is " + wellID + ", interpID is " + interpID + ", newInterpID is " + newInterpID);
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit tempAudit = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("sqpick") + " SET interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND surface_id=" + this.surface.getSurfaceID() + " AND interp_id=" + interpID;
        try {
            int nUpdated = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nUpdated != 1) {
                throw new SBException("Cannot update sequence pick: " + this);
            }
        }
        finally {
            stmt.close();
        }
        this.audit = tempAudit;
    }

    public int getSurfaceID() {
        return this.surface.getSurfaceID();
    }

    public int getSampID() {
        return this.sample.getSampID();
    }

    public boolean isQuestionable() {
        return this.questionable;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public String getModifierString() throws SQLException, SBException {
        return this.sbdb.getUser(this.audit.modifier).getAbr();
    }

    public int getUpdater() {
        return this.audit.updater;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public Date getUpdated() {
        return this.audit.updated;
    }

    public String getSortEntry() {
        return this.sample.getSortEntry();
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.surface.getName();
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<SequencePick>\n");
        out.write(ind + "<SampleID>" + this.sample.getSampID() + "</SampleID>\n");
        out.write(ind + "<SurfaceID>" + this.surface.getSurfaceID() + "</SurfaceID>\n");
        out.write(ind + "<SchemeID>" + this.surface.getSchID() + "</SchemeID>\n");
        out.write(ind + "<Name>" + (this.informalName != null && this.informalName.length() > 0 ? this.informalName : this.surface.getName()) + "</Name>\n");
        if (this.questionable) {
            out.write(ind + "<Questionable>" + this.questionable + "</Questionable>\n");
        }
        out.write(ind + "<Boundary>" + this.getBnd() + "</Boundary>\n");
        this.audit.writeXML(out, indent);
        out.write("</SequencePick>\n");
    }

    SQPick(SBdb db, Well well, Element xml) throws SQLException, SBException, ParseException {
        Element el;
        this.sbdb = db;
        String strg = xml.getChildTextNormalize("SampleID");
        if (strg != null) {
            int sampID = Integer.parseInt(strg);
            this.sample = well.getSample(sampID);
            if (this.sample == null) {
                throw new SBException("Cannot find Top Sample in Pick for ID: " + sampID);
            }
        }
        int surfaceID = 0;
        strg = xml.getChildTextNormalize("SurfaceID");
        if (strg != null) {
            surfaceID = Integer.parseInt(strg);
        }
        int schemeID = 0;
        strg = xml.getChildTextNormalize("SchemeID");
        if (strg == null) {
            throw new SBException("No surface scheme specified for Pick: " + this.sample);
        }
        schemeID = Integer.parseInt(strg);
        this.surface = db.getIGDScheme(schemeID).getSurface(surfaceID);
        if (this.surface == null) {
            throw new SBException("No surface specified for Pick: " + this.sample);
        }
        strg = xml.getChildTextNormalize("Name");
        if (strg != null && strg.length() > 0 && !strg.equalsIgnoreCase(this.surface.getName())) {
            this.informalName = strg;
        }
        if ((strg = xml.getChildTextNormalize("Questionable")) != null) {
            this.questionable = Boolean.parseBoolean(strg);
        }
        if ((strg = xml.getChildTextNormalize("Boundary")) != null) {
            this.bnd = IGDIntervalZone.getBoundaryTypeFromString(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for pick: " + this);
        }
    }

    void updateStatus(List<SQPick> picks) throws SBException {
        if (this.sample != null) {
            // empty if block
        }
        this.status = NOTSTORED;
        for (SQPick pick : picks) {
            if (pick == this || !this.isFuncEquivalent(pick)) continue;
            this.status = STORED;
            if (!pick.surface.getName().trim().equals(this.surface.getName().trim())) {
                this.status = CONFLICT;
                break;
            }
            if (pick.surface.getType() != this.surface.getType()) {
                this.status = CONFLICT;
                break;
            }
            if (pick.getBndInt() != this.getBndInt()) {
                this.status = CONFLICT;
                break;
            }
            if (pick.questionable != this.questionable) {
                this.status = CONFLICT;
                break;
            }
            if (pick.getInfName() == null || pick.getInfName().equals(this.informalName) || pick.getInfName().equals(pick.getSurface().getName()) && this.informalName.equals(this.surface.getName())) break;
            this.status = CONFLICT;
            break;
        }
    }

    boolean mergeSamples(Sample donor, Sample target) {
        if (this.sample == donor) {
            this.sample = target;
            return true;
        }
        return false;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException {
        if (e instanceof SQPick) {
            if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
                return true;
            }
            SQPick comp = (SQPick)e;
            if (this.sample.isFuncEquivalent(comp.getSample())) {
                return true;
            }
        }
        return false;
    }

    public void setInfName(String newInfName) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set informal name on database pick: " + this);
        }
        if (newInfName == null) {
            newInfName = "";
        }
        System.out.println("Changing informal name for pick: " + this + " to: " + newInfName);
        this.informalName = newInfName;
    }

    public String getSchemeName() throws SQLException {
        return this.getSchemeName(false);
    }

    public String getSchemeName(boolean useLink) throws SQLException {
        if (this.surface == null) {
            return "Surface null";
        }
        if (this.surface.getSchID() > 0) {
            IGDScheme scheme;
            if (this.sbdb != null && (scheme = this.sbdb.getIGDScheme(this.surface.getSchID())) != null) {
                if (useLink && scheme.getLink() != null) {
                    return scheme.getLink().toString();
                }
                return scheme.toString();
            }
            return "Scheme ID = " + this.surface.getSchID();
        }
        return "";
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for SQPick: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private SQPick(Builder builder) {
        this.sbdb = builder.sbdb;
        this.surface = builder.surface;
        this.sample = builder.sample;
        this.bnd = builder.bnd;
        this.informalName = builder.informalName;
        this.questionable = builder.questionable;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    public static class Builder {
        private final SBdb sbdb;
        private final Surface surface;
        private final Sample sample;
        private String informalName = "";
        private boolean questionable = false;
        private Audit audit = new Audit();
        private Color status = SbugsStatus.UNKNOWN;
        private int bnd = 0;

        public Builder(SBdb sbdb, Surface surface, Sample sample, int bnd) {
            this.sbdb = sbdb;
            this.sample = sample;
            this.surface = surface;
            if (bnd == 0) {
                bnd = surface.getBndDefault();
            }
            this.bnd = bnd;
        }

        public static Builder copyOf(SQPick rhs) {
            Builder builder = new Builder(rhs.sbdb, rhs.surface, rhs.sample, rhs.bnd);
            builder.informalName(rhs.informalName).questionable(rhs.questionable).audit(rhs.audit);
            return builder;
        }

        Builder informalName(String informalName) {
            if (informalName != null && !informalName.isEmpty()) {
                this.informalName = informalName;
            }
            return this;
        }

        Builder questionable(boolean questionable) {
            this.questionable = questionable;
            return this;
        }

        Builder bnd(int bnd) {
            if (bnd >= 0) {
                this.bnd = bnd;
            }
            return this;
        }

        Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
                this.status = SbugsStatus.STORED;
            }
            return this;
        }

        SQPick build() {
            if (this.sbdb == null) {
                throw new IllegalStateException("Attempt to build SQPick with null data model");
            }
            if (this.sample == null) {
                throw new IllegalStateException("Attempt to build SQPick with null sample");
            }
            if (this.surface == null) {
                throw new IllegalStateException("Attempt to build SQPick with null surface");
            }
            if (this.bnd < 0) {
                throw new IllegalStateException("Attempt to build SQPick with illgal bnd: " + this.bnd);
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new SQPick(this);
        }

        SQPick build(int wellID, int interpID) throws SQLException {
            if (this.status == SbugsStatus.STORED) {
                System.out.println("WARNING: building SQPick with store, builder has stored status");
            }
            SQPick pick = this.build();
            pick.store(wellID, interpID);
            return pick;
        }
    }
}

