/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import model2.AnalystHeader;
import model2.Audit;
import model2.DEXFile;
import model2.IGDIntervalZone;
import model2.ImageSet;
import model2.Lastval;
import model2.Lithdesc;
import model2.Project;
import model2.SBdb;
import model2.SampleInsertException;
import model2.SampleLithology;
import model2.SampleLithologyUnit;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Userdef;
import model2.Well;
import model2.WellInterp;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class Sample
extends Observable
implements SbugsStatus,
SortEntry {
    private String stratigraphyString = null;
    static int logDp = 1;
    Sample link = null;
    public static final float SMALL = 0.0029f;
    static final String[] SBSampleTypes = new String[]{"CU", "CO", "SC", "OC", "LOG"};
    private final SBdb SB;
    private int sampID;
    private SampleDepth depth = null;
    private String type = "";
    private double gridX;
    private double gridY;
    private String textLabel = "";
    private char sectionType = (char)87;
    private Audit audit = new Audit();
    String donorAnalyst = "";
    String donorSampleType = null;
    boolean hasImportedAgeData = false;
    Color status = SbugsStatus.UNKNOWN;
    public char displayUnits = (char)77;
    boolean[] detailsLoaded = new boolean[4];
    List<Smpdtl> analyses = new LinkedList<Smpdtl>();
    SampleLithology sampleLithology = new SampleLithology();
    private HashMap<Integer, SampleAge> ages = new HashMap();
    static int SLFACT = 10000000;

    public static void setLogDp(SBdb db, int dp) throws SBException, SQLException {
        switch (dp) {
            case 1: 
            case 2: 
            case 3: {
                logDp = dp;
                Lastval.putInt(db, "LOGPREC", dp);
                break;
            }
            default: {
                throw new SBException("Can't set log decimal places to: " + dp + ", only 1-3 allowed");
            }
        }
    }

    public static int getLogDp(SBdb db) throws SQLException {
        int p = Lastval.getInt(db, "LOGPREC");
        if (p > 0) {
            logDp = p;
        }
        return logDp;
    }

    public Sample getLink() {
        return this.link;
    }

    void setLink(Sample comp) throws SQLException, SBException {
        this.link = comp;
        for (Smpdtl dtl : this.analyses) {
            dtl.link = null;
            if (comp == null) continue;
            int analyNo = dtl.getAnalyNo();
            for (Smpdtl compDtl : comp.analyses) {
                if (compDtl.getDiscID() != dtl.getDiscID() || !compDtl.getAnalyst().equals(dtl.getAnalyst()) || compDtl.getAnalyNo() != analyNo) continue;
                dtl.link = compDtl;
            }
        }
    }

    public String getStratigraphy(WellInterp wellInterp, boolean refresh) throws SBException {
        if (wellInterp == null) {
            refresh = false;
            this.stratigraphyString = null;
        }
        if (this.stratigraphyString == null && wellInterp != null) {
            refresh = true;
        }
        if (refresh) {
            this.stratigraphyString = wellInterp.getStratigraphy(this.getDepth());
        }
        return this.stratigraphyString;
    }

    public void moveDtl(int wellID, AnalystHeader hdr, AnalystHeader newHdr) throws SBException, SQLException, Exception {
        if (this.getSmpdtl(newHdr.getAnalyID()) != null) {
            throw new SBException("New Analyst already exists for Sample: " + this);
        }
        Smpdtl dtl = this.getSmpdtl(hdr.getAnalyID());
        if (dtl == null) {
            throw new SBException("Can't relocate analysis for moving in sample: " + this);
        }
        dtl.move(wellID, newHdr);
        this.setChanged();
    }

    public void mergeDtl(int wellID, Smpdtl dtl, AnalystHeader newHdr) throws SBException, SQLException, Exception {
        Smpdtl target = this.getSmpdtl(newHdr.getAnalyID());
        if (target == null) {
            throw new SBException("Cannot find target analysis for Sample: " + this);
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        target.mergeOcc(dtl, stmt, wellID, this.sampID);
        this.deleteDtl(wellID, dtl.getHeader().getAnalyID(), dtl);
    }

    boolean hasEnvData(AnalystHeader hdr) {
        boolean hasData = false;
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (hdr != null && smpdtl.getHeader() != hdr || !(hasData = smpdtl.hasEnvData())) continue;
            return true;
        }
        return hasData;
    }

    void mergeAnalyses(Sample donor) throws SBException {
        if (donor.analyses != null) {
            for (Smpdtl smpdtl : donor.analyses) {
                smpdtl.setSample(this, true);
                this.insert(smpdtl);
            }
        }
    }

    private SampleAge getDefaultSampleAge() {
        SampleAge age = this.ages.get(0);
        if (age == null) {
            age = new SampleAge();
            this.ages.put(0, age);
        }
        return age;
    }

    public SampleLithology getLithology() {
        return this.sampleLithology;
    }

    public String getSortEntry() {
        String entry;
        try {
            int second;
            int first;
            int top = this.getTopDepth() == null ? (int)(this.getBaseDepth() * 1000.0) : (int)(this.getTopDepth() * 1000.0);
            int base = this.getBaseDepth() == null ? (int)(this.getTopDepth() * 1000.0) : (int)(this.getBaseDepth() * 1000.0);
            if (this.SB.useSampleTops()) {
                first = top;
                second = base;
            } else {
                first = base;
                second = top;
            }
            entry = "" + (first + SLFACT);
            while (entry.length() < 8) {
                entry = ' ' + entry;
            }
            String baseString = "" + (second + SLFACT);
            while (baseString.length() < 8) {
                baseString = ' ' + baseString;
            }
            entry = entry + baseString;
            entry = entry + this.type;
        }
        catch (Exception e) {
            entry = this.toString();
        }
        return entry;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException {
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return true;
        }
        if (this.getTopDepth() != null && this.getBaseDepth() != null) {
            return false;
        }
        Sample sample = (Sample)e;
        if (!sample.type.equals(this.type) || sample.getTopDepth() == null || sample.getBaseDepth() == null) {
            return false;
        }
        if (this.getTopDepth() != null && this.depth.compareTop(sample.getTopDepth()) == 0) {
            return true;
        }
        return this.getBaseDepth() != null && this.depth.compareBase(sample.getBaseDepth()) == 0;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    SampleAge getSampleAge(int interpID) {
        return this.ages.get(interpID);
    }

    public Double getAge(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.age;
        }
        return null;
    }

    public Double getRatio(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ratio;
        }
        return null;
    }

    public Float getAgeErrorPlus(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ageErrorPlus;
        }
        return null;
    }

    public Float getAgeErrorMinus(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ageErrorMinus;
        }
        return null;
    }

    public Double getAgeBelow(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ageBelow;
        }
        return null;
    }

    public double getAge(WellInterp interp) {
        return this.getAge(interp.interpID);
    }

    public double getAgeBelow(WellInterp interp) {
        return this.getAgeBelow(interp.interpID);
    }

    Sample(SBdb SB2, char sectionType) {
        this.SB = SB2;
        this.sectionType = sectionType;
    }

    public Sample(SBdb db, Sample sample, boolean clearSampID) throws SQLException, SBException {
        this.copy(sample);
        this.SB = db;
        if (clearSampID) {
            this.sampID = 0;
        }
        this.audit = new Audit(this.SB, sample.SB, this.audit);
        sample.link = this;
        this.status = NOTSTORED;
    }

    public Sample(SBdb ws, Sample sample) throws SQLException, SBException {
        this.copy(sample);
        this.audit.fillWorkspace(sample.SB, ws);
        this.SB = ws;
        this.link = sample;
    }

    Sample(SBdb db, Lithdesc lithdesc, DEXFile.DEXsection section, char sectionType, Well well, List dataTypes, int[] wellAbn, boolean setWellHeaderUnits) throws SBException, SQLException {
        this.SB = db;
        this.sectionType = sectionType;
        char discID = '\u0000';
        int lithCode = 0;
        int lithPercent = 0;
        String analyst = null;
        String picker = null;
        String source = null;
        String notes = null;
        Date smpdtlModified = null;
        String smpdtlModifier = null;
        float coarse = 0.0f;
        float medium = 0.0f;
        float fine = 0.0f;
        float weight = 0.0f;
        Smpdtl.AnalysisType analysisType = Smpdtl.AnalysisType.ANALYSED;
        String taxonDonorString = null;
        int counts = 0;
        int fssCoarse = 0;
        int fssFine = 0;
        boolean reworked = false;
        boolean caved = false;
        boolean marker = false;
        int identType = 80;
        int form = 67;
        int growth = 65;
        String preservation = null;
        String comment = null;
        String colour = null;
        String subjAbund = null;
        String speciesType = null;
        LinkedList<TaxonOcc> occs = new LinkedList<TaxonOcc>();
        int specID = 0;
        this.status = NOTSTORED;
        for (int i = 0; i < section.label.size(); ++i) {
            SampleAge age;
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("TOP DEPTH")) {
                this.setTopDepth(util.SB.parseDepthString((String)value), 'M');
                this.displayUnits = util.SB.parseDepthUnitsFromString((String)value);
                if (well.getWellUnits() == this.displayUnits || this.displayUnits <= '\u0000' || !setWellHeaderUnits) continue;
                well.getHeader().setWellUnits(this.displayUnits);
                continue;
            }
            if (label.equalsIgnoreCase("BASE DEPTH")) {
                this.setBaseDepth(util.SB.parseDepthString((String)value), 'M');
                this.displayUnits = util.SB.parseDepthUnitsFromString((String)value);
                if (well.getWellUnits() == this.displayUnits || this.displayUnits <= '\u0000' || !setWellHeaderUnits) continue;
                well.getHeader().setWellUnits(this.displayUnits);
                continue;
            }
            if (label.equalsIgnoreCase("TYPE")) {
                this.setType(value);
                continue;
            }
            if (label.equalsIgnoreCase("SAMPLE ID")) {
                this.sampID = Integer.parseInt(value);
                System.out.println("Parsing sample, ID=" + this.sampID);
                continue;
            }
            if (label.equalsIgnoreCase("ANALYST") && sepChar == '=') {
                this.donorAnalyst = value;
                if (this.SB.getUser(analyst) != null) continue;
                this.SB.getAddUserID(this.donorAnalyst);
                continue;
            }
            if (label.equalsIgnoreCase("GRID X")) {
                this.gridX = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("GRID Y")) {
                this.gridY = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("LABEL")) {
                this.textLabel = value;
                continue;
            }
            if (label.equalsIgnoreCase("AGE")) {
                age = this.getAddAge(0);
                age.age = Double.parseDouble(value);
                this.hasImportedAgeData = true;
                continue;
            }
            if (label.equalsIgnoreCase("AGE BELOW UNCONFORMITY")) {
                age = this.getAddAge(0);
                age.ageBelow = Double.parseDouble(value);
                this.hasImportedAgeData = true;
                continue;
            }
            if (label.equalsIgnoreCase("AGE ERROR PLUS")) {
                age = this.getAddAge(0);
                age.ageErrorPlus = Float.valueOf(Float.parseFloat(value));
                this.hasImportedAgeData = true;
                continue;
            }
            if (label.equalsIgnoreCase("AGE ERROR MINUS")) {
                age = this.getAddAge(0);
                age.ageErrorMinus = Float.valueOf(Float.parseFloat(value));
                this.hasImportedAgeData = true;
                continue;
            }
            if (label.equalsIgnoreCase("RATIO")) {
                age = this.getAddAge(0);
                age.ratio = Double.parseDouble(value);
                this.hasImportedAgeData = true;
                continue;
            }
            if (label.equalsIgnoreCase("LITHOLOGY CODE")) {
                if (lithCode != 0) {
                    SampleLithologyUnit lith = new SampleLithologyUnit(lithdesc.getLithology(lithCode), lithPercent);
                    this.sampleLithology.add(lith);
                    if (!dataTypes.contains(22)) {
                        dataTypes.add(22);
                    }
                }
                lithCode = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("LITHOLOGY PERCENT")) {
                lithPercent = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("DISCIPLINE")) {
                if (discID != '\u0000') {
                    try {
                        if (analyst == null) {
                            analyst = db.getUser().getAbr();
                        }
                        AnalystHeader header = well.getAnalystHeader(analyst, discID, 1, true);
                        Audit smpdtlAudit = new Audit(this.audit);
                        if (smpdtlModifier != null && smpdtlModified != null) {
                            smpdtlAudit = new Audit(this.SB.getAddUserID(smpdtlModifier), smpdtlModified, this.SB.getAddUserID(smpdtlModifier), smpdtlModified);
                        }
                        Smpdtl smpdtl = new Smpdtl(db, this, header, picker, source, notes, 0, 0, 0, weight, coarse, medium, fine, this.audit, analysisType);
                        this.insert(smpdtl);
                        Integer dataType = new Integer(SBdb.did2dtype(discID));
                        if (!dataTypes.contains(dataType)) {
                            dataTypes.add(dataType);
                        }
                        if (taxonDonorString != null) {
                            if (db.getTaxon(specID) == null) {
                                db.getTaxon(taxonDonorString, specID, true);
                            }
                            TaxonOcc.Builder builder = new TaxonOcc.Builder(db, db.getTaxon(specID), reworked, identType == 63, db.getAddSpecType((char)form, (char)growth, speciesType));
                            builder.caved(caved).marker(marker).count(fssCoarse, counts, fssFine).subjAbund(subjAbund);
                            builder.preservation(preservation).colour(colour).comment(comment);
                            occs.add(builder.build());
                            counts = 0;
                            fssCoarse = 0;
                            fssFine = 0;
                            reworked = false;
                            caved = false;
                            marker = false;
                            identType = 80;
                            form = 67;
                            growth = 65;
                            preservation = null;
                            comment = null;
                            colour = null;
                            subjAbund = null;
                            speciesType = null;
                        }
                        boolean hasSemiQuant = false;
                        for (TaxonOcc occ : occs) {
                            Taxon taxon = db.getTaxon(occ.getSpecID());
                            if (taxon != null) {
                                occ.setTaxon(taxon);
                            }
                            if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0) continue;
                            hasSemiQuant = true;
                        }
                        smpdtl.copyOccs(occs);
                        if (hasSemiQuant) {
                            header.setAbnScheme(wellAbn[SBdb.did2i(discID)]);
                        }
                        occs = new LinkedList();
                        taxonDonorString = null;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                discID = value.charAt(0);
                continue;
            }
            if (label.equalsIgnoreCase("MODIFIED") && sepChar == ':') {
                try {
                    smpdtlModified = util.SB.df.parse(value);
                }
                catch (ParseException pe) {}
                continue;
            }
            if (label.equalsIgnoreCase("MODIFIER") && sepChar == ':') {
                smpdtlModifier = value;
                continue;
            }
            if (label.equalsIgnoreCase("ANALYST") && sepChar == ':') {
                analyst = value;
                continue;
            }
            if (label.equalsIgnoreCase("PICKER")) {
                picker = value;
                continue;
            }
            if (label.equalsIgnoreCase("SOURCE")) {
                source = value;
                continue;
            }
            if (label.equalsIgnoreCase("NOTES")) {
                notes = value;
                continue;
            }
            if (label.equalsIgnoreCase("COARSE FRACTION")) {
                coarse = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("MEDIUM FRACTION")) {
                medium = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("FINE FRACTION")) {
                fine = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("WEIGHT")) {
                weight = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("ANALYSIS")) {
                if (!value.equalsIgnoreCase("Barren")) continue;
                analysisType = Smpdtl.AnalysisType.BARREN;
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES") && sepChar == '=') {
                if (taxonDonorString != null) {
                    if (db.getTaxon(specID) == null) {
                        db.getTaxon(taxonDonorString, specID, true);
                    }
                    TaxonOcc.Builder builder = new TaxonOcc.Builder(db, db.getTaxon(specID), reworked, identType == 63, db.getAddSpecType((char)form, (char)growth, speciesType));
                    builder.caved(caved).marker(marker).count(fssCoarse, counts, fssFine).subjAbund(subjAbund);
                    builder.preservation(preservation).colour(colour).comment(comment);
                    occs.add(builder.build());
                    counts = 0;
                    fssCoarse = 0;
                    fssFine = 0;
                    reworked = false;
                    caved = false;
                    marker = false;
                    identType = 80;
                    form = 67;
                    growth = 65;
                    preservation = null;
                    comment = null;
                    colour = null;
                    subjAbund = null;
                    speciesType = null;
                    analysisType = Smpdtl.AnalysisType.ANALYSED;
                }
                taxonDonorString = value;
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES ID")) {
                specID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES COUNT")) {
                counts = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES COUNT COARSE")) {
                fssCoarse = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES COUNT FINE")) {
                fssFine = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("QUALIFIER")) {
                if (value.charAt(0) == 'R') {
                    reworked = true;
                }
                if (value.charAt(0) != '?') continue;
                identType = 63;
                continue;
            }
            if (label.equalsIgnoreCase("FLAG")) {
                if (value.charAt(0) == 'C') {
                    caved = true;
                }
                if (value.charAt(0) != 'M') continue;
                marker = true;
                continue;
            }
            if (label.equalsIgnoreCase("FORM")) {
                form = value.charAt(0);
                continue;
            }
            if (label.equalsIgnoreCase("GROWTH STAGE")) {
                growth = value.charAt(0);
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES TYPE")) {
                speciesType = value;
                continue;
            }
            if (label.equalsIgnoreCase("PRESERVATION")) {
                preservation = value;
                continue;
            }
            if (label.equalsIgnoreCase("SP COMMENT")) {
                comment = value;
                continue;
            }
            if (label.equalsIgnoreCase("COLOUR")) {
                colour = value;
                continue;
            }
            if (label.equalsIgnoreCase("ABUNDANCE")) {
                subjAbund = value;
                continue;
            }
            if (label.equalsIgnoreCase("CREATED")) {
                try {
                    this.audit.created = util.SB.df.parse(value);
                }
                catch (ParseException pe) {}
                continue;
            }
            if (!label.equalsIgnoreCase("MODIFIED") || sepChar != '=') continue;
            try {
                this.audit.modified = util.SB.df.parse(value);
                continue;
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        if (lithCode != 0) {
            SampleLithologyUnit lith = new SampleLithologyUnit(lithdesc.getLithology(lithCode), lithPercent);
            this.sampleLithology.add(lith);
            if (!dataTypes.contains(22)) {
                dataTypes.add(22);
            }
        }
        if (taxonDonorString != null) {
            if (db.getTaxon(specID) == null) {
                db.getTaxon(taxonDonorString, specID, true);
            }
            TaxonOcc.Builder builder = new TaxonOcc.Builder(db, db.getTaxon(specID), reworked, identType == 63, db.getAddSpecType((char)form, (char)growth, speciesType));
            builder.caved(caved).marker(marker).count(fssCoarse, counts, fssFine).subjAbund(subjAbund);
            builder.preservation(preservation).colour(colour).comment(comment);
            occs.add(builder.build());
        }
        if (discID != '\u0000') {
            try {
                if (analyst == null) {
                    analyst = db.getUser().getAbr();
                }
                AnalystHeader header = well.getAnalystHeader(analyst, discID, 1, true);
                Audit smpdtlAudit = new Audit(this.audit);
                if (smpdtlModifier != null && smpdtlModified != null) {
                    smpdtlAudit = new Audit(this.SB.getAddUserID(smpdtlModifier), smpdtlModified, this.SB.getAddUserID(smpdtlModifier), smpdtlModified);
                }
                Smpdtl smpdtl = new Smpdtl(db, this, header, picker, source, notes, 0, 0, 0, weight, coarse, medium, fine, smpdtlAudit, analysisType);
                this.insert(smpdtl);
                Integer dataType = new Integer(SBdb.did2dtype(discID));
                if (!dataTypes.contains(dataType)) {
                    dataTypes.add(dataType);
                }
                boolean hasSemiQuant = false;
                for (TaxonOcc occ : occs) {
                    Taxon taxon = db.getTaxon(occ.getSpecID());
                    if (taxon != null) {
                        occ.setTaxon(taxon);
                    }
                    if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0) continue;
                    hasSemiQuant = true;
                }
                smpdtl.copyOccs(occs);
                if (hasSemiQuant) {
                    header.setAbnScheme(wellAbn[SBdb.did2i(discID)]);
                }
                occs = new LinkedList();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private SampleAge getAddAge(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age == null) {
            age = new SampleAge();
            this.ages.put(interpID, age);
        }
        return age;
    }

    void copy(Sample rhs) {
        this.sectionType = rhs.sectionType;
        this.sampID = rhs.sampID;
        this.depth = new SampleDepth();
        this.depth.top = rhs.depth.top;
        this.depth.base = rhs.depth.base;
        this.type = rhs.type;
        this.gridX = rhs.gridX;
        this.gridY = rhs.gridY;
        this.audit = rhs.audit;
        this.textLabel = rhs.textLabel;
        this.setChanged();
    }

    public void copyLithology(SampleLithology rhs) {
        this.sampleLithology.getLithology().clear();
        for (SampleLithologyUnit lith : rhs.getLithology()) {
            this.sampleLithology.add(new SampleLithologyUnit(lith));
        }
    }

    public List<Smpdtl> getAnalyses() {
        return this.analyses;
    }

    Sample(SBdb SB2, char sectionType, int sampID, Double topDepth, Double baseDepth, String sampleType, double gridX, double gridY, String label, Audit audit) throws SBException {
        this.SB = SB2;
        this.sectionType = sectionType;
        this.sampID = sampID;
        this.setDepth(topDepth, baseDepth, 'M');
        this.type = sampleType;
        this.gridX = gridX;
        this.gridY = gridY;
        this.audit = audit;
        this.textLabel = label;
    }

    public Sample(Statement stmt, SBdb SB2, char sectionType, int wellID, int sampID, Double topDepth, Double baseDepth, String sampleType, String label, double gridX, double gridY, Date created, Userdef creator, Date modified, Userdef modifier) throws SBException, SQLException, FileNotFoundException, IOException {
        this.SB = SB2;
        this.sectionType = sectionType;
        this.sampID = sampID;
        if (topDepth == null && baseDepth == null) {
            topDepth = baseDepth = Double.valueOf(0.0);
        }
        this.setDepth(topDepth, baseDepth, '\u0000');
        this.type = sampleType;
        this.gridX = gridX;
        this.gridY = gridY;
        this.audit.created = created;
        if (creator != null) {
            this.audit.creator = creator.getUsrID();
        }
        this.audit.modified = modified;
        if (modifier != null) {
            this.audit.modifier = modifier.getUsrID();
        }
        this.textLabel = label;
        this.status = NOTSTORED;
        this.store(stmt, wellID, sampID);
    }

    Sample(SBdb SB2, char sectionType, Double topDepth, Double baseDepth, String sampleType, String label) throws SBException {
        this.SB = SB2;
        this.sectionType = sectionType;
        this.setDepth(topDepth, baseDepth, 'M');
        this.setType(sampleType);
        this.textLabel = label;
    }

    public Sample(SBdb SB2, int wellID, int sampID, char sectionType) throws SQLException, SBException {
        Statement stmt;
        this.sectionType = sectionType;
        this.SB = SB2;
        System.out.println("In sample constructor INDIVIDUAL");
        if (sampID != 0) {
            String sql = "SELECT top_depth,base_depth,type,grid_x,grid_y,label," + Audit.sqlFieldString();
            sql = sql + " FROM " + SB2.DBTableName("SAMPLES") + " WHERE well_id=" + wellID + " AND samp_id =" + sampID;
            stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            if (rs.next()) {
                this.sampID = sampID;
                this.depth = new SampleDepth();
                BigDecimal topDepth = util.SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (SB2.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                BigDecimal baseDepth = util.SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (SB2.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                if (topDepth != null) {
                    this.depth.top = topDepth.doubleValue();
                }
                if (baseDepth != null) {
                    this.depth.base = baseDepth.doubleValue();
                }
                this.type = rs.getString("type");
                this.status = SbugsStatus.STORED;
                this.gridX = rs.getInt("grid_x");
                this.gridY = rs.getInt("grid_y");
                String strg = rs.getString("label");
                if (strg != null) {
                    this.textLabel = strg;
                }
            } else {
                throw new SBException("Sample missing for ID: " + sampID);
            }
            this.audit = new Audit(rs);
        } else {
            throw new SBException("Can't create new sample from zero sample ID");
        }
        stmt.close();
    }

    void setSectionType(char newSectionType) {
        if (this.sectionType != newSectionType) {
            if (this.depth != null) {
                if (this.depth.top != null) {
                    this.depth.top = -this.depth.top.doubleValue();
                }
                if (this.depth.base != null) {
                    this.depth.base = -this.depth.base.doubleValue();
                }
            }
            this.sectionType = newSectionType;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type == null) {
            return "";
        }
        return this.type;
    }

    Date getAgeUpdated(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ageAudit.updated;
        }
        return null;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public void update(Well well, Sample sample) throws SQLException {
        Audit temp = new Audit(this.audit);
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("samples") + " SET label='" + sample.textLabel + "'," + temp.sqlUpdate(this.SB, stmt, false) + " WHERE samp_id=" + this.sampID + " AND well_id=" + well.wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        this.textLabel = sample.textLabel;
        this.audit = temp;
    }

    void update(int wellID, Double topDepth, Double baseDepth, String type, String label) throws SQLException, SBException {
        Audit temp = new Audit(this.audit);
        this.setDepth(topDepth, baseDepth, 'M');
        this.type = type;
        this.textLabel = label;
        if (this.SB != null && this.SB.isConnected()) {
            Statement stmt = this.SB.getDatabase().createStatement();
            String sql = "UPDATE " + this.SB.DBTableName("samples") + " SET top_depth=" + this.depth.top + ",base_depth=" + this.depth.base + ",type='" + type + "',label='" + label + "'," + temp.sqlUpdate(this.SB, stmt, false) + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        this.audit = temp;
    }

    public String getLabel() {
        if (this.textLabel != null && this.textLabel.length() > 0) {
            return this.textLabel.toString();
        }
        return "";
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public double getDepth() {
        if (this.SB.useSampleTops()) {
            if (this.depth.top != null) {
                return this.depth.top;
            }
            if (this.depth.base != null) {
                return this.depth.base;
            }
        } else {
            if (this.depth.base != null) {
                return this.depth.base;
            }
            if (this.depth.top != null) {
                return this.depth.top;
            }
        }
        return 0.0;
    }

    public double getDepth(char units) {
        return util.SB.convFromM((double)this.getDepth(), (char)units);
    }

    public boolean hasDepthRange() {
        if (this.depth == null) {
            return false;
        }
        return Math.abs(this.depth.top - this.depth.base) > (double)0.0029f;
    }

    public void setDepth(double d, char units, boolean useSampleTops, boolean useSectionType) {
        this.depth = useSampleTops ? new SampleDepth(util.SB.convToM((double)d, (char)units, (char)(useSectionType ? (char)this.sectionType : (char)'W')), null) : new SampleDepth(null, util.SB.convToM((double)d, (char)units, (char)(useSectionType ? (char)this.sectionType : (char)'W')));
    }

    public boolean hasTopDepth() {
        if (this.depth == null) {
            return false;
        }
        return this.depth.top != null;
    }

    public boolean hasBaseDepth() {
        if (this.depth == null) {
            return false;
        }
        return this.depth.base != null;
    }

    public double getTopDepth(char units) throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        if (this.depth.top == null) {
            return 0.0;
        }
        return util.SB.convFromM((double)this.depth.top, (char)units, (char)this.sectionType);
    }

    public double getBaseDepth(char units) throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        if (this.depth.base == null) {
            return 0.0;
        }
        return util.SB.convFromM((double)this.depth.base, (char)units, (char)this.sectionType);
    }

    public Double getTopDepth() throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        return this.depth.top;
    }

    public Double getBaseDepth() throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        return this.depth.base;
    }

    public boolean hasDepth() {
        return this.depth != null;
    }

    public void setBaseDepth(double d, char units) throws SBException {
        if (this.depth == null) {
            this.depth = new SampleDepth(null, util.SB.convToM((double)d, (char)units, (char)this.sectionType));
        } else {
            this.depth.base = util.SB.convToM((double)d, (char)units, (char)this.sectionType);
        }
        if (this.depth.top != null) {
            if (this.sectionType == 'W') {
                if (this.depth.top > this.depth.base) {
                    throw new SBException("Top depth larger than base depth: " + util.SB.convFromM((double)this.depth.top, (char)units) + " - " + util.SB.convFromM((double)this.depth.base, (char)units));
                }
            } else if (this.depth.base > this.depth.top) {
                throw new SBException("Base depth larger than top depth: " + util.SB.convFromM((double)this.depth.top, (char)units) + " - " + util.SB.convFromM((double)this.depth.base, (char)units));
            }
        }
        if (this.depth.base > 99999.0) {
            throw new SBException("Base depth set to unreasonably high value: " + util.SB.convFromM((double)this.depth.base, (char)units));
        }
    }

    void clearDepths() {
        this.depth = null;
    }

    public void setTopDepth(double d, char units) throws SBException {
        if (this.depth == null) {
            this.depth = new SampleDepth(util.SB.convToM((double)d, (char)units, (char)this.sectionType), null);
        } else {
            this.depth.top = util.SB.convToM((double)d, (char)units, (char)this.sectionType);
        }
        if (this.depth.base != null) {
            if (this.sectionType == 'W') {
                if (this.depth.top > this.depth.base) {
                    throw new SBException("Top depth larger than base depth");
                }
            } else if (this.depth.base > this.depth.top) {
                throw new SBException("Base depth larger than top depth");
            }
        }
        if (this.depth.top > 99999.0 || this.depth.top < -99999.0) {
            throw new SBException("Top depth set to unreasonably high value");
        }
    }

    public void setDepth(Double top, Double base, char units) throws SBException {
        if (top != null && base != null && top > base) {
            throw new SBException("Top depth larger than base depth in sample: " + top + " - " + base);
        }
        if (top != null && top > 99999.0 || base != null && base > 99999.0) {
            throw new SBException("Top or base depth unreasonably high value in sample: " + top + " - " + base);
        }
        this.depth = new SampleDepth(top == null ? null : Double.valueOf(util.SB.convToM((double)top, (char)units)), base == null ? null : Double.valueOf(util.SB.convToM((double)base, (char)units)));
    }

    int compareDepth(Sample s) {
        if (this.depth != null && s.depth != null) {
            int compareBase = this.depth.compareBase(s.depth.base);
            if (compareBase == 0) {
                return this.depth.compareTop(s.depth.top);
            }
            return compareBase;
        }
        return 1;
    }

    boolean compareDepth(Double topDepth, Double baseDepth) throws SBException {
        if (this.depth == null) {
            throw new SBException("Attempt to compare null sample depth for sample: " + this);
        }
        if (topDepth == null && baseDepth == null) {
            throw new SBException("Attempt to compare top & base sample depths with sample: " + this);
        }
        return this.depth.compareBase(baseDepth) == 0 && this.depth.compareTop(topDepth) == 0;
    }

    void parseDepthTypeLabelString(String buff, char units, boolean decideUnits, boolean useSampleTops) throws SBException, NumberFormatException {
        String strg;
        StringTokenizer tok = new StringTokenizer(buff, " -");
        boolean hasTopDepth = false;
        boolean hasBaseDepth = false;
        boolean hasType = false;
        boolean hasUnits = false;
        while (tok.hasMoreTokens()) {
            strg = tok.nextToken();
            if (strg.equalsIgnoreCase("m")) {
                units = (char)77;
                hasUnits = true;
                continue;
            }
            if (!strg.equalsIgnoreCase("f") && !strg.equalsIgnoreCase("ft")) continue;
            units = (char)70;
            hasUnits = true;
        }
        if (!hasUnits && decideUnits) {
            if (buff.indexOf(109) >= 0 || buff.indexOf(77) >= 0) {
                units = (char)77;
            }
            if (buff.indexOf(102) >= 0 || buff.indexOf(70) >= 0) {
                units = (char)70;
            }
            if (buff.indexOf(39) >= 0) {
                units = (char)70;
            }
        }
        tok = new StringTokenizer(buff, " -");
        while (tok.hasMoreTokens()) {
            strg = tok.nextToken();
            if (hasUnits && (strg.equalsIgnoreCase("m") || strg.equalsIgnoreCase("f") || strg.equalsIgnoreCase("ft"))) {
                hasUnits = false;
                continue;
            }
            if (Character.isDigit(strg.charAt(0))) {
                if (!hasTopDepth) {
                    this.setDepth(Double.parseDouble(this.stripUnitsFromDepth(strg)), units, useSampleTops, true);
                    hasTopDepth = true;
                    continue;
                }
                if (!hasBaseDepth) {
                    this.setBaseDepth(Double.parseDouble(this.stripUnitsFromDepth(strg)), units);
                    hasBaseDepth = true;
                    continue;
                }
                if (strg != null && !strg.toUpperCase().trim().equals("SAMPLE")) {
                    this.textLabel = this.textLabel + strg;
                }
                if (!hasTopDepth) continue;
                hasBaseDepth = true;
                continue;
            }
            if (hasTopDepth) {
                hasBaseDepth = true;
            }
            if (!hasType) {
                hasType = this.parseType(strg);
                if (hasType) continue;
                this.textLabel = this.textLabel + strg;
                continue;
            }
            if (strg == null || strg.toUpperCase().trim().equals("SAMPLE")) continue;
            this.textLabel = this.textLabel + strg;
        }
    }

    boolean parseType(String buff) {
        boolean parsed = false;
        String[] types = new String[]{"CU", "DC", "WDC", "DDC", "SC", "SWC", "MSCT", "CO", "CORE", "CC", "OC", "CUTTING", "SW"};
        String[] sbTypes = new String[]{"CU", "CU", "CU", "CU", "SC", "SC", "SC", "CO", "CO", "CO", "OC", "CU", "SC"};
        for (int i = 0; i < types.length; ++i) {
            if (!buff.equalsIgnoreCase(types[i])) continue;
            this.type = sbTypes[i];
            parsed = true;
            break;
        }
        if (buff.startsWith("SWC")) {
            this.type = "SC";
            this.textLabel = this.textLabel + buff.substring(3);
            parsed = true;
        } else if (buff.startsWith("SC")) {
            this.type = "SC";
            this.textLabel = this.textLabel + buff.substring(2);
            parsed = true;
        }
        if (!parsed) {
            this.donorSampleType = buff;
        }
        return parsed;
    }

    public String getDonorSampleType() {
        return this.donorSampleType;
    }

    void parseDepthString(String buff, char units, boolean decideUnits, boolean useSampleTops) throws SBException, NumberFormatException {
        StringTokenizer tok;
        if (decideUnits) {
            if ((buff = buff.trim()).indexOf(109) >= 0 || buff.indexOf(77) >= 0) {
                units = (char)77;
            }
            if (buff.indexOf(102) >= 0 || buff.indexOf(70) >= 0) {
                units = (char)70;
            }
            if (buff.indexOf(39) >= 0) {
                units = (char)70;
            }
        }
        if ((tok = new StringTokenizer(buff, " -")).countTokens() == 1) {
            String depthString = tok.nextToken();
            if (useSampleTops) {
                this.setDepth(new Double(this.stripUnitsFromDepth(depthString)), null, units);
            } else {
                this.setDepth(null, new Double(this.stripUnitsFromDepth(depthString)), units);
            }
        } else {
            String topDepthString = tok.nextToken();
            String baseDepthString = tok.nextToken();
            try {
                this.setDepth(new Double(this.stripUnitsFromDepth(topDepthString)), new Double(this.stripUnitsFromDepth(baseDepthString)), units);
            }
            catch (NumberFormatException ex) {
                this.setDepth(Float.parseFloat(topDepthString), units, useSampleTops, true);
            }
        }
    }

    public String stripUnitsFromDepth(String buff) {
        buff = buff.trim();
        if ((buff = buff.toLowerCase()).indexOf(109) > 0) {
            buff = buff.substring(0, buff.indexOf(109));
        }
        if (buff.indexOf(102) > 0) {
            buff = buff.substring(0, buff.indexOf(102));
        }
        if (buff.indexOf(39) > 0) {
            buff = buff.substring(0, buff.indexOf(39));
        }
        for (int i = 0; i < buff.length(); ++i) {
            if (!Character.isDigit(buff.charAt(i)) && buff.charAt(i) != '.' && buff.charAt(i) != ',') {
                System.out.println("Warning: truncating string: " + buff);
                buff = buff.substring(0, i);
                continue;
            }
            if (buff.charAt(i) != ',') continue;
            buff = buff.length() > i + 1 ? buff.substring(0, i) + buff.substring(i + 1) : buff.substring(0, i);
        }
        return buff;
    }

    public int compareTo(Sample other) {
        String se = this.getSortEntry();
        String seOther = other.getSortEntry();
        int comp = this.getSortEntry().compareTo(other.getSortEntry());
        if (comp != 0) {
            return comp;
        }
        comp = this.compareDepth(other);
        if (comp != 0) {
            return comp;
        }
        return 0;
    }

    public void setType(String type) throws SBException {
        for (int i = 0; i < SBSampleTypes.length; ++i) {
            if (!type.equalsIgnoreCase(SBSampleTypes[i])) continue;
            this.type = SBSampleTypes[i];
            return;
        }
        if (this.type.length() == 0) {
            throw new SBException("Can't parse sample type: " + type);
        }
    }

    public static String[] getSampleTypes() {
        return SBSampleTypes;
    }

    void setLabel(String label) {
        if (label != null) {
            this.textLabel = label;
        }
    }

    void loadLithology(int wellID, Lithdesc lithdesc) throws SQLException, SBException {
        if (this.sampID > 0) {
            this.sampleLithology.getLithology().clear();
            String sql = "SELECT lith_id,percnt FROM " + this.SB.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                int lithID = rs.getInt("lith_id");
                SampleLithologyUnit lith = new SampleLithologyUnit(this.SB, this.SB.getLithdesc().getLithology(lithID), rs.getInt("percnt"));
                this.sampleLithology.add(lith);
            }
            stmt.close();
        }
    }

    public Color getDbStatus() {
        return null;
    }

    public String dbStatusString() {
        return null;
    }

    public Color getStatus() {
        if (this.status == UNKNOWN) {
            this.status = this.sampID != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    void loadAges(int wellID, int interpID) throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        if (this.hasImportedAgeData) {
            return;
        }
        this.ages.remove(interpID);
        SampleAge age = new SampleAge(this.SB, wellID, interpID);
        if (age.hasData) {
            this.ages.put(interpID, age);
        }
    }

    void loadDetails(int wellID) throws SQLException, SBException {
        if (this.sampID == 0) {
            return;
        }
        String sql = "SELECT analy_id,picker,source,barren,notes,proximal,distal,fov,weight,coarse,medium,fine," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("SMPDTL") + " WHERE samp_id=" + this.sampID + " and well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        Object strg = null;
        while (rs.next()) {
            int analyID = rs.getInt("analy_id");
            String picker = rs.getString("picker");
            String source = rs.getString("source");
            Smpdtl.AnalysisType analysisType = Smpdtl.AnalysisType.getTypeFromDB(rs.getString("barren"));
            String notes = rs.getString("notes");
            int proximal = 0;
            int distal = 0;
            proximal = rs.getInt("proximal");
            distal = rs.getInt("distal");
            int fov = rs.getInt("fov");
            float weight = 0.0f;
            float coarse = 0.0f;
            float medium = 0.0f;
            float fine = 0.0f;
            weight = rs.getFloat("weight");
            coarse = rs.getFloat("coarse");
            medium = rs.getFloat("medium");
            fine = rs.getFloat("fine");
            Well well = this.SB.getAddWell(wellID);
            Smpdtl dtl = new Smpdtl(this.SB, this, well.getAnalystHeader(analyID, true), picker, source, notes, proximal, distal, fov, weight, coarse, medium, fine, new Audit(rs), analysisType);
            dtl.load(wellID);
            dtl.status = STORED;
            Iterator<Smpdtl> it = this.analyses.iterator();
            boolean toAdd = true;
            while (it.hasNext()) {
                Smpdtl analysis = it.next();
                if (analysis.getDiscID() != dtl.getDiscID() || !analysis.getAnalyst().equals(dtl.getAnalyst()) || analysis.getAnalyNo() != dtl.getAnalyNo()) continue;
                String message = "Duplicate analyst for discID: " + analysis.getDiscID() + ", analyst:" + analysis.getAnalyst() + ", sample ID: " + this.sampID;
                if (dtl.getOccSize() > 0 && analysis.getOccSize() == 0) {
                    System.out.println(message + ", sample details: " + analysis + " removed.");
                    it.remove();
                    break;
                }
                if (dtl.getOccSize() == analysis.getOccSize()) {
                    System.out.println(message + ", sample details: " + dtl + " ignored.");
                    toAdd = false;
                    continue;
                }
                throw new SBException(message + ", analyses have different occurrence records");
            }
            if (!toAdd) continue;
            this.analyses.add(dtl);
        }
        rs.close();
        stmt.close();
    }

    void fillTaxa(List taxa, char discID, int analyst, int analyNo) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (discID != '\u0000' && discID != smpdtl.getDiscID() || analyst != 0 && smpdtl.getHeader().getAnalystUsrid() != analyst || analyNo != 0 && smpdtl.getHeader().getAnalyNumber() != analyNo) continue;
            smpdtl.fillTaxonList(taxa);
        }
    }

    public boolean hasDisciplineData(char discID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID) continue;
            return true;
        }
        return false;
    }

    String hasSemiQuantData(AnalystHeader hdr, String semiQuant) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (hdr != null && smpdtl.getHeader() != hdr) continue;
            semiQuant = smpdtl.hasSemiQuantData(semiQuant);
        }
        return semiQuant;
    }

    void delete(int wellID) throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SBSSR") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("FAULTS") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "SELECT image_set_id FROM " + this.SB.DBTableName("TAXONOCC") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        LinkedList<Integer> imgIDs = new LinkedList<Integer>();
        while (rs.next()) {
            imgIDs.add(rs.getInt("image_set_id"));
        }
        sql = "DELETE FROM " + this.SB.DBTableName("TAXONOCC") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        for (Integer i : imgIDs) {
            ImageSet.deleteWithTypeCheck(this.SB, i, wellID);
        }
        sql = "DELETE FROM " + this.SB.DBTableName("SMPDTL") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SAMPLES") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.sampID = 0;
    }

    public String getIGDOccurrences(int wellID) throws SQLException {
        int n;
        Statement stmt = this.SB.getDatabase().createStatement();
        String strg = "";
        String table = this.SB.DBTableName("IGD");
        String sql = "SELECT count(d1.top_id) AS n FROM " + table + " d1 WHERE (d1.top_id=" + this.sampID + " OR d1.base_id=" + this.sampID + ") AND d1.well_id=" + wellID;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (n = rs.getInt("n")) > 0) {
            strg = strg + "" + n + " Intervals, ";
        }
        table = this.SB.DBTableName("IGD_ENV");
        sql = "SELECT count(d1.top_id) AS n FROM " + table + " d1 WHERE (d1.top_id=" + this.sampID + " OR d1.base_id=" + this.sampID + ") AND d1.well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (n = rs.getInt("n")) > 0) {
            strg = strg + "" + n + " Envs, ";
        }
        table = this.SB.DBTableName("BCMMNTS");
        sql = "SELECT count(d1.usamp_id) AS n FROM " + table + " d1 WHERE (d1.usamp_id=" + this.sampID + " OR d1.lsamp_id=" + this.sampID + ") " + " AND d1.well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (n = rs.getInt("n")) > 0) {
            strg = strg + "" + n + " Comments, ";
        }
        table = this.SB.DBTableName("EVENTS");
        sql = "SELECT count(d1.samp_id) AS n FROM " + table + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (n = rs.getInt("n")) > 0) {
            strg = strg + "" + n + " Events, ";
        }
        table = this.SB.DBTableName("FAULTS");
        sql = "SELECT count(d1.samp_id) AS n FROM " + table + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (n = rs.getInt("n")) > 0) {
            strg = strg + "" + n + " Faults, ";
        }
        table = this.SB.DBTableName("SBSLITH");
        sql = "SELECT count(d1.samp_id) AS n FROM " + table + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (n = rs.getInt("n")) > 0) {
            strg = strg + "" + n + " Liths, ";
        }
        table = this.SB.DBTableName("SBSSR");
        sql = "SELECT count(d1.samp_id) AS n FROM " + table + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (n = rs.getInt("n")) > 0) {
            strg = strg + "" + n + " Age, ";
        }
        table = this.SB.DBTableName("SQPICK");
        sql = "SELECT count(d1.samp_id) AS n FROM " + table + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (n = rs.getInt("n")) > 0) {
            strg = strg + "" + n + " Pick";
        }
        if ((strg = strg.trim()).endsWith(",")) {
            strg = strg.substring(0, strg.length() - 2);
        }
        stmt.close();
        return strg;
    }

    void replace(int wellID, int newSampID) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("SBSLITH") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("SBSSR") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("TAXONOCC") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("SMPDTL") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("EVENTS") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD") + " SET top_id=" + newSampID + " WHERE top_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD_ENV") + " SET top_id=" + newSampID + " WHERE top_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD") + " SET base_id=" + newSampID + " WHERE base_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD_ENV") + " SET base_id=" + newSampID + " WHERE base_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("BCMMNTS") + " SET usamp_id=" + newSampID + " WHERE usamp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("BCMMNTS") + " SET lsamp_id=" + newSampID + " WHERE lsamp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SAMPLES") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.sampID = 0;
    }

    int hasIGDdataInDB(int wellID) throws SQLException, SBException {
        String sql;
        if (this.sampID == 0) {
            return 0;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql = "SELECT igd_type FROM " + this.SB.DBTableName("IGD") + " WHERE top_id=" + this.sampID + " AND well_id=" + wellID));
        if (rs.next()) {
            return IGDIntervalZone.igdType2dType(rs.getInt("igd_type"));
        }
        sql = "SELECT top_id FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE top_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return 15;
        }
        sql = "SELECT igd_type FROM " + this.SB.DBTableName("IGD") + " WHERE base_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return IGDIntervalZone.igdType2dType(rs.getInt("igd_type"));
        }
        sql = "SELECT base_id FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE base_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return 15;
        }
        sql = "SELECT samp_id FROM " + this.SB.DBTableName("SQPICK") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return 14;
        }
        sql = "SELECT samp_id FROM " + this.SB.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return 21;
        }
        sql = "SELECT disc_id FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE usamp_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return SBdb.did2comType(util.SB.getDBChar((ResultSet)rs, (String)"disc_id"));
        }
        sql = "SELECT disc_id FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE lsamp_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return SBdb.did2comType(util.SB.getDBChar((ResultSet)rs, (String)"disc_id"));
        }
        sql = "SELECT samp_id FROM " + this.SB.DBTableName("EVENTS") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return 16;
        }
        sql = "SELECT samp_id FROM " + this.SB.DBTableName("SBSSR") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return 1;
        }
        stmt.close();
        return 0;
    }

    public Smpdtl getAnySmpdtl(char discID, String analyst) throws SQLException, SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || analyst.length() != 0 && !smpdtl.getAnalyst().equals(analyst)) continue;
            return smpdtl;
        }
        return null;
    }

    public Smpdtl getSmpdtl(char discID, String analyst, int suiteNo) throws SQLException, SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || analyst.length() != 0 && !smpdtl.getAnalyst().equals(analyst) || smpdtl.getAnalyNo() != suiteNo) continue;
            return smpdtl;
        }
        return null;
    }

    public List getAnalysts(int wellID, char discID) throws SQLException, SBException {
        LinkedList<String> analysts = new LinkedList<String>();
        if (this.sampID > 0) {
            String sql = "SELECT distinct analyst FROM " + this.SB.DBTableName("SMPDTL") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            if (discID > '\u0000') {
                sql = sql + " AND disc_id='" + discID + "'";
            }
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                analysts.add(rs.getString("analyst"));
            }
            stmt.close();
        }
        for (Smpdtl dtl : this.analyses) {
            if (discID != '\u0000' && discID != dtl.getDiscID() || analysts.contains(dtl.getAnalyst())) continue;
            analysts.add(dtl.getAnalyst());
        }
        return analysts;
    }

    Smpdtl getSmpdtl(int analyID) throws SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getAnalyID() != analyID) continue;
            return smpdtl;
        }
        return null;
    }

    void removeSmpdtl(char discID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID) continue;
            this.analyses.remove(i);
            break;
        }
    }

    void removeSmpdtl(char discID, String analyst) throws SQLException, SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.getAnalyst().equals(analyst)) continue;
            this.analyses.remove(i);
            break;
        }
    }

    Color updateStatus(int wellID) throws SQLException, SBException {
        if (this.sampID == 0) {
            Statement stmt;
            ResultSet rs;
            String sql = "SELECT samp_id,grid_x,grid_y,label," + Audit.sqlFieldString();
            sql = sql + " FROM " + this.SB.DBTableName("SAMPLES") + " WHERE well_id =" + wellID;
            sql = sql + " AND base_depth >" + Double.toString(this.depth.base - (double)0.0029f) + " AND base_depth < " + Double.toString(this.depth.base + (double)0.0029f) + " AND type='" + this.type + "'";
            if (this.hasDepthRange()) {
                sql = sql + " AND depth >" + Double.toString(this.depth.top - (double)0.0029f) + " AND depth < " + Double.toString(this.depth.top + (double)0.0029f);
            }
            if ((rs = (stmt = this.SB.getDatabase().createStatement()).executeQuery(this.SB.modQuery(sql))).next()) {
                this.sampID = rs.getInt("samp_id");
                this.status = STORED;
                MergeStatus m = new MergeStatus(this.status);
                this.gridX = m.compareDoubleField("grid x", this.gridX, rs.getDouble("grid_x"));
                this.gridY = m.compareDoubleField("grid y", this.gridY, rs.getDouble("grid_y"));
                m.compareStringField("Label", this.textLabel, rs.getString("label"), true);
                this.status = m.getStatus();
                if (this.status != CONFLICT) {
                    this.audit = new Audit(rs);
                }
            }
            stmt.close();
            throw new SBException("Attempt to update sample status");
        }
        if (this.sampID != 0) {
            for (int i = 0; i < this.analyses.size(); ++i) {
                Smpdtl smpdtl = this.analyses.get(i);
                smpdtl.updateStatus(wellID, this.sampID);
            }
        } else {
            this.status = NOTSTORED;
        }
        return this.status;
    }

    void updateLithologyStatus(List<Sample> list) {
        for (Sample sample : list) {
            if (this.compareTo(sample) <= 0) continue;
            this.getLithology().getStatus(sample.getLithology());
        }
    }

    Color updateStatus(Sample sample) throws SQLException, SBException {
        MergeStatus m = new MergeStatus(this.status);
        this.gridX = m.compareDoubleField("grid x", this.gridX, sample.gridX);
        this.gridY = m.compareDoubleField("grid y", this.gridY, sample.gridY);
        m.compareStringField("Label", this.textLabel, sample.textLabel, true);
        this.status = m.getStatus();
        return this.status;
    }

    boolean hasSpecies(char discID, int specID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.hasSpecies(specID)) continue;
            return true;
        }
        return false;
    }

    boolean hasInSituSpecies(char discID, int specID, char flag) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.hasInSituSpecies(specID, flag)) continue;
            return true;
        }
        return false;
    }

    void writeSbugs(FileWriter out, char discID) throws IOException, SQLException, SBException {
        String blanks = "                        ";
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID) continue;
            out.write("S ");
            if (Math.abs(this.depth.top) > (double)0.0029f) {
                out.write(this.padDouble(9, 3, this.depth.top));
            } else {
                out.write(this.padDouble(9, 3, this.depth.base));
            }
            out.write(blanks.substring(0, 6 - this.type.length()) + this.type + '\t');
            out.write(this.padInt(6, (int)this.gridX) + '\t');
            out.write(this.padInt(6, (int)this.gridY) + '\t');
            if (Math.abs(this.depth.top) > (double)0.0029f && Math.abs(this.depth.top - this.depth.base) > (double)0.0029f) {
                out.write(this.padDouble(9, 3, this.depth.base));
            }
            out.write(10);
            smpdtl.writeSbugs(out);
        }
    }

    public String padFloat(int width, int precision, float number) {
        String result = String.valueOf(number);
        if (result.length() - result.indexOf(46) > precision) {
            result = result.substring(0, result.indexOf(46) + precision);
        }
        while (result.length() < width) {
            result = " " + result;
        }
        return result;
    }

    public String padDouble(int width, int precision, double number) {
        String result = String.valueOf(number);
        if (result.length() - result.indexOf(46) > precision) {
            result = result.substring(0, result.indexOf(46) + precision);
        }
        while (result.length() < width) {
            result = " " + result;
        }
        return result;
    }

    public String padInt(int width, int value) {
        String result = String.valueOf(value);
        while (result.length() < width) {
            result = " " + result;
        }
        return result;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.toString(this.displayUnits);
    }

    public String toString(char units) {
        return this.toString(units, true, true);
    }

    public String toString(char units, boolean showUnits, boolean showLabel) {
        return this.toString(units, showUnits, showLabel, true, true, null, null);
    }

    public String toString(char units, boolean showUnits, boolean showLabel, boolean pad) {
        String string = this.toString(units, showUnits, showLabel, true, true, null, null);
        if (pad) {
            int dotIndex = string.indexOf(46);
            int spIndex = string.indexOf(32);
            int index = 0;
            for (index = dotIndex > 0 && spIndex > 0 ? Math.min(dotIndex, spIndex) : (dotIndex > 0 ? dotIndex : spIndex); index > 0 && index < 5; ++index) {
                string = " " + string;
            }
        }
        return string;
    }

    public String toString(char units, boolean showUnits, boolean showLabel, boolean showType, boolean showRange, Double correctedDepthTop, Double correctedDepthBase) {
        double displayTop;
        if (correctedDepthTop != null) {
            displayTop = util.SB.convFromM((double)correctedDepthTop, (char)units, (char)this.sectionType);
        } else {
            double d = displayTop = this.depth.top != null ? util.SB.convFromM((double)this.depth.top, (char)units, (char)this.sectionType) : 0.0;
        }
        double displayBase = correctedDepthBase != null ? util.SB.convFromM((double)correctedDepthBase, (char)units, (char)this.sectionType) : (this.depth.base != null ? util.SB.convFromM((double)this.depth.base, (char)units, (char)this.sectionType) : 0.0);
        int dp = 0;
        if (this.type.equals("LOG") && logDp == 3) {
            displayTop = (double)Math.round(displayTop * 1000.0) / 1000.0;
            displayBase = (double)Math.round(displayBase * 1000.0) / 1000.0;
            dp = 3;
        } else if (this.type.equals("CO") || this.type.equals("OC") || this.type.equals("LOG") && logDp == 2) {
            displayTop = (double)Math.round(displayTop * 100.0) / 100.0;
            displayBase = (double)Math.round(displayBase * 100.0) / 100.0;
            dp = 2;
        } else if (this.type.equals("SC") || this.type.equals("LOG") && logDp == 1) {
            displayTop = (double)Math.round(displayTop * 10.0) / 10.0;
            displayBase = (double)Math.round(displayBase * 10.0) / 10.0;
            dp = 1;
        } else {
            displayTop = Math.round(displayTop);
            displayBase = Math.round(displayBase);
            dp = 0;
        }
        String s = new String();
        if (Math.abs(displayTop - displayBase) > (double)0.0029f && showRange) {
            if (this.depth.top != null) {
                s = util.SB.floatString((double)displayTop, (int)dp);
                if (this.depth.base != null) {
                    s = s + " - ";
                }
            }
            if (this.depth.base != null) {
                s = s + util.SB.floatString((double)displayBase, (int)dp).trim();
            }
        } else {
            s = this.depth.base != null ? s + util.SB.floatString((double)displayBase, (int)dp) : s + util.SB.floatString((double)displayTop, (int)dp);
        }
        if (showUnits) {
            s = units == 'F' ? s + '\'' : s + 'm';
        }
        if (showType) {
            if (this.SB.hideCommonSampleTypes) {
                if (!this.type.equals("CU") && !this.type.equals("OC")) {
                    s = s + ' ' + this.type;
                }
            } else {
                s = s + ' ' + this.type;
            }
        }
        if (showLabel && this.textLabel != null && this.textLabel.length() > 0) {
            s = s + ' ';
            s = s + this.textLabel;
        }
        return s;
    }

    public Smpdtl addDtl(int wellID, AnalystHeader hdr, Smpdtl.AnalysisType analysisType, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal, int fov) throws SBException, SQLException {
        for (Smpdtl o : this.analyses) {
            Smpdtl d = o;
            if (d.getAnalyID() != hdr.getAnalyID()) continue;
            throw new SBException("Duplicate analyst ID: " + hdr.getAnalyID() + " for sample: " + this.toString(this.SB.getProject(0).getWell(this.SB, wellID).getWellUnits()));
        }
        Smpdtl smpdtl = new Smpdtl(this.SB, this, hdr, picker, source, notes, analysisType, proximal, distal, fov, weight, coarse, medium, fine, wellID);
        this.insert(smpdtl);
        this.setChanged();
        return smpdtl;
    }

    public void addDtl(Smpdtl smpdtl) throws SBException {
        AnalystHeader hdr = smpdtl.getHeader();
        for (Smpdtl o : this.analyses) {
            Smpdtl d = o;
            if (d.getAnalyID() != hdr.getAnalyID()) continue;
            throw new SBException("Duplicate analyst ID: " + hdr.getAnalyID() + " for sample: " + this.toString());
        }
        this.insert(smpdtl);
        this.setChanged();
    }

    public void deleteDtl(int wellID, int analyID, Smpdtl smpdtl) throws SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            Smpdtl.delete(this.SB, wellID, this.sampID, analyID);
        }
        this.analyses.remove(smpdtl);
        this.setChanged();
    }

    void removeDtl(int analyID) {
        Iterator<Smpdtl> it = this.analyses.iterator();
        while (it.hasNext()) {
            Smpdtl dtl = it.next();
            if (analyID != dtl.getAnalyID()) continue;
            it.remove();
            this.setChanged();
            break;
        }
    }

    public Smpdtl getAnalysis(int analyID) {
        for (Smpdtl dtl : this.analyses) {
            if (dtl.getHeader().getAnalyID() != analyID) continue;
            return dtl;
        }
        return null;
    }

    public void updateDtl(int wellID, Smpdtl smpdtl, AnalystHeader hdr, Smpdtl.AnalysisType analysisType, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal, int fov) throws SBException, SQLException {
        for (Smpdtl o : this.analyses) {
            Smpdtl d = o;
            if (d == smpdtl || d.getAnalyID() != hdr.getAnalyID()) continue;
            throw new SBException("Duplicate analyst & discipline for sample: " + this.toString());
        }
        if (hdr != smpdtl.getHeader()) {
            this.setChanged();
        }
        smpdtl.update(wellID, hdr, analysisType, picker, source, notes, weight, coarse, medium, fine, proximal, distal, fov);
    }

    void insert(Smpdtl smpdtl) throws SBException {
        this.checkDtl(smpdtl);
        this.analyses.add(smpdtl);
    }

    void checkDtl(Smpdtl smpdtl) throws SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl dtl = this.analyses.get(i);
            if (dtl.getAnalyID() != smpdtl.getAnalyID()) continue;
            throw new SBException("Duplicate analyst,discipline & no for sample: " + this.toString());
        }
    }

    int store(Statement stmt, int wellID, int serialNumber) throws SQLException, SBException {
        String sql = null;
        if (this.type == null || this.type.length() == 0) {
            throw new SBException("Cannot save sample with null sample type: " + this.toString());
        }
        if (this.depth == null) {
            throw new SBException("Cannot save sample with null depth");
        }
        if (this.depth.top == null && this.depth.base == null) {
            throw new SBException("Cannot save sample with null top and base depth");
        }
        Audit tempAudit = new Audit(this.audit);
        if (this.sampID == 0 || this.status == NOTSTORED) {
            if (this.sampID == 0) {
                this.sampID = ++serialNumber;
            }
            sql = "INSERT INTO " + this.SB.DBTableName("SAMPLES") + " (well_id,samp_id,type," + Audit.sqlFieldString();
            if (this.depth.top != null) {
                sql = sql + ",top_depth";
            }
            if (this.depth.base != null) {
                sql = sql + ",base_depth";
            }
            if (this.textLabel != null && this.textLabel.length() > 0) {
                sql = sql + ",label";
            }
            if (this.gridX > 0.0) {
                sql = sql + ",grid_x";
            }
            if (this.gridY > 0.0) {
                sql = sql + ",grid_y";
            }
            sql = sql + ") VALUES (";
            sql = sql + wellID + "," + this.sampID + ",'" + this.type + "'," + tempAudit.sqlInsert(this.SB, stmt);
            if (this.depth.top != null) {
                sql = sql + "," + this.depth.top;
            }
            if (this.depth.base != null) {
                sql = sql + "," + this.depth.base;
            }
            if (this.textLabel != null && this.textLabel.length() > 0) {
                sql = sql + ",'" + this.textLabel.toString() + "'";
            }
            if (this.gridX > 0.0) {
                sql = sql + "," + this.gridX;
            }
            if (this.gridY > 0.0) {
                sql = sql + "," + this.gridY;
            }
            sql = sql + ")";
        } else if (this.status == PARTSTORED) {
            sql = "UPDATE " + this.SB.DBTableName("SAMPLES") + " SET ";
            sql = sql + "top_depth=" + (this.depth.top != null ? this.depth.top : "NULL") + ",";
            sql = sql + "base_depth=" + (this.depth.base != null ? this.depth.base : "NULL") + ",type='" + this.type + "'," + tempAudit.sqlUpdate(this.SB, stmt, SBdb.preserveAudit);
            if (this.textLabel.length() > 0) {
                sql = sql + ",label='" + this.textLabel.toString() + "'";
            }
            if (this.gridX > 0.0) {
                sql = sql + ",grid_x=" + this.gridX;
            }
            if (this.gridY > 0.0) {
                sql = sql + ",grid_y=" + this.gridY;
            }
            sql = sql + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
        }
        if (stmt == null) {
            stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
        } else {
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        this.audit = tempAudit;
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            smpdtl.store(stmt, wellID, this.sampID, smpdtl.getAnalyID());
        }
        if (this.sampleLithology != null && !this.sampleLithology.getLithology().isEmpty()) {
            this.sampleLithology.store(wellID, this.sampID, this.SB);
        }
        this.storeAge(wellID, 0);
        this.status = STORED;
        return serialNumber;
    }

    public void updateLithology(List<SampleLithologyUnit> liths, int wellID) throws SQLException, SBException {
        this.sampleLithology.updateLithology(liths, wellID, this.sampID, this.SB);
        this.setChanged();
    }

    public void storeAge(int wellID, int interpID) throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            age.store(this.SB, wellID, interpID);
        }
        this.hasImportedAgeData = false;
    }

    void parseXML(String chars, String element, char units) throws ParseException, SBException, SQLException {
        if (element.compareTo("Label") == 0) {
            this.textLabel = this.textLabel + chars;
        } else if (element.compareTo("TopDepth") == 0) {
            try {
                this.setTopDepth(Float.parseFloat(chars), units);
                this.displayUnits = units;
            }
            catch (SBException se) {
                throw new ParseException("Error trying to parse: " + chars + " : " + se.getMessage(), 0);
            }
        } else if (element.compareTo("BaseDepth") == 0) {
            try {
                this.setBaseDepth(Float.parseFloat(chars), units);
                this.displayUnits = units;
            }
            catch (SBException se) {
                throw new ParseException("Error trying to parse: " + chars + " : " + se.getMessage(), 0);
            }
        } else if (element.compareTo("Type") == 0) {
            this.type = chars;
        } else if (element.compareTo("Created") == 0) {
            this.audit.created = util.SB.DBdf.parse(chars);
        } else if (element.compareTo("Creator") == 0) {
            System.out.println("Parsing as userID for sample: " + this + " : " + chars);
            this.audit.creator = this.SB.getUser(chars).getUsrID();
        } else if (element.compareTo("Modified") == 0) {
            this.audit.modified = util.SB.DBdf.parse(chars);
        } else if (element.compareTo("Modifier") == 0) {
            this.audit.modifier = this.SB.getUser(chars).getUsrID();
        } else if (element.compareTo("GridX") == 0) {
            this.gridX = Integer.parseInt(chars);
        } else if (element.compareTo("GridY") == 0) {
            this.gridY = Integer.parseInt(chars);
        } else if (element.compareTo("Age") == 0) {
            SampleAge age = this.getDefaultSampleAge();
            age.age = Double.parseDouble(chars);
        } else if (element.compareTo("AgeBelowUnconformity") == 0) {
            SampleAge age = this.getDefaultSampleAge();
            age.ageBelow = Double.parseDouble(chars);
        } else if (element.compareTo("AgeErrorPlus") == 0) {
            SampleAge age = this.getDefaultSampleAge();
            age.ageErrorPlus = Float.valueOf(Float.parseFloat(chars));
        } else if (element.compareTo("AgeErrorMinus") == 0) {
            SampleAge age = this.getDefaultSampleAge();
            age.ageErrorMinus = Float.valueOf(Float.parseFloat(chars));
        } else if (element.compareTo("Ratio") == 0) {
            SampleAge age = this.getDefaultSampleAge();
            age.ratio = Double.parseDouble(chars);
        }
    }

    LinkedList<Integer> writeXMLAges(BufferedWriter out, int indent, int interpID) throws IOException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        SampleAge age = this.ages.get(interpID);
        if (age == null) {
            return userIDs;
        }
        out.write(ind + "<SampleID>" + this.sampID + "</SampleID>\n");
        out.write(ind + "<Age>" + age.age + "</Age>\n");
        if (Math.abs(age.ageBelow) > 1.0E-6) {
            out.write(ind + "<AgeBelowUnconformity>" + age.ageBelow + "</AgeBelowUnconformity>\n");
        }
        if ((double)Math.abs(age.ageErrorPlus.floatValue()) > 1.0E-4) {
            out.write(ind + "<AgeErrorPlus>" + age.ageErrorPlus + "</AgeErrorPlus>\n");
        }
        if ((double)Math.abs(age.ageErrorMinus.floatValue()) > 1.0E-4) {
            out.write(ind + "<AgeErrorMinus>" + age.ageErrorMinus + "</AgeErrorMinus>\n");
        }
        if (Math.abs(age.ratio) > 1.0E-4) {
            out.write(ind + "<Ratio>" + age.ratio + "</Ratio>\n");
        }
        if (this.ages.get(0) != null) {
            out.write(ind + "<AgeAudit>\n");
            out.write(ind);
            userIDs.addAll(age.ageAudit.writeXML(out, indent + 3));
            out.write(ind + "</AgeAudit>\n");
        }
        return userIDs;
    }

    LinkedList<Integer> writeXML(BufferedWriter out, int indent, char units, List<File> files) throws IOException, SQLException, SBException {
        LinkedList<Integer> userIDs = new LinkedList();
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        if (this.sampID > 0) {
            out.write(ind + "<SampleID>" + this.sampID + "</SampleID>\n");
        }
        if (this.depth != null) {
            if (!(this.depth.top != null && this.depth.base != null || this.type.equals("CU"))) {
                out.write(ind + "<Depth>" + util.SB.convFromM((double)this.getDepth(), (char)units) + "</Depth>\n");
            } else {
                if (this.depth.top != null) {
                    out.write(ind + "<TopDepth>" + util.SB.convFromM((double)this.depth.top, (char)units) + "</TopDepth>\n");
                }
                if (this.depth.base != null) {
                    out.write(ind + "<BaseDepth>" + util.SB.convFromM((double)this.depth.base, (char)units) + "</BaseDepth>\n");
                }
            }
        }
        out.write(ind + "<Type>" + this.type + "</Type>\n");
        if (this.gridX != 0.0) {
            out.write(ind + "<GridX>" + this.gridX + "</GridX>\n");
        }
        if (this.gridY != 0.0) {
            out.write(ind + "<GridY>" + this.gridY + "</GridY>\n");
        }
        if (this.textLabel != null && this.textLabel.length() > 0) {
            out.write(ind + "<Label>" + util.SB.getXMLstring((String)this.textLabel.toString()) + "</Label>\n");
        }
        if (this.audit != null) {
            userIDs = this.audit.writeXML(out, indent);
        }
        for (int i = 0; i < this.sampleLithology.getLithology().size(); ++i) {
            out.write(ind + "<Lithology>\n");
            SampleLithologyUnit lith = this.sampleLithology.getLithology().get(i);
            lith.writeXML(out, indent + 3);
            out.write(ind + "</Lithology>\n");
        }
        for (int i = 0; i < this.analyses.size(); ++i) {
            out.write(ind + "<Analysis>\n");
            Smpdtl smpdtl = this.analyses.get(i);
            userIDs.addAll(smpdtl.writeXML(out, indent + 3, files));
            out.write(ind + "</Analysis>\n");
        }
        return userIDs;
    }

    Sample(SBdb db, Well well, char sectionType, Element xml, List<Integer> dataTypes, ZipFile zip) throws ParseException, SBException, SQLException {
        this.SB = db;
        this.sectionType = sectionType;
        String strg = xml.getChildTextNormalize("SampleID");
        if (strg != null) {
            this.sampID = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("TopDepth")) != null) {
            if (this.depth == null) {
                this.depth = new SampleDepth();
            }
            this.depth.top = util.SB.convToM((double)new Double(strg), (char)well.getWellUnits());
        }
        if ((strg = xml.getChildTextNormalize("BaseDepth")) != null) {
            if (this.depth == null) {
                this.depth = new SampleDepth();
            }
            this.depth.base = util.SB.convToM((double)new Double(strg), (char)well.getWellUnits());
        }
        if ((strg = xml.getChildTextNormalize("Depth")) != null) {
            this.setDepth(new Double(strg), well.getWellUnits(), db.useSampleTops(), false);
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            this.type = strg;
        }
        if ((strg = xml.getChildText("Label")) != null) {
            this.textLabel = strg;
            this.textLabel.trim();
        }
        if ((strg = xml.getChildTextNormalize("GridX")) != null) {
            this.gridX = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("GridY")) != null) {
            this.gridY = Double.parseDouble(strg);
        }
        Iterator it = xml.getDescendants((Filter)new ElementFilter("Analysis"));
        while (it.hasNext()) {
            this.analyses.add(new Smpdtl(db, well, this, (Element)it.next(), dataTypes, zip));
        }
        Iterator it1 = xml.getDescendants((Filter)new ElementFilter("Lithology"));
        while (it1.hasNext()) {
            this.sampleLithology.add(new SampleLithologyUnit(db, (Element)it1.next()));
            if (dataTypes.contains(22)) continue;
            dataTypes.add(22);
        }
        Element el = xml.getChild("Audit");
        if (el != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for sample: " + this);
        }
        if (!dataTypes.contains(1)) {
            dataTypes.add(1);
        }
    }

    public int getSampID() {
        return this.sampID;
    }

    public void setAge(int interpID, Double age, Double ageBelow, Float ageErrorPlus, Float ageErrorMinus, Double ratio, int wellID) throws SQLException {
        SampleAge sampleAge = this.ages.get(interpID);
        if (age == null && ageBelow == null && ageErrorPlus == null && ageErrorMinus == null && ratio == null) {
            if (sampleAge != null) {
                this.ages.remove(interpID);
                sampleAge.delete(this.SB, wellID, interpID);
            }
            return;
        }
        if (sampleAge == null) {
            sampleAge = new SampleAge();
            this.ages.put(interpID, sampleAge);
        }
        sampleAge.age = age;
        sampleAge.ageBelow = ageBelow;
        sampleAge.ageErrorPlus = ageErrorPlus;
        sampleAge.ageErrorMinus = ageErrorMinus;
        sampleAge.ratio = ratio;
        this.setChanged();
    }

    public void updateAge(int wellID, double age, WellInterp interp) throws SQLException {
        SampleAge sage = this.ages.get(interp.interpID);
        if (sage == null) {
            sage = new SampleAge();
            this.ages.put(interp.interpID, sage);
        }
        sage.setAge(this.SB, wellID, interp.interpID, age);
        this.setChanged();
    }

    public void updateAgeBelow(int wellID, double age, WellInterp interp) throws SQLException {
        SampleAge sage = this.ages.get(interp.interpID);
        if (sage == null) {
            sage = new SampleAge();
            this.ages.put(interp.interpID, sage);
        }
        sage.setAgeBelow(this.SB, wellID, interp.interpID, age);
        this.setChanged();
    }

    void writeDEX(FileWriter out, List dataTypes, boolean useAges, boolean useLithology, LinkedList taxa, char units, String eol, SimpleDateFormat df) throws IOException, SBException, SQLException {
        this.displayUnits = units;
        out.write("[SAMPLE " + this.toString().trim() + "]" + eol);
        if (this.depth != null) {
            if (this.depth.top != null) {
                out.write("Top Depth = " + util.SB.getDepthString((double)this.depth.top, (char)units, (int)3, (char)this.sectionType).trim() + eol);
            }
            if (this.depth.base != null) {
                out.write("Base Depth = " + util.SB.getDepthString((double)this.depth.base, (char)units, (int)3, (char)this.sectionType).trim() + eol);
            }
        }
        out.write("Type = " + this.type + eol);
        if (this.gridX > 0.0) {
            out.write("Grid X = " + this.gridX + eol);
        }
        if (this.gridY > 0.0) {
            out.write("Grid Y = " + this.gridY + eol);
        }
        if (this.audit.created != null) {
            out.write("Created = " + df.format(this.audit.created) + eol);
        }
        if (this.audit.modified != null) {
            out.write("Modified = " + df.format(this.audit.modified) + eol);
        }
        out.write("Sample id = " + this.getSampID() + eol);
        if (this.textLabel != null && this.textLabel.length() > 0) {
            out.write("Label = " + this.textLabel + eol);
        }
        SampleAge sampleAge = this.ages.get(0);
        if (useAges && sampleAge != null) {
            out.write("Age = " + sampleAge.age + eol);
            out.write("Age error plus : " + sampleAge.ageErrorPlus + eol);
            out.write("Age error minus : " + sampleAge.ageErrorMinus + eol);
        }
        if (useAges && sampleAge != null && sampleAge.ageBelow > 0.0) {
            out.write("Age below unconformity = " + sampleAge.ageBelow + eol);
        }
        if (useAges && sampleAge != null && sampleAge.ratio > 0.0) {
            out.write("Ratio : " + sampleAge.ratio + eol);
        }
        if (useLithology) {
            for (int i = 0; i < this.sampleLithology.getLithology().size(); ++i) {
                SampleLithologyUnit lith = this.sampleLithology.getLithology().get(i);
                out.write("Lithology = " + lith.getDescription().getDescr() + eol);
                out.write("  Lithology code : " + lith.getDescription().getLithID() + eol);
                out.write("  Lithology percent : " + lith.getPercent() + eol);
            }
        }
        Iterator it = dataTypes.iterator();
        while (it.hasNext()) {
            int columnType = (Integer)it.next();
            if (columnType != 8 && columnType != 2 && columnType != 6 && columnType != 4 || !this.hasDisciplineData(SBdb.dt2discID(columnType))) continue;
            out.write(eol);
            for (int i = 0; i < this.analyses.size(); ++i) {
                Smpdtl smpdtl = this.analyses.get(i);
                if (smpdtl.getDiscID() != SBdb.dt2discID(columnType)) continue;
                smpdtl.writeDEX(out, taxa, df, eol);
            }
        }
        out.write(eol);
    }

    void removeAgeData(int interpID) {
        this.ages.remove(interpID);
    }

    public boolean hasAgeData(WellInterp interp) {
        return this.hasAgeData(interp.interpID);
    }

    public boolean hasAgeData(int interpID) {
        SampleAge age = this.ages.get(interpID);
        return age != null && age.hasData();
    }

    void merge(Sample sample) throws SBException, SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to merge samples in database instance.");
        }
        if (!this.getSortEntry().equals(sample.getSortEntry())) {
            throw new SBException("Attempt to merge unequal.");
        }
        for (Smpdtl smpdtl : this.analyses) {
            for (Smpdtl mergeAnaly : sample.analyses) {
                if (smpdtl.getHeader() != mergeAnaly.getHeader()) continue;
                throw new SBException("Attempt to read/merge sample with duplicate analyses:  " + this + " : " + smpdtl.getHeader());
            }
        }
        for (Smpdtl mergeAnaly : sample.analyses) {
            mergeAnaly.setSample(this);
        }
        this.analyses.addAll(sample.analyses);
        this.textLabel = util.SB.mergeString((String)this.textLabel, (String)sample.textLabel, (boolean)true);
        if (this.sampleLithology.getLithology().size() == 0 && sample.getLithology().getLithology().size() > 0) {
            this.sampleLithology = sample.getLithology();
        }
        if (this.ages.size() == 0 && sample.ages.size() > 0) {
            this.ages = sample.ages;
        }
        if (Math.abs(this.gridX) < (double)0.0029f && Math.abs(sample.gridX) > (double)0.0029f) {
            this.gridX = sample.gridX;
        }
        if (Math.abs(this.gridY) < (double)0.0029f && Math.abs(sample.gridY) > (double)0.0029f) {
            this.gridY = sample.gridY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(List samples, Sample sample, char wellUnits) throws SBException {
        int i;
        for (i = 0; i < samples.size(); ++i) {
            Sample existing = (Sample)samples.get(i);
            int compare = sample.compareTo(existing);
            if (compare == 0) {
                if (sample.sampID > 0 && existing.sampID == 0) {
                    existing.sampID = sample.sampID;
                    existing.status = sample.status;
                } else {
                    if (sample.sampID > 0 && existing.sampID > 0 && sample.sampID != existing.sampID) break;
                    sample.displayUnits = wellUnits;
                    throw new SampleInsertException("Duplicate sample at depth: " + sample.toString() + ". Sample ID: " + sample.sampID, existing);
                }
            }
            if (compare < 0) break;
        }
        List list = samples;
        synchronized (list) {
            samples.add(i, sample);
        }
    }

    public static void checkOverlap(List samples, Sample sample, char wellUnits) throws SBException {
        for (int i = 0; i < samples.size(); ++i) {
            Sample existing = (Sample)samples.get(i);
            if (sample.compareTo(existing) != 0) continue;
            if (sample.sampID > 0 && existing.sampID == 0) {
                existing.sampID = sample.sampID;
                existing.status = sample.status;
                continue;
            }
            if (sample.sampID > 0 && existing.sampID > 0 && sample.sampID != existing.sampID) continue;
            sample.displayUnits = wellUnits;
            throw new SampleInsertException("Duplicate sample at depth: " + sample.toString() + ". Sample ID: " + sample.sampID, existing);
        }
    }

    static int getNumAnalyses(SBdb SB2, String userID) throws SQLException {
        int num = 0;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = null;
        for (int i = 0; i < 4; ++i) {
            String sql = "SELECT count(analyst) AS analyses FROM " + SB2.DBTableName("SMPDTL") + " WHERE disc_id='" + SBdb.discArr[i] + "' AND analyst='" + userID + "'";
            rs = stmt.executeQuery(SB2.modQuery(sql));
            if (!rs.next()) continue;
            num += rs.getInt("analyses");
        }
        stmt.close();
        return num;
    }

    public int hashCode() {
        return this.sampID;
    }

    static int loadAll(SBdb SB2, Project project) throws SQLException, SBException {
        int nSamples = 0;
        String sql = "SELECT WELL_ID,SAMP_ID,TOP_DEPTH,BASE_DEPTH,TYPE,GRID_X,GRID_Y,LABEL," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("samples") + " ORDER BY well_id,samp_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            int sampID = rs.getInt("samp_id");
            Well well = project.getWell(SB2, wellID);
            if (well == null) {
                System.out.println("WARNING: well is null for sample: " + sampID);
                continue;
            }
            try {
                BigDecimal topDepth = util.SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (SB2.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                BigDecimal baseDepth = util.SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (SB2.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                String sampleType = rs.getString("type");
                int gridX = rs.getInt("grid_x");
                int gridY = rs.getInt("grid_y");
                String strg = rs.getString("label");
                Audit audit = new Audit(rs);
                Sample sample = new Sample(SB2, well.getType(), sampID, topDepth == null ? null : Double.valueOf(topDepth.doubleValue()), baseDepth == null ? null : Double.valueOf(baseDepth.doubleValue()), sampleType, gridX, gridY, strg, audit);
                Sample.insert(well.getSamples(false), sample, well.getWellUnits());
                sample.loadLithology(wellID, SB2.getLithdesc());
                ++nSamples;
            }
            catch (SBException sbe) {
                System.out.println("Exception inserting sample for well: " + well + " : " + sbe.getMessage());
            }
        }
        return nSamples;
    }

    public char getSectionType() {
        return this.sectionType;
    }

    public void deleteLithology(int wellID) throws SQLException {
        if (this.SB != null && this.SB.isConnected() && wellID > 0) {
            SampleLithology.clear(this.SB, wellID, this.sampID);
        }
        this.sampleLithology.lithology.clear();
    }

    public static String roundSampleDepth(Sample sample) throws SBException {
        if (sample.getTypeString().equals("CO")) {
            return util.SB.floatString((double)sample.getDepth(), (int)2);
        }
        if (sample.getTypeString().equals("SC") || sample.getTypeString().equals("LOG")) {
            return util.SB.floatString((double)sample.getDepth(), (int)1);
        }
        return util.SB.floatString((double)sample.getDepth(), (int)0);
    }

    public static String roundSampleDepth(double corrDepth, String type) throws SBException {
        if (type.equals("CO")) {
            return util.SB.floatString((double)corrDepth, (int)2);
        }
        if (type.equals("SC") || type.equals("LOG")) {
            return util.SB.floatString((double)corrDepth, (int)1);
        }
        return util.SB.floatString((double)corrDepth, (int)0);
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for sample: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
        for (Smpdtl dtl : this.getAnalyses()) {
            dtl.setAnalyst(analyst);
        }
    }

    public static enum SampleType {
        CU,
        CO,
        SC,
        OC,
        LOG;


        public static SampleType getType(String typeAbr) {
            for (SampleType t : SampleType.values()) {
                if (!typeAbr.equalsIgnoreCase(t.name())) continue;
                return t;
            }
            throw new IllegalArgumentException("Unrecognised sample type: " + typeAbr);
        }

        public static SampleType parseType(String buff) {
            String[] types = new String[]{"CU", "DC", "WDC", "DDC", "SC", "SWC", "MSCT", "CO", "CORE", "CC", "OC", "CUTTING", "SW", "LOG", "SWS", "Ditch Cutting", "Sidewall Core"};
            SampleType[] sbTypes = new SampleType[]{CU, CU, CU, CU, SC, SC, SC, CO, CO, CO, OC, CU, SC, LOG, SC, CU, SC};
            for (int i = 0; i < types.length; ++i) {
                if (!buff.equalsIgnoreCase(types[i])) continue;
                return sbTypes[i];
            }
            if (buff.startsWith("SWC") || buff.startsWith("SC")) {
                return SC;
            }
            return null;
        }
    }

    class SampleAge {
        boolean hasData = false;
        Float ageErrorPlus;
        Float ageErrorMinus;
        Double age;
        Double ageBelow;
        Double ratio;
        Audit ageAudit = new Audit();

        private SampleAge() {
        }

        private SampleAge(SBdb SB2, int wellID, int interpID) throws SQLException {
            this.age = null;
            this.ageBelow = null;
            this.ageErrorPlus = null;
            this.ageErrorMinus = null;
            this.ratio = null;
            String sql = "SELECT age,age_below,ageplus,ageminus,ratio," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("SBSSR") + " WHERE samp_id=" + Sample.this.sampID + " AND well_id=" + wellID + " AND interp_id=" + interpID;
            sql = SB2.modQuery(sql);
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                this.hasData = true;
                this.age = rs.getDouble("age");
                this.ageBelow = rs.getDouble("age_below");
                this.ageErrorPlus = Float.valueOf(rs.getFloat("ageplus"));
                this.ageErrorMinus = Float.valueOf(rs.getFloat("ageminus"));
                this.ratio = rs.getDouble("ratio");
                this.ageAudit = new Audit(rs);
            }
            stmt.close();
        }

        private boolean hasData() {
            this.hasData = false;
            if (this.age != null && this.age != 0.0) {
                this.hasData = true;
            } else if (this.ageErrorPlus != null && this.ageErrorPlus.floatValue() != 0.0f) {
                this.hasData = true;
            } else if (this.ageErrorMinus != null && this.ageErrorMinus.floatValue() != 0.0f) {
                this.hasData = true;
            } else if (this.ageBelow != null && this.ageBelow != 0.0) {
                this.hasData = true;
            } else if (this.ratio != null && this.ratio != 0.0) {
                this.hasData = true;
            }
            return this.hasData;
        }

        private void setAge(SBdb SB2, int wellID, int interpID, double age) throws SQLException {
            String sql;
            Statement stmt = SB2.getDatabase().createStatement();
            int nRow = stmt.executeUpdate(SB2.modQuery(sql = "UPDATE " + SB2.DBTableName("sbssr") + " SET age=" + age + "," + this.ageAudit.sqlUpdate(SB2, stmt, false) + " WHERE samp_id=" + Sample.this.sampID + " AND interp_id=" + interpID + " AND well_id=" + wellID));
            if (nRow == 0) {
                sql = "INSERT INTO " + SB2.DBTableName("sbssr") + " (well_id,samp_id,age,interp_id," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + Sample.this.sampID + "," + age + "," + interpID + "," + this.ageAudit.sqlInsert(SB2, stmt) + ")";
                stmt.executeUpdate(SB2.modQuery(sql));
            }
            this.age = age;
            stmt.close();
        }

        private void setAgeBelow(SBdb SB2, int wellID, int interpID, double ageBelow) throws SQLException {
            String sql;
            Statement stmt = SB2.getDatabase().createStatement();
            int nRow = stmt.executeUpdate(SB2.modQuery(sql = "UPDATE " + SB2.DBTableName("sbssr") + " SET age_below=" + ageBelow + "," + this.ageAudit.sqlUpdate(SB2, stmt, false) + " WHERE samp_id=" + Sample.this.sampID + " AND interp_id=" + interpID + " AND well_id=" + wellID));
            if (nRow == 0) {
                sql = "INSERT INTO " + SB2.DBTableName("sbssr") + " (well_id,samp_id,age_below,interp_id," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + Sample.this.sampID + "," + ageBelow + "," + interpID + "," + this.ageAudit.sqlInsert(SB2, stmt) + ")";
                stmt.executeUpdate(SB2.modQuery(sql));
            }
            this.ageBelow = ageBelow;
            stmt.close();
        }

        private void store(SBdb SB2, int wellID, int interpID) throws SQLException {
            String sql = "DELETE FROM " + SB2.DBTableName("SBSSR") + " WHERE well_id=" + wellID + " AND samp_id=" + Sample.this.sampID + " AND interp_id=" + interpID;
            Statement stmt = SB2.getDatabase().createStatement();
            stmt.executeUpdate(SB2.modQuery(sql));
            if (this.ratio == null && this.age == null && this.ageBelow == null && this.ageErrorPlus == null && this.ageErrorMinus == null) {
                stmt.close();
                return;
            }
            sql = "INSERT INTO " + SB2.DBTableName("SBSSR") + " (well_id,interp_id,samp_id,ratio,age,age_below,ageplus,ageminus," + Audit.sqlFieldString();
            sql = sql + ") VALUES(";
            sql = sql + wellID + "," + interpID + "," + Sample.this.sampID + "," + this.ratio + "," + this.age + "," + this.ageBelow + "," + this.ageErrorPlus + "," + this.ageErrorMinus + "," + this.ageAudit.sqlInsert(SB2, stmt);
            sql = sql + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
        }

        private void delete(SBdb SB2, int wellID, int interpID) throws SQLException {
            String sql = "DELETE FROM " + SB2.DBTableName("SBSSR") + " WHERE well_id=" + wellID + " AND samp_id=" + Sample.this.sampID + " AND interp_id=" + interpID;
            Statement stmt = SB2.getDatabase().createStatement();
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
        }
    }

    class SampleDepth {
        Double top;
        Double base;

        SampleDepth() {
        }

        SampleDepth(Double top, Double base) {
            this.top = top;
            this.base = base;
        }

        private int compareBase(Double base) {
            if (this.base == null && base == null) {
                return 0;
            }
            if (this.base == null) {
                return -1;
            }
            if (base == null) {
                return 1;
            }
            if (Math.abs(this.base - base) < (double)0.0029f) {
                return 0;
            }
            return this.base < base ? -1 : 1;
        }

        private int compareTop(Double top) {
            if (this.top == null || top == null) {
                return 0;
            }
            if (Math.abs(this.top - top) < (double)0.0029f) {
                return 0;
            }
            return this.top < top ? -1 : 1;
        }
    }
}

