/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import model2.Audit;
import model2.Lithology;
import model2.SBdb;
import model2.Sample;
import model2.SampleLithologyUnit;
import model2.WsLithology;
import model2.WsWell;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsStatus;

public class SampleLithology
implements SbugsStatus {
    Color status = UNKNOWN;
    List<SampleLithologyUnit> lithology = new LinkedList<SampleLithologyUnit>();

    SampleLithology() {
    }

    public List<SampleLithologyUnit> getLithology() {
        return this.lithology;
    }

    void add(SampleLithologyUnit unit) {
        this.lithology.add(unit);
    }

    void store(int wellID, int sampID, SBdb db) throws SQLException, SBException {
        this.checkTotal();
        Statement stmt = db.getDatabase().createStatement();
        String sql = "";
        for (SampleLithologyUnit unit : this.lithology) {
            sql = "INSERT INTO " + db.DBTableName("SBSLITH") + " (well_id,samp_id,lith_id,percnt," + Audit.sqlFieldString() + ") VALUES(" + wellID + "," + sampID + "," + unit.getDescription().getLithID() + "," + unit.getPercent() + "," + unit.getAudit().sqlInsert(db, stmt) + ")";
            stmt.executeUpdate(db.modQuery(sql));
        }
        stmt.close();
    }

    void updateLithology(List<SampleLithologyUnit> liths, int wellID, int sampID, SBdb db) throws SQLException, SBException {
        LinkedList<SampleLithologyUnit> newLiths = new LinkedList<SampleLithologyUnit>();
        this.lithology.clear();
        SampleLithology.clear(db, wellID, sampID);
        for (SampleLithologyUnit lith : liths) {
            Lithology desc;
            if (lith.getDescription() instanceof WsLithology) {
                WsLithology wslith = (WsLithology)lith.getDescription();
                desc = wslith.getLink();
            } else {
                desc = lith.getDescription();
            }
            SampleLithologyUnit newLith = new SampleLithologyUnit(db, desc, lith.getPercent());
            newLiths.add(newLith);
        }
        this.lithology = newLiths;
        Collections.sort(this.lithology);
        this.store(wellID, sampID, db);
    }

    static void clear(SBdb SB2, int wellID, int sampID) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("SBSLITH") + " WHERE well_id=" + wellID + " AND samp_id=" + sampID;
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    private void checkTotal() throws SBException {
        int total = 0;
        for (SampleLithologyUnit unit : this.lithology) {
            if ((total += unit.getPercent()) <= 100) continue;
            throw new SBException("Attempt to store sample lithology with total > 100%");
        }
    }

    public Color getStatus(SampleLithology lith) {
        MergeStatus m = new MergeStatus(STORED);
        if (lith == null || lith.getLithology().isEmpty()) {
            this.status = NOTSTORED;
            return this.status;
        }
        m.compareStringField("Name", this.toString(), lith.toString(), true);
        this.status = m.getStatus();
        return this.status;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        String strg = "";
        Collections.sort(this.lithology);
        for (SampleLithologyUnit unit : this.lithology) {
            strg = strg + (!strg.isEmpty() ? ", " : "") + unit.getDescription();
            strg = strg + " " + unit.getPercent() + "%";
        }
        return strg;
    }

    public void discardUnmatched() {
        LinkedList<SampleLithologyUnit> toKill = new LinkedList<SampleLithologyUnit>();
        for (SampleLithologyUnit unit : this.lithology) {
            WsLithology wslith;
            if (!(unit.getDescription() instanceof WsLithology) || (wslith = (WsLithology)unit.getDescription()).getLink() != null) continue;
            toKill.add(unit);
        }
        for (SampleLithologyUnit kill : toKill) {
            this.lithology.remove(kill);
        }
    }

    public static void readFile(String fileName, SBdb sbdb, WsWell well, LinkedList<WsLithology> lithList, LinkedList<Sample> samples, boolean singleDepth, float interval, char units) throws IOException, SBException, SQLException {
        if (singleDepth) {
            SampleLithology.readSingleDepthFile(fileName, sbdb, well, lithList, samples, units, interval);
        } else {
            SampleLithology.readDuelDepthFile(fileName, sbdb, well, lithList, samples, units);
        }
    }

    public static void readSingleDepthFile(String fileName, SBdb sbdb, WsWell well, LinkedList<WsLithology> lithList, LinkedList<Sample> samples, char units, float interval) throws IOException, SBException, SQLException {
        String buff;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        WsLithology[] wsLiths = null;
        while ((buff = in.readLine()) != null) {
            if (!buff.trim().toUpperCase().startsWith("DEPTH")) continue;
            wsLiths = SampleLithology.parseFileColumns(buff);
            break;
        }
        float depth = 0.0f;
        float lastDepth = 0.0f;
        LinkedList<SampleLithologyUnit> slithUnits = null;
        LinkedList<SampleLithologyUnit> lastUnits = null;
        while ((buff = in.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(buff, " ,\t");
            int column = 0;
            slithUnits = null;
            while (tok.hasMoreTokens()) {
                float colValue = Float.parseFloat(tok.nextToken().trim());
                if (column == 0) {
                    depth = colValue;
                } else if (colValue > 0.0f && wsLiths[column] != null) {
                    if (slithUnits == null) {
                        slithUnits = new LinkedList<SampleLithologyUnit>();
                    }
                    slithUnits.add(new SampleLithologyUnit(wsLiths[column], (int)colValue));
                }
                ++column;
            }
            if (lastDepth == 0.0f) {
                lastDepth = depth;
            }
            if (slithUnits != null && (!SampleLithology.lithEqual(slithUnits, lastUnits) || depth - lastDepth >= interval)) {
                double mDepth = SB.convToM((float)depth, (char)units);
                Sample sample = new Sample(sbdb, well.getType());
                sample.setBaseDepth(mDepth, 'M');
                sample.setType("CU");
                samples.add(sample);
                for (SampleLithologyUnit unit : slithUnits) {
                    sample.getLithology().add(unit);
                }
                lastDepth = depth;
            }
            lastUnits = slithUnits;
        }
        in.close();
        if (wsLiths != null) {
            for (int i = 0; i < wsLiths.length; ++i) {
                WsLithology wsLith = wsLiths[i];
                if (wsLith == null) continue;
                lithList.add(wsLith);
            }
        }
    }

    public static void readDuelDepthFile(String fileName, SBdb sbdb, WsWell well, LinkedList<WsLithology> lithList, LinkedList<Sample> samples, char units) throws IOException, SBException, SQLException {
        String buff;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        WsLithology[] wsLiths = null;
        while ((buff = in.readLine()) != null) {
            if (!buff.trim().toUpperCase().startsWith("TOP")) continue;
            wsLiths = SampleLithology.parseFileColumns(buff);
            break;
        }
        float topDepth = 0.0f;
        float baseDepth = 0.0f;
        LinkedList<SampleLithologyUnit> slithUnits = null;
        while ((buff = in.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(buff, " ,\t");
            int column = 0;
            slithUnits = null;
            while (tok.hasMoreTokens()) {
                float colValue = Float.parseFloat(tok.nextToken().trim());
                if (column == 0) {
                    topDepth = colValue;
                } else if (column == 1) {
                    baseDepth = colValue;
                } else if (colValue > 1.0f && wsLiths[column] != null) {
                    if (slithUnits == null) {
                        slithUnits = new LinkedList<SampleLithologyUnit>();
                    }
                    slithUnits.add(new SampleLithologyUnit(wsLiths[column], (int)colValue));
                }
                ++column;
            }
            if (slithUnits == null) continue;
            double mTopDepth = SB.convToM((float)topDepth, (char)units);
            double mBaseDepth = SB.convToM((float)baseDepth, (char)units);
            Sample sample = new Sample(sbdb, well.getType());
            sample.setDepth(mTopDepth, mBaseDepth, 'M');
            sample.setType("CU");
            samples.add(sample);
            for (SampleLithologyUnit unit : slithUnits) {
                sample.getLithology().add(unit);
            }
        }
        in.close();
        if (wsLiths != null) {
            for (int i = 0; i < wsLiths.length; ++i) {
                WsLithology wsLith = wsLiths[i];
                if (wsLith == null) continue;
                lithList.add(wsLith);
            }
        }
    }

    static WsLithology[] parseFileColumns(String buff) throws SBException, SQLException {
        StringTokenizer tok = new StringTokenizer(buff, " ,\t");
        LinkedList<WsLithology> liths = new LinkedList<WsLithology>();
        while (tok.hasMoreTokens()) {
            String strg = tok.nextToken().trim().toUpperCase();
            WsLithology lith = null;
            lith = strg.equalsIgnoreCase("DEPTH") ? null : (strg.equalsIgnoreCase("TOP") ? null : (strg.equalsIgnoreCase("BASE") ? null : (strg.equalsIgnoreCase("NODE") ? null : (strg.equalsIgnoreCase("NOSA") ? null : new WsLithology(strg, -1)))));
            liths.add(lith);
        }
        WsLithology[] lithArray = new WsLithology[liths.size()];
        for (int i = 0; i < liths.size(); ++i) {
            lithArray[i] = (WsLithology)liths.get(i);
        }
        return lithArray;
    }

    static boolean lithEqual(LinkedList<SampleLithologyUnit> lith1, LinkedList<SampleLithologyUnit> lith2) {
        if (lith1 != null && lith2 == null) {
            return false;
        }
        if (lith1.size() != lith2.size()) {
            return false;
        }
        for (int i = 0; i < lith1.size(); ++i) {
            SampleLithologyUnit slith1 = lith1.get(i);
            SampleLithologyUnit slith2 = lith2.get(i);
            if (!slith1.getDescription().equals(slith2.getDescription())) {
                return false;
            }
            if (slith1.getPercent() == slith2.getPercent()) continue;
            return false;
        }
        return true;
    }
}

