/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import model2.Audit;
import model2.Lithology;
import model2.SBdb;
import org.jdom.Element;
import util.SBException;

public class SampleLithologyUnit
implements Comparable<SampleLithologyUnit> {
    SBdb SB;
    private Lithology description;
    private int percent;
    private Audit audit = new Audit();

    SampleLithologyUnit(SBdb SB2, Lithology descr, int percent) {
        this.SB = SB2;
        this.description = descr;
        this.percent = percent;
    }

    public SampleLithologyUnit(Lithology descr, int percent) {
        this.description = descr;
        this.percent = percent;
    }

    public SampleLithologyUnit(SampleLithologyUnit rhs) {
        this.description = rhs.description;
        this.percent = rhs.percent;
        this.audit = rhs.audit;
    }

    public SampleLithologyUnit(SBdb SB2, Element xml) throws SBException, SQLException {
        this.SB = SB2;
        String codeStrg = xml.getChildTextNormalize("Code");
        if (codeStrg == null) {
            throw new SBException("Attempt to get lithology for unrecognised code: " + codeStrg);
        }
        int code = Integer.parseInt(codeStrg);
        this.description = this.SB.getLithdesc().getLithology(code);
        String percentStrg = xml.getChildTextNormalize("Percent");
        this.percent = Integer.parseInt(percentStrg);
    }

    public void setPercent(int percent) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set sample lithology");
        }
        this.percent = percent;
    }

    public void setDescription(Lithology descr) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set sample lithology");
        }
        this.description = descr;
    }

    void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<Description>" + this.description.getDescr() + "</Description>\n");
        out.write(ind + "<Code>" + this.description.getLithID() + "</Code>\n");
        out.write(ind + "<Percent>" + this.percent + "</Percent>\n");
    }

    void parseXML(String chars, String element) throws ParseException, SQLException {
    }

    public Lithology getDescription() {
        return this.description;
    }

    public int getPercent() {
        return this.percent;
    }

    Audit getAudit() {
        return this.audit;
    }

    @Override
    public int compareTo(SampleLithologyUnit o) {
        Integer s2;
        Integer s1 = this.description.getSortOrder();
        int val = s1.compareTo(s2 = Integer.valueOf(o.getDescription().getSortOrder()));
        if (val == 0) {
            Integer p1 = this.percent;
            Integer p2 = o.getPercent();
            val = p1.compareTo(p2);
        }
        return val;
    }
}

