/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import model2.AnalystHeader;
import model2.Audit;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Userdef;
import model2.Well;
import model2.WsWell;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.MergeStatus;
import util.SB;
import util.SBException;

public class SampleOccReaderXLS {
    List nonInserts = new LinkedList();
    int donorSampleID = 1;
    List<Integer> dataTypes;
    int topDepthColumn = -1;
    int baseDepthColumn = -1;
    int sampleTypeColumn = -1;
    int genusColumn = -1;
    int speciesColumn = -1;
    int countsColumn = -1;
    char units = (char)77;
    int specID = 1;
    SBdb ws;

    public SampleOccReaderXLS(SBdb ws, File file, List<Integer> dataTypes, Userdef analyst, char discID, char units) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        this.units = units;
        Workbook wb = WorkbookFactory.create((File)file);
        dataTypes.clear();
        Sheet sheet = wb.getSheetAt(0);
        System.out.println("processing sheet: " + wb.getSheetName(0) + "\n");
        this.parseSheet(sheet, analyst, discID);
    }

    final void parseSheet(Sheet sheet, Userdef analyst, char discID) throws SBException, SQLException {
        boolean parsedTitles = false;
        WsWell well = null;
        this.addDataType(1);
        if (well != null) {
            well.updateStatus(this.dataTypes);
        }
        well = new WsWell(this.ws);
        System.out.println("Setting well name as: " + sheet.getSheetName());
        well.getHeader().setWellName(sheet.getSheetName());
        well.getHeader().setWellCode(Well.makeCode(sheet.getSheetName()));
        well.getHeader().setWellUnits(this.units);
        AnalystHeader analyHdr = well.getAnalystHeader(analyst.getAbr(), discID, 1, true);
        this.ws.insertWell(well);
        double lastDepth = 0.0;
        String lastType = null;
        Sample sample = null;
        Smpdtl smpdtl = null;
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            if (!parsedTitles) {
                parsedTitles = this.parseTitles(row);
                continue;
            }
            Double topDepth = null;
            Double baseDepth = null;
            String type = "CO";
            String genus = null;
            String species = null;
            int counts = 0;
            for (short i = 0; i <= row.getLastCellNum(); i = (short)(i + 1)) {
                Cell cell = row.getCell((int)i);
                if (cell == null || cell.getCellType() == 3) continue;
                if (i == this.baseDepthColumn) {
                    switch (cell.getCellType()) {
                        case 0: 
                        case 2: {
                            baseDepth = cell.getNumericCellValue();
                            break;
                        }
                        case 1: {
                            baseDepth = new Double(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.topDepthColumn) {
                    switch (cell.getCellType()) {
                        case 0: 
                        case 2: {
                            topDepth = cell.getNumericCellValue();
                            break;
                        }
                        case 1: {
                            topDepth = new Double(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.sampleTypeColumn) {
                    type = cell.getStringCellValue();
                    continue;
                }
                if (i == this.genusColumn) {
                    genus = cell.getStringCellValue();
                    continue;
                }
                if (i == this.speciesColumn) {
                    species = cell.getStringCellValue();
                    continue;
                }
                if (i != this.countsColumn) continue;
                counts = (int)cell.getNumericCellValue();
            }
            if (Math.max(baseDepth == null ? 0.0 : baseDepth, topDepth == null ? 0.0 : topDepth) < (double)0.0029f) continue;
            try {
                block31: {
                    block30: {
                        if (this.units == 'F') {
                            if (topDepth != null) {
                                topDepth = SB.convToM((double)topDepth, (char)this.units);
                            }
                            if (baseDepth != null) {
                                baseDepth = SB.convToM((double)baseDepth, (char)this.units);
                            }
                        }
                        if (sample == null) break block30;
                        double d = baseDepth == null ? 0.0 : baseDepth;
                        double d2 = topDepth == null ? 0.0 : topDepth;
                        if (!(Math.max(d, d2) - lastDepth > (double)0.0029f) && type.equals(lastType)) break block31;
                    }
                    sample = well.addSample(topDepth, baseDepth, type, null);
                    System.out.println("Sample: " + sample.toString() + " Added to well: " + well);
                    smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.ANALYSED);
                    sample.insert(smpdtl);
                    lastDepth = Math.max(baseDepth == null ? 0.0 : baseDepth, topDepth == null ? 0.0 : topDepth);
                    lastType = type;
                }
                if (smpdtl == null) {
                    throw new SBException("Failed to parse smpdtl");
                }
                Taxon taxonRef = this.ws.getTaxon(genus + " " + species, this.specID, true);
                if (taxonRef.getSpecID() == this.specID) {
                    ++this.specID;
                }
                TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, taxonRef, false, false, 0);
                builder = builder.count(counts);
                try {
                    smpdtl.insertOccurrence(builder, well.getWellID(), false);
                }
                catch (SBException ex) {
                    throw new SBException(ex.getMessage() + " in Sample: " + sample.toString());
                }
                sample.status = MergeStatus.merge((Color)sample.status, (Color)smpdtl.status);
                this.addDataType(1);
                this.addDataType(SBdb.did2dtype(smpdtl.getDiscID()));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception ading sample: " + topDepth + "," + baseDepth + "," + type + " to Well:" + well);
                ex.printStackTrace();
            }
        }
        if (well != null) {
            well.updateStatus(this.dataTypes);
        }
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    boolean parseTitles(Row row) {
        boolean isTitleRow = false;
        for (short i = 0; i <= row.getLastCellNum(); i = (short)(i + 1)) {
            Cell cell = row.getCell((int)i);
            if (cell == null || cell.getCellType() != 1) continue;
            String strg = cell.getStringCellValue();
            if (strg.toUpperCase().startsWith("DEPTH")) {
                if (this.ws.useSampleTops()) {
                    this.topDepthColumn = i;
                } else {
                    this.baseDepthColumn = i;
                }
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("TOP DEPTH") && this.topDepthColumn < 0) {
                this.topDepthColumn = i;
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("BASE DEPTH")) {
                if (this.baseDepthColumn >= 0) continue;
                this.baseDepthColumn = i;
                isTitleRow = true;
                if (!strg.toLowerCase().contains("(ft)")) continue;
                this.units = (char)70;
                continue;
            }
            if (strg.equalsIgnoreCase("SAMPLE TYPE") || strg.equalsIgnoreCase("TYPE")) {
                if (this.sampleTypeColumn >= 0) continue;
                this.sampleTypeColumn = i;
                continue;
            }
            if (strg.equalsIgnoreCase("GENUS")) {
                this.genusColumn = i;
                continue;
            }
            if (strg.equalsIgnoreCase("SPECIES")) {
                this.speciesColumn = i;
                continue;
            }
            if (!strg.equalsIgnoreCase("COUNTS")) continue;
            this.countsColumn = i;
        }
        return isTitleRow;
    }
}

