/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WsWell;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.SB;
import util.SBException;

public class SampleReaderXLS {
    List nonInserts = new LinkedList();
    int donorSampleID = 1;
    List<Integer> dataTypes;
    int wellColumn = 0;
    int topDepthColumn = -1;
    int baseDepthColumn = -1;
    int sampleTypeColumn = -1;
    int sampleLabelColumn = -1;
    char units = (char)77;
    SBdb ws;

    public SampleReaderXLS(SBdb ws, File file, List<Integer> dataTypes) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        Workbook wb = WorkbookFactory.create((File)file);
        dataTypes.clear();
        Sheet sheet = wb.getSheetAt(0);
        System.out.println("processing sheet: " + wb.getSheetName(0) + "\n");
        this.parseSheet(sheet);
    }

    final void parseSheet(Sheet sheet) throws SBException, SQLException {
        boolean parsedTitles = false;
        WsWell well = null;
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            if (!parsedTitles) {
                parsedTitles = this.parseTitles(row);
                continue;
            }
            Double topDepth = null;
            Double baseDepth = null;
            String type = "CO";
            String wellName = null;
            String label = null;
            block15: for (short i = 0; i <= row.getLastCellNum(); i = (short)(i + 1)) {
                Cell cell = row.getCell((int)i);
                if (cell == null || cell.getCellType() == 3) continue;
                if (i == this.wellColumn) {
                    wellName = cell.getStringCellValue();
                    continue;
                }
                if (i == this.topDepthColumn) {
                    switch (cell.getCellType()) {
                        case 0: 
                        case 2: {
                            topDepth = cell.getNumericCellValue();
                            break;
                        }
                        case 1: {
                            topDepth = new Double(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.baseDepthColumn) {
                    switch (cell.getCellType()) {
                        case 0: 
                        case 2: {
                            baseDepth = cell.getNumericCellValue();
                            break;
                        }
                        case 1: {
                            baseDepth = new Double(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.sampleTypeColumn) {
                    type = cell.getStringCellValue();
                    continue;
                }
                if (i != this.sampleLabelColumn) continue;
                switch (cell.getCellType()) {
                    case 0: 
                    case 2: {
                        label = "" + cell.getNumericCellValue();
                        if (!label.endsWith(".0")) continue block15;
                        label = label.substring(0, label.length() - 2);
                        continue block15;
                    }
                    case 1: {
                        label = cell.getStringCellValue();
                    }
                }
            }
            if (well == null || wellName != null && !well.getWellName().equalsIgnoreCase(wellName)) {
                this.addDataType(1);
                if (well != null) {
                    well.updateStatus(this.dataTypes);
                }
                well = new WsWell(this.ws);
                System.out.println("Setting well name as: " + wellName);
                well.getHeader().setWellName(wellName);
                well.getHeader().setWellCode(Well.makeCode(wellName));
                well.getHeader().setWellUnits(this.units);
                this.ws.insertWell(well);
            }
            try {
                if (this.units == 'F') {
                    if (topDepth != null) {
                        topDepth = SB.convToM((double)topDepth, (char)this.units);
                    }
                    if (baseDepth != null) {
                        baseDepth = SB.convToM((double)baseDepth, (char)this.units);
                    }
                }
                if (topDepth != null || baseDepth != null) {
                    Sample sample = well.addSample(topDepth, baseDepth, type, label);
                    System.out.println("Sample: " + sample.toString() + " Added to well: " + well);
                    continue;
                }
                System.out.println("Ignored null sample depths");
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception ading sample: " + topDepth + "," + baseDepth + "," + type + " to Well:" + well);
                ex.printStackTrace();
            }
        }
        if (well != null) {
            well.updateStatus(this.dataTypes);
        }
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    boolean parseTitles(Row row) {
        boolean isTitleRow = false;
        for (short i = 0; i <= row.getLastCellNum(); i = (short)(i + 1)) {
            Cell cell = row.getCell((int)i);
            if (cell == null || cell.getCellType() != 1) continue;
            String strg = cell.getStringCellValue();
            if (strg.toUpperCase().startsWith("DEPTH")) {
                if (this.ws.useSampleTops()) {
                    this.topDepthColumn = i;
                } else {
                    this.baseDepthColumn = i;
                }
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("TOP DEPTH") && this.topDepthColumn < 0) {
                this.topDepthColumn = i;
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("BASE DEPTH") && this.baseDepthColumn < 0) {
                this.baseDepthColumn = i;
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("LABEL")) {
                if (this.sampleLabelColumn >= 0) continue;
                this.sampleLabelColumn = i;
                continue;
            }
            if (!strg.equalsIgnoreCase("SAMPLE TYPE") && !strg.equalsIgnoreCase("TYPE") || this.sampleTypeColumn >= 0) continue;
            this.sampleTypeColumn = i;
        }
        return isTitleRow;
    }
}

