/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JOptionPane;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.Audit;
import model2.Discipline;
import model2.Genus;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.WsWell;
import util.SBException;

public class SbugsReader {
    List dataTypes;
    String dataSource;
    static final int WELL = 1;
    static final int FSSABND = 2;
    SBdb ws;
    WsWell well;
    int abnSchID = 1;
    LinkedHashMap abnSchemes = new LinkedHashMap();

    public SbugsReader(String fileName, SBdb ws, List dataTypes, String analyst) throws SBException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            try {
                String buff = in.readLine();
                if (!buff.substring(0, 2).equals("**")) {
                    throw new SBException("Not a StrataBugs format file");
                }
                this.dataSource = buff.substring(25).trim();
                buff = in.readLine();
                if (!buff.substring(0, 1).equals("*")) {
                    throw new SBException("Error reading line :" + buff);
                }
                this.well = new WsWell(ws, fileName);
                boolean hasWellDetails = false;
                while (buff != null) {
                    switch (this.decodeRecordType(buff.substring(1))) {
                        case 1: {
                            buff = this.parseWell(in.readLine(), in);
                            hasWellDetails = true;
                            break;
                        }
                        case 2: {
                            buff = this.parseFssabnd(buff, analyst, in);
                        }
                    }
                }
                if (!hasWellDetails) {
                    this.well.getHeader().setWellName(fileName.substring(0, fileName.lastIndexOf(".")));
                    if (this.well.getHeader().getWellName().length() > 25) {
                        this.well.getHeader().setWellName(this.well.getWellName().substring(this.well.getWellName().length() - 25));
                    }
                }
                this.well.updateStatus(dataTypes);
                ws.getProject(0).addWell(this.well);
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            in.close();
        }
        catch (Exception fnf) {
            JOptionPane.showMessageDialog(null, "Can't open file for some reason - sorry");
            return;
        }
    }

    String parseWell(String buff, BufferedReader in) throws IOException, SBException {
        this.well.getHeader().setWellName(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        this.well.getHeader().setWellCode(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        this.well.getHeader().setOper(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        this.well.getHeader().setCountry(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        this.well.getHeader().setField(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        buff = buff.substring(buff.indexOf(9) + 1);
        buff = buff.substring(buff.indexOf(9) + 1);
        buff = buff.substring(buff.indexOf(9) + 1);
        String strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        long gridX = 0L;
        long gridY = 0L;
        if (strg.length() > 0) {
            gridX = Long.parseLong(strg);
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            gridY = Long.parseLong(strg);
        }
        if (gridX != 0L && gridY != 0L) {
            this.well.getHeader().setGrid(gridX, gridY);
        }
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yy");
        String spudString = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        String compString = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        try {
            this.well.getHeader().setSpud(df.parse(spudString));
            this.well.getHeader().setComp(df.parse(compString));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            this.well.getHeader().setLat(new Double(strg));
        }
        char lat_ind = buff.substring(0, buff.indexOf(9)).trim().charAt(0);
        buff = buff.substring(buff.indexOf(9) + 1);
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        short lat_deg = -1;
        if (strg.length() > 0) {
            lat_deg = Short.parseShort(strg);
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        short lat_min = -1;
        if (strg.length() > 0) {
            lat_min = Short.parseShort(strg);
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        float lat_sec = -1.0f;
        if (strg.length() > 0) {
            lat_sec = Float.parseFloat(strg);
        }
        this.well.getHeader().setLat(lat_deg, lat_min, lat_sec, lat_ind);
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            this.well.getHeader().setLong(new Double(strg));
        }
        char long_ind = buff.substring(0, buff.indexOf(9)).trim().charAt(0);
        buff = buff.substring(buff.indexOf(9) + 1);
        short long_deg = -1;
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            long_deg = Short.parseShort(strg);
        }
        short long_min = -1;
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            long_min = Short.parseShort(strg);
        }
        float long_sec = -1.0f;
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            long_sec = Float.parseFloat(strg);
        }
        this.well.getHeader().setLong(long_deg, long_min, long_sec, long_ind);
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            this.well.getHeader().setTD(Float.parseFloat(strg));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            this.well.getHeader().setSL(Float.parseFloat(strg));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            this.well.getHeader().setSB(Float.parseFloat(strg));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            this.well.getHeader().setRTE(Float.parseFloat(strg));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            this.well.getHeader().setDatum(Integer.parseInt(strg));
        }
        this.well.getHeader().setType(buff.substring(0, buff.indexOf(9)).trim().charAt(0));
        buff = buff.substring(buff.indexOf(9) + 1);
        this.well.getHeader().setWellUnits(buff.substring(0).trim().charAt(0));
        buff = in.readLine();
        return buff;
    }

    String parseFssabnd(String buff, String analyst, BufferedReader in) throws IOException, SBException, Exception {
        char discID = buff.charAt(9);
        Discipline disc = Discipline.getDisc(discID);
        if (disc == null) {
            throw new SBException("Not a valid discipline in line: " + buff);
        }
        buff = in.readLine();
        if (buff.trim().equals("ABNSCHME")) {
            buff = this.parseAbnscheme(disc, in);
        }
        if (buff.trim().startsWith("TAXA")) {
            buff = this.parseTaxa(discID, buff, in);
        }
        if (buff.trim().equals("SAMPLES")) {
            buff = this.parseSamples(discID, analyst, in);
        }
        return buff;
    }

    String parseAbnscheme(Discipline discID, BufferedReader in) throws Exception {
        String buff = in.readLine();
        AbnScheme abnScheme = new AbnScheme(this.abnSchID);
        while (!buff.startsWith("TAXA")) {
            String abr = buff.substring(0, 4).trim();
            if (!abr.equals("+")) {
                abnScheme.addClass(abr, buff.substring(4, 29).trim(), Integer.parseInt(buff.substring(29).trim()), 0);
            }
            buff = in.readLine();
        }
        abnScheme.setName("SbugsReader " + discID.getNoun() + " Scheme");
        this.abnSchemes.put(Character.valueOf(discID.getChar()), this.abnSchID);
        ++this.abnSchID;
        this.ws.addAbnScheme(abnScheme);
        return buff;
    }

    String parseTaxa(char discID, String buff, BufferedReader in) throws IOException, SBException, SQLException {
        int nTaxa = Integer.parseInt(buff.substring(5).trim());
        for (int i = 0; i < nTaxa; ++i) {
            Genus.Builder genBuilder = new Genus.Builder();
            Taxon.Builder txBuilder = new Taxon.Builder();
            String cat_mnem = "";
            buff = in.readLine();
            int donorID = Integer.parseInt(buff.substring(0, buff.indexOf(9)));
            String donorString = buff = in.readLine();
            cat_mnem = this.buffField(buff);
            if ((buff = this.nextField(buff)) != null) {
                genBuilder.qual(0, this.buffField(buff));
                buff = this.nextField(buff);
                if (buff != null) {
                    genBuilder.genusName(this.buffField(buff));
                    buff = this.nextField(buff);
                    if (buff != null) {
                        genBuilder.qual(1, this.buffField(buff));
                        buff = this.nextField(buff);
                        if (buff != null) {
                            genBuilder.qual(2, this.buffField(buff));
                            buff = this.nextField(buff);
                            if (buff != null) {
                                genBuilder.subGenus(this.buffField(buff));
                                buff = this.nextField(buff);
                                if (buff != null) {
                                    genBuilder.qual(3, this.buffField(buff));
                                    buff = this.nextField(buff);
                                    if (buff != null) {
                                        txBuilder.qual(4, this.buffField(buff));
                                        buff = this.nextField(buff);
                                        if (buff != null) {
                                            txBuilder.species(this.buffField(buff));
                                            buff = this.nextField(buff);
                                            if (buff != null) {
                                                txBuilder.qual(5, this.buffField(buff));
                                                buff = this.nextField(buff);
                                                if (buff != null) {
                                                    txBuilder.qual(6, this.buffField(buff));
                                                    buff = this.nextField(buff);
                                                    if (buff != null) {
                                                        txBuilder.subSpecies(this.buffField(buff));
                                                        buff = this.nextField(buff);
                                                        if (buff != null) {
                                                            txBuilder.qual(7, this.buffField(buff));
                                                            buff = this.nextField(buff);
                                                            if (buff != null) {
                                                                txBuilder.author(this.buffField(buff));
                                                                buff = this.nextField(buff);
                                                                if (buff != null && buff.length() > 0) {
                                                                    if (buff.endsWith(".00")) {
                                                                        txBuilder.year((int)Float.parseFloat(buff));
                                                                    } else {
                                                                        txBuilder.year(Integer.parseInt(buff));
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.ws.addTaxon(txBuilder, genBuilder, cat_mnem, donorID, donorString);
        }
        buff = in.readLine();
        return buff;
    }

    String nextField(String buff) {
        if (buff == null) {
            return buff;
        }
        int ind = buff.indexOf(9);
        if (ind >= 0) {
            return buff.substring(buff.indexOf(9) + 1);
        }
        return null;
    }

    String buffField(String buff) {
        if (buff == null) {
            return buff;
        }
        int ind = buff.indexOf(9);
        if (ind >= 0) {
            return buff.substring(0, buff.indexOf(9)).trim();
        }
        return buff;
    }

    String parseSamples(char discID, String analyst, BufferedReader in) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        int gridX = 0;
        int gridY = 0;
        Sample sample = null;
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yy");
        TaxonOcc fss = null;
        this.well.getSamples();
        while (buff != null && buff.length() > 0) {
            if (buff.charAt(0) == 'S') {
                double baseDepth;
                double topDepth = Float.parseFloat(buff.substring(1, buff.indexOf(9)));
                buff = buff.substring(buff.indexOf(9) + 1);
                String sampleType = buff.substring(0, buff.indexOf(9)).trim();
                String strg = (buff = buff.substring(buff.indexOf(9) + 1)).substring(0, buff.indexOf(9)).trim();
                if (strg.length() > 0) {
                    gridX = Integer.parseInt(strg);
                }
                if ((buff = buff.substring(buff.indexOf(9) + 1)).indexOf(9) >= 0) {
                    strg = buff.substring(0, buff.indexOf(9)).trim();
                    if (strg.length() > 0) {
                        gridY = Integer.parseInt(strg);
                    }
                    if (buff.indexOf(9) >= 0) {
                        buff = buff.substring(buff.indexOf(9) + 1);
                        if ((buff = buff.trim()).length() > 0) {
                            baseDepth = Float.parseFloat(buff);
                            if (Math.abs(baseDepth) < (double)0.0029f) {
                                baseDepth = topDepth;
                            }
                        } else {
                            baseDepth = topDepth;
                        }
                    } else {
                        baseDepth = topDepth;
                    }
                } else {
                    baseDepth = topDepth;
                }
                if ((sample = this.well.getSample(topDepth, baseDepth, sampleType, false)) == null) {
                    sample = new Sample(this.ws, this.well.getType(), topDepth, baseDepth, sampleType, "");
                    Sample.insert(this.well.getSamples(), sample, this.well.getWellUnits());
                    this.addDataType(1);
                }
            } else if (buff.charAt(0) == 'D') {
                if (sample == null) {
                    throw new SBException("Sample record missing for line " + buff);
                }
                if (sample.getSmpdtl(discID, analyst, 1) != null) {
                    throw new SBException("Duplicate sample info for discipline: " + discID + " for sample: " + sample.toString());
                }
                AnalystHeader analyHdr = this.well.getAnalystHeader(analyst, discID, 1, true);
                if (this.ws.getAbnSchemes().size() > 0) {
                    analyHdr.setAbnScheme((Integer)this.abnSchemes.get(Character.valueOf(discID)));
                }
                Smpdtl smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), buff.charAt(2) == 'Y' ? Smpdtl.AnalysisType.BARREN : Smpdtl.AnalysisType.ANALYSED);
                if (buff.indexOf(9) >= 0) {
                    buff = buff.substring(buff.indexOf(9) + 1);
                    smpdtl.setPicker(buff.substring(0, buff.indexOf(9)).trim());
                    if (buff.indexOf(9) >= 0) {
                        buff = buff.substring(buff.indexOf(9) + 1);
                        smpdtl.setSource(buff.substring(0, buff.indexOf(9)).trim());
                        if (buff.indexOf(9) >= 0 && (buff = buff.substring(buff.indexOf(9) + 1)).indexOf(9) >= 0) {
                            smpdtl.appendNote(buff.substring(0, buff.indexOf(9)).trim());
                            if (buff.indexOf(9) >= 0) {
                                buff = buff.substring(buff.indexOf(9) + 1);
                            }
                        }
                    }
                }
                sample.insert(smpdtl);
                this.addDataType(SBdb.did2dtype(discID));
            } else if (buff.charAt(0) == 'T') {
                Smpdtl smpdtl;
                if (sample == null) {
                    throw new SBException("Sample record missing for line " + buff);
                }
                Taxon t = this.ws.getTaxon(Integer.parseInt(buff.substring(1, buff.indexOf(9)).trim()));
                if (t == null) {
                    throw new SBException("Cannot find taxon record for line: " + buff);
                }
                boolean reworked = false;
                boolean questionable = false;
                if ((buff = buff.substring(buff.indexOf(9) + 1)).charAt(0) == 'R') {
                    reworked = true;
                }
                if (buff.charAt(1) == '?') {
                    questionable = true;
                }
                TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, t, reworked, questionable, 0);
                if ((buff = this.nextField(buff)) != null) {
                    builder.subjAbund(this.buffField(buff));
                }
                if ((buff = this.nextField(buff)) != null) {
                    try {
                        builder.count(Integer.parseInt(this.buffField(buff)));
                    }
                    catch (NumberFormatException ne) {
                        builder.subjAbund(this.buffField(buff));
                    }
                }
                if ((buff = this.nextField(buff)) != null && buff.length() > 0 && buff.charAt(0) == 'C') {
                    builder.caved(true);
                }
                if ((smpdtl = sample.getSmpdtl(discID, analyst, 1)) == null) {
                    AnalystHeader analyHdr = this.well.getAnalystHeader(analyst, discID, 1, true);
                    if (this.ws.getAbnSchemes().size() > 0) {
                        analyHdr.setAbnScheme((Integer)this.abnSchemes.get(Character.valueOf(discID)));
                    }
                    smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.ANALYSED);
                    sample.insert(smpdtl);
                }
                fss = smpdtl.insertOccurrence(builder, this.well.getWellID(), false);
            } else {
                if (buff.charAt(0) != 'A') break;
                if (fss == null) {
                    throw new SBException("Taxon record null for occurrence detail record: " + buff);
                }
                fss.setPreservation(buff.substring(1, buff.indexOf(9)));
                buff = buff.substring(buff.indexOf(9) + 1);
                fss.setColour(buff.substring(1, buff.indexOf(9)));
                fss.setComment(buff.substring(buff.indexOf(9) + 1));
            }
            buff = in.readLine();
        }
        return buff;
    }

    int decodeRecordType(String buff) {
        if (buff.equals("WELL")) {
            return 1;
        }
        if (buff.startsWith("FSSABND")) {
            return 2;
        }
        return 0;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }
}

