/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.File;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import model2.AbnScheme;
import model2.SBdb;
import model2.Sample;
import model2.SampleLithologyUnit;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Userdef;
import model2.Well;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import util.SBException;

public class SbugsSAXhandler
extends DefaultHandler {
    List<Integer> dataTypes;
    SBdb ws;
    String category;
    boolean genus;
    Taxon taxon;
    Taxon newTaxon;
    AbnScheme abn;
    Well well;
    Sample sample;
    Smpdtl smpdtl;
    SampleLithologyUnit sampLith;
    TaxonOcc taxonOcc;
    Userdef userdef;
    Object lastObject;
    int rowsParsed;
    AttributesImpl myatts;
    String current;
    String genusString;
    String subGenusString;
    String gq1;
    String gq2;
    String gq3;
    String gq4;
    String charString = null;
    StringBuffer lastChars = new StringBuffer();
    boolean foundChars = false;

    public SbugsSAXhandler(SBdb ws, List<Integer> dataTypes) throws SQLException, SBException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        if (ws.getProject(0).getSize() == 0) {
            dataTypes.clear();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.category = null;
        this.genus = false;
        this.rowsParsed = 0;
        this.lastObject = null;
    }

    public int getRowsParsed() {
        return this.rowsParsed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        this.current = rawName;
        if (this.lastObject != null && this.lastObject == this.abn) {
            return;
        }
        if (this.current.compareToIgnoreCase("Category") == 0) {
            if (this.category != null && this.category.compareTo(atts.getValue("cat_mnem")) == 0) return;
            this.category = atts.getValue("cat_mnem");
            return;
        }
        if (this.current.compareTo("Genus") == 0) {
            if (this.category == null) {
                String message = "No category specified for genus";
                throw new SAXException(message);
            }
            this.genus = true;
            return;
        }
        if (this.current.compareTo("Species") == 0) {
            if (!this.genus) {
                String message = "No genus specified for species";
                throw new SAXException(message);
            }
            String specIDString = atts.getValue("ID");
            return;
        }
        if (this.lastObject == null && this.current.compareTo("Well") == 0) {
            try {
                this.well = new Well(this.ws);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            this.lastObject = this.well;
            return;
        }
        if (this.well != null && this.lastObject == this.well && this.current.compareTo("AbundanceScheme") == 0) {
            String discipline = atts.getValue("Discipline");
            if (discipline == null) return;
        }
        if (this.well != null && this.lastObject == this.well && this.current.compareTo("Sample") == 0) {
            this.sample = new Sample(this.ws, this.well.getType());
            this.lastObject = this.sample;
            return;
        } else if (this.sample != null && this.lastObject == this.sample && this.current.compareTo("Analyses") == 0) {
            this.smpdtl = new Smpdtl(this.ws);
            this.lastObject = this.smpdtl;
            return;
        } else if (this.lastObject == this.sample && this.current.compareTo("Lithology") == 0) {
            this.sampLith = null;
            this.lastObject = this.sampLith;
            return;
        } else if (this.lastObject == this.smpdtl && this.current.compareTo("Occurrence") == 0) {
            this.taxonOcc = null;
            this.lastObject = this.taxonOcc;
            return;
        } else if (this.lastObject == null && this.current.compareTo("AbundanceScheme") == 0) {
            this.abn = new AbnScheme();
            this.lastObject = this.abn;
            return;
        } else {
            if (this.current.compareTo("TaxonDictionary") != 0) return;
            this.lastObject = null;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        String chars = this.lastChars.toString().trim();
        if (this.foundChars && chars.length() > 0) {
            this.lastChars.delete(0, this.lastChars.length());
            if (this.lastObject != null && this.lastObject == this.abn) {
                this.abn.parseXML(chars, this.current);
                return;
            }
            if (this.lastObject != null && this.lastObject == this.well) {
                try {
                    this.well.getHeader().parseXML(chars, this.current);
                }
                catch (ParseException ex) {
                    throw new SAXException("Error parsing well date : " + chars);
                }
            }
            if (this.lastObject != null && this.lastObject == this.sample) {
                try {
                    this.sample.parseXML(chars, this.current, this.well.getWellUnits());
                }
                catch (SQLException ex) {
                    throw new SAXException("SQL Error parsing sample data : " + this.current + " : " + chars + " well: " + this.well.getWellName() + " sample: " + this.sample.toString() + "\nMessage: " + ex.getMessage());
                }
                catch (SBException ex) {
                    throw new SAXException("Error parsing sample data : " + this.current + " : " + chars + " well: " + this.well.getWellName() + " sample: " + this.sample.toString() + "\nMessage: " + ex.getMessage());
                }
                catch (ParseException ex) {
                    throw new SAXException("Error parsing sample data : " + this.current + " : " + chars + " well: " + this.well.getWellName() + " sample: " + this.sample.toString() + "\nMessage: " + ex.getMessage());
                }
            }
            if (this.lastObject != null && this.lastObject == this.smpdtl) {
                try {
                    this.smpdtl.parseXML(chars, this.current);
                }
                catch (SQLException ex) {
                    throw new SAXException("SQL Error parsing sanmple : " + ex.getMessage());
                }
                catch (SBException ex) {
                    throw new SAXException("Error parsing sample : " + ex.getMessage());
                }
                catch (ParseException ex) {
                    throw new SAXException("Error parsing analysis date : " + chars);
                }
            }
            if (this.lastObject != null && this.lastObject == this.sampLith) {
                try {
                    this.sampLith.parseXML(chars, this.current);
                }
                catch (SQLException ex) {
                    throw new SAXException("Error parsing sample lithology : " + chars);
                }
                catch (ParseException ex) {
                    throw new SAXException("Error parsing sample lithology : " + chars);
                }
                return;
            }
            if (this.lastObject != null && this.lastObject == this.taxonOcc) {
                try {
                    this.taxonOcc.parseXML(chars, this.current, this.newTaxon);
                }
                catch (SQLException ex) {
                    throw new SAXException("SQL Error parsing TaxonOcc field : " + chars);
                }
                catch (ParseException ex) {
                    throw new SAXException("Error parsing TaxonOcc field : " + chars);
                }
                return;
            }
        }
        this.foundChars = false;
        if (rawName == null) {
            this.current = null;
            return;
        }
        try {
            if (this.lastObject == this.well && rawName.compareTo("Well") == 0) {
                this.lastObject = null;
                try {
                    this.ws.getProject(0).addWell(this.well);
                }
                catch (SQLException ex) {
                    throw new SAXException("SQL Error adding well to project : " + ex.getMessage());
                }
            } else {
                if (this.lastObject == this.taxonOcc && rawName.compareTo("Occurrence") == 0) {
                    throw new UnsupportedOperationException("Attempt to use redundant method from Smpdtl in sbugsSAXHandler");
                }
                if (this.lastObject == this.smpdtl && rawName.compareTo("Analyses") == 0) {
                    switch (this.smpdtl.getDiscID()) {
                        case 'A': {
                            this.addDataType(8);
                            break;
                        }
                        case 'M': {
                            this.addDataType(2);
                            break;
                        }
                        case 'N': {
                            this.addDataType(4);
                            break;
                        }
                        case 'P': {
                            this.addDataType(6);
                        }
                    }
                    this.sample.insert(this.smpdtl);
                    this.lastObject = this.sample;
                } else if (this.lastObject == this.sampLith && rawName.compareTo("Lithology") == 0) {
                    this.sample.sampleLithology.lithology.add(this.sampLith);
                    this.addDataType(21);
                    this.lastObject = this.sample;
                } else if (this.lastObject == this.sample && rawName.compareTo("Sample") == 0) {
                    Sample.insert(this.well.getSamples(), this.sample, this.well.getWellUnits());
                    this.addDataType(1);
                    this.lastObject = this.well;
                }
            }
            ++this.rowsParsed;
        }
        catch (SBException se) {
            this.sample.displayUnits = this.well.getWellUnits();
            throw new SAXException(se.getMessage() + " Sample: " + this.sample.toString());
        }
        catch (SQLException se) {
            this.sample.displayUnits = this.well.getWellUnits();
            throw new SAXException(se.getMessage() + " Sample: " + this.sample.toString());
        }
        if (this.lastObject == this.abn && rawName.compareTo("AbundanceScheme") == 0) {
            this.lastObject = null;
            try {
                this.ws.addAbnScheme(this.abn);
            }
            catch (SBException ex) {
                throw new SAXException("Error adding abundance Scheme : " + ex.getMessage());
            }
            catch (SQLException ex) {
                throw new SAXException("SQL Error adding abundance Scheme : " + ex.getMessage());
            }
        }
        if (rawName.compareTo("Species") == 0) {
            // empty if block
        }
        if (rawName.compareTo("Genus") == 0) {
            this.genus = false;
            this.genusString = null;
            this.subGenusString = null;
            this.gq1 = null;
            this.gq2 = null;
            this.gq3 = null;
            this.gq4 = null;
        } else if (rawName.compareToIgnoreCase("Category") == 0) {
            this.category = null;
        }
        this.current = null;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charString = new String(ch, start, length);
        this.lastChars.append(this.charString);
        this.foundChars = true;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public static String convertToFileURL(String filename) {
        String path = new File(filename).getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return "file:" + path;
    }

    String getGenusString() {
        String chars = new String();
        if (this.genusString != null) {
            chars = chars + this.genusString;
        }
        if (this.subGenusString != null) {
            chars = chars + " (" + this.subGenusString + ")";
        }
        return chars;
    }
}

