/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.zip.ZipFile;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.Audit;
import model2.ImageSet;
import model2.SBdb;
import model2.Sample;
import model2.Taxon;
import model2.TaxonCompareAlphaCode;
import model2.TaxonCompareCategory;
import model2.TaxonCompareGenus;
import model2.TaxonCompareSpecies;
import model2.TaxonOcc;
import model2.TaxonOccCompare;
import model2.TaxonOccCompareAbund;
import model2.Userdef;
import model2.Well;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SBPrivilegeException;
import util.SbugsCompoundEdit;
import util.SbugsEdit;
import util.SbugsStatus;
import util.SortEntry;

public class Smpdtl
extends Observable
implements SbugsStatus,
SortEntry {
    private final SBdb sbdb;
    private Sample sample;
    Smpdtl link = null;
    Color status = NOTSTORED;
    int donorID;
    private AnalystHeader header;
    private String picker;
    private String source;
    private String notes;
    private float weight = 0.0f;
    private float coarse = 0.0f;
    private float medium = 0.0f;
    private float fine = 0.0f;
    private int fov;
    private int proximal;
    private int distal;
    private Audit audit = new Audit();
    private boolean isLoaded = false;
    boolean isStored = false;
    AnalysisType analysisType;
    private final List<TaxonOcc> occur = new LinkedList<TaxonOcc>();

    public AnalystHeader getHeader() {
        return this.header;
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    public int getProximal() {
        return this.proximal;
    }

    public int getDistal() {
        return this.distal;
    }

    public List<TaxonOcc> getOccurUnsorted() {
        return this.occur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TaxonOcc> getUnsortedOccur() {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            return new LinkedList<TaxonOcc>(this.occur);
        }
    }

    int getOccSize() {
        return this.occur.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonOcc> getOccur() {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            Collections.sort(this.occur, new TaxonOccCompare());
        }
        return this.occur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaxonOcc> getOccur(Comparator comp) {
        if (comp == null) {
            try {
                List<TaxonOcc> list = this.occur;
                synchronized (list) {
                    Collections.sort(this.occur, new TaxonOccCompareAbund(this.sbdb.getAbnScheme(this.getHeader().getAbnSchID(), true), new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies()))));
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
        } else {
            List<TaxonOcc> list = this.occur;
            synchronized (list) {
                Collections.sort(this.occur, new TaxonOccCompare(comp));
            }
        }
        return this.occur;
    }

    public List<TaxonOcc> getOccurSorted(SortOrder order) {
        switch (order) {
            case SORT_GENUS: {
                return this.getOccur(new TaxonCompareGenus(new TaxonCompareSpecies()));
            }
            case SORT_CATEGORY: {
                return this.getOccur(new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
            }
            case SORT_ALPHACODE: {
                return this.getOccur(new TaxonCompareAlphaCode(new TaxonCompareGenus(new TaxonCompareSpecies())));
            }
            case SORT_ABUND: {
                return this.getOccur(null);
            }
        }
        return this.getOccur();
    }

    public boolean isAnalysed() {
        return this.analysisType.isAnalysed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillTaxonList(List taxa) {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            Iterator<TaxonOcc> i$ = this.occur.iterator();
            while (i$.hasNext()) {
                TaxonOcc occ;
                TaxonOcc fss = occ = i$.next();
                fss.fillTaxonList(taxa);
            }
        }
    }

    public int getAnalyID() {
        if (this.header == null) {
            throw new NullPointerException("Analyst header null in Smpdtl");
        }
        return this.header.getAnalyID();
    }

    public char getDiscID() {
        return this.header.getDiscID();
    }

    public String getAnalyst() throws SQLException, SBException {
        return this.header.getAnalyst();
    }

    public int getAnalyNo() {
        return this.header.getAnalyNumber();
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public Sample getSample() {
        return this.sample;
    }

    public boolean getBarren() {
        return this.analysisType == AnalysisType.BARREN;
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getCoarse() {
        return this.coarse;
    }

    public float getMedium() {
        return this.medium;
    }

    public float getFine() {
        return this.fine;
    }

    public int getFOV() {
        return this.fov;
    }

    public String getPicker() {
        return this.picker;
    }

    public String getSource() {
        return this.source;
    }

    public String getNotes() {
        return this.notes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSplitCountData() {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc fss : this.occur) {
                if (fss.getCoarse() <= 0 && fss.getFine() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCount() {
        int total = 0;
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc occ : this.occur) {
                total += occ.getTotalCount();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCount(boolean excludeRwCv) {
        int total = 0;
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc occ : this.occur) {
                if (excludeRwCv && (occ.getCaved() || occ.getReworked())) continue;
                total += occ.getTotalCount();
            }
        }
        return total;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public String toString() {
        if (this.audit.modified == null) {
            return "";
        }
        return SB.df.format(this.audit.modified);
    }

    public String getOccurString(Taxon t) {
        String strg = "";
        for (TaxonOcc occ : this.getOccurUnsorted()) {
            if (occ.getTaxon().getSpecID() != t.getSpecID()) continue;
            if (!strg.isEmpty()) {
                strg = strg + "; ";
            }
            strg = strg + occ.toAbnString();
        }
        return strg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String hasSemiQuantData(String semiQuant) {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (int i = 0; i < this.occur.size(); ++i) {
                TaxonOcc fss = this.occur.get(i);
                if (fss.getSubAbund() == null || fss.getSubAbund().length() <= 0) continue;
                if (semiQuant == null) {
                    semiQuant = fss.getSubAbund();
                    continue;
                }
                if (semiQuant.contains(fss.getSubAbund())) continue;
                semiQuant = semiQuant + "," + fss.getSubAbund();
            }
        }
        return semiQuant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSemiQuantData() {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc fss : this.occur) {
                if (fss.getSubAbund().isEmpty() || fss.getTotalCount() != 0) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasEnvData() {
        return this.proximal > 0 || this.distal > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSpecies(int specID) {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc occ : this.occur) {
                TaxonOcc fss = occ;
                if (fss.getTaxon().getSpecID() != specID) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveOccs(int wellID, Smpdtl newSmpdtl) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET samp_id=" + newSmpdtl.sample.getSampID() + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND analy_id=" + this.header.getAnalyID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            List<TaxonOcc> list = newSmpdtl.occur;
            synchronized (list) {
                newSmpdtl.occur.clear();
                newSmpdtl.occur.addAll(this.occur);
            }
            newSmpdtl.isLoaded = true;
            newSmpdtl.isStored = true;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonOcc getFss(Taxon taxon, boolean reworked, char identType, int specType) {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc f : this.occur) {
                if (f.getTaxon() != taxon && f.getTaxon().getSpecID() != taxon.getSpecID() || f.getIdentType() != identType || f.getReworked() != reworked || f.getSpecType() != specType) continue;
                return f;
            }
        }
        return null;
    }

    public void setProximal(int proximal) {
        this.proximal = proximal;
    }

    public void setDistal(int distal) {
        this.distal = distal;
    }

    public void setPicker(String picker) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set smpdtl picker when connected to database");
        }
        this.picker = picker;
    }

    public void setSource(String source) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set smpdtl source when connected to database");
        }
        this.source = source;
    }

    public void setWeight(SBdb sbdb, int wellID, float weight) throws SQLException, SBException {
        if (sbdb == null || !sbdb.isConnected()) {
            throw new SBException("Attempt to set smpdtl weight not connected to database");
        }
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + sbdb.DBTableName("SMPDTL") + " SET weight=" + weight + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND analy_id=" + this.header.getAnalyID();
        stmt.executeUpdate(sbdb.modQuery(sql));
        this.weight = weight;
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUndoableEdit setBarren(int wellID, boolean barren) throws SBException, SQLException {
        if (barren && this.analysisType == AnalysisType.BARREN) {
            return null;
        }
        if (!barren && this.analysisType != AnalysisType.BARREN) {
            return null;
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit((!barren ? "un" : "") + "set barren");
        if (barren && !this.occur.isEmpty()) {
            List<TaxonOcc> list = this.occur;
            synchronized (list) {
                edit.addEdit((UndoableEdit)this.deleteOccs(wellID, this.occur));
            }
        }
        OccBarren occBarren = new OccBarren(wellID, barren);
        occBarren.doEdit();
        edit.addEdit((UndoableEdit)((Object)occBarren));
        edit.end();
        return edit;
    }

    void updateBarren(int wellID, AnalysisType analysisType) throws SQLException, SBPrivilegeException {
        if (this.analysisType != analysisType) {
            if (analysisType == AnalysisType.BARREN && this.occur.size() > 0) {
                this.deleteOccs(wellID, true);
            }
            if (this.sbdb.getDatabase() != null) {
                Audit temp = new Audit(this.audit);
                Statement stmt = this.sbdb.getDatabase().createStatement();
                String sql = "UPDATE " + this.sbdb.DBTableName("SMPDTL") + " SET barren=" + analysisType.getDBString() + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND analy_id=" + this.header.getAnalyID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                this.audit = temp;
                this.analysisType = analysisType;
                stmt.close();
                this.setChanged();
            }
        }
    }

    void setSample(Sample sample) throws SBException, SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to reset sample for smpdtl: " + this);
        }
        this.sample = sample;
    }

    void setSample(Sample sample, boolean override) {
        this.sample = sample;
    }

    void appendNote(String comment) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to append note for smpdtl: " + this);
        }
        this.notes = this.notes == null || this.notes.length() == 0 ? comment : this.notes + " " + comment;
    }

    Smpdtl(SBdb SB2) {
        this.sbdb = SB2;
    }

    Smpdtl(SBdb SB2, Sample sample, AnalystHeader header, String picker, String source, String notes, int proximal, int distal, int fov, float weight, float coarse, float medium, float fine, Audit audit, AnalysisType analysisStatus) throws SBException {
        this.header = header;
        this.sbdb = SB2;
        this.sample = sample;
        this.picker = picker;
        this.source = source;
        this.notes = notes;
        this.proximal = proximal;
        this.distal = distal;
        this.fov = fov;
        this.weight = weight;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.audit = audit;
        this.analysisType = analysisStatus;
    }

    Smpdtl(SBdb SB2, Sample sample, AnalystHeader header, String picker, String source, String notes, AnalysisType analysisStatus, int proximal, int distal, int fov, float weight, float coarse, float medium, float fine, int wellID) throws SQLException, SBException {
        this.header = header;
        this.sbdb = SB2;
        this.sample = sample;
        this.picker = picker;
        this.source = source;
        this.notes = notes;
        this.audit.modified = new Date();
        this.audit.modifier = SB2.user.getUsrID();
        this.proximal = proximal;
        this.distal = distal;
        this.weight = weight;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.fov = fov;
        this.analysisType = analysisStatus;
        this.store(null, wellID, sample.getSampID(), header.getAnalyID());
    }

    public Smpdtl(Statement stmt, SBdb SB2, int wellID, int sampID, int analyID, String picker, String source, Userdef modifier, Date modified, AnalysisType analysisStatus, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal, int fov) throws SQLException, SBException, FileNotFoundException, IOException {
        this.sbdb = SB2;
        this.picker = picker;
        this.source = source;
        this.notes = notes;
        this.audit.modified = modified;
        if (modifier != null) {
            this.audit.modifier = modifier.getUsrID();
        }
        this.audit.created = modified;
        this.audit.creator = this.audit.modifier;
        this.analysisType = analysisStatus;
        this.proximal = proximal;
        this.distal = distal;
        this.weight = weight;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.fov = fov;
        this.store(stmt, wellID, sampID, analyID);
    }

    Smpdtl(SBdb SB2, int wellID, Sample sample, AnalystHeader header) throws SQLException, SBException {
        this.sbdb = SB2;
        String sql = "SELECT picker,source,barren,notes,proximal,distal,weight,coarse,medium,fine,fov," + Audit.sqlFieldString();
        sql = sql + " FROM " + SB2.DBTableName("SMPDTL") + " WHERE well_id=" + wellID + " AND samp_id=" + sample.getSampID() + " AND analy_id=" + header.getAnalyID();
        Statement stmt = SB2.getDatabase().createStatement();
        sql = SB2.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            this.sample = sample;
            this.header = header;
            this.picker = rs.getString("picker");
            this.source = rs.getString("source");
            this.analysisType = AnalysisType.getTypeFromDB(rs.getString("barren"));
            this.notes = rs.getString("notes");
            this.proximal = rs.getInt("proximal");
            this.distal = rs.getInt("distal");
            this.weight = rs.getFloat("weight");
            this.coarse = rs.getFloat("coarse");
            this.medium = rs.getFloat("medium");
            this.fine = rs.getFloat("fine");
            this.fov = rs.getInt("fov");
            this.audit = new Audit(rs);
            this.load(wellID);
        }
        rs.close();
        stmt.close();
    }

    Smpdtl(SBdb db, Well well, Sample sample, Element xml, List<Integer> dataTypes, ZipFile zip) throws SBException, SQLException, ParseException {
        this.sbdb = db;
        this.sample = sample;
        String strgID = xml.getChildTextNormalize("AnalysisID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int analyID = Integer.parseInt(strgID);
        this.header = well.getAnalystHeader(analyID, false);
        if (!dataTypes.contains(SBdb.did2dtype(this.header.getDiscID()))) {
            dataTypes.add(SBdb.did2dtype(this.header.getDiscID()));
        }
        if (this.header == null) {
            throw new SBException("No analyst header for analysis: " + analyID + " In smpdtl constructor");
        }
        String strg = xml.getChildTextNormalize("AnalysisType");
        if (strg != null) {
            this.analysisType = AnalysisType.parseType(strg);
        }
        if ((strg = xml.getChildTextNormalize("Picker")) != null) {
            this.picker = strg;
        }
        if ((strg = xml.getChildTextNormalize("Source")) != null) {
            this.source = strg;
        }
        if ((strg = xml.getChildTextNormalize("Notes")) != null) {
            this.notes = strg;
        }
        if ((strg = xml.getChildTextNormalize("FieldsOfView")) != null) {
            this.fov = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("Weight")) != null) {
            this.weight = Float.parseFloat(strg);
        }
        if ((strg = xml.getChildTextNormalize("CoarseFraction")) != null) {
            this.coarse = Float.parseFloat(strg);
        }
        if ((strg = xml.getChildTextNormalize("MediumFraction")) != null) {
            this.medium = Float.parseFloat(strg);
        }
        if ((strg = xml.getChildTextNormalize("FineFraction")) != null) {
            this.fine = Float.parseFloat(strg);
        }
        if ((strg = xml.getChildTextNormalize("Proximal")) != null) {
            this.proximal = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("Distal")) != null) {
            this.distal = Integer.parseInt(strg);
        }
        Iterator it = xml.getDescendants((Filter)new ElementFilter("Occurrence"));
        while (it.hasNext()) {
            this.occur.add(TaxonOcc.parse(db, (Element)it.next(), zip));
        }
        Element el = xml.getChild("Audit");
        if (el != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for analysis: " + this);
        }
    }

    public Smpdtl(SBdb ws, Smpdtl smpdtl, Sample wsSample, AnalystHeader wsHeader) throws SBException, SQLException, FileNotFoundException, IOException {
        this.copyPrimitives(smpdtl);
        this.sbdb = ws;
        this.header = wsHeader;
        this.audit = new Audit(smpdtl.audit);
        this.sample = wsSample;
        for (TaxonOcc occ : smpdtl.occur) {
            this.occur.add(TaxonOcc.copyToWorkspace(ws, occ));
        }
        this.audit.fillWorkspace(smpdtl.sbdb, this.sbdb);
        this.link = smpdtl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Smpdtl(Statement stmt, SBdb db, SBdb ws, Smpdtl wsDtl, int wellID, int sampID, AnalystHeader hdr) throws SQLException, SBException, FileNotFoundException, IOException {
        this.copyPrimitives(wsDtl);
        this.sbdb = db;
        this.header = hdr;
        this.sample = db.getProject(0).getWell(db, wellID).getSample(sampID);
        this.audit = new Audit(db, ws, wsDtl.audit);
        boolean stmtCreated = false;
        if (stmt == null) {
            stmt = db.getDatabase().createStatement();
            stmtCreated = true;
        }
        this.store(stmt, wellID, sampID, hdr.getAnalyID());
        if (stmtCreated) {
            stmt.close();
        }
        this.analysisType = wsDtl.analysisType;
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc occ : wsDtl.occur) {
                this.analysisType = AnalysisType.ANALYSED;
                this.occur.add(TaxonOcc.copyToDatabase(db, wellID, sampID, hdr.getAnalyID(), occ, db.getAddSpecType(ws.getSpecType(occ.getSpecType())), db.getAbnScheme(this.header.getAbnSchID(), false)));
            }
        }
        this.isLoaded = true;
        this.isStored = true;
    }

    final void copyPrimitives(Smpdtl rhs) throws SBException, SQLException {
        this.picker = rhs.picker;
        this.source = rhs.source;
        this.notes = rhs.notes;
        this.analysisType = rhs.analysisType;
        this.proximal = rhs.proximal;
        this.distal = rhs.distal;
        this.weight = rhs.weight;
        this.coarse = rhs.coarse;
        this.medium = rhs.medium;
        this.fine = rhs.fine;
        this.fov = rhs.fov;
    }

    public void copyAll(Smpdtl rhs) throws SBException, SQLException {
        this.copyPrimitives(rhs);
        this.header = rhs.header;
        this.sample = rhs.sample;
        this.audit = rhs.audit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOccs(Smpdtl rhs) throws SBException, SQLException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            this.occur.clear();
            this.occur.addAll(rhs.occur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOccs(List<TaxonOcc> occs) throws SBException, SQLException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            this.occur.clear();
            this.occur.addAll(occs);
        }
    }

    static PreparedStatement getLoadPrepStmt(SBdb db) throws SQLException {
        String sql = "SELECT spec_id,status,ident_type,spec_type_id,abund,medium,coarse,fine,caved,marker,preserv,colour,comments,image_set_id";
        sql = sql + " FROM " + db.DBTableName("TAXONOCC") + " WHERE well_id=? AND analy_id=? AND samp_id=?";
        sql = db.modQuery(sql);
        PreparedStatement pStmt = db.getDatabase().prepareStatement(sql);
        return pStmt;
    }

    public final void load(int wellID) throws SQLException, SBException {
        PreparedStatement pStmt = Smpdtl.getLoadPrepStmt(this.sbdb);
        this.load(wellID, pStmt);
        pStmt.close();
    }

    void load(int wellID, PreparedStatement pStmt) throws SQLException, SBException {
        if (this.isLoaded) {
            return;
        }
        pStmt.setInt(1, wellID);
        pStmt.setInt(2, this.header.getAnalyID());
        pStmt.setInt(3, this.sample.getSampID());
        ResultSet rs = pStmt.executeQuery();
        while (rs.next()) {
            this.analysisType = AnalysisType.ANALYSED;
            int specID = rs.getInt("spec_id");
            String strg = rs.getString("status");
            boolean reworked = false;
            if (strg != null && strg.compareToIgnoreCase("R") == 0) {
                reworked = true;
            }
            char identType = rs.getString("ident_type").charAt(0);
            int specType = rs.getInt("spec_type_id");
            strg = rs.getString("abund");
            String subjAbund = strg != null ? strg : "";
            int counts = rs.getInt("medium");
            int fsscoarse = rs.getInt("coarse");
            int fssfine = rs.getInt("fine");
            strg = rs.getString("caved");
            boolean caved = false;
            if (strg != null && (strg.equalsIgnoreCase("C") || strg.equalsIgnoreCase("Y"))) {
                caved = true;
            }
            strg = rs.getString("marker");
            boolean marker = false;
            if (strg != null && strg.compareToIgnoreCase("Y") == 0) {
                marker = true;
            }
            String preservation = rs.getString("preserv");
            String colour = rs.getString("colour");
            String comment = rs.getString("comments");
            int imageSetID = rs.getInt("image_set_id");
            TaxonOcc.Builder builder = new TaxonOcc.Builder(this.sbdb, this.sbdb.getTaxon(specID), reworked, identType == '?', specType);
            builder.count(fsscoarse, counts, fssfine).subjAbund(subjAbund).caved(caved).marker(marker);
            builder.preservation(preservation).colour(colour).comment(comment).imageSet(new ImageSet(this.sbdb, imageSetID));
            this.insertOccurrence(builder, wellID, false);
        }
        this.isStored = true;
        this.isLoaded = true;
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void store(Statement stmt, int wellID, int sampID, int analyID) throws SQLException, SBException {
        if (this.status == NOTSTORED) {
            boolean createdStatement = false;
            if (stmt == null) {
                stmt = this.sbdb.getDatabase().createStatement();
                createdStatement = true;
            }
            Audit tempAudit = new Audit(this.audit);
            String sql = "INSERT INTO " + this.sbdb.DBTableName("SMPDTL") + " (well_id,samp_id,analy_id,barren," + Audit.sqlFieldString();
            if (this.picker != null && this.picker.length() > 0) {
                sql = sql + ",picker";
            }
            if (this.source != null && this.source.length() > 0) {
                sql = sql + ",source";
            }
            if ((double)Math.abs(this.weight) > 0.001) {
                sql = sql + ",weight";
            }
            if ((double)Math.abs(this.coarse) > 0.001) {
                sql = sql + ",coarse";
            }
            if ((double)Math.abs(this.medium) > 0.001) {
                sql = sql + ",medium";
            }
            if ((double)Math.abs(this.fine) > 0.001) {
                sql = sql + ",fine";
            }
            if ((double)Math.abs(this.fov) > 0.001) {
                sql = sql + ",fov";
            }
            if (this.notes != null && this.notes.length() > 0) {
                sql = sql + ",notes";
            }
            if (this.proximal > 0) {
                sql = sql + ",proximal,distal";
            }
            sql = sql + ") VALUES (" + wellID + "," + sampID + "," + analyID + "," + this.analysisType.getDBString() + "," + tempAudit.sqlInsert(this.sbdb, stmt);
            if (this.picker != null && this.picker.length() > 0) {
                sql = sql + ",'" + this.picker + "'";
            }
            if (this.source != null && this.source.length() > 0) {
                sql = sql + ",'" + this.source + "'";
            }
            if ((double)Math.abs(this.weight) > 0.001) {
                sql = sql + "," + this.weight;
            }
            if ((double)Math.abs(this.coarse) > 0.001) {
                sql = sql + "," + this.coarse;
            }
            if ((double)Math.abs(this.medium) > 0.001) {
                sql = sql + "," + this.medium;
            }
            if ((double)Math.abs(this.fine) > 0.001) {
                sql = sql + "," + this.fine;
            }
            if ((double)Math.abs(this.fov) > 0.001) {
                sql = sql + "," + this.fov;
            }
            if (this.notes != null && this.notes.length() > 0) {
                sql = sql + "," + SB.DBString((String)this.notes);
            }
            if (this.proximal > 0) {
                sql = sql + "," + this.proximal + "," + this.distal;
            }
            sql = sql + ")";
            sql = this.sbdb.modQuery(sql);
            if (createdStatement) {
                stmt.executeUpdate(sql);
                stmt.close();
            } else {
                stmt.executeUpdate(sql);
            }
            this.audit = tempAudit;
        } else if (this.status == PARTSTORED) {
            this.updateHeader(wellID, this.analysisType, this.picker, this.source, this.notes, this.weight, this.coarse, this.medium, this.fine, this.proximal, this.distal, this.fov);
        }
        boolean toStore = false;
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            int i;
            for (i = 0; i < this.occur.size(); ++i) {
                TaxonOcc fss = this.occur.get(i);
                if (fss.status != TaxonOcc.PARTSTORED && fss.status != TaxonOcc.NOTSTORED) continue;
                toStore = true;
                break;
            }
            if (toStore) {
                this.deleteOccs(wellID, false);
                for (i = 0; i < this.occur.size(); ++i) {
                    TaxonOcc fss = this.occur.get(i);
                    fss.store(stmt, wellID, this.sample.getSampID(), analyID, this.sbdb.getAbnScheme(this.header.getAbnSchID(), false));
                }
            }
        }
        this.isStored = true;
        this.status = STORED;
    }

    void update(int wellID, AnalystHeader header, AnalysisType analysisType, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal, int fov) throws SQLException, SBException {
        if (this.sbdb.restrictedToDiscID(this.getHeader().getDiscipline())) {
            throw new SBPrivilegeException("You can only add/edit data within " + this.sbdb.getUser().getDiscipline().getNoun());
        }
        if (this.header.getAnalyID() != header.getAnalyID()) {
            this.updateKey(wellID, header);
            this.header = header;
        }
        this.updateHeader(wellID, analysisType, picker, source, notes, weight, coarse, medium, fine, proximal, distal, fov);
        this.picker = picker;
        this.source = source;
        this.notes = notes;
        this.audit.modified = new Date();
        this.audit.modifier = this.sbdb.user.getUsrID();
        if (this.analysisType != analysisType) {
            this.updateBarren(wellID, analysisType);
        }
        this.proximal = proximal;
        this.distal = distal;
        this.weight = weight;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.fov = fov;
    }

    public void update(int wellID, Smpdtl ws) throws SBException, SQLException {
        if (this.occur.size() != ws.occur.size()) {
            throw new SBException("Attmept to update smpdtl from workspace when occurrence lists not equal");
        }
        if (ws.analysisType == AnalysisType.BARREN && this.occur.size() > 0) {
            throw new SBException("Attmept to set barren smpdtl from workspace when occurrences exist");
        }
        this.updateHeader(wellID, ws.analysisType, ws.picker, ws.source, ws.notes, ws.weight, ws.coarse, ws.medium, ws.fine, ws.proximal, ws.distal, ws.fov);
        this.picker = ws.picker;
        this.source = ws.source;
        this.notes = ws.notes;
        this.audit.modified = ws.audit.modified;
        this.audit.modifier = this.sbdb.user.getUsrID();
        this.analysisType = ws.analysisType;
        this.proximal = ws.proximal;
        this.distal = ws.distal;
        this.weight = ws.weight;
        this.coarse = ws.coarse;
        this.medium = ws.medium;
        this.fine = ws.fine;
        this.fov = ws.fov;
    }

    private void updateHeader(int wellID, AnalysisType analysisType, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal, int fov) throws SQLException, SBException {
        Audit tempAudit = new Audit(this.audit);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("SMPDTL") + " SET " + tempAudit.sqlUpdate(this.sbdb, stmt, SBdb.preserveAudit) + ",barren=" + analysisType.getDBString() + ",picker='" + (picker != null ? picker.toString() : "") + "'" + ",source='" + (source != null ? source.toString() : "") + "'" + ",weight=" + weight + ",coarse=" + coarse + ",medium=" + medium + ",fine=" + fine + ",fov=" + fov + ",notes=" + SB.DBString((String)(notes != null ? notes.toString() : ""));
        sql = sql + ",proximal=" + proximal + ",distal=" + distal;
        sql = sql + " WHERE samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND analy_id=" + this.header.getAnalyID();
        sql = this.sbdb.modQuery(sql);
        stmt.executeUpdate(sql);
        stmt.close();
        this.audit = tempAudit;
        this.setChanged();
    }

    private void updateKey(int wellID, AnalystHeader header) throws SQLException {
        String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET analy_id=" + header.getAnalyID() + " WHERE samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND analy_id=" + this.header.getAnalyID();
        sql = this.sbdb.modQuery(sql);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        int nRows = stmt.executeUpdate(sql);
        System.out.println("Fss Rows updated: " + nRows);
        sql = "UPDATE " + this.sbdb.DBTableName("SMPDTL") + " SET analy_id=" + header.getAnalyID() + " WHERE samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND analy_id=" + this.header.getAnalyID();
        sql = this.sbdb.modQuery(sql);
        nRows = stmt.executeUpdate(sql);
        System.out.println("Smpdtl Rows updated: " + nRows);
        stmt.close();
        this.setChanged();
    }

    static void delete(SBdb SB2, int wellID, int sampID, int analyID) throws SQLException {
        if (sampID == 0) {
            return;
        }
        Statement stmt = SB2.getDatabase().createStatement();
        LinkedList<Integer> imgSetIDs = new LinkedList<Integer>();
        String sql = "SELECT image_set_id FROM " + SB2.DBTableName("TAXONOCC") + " WHERE samp_id=" + sampID + " AND well_id=" + wellID + " AND analy_id=" + analyID;
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            imgSetIDs.add(rs.getInt("image_set_id"));
        }
        sql = "DELETE FROM " + SB2.DBTableName("TAXONOCC") + " WHERE samp_id=" + sampID + " AND well_id=" + wellID + " AND analy_id=" + analyID;
        stmt.executeUpdate(SB2.modQuery(sql));
        for (Integer i : imgSetIDs) {
            ImageSet.deleteWithTypeCheck(SB2, i, wellID);
        }
        sql = "DELETE FROM " + SB2.DBTableName("SMPDTL") + " WHERE samp_id=" + sampID + " AND well_id=" + wellID + " AND analy_id=" + analyID;
        stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(int wellID, AnalystHeader newHdr) throws Exception {
        if (this.sbdb.restrictedToDiscID(this.getHeader().getDiscipline())) {
            throw new SBPrivilegeException("You can only add/edit data within " + this.sbdb.getUser().getDiscipline().getNoun());
        }
        Audit tempAudit = new Audit(this.audit);
        AnalystHeader oldHeader = this.header;
        this.header = newHdr;
        try {
            this.status = NOTSTORED;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            List<TaxonOcc> list = this.occur;
            synchronized (list) {
                for (TaxonOcc occ : this.occur) {
                    occ.status = TaxonOcc.STORED;
                }
            }
            this.store(stmt, wellID, this.sample.getSampID(), this.header.getAnalyID());
            String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET " + tempAudit.sqlUpdate(this.sbdb, stmt, false) + ",analy_id=" + newHdr.getAnalyID() + " WHERE samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND analy_id=" + oldHeader.getAnalyID();
            sql = this.sbdb.modQuery(sql);
            stmt.executeUpdate(sql);
            sql = "DELETE FROM " + this.sbdb.DBTableName("SMPDTL") + " WHERE samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND analy_id=" + oldHeader.getAnalyID();
            sql = this.sbdb.modQuery(sql);
            stmt.executeUpdate(sql);
            stmt.close();
            this.audit = tempAudit;
            List<TaxonOcc> list2 = this.occur;
            synchronized (list2) {
                for (TaxonOcc occ : this.occur) {
                    occ.setMoved(tempAudit);
                }
            }
            this.setChanged();
        }
        catch (Exception ex) {
            this.header = oldHeader;
            throw ex;
        }
    }

    private void updateTimestamp(int wellID) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit temp = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("SMPDTL") + " SET " + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND analy_id=" + this.header.getAnalyID();
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        this.audit = temp;
        stmt.close();
    }

    public static int loadAll(SBdb SB2) throws SQLException, SBException {
        int nAnalyses = 0;
        String sql = "SELECT well_id,samp_id,analy_id,picker,source,barren,notes,proximal,distal,fov,weight,coarse,medium,fine," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("SMPDTL");
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            int sampID = rs.getInt("samp_id");
            int analyID = rs.getInt("analy_id");
            String picker = rs.getString("picker");
            String source = rs.getString("source");
            AnalysisType analysisType = AnalysisType.getTypeFromDB(rs.getString("barren"));
            String notes = rs.getString("notes");
            int proximal = rs.getInt("proximal");
            int distal = rs.getInt("distal");
            int fov = rs.getInt("fov");
            float weight = rs.getFloat("weight");
            float coarse = rs.getFloat("coarse");
            float medium = rs.getFloat("medium");
            float fine = rs.getFloat("fine");
            Well well = SB2.getAddWell(wellID);
            Smpdtl dtl = new Smpdtl(SB2, well.getSample(sampID), well.getAnalystHeader(analyID, true), picker, source, notes, proximal, distal, fov, weight, coarse, medium, fine, new Audit(rs), analysisType);
            dtl.status = STORED;
            if (analyID == 0) {
                System.out.println("Analyst null for sample : " + sampID);
            } else if (dtl.sample == null) {
                System.out.println("Sample null for sample ID : " + sampID);
            } else {
                try {
                    dtl.sample.insert(dtl);
                    ++nAnalyses;
                }
                catch (SBException sbe) {
                    System.out.println("Exception inserting smpdtl for well: " + well.getWellName() + ",wellID:" + well.getWellID() + ", sample: " + dtl.sample + " : " + sbe.getMessage());
                }
            }
            well.setAnalysesLoaded();
        }
        return nAnalyses;
    }

    public OccAddDelete insertOccurrence(TaxonOcc.Builder builder, int wellID) throws SBException, SQLException {
        OccAddDelete edit = new OccAddDelete(builder, wellID);
        edit.doEdit();
        this.setChanged();
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaxonOcc insertOccurrence(TaxonOcc.Builder builder, int wellID, boolean store) throws SBException, SQLException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            TaxonOcc occ;
            for (TaxonOcc f : this.occur) {
                if (f.getTaxon() != builder.taxonRef || f.getIdentType() != builder.identType || f.getReworked() != builder.reworked || f.getSpecType() != builder.specType) continue;
                if (store) {
                    throw new SBException("Occurrence of: " + builder.taxonRef + " already exists in sample: " + this.getSample().toString());
                }
                builder = builder.status(CONFLICT);
            }
            if (store) {
                if (this.sbdb.restrictedToDiscID(this.getHeader().getDiscipline())) {
                    throw new SBException("You can only add/edit data within " + this.sbdb.getUser().getDiscipline().getNoun());
                }
                occ = builder.build(null, wellID, this.getSample().getSampID(), this.getAnalyID(), this.sbdb.getAbnScheme(this.getHeader().getAbnSchID(), false));
                this.insert(occ, wellID);
            } else {
                occ = builder.build();
                this.occur.add(occ);
                this.analysisType = AnalysisType.ANALYSED;
            }
            return occ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonOcc insert(TaxonOcc occ, int wellID) throws SQLException, SBPrivilegeException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            this.occur.add(occ);
        }
        this.updateBarren(wellID, AnalysisType.ANALYSED);
        this.isStored = false;
        if (this.sbdb != null && this.sbdb.isConnected() && this.sample.getSampID() > 0) {
            this.updateTimestamp(wellID);
        }
        this.status = MergeStatus.merge((Color)this.status, (Color)occ.status);
        this.setChanged();
        return occ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOccs(int wellID, boolean clearFss) throws SQLException, SBPrivilegeException {
        if (this.sbdb.restrictedToDiscID(this.getHeader().getDiscipline())) {
            throw new SBPrivilegeException("You can only add/edit data within " + this.sbdb.getUser().getDiscipline().getNoun());
        }
        if (this.sample.getSampID() != 0) {
            String sql = "DELETE ";
            sql = sql + " FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE well_id=" + wellID + " AND analy_id=" + this.header.getAnalyID() + " AND samp_id=" + this.sample.getSampID();
            Statement stmt = this.sbdb.getDatabase().createStatement();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.updateTimestamp(wellID);
        }
        if (clearFss) {
            List<TaxonOcc> list = this.occur;
            synchronized (list) {
                this.occur.clear();
            }
            this.setChanged();
        }
    }

    public AbstractUndoableEdit deleteOccs(int wellID, List<TaxonOcc> occs) throws SBException, SQLException {
        String presentationName = "delete" + (occs.size() > 1 ? " " + occs.size() + " occurrences" : " occurrence: " + occs.get(0).toStringNoCat());
        if (this.analysisType == AnalysisType.BARREN) {
            presentationName = "set barren (" + presentationName + ")";
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit(presentationName);
        for (TaxonOcc occ : occs) {
            edit.addEdit((UndoableEdit)((Object)new OccAddDelete(occ, wellID)));
        }
        edit.end();
        edit.doEdits();
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOcc(int wellID, TaxonOcc fss) throws SQLException, SBException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            if (!this.occur.contains(fss)) {
                throw new SBException("Fss not found in smpdtl.delete");
            }
            if (this.sbdb != null && this.sbdb.isConnected()) {
                if (this.sbdb.restrictedToDiscID(this.getHeader().getDiscipline())) {
                    throw new SBPrivilegeException("You can only add/edit data within " + this.sbdb.getUser().getDiscipline().getNoun());
                }
                fss.delete(wellID, this.sample.getSampID(), this.header.getAnalyID());
                this.updateTimestamp(wellID);
            }
            this.occur.remove(fss);
            this.setChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOcc(int wellID, TaxonOcc fss, boolean reworked, boolean questionable, int specType, boolean caved, boolean marker, int coarse, int medium, int fine, String abund, String preserv, String colour, String comment, ImageSet image) throws SBException, SQLException, FileNotFoundException, IOException {
        if (this.sbdb.restrictedToDiscID(this.getHeader().getDiscipline())) {
            throw new SBPrivilegeException("You can only add/edit data within " + this.sbdb.getUser().getDiscipline().getNoun());
        }
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc f : this.occur) {
                if (f == fss || f.getSpecID() != fss.getSpecID() || f.getReworked() != reworked || f.getSpecType() != specType || f.getIdentType() != '?' || !questionable) continue;
                throw new SBException("An occurrence of this type already exists");
            }
        }
        fss.update(wellID, this.header.getAnalyID(), reworked, questionable, specType, caved, marker, coarse, medium, fine, abund, preserv, colour, comment, image, this.sample.getSampID());
        this.updateTimestamp(wellID);
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOcc(Taxon taxon, String field, char newValue, int newSpecType) throws SBException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc fss : this.occur) {
                if (fss.getSpecID() != taxon.getSpecID()) continue;
                if (field != null) {
                    if (field.equalsIgnoreCase("status")) {
                        fss.setReworked(newValue == 'R', true);
                    } else if (field.equalsIgnoreCase("ident_type")) {
                        fss.setIdentType(newValue, true);
                    } else if (field.equalsIgnoreCase("caved")) {
                        fss.setCaved(newValue == 'Y', true);
                    }
                }
                if (newSpecType > -1) {
                    fss.setSpecType(newSpecType);
                }
                this.setChanged();
            }
        }
        return this.hasChanged();
    }

    public AbstractUndoableEdit incrementOcc(int wellID, int sampID, TaxonOcc occ, int field, int factor, boolean quant) throws SQLException, SBException {
        if (this.sbdb.restrictedToDiscID(this.getHeader().getDiscipline())) {
            throw new SBPrivilegeException("You can only add/edit data within " + this.sbdb.getUser().getDiscipline().getNoun());
        }
        SbugsCompoundEdit compoundEdit = new SbugsCompoundEdit((factor > 0 ? "increment" : "decrement") + " occurrence");
        if (quant) {
            if (!occ.getSubAbund().isEmpty()) {
                AbnScheme scheme = this.sbdb.getAbnScheme(this.getHeader().getAbnSchID(), false);
                for (int qFactor = scheme.getIndex(occ.getSubAbund()); qFactor > -1; --qFactor) {
                    compoundEdit.addEdit((UndoableEdit)((Object)new OccIncrementSubjective(wellID, sampID, occ, -1)));
                }
            }
            compoundEdit.addEdit((UndoableEdit)((Object)new OccIncrementNumeric(wellID, sampID, occ, field, factor)));
        } else {
            if (occ.getCoarse() > 0) {
                compoundEdit.addEdit((UndoableEdit)((Object)new OccIncrementNumeric(wellID, sampID, occ, 1, -occ.getCoarse())));
            }
            if (occ.getMedium() > 0) {
                compoundEdit.addEdit((UndoableEdit)((Object)new OccIncrementNumeric(wellID, sampID, occ, 2, -occ.getMedium())));
            }
            if (occ.getFine() > 0) {
                compoundEdit.addEdit((UndoableEdit)((Object)new OccIncrementNumeric(wellID, sampID, occ, 3, -occ.getFine())));
            }
            compoundEdit.addEdit((UndoableEdit)((Object)new OccIncrementSubjective(wellID, sampID, occ, factor)));
        }
        compoundEdit.end();
        compoundEdit.doEdits();
        return compoundEdit;
    }

    public void incremenetOcc(int wellID, TaxonOcc occ, String subjAbund) throws SQLException, SBException {
        occ.setSubjAbund(wellID, this, subjAbund);
        this.updateTimestamp(wellID);
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkSubjAbunds(AbnScheme abnSch) {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc fss : this.occur) {
                if (fss.getSubAbund() == null || fss.getSubAbund().length() <= 0 || fss.getSubAbund().equals("+")) continue;
                if (abnSch == null) {
                    return false;
                }
                if (abnSch.getIndex(fss.getSubAbund()) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeSpecies(int specID) throws SBException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            Iterator<TaxonOcc> fssIter = this.occur.iterator();
            while (fssIter.hasNext()) {
                TaxonOcc fss = fssIter.next();
                if (fss.getSpecID() != specID) continue;
                fssIter.remove();
                this.setChanged();
            }
        }
        return this.hasChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceOccs(int wellID, List<TaxonOcc> occur) throws SQLException, SBException, FileNotFoundException, IOException {
        this.deleteOccs(wellID, true);
        for (TaxonOcc occ : occur) {
            TaxonOcc dbOcc = TaxonOcc.copyToDatabase(this.sbdb, wellID, this.sample.getSampID(), this.header.getAnalyID(), occ, this.sbdb.getAddSpecType(occ.getSpecTypeString()), this.sbdb.getAbnScheme(this.header.getAbnSchID(), false));
            List<TaxonOcc> list = occur;
            synchronized (list) {
                this.occur.add(dbOcc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccs(int wellID, List<TaxonOcc> occur) throws SBException, SQLException, IOException {
        List<TaxonOcc> list = occur;
        synchronized (list) {
            for (TaxonOcc occ : occur) {
                if (occ.status.getRGB() != NOTSTORED.getRGB()) continue;
                TaxonOcc dbOcc = TaxonOcc.copyToDatabase(this.sbdb, wellID, this.sample.getSampID(), this.header.getAnalyID(), occ, this.sbdb.getAddSpecType(occ.getSpecTypeString()), this.sbdb.getAbnScheme(this.header.getAbnSchID(), false));
                this.occur.add(dbOcc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteImageSet(ImageSet imageSet) throws SQLException, SBException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc occ : this.occur) {
                ImageSet set = occ.getImageSet(true);
                if (set == null || set.getID() != imageSet.getID()) continue;
                set.delete();
                occ.clearImageSet();
                this.setChanged();
                this.notifyObservers();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasInSituSpecies(int specID, char flag) {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (int i = 0; i < this.occur.size(); ++i) {
                TaxonOcc fss = this.occur.get(i);
                if (fss.getTaxon().getSpecID() != specID) continue;
                if (flag == 'R' && !fss.getReworked()) {
                    return true;
                }
                if (flag != 'C' || fss.getCaved()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateTaxonRef(Taxon donor, Taxon target) throws SBException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc f1 : this.occur) {
                if (f1.getTaxon() != donor) continue;
                for (TaxonOcc f2 : this.occur) {
                    if (f2.getTaxon() != target || f2.getSpecType() != f1.getSpecType() || f1.getIdentType() != f2.getIdentType() || f1.getReworked() != f2.getReworked()) continue;
                    throw new SBException("Error updating records: " + f1 + " and " + f2);
                }
                f1.setTaxon(target);
                this.setChanged();
            }
        }
        return this.hasChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOcc(TaxonOcc fss) throws SBException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc f : this.occur) {
                if (f == fss) {
                    throw new SBException("TaxonOcc object already exists in TaxonOcc.removeOcc");
                }
                if (f.getSpecID() != fss.getSpecID() || f.getReworked() != fss.getReworked() || f.getSpecType() != fss.getSpecType() || f.getIdentType() != fss.getIdentType()) continue;
                this.occur.remove(f);
                return;
            }
        }
        System.out.println("Fss record not found in TaxonOcc.removeOcc");
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceOcc(int wellID, TaxonOcc fss) throws SBException, SQLException {
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc f : this.occur) {
                if (f == fss) {
                    throw new SBException("TaxonOcc object already exists in TaxonOcc.replaceOcc");
                }
                if (f.getSpecID() != fss.getSpecID() || f.getReworked() != fss.getReworked() || f.getSpecType() != fss.getSpecType() || f.getIdentType() != fss.getIdentType()) continue;
                this.occur.remove(f);
                this.insert(fss, wellID);
                return;
            }
        }
        System.out.println("Fss record not found in TaxonOcc.replaceOcc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceSubjAbund(String donor, String target) {
        if (donor.equals(target)) {
            return;
        }
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc f : this.occur) {
                if (!f.getSubAbund().equals(donor)) continue;
                f.setSubjAbund(target);
                this.setChanged();
            }
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeOcc(Smpdtl donor, Statement stmt, int wellID, int sampID) throws SQLException, SBException, FileNotFoundException, IOException {
        Audit tempAudit = new Audit(this.audit);
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc fDonor : donor.occur) {
                boolean exists = false;
                for (TaxonOcc fTarget : this.occur) {
                    if (!fTarget.getSortEntry().equals(fDonor.getSortEntry())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                fDonor.setMoved(tempAudit);
                fDonor.store(stmt, wellID, sampID, this.header.getAnalyID(), this.sbdb.getAbnScheme(this.header.getAbnSchID(), false));
                this.occur.add(fDonor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeDuplicateOccurrences(AbnScheme abn) throws SBException {
        boolean wasMerger = true;
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            block3: while (wasMerger) {
                wasMerger = false;
                for (TaxonOcc fss1 : this.occur) {
                    if (fss1.getTaxon() == null) {
                        throw new SBException("Null TaxonOcc reference : " + fss1.toString());
                    }
                    Iterator<TaxonOcc> it2 = this.occur.iterator();
                    while (it2.hasNext()) {
                        TaxonOcc fss2 = it2.next();
                        if (fss1 == fss2) continue;
                        if (fss2.getTaxon() == null) {
                            throw new SBException("Null TaxonOcc reference : " + fss2.toString());
                        }
                        if (fss2.getTaxon().getSpecID() != fss1.getTaxon().getSpecID() || fss2.getReworked() != fss1.getReworked() || fss2.getIdentType() != fss1.getIdentType() || fss2.getSpecType() != fss1.getSpecType()) continue;
                        wasMerger = true;
                        fss1.merge(fss2, abn);
                        it2.remove();
                    }
                    if (!wasMerger) continue;
                    continue block3;
                }
            }
            if (wasMerger) {
                this.isStored = false;
            }
        }
    }

    public String getSortEntry() {
        try {
            return this.sample.getSortEntry() + this.header.getAnalyst() + this.header.getAnalyNumber();
        }
        catch (SQLException ex) {
            System.out.println("Exception in Smpdtl.GetSortEntry: " + ex.getMessage());
            ex.printStackTrace();
            return "";
        }
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException, SQLException {
        Smpdtl comp;
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return true;
        }
        return e instanceof Smpdtl && this.sample.isFuncEquivalent((comp = (Smpdtl)e).getSample()) && this.header.getAnalyst().equals(comp.getHeader().getAnalyst()) && this.header.getAnalyNumber() == comp.getHeader().getAnalyNumber();
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public String statusString() {
        return this.toString();
    }

    public Color getStatus() {
        if (this.status == UNKNOWN) {
            this.status = this.sample.getSampID() != 0 ? (this.isStored ? STORED : PARTSTORED) : NOTSTORED;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Color updateStatus(int wellID, int iSampID) throws SQLException, SBException {
        this.status = NOTSTORED;
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (int i = 0; i < this.occur.size(); ++i) {
                TaxonOcc occ = this.occur.get(i);
                if (this.sample.getSampID() == 0) {
                    occ.status = TaxonOcc.NOTSTORED;
                }
                occ.updateStatus(this.occur);
                this.status = MergeStatus.merge((Color)this.status, (Color)occ.status);
            }
        }
        if (iSampID == 0) {
            return this.status;
        }
        String sql = "SELECT picker,source,barren,notes,proximal,distal," + Audit.sqlFieldString();
        sql = sql + " FROM " + this.sbdb.DBTableName("SMPDTL") + " WHERE well_id='" + wellID + "' AND analy_id=" + this.header.getAnalyID() + "' AND samp_id=" + this.sample.getSampID();
        sql = this.sbdb.modQuery(sql);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            this.status = STORED;
            MergeStatus m = new MergeStatus(this.status);
            m.compareStringField("Picker", this.picker, rs.getString("picker"), true);
            m.compareStringField("Source", this.source, rs.getString("source"), true);
            if (this.analysisType != AnalysisType.parseType(rs.getString("barren"))) {
                this.status = CONFLICT;
            }
            m.compareStringField("notes", this.notes, rs.getString("notes"), true);
            m.compareIntField("Proximal", this.proximal, rs.getInt("proximal"));
            m.compareIntField("Distal", this.distal, rs.getInt("distal"));
            if (this.status != CONFLICT) {
                this.audit = new Audit(rs);
            }
        } else {
            this.status = NOTSTORED;
        }
        rs.close();
        if (this.occur.size() > 0) {
            sql = "SELECT spec_id,status,ident_type,species_type,abund,medium,caved,marker";
            sql = sql + " FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE well_id=" + wellID + " AND analy_id=" + this.header.getAnalyID() + " AND samp_id=" + this.sample.getSampID();
            sql = this.sbdb.modQuery(sql);
            rs = stmt.executeQuery(sql);
            List<TaxonOcc> list2 = this.occur;
            synchronized (list2) {
                for (TaxonOcc occ : this.occur) {
                    occ.status = NOTSTORED;
                }
            }
            int numberInDatabase = 0;
            if (rs.next()) {
                throw new SBException("In TaxonOcc::updateStatus");
            }
            stmt.close();
            if (numberInDatabase > this.occur.size()) {
                this.status = CONFLICT;
            } else {
                List<TaxonOcc> list3 = this.occur;
                synchronized (list3) {
                    for (int i = 0; i < this.occur.size(); ++i) {
                        TaxonOcc occ = this.occur.get(i);
                        if (occ.status == CONFLICT) {
                            this.status = CONFLICT;
                            break;
                        }
                        if (this.status != STORED || occ.status != NOTSTORED) continue;
                        this.status = CONFLICT;
                    }
                }
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color updateStatus() {
        if (this.occur.size() == 1) {
            TaxonOcc occ = this.occur.get(0);
            if (this.status == NOTSTORED && occ.getTaxon().getLink() != null) {
                occ.status = TaxonOcc.NOTSTORED;
            }
            return this.status;
        }
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (int i = 0; i < this.occur.size(); ++i) {
                TaxonOcc fss = this.occur.get(i);
                for (int j = 0; j < this.occur.size(); ++j) {
                    if (i == j) continue;
                    TaxonOcc fssCmp = this.occur.get(j);
                    if (fssCmp.getSortEntry().equals(fss.getSortEntry())) {
                        fss.status = TaxonOcc.CONFLICT;
                        this.status = CONFLICT;
                        continue;
                    }
                    if (this.status != NOTSTORED || fss.getTaxon() == null || fss.getTaxon().getLink() == null) continue;
                    fss.status = TaxonOcc.NOTSTORED;
                }
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color updateStatus(Smpdtl smpdtl) throws SQLException, SBException {
        this.status = NOTSTORED;
        MergeStatus m = new MergeStatus(this.status);
        m.compareStringField("Picker", this.picker, smpdtl.picker, true);
        m.compareStringField("Source", this.source, smpdtl.source, true);
        m.compareStringField("Notes", this.notes, smpdtl.notes, true);
        m.compareIntField("Proximal", this.proximal, smpdtl.proximal);
        m.compareIntField("Distal", this.distal, smpdtl.distal);
        m.compareFloatField("Weight", this.weight, smpdtl.weight);
        m.compareFloatField("Coarse", this.coarse, smpdtl.coarse);
        m.compareFloatField("Medium", this.medium, smpdtl.medium);
        m.compareFloatField("Fine", this.fine, smpdtl.fine);
        m.compareFloatField("FOV", (float)this.fov, (float)smpdtl.fov);
        this.status = m.getStatus();
        if (!(this.analysisType == smpdtl.analysisType || this.occur.isEmpty() && smpdtl.analysisType == AnalysisType.BARREN)) {
            this.status = CONFLICT;
        }
        if (this.occur.size() != smpdtl.occur.size()) {
            this.status = CONFLICT;
        }
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (int i = 0; i < this.occur.size(); ++i) {
                TaxonOcc fss = this.occur.get(i);
                fss.updateStatus(smpdtl.occur);
                if (fss.status == CONFLICT) {
                    this.status = CONFLICT;
                }
                if (fss.status != NOTSTORED) continue;
                this.status = CONFLICT;
            }
        }
        if (this.status != CONFLICT && this.status != PARTSTORED) {
            this.status = STORED;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDEX(FileWriter out, LinkedList taxa, SimpleDateFormat df, String eol) throws IOException, SBException, SQLException {
        out.write("Discipline = " + this.header.getDiscipline().getChar() + eol);
        if (this.audit.modified != null) {
            out.write("  Modified : " + df.format(this.audit.modified) + eol);
        }
        if (this.audit.modifier > 0) {
            out.write("  Modifier : " + this.sbdb.getUser(this.audit.modifier).getAbr() + eol);
        }
        if (this.header.getAnalyst().length() > 0) {
            out.write("  Analyst : " + this.header.getAnalystv18() + eol);
        }
        if (this.picker != null && this.picker.length() > 0) {
            out.write("  Picker : " + this.picker.toString() + eol);
        }
        if (this.source != null && this.source.length() > 0) {
            out.write("  Source : " + this.source.toString() + eol);
        }
        if (this.notes != null && this.notes.length() > 0) {
            out.write("  Notes : " + this.notes.toString() + eol);
        }
        if (this.weight > 0.0f) {
            out.write("  Weight : " + this.weight + eol);
        }
        if (this.coarse > 0.0f || this.medium > 0.0f || this.fine > 0.0f) {
            out.write("  Coarse fraction : " + this.coarse + eol);
            out.write("  Medium fraction : " + this.medium + eol);
            out.write("  Fine fraction : " + this.fine + eol);
        }
        if (this.fov > 0) {
            out.write(" Fields of View: " + this.fov + eol);
        }
        if (this.analysisType == AnalysisType.BARREN) {
            out.write("  Analysis : barren" + eol);
        }
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc fss : this.occur) {
                if (fss.getSpecType() > 0) {
                    Taxon.Builder builder = Taxon.Builder.copyOf(fss.getTaxon());
                    String subSpec = fss.getTaxon().getSubSpecies();
                    if (!subSpec.isEmpty()) {
                        subSpec = subSpec + " ";
                    }
                    subSpec = subSpec + fss.getSpecTypeString();
                    builder.subSpecies(subSpec);
                    builder.genus(fss.getTaxon().getGenus()).audit(fss.getTaxon().getAudit());
                    Taxon newTaxon = this.sbdb.getTaxon(builder);
                    newTaxon.setLink(fss.getTaxon());
                    newTaxon.donorOccType = fss.getSpecTypeString();
                    fss.setTaxon(newTaxon);
                }
                out.write("Species = " + fss.getTaxon().toString(true, false, false) + eol);
                if (!taxa.contains(fss.getTaxon())) {
                    taxa.add(fss.getTaxon());
                }
                out.write("  Code : " + fss.getTaxon().getCatMnem() + eol);
                fss.writeDEX(out, eol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedList<Integer> writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SBException, SQLException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        if (this.header.getAnalyID() > 0) {
            out.write(ind + "<AnalysisID>" + this.header.getAnalyID() + "</AnalysisID>\n");
        }
        LinkedList<Integer> userIDs = this.audit.writeXML(out, indent);
        if (this.picker != null && this.picker.length() > 0) {
            out.write(ind + "<Picker>" + this.picker + "</Picker>\n");
        }
        if (this.source != null && this.source.length() > 0) {
            out.write(ind + "<Source>" + this.source + "</Source>\n");
        }
        out.write(ind + "<AnalysisType>");
        out.write(this.analysisType.getString());
        out.write("</AnalysisType>\n");
        if (this.fov > 0) {
            out.write(ind + "<FieldsOfView>" + this.fov + "</FieldsOfView>\n");
        }
        if (this.notes != null && this.notes.length() > 0) {
            out.write(ind + "<Notes>" + SB.getXMLstring((String)this.notes) + "</Notes>\n");
        }
        if ((double)Math.abs(this.weight) > 0.001) {
            out.write(ind + "<Weight>" + this.weight + "</Weight>\n");
        }
        if (this.coarse > 0.0f) {
            out.write(ind + "<CoarseFraction>" + this.coarse + "</CoarseFraction>\n");
        }
        if (this.medium > 0.0f) {
            out.write(ind + "<MediumFraction>" + this.medium + "</MediumFraction>\n");
        }
        if (this.fine > 0.0f) {
            out.write(ind + "<FineFraction>" + this.fine + "</FineFraction>\n");
        }
        if (this.proximal > 0) {
            out.write(ind + "<Proximal>" + this.proximal + "</Proximal>\n");
        }
        if (this.distal > 0) {
            out.write(ind + "<Distal>" + this.distal + "</Distal>\n");
        }
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (int i = 0; i < this.occur.size(); ++i) {
                TaxonOcc fss = this.occur.get(i);
                out.write(ind + "<Occurrence>\n");
                userIDs.addAll(fss.writeXML(out, indent + 3, files));
                out.write(ind + "</Occurrence>\n");
            }
        }
        return userIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSbugs(FileWriter out) throws IOException, SQLException, SBException {
        out.write("D " + (this.analysisType == AnalysisType.BARREN ? "Y" : "N"));
        if (this.header.getAnalyst() != null) {
            out.write(this.header.getAnalyst().toString());
        }
        out.write(9);
        if (this.picker != null) {
            out.write(this.picker.toString());
        }
        out.write(9);
        if (this.source != null) {
            out.write(this.source.toString());
        }
        out.write(9);
        if (this.notes != null) {
            out.write(this.notes.toString());
        }
        out.write(9);
        if (this.audit.modified != null) {
            out.write(SB.df.format(this.audit.modified));
        }
        out.write(10);
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (int i = 0; i < this.occur.size(); ++i) {
                TaxonOcc fss = this.occur.get(i);
                fss.writeSbugs(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for sample: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
        List<TaxonOcc> list = this.occur;
        synchronized (list) {
            for (TaxonOcc occ : this.occur) {
                occ.setAnalyst(analyst);
            }
        }
    }

    void parseXML(String chars, String element) throws ParseException, SBException, SQLException {
        if (element.compareTo("Discipline") == 0) {
            char discID = chars.charAt(0);
        } else if (element.compareTo("Modified") == 0) {
            this.audit.modified = SB.DBdf.parse(chars);
        } else if (element.compareTo("Modifier") == 0) {
            this.audit.modifier = this.sbdb.getUser(chars).getUsrID();
        } else if (element.compareTo("Analyst") == 0) {
            String string = chars;
        } else if (element.compareTo("Picker") == 0) {
            this.picker = chars;
        } else if (element.compareTo("Source") == 0) {
            this.source = chars;
        } else if (element.compareTo("Notes") == 0) {
            this.notes = chars;
        } else if (element.compareTo("Weight") == 0) {
            this.weight = Float.parseFloat(chars);
        } else if (element.compareTo("CoarseFraction") == 0) {
            this.coarse = Float.parseFloat(chars);
        } else if (element.compareTo("MediumFraction") == 0) {
            this.medium = Float.parseFloat(chars);
        } else if (element.compareTo("FineFraction") == 0) {
            this.fine = Float.parseFloat(chars);
        }
    }

    public class OccBarren
    extends SbugsEdit {
        private final boolean barren;
        private final int wellID;

        public OccBarren(int wellID, boolean barren) {
            this.barren = barren;
            this.wellID = wellID;
        }

        public void undo() {
            this.barren(!this.barren);
        }

        public void redo() {
            this.barren(this.barren);
        }

        private void barren(boolean b) {
            try {
                Smpdtl.this.updateBarren(this.wellID, b ? AnalysisType.BARREN : AnalysisType.PREPARED);
            }
            catch (Exception ex) {
                SB.showStackError((String)("Error " + (b == this.barren ? "redoing" : "undoing")), (Exception)ex);
            }
        }

        public void doEdit() throws SBException, SQLException {
            this.barren(this.barren);
        }
    }

    public class OccAddDelete
    extends SbugsEdit {
        private final boolean isAddition;
        private final TaxonOcc.Builder builder;
        private final String presentationName;
        private final int wellID;
        private final AnalysisType origAnalysisType;
        private TaxonOcc occurrence;

        OccAddDelete(TaxonOcc.Builder builder, int wellID) throws SQLException {
            this.isAddition = true;
            this.builder = builder;
            this.wellID = wellID;
            this.presentationName = "new occurrence: " + builder.taxonRef.toString(false, false) + (builder.reworked ? " Rw" : "") + (builder.identType == 'P' ? "" : " ?" + (builder.specType > 0 ? " " + Smpdtl.this.sbdb.getSpecType(builder.specType) : ""));
            this.origAnalysisType = Smpdtl.this.analysisType;
        }

        OccAddDelete(TaxonOcc occ, int wellID) {
            this.isAddition = false;
            this.occurrence = occ;
            this.builder = null;
            this.wellID = wellID;
            this.presentationName = "delete occurrence: " + this.occurrence.toString();
            this.origAnalysisType = AnalysisType.ANALYSED;
        }

        public void undo() {
            try {
                if (this.isAddition) {
                    this.deleteAction();
                } else {
                    this.insertAction();
                }
            }
            catch (Exception sbe) {
                SB.showStackError((String)("Error undoing " + this.presentationName), (Exception)sbe);
            }
        }

        public void redo() {
            try {
                if (this.isAddition) {
                    this.insertAction();
                } else {
                    this.deleteAction();
                }
            }
            catch (Exception e) {
                SB.showStackError((String)("Error redoing " + this.presentationName), (Exception)e);
            }
        }

        private void deleteAction() throws SQLException, SBException {
            Smpdtl.this.deleteOcc(this.wellID, this.occurrence);
            if (this.origAnalysisType != Smpdtl.this.analysisType) {
                Smpdtl.this.updateBarren(this.wellID, this.origAnalysisType);
            }
            this.occurrence.status = SbugsStatus.NOTSTORED;
        }

        private void insertAction() throws SBException, SQLException, FileNotFoundException, IOException {
            if (this.occurrence.hasImageSet()) {
                try {
                    this.occurrence.getImageSet().store();
                }
                catch (FileNotFoundException nfe) {
                    System.out.println("Failed to store SBImage - clearing image set for occurrence: " + this.occurrence.toString());
                    this.occurrence.clearImageSet();
                }
            }
            this.occurrence.store(null, this.wellID, Smpdtl.this.getSample().getSampID(), Smpdtl.this.getAnalyID(), Smpdtl.this.sbdb.getAbnScheme(Smpdtl.this.getHeader().getAbnSchID(), false));
            Smpdtl.this.insert(this.occurrence, this.wellID);
        }

        public boolean canUndo() {
            return this.occurrence != null;
        }

        public boolean canRedo() {
            return this.occurrence != null;
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public void doEdit() throws SBException, SQLException {
            if (this.isAddition) {
                this.occurrence = Smpdtl.this.insertOccurrence(this.builder, this.wellID, true);
            } else {
                this.deleteAction();
            }
        }

        public TaxonOcc getOccurrence() {
            return this.occurrence;
        }
    }

    public class OccIncrementSubjective
    extends Incrementor {
        final boolean incr;

        OccIncrementSubjective(int wellID, int sampID, TaxonOcc occ, int factor) {
            super(wellID, sampID, occ, occ.getTaxon().toString(false, false) + (factor > 0 ? " increment" : " decrement"));
            this.incr = factor > 0;
        }

        public void undo() {
            try {
                this.occ.incrementSubj(!this.incr, this.wellID, this.sampID, Smpdtl.this.getAnalyID(), Smpdtl.this.getHeader().getAbnSchID());
                Smpdtl.this.updateTimestamp(this.wellID);
                Smpdtl.this.setChanged();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error undoing", (Exception)e);
            }
        }

        public void redo() {
            try {
                this.doEdit();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error undoing", (Exception)e);
            }
        }

        public void doEdit() throws SBException, SQLException {
            this.occ.incrementSubj(this.incr, this.wellID, this.sampID, Smpdtl.this.getAnalyID(), Smpdtl.this.getHeader().getAbnSchID());
            Smpdtl.this.updateTimestamp(this.wellID);
            Smpdtl.this.setChanged();
        }
    }

    public class OccIncrementNumeric
    extends Incrementor {
        final int field;
        final int factor;

        OccIncrementNumeric(int wellID, int sampID, TaxonOcc occ, int field, int factor) {
            super(wellID, sampID, occ, occ.getTaxon().toString(false, false) + " " + (factor > 0 ? "+" : "") + factor);
            this.field = field;
            this.factor = factor;
        }

        public void undo() {
            try {
                this.occ.incrementNumeric(this.field, -this.factor, this.wellID, this.sampID, Smpdtl.this.getAnalyID());
                Smpdtl.this.updateTimestamp(this.wellID);
                Smpdtl.this.setChanged();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error undoing", (Exception)e);
            }
        }

        public void redo() {
            try {
                this.doEdit();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error undoing", (Exception)e);
            }
        }

        public void doEdit() throws SBException, SQLException {
            this.occ.incrementNumeric(this.field, this.factor, this.wellID, this.sampID, Smpdtl.this.getAnalyID());
            Smpdtl.this.updateTimestamp(this.wellID);
            Smpdtl.this.setChanged();
        }
    }

    private abstract class Incrementor
    extends SbugsEdit {
        final String presentationName;
        final int wellID;
        final int sampID;
        final TaxonOcc occ;

        Incrementor(int wellID, int sampID, TaxonOcc occ, String presentationName) {
            this.wellID = wellID;
            this.sampID = sampID;
            this.occ = occ;
            this.presentationName = presentationName;
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return this.presentationName;
        }
    }

    public static enum AnalysisType {
        PREPARED(null, "Prepared"),
        ANALYSED("N", "Analysed"),
        BARREN("Y", "Barren");

        private final String type;
        private final String description;

        private AnalysisType(String s, String d) {
            this.type = s;
            this.description = d;
        }

        public String getString() {
            return this.description;
        }

        public static AnalysisType parseType(String type) {
            for (AnalysisType t : AnalysisType.values()) {
                if (!t.description.equalsIgnoreCase(type)) continue;
                return t;
            }
            return PREPARED;
        }

        public static AnalysisType getTypeFromDB(String barrenField) {
            if (barrenField == null) {
                return PREPARED;
            }
            for (AnalysisType t : AnalysisType.values()) {
                if (t.type == null || !t.type.equalsIgnoreCase(barrenField)) continue;
                return t;
            }
            return PREPARED;
        }

        public String getDBString() {
            switch (this) {
                default: {
                    return this.type;
                }
                case ANALYSED: 
                case BARREN: 
            }
            return SB.DBString((String)this.type);
        }

        public boolean isAnalysed() {
            switch (this) {
                default: {
                    return false;
                }
                case ANALYSED: 
                case BARREN: 
            }
            return true;
        }
    }

    public static enum SortOrder {
        SORT_GENUS,
        SORT_CATEGORY,
        SORT_ALPHACODE,
        SORT_ABUND;

    }
}

