/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import model2.SBdb;
import model2.Taxon;
import util.SB;
import util.SBException;

public class Source {
    private String ID;
    private String name;

    public Source(SBdb db, String abr, String name) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "INSERT INTO " + db.DBTableName("source") + " ( source_id, txt ) VALUES (" + SB.DBString((String)abr) + "," + SB.DBString((String)name) + ")";
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
        this.ID = abr;
        this.name = name;
    }

    Source(String ID, String name) {
        this.ID = ID;
        this.name = name;
    }

    public void delete(SBdb db) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "DELETE FROM " + db.DBTableName("txload") + " WHERE source_id =" + SB.DBString((String)this.ID);
        stmt.executeUpdate(db.modQuery(sql));
        sql = "DELETE FROM " + db.DBTableName("envtrn") + " WHERE source_id =" + SB.DBString((String)this.ID);
        stmt.executeUpdate(db.modQuery(sql));
        sql = "DELETE FROM " + db.DBTableName("SOURCE") + " WHERE source_id =" + SB.DBString((String)this.ID);
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
    }

    public void deleteMatch(SBdb db, String txt) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "DELETE FROM " + db.DBTableName("txload") + " WHERE txt=" + SB.DBString((String)txt) + " AND source_id=" + SB.DBString((String)this.ID);
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
    }

    public String getID() {
        return this.ID;
    }

    public int getNEnvs(SBdb db) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        int n = 0;
        String sql = "SELECT count(source_id) AS nEnv FROM " + db.DBTableName("envtrn") + " WHERE source_id=" + SB.DBString((String)this.ID);
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        if (rs.next()) {
            n = rs.getInt("nEnv");
        }
        stmt.close();
        return n;
    }

    public void getTaxon(SBdb db, Statement stmt, Taxon taxon) throws SQLException, SBException {
        boolean deleteStatement = false;
        if (stmt == null) {
            stmt = db.getDatabase().createStatement();
            deleteStatement = true;
        }
        Object taxon2 = null;
        String sql = "SELECT spec_id,occ_type FROM " + db.DBTableName("TXLOAD") + " WHERE ucase(txt)=" + SB.DBString((String)taxon.donorString.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')) + " AND source_id=" + SB.DBString((String)this.ID);
        ResultSet rs = stmt.executeQuery(sql = db.modQuery(sql));
        if (rs.next()) {
            taxon.setLink(db.getTaxon(rs.getInt("spec_id")));
            taxon.setDonorOccType(rs.getString("occ_type"));
        }
        rs.close();
        if (deleteStatement) {
            stmt.close();
        }
    }

    public int getnTxload(SBdb db) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        int n = 0;
        String sql = "SELECT count(source_id) AS n FROM " + db.DBTableName("txload") + " WHERE source_id=" + SB.DBString((String)this.ID);
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        if (rs.next()) {
            n = rs.getInt("n");
        }
        stmt.close();
        return n;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(SBdb db, String name) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        try {
            String sql = "UPDATE " + db.DBTableName("SOURCE") + " SET txt=" + SB.DBString((String)name) + " WHERE source_id=" + SB.DBString((String)this.ID);
            stmt.executeUpdate(sql);
            this.name = name;
        }
        finally {
            stmt.close();
        }
    }

    public static List<Source> getSources(SBdb db) throws SQLException {
        LinkedList<Source> list = new LinkedList<Source>();
        String sql = "SELECT source_id, txt FROM " + db.DBTableName("SOURCE") + " ORDER BY source_id";
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        while (rs.next()) {
            list.add(new Source(rs.getString("source_id"), rs.getString("txt")));
        }
        stmt.close();
        return list;
    }

    public void loadMatches(SBdb db, List<Taxon> taxa, List<String> donor) throws SQLException, SBException {
        String sql = "SELECT spec_id,txt FROM " + db.DBTableName("TXLOAD") + " WHERE source_id=" + SB.DBString((String)this.ID) + " ORDER BY txt";
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        while (rs.next()) {
            taxa.add(db.getTaxon(rs.getInt("spec_id")));
            donor.add(rs.getString("txt"));
        }
        stmt.close();
        if (taxa.size() != donor.size()) {
            throw new SBException("Missing taxon in source match list");
        }
        stmt.close();
    }

    public void storeMatch(SBdb db, Taxon taxon) throws SQLException {
        taxon.storeMatch(this.ID, taxon.getDonorString(), taxon.getDonorOccType(), db);
    }
}

