/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import model2.Audit;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import model2.SurfaceBase;
import model2.Userdef;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class Surface
implements SortEntry,
SbugsStatus,
Comparable,
SurfaceBase {
    private final SBdb db;
    private final int schID;
    private final int surfaceID;
    private String name;
    private double age;
    private double interpAge;
    private SurfaceType type;
    private Audit audit;
    private Color status;
    private int nOccs;
    private Surface link;

    public static Surface convert(Builder builder, int schID) throws SQLException {
        builder.status = Surface.NOTSTORED;
        try {
            return builder.store(schID);
        }
        catch (SBException sbe) {
            throw new IllegalStateException("An unexpected error occurred: " + sbe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface(SBdb sbdb, int surfaceID) throws SQLException, SBException {
        block4: {
            this.name = "";
            this.type = SurfaceType.getDefault();
            this.audit = new Audit();
            this.status = UNKNOWN;
            this.nOccs = -1;
            this.link = null;
            this.db = sbdb;
            Statement stmt = this.db.getDatabase().createStatement();
            String sql = "SELECT sch_id,age,name,type," + Audit.sqlFieldString() + " FROM " + this.db.DBTableName("surface") + " WHERE surface_id=" + surfaceID;
            try {
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                if (rs.next()) {
                    this.schID = rs.getInt("sch_id");
                    this.surfaceID = surfaceID;
                    this.age = rs.getDouble("age");
                    this.name = rs.getString("name");
                    this.type = SurfaceType.values()[rs.getInt("type")];
                    this.audit = new Audit(rs);
                    this.status = STORED;
                    this.setInterpAge(stmt);
                    break block4;
                }
                throw new SBException("No surface found with ID: " + surfaceID);
            }
            finally {
                stmt.close();
            }
        }
    }

    Surface(SBdb ws, int schID, Element xml) throws ParseException, SQLException, SBException {
        Element el;
        this.name = "";
        this.type = SurfaceType.getDefault();
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.nOccs = -1;
        this.link = null;
        this.schID = schID;
        this.db = ws;
        String strg = xml.getChildTextNormalize("SurfaceID");
        if (strg == null) {
            throw new IllegalStateException("Cannot parse Surface with no surface ID");
        }
        this.surfaceID = Integer.parseInt(strg);
        strg = xml.getChildTextNormalize("Name");
        if (strg != null) {
            this.name = strg;
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            this.type = SurfaceType.parseType(strg, SurfaceType.getDefault());
        }
        if ((strg = xml.getChildTextNormalize("Age")) != null) {
            this.age = Double.parseDouble(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for IGDUnit: " + this);
        }
        this.status = NOTSTORED;
    }

    public void copyLink() throws SQLException {
        if (this.db.isConnected()) {
            throw new IllegalStateException("Attempt to copy link in database surface");
        }
        if (this.link == null || this.status != CONFLICT) {
            return;
        }
        this.name = this.link.getName();
        this.type = this.link.type;
        this.age = this.link.getAge();
        this.status = STORED;
    }

    public Surface getLink() {
        return this.link;
    }

    public void setLink(Surface link) {
        this.link = link;
        if (link != null) {
            this.status = STORED;
            if (!this.name.equalsIgnoreCase(link.getName()) || this.type != link.type || Math.abs(this.age - link.getAge()) > 0.001) {
                this.status = CONFLICT;
            }
        } else {
            this.status = NOTSTORED;
        }
    }

    public int getBndDefault() {
        switch (this.type) {
            default: {
                return 3;
            }
            case SB: {
                return 4;
            }
            case TS: 
        }
        return 2;
    }

    private void setInterpAge(Statement stmt) throws SQLException {
        String sql;
        ResultSet rs2;
        this.interpAge = this.age;
        if (this.interpAge < (double)1.0E-7f && (rs2 = stmt.executeQuery(this.db.modQuery(sql = "SELECT u_age,l_age FROM " + this.db.DBTableName("igd_dict") + " WHERE sch_id=" + this.schID + " AND name=" + SB.DBString((String)this.getName())))).next()) {
            double uAge = rs2.getDouble("u_age");
            double lAge = rs2.getDouble("l_age");
            this.interpAge = this.type == SurfaceType.SB ? lAge : (this.type == SurfaceType.MFS ? uAge + (lAge - uAge) / 3.0 : uAge + (lAge - uAge) * 2.0 / 3.0);
        }
    }

    public void store() throws SQLException {
        if (this.status == STORED) {
            return;
        }
        if (!this.db.isConnected()) {
            throw new IllegalStateException("Attempt to store workspace Surface");
        }
        if (this.status == NOTSTORED) {
            this.storeDB();
        } else {
            this.updateDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void storeDB() throws SQLException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "INSERT INTO " + this.db.DBTableName("surface") + " (surface_id,sch_id,age,name,type," + Audit.sqlFieldString() + ") VALUES (" + this.surfaceID + "," + this.schID + "," + this.age + "," + SB.DBString((String)this.name) + "," + this.type.ordinal() + "," + this.audit.sqlInsert(this.db, stmt) + ")";
        try {
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        stmt.close();
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDB() throws SQLException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "UPDATE " + this.db.DBTableName("surface") + " SET age=" + this.age + ",name=" + SB.DBString((String)this.name) + ",type=" + (Object)((Object)this.type) + "," + this.audit.sqlUpdate(this.db, stmt, false) + " WHERE surface_id=" + this.surfaceID;
        try {
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        stmt.close();
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Builder rhs) throws SQLException, SBException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "UPDATE " + this.db.DBTableName("surface") + " SET age=" + rhs.age + ",name=" + SB.DBString((String)rhs.name) + ",type=" + rhs.type.ordinal() + "," + this.audit.sqlUpdate(this.db, stmt, false) + " WHERE surface_id=" + this.surfaceID;
        try {
            int nUpdated = stmt.executeUpdate(this.db.modQuery(sql));
            if (nUpdated != 1) {
                throw new SBException("Could not update surface: " + rhs.name);
            }
        }
        finally {
            stmt.close();
        }
        this.name = rhs.getName();
        this.type = rhs.type;
        this.age = rhs.age;
        this.status = STORED;
    }

    private static Surface load(SBdb sbdb, int surfaceID, Surface surface) throws SQLException, SBException {
        if (surface != null && surface.getSurfaceID() != surfaceID) {
            throw new IllegalArgumentException("Attempt to refresh surface with incorrect ID");
        }
        Surface temp = new Surface(sbdb, surfaceID);
        if (surface != null) {
            surface.age = temp.age;
            surface.name = temp.name;
            surface.type = temp.type;
            surface.audit = new Audit(temp.audit);
        } else {
            surface = temp;
        }
        return surface;
    }

    static Surface refresh(Statement stmt, SBdb SB2, int schID, List<Surface> surfaces) throws SQLException, SBException {
        String sql = "SELECT surface_id,updated FROM " + SB2.DBTableName("surface") + " WHERE sch_id=" + schID;
        sql = SB2.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        Surface notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("surface_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Surface o : surfaces) {
                if (o.getSurfaceID() != key) continue;
                found = true;
                if (time == null || !time.after(o.audit.updated)) break;
                notifier = Surface.load(SB2, key, o);
                break;
            }
            if (found) continue;
            notifier = Surface.load(SB2, key, null);
            notifier.status = STORED;
            Surface.insert(surfaces, notifier);
        }
        if (keys.size() < surfaces.size()) {
            Iterator<Surface> it = surfaces.iterator();
            while (it.hasNext()) {
                Surface o = it.next();
                if (keys.contains(o.getSurfaceID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(SBdb db, int schID, List<Surface> surfaces, IGDScheme scheme) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "SELECT age,name,type," + Audit.sqlFieldString() + ",surface_id FROM " + db.DBTableName("surface") + " WHERE sch_id=" + schID + " ORDER BY surface_id";
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                Builder builder = new Builder(db);
                builder.age(rs.getDouble("age"));
                builder.name(rs.getString("name"));
                builder.type(SurfaceType.values()[rs.getInt("type")]);
                builder.audit(new Audit(rs)).status(STORED);
                Surface surface = builder.build(rs.getInt("surface_id"), schID);
                surface.interpAge = surface.age;
                IGDUnit unit = scheme.findUnit(surface.getName());
                if (surface.interpAge < (double)1.0E-7f && unit != null) {
                    double uAge = unit.getUage();
                    double lAge = unit.getLage();
                    surface.interpAge = surface.type == SurfaceType.SB ? lAge : (surface.type == SurfaceType.MFS ? uAge + (lAge - uAge) / 3.0 : uAge + (lAge - uAge) * 2.0 / 3.0);
                }
                surface.status = STORED;
                Surface.insert(surfaces, surface);
            }
        }
        finally {
            stmt.close();
        }
    }

    static void insert(List<Surface> surfaces, Surface surface) {
        boolean inserted = false;
        int i = 0;
        for (Surface s : surfaces) {
            if (s.getSortEntry().compareTo(surface.getSortEntry()) > 0) {
                surfaces.add(i, surface);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            surfaces.add(surface);
        }
    }

    public int getSchID() {
        return this.schID;
    }

    public IGDScheme getScheme() throws SQLException {
        return this.db.getIGDScheme(this.schID);
    }

    public int getSurfaceID() {
        return this.surfaceID;
    }

    @Override
    public double getAge() {
        if (this.age < (double)1.0E-6f) {
            return this.interpAge;
        }
        return this.age;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getTypeString() {
        return this.type.name();
    }

    public SurfaceType getType() {
        return this.type;
    }

    void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<SurfaceID>" + this.surfaceID + "</SurfaceID>\n");
        out.write(ind + "<Name>" + SB.getXMLstring((String)this.name) + "</Name>\n");
        out.write(ind + "<Type>" + this.getTypeString() + "</Type>\n");
        out.write(ind + "<Age>" + this.age + "</Age>\n");
        this.audit.writeXML(out, indent);
    }

    public void setAge(double age) throws SBException, SQLException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set surface age");
        }
        this.age = age;
    }

    public void setName(String string) throws SQLException, SBException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set surface age");
        }
        this.name = string;
    }

    public int getNoccs(boolean refresh) throws SQLException {
        if (this.nOccs < 0 || refresh) {
            this.nOccs = 0;
            if (this.db != null && this.db.isConnected()) {
                String sql;
                Statement stmt = this.db.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql = "SELECT count(samp_id) AS nOccs FROM " + this.db.DBTableName("SQPICK") + " WHERE surface_id=" + this.surfaceID));
                if (rs.next()) {
                    this.nOccs = rs.getInt("nOccs");
                }
                stmt.close();
            }
        }
        return this.nOccs;
    }

    public String getSortEntry() {
        int ageInt = (int)Math.round(this.age * 1000000.0);
        String sage = "" + ageInt;
        while (sage.length() < 10) {
            sage = '0' + sage;
        }
        return sage + '-' + this.name.toUpperCase();
    }

    public Color getStatus() {
        return this.status;
    }

    void setStatus(Color status) {
        if (status != null) {
            this.status = status;
        }
    }

    public String statusString() {
        return this.name;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Surface)) {
            return 0;
        }
        return this.compareTo((Surface)o);
    }

    public int compareTo(Surface rhs) {
        if (this.getAge() < rhs.getAge()) {
            return -1;
        }
        if (this.getAge() > rhs.getAge()) {
            return 1;
        }
        int comp = this.name.compareTo(rhs.name);
        if (comp == 0) {
            return rhs.type.ordinal() - this.type.ordinal();
        }
        return comp;
    }

    public List<String> getOccs(SBdb SB2) throws SQLException, SBException {
        if (this.surfaceID == 0) {
            return null;
        }
        if (SB2 == null || !SB2.isConnected()) {
            throw new SBException("Attempt to get occurrences when connection is: " + SB2);
        }
        String sql = "SELECT DISTINCT v.well_id,w.well_name,v.well_code FROM " + SB2.DBTableName("SQPICK") + " i," + SB2.DBTableName("WELL_IDENT") + " v," + SB2.DBTableName("WELLS") + " w" + " WHERE i.surface_id=" + this.surfaceID + " AND i.well_id=v.well_id AND v.well_code=w.well_code ORDER BY well_name";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        ArrayList<String> occs = new ArrayList<String>();
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            occs.add(rs.getString("well_name") + "(" + rs.getString("well_code") + ")");
        }
        stmt.close();
        return occs;
    }

    public void setNoccs(int i) {
        this.nOccs = i;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return true;
        }
        if (e instanceof Surface) {
            Surface surface = (Surface)e;
            if (this.name.toUpperCase().equals(surface.getName().toUpperCase())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(Statement stmt) throws SQLException {
        Statement statement = stmt == null ? this.db.getDatabase().createStatement() : stmt;
        String sql = "DELETE FROM " + this.db.DBTableName("SURFACE") + " WHERE surface_id=" + this.surfaceID;
        try {
            statement.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        this.status = NOTSTORED;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for surface: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private Surface(Builder builder, int surfaceID, int schID) {
        this.name = "";
        this.type = SurfaceType.getDefault();
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.nOccs = -1;
        this.link = null;
        this.db = builder.sbdb;
        this.surfaceID = surfaceID;
        this.name = builder.name;
        this.age = builder.age;
        this.type = builder.type;
        this.schID = schID;
        this.status = builder.status;
        this.audit = builder.audit;
    }

    public static class Builder
    implements SurfaceBase {
        private final SBdb sbdb;
        private String name = "";
        private double age;
        private SurfaceType type = SurfaceType.SB;
        private Audit audit = new Audit();
        private Color status = SbugsStatus.UNKNOWN;
        private int nOccs;
        private Surface original;

        public Builder(SBdb sbdb) {
            if (sbdb == null) {
                throw new IllegalArgumentException("Illegal argument to Surface.Builder: sbdb must not be null");
            }
            this.sbdb = sbdb;
        }

        public Builder name(String name) {
            this.name = name != null ? name : "";
            return this;
        }

        public Builder age(double age) {
            if (age >= 0.0) {
                this.age = age;
            }
            return this;
        }

        public Builder type(SurfaceType type) {
            this.type = type;
            return this;
        }

        Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        Builder status(Color status) {
            if (status != null) {
                this.status = status;
            }
            return this;
        }

        private void validateFields() {
            if (this.name.isEmpty()) {
                throw new IllegalStateException("Attempt to build Surface with empty name");
            }
        }

        Surface build(int ID, int schID) {
            if (ID <= 0) {
                throw new IllegalArgumentException("Cannot build Surface with ID " + ID);
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                System.out.println("WARNING: building surface with unknown status...");
            }
            this.validateFields();
            return new Surface(this, ID, schID);
        }

        Surface store(int schID) throws SQLException, SBException {
            Surface surface;
            if (this.original != null) {
                this.validateFields();
                if (!this.name.equals(this.original.name) || Math.abs(this.age - this.original.age) > 0.001 || this.type != this.original.type) {
                    this.original.update(this);
                }
                surface = this.original;
            } else {
                if (!this.sbdb.isConnected()) {
                    throw new IllegalStateException("Attempt to store IGDUnit in workspace");
                }
                this.status = SbugsStatus.NOTSTORED;
                int ID = this.sbdb.nextControl("SURFACE", "SURFACE_ID");
                surface = this.build(ID, schID);
                surface.storeDB();
            }
            return surface;
        }

        public static Builder copyOf(SBdb sbdb, Surface s) throws SQLException, SBException {
            Builder builder = new Builder(sbdb);
            builder.name(s.name).age(s.age).type(s.getType());
            builder.status = SbugsStatus.NOTSTORED;
            if (sbdb == s.db) {
                builder.original = s;
                builder.audit(new Audit(s.audit));
            } else if (!s.db.isConnected() && builder.sbdb.isConnected()) {
                builder.audit(new Audit(builder.sbdb, s.db, s.audit));
            }
            return builder;
        }

        public int getOriginalID() {
            if (this.original != null) {
                return this.original.getSurfaceID();
            }
            return 0;
        }

        public void setNOccs(int nOccs) {
            this.nOccs = nOccs;
        }

        @Override
        public double getAge() {
            return this.age;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getNOccs() {
            return this.nOccs;
        }

        public String getTypeString() {
            return this.type.name();
        }

        public SurfaceType getType() {
            return this.type;
        }

        SBdb getModel() {
            return this.sbdb;
        }

        Audit getAudit() {
            return this.audit;
        }
    }

    public static enum SurfaceType {
        CC(""),
        MFS("TST"),
        TS("LST"),
        SB("HST");

        final String tractName;

        private SurfaceType(String tractName) {
            this.tractName = tractName;
        }

        static SurfaceType getDefault() {
            return SB;
        }

        public static SurfaceType parseType(String name, SurfaceType defaultType) {
            SurfaceType type = defaultType;
            for (SurfaceType t : SurfaceType.values()) {
                if (!name.toUpperCase().contains(t.name()) && !name.toUpperCase().contains(t.tractName) || t == CC) continue;
                return t;
            }
            return type;
        }
    }
}

