/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBEvent;
import model2.SBdb;
import model2.Surface;
import util.InvalidFieldException;
import util.SBException;

public class TSCreatorReader {
    List<TSCScheme> tscSchemes = new LinkedList<TSCScheme>();
    List<TSCCurve> tscCurves = new LinkedList<TSCCurve>();
    SBdb ws;

    public List<TSCScheme> getLists() {
        return this.tscSchemes;
    }

    public List<TSCCurve> getCurves() {
        return this.tscCurves;
    }

    String stripQuotes(String strg) {
        if (strg != null && strg.startsWith("\"") && strg.endsWith("\"")) {
            strg = strg.substring(1, strg.length() - 1);
        }
        return strg;
    }

    public TSCreatorReader(SBdb ws, String fileName) throws IOException, Exception {
        BufferedReader in;
        File file;
        ZipFile zipFile;
        this.ws = ws;
        if (fileName.indexOf("himem") > 0) {
            int nBytes;
            zipFile = new ZipFile(fileName);
            System.out.println("Extracting zip file....");
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            ZipEntry entry = null;
            while (en.hasMoreElements() && !(entry = en.nextElement()).getName().toLowerCase().endsWith("jar")) {
            }
            if (entry == null) {
                throw new Exception("No jar file found in himem jar file");
            }
            InputStream fis = zipFile.getInputStream(entry);
            file = File.createTempFile("TSCreator-2.1", "jar");
            FileOutputStream fos = new FileOutputStream(file);
            byte[] b = new byte[Short.MAX_VALUE];
            while ((nBytes = fis.read(b, 0, b.length)) > 0) {
                fos.write(b, 0, nBytes);
            }
            fos.close();
            System.out.println("...done");
        } else {
            file = new File(fileName);
        }
        if (file.getName().toLowerCase().endsWith("jar")) {
            zipFile = new ZipFile(file);
            in = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipFile.getEntry("default_data.txt"))));
        } else {
            in = new BufferedReader(new FileReader(file));
        }
        String buff = in.readLine();
        if (buff.startsWith("format version")) {
            buff = in.readLine();
        }
        RECORDTYPE readingRecord = RECORDTYPE.NONE;
        boolean readingFAD = false;
        boolean readingLAD = false;
        TSCEventList tscEvent = null;
        TSCBlock tscBlock = null;
        TSCSequence tscSequence = null;
        TSCCurve tscCurve = null;
        String precedingSurfaceName = null;
        while (buff != null) {
            if (buff.length() > 0) {
                if (buff.charAt(0) != '\t') {
                    String[] tok = buff.split("\t", -1);
                    if (tok.length > 2 && !tok[0].equals("FAD") && !tok[0].equals("LAD")) {
                        String[] rgb;
                        String colour;
                        TSCScheme scheme;
                        String dType;
                        int nTok = 0;
                        String name = tok[nTok++];
                        if ((dType = tok[nTok++]) == null) continue;
                        if (dType.equals(":") && !name.equalsIgnoreCase("Chart Title") && !name.equalsIgnoreCase("date")) {
                            String schemeName;
                            scheme = new TSCScheme();
                            scheme.name = name;
                            while (nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0 && !(schemeName = tok[nTok++]).contains("METACOLUMN")) {
                                scheme.columnNames.add(schemeName);
                            }
                            this.tscSchemes.add(scheme);
                        }
                        if (dType.equals("event")) {
                            tscEvent = new TSCEventList();
                            tscEvent.name = name;
                            if (tok.length > 3 && tok[nTok++] != null) {
                                tscEvent.author = tok[nTok];
                            }
                            readingRecord = RECORDTYPE.EVENTS;
                            for (TSCScheme scheme2 : this.tscSchemes) {
                                for (String schemeName : scheme2.columnNames) {
                                    if (!schemeName.equals(tscEvent.name)) continue;
                                    scheme2.columns.add(tscEvent);
                                }
                            }
                        } else if (dType.equals("block")) {
                            readingRecord = RECORDTYPE.BLOCK;
                            tscBlock = new TSCBlock();
                            tscBlock.name = name;
                            if (nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscBlock.width = Float.parseFloat(tok[nTok]);
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0 && (colour = tok[nTok]).contains("/") && (rgb = colour.split("/")).length == 3) {
                                tscBlock.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscBlock.title = tok[nTok];
                            }
                            for (TSCScheme scheme2 : this.tscSchemes) {
                                for (String schemeName : scheme2.columnNames) {
                                    if (!schemeName.equals(tscBlock.name)) continue;
                                    scheme2.columns.add(tscBlock);
                                }
                            }
                        } else if (dType.equals("point")) {
                            readingRecord = RECORDTYPE.POINT;
                            tscCurve = new TSCCurve();
                            tscCurve.name = name;
                            if (nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscCurve.width = Float.parseFloat(tok[nTok]);
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0 && (colour = tok[nTok]).contains("/") && (rgb = colour.split("/")).length == 3) {
                                tscCurve.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscCurve.title = tok[nTok];
                            }
                            this.tscCurves.add(tscCurve);
                        } else if (dType.equals("facies")) {
                            readingRecord = RECORDTYPE.NONE;
                        } else if (dType.equals("sequence")) {
                            precedingSurfaceName = null;
                            readingRecord = RECORDTYPE.SEQUENCE;
                            tscSequence = new TSCSequence();
                            tscSequence.name = name;
                            if (nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscSequence.width = Float.parseFloat(tok[nTok]);
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0 && (colour = tok[nTok]).contains("/") && (rgb = colour.split("/")).length == 3) {
                                tscSequence.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscSequence.title = tok[nTok];
                            }
                            scheme = new TSCScheme();
                            scheme.name = tscSequence.name;
                            scheme.columnNames.add(tscSequence.name);
                            scheme.columns.add(tscSequence);
                            this.tscSchemes.add(scheme);
                        }
                    } else if (readingRecord == RECORDTYPE.EVENTS) {
                        if (buff.trim().equals("FAD")) {
                            readingFAD = true;
                            readingLAD = false;
                        } else if (buff.trim().equals("LAD")) {
                            readingLAD = true;
                            readingFAD = false;
                        } else {
                            readingRecord = RECORDTYPE.NONE;
                        }
                    } else {
                        readingRecord = RECORDTYPE.NONE;
                    }
                } else if (readingRecord == RECORDTYPE.EVENTS && readingFAD) {
                    this.parseEvent(buff, tscEvent.FAD);
                } else if (readingRecord == RECORDTYPE.EVENTS && readingLAD) {
                    this.parseEvent(buff, tscEvent.LAD);
                } else if (readingRecord == RECORDTYPE.BLOCK) {
                    this.parseBlockEntry(buff, tscBlock);
                } else if (readingRecord == RECORDTYPE.SEQUENCE) {
                    precedingSurfaceName = this.parseSurface(buff, tscSequence, precedingSurfaceName);
                } else if (readingRecord == RECORDTYPE.POINT) {
                    this.parsePoint(buff, tscCurve);
                }
            }
            buff = in.readLine();
        }
        in.close();
    }

    private void parseEvent(String buff, List list) throws SBException {
        String[] toks = buff.split("\t", -1);
        if (toks.length < 2) {
            System.out.println("Cannot tokenize: " + buff);
            return;
        }
        int nTok = 1;
        String name = toks[nTok++];
        name = this.stripQuotes(name);
        double age = 0.0;
        if (toks[nTok] != null && toks[nTok].length() > 0) {
            age = Double.parseDouble(toks[nTok]);
        }
        String[] names = name.split("[,;]");
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null || names[i].trim().length() <= 0) continue;
            TSCEvent event = new TSCEvent();
            event.name = names[i].trim();
            event.age = age;
            list.add(event);
        }
    }

    private void parseBlockEntry(String buff, TSCBlock tscBlock) throws SBException {
        String[] rgb;
        String colour;
        String[] toks = buff.split("\t", -1);
        if (toks.length < 2) {
            System.out.println("Cannot tokenize: " + buff);
            return;
        }
        System.out.println("Parsing block entry: " + buff);
        TSCBlockEntry entry = new TSCBlockEntry();
        int nTok = 1;
        String name = toks[nTok++];
        entry.name = this.stripQuotes(name);
        if (entry.name == null || entry.name.length() == 0) {
            System.out.println("Skipping null entry in parseBlockEntry");
        }
        if (toks[nTok] != null && toks[nTok].length() > 0) {
            entry.age = Double.parseDouble(toks[nTok]);
        }
        ++nTok;
        if (toks.length > ++nTok) {
            entry.comment = toks[nTok++];
        }
        if (toks.length > nTok && (colour = toks[nTok++]) != null && colour.length() > 0 && colour.contains("/") && (rgb = colour.split("/")).length == 3) {
            entry.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        tscBlock.entry.add(entry);
    }

    private String parseSurface(String buff, TSCSequence tscSequence, String precedingName) throws SBException {
        String[] rgb;
        String colour;
        String[] toks = buff.split("\t", -1);
        if (toks.length < 2) {
            System.out.println("Cannot tokenize: " + buff);
            return null;
        }
        TSCSurface surface = new TSCSurface();
        int nTok = 1;
        String name = toks[nTok++];
        surface.name = this.stripQuotes(name);
        System.out.println("parsing: " + buff + ", nTok=" + toks.length);
        if (toks[nTok] != null && toks[nTok].length() > 0) {
            surface.type = toks[nTok];
        }
        if (toks[++nTok] != null && toks[nTok].length() > 0) {
            surface.age = Double.parseDouble(toks[nTok]);
        }
        if (toks[++nTok] != null && toks[nTok].length() > 0) {
            surface.magnitude = toks[nTok];
        }
        if (toks.length > ++nTok) {
            surface.comment = toks[nTok++];
        }
        if (toks.length > nTok && (colour = toks[nTok++]) != null && colour.length() > 0 && colour.contains("/") && (rgb = colour.split("/")).length == 3) {
            surface.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        if (surface.name == null || surface.name.length() == 0) {
            surface.name = precedingName != null ? precedingName : "Surface @ " + surface.age;
        }
        tscSequence.entry.add(surface);
        return surface.name;
    }

    private void parsePoint(String buff, TSCCurve tscCurve) throws SBException {
        String[] toks = buff.split("\t", -1);
        if (toks.length < 2) {
            System.out.println("Cannot tokenize: " + buff);
            return;
        }
        TSCPoint point = new TSCPoint();
        int nTok = 1;
        if (toks[nTok] != null && toks[nTok].length() > 0) {
            point.age = Double.parseDouble(toks[nTok]);
        }
        if (toks[++nTok] != null && toks[nTok].length() > 0) {
            point.value = Double.parseDouble(toks[nTok]);
        }
        if (toks.length > nTok) {
            point.comment = toks[nTok++];
        }
        tscCurve.points.add(point);
    }

    static enum RECORDTYPE {
        NONE,
        EVENTS,
        BLOCK,
        SEQUENCE,
        POINT;

    }

    public class TSCPoint {
        double age;
        double value;
        String comment;
    }

    public class TSCCurve {
        String name;
        Color colour;
        float width;
        String title;
        List<TSCPoint> points = new LinkedList<TSCPoint>();

        public String toString() {
            return this.name;
        }
    }

    public class TSCEventList
    extends TSCColumn {
        private String author;
        List<TSCEvent> FAD;
        List<TSCEvent> LAD;

        public TSCEventList() {
            this.FAD = new LinkedList<TSCEvent>();
            this.LAD = new LinkedList<TSCEvent>();
        }

        public String toString() {
            return this.getName() + (this.getAuthor() != null && this.getAuthor().trim().length() > 0 ? " - " + this.getAuthor() : "");
        }

        public boolean needsFilter() {
            for (TSCEvent tscEvent : this.FAD) {
                if (!tscEvent.needsFilter()) continue;
                return true;
            }
            for (TSCEvent tscEvent : this.LAD) {
                if (!tscEvent.needsFilter()) continue;
                return true;
            }
            return false;
        }

        public void filterNames() {
            System.out.println("Filtering names....");
            for (TSCEvent tscEvent : this.FAD) {
                tscEvent.filter();
            }
            for (TSCEvent tscEvent : this.LAD) {
                tscEvent.filter();
            }
        }

        public void removeBlankEvents() {
            TSCEvent tscEvent;
            Iterator<TSCEvent> it = this.FAD.iterator();
            while (it.hasNext()) {
                tscEvent = it.next();
                if (tscEvent.name != null && !tscEvent.name.isEmpty()) continue;
                it.remove();
            }
            it = this.LAD.iterator();
            while (it.hasNext()) {
                tscEvent = it.next();
                if (tscEvent.name != null && !tscEvent.name.isEmpty()) continue;
                it.remove();
            }
        }

        public void getEvents(SBdb ws) throws SQLException, SBException {
            for (TSCEvent tscEvent : this.FAD) {
                if (tscEvent.wsEvent != null || (tscEvent.wsEvent = ws.getSBEvent(tscEvent.name)) != null) continue;
                tscEvent.wsEvent = ws.addSBEvent(new SBEvent.Builder().name(tscEvent.name).isGenerate(true));
            }
            for (TSCEvent tscEvent : this.LAD) {
                if (tscEvent.wsEvent != null || (tscEvent.wsEvent = ws.getSBEvent(tscEvent.name)) != null) continue;
                tscEvent.wsEvent = ws.addSBEvent(new SBEvent.Builder().name(tscEvent.name).isGenerate(true));
            }
        }

        public CompositeStandard getCompositeStandard(List<SBException> exceptions) throws SBException, SQLException {
            CompositeStandardEvent.Builder builder;
            SBEvent dbEvent;
            LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
            Double minAge = null;
            Double maxAge = null;
            for (TSCEvent tscEvent : this.FAD) {
                if (tscEvent.wsEvent == null || (dbEvent = tscEvent.wsEvent.getLink()) == null) continue;
                builder = new CompositeStandardEvent.Builder().event(tscEvent.wsEvent).csu(tscEvent.age);
                if (!tscEvent.wsEvent.isSingle()) {
                    builder.type(SBEvent.EventType.BASE);
                }
                builders.add(builder);
                if (minAge == null || tscEvent.age < minAge) {
                    minAge = tscEvent.age;
                }
                if (maxAge != null && !(tscEvent.age > maxAge)) continue;
                maxAge = tscEvent.age;
            }
            for (TSCEvent tscEvent : this.LAD) {
                if (tscEvent.wsEvent == null || (dbEvent = tscEvent.wsEvent.getLink()) == null) continue;
                builder = new CompositeStandardEvent.Builder().event(tscEvent.wsEvent).csu(tscEvent.age);
                if (!tscEvent.wsEvent.isSingle()) {
                    builder.type(SBEvent.EventType.TOP);
                }
                builders.add(builder);
                if (minAge == null || tscEvent.age < minAge) {
                    minAge = tscEvent.age;
                }
                if (maxAge != null && !(tscEvent.age > maxAge)) continue;
                maxAge = tscEvent.age;
            }
            if (minAge == null) {
                minAge = 0.0;
            }
            if (maxAge == null) {
                maxAge = 0.0;
            }
            try {
                return TSCreatorReader.this.ws.addCompositeStandard(this.name, minAge, maxAge, maxAge, maxAge, true, builders, null);
            }
            catch (InvalidFieldException e) {
                exceptions.add(new SBException(e.getMessage()));
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getAuthor() {
            return this.author;
        }
    }

    public class TSCScheme {
        String name;
        boolean hasColumns = false;
        List<String> columnNames = new LinkedList<String>();
        List<TSCColumn> columns = new LinkedList<TSCColumn>();
        int blockCount = -1;
        int sequenceCount = -1;
        private int igdType = 0;

        public String toString() {
            return this.name + " : " + this.columnNames;
        }

        public List<TSCEventList> getEventLists() {
            for (TSCColumn column : this.columns) {
                System.out.println("Column: " + column.name + " : " + (column instanceof TSCBlock ? "block" : "events"));
            }
            LinkedList<TSCEventList> list = new LinkedList<TSCEventList>();
            for (TSCColumn column : this.columns) {
                if (!(column instanceof TSCEventList)) continue;
                list.add((TSCEventList)column);
            }
            return list;
        }

        public IGDScheme getScheme(SBdb ws) throws SBException, SQLException, Exception {
            if (this.igdType == 0) {
                throw new SBException("No IGD type st for selected scheme");
            }
            IGDScheme scheme = ws.addIGDScheme(this.igdType, this.name);
            scheme.loadUnits();
            for (TSCColumn column : this.columns) {
                if (column instanceof TSCBlock) {
                    TSCBlock block = (TSCBlock)column;
                    if (block.hier <= 0) continue;
                    double topAge = 0.0;
                    for (TSCBlockEntry entry : block.entry) {
                        block14: {
                            if (entry.name.equals("TOP")) {
                                topAge = entry.age;
                                continue;
                            }
                            String entryName = entry.name.trim();
                            if (entryName == null || entryName.length() == 0) {
                                topAge = entry.age;
                                continue;
                            }
                            IGDUnit unit = scheme.findUnit(entryName);
                            if (unit != null && unit.getHier() == block.getHier()) {
                                IGDUnit higher = scheme.findUnit(topAge, entry.age, block.getHier() - 1);
                                entryName = higher == null ? this.makeUniqueName(scheme, entryName, topAge, entry) : higher.getName() + " " + entry.name;
                                unit = scheme.findUnit(entryName);
                                if (unit != null) {
                                    System.out.println("Duplicate unit name found for: " + unit.getName());
                                    topAge = entry.age;
                                    continue;
                                }
                            } else if (unit != null) {
                                entryName = this.makeUniqueName(scheme, entryName, topAge, entry);
                            }
                            System.out.println("Inserting unit: " + entryName);
                            try {
                                scheme.addUnit(new IGDUnit.Builder(ws).hier(block.getHier()).name(entryName).age(topAge, entry.age).colour(block.colour).colour(entry.colour));
                            }
                            catch (IllegalStateException ils) {
                                if (JOptionPane.showConfirmDialog(null, ils.toString() + "\nIgnore unit and continue reading?", "Error adding unit to scheme", 0, 2) != 1) break block14;
                                throw new SBException("Reading cancelled");
                            }
                        }
                        topAge = entry.age;
                    }
                    continue;
                }
                if (!(column instanceof TSCSequence)) continue;
                TSCSequence sequence = (TSCSequence)column;
                for (TSCSurface surface : sequence.entry) {
                    Surface.Builder b = new Surface.Builder(ws).name(surface.name).age(surface.age).type(Surface.SurfaceType.parseType(surface.name, Surface.SurfaceType.SB));
                    if (!surface.name.contains(surface.type)) {
                        b.name(surface.name + " " + surface.type);
                    }
                    scheme.addSurface(b);
                }
            }
            return scheme;
        }

        String makeUniqueName(IGDScheme scheme, String entryName, double topAge, TSCBlockEntry entry) throws SQLException {
            IGDUnit unit;
            System.out.println("Duplicate unit name, and no higher level entry found at: " + entryName + " ages(s): " + topAge + " & " + entry.age);
            int uniqueNo = 1;
            while ((unit = scheme.findUnit(entryName)) != null && uniqueNo < 100) {
                entryName = entry.name + " (" + uniqueNo++ + ")";
            }
            return entryName;
        }

        public int getBlockCount() {
            if (this.blockCount < 0) {
                this.blockCount = this.initBlockCount();
            }
            return this.blockCount;
        }

        public int getSequenceCount() {
            if (this.sequenceCount < 0) {
                this.sequenceCount = this.initSequenceCount();
            }
            return this.sequenceCount;
        }

        public TSCBlock getBlock(int row) {
            int index = 0;
            for (TSCColumn column : this.columns) {
                if (!(column instanceof TSCBlock)) continue;
                if (row == index) {
                    return (TSCBlock)column;
                }
                ++index;
            }
            return null;
        }

        private int initBlockCount() {
            int count = 0;
            for (TSCColumn column : this.columns) {
                if (!(column instanceof TSCBlock)) continue;
                ++count;
            }
            return count;
        }

        private int initSequenceCount() {
            int count = 0;
            for (TSCColumn column : this.columns) {
                if (!(column instanceof TSCSequence)) continue;
                ++count;
            }
            return count;
        }

        public void setIGDType(int igdType) {
            this.igdType = igdType;
        }
    }

    public class TSCSequence
    extends TSCColumn {
        String author;
        Color colour;
        String title;
        List<TSCSurface> entry;

        public TSCSequence() {
            this.entry = new LinkedList<TSCSurface>();
        }

        public String toString() {
            return this.name;
        }
    }

    public class TSCBlock
    extends TSCColumn {
        String author;
        Color colour;
        String title;
        int hier;
        List<TSCBlockEntry> entry;

        public TSCBlock() {
            this.hier = 0;
            this.entry = new LinkedList<TSCBlockEntry>();
        }

        public String toString() {
            return this.name;
        }

        public int getHier() {
            return this.hier;
        }

        public void setHier(int i) {
            this.hier = i;
        }
    }

    public abstract class TSCColumn {
        String name;
        float width;
    }

    public class TSCSurface {
        String name;
        String type;
        String magnitude;
        double age;
        String comment;
        Color colour;

        public String toString() {
            return this.name + " - " + this.age;
        }
    }

    public class TSCBlockEntry {
        String name;
        double age;
        String comment;
        Color colour;

        public String toString() {
            return this.name + " - " + this.age;
        }
    }

    public class TSCEvent {
        String name;
        double age;
        SBEvent wsEvent;

        public String toString() {
            return this.name + " - " + this.age;
        }

        private boolean needsFilter() {
            if (this.name.contains("[") && this.name.contains("]")) {
                return true;
            }
            int index = this.name.indexOf("*");
            return index > 0 && index < this.name.length() && this.name.substring(index + 1).contains("*");
        }

        private void filter() {
            int index = this.name.indexOf("[");
            if (index >= 0 && this.name.substring(index + 1).contains("]")) {
                this.name = this.name.substring(0, index) + this.name.substring(this.name.indexOf(93) + 1);
            }
            if ((index = this.name.indexOf("*")) > 0) {
                this.name = this.name.substring(0, index) + this.name.substring(index + 1);
            }
            if ((index = this.name.indexOf("*")) > 0) {
                this.name = this.name.substring(0, index) + this.name.substring(index + 1);
            }
            if ((index = this.name.indexOf("#")) > 0) {
                this.name = this.name.substring(0, index) + this.name.substring(index + 1);
            }
        }
    }
}

