/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import model2.SBdb;
import model2.TVDepth;
import util.SB;
import util.SBException;
import util.SbugsStatus;

public class TVDList
extends Observable
implements SbugsStatus {
    private SBdb SB;
    boolean isDirty = false;
    boolean isLoaded = false;
    boolean isPlan = false;
    private String headerText;
    private int datum;
    private List<TVDepth> list = new LinkedList<TVDepth>();
    Color status = UNKNOWN;

    public TVDList(SBdb SB2, boolean isPlan) {
        this.SB = SB2;
        this.isPlan = isPlan;
    }

    public int getSize() {
        return this.list.size();
    }

    private static String getPlanDBString(SBdb db) {
        if (db.getDBType() == SBdb.DBType.MSSQLSERVER) {
            return "[plan]";
        }
        return "plan";
    }

    public TVDepth get(int row) {
        return this.list.get(row);
    }

    public Iterator<TVDepth> getIterator() {
        return this.list.iterator();
    }

    public ListIterator<TVDepth> getListIterator() {
        return this.list.listIterator();
    }

    public List<TVDepth> getList() {
        return this.list;
    }

    public boolean add(TVDepth tvd) throws SBException {
        Iterator<TVDepth> it = this.list.iterator();
        int insertPoint = 0;
        int nzD = (int)(tvd.getDDepth() * 100.0);
        boolean ignore = false;
        while (it.hasNext()) {
            TVDepth compareWith = it.next();
            if (compareWith != tvd) {
                int cD = (int)(compareWith.getDDepth() * 100.0);
                if (nzD == cD) {
                    ignore = true;
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return false;
        }
        if (!ignore) {
            this.list.add(insertPoint, tvd);
            this.setChanged();
            this.isDirty = true;
        }
        return true;
    }

    public void add(TVDepth tvd, int wellID) throws SBException, SQLException {
        if (this.add(tvd)) {
            this.store(wellID, tvd);
        }
    }

    public void load(int wellID) throws SQLException {
        if (!this.isLoaded || this.list == null) {
            this.list = new LinkedList<TVDepth>();
            String sql = "SELECT ddepth, tvdepth, inclination, azimuth, incrvs, north, east FROM " + this.SB.DBTableName("WELLTVD") + " WHERE well_id=" + wellID;
            if (this.SB.hasTVDplan()) {
                sql = sql + " AND " + TVDList.getPlanDBString(this.SB) + "=" + (this.isPlan ? 1 : 0);
            }
            sql = sql + " ORDER BY ddepth";
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                try {
                    double dDepth = rs.getDouble("ddepth");
                    double tvDepth = rs.getDouble("tvdepth");
                    Float inclination = Float.valueOf(rs.getFloat("inclination"));
                    if (rs.wasNull()) {
                        inclination = null;
                    }
                    Float azimuth = Float.valueOf(rs.getFloat("azimuth"));
                    if (rs.wasNull()) {
                        azimuth = null;
                    }
                    Double vs = rs.getDouble("incrvs");
                    if (rs.wasNull()) {
                        vs = null;
                    }
                    Double north = rs.getDouble("north");
                    if (rs.wasNull()) {
                        north = null;
                    }
                    Double east = rs.getDouble("east");
                    if (rs.wasNull()) {
                        east = null;
                    }
                    TVDepth tvd = new TVDepth(dDepth, tvDepth, inclination, azimuth, vs, north, east);
                    this.list.add(tvd);
                }
                catch (SBException se) {
                    System.out.println(se.getMessage());
                }
            }
            sql = "SELECT datum, comments FROM " + this.SB.DBTableName("TVDHDR") + " WHERE well_id=" + wellID;
            if (this.SB.hasTVDplan()) {
                sql = sql + " AND " + TVDList.getPlanDBString(this.SB) + "=" + (this.isPlan ? 1 : 0);
            }
            if ((rs = stmt.executeQuery(this.SB.modQuery(sql))).next()) {
                this.datum = rs.getInt("datum");
                this.headerText = rs.getString("comments");
            } else {
                this.datum = 1;
                this.headerText = null;
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    public void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("WELLTVD") + " WHERE well_id=" + wellID;
        if (this.SB.hasTVDplan()) {
            sql = sql + " AND " + TVDList.getPlanDBString(this.SB) + "=" + (this.isPlan ? 1 : 0);
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void clear() {
        this.isDirty = false;
        this.isLoaded = false;
        if (this.list != null) {
            this.list.clear();
        }
    }

    private void store(int wellID, TVDepth tvd) throws SQLException {
        String sql = "INSERT INTO " + this.SB.DBTableName("WELLTVD") + "(well_id,";
        if (this.SB.hasTVDplan()) {
            sql = sql + "plan,";
        }
        sql = sql + "ddepth,tvdepth,inclination,azimuth,incrvs,north,east) VALUES (" + wellID;
        if (this.SB.hasTVDplan()) {
            sql = sql + "," + (this.isPlan ? 1 : 0);
        }
        sql = sql + ",?,?,?,?,?,?,?)";
        PreparedStatement pstmt = this.SB.getDatabase().prepareStatement(sql);
        pstmt.setDouble(1, tvd.getDDepth());
        pstmt.setDouble(2, tvd.getTVDepth());
        if (tvd.getInclination() != null) {
            pstmt.setFloat(3, tvd.getInclination().floatValue());
        } else {
            pstmt.setNull(3, 8);
        }
        if (tvd.getAzumith() != null) {
            pstmt.setFloat(4, tvd.getAzumith().floatValue());
        } else {
            pstmt.setNull(4, 8);
        }
        if (tvd.getVS() != null) {
            pstmt.setDouble(5, tvd.getVS());
        } else {
            pstmt.setNull(5, 8);
        }
        if (tvd.getNorth() != null) {
            pstmt.setDouble(6, tvd.getNorth());
        } else {
            pstmt.setNull(6, 8);
        }
        if (tvd.getEast() != null) {
            pstmt.setDouble(7, tvd.getEast());
        } else {
            pstmt.setNull(7, 8);
        }
        pstmt.executeUpdate();
        pstmt.close();
    }

    public void store(int wellID) throws SQLException {
        if (this.isDirty) {
            Iterator<TVDepth> it = this.list.iterator();
            this.deleteAll(wellID);
            it = this.list.iterator();
            String sql = "INSERT INTO " + this.SB.DBTableName("WELLTVD") + "(well_id,";
            if (this.SB.hasTVDplan()) {
                sql = sql + TVDList.getPlanDBString(this.SB) + ",";
            }
            sql = sql + "ddepth,tvdepth,inclination,azimuth,incrvs,north,east) VALUES (" + wellID;
            if (this.SB.hasTVDplan()) {
                sql = sql + "," + (this.isPlan ? 1 : 0);
            }
            sql = sql + ",?,?,?,?,?,?,?)";
            PreparedStatement pstmt = this.SB.getDatabase().prepareStatement(sql);
            while (it.hasNext()) {
                TVDepth tvd = it.next();
                pstmt.setDouble(1, tvd.getDDepth());
                pstmt.setDouble(2, tvd.getTVDepth());
                if (tvd.getInclination() != null) {
                    pstmt.setFloat(3, tvd.getInclination().floatValue());
                } else {
                    pstmt.setNull(3, 8);
                }
                if (tvd.getAzumith() != null) {
                    pstmt.setFloat(4, tvd.getAzumith().floatValue());
                } else {
                    pstmt.setNull(4, 8);
                }
                if (tvd.getVS() != null) {
                    pstmt.setDouble(5, tvd.getVS());
                } else {
                    pstmt.setNull(5, 8);
                }
                if (tvd.getNorth() != null) {
                    pstmt.setDouble(6, tvd.getNorth());
                } else {
                    pstmt.setNull(6, 8);
                }
                if (tvd.getEast() != null) {
                    pstmt.setDouble(7, tvd.getEast());
                } else {
                    pstmt.setNull(7, 8);
                }
                pstmt.executeUpdate();
            }
            pstmt.close();
            if (this.headerText != null || this.datum != 1) {
                Statement stmt = this.SB.getDatabase().createStatement();
                sql = "DELETE FROM " + this.SB.DBTableName("TVDHDR") + " WHERE well_id=" + wellID;
                if (this.SB.hasTVDplan()) {
                    sql = sql + " AND " + TVDList.getPlanDBString(this.SB) + "=" + (this.isPlan ? 1 : 0);
                }
                stmt.executeUpdate(this.SB.modQuery(sql));
                sql = "INSERT INTO " + this.SB.DBTableName("TVDHDR") + " (well_id,";
                if (this.SB.hasTVDplan()) {
                    sql = sql + TVDList.getPlanDBString(this.SB) + ",";
                }
                sql = sql + "datum, comments) VALUES (" + wellID;
                if (this.SB.hasTVDplan()) {
                    sql = sql + "," + (this.isPlan ? 1 : 0);
                }
                sql = sql + "," + this.datum + "," + util.SB.DBString((String)this.headerText) + ")";
                stmt.executeUpdate(this.SB.modQuery(sql));
                stmt.close();
            }
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        if (this.list.size() > 0) {
            Iterator<TVDepth> it = this.list.iterator();
            out.write("[TVD]" + eol);
            while (it.hasNext()) {
                TVDepth tvd = it.next();
                out.write("Depth/TVD = " + util.SB.getDepthString((double)tvd.getDDepth(), (char)units, (int)2).trim() + " : " + util.SB.getDepthString((double)tvd.getTVDepth(), (char)units, (int)2).trim() + eol);
            }
            out.write(eol);
        }
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        System.out.println("in TVDList.writeXML list.size: " + this.list.size());
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        if (this.list.size() > 0) {
            Iterator<TVDepth> it = this.list.iterator();
            out.write("<DeviationSurvey>\n");
            if (this.headerText != null && this.headerText.length() > 0) {
                out.write(ind + "<Header>" + util.SB.getXMLstring((String)this.headerText) + "</Header>");
            }
            while (it.hasNext()) {
                String tvdepth;
                out.write(ind + "<TVDData>\n");
                TVDepth tvd = it.next();
                String ddepth = util.SB.getDepthString((double)tvd.getDDepth(), (char)units, (int)2).trim();
                if (ddepth != null && ddepth.length() > 0) {
                    out.write(ind + ind + "<DrilledDepth>" + ddepth + "</DrilledDepth>\n");
                }
                if ((tvdepth = util.SB.getDepthString((double)tvd.getTVDepth(), (char)units, (int)2).trim()) != null && tvdepth.length() > 0) {
                    out.write(ind + ind + "<TVDepth>" + tvdepth + "</TVDepth>\n");
                }
                if (tvd.getInclination() != null && tvd.getInclination().floatValue() > 0.0f) {
                    out.write(ind + ind + "<Inclination>" + tvd.getInclination() + "</Inclination>\n");
                }
                if (tvd.getAzumith() != null && tvd.getAzumith().floatValue() > 0.0f) {
                    out.write(ind + ind + "<Azimuth>" + tvd.getAzumith() + "</Azimuth>\n");
                }
                String strg = "";
                if (tvd.getVS() != null && (strg = util.SB.getDepthString((double)tvd.getVS(), (char)units, (int)2).trim()) != null && strg.length() > 0) {
                    out.write(ind + ind + "<VerticalSection>" + strg + "</VerticalSection>\n");
                }
                if (tvd.getNorth() != null && (strg = util.SB.getDepthString((double)tvd.getNorth(), (char)units, (int)2).trim()) != null && strg.length() > 0) {
                    out.write(ind + ind + "<North>" + strg + "</North>\n");
                }
                if (tvd.getEast() != null && (strg = util.SB.getDepthString((double)tvd.getEast(), (char)units, (int)2).trim()) != null && strg.length() > 0) {
                    out.write(ind + ind + "<East>" + strg + "</East>\n");
                }
                out.write(ind + "</TVDData>\n");
            }
            out.write("</DeviationSurvey>\n");
        }
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public boolean isPlan() {
        return this.isPlan;
    }

    public boolean isIsTVDSS() {
        return this.datum == 2;
    }

    public void setHeader(String header, int i) {
        this.headerText = header;
        this.datum = i;
        this.isDirty = true;
    }

    public double getMaxVS() {
        if (!this.list.isEmpty()) {
            Double vs = this.list.get(this.list.size() - 1).getVS();
            if (vs != null) {
                return vs;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getMinVS() {
        if (!this.list.isEmpty()) {
            Double vs = this.list.get(0).getVS();
            if (vs != null) {
                return this.list.get(0).getVS();
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getTopTVD() {
        Iterator<TVDepth> it = this.list.iterator();
        if (this.list.isEmpty()) {
            return 0.0;
        }
        double toptvd = this.list.get(0).getTVDepth();
        while (it.hasNext()) {
            double tvd = it.next().getTVDepth();
            if (!(tvd < toptvd)) continue;
            toptvd = tvd;
        }
        return toptvd;
    }

    public double getBaseTVD() {
        if (this.list.isEmpty()) {
            return 0.0;
        }
        Iterator<TVDepth> it = this.list.iterator();
        double basetvd = 0.0;
        while (it.hasNext()) {
            double tvd = it.next().getTVDepth();
            if (!(tvd > basetvd)) continue;
            basetvd = tvd;
        }
        return basetvd;
    }

    public double getBaseDD() {
        if (this.list.isEmpty()) {
            return 0.0;
        }
        return this.list.get(this.list.size() - 1).getDDepth();
    }

    public double getTopDD() {
        if (this.list.isEmpty()) {
            return 0.0;
        }
        return this.list.get(0).getDDepth();
    }

    public TVDepth getTVD(double dDepth) {
        TVDepth newTVDepth = null;
        try {
            if (this.list.size() < 2) {
                return new TVDepth(dDepth, dDepth, Float.valueOf(0.0f), Float.valueOf(0.0f), 0.0, 0.0, 0.0);
            }
            double d1 = 0.0;
            double d2 = 0.0;
            double tvd1 = 0.0;
            double tvd2 = 0.0;
            double vs1 = 0.0;
            double vs2 = 0.0;
            ListIterator<TVDepth> it = this.list.listIterator();
            while (it.hasNext()) {
                boolean first = !it.hasPrevious();
                TVDepth tvd = it.next();
                if (first && dDepth < tvd.getDDepth() - 0.001) {
                    return new TVDepth(dDepth, dDepth, Float.valueOf(0.0f), Float.valueOf(0.0f), 0.0, 0.0, 0.0);
                }
                if (Math.abs(tvd.getDDepth() - dDepth) < 0.001) {
                    return tvd;
                }
                if (dDepth > d1 && dDepth < tvd.getDDepth()) {
                    d2 = tvd.getDDepth();
                    tvd2 = tvd.getTVDepth() != null ? tvd.getTVDepth() : 0.0;
                    vs2 = tvd.getVS() != null ? tvd.getVS() : 0.0;
                    break;
                }
                if (!it.hasNext()) {
                    d2 = tvd.getDDepth();
                    tvd2 = tvd.getTVDepth() != null ? tvd.getTVDepth() : 0.0;
                    vs2 = tvd.getVS() != null ? tvd.getVS() : 0.0;
                    break;
                }
                d1 = tvd.getDDepth();
                tvd1 = tvd.getTVDepth() != null ? tvd.getTVDepth() : 0.0;
                vs1 = tvd.getVS() != null ? tvd.getVS() : 0.0;
            }
            double sa = dDepth - d1;
            newTVDepth = new TVDepth(dDepth, sa * (tvd2 - tvd1) / (d2 - d1) + tvd1, Float.valueOf(0.0f), Float.valueOf(0.0f), sa * (vs2 - vs1) / (d2 - d1) + vs1, 0.0, 0.0);
            return newTVDepth;
        }
        catch (SBException se) {
            System.out.println(se.getMessage());
            se.printStackTrace();
            return newTVDepth;
        }
    }

    public TVDepth getTVDepth(double vs) throws SBException {
        TVDepth n1 = null;
        TVDepth n2 = null;
        for (TVDepth depth : this.list) {
            if (Math.abs(depth.getVS() - vs) < 0.001) {
                return depth;
            }
            if (depth.getVS() < vs) {
                n1 = depth;
            }
            if (!(depth.getVS() > vs)) continue;
            n2 = depth;
            break;
        }
        if (n1 != null && n2 != null) {
            double vsdiff = n2.getVS() - n1.getVS();
            double tvddiff = Math.abs(n1.getTVDepth() - n2.getTVDepth());
            double newvsdiff = vs - n1.getVS();
            double newtvddiff = newvsdiff * (tvddiff / vsdiff);
            double tvd = Math.min(n1.getTVDepth(), n2.getTVDepth()) + newtvddiff;
            double ddepth = n1.getDDepth() + Math.sqrt(Math.pow(tvd - n1.getTVDepth(), 2.0) + Math.pow(vs - n1.getVS(), 2.0));
            return new TVDepth(ddepth, tvd, null, null, vs, null, null);
        }
        return null;
    }

    public TVDepth getDepth(double tvd, boolean first, Double minDepth, Double maxDepth) {
        if (this.list.size() < 2) {
            return null;
        }
        ListIterator<TVDepth> it = this.list.listIterator();
        if (!first) {
            while (it.hasNext()) {
                it.next();
            }
        }
        TVDepth last = null;
        while (first ? it.hasNext() : it.hasPrevious()) {
            TVDepth tvdepth;
            TVDepth tVDepth = tvdepth = first ? it.next() : it.previous();
            if (Math.abs(tvdepth.getTVDepth() - tvd) < 0.001) {
                return tvdepth;
            }
            if (last != null && tvd > Math.min(tvdepth.getTVDepth(), last.getTVDepth()) && tvd <= Math.max(tvdepth.getTVDepth(), last.getTVDepth())) {
                try {
                    double tvd1 = tvdepth.getTVDepth();
                    double tvd2 = last.getTVDepth();
                    double vs1 = tvdepth.getVS() == null ? 0.0 : tvdepth.getVS();
                    double vs2 = last.getVS() == null ? 0.0 : tvdepth.getVS();
                    double d1 = tvdepth.getDDepth();
                    double d2 = last.getDDepth();
                    double newDD = d1 + (tvd - tvd1) * ((d2 - d1) / (tvd2 - tvd1));
                    double newVS = vs1 + (tvd - tvd1) * ((vs2 - vs1) / (tvd2 - tvd1));
                    if (minDepth == null || newDD >= minDepth && newDD <= maxDepth) {
                        return new TVDepth(newDD, tvd, Float.valueOf(0.0f), Float.valueOf(0.0f), newVS, 0.0, 0.0);
                    }
                }
                catch (SBException e) {
                    util.SB.showStackError((String)"Error", (Exception)((Object)e));
                }
            }
            last = tvdepth;
        }
        return null;
    }

    public Color getStatus() {
        return this.status;
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    public String statusString() {
        String string = "(No data)";
        if (!this.list.isEmpty()) {
            String topdepth = "" + util.SB.getDepthString((double)this.list.get(0).getDDepth(), (char)'M', (int)2);
            String basedepth = "" + util.SB.getDepthString((double)this.list.get(this.list.size() - 1).getDDepth(), (char)'M', (int)2);
            string = topdepth + " - " + basedepth;
        }
        return string;
    }

    public double[][] getReversals() {
        Iterator<TVDepth> it = this.list.iterator();
        TVDepth lastNode = null;
        LinkedList<double[]> revs = new LinkedList<double[]>();
        double[] rev = null;
        while (it.hasNext()) {
            TVDepth node = it.next();
            if (lastNode == null) {
                lastNode = node;
                continue;
            }
            if (node.getTVDepth() < lastNode.getTVDepth()) {
                if (rev == null) {
                    rev = new double[2];
                    rev[0] = lastNode.getDDepth();
                }
            } else if (rev != null) {
                rev[1] = lastNode.getDDepth();
                revs.add(rev);
                rev = null;
            }
            lastNode = node;
        }
        if (rev != null) {
            rev[1] = lastNode.getDDepth();
            revs.add(rev);
        }
        if (revs.isEmpty()) {
            return null;
        }
        double[][] depths = new double[revs.size()][];
        for (int i = 0; i < revs.size(); ++i) {
            depths[i] = (double[])revs.get(i);
        }
        return depths;
    }
}

