/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2.SBdb;
import model2.TWTDepth;
import util.SB;
import util.SBException;

public class TWTList
extends Observable {
    SBdb SB;
    boolean isDirty = false;
    boolean isLoaded = false;
    private List<TWTDepth> list = new LinkedList<TWTDepth>();

    public TWTList(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSize() {
        return this.list.size();
    }

    public TWTDepth get(int row) {
        return this.list.get(row);
    }

    public boolean add(TWTDepth twt) throws SBException {
        Iterator<TWTDepth> it = this.list.iterator();
        int insertPoint = 0;
        int nzD = (int)(twt.getDepth() * 100.0);
        boolean ignore = false;
        while (it.hasNext()) {
            TWTDepth compareWith = it.next();
            if (compareWith != twt) {
                int cD = (int)(compareWith.getDepth() * 100.0);
                if (nzD == cD) {
                    ignore = true;
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return false;
        }
        if (!ignore) {
            this.list.add(insertPoint, twt);
            this.isDirty = true;
        }
        return true;
    }

    public void load(int wellID) throws SQLException {
        if (!this.isLoaded) {
            this.clear();
            String sql = "SELECT ddepth, TWT FROM " + this.SB.DBTableName("WELLTWT") + " WHERE well_id=" + wellID;
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                try {
                    double dDepth = rs.getDouble("ddepth");
                    double TWTDepth2 = rs.getDouble("TWT");
                    TWTDepth twt = new TWTDepth(dDepth, TWTDepth2);
                    this.add(twt);
                }
                catch (SBException se) {
                    System.out.println(se.getMessage());
                }
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    public void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("WELLTWT") + " WHERE well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void clear() {
        this.isDirty = false;
        this.isLoaded = false;
        this.list.clear();
    }

    public void store(int wellID) throws SQLException {
        if (this.isDirty) {
            Iterator<TWTDepth> it = this.list.iterator();
            this.deleteAll(wellID);
            it = this.list.iterator();
            Statement stmt = this.SB.getDatabase().createStatement();
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                String sql = "INSERT INTO " + this.SB.DBTableName("WELLTWT") + "(well_id,ddepth,twt) VALUES (" + wellID + "," + twt.getDepth() + "," + twt.getTWT() + ")";
                stmt.executeUpdate(this.SB.modQuery(sql));
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        if (this.list.size() > 0) {
            Iterator<TWTDepth> it = this.list.iterator();
            out.write("[TWT]" + eol);
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                out.write("Depth/TWT = " + util.SB.getDepthString((double)twt.getDepth(), (char)units, (int)2).trim() + " : " + util.SB.floatString((double)twt.getTWT(), (int)2) + eol);
            }
            out.write(eol);
        }
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        if (this.list.size() > 0) {
            Iterator<TWTDepth> it = this.list.iterator();
            out.write("<TWTList>\n");
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                String depth = util.SB.getDepthString((double)twt.getDepth(), (char)units, (int)2).trim();
                String twtString = util.SB.floatString((double)twt.getTWT(), (int)2);
                out.write(ind + "<TWTData>\n");
                if (depth != null && depth.length() > 0) {
                    out.write(ind + ind + "<DrilledDepth>" + depth + "</DrilledDepth>\n");
                }
                if (twtString != null && twtString.length() > 0) {
                    out.write(ind + ind + "<TWT>" + twtString + "</TWT>\n");
                }
                out.write(ind + "</TWTData>\n");
            }
            out.write("</TWTList>\n");
        }
    }
}

