/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import javax.swing.JComboBox;
import model2.Audit;
import model2.Categories;
import model2.Category;
import model2.Discipline;
import model2.Genus;
import model2.ImageSet;
import model2.Qualifier;
import model2.SBImage;
import model2.SBdb;
import model2.Taxon;
import model2.TaxonQual;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.ProgressBarMonitor;
import util.SB;
import util.SBException;

public class TaxaMap
extends Observable {
    private final SBdb sbdb;
    private final HashMap<Integer, Taxon> taxa;
    private final HashMap<Integer, Genus> genera;
    private Categories categories;
    PreparedStatement speciesFillStatement;

    TaxaMap(SBdb sbdb) throws SQLException {
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to construct TaxaMap with no model");
        }
        this.sbdb = sbdb;
        this.taxa = new HashMap();
        this.genera = new HashMap();
    }

    List<Taxon> getTaxa() {
        return new LinkedList<Taxon>(this.taxa.values());
    }

    void clearStatement() throws SQLException {
        if (this.speciesFillStatement != null) {
            this.speciesFillStatement.close();
            this.speciesFillStatement = null;
        }
    }

    public boolean hasTaxon(Taxon taxon) {
        return this.taxa.containsValue(taxon);
    }

    Taxon getTaxon(int specID) throws SQLException {
        Taxon taxon = this.taxa.get(new Integer(specID));
        if (taxon == null && this.sbdb.isConnected()) {
            Taxon.Builder tBuilder;
            int genID;
            if (this.speciesFillStatement == null) {
                this.speciesFillStatement = Taxon.getFillSpeciesStatement(this.sbdb);
            }
            if ((genID = Taxon.fillSpecies(specID, this.speciesFillStatement, tBuilder = new Taxon.Builder())) == 0) {
                return null;
            }
            tBuilder.genus(this.getGenus(genID));
            taxon = tBuilder.build(specID, this.sbdb);
            taxon = this.putSpecies(specID, taxon);
        }
        return taxon;
    }

    Taxon getTaxon(Taxon.Builder builder) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to get Taxon by builder");
        }
        int maxSpecID = 1;
        for (Taxon taxon : this.taxa.values()) {
            if (taxon.equalsBuilder(builder)) {
                return taxon;
            }
            if (taxon.getSpecID() < maxSpecID) continue;
            maxSpecID = taxon.getSpecID() + 1;
        }
        Taxon newTaxon = builder.build(maxSpecID, this.sbdb);
        newTaxon = this.putSpecies(maxSpecID, newTaxon);
        return newTaxon;
    }

    Taxon getTaxonFromName(String taxonName) throws SQLException {
        StringTokenizer tok = new StringTokenizer(taxonName);
        String genus = tok.nextToken();
        String species = "";
        String subSpecies = null;
        if (tok.hasMoreTokens()) {
            species = tok.nextToken();
        }
        if (tok.hasMoreTokens()) {
            subSpecies = tok.nextToken();
        }
        if (!tok.hasMoreTokens()) {
            Taxon[] specArr = this.lookupSpecies(null, genus, "", species, subSpecies, null, null, null, null, null, null, null, null);
            if (specArr != null) {
                Taxon taxon = specArr[0];
                if (specArr.length > 1) {
                    System.out.println("WARNING: other matches found for " + genus + " " + species);
                    if (subSpecies == null) {
                        for (Taxon t : specArr) {
                            if (!t.getSubSpecies().isEmpty()) continue;
                            taxon = t;
                            System.out.println("chose no sub-species option");
                            break;
                        }
                    }
                }
                return taxon;
            }
            Genus[] genArr = this.lookupGenus(new Genus.Builder().genusName(genus));
            if (genArr != null && genArr.length == 1) {
                Taxon.Builder txBuilder = new Taxon.Builder().species(species).subSpecies(subSpecies).genus(genArr[0]);
                return this.addTaxon(txBuilder);
            }
        }
        return null;
    }

    private Genus getGenus(int genID) throws SQLException {
        Genus genus = this.genera.get(genID);
        if (genus == null && (genus = Genus.load(this.sbdb, genID, null, null)) != null) {
            genus = this.putGenus(genID, genus);
        }
        return genus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Genus putGenus(int genID, Genus genus) {
        if (genus == null) {
            throw new IllegalArgumentException("Attempt to put null genus for ID: " + genID);
        }
        HashMap<Integer, Genus> hashMap = this.genera;
        synchronized (hashMap) {
            Genus existing = this.genera.put(genID, genus);
            if (existing != null && existing != genus) {
                if (existing.compareTo(genus) != 0) {
                    throw new IllegalArgumentException("Attempt to replace genus with ID=" + genID + " in workspace: " + existing.toString() + " with: " + genus.toString());
                }
                this.genera.put(genID, existing);
                return existing;
            }
            return genus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Taxon putSpecies(int specID, Taxon species) {
        if (species == null) {
            throw new IllegalArgumentException("Attempt to put null genus for ID: " + specID);
        }
        HashMap<Integer, Taxon> hashMap = this.taxa;
        synchronized (hashMap) {
            Taxon existing = this.taxa.put(specID, species);
            if (existing != null && existing != species) {
                if (existing.compareTo(species) > 0) {
                    throw new IllegalArgumentException("Attempt to replace taxon with ID=" + specID + " in workspace: " + existing.toString() + " with: " + species.toString());
                }
                this.taxa.put(specID, existing);
                return existing;
            }
            return species;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTaxon(Taxon taxon) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to remove species from connected database");
        }
        if (this.taxa.get(taxon.getSpecID()) == null) {
            throw new IllegalArgumentException("Attempt to remove species not in map");
        }
        HashMap<Integer, Taxon> hashMap = this.taxa;
        synchronized (hashMap) {
            this.taxa.remove(taxon.getSpecID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadTaxa(int wellID) throws SQLException {
        this.loadCategories();
        String sql = "SELECT g.gen_id,g.cat_mnem,g.genus,g.sub_genus,g.q1 AS gq1,g.q2 AS gq2,g.q3 AS gq3,g.q4 AS gq4, " + Audit.sqlFieldString("g") + ",";
        sql = sql + "s.spec_id,s.species,s.sub_spec,s.q1 AS sq1,s.q2 AS sq2,s.q3 AS sq3,s.q4 AS sq4,s.author,s.year,s.alphaCode," + Audit.sqlFieldString("s");
        sql = sql + " FROM " + this.sbdb.DBTableName("species") + " s,";
        sql = sql + this.sbdb.DBTableName("genus") + " g, ";
        sql = sql + this.sbdb.DBTableName("taxonocc") + " t ";
        sql = sql + "WHERE g.gen_id=s.gen_id AND s.spec_id=t.spec_id AND t.well_id=" + wellID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                try {
                    int specID;
                    Taxon taxon;
                    int genID = rs.getInt("gen_id");
                    Genus genus = this.genera.get(genID);
                    if (genus == null) {
                        Genus.Builder genBuilder = new Genus.Builder();
                        genBuilder.category(this.sbdb.getCategory(rs.getString("cat_mnem")));
                        genBuilder.genusName(rs.getString("genus"));
                        genBuilder.subGenus(rs.getString("sub_genus"));
                        genBuilder.qual(0, rs.getString("gq1"));
                        genBuilder.qual(1, rs.getString("gq2"));
                        genBuilder.qual(2, rs.getString("gq3"));
                        genBuilder.qual(3, rs.getString("gq4"));
                        genBuilder.audit(new Audit(rs, "g"));
                        genus = genBuilder.build(genID);
                        genus = this.putGenus(genID, genus);
                    }
                    if ((taxon = this.taxa.get(new Integer(specID = rs.getInt("spec_id")))) != null) continue;
                    Taxon.Builder builder = new Taxon.Builder();
                    builder.genus(genus);
                    builder.species(rs.getString("species"));
                    builder.subSpecies(rs.getString("sub_spec"));
                    builder.qual(4, rs.getString("sq1"));
                    builder.qual(5, rs.getString("sq2"));
                    builder.qual(6, rs.getString("sq3"));
                    builder.qual(7, rs.getString("sq4"));
                    builder.author(rs.getString("author"));
                    builder.year(rs.getInt("year"));
                    builder.alphaCode(rs.getString("alphaCode"));
                    builder.audit(new Audit(rs, "s"));
                    this.putSpecies(specID, builder.build(specID, this.sbdb));
                }
                catch (RuntimeException re) {
                    SB.showStackError((String)"Failed to load species: ", (Exception)re);
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    Taxon addTaxon(Taxon.Builder builder) throws SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store Taxon in unconnected model");
        }
        Taxon t = builder.store(this.sbdb);
        t = this.putSpecies(t.getSpecID(), t);
        return t;
    }

    Taxon addTaxon(Taxon.Builder txBuilder, Genus.Builder genBuilder, String cat_mnem, int specID, Integer genID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to add Taxon to connected workspace");
        }
        if (specID <= 0) {
            throw new IllegalArgumentException("Attempt to add taxon to workspace with ID: " + specID);
        }
        assert (genBuilder.getCategory() == null);
        try {
            Category cat;
            if (cat_mnem == null) {
                cat_mnem = "";
            }
            if ((cat = this.getCategory(cat_mnem)) == null) {
                cat = cat_mnem.isEmpty() ? this.getNullCategory() : this.addCategory(cat_mnem, Discipline.MICRO, cat_mnem, Color.blue);
            }
            genBuilder.category(cat);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Genus genus = this.findGenus(genBuilder);
        if (genus == null) {
            int id = genID != null && genID > 0 && this.genera.get(genID) == null ? genID.intValue() : this.nextGenID();
            genus = genBuilder.build(id);
            genus = this.putGenus(genus.getGenID(), genus);
        }
        txBuilder.genus(genus);
        Taxon taxon = txBuilder.build(specID, this.sbdb);
        taxon = this.putSpecies(specID, taxon);
        return taxon;
    }

    Taxon copyToWorkspace(SBdb ws, Taxon dbTaxon, SBdb db) throws SQLException, SBException {
        if (ws.isConnected() || !db.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy Taxon to connected workspace");
        }
        Taxon taxon = this.taxa.get(dbTaxon.getSpecID());
        if (taxon == null) {
            Genus genus = this.genera.get(dbTaxon.getGenus().getGenID());
            if (genus == null) {
                Category dbCat = dbTaxon.getGenus().getCategory();
                Category wsCat = this.getCategory(dbCat.getMnem());
                if (wsCat == null) {
                    wsCat = this.addCategory(dbCat.getMnem(), dbCat.getDisc(), dbCat.getName(), dbCat.getColour());
                }
                Genus.Builder wsGenBuilder = Genus.Builder.copyOf(dbTaxon.getGenus());
                wsGenBuilder.category(wsCat);
                Audit audit = new Audit(dbTaxon.getGenus().getAudit());
                audit.fillWorkspace(db, ws);
                wsGenBuilder.audit(audit);
                genus = wsGenBuilder.build(dbTaxon.getGenus().getGenID());
                genus = this.putGenus(genus.getGenID(), genus);
            }
            dbTaxon.loadNotesAndRefs();
            Taxon.Builder builder = Taxon.Builder.copyOf(dbTaxon);
            builder.genus(genus);
            Audit audit = new Audit(dbTaxon.getAudit());
            audit.fillWorkspace(db, ws);
            builder.audit(audit);
            taxon = builder.build(dbTaxon.getSpecID(), this.sbdb);
            taxon.setLink(dbTaxon);
            taxon = this.putSpecies(taxon.getSpecID(), taxon);
        }
        return taxon;
    }

    Taxon copyToDataBase(Taxon wsTaxon, SBdb ws, Category cat) throws SQLException, SBException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy Taxon to unconnected database");
        }
        if (this.categories.getCategory(cat.getMnem()) == null) {
            throw new IllegalArgumentException("Could not copy taxon because category '" + cat.getMnem() + "' was not recognised.");
        }
        Genus.Builder dbGenBuilder = Genus.Builder.copyOf(wsTaxon.getGenus());
        dbGenBuilder.category(cat);
        Genus genus = this.findGenus(dbGenBuilder);
        if (genus == null) {
            dbGenBuilder.audit(new Audit(this.sbdb, ws, wsTaxon.getGenus().getAudit()));
            genus = dbGenBuilder.store(this.sbdb);
            genus = this.putGenus(genus.getGenID(), genus);
        }
        Taxon.Builder builder = Taxon.Builder.copyOf(wsTaxon);
        builder.genus(genus);
        builder.audit(new Audit(this.sbdb, ws, wsTaxon.getAudit()));
        Taxon taxon = builder.store(this.sbdb);
        taxon = this.putSpecies(taxon.getSpecID(), taxon);
        wsTaxon.setLink(taxon);
        return taxon;
    }

    void copyLink(int specID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy taxon in connected workspace");
        }
        Taxon taxon = this.taxa.get(specID);
        if (taxon == null) {
            throw new IllegalStateException("Attempt to copy link on non-existant taxon");
        }
        if (taxon.getLink() == null) {
            throw new IllegalArgumentException("Attempt to copy link on unlinked taxon: " + taxon.toString() + " ID=" + taxon.getSpecID());
        }
        Genus linkGen = taxon.getLink().getGenus();
        try {
            Category cat = this.getCategory(linkGen.getCategory().getMnem());
            if (cat == null) {
                cat = this.addCategory(linkGen.getCategory().getMnem(), linkGen.getCategory().getDisc(), linkGen.getCategory().getName(), linkGen.getCategory().getColour());
            }
            Taxon.Builder copyTx = Taxon.Builder.copyOf(taxon.getLink());
            Genus.Builder copyGen = Genus.Builder.copyOf(linkGen).category(cat);
            if (!taxon.getGenus().equalsBuilder(copyGen, false)) {
                Genus newGen = this.findGenus(copyGen);
                if (newGen == null) {
                    newGen = copyGen.build(this.nextGenID());
                    newGen = this.putGenus(newGen.getGenID(), newGen);
                }
                copyTx.genus(newGen);
            } else {
                copyTx.genus(taxon.getGenus());
            }
            taxon.update(this.sbdb, copyTx);
        }
        catch (SQLException sql) {
            System.out.println("WARNING error copying fields to workspace taxon: " + taxon);
            sql.printStackTrace();
        }
    }

    void setChangeNotify(Object notifier) {
        this.setChanged();
        this.notifyObservers(notifier);
    }

    Taxon get(int specID) {
        return this.taxa.get(specID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadAll() throws SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to load taxa from unconnected database");
        }
        this.loadCategories();
        HashMap<Integer, Observable> hashMap = this.genera;
        synchronized (hashMap) {
            Genus.loadAll(this.sbdb, this.genera);
        }
        hashMap = this.taxa;
        synchronized (hashMap) {
            Taxon.loadAll(this.sbdb, this.taxa, this.genera);
        }
    }

    int getSize() {
        return this.taxa.size();
    }

    Taxon getTaxon(String donorString, int specID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Looking for donor strings in database");
        }
        for (Taxon taxon : this.taxa.values()) {
            if (taxon.donorString == null || !taxon.donorString.equals(donorString)) continue;
            if (taxon.getSpecID() != specID) {
                this.taxa.put(specID, taxon);
            }
            return taxon;
        }
        return null;
    }

    Genus addGenus(Genus.Builder builder) throws SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store Genus in unconnected database");
        }
        Genus genus = builder.store(this.sbdb);
        genus = this.putGenus(genus.getGenID(), genus);
        return genus;
    }

    Genus[] lookupGenus(Genus.Builder genus) throws SQLException {
        Genus[] genArr;
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to lookup genus in unconnected database");
        }
        this.loadCategories();
        Category cat = genus.getCategory();
        if (cat != null && cat.getMnem().isEmpty()) {
            cat = null;
        }
        if ((genArr = Genus.load(this.sbdb, cat != null ? cat.getMnem() : null, genus.getName(), genus.getSubGenus(), genus.getQualifier(0), genus.getQualifier(1), genus.getQualifier(2), genus.getQualifier(3))) != null) {
            for (int i = 0; i < genArr.length; ++i) {
                if (this.genera.get(genArr[i].getGenID()) != null) {
                    genArr[i] = this.genera.get(genArr[i].getGenID());
                    continue;
                }
                this.putGenus(genArr[i].getGenID(), genArr[i]);
            }
        }
        return genArr;
    }

    Taxon[] lookupSpecies(String cat_mnem, String genus, String subGenus, String species, String subSpecies, Qualifier gq1, Qualifier gq2, Qualifier gq3, Qualifier gq4, Qualifier sq1, Qualifier sq2, Qualifier sq3, Qualifier sq4) throws SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to lookup species in unconnected database");
        }
        Genus[] genArr = Genus.load(this.sbdb, cat_mnem, genus, subGenus, gq1, gq2, gq3, gq4);
        if (genArr == null || genArr.length == 0) {
            return null;
        }
        for (int i = 0; i < genArr.length; ++i) {
            Genus loaded = genArr[i];
            if (this.genera.get(loaded.getGenID()) != null) {
                genArr[i] = this.genera.get(loaded.getGenID());
                continue;
            }
            this.putGenus(loaded.getGenID(), loaded);
        }
        LinkedList<Taxon> tList = new LinkedList<Taxon>();
        for (Genus g : genArr) {
            Taxon[] tArr = Taxon.load(this.sbdb, g, species, subSpecies, sq1, sq2, sq3, sq4);
            if (tArr == null) continue;
            for (Taxon t : tArr) {
                if (this.taxa.get(t.getSpecID()) != null) {
                    t = this.taxa.get(t.getSpecID());
                } else {
                    this.putSpecies(t.getSpecID(), t);
                }
                tList.add(t);
            }
        }
        if (tList.isEmpty()) {
            return null;
        }
        return tList.toArray(new Taxon[tList.size()]);
    }

    void lookupTaxonLink(Taxon taxon) throws SQLException {
        if (this.taxa.get(taxon.getSpecID()) != null && this.taxa.get(taxon.getSpecID()) == taxon) {
            throw new IllegalStateException("Attempt to link taxon within same model");
        }
        String cat_mnem = taxon.getCatMnem().isEmpty() ? null : taxon.getCatMnem();
        Taxon[] arr = this.lookupSpecies(cat_mnem, taxon.getGenusName(), taxon.getSubGenus(), taxon.getSpecies(), taxon.getSubSpecies(), taxon.getQualifier(0), taxon.getQualifier(1), taxon.getQualifier(2), taxon.getQualifier(3), taxon.getQualifier(4), taxon.getQualifier(5), taxon.getQualifier(6), taxon.getQualifier(7));
        if (arr != null) {
            taxon.setLink(arr[0]);
        } else {
            taxon.setLink(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Taxon lookupTaxon(String alphaCode) throws SQLException {
        String sql = "SELECT spec_id FROM " + this.sbdb.DBTableName("species") + " WHERE ucase(alphacode)=" + SB.DBString((String)alphaCode.toUpperCase());
        sql = this.sbdb.modQuery(sql);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                Taxon taxon = this.getTaxon(rs.getInt("spec_id"));
                return taxon;
            }
        }
        finally {
            stmt.close();
        }
        return null;
    }

    void updateGenus(int genID, Genus.Builder genBuilder) throws SQLException {
        Genus genus = this.genera.get(genID);
        genus.update(this.sbdb, genBuilder);
        genus.notifyObservers();
    }

    void updateSpecies(int specID, Taxon.Builder builder) throws SQLException {
        Taxon taxon = this.taxa.get(specID);
        Genus origGenus = taxon.getGenus();
        taxon.update(this.sbdb, builder);
        if (origGenus != taxon.getGenus()) {
            this.checkDeleteGenus(origGenus.getGenID());
        }
        taxon.notifyObservers();
    }

    private void loadCategories() throws SQLException {
        if (this.categories == null) {
            this.categories = new Categories(this.sbdb);
        }
    }

    List<Category> getCategories() throws SQLException {
        this.loadCategories();
        return this.categories.getList();
    }

    Category addCategory(String mnem, Discipline discID, String name, Color colour) throws SQLException {
        this.loadCategories();
        return this.categories.add(this.sbdb, mnem, discID, name, colour);
    }

    Category getCategory(String mnem) throws SQLException {
        this.loadCategories();
        return this.categories.getCategory(mnem);
    }

    void deleteCategory(Category cat) throws SQLException, SBException {
        this.loadCategories();
        this.categories.delete(this.sbdb, cat);
    }

    void updateCategory(Category cat, String abr, Discipline discID, String description, Color colour) throws SQLException {
        this.loadCategories();
        this.categories.updateCat(this.sbdb, cat, abr, discID, description, colour);
    }

    void fillCatCombo(JComboBox combo, boolean mnemOnly, Discipline discID) throws SQLException {
        this.loadCategories();
        this.categories.fillCombo(combo, mnemOnly, discID);
    }

    void setCatSelection(JComboBox combo, String mnem) {
        this.categories.setSelection(combo, mnem);
    }

    void loadCatGenOcc() throws SQLException {
        this.loadCategories();
        this.categories.loadGenOcc(this.sbdb);
    }

    void cleanTaxon(int specID, boolean convertCase, boolean clearCat, boolean spSpp) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to clean database taxon");
        }
        Taxon taxon = this.taxa.get(specID);
        if (taxon == null) {
            return;
        }
        Category cat = clearCat ? this.getNullCategory() : taxon.getGenus().getCategory();
        taxon.clean(convertCase, spSpp);
        taxon.getGenus().clean(convertCase, cat);
    }

    private Category getNullCategory() {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to find dummy category in connected workspace");
        }
        try {
            Category cat = this.getCategory("");
            if (cat == null) {
                cat = this.categories.add(this.sbdb, "", Discipline.MICRO, "no_category", Color.BLACK);
            }
            return cat;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Genus findGenus(Genus.Builder builder) {
        for (Genus g : this.genera.values()) {
            if (!g.equalsBuilder(builder, false)) continue;
            return g;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkDeleteGenus(int genID) throws SQLException {
        block6: {
            Genus genus = this.genera.get(genID);
            if (genus == null) {
                throw new IllegalArgumentException("Attempt to delete non-loaded genus: " + genID);
            }
            try {
                if (!genus.checkDelete(this.sbdb)) break block6;
                HashMap<Integer, Genus> hashMap = this.genera;
                synchronized (hashMap) {
                    this.genera.remove(genID);
                }
            }
            catch (SBException sbe) {
                System.out.println("WARNING: Genus not deleted: " + genus.getGenus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTaxa(Collection<Integer> specIDs, boolean delFss, ProgressBarMonitor prog) throws SQLException {
        if (specIDs.isEmpty()) {
            return;
        }
        HashSet<Integer> genIDs = new HashSet<Integer>();
        Iterator<Integer> it = specIDs.iterator();
        while (it.hasNext()) {
            Taxon taxon = this.taxa.get(it.next());
            if (taxon == null) continue;
            genIDs.add(taxon.getGenID());
        }
        Taxon.deleteSpecies(this.sbdb, specIDs, delFss, prog);
        Genus.deleteGenera(this.sbdb, genIDs);
        HashMap<Integer, Observable> hashMap = this.taxa;
        synchronized (hashMap) {
            it = specIDs.iterator();
            while (it.hasNext()) {
                this.taxa.remove(it.next());
            }
        }
        hashMap = this.genera;
        synchronized (hashMap) {
            it = genIDs.iterator();
            while (it.hasNext()) {
                this.genera.remove(it.next());
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshTaxa(Statement stmt) throws SQLException {
        HashMap<Integer, Observable> hashMap = this.genera;
        synchronized (hashMap) {
            PreparedStatement pStmtGenus = this.sbdb.getDatabase().prepareStatement(this.sbdb.modQuery("SELECT updated FROM " + this.sbdb.DBTableName("GENUS") + " WHERE gen_id=?"));
            Iterator<Genus> it = this.genera.values().iterator();
            while (it.hasNext()) {
                Genus genus = it.next();
                pStmtGenus.setInt(1, genus.getGenID());
                ResultSet rs = pStmtGenus.executeQuery();
                if (rs.next()) {
                    Timestamp time = rs.getTimestamp("updated");
                    if (time == null || genus.getUpdated() != null && !time.after(genus.getUpdated())) continue;
                    Genus.load(this.sbdb, genus.getGenID(), stmt, genus);
                    genus.notifyObservers();
                    continue;
                }
                it.remove();
            }
        }
        hashMap = this.taxa;
        synchronized (hashMap) {
            PreparedStatement pStmtSpeciesUpdate = this.sbdb.getDatabase().prepareStatement(this.sbdb.modQuery("SELECT updated FROM " + this.sbdb.DBTableName("SPECIES") + " WHERE spec_id=?"));
            Statement pStmt = null;
            Iterator<Taxon> it = this.taxa.values().iterator();
            while (it.hasNext()) {
                Taxon taxon = it.next();
                pStmtSpeciesUpdate.setInt(1, taxon.getSpecID());
                ResultSet rs = pStmtSpeciesUpdate.executeQuery();
                if (rs.next()) {
                    Timestamp time = rs.getTimestamp("updated");
                    if (time == null || taxon.getSpeciesUpdated() != null && !time.after(taxon.getSpeciesUpdated())) continue;
                    if (pStmt == null) {
                        pStmt = Taxon.getFillSpeciesStatement(this.sbdb);
                    }
                    Taxon.Builder builder = new Taxon.Builder();
                    int genID = Taxon.fillSpecies(taxon.getSpecID(), (PreparedStatement)pStmt, builder);
                    builder.genus(this.getGenus(genID));
                    taxon.copyFields(builder);
                    taxon.notifyObservers();
                    continue;
                }
                it.remove();
                this.setChanged();
            }
            if (pStmt != null) {
                pStmt.close();
            }
        }
        this.notifyObservers();
    }

    Taxon parse(String s, int specID, boolean notNull) {
        BuilderPair bp = TaxaMap.parse(s);
        if (bp == null) {
            if (notNull) {
                String string = s;
                for (int its = 3; bp == null && its > 0; --its) {
                    string = string + " unknown";
                    bp = TaxaMap.parse(string);
                }
                if (bp == null) {
                    throw new IllegalArgumentException("Cannot create Taxon from string: '" + s + "'");
                }
            } else {
                return null;
            }
        }
        if (this.categories == null) {
            try {
                this.categories = new Categories(null);
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        Category cat = this.getNullCategory();
        bp.genusBuilder.category(cat);
        Genus genus = this.findGenus(bp.genusBuilder);
        if (genus == null) {
            genus = bp.genusBuilder.build(this.nextGenID());
            genus = this.putGenus(genus.getGenID(), genus);
        }
        bp.taxonBuilder.genus(genus);
        Taxon taxon = bp.taxonBuilder.build(specID, this.sbdb);
        taxon.donorString = s;
        this.taxa.put(specID, taxon);
        return taxon;
    }

    void setTaxonCat(int specID, String cat_mnem) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to set taxon category in connected workspace");
        }
        Taxon taxon = this.taxa.get(specID);
        if (taxon == null) {
            return;
        }
        try {
            Category cat = this.categories.getCategory(cat_mnem);
            if (cat == null) {
                cat = this.categories.add(this.sbdb, cat_mnem, Discipline.MICRO, cat_mnem, Color.blue);
            }
            taxon.getGenus().clean(false, cat);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private int nextGenID() {
        int maxID = 1;
        for (Genus g : this.genera.values()) {
            if (g.getGenID() < maxID) continue;
            maxID = g.getGenID() + 1;
        }
        return maxID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(Taxon donor, Taxon target, int targetSpecType) throws SQLException, SBException {
        boolean genusDeleted;
        HashMap<Integer, Observable> hashMap = this.taxa;
        synchronized (hashMap) {
            genusDeleted = Taxon.merge(this.sbdb, true, donor.getSpecID(), target.getSpecID(), targetSpecType);
            this.sbdb.commit();
            if (this.taxa.remove(donor.getSpecID()) != null) {
                this.setChanged();
            }
        }
        if (genusDeleted) {
            hashMap = this.genera;
            synchronized (hashMap) {
                this.genera.remove(donor.getGenID());
            }
        }
    }

    public static BuilderPair parse(String s) {
        String stripped;
        int i;
        String[] arr = s.split(" ");
        if (arr.length < 1) {
            return null;
        }
        Genus.Builder genBuilder = new Genus.Builder();
        Taxon.Builder txBuilder = new Taxon.Builder();
        Qualifier q1 = genBuilder.getQualifier(0);
        Qualifier q2 = genBuilder.getQualifier(1);
        for (i = 0; i < arr.length; ++i) {
            if (!genBuilder.getName().isEmpty()) {
                if (arr[i].startsWith("(")) {
                    String subGen = arr[i].replaceAll("\\(", "");
                    genBuilder.subGenus(subGen);
                    break;
                }
                q1 = genBuilder.getQualifier(1);
                q2 = txBuilder.getQualifier(0);
                break;
            }
            stripped = TaxonQual.stripQualifiers(arr[i], q1, q2);
            if (stripped.isEmpty()) continue;
            genBuilder.genusName(stripped);
        }
        if (i == arr.length) {
            return null;
        }
        while (i < arr.length) {
            if (q1 == genBuilder.getQualifier(1) && (arr[i].endsWith(TaxonQual.Q.toString()) || arr[i].startsWith(TaxonQual.Q.toString())) || arr[i].endsWith(TaxonQual.QUOTE.toString()) || arr[i].startsWith(TaxonQual.QUOTE.toString())) {
                q1 = q2;
                q2 = txBuilder.getQualifier(1);
            }
            stripped = TaxonQual.stripQualifiers(arr[i], q1, q2);
            if (q1 == genBuilder.getQualifier(1) && q1.hasQuals()) {
                q1 = q2;
                q2 = txBuilder.getQualifier(1);
            }
            if (!stripped.isEmpty()) {
                if (txBuilder.getName().isEmpty() || !txBuilder.getQualifier(1).hasQuals()) {
                    txBuilder.speciesAdd(stripped);
                    q1 = txBuilder.getQualifier(1);
                    q2 = txBuilder.getQualifier(2);
                } else {
                    txBuilder.subSpecies(stripped);
                    ++i;
                    break;
                }
            }
            ++i;
        }
        if (txBuilder.getName().isEmpty()) {
            return null;
        }
        if (i < arr.length) {
            q1 = txBuilder.getQualifier(2);
            q2 = txBuilder.getQualifier(3);
            while (i < arr.length) {
                stripped = TaxonQual.stripQualifiers(arr[i], q1, q2);
                if (!stripped.isEmpty()) {
                    if (Character.isDigit(stripped.charAt(0))) {
                        for (int j = 0; j < stripped.length(); ++j) {
                            if (Character.isDigit(stripped.charAt(j))) continue;
                            txBuilder.year(Integer.parseInt(stripped.substring(0, j)));
                            stripped = stripped.substring(j);
                            break;
                        }
                    }
                    if (!stripped.isEmpty()) {
                        txBuilder.author((txBuilder.getAuthor().isEmpty() ? "" : txBuilder.getAuthor() + " ") + stripped);
                    }
                }
                ++i;
            }
        }
        return new BuilderPair(txBuilder, genBuilder);
    }

    public static BuilderPair copy(Taxon taxon) {
        Genus.Builder genBuilder = Genus.Builder.copyOf(taxon.getGenus());
        genBuilder.category(taxon.getGenus().getCategory());
        Taxon.Builder txBuilder = Taxon.Builder.copyOf(taxon);
        return new BuilderPair(txBuilder, genBuilder);
    }

    Taxon parseTaxon(Element xml, ZipFile zip) throws SBException, SQLException {
        String strgID;
        String cat_mnem = "";
        Genus.Builder genBuilder = new Genus.Builder();
        Taxon.Builder txBuilder = new Taxon.Builder();
        String strg = xml.getChildText("Category");
        if (strg != null) {
            cat_mnem = strg;
        }
        if ((strgID = xml.getChildTextNormalize("GenusID")) == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int genID = Integer.parseInt(strgID);
        strgID = xml.getChildTextNormalize("SpeciesID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int specID = Integer.parseInt(strgID);
        txBuilder.species(xml.getChildText("Species"));
        genBuilder.genusName(xml.getChildText("Genus"));
        strg = xml.getChildText("GQ1");
        if (strg != null) {
            genBuilder.qual(0, strg);
        }
        if ((strg = xml.getChildText("GQ2")) != null) {
            genBuilder.qual(1, strg);
        }
        if ((strg = xml.getChildText("GQ3")) != null) {
            genBuilder.qual(2, strg);
        }
        if ((strg = xml.getChildText("GQ4")) != null) {
            genBuilder.qual(3, strg);
        }
        if ((strg = xml.getChildText("SubGenus")) != null) {
            genBuilder.subGenus(strg);
        }
        if ((strg = xml.getChildText("SQ1")) != null) {
            txBuilder.qual(4, strg);
        }
        if ((strg = xml.getChildText("SQ2")) != null) {
            txBuilder.qual(5, strg);
        }
        if ((strg = xml.getChildText("SQ3")) != null) {
            txBuilder.qual(6, strg);
        }
        if ((strg = xml.getChildText("SQ4")) != null) {
            txBuilder.qual(7, strg);
        }
        if ((strg = xml.getChildText("SubSpecies")) != null) {
            txBuilder.subSpecies(strg);
        }
        if ((strg = xml.getChildText("Alphacode")) != null) {
            txBuilder.alphaCode(strg);
        }
        if ((strg = xml.getChildText("Author")) != null) {
            txBuilder.author(strg);
        }
        if ((strg = xml.getChildText("Notes")) != null) {
            txBuilder.notes(strg);
        }
        if ((strg = xml.getChildText("Reference")) != null) {
            txBuilder.reference(strg);
        }
        if ((strgID = xml.getChildTextNormalize("Year")) != null) {
            txBuilder.year(Integer.parseInt(strgID));
        }
        Taxon taxon = this.addTaxon(txBuilder, genBuilder, cat_mnem, specID, genID);
        taxon.donorString = taxon.toString(true, false);
        Iterator its = xml.getDescendants((Filter)new ElementFilter("ImageSet"));
        while (its.hasNext()) {
            Element xmlImageSet = (Element)its.next();
            Iterator it = xmlImageSet.getDescendants((Filter)new ElementFilter("Image"));
            int imageIndex = 0;
            if (taxon.wsImages == null) {
                taxon.wsImages = new LinkedList<ImageSet>();
            }
            ImageSet imageSet = new ImageSet(this.sbdb);
            while (it.hasNext()) {
                imageSet.insert(imageIndex++, new SBImage(this.sbdb, (Element)it.next(), zip));
            }
            taxon.wsImages.add(imageSet);
        }
        return taxon;
    }

    public static class BuilderPair {
        public final Taxon.Builder taxonBuilder;
        public final Genus.Builder genusBuilder;

        BuilderPair(Taxon.Builder txBuilder, Genus.Builder genBuilder) {
            if (txBuilder == null || genBuilder == null) {
                throw new IllegalArgumentException("Attempt to create BuilderPair with one or more null Builder");
            }
            this.taxonBuilder = txBuilder;
            this.genusBuilder = genBuilder;
        }

        public String toString() {
            String s = this.genusBuilder.getName();
            if (!this.genusBuilder.getSubGenus().isEmpty()) {
                s = s + " " + this.genusBuilder.getSubGenus();
            }
            s = s + " " + this.taxonBuilder.getName();
            if (!this.taxonBuilder.getSubSpecies().isEmpty()) {
                s = s + " " + this.taxonBuilder.getSubSpecies();
            }
            return s;
        }
    }
}

