/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.AttributedString;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import model2.Audit;
import model2.CoOccurrence;
import model2.Discipline;
import model2.Genus;
import model2.IGDUnit;
import model2.ImageSet;
import model2.Project;
import model2.Qualifier;
import model2.SBdb;
import model2.TaxonCompareAlphaCode;
import model2.TaxonCompareCategory;
import model2.TaxonCompareGenus;
import model2.TaxonCompareSIPMCode;
import model2.TaxonCompareSpecies;
import model2.TaxonOcc;
import model2.TaxonQual;
import model2.TxGroup;
import model2.Userdef;
import util.InvalidFieldException;
import util.ProgressBarMonitor;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class Taxon
extends Observable
implements Comparable,
SortEntry,
SbugsStatus,
Observer {
    private final SBdb sbdb;
    private final int specID;
    private Genus genus;
    private String species = "";
    private String subSpecies = "";
    private final Qualifier[] qualifiers;
    private String author = "";
    private int year;
    private String alphaCode = "";
    private String notes = null;
    private String reference = null;
    private Audit audit = new Audit();
    String donorString = "";
    String donorOccType = "In-situ";
    private Taxon link;
    private HashMap<Integer, Integer> sipmCode = null;
    public static final String INSITU_OCC = "In-situ";
    public static final String REWORKED_OCC = "Reworked";
    public static final String CAVED_OCC = "Caved";
    public static final String QUESTIONABLE_OCC = "Questionable";
    private int imageSetCount = -1;
    private int hasTypeImage = -1;
    List<ImageSet> wsImages = null;
    private ImageSet imageType = null;
    static SimpleDateFormat databaseDate = new SimpleDateFormat("yyyy-MM-dd");
    public static boolean includeAuthorInString = false;
    public static boolean includeCategoryInString = true;
    public static boolean includeAlphaInString = false;
    static int NQUAL = 8;
    static int[] preqal = new int[]{1, 0, 1, 0, 1, 0, 1, 0};
    static int NSYM = 9;
    static int MAXSYM = 6;
    static String[] qulsym = new String[]{"\"", "?", "cf.", "aff.", "ss.", "sl.", "grp.", "sensu", "var."};
    static int[][] symord = new int[][]{{1, 2, 3, 0, -1, -1}, {1, 0, 6, 4, 5, -1}, {2, 3, 0, -1, -1, -1}, {1, 0, 6, 4, 5, -1}, {2, 3, 0, -1, -1, -1}, {1, 0, 6, 4, 5, 7}, {2, 3, 0, 8, -1, -1}, {1, 0, 4, 5, 7, -1}};
    static int[][] mutexc = new int[][]{{1, 1, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 0, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 0, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 2, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 2}, {1, 1, 0, 0, 2, 2, 0, 2, 0}};

    public SBdb getDatabase() {
        return this.sbdb;
    }

    public Taxon getLink() {
        return this.link;
    }

    public Color getStatus() {
        if (this.link != null) {
            return STORED;
        }
        return NOTSTORED;
    }

    public void setLink(Taxon link) {
        this.link = link;
    }

    public int getSpecID() {
        return this.specID;
    }

    public String getSortEntry() {
        return this.toString(false, true);
    }

    public int getGenID() {
        return this.genus.getGenID();
    }

    public String getDonorString() {
        return this.donorString;
    }

    public String getDonorOccType() {
        return this.donorOccType;
    }

    public void setDonorOccType(String str) {
        this.donorOccType = str;
    }

    public String getCatMnem() {
        return this.genus.getCategory().getMnem();
    }

    public String getGenusName() {
        return this.genus.getGenus();
    }

    public String getSubGenus() {
        return this.genus.getSubGenus();
    }

    public String getSpecies() {
        return this.species;
    }

    public String getSubSpecies() {
        return this.subSpecies;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getYear() {
        return this.year;
    }

    public String getAlphaCode() {
        return this.alphaCode;
    }

    public Genus getGenus() {
        return this.genus;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    public Date getModified() {
        if (this.audit.modified != null) {
            return new Date(this.audit.modified.getTime());
        }
        return null;
    }

    public String getModifier() {
        if (this.audit.modifier < 1) {
            return "";
        }
        try {
            Userdef user = this.sbdb.getUser(this.audit.modifier);
            if (user != null) {
                return user.getAbr();
            }
            return "";
        }
        catch (SQLException sql) {
            return "Error loading users";
        }
    }

    public Qualifier getQualifier(int field) {
        if (field < 0 || field > 7) {
            throw new IllegalArgumentException("Attempt to get taxon qualifier " + field);
        }
        if (field < 4) {
            return this.genus.getQualifier(field);
        }
        return this.qualifiers[field - 4];
    }

    public Qualifier getQualifierSpecies(int field) {
        if (field < 0 || field > 3) {
            throw new IllegalArgumentException("Attempt to get taxon qualifier " + field);
        }
        return this.qualifiers[field];
    }

    public Qualifier getQ1() {
        return this.qualifiers[0];
    }

    public Qualifier getQ2() {
        return this.qualifiers[1];
    }

    public Qualifier getQ3() {
        return this.qualifiers[2];
    }

    public Qualifier getQ4() {
        return this.qualifiers[3];
    }

    public String getNotes() throws SQLException {
        this.loadNotesAndRefs();
        return this.notes;
    }

    public String getReference() throws SQLException {
        this.loadNotesAndRefs();
        return this.reference;
    }

    private static boolean containsQualifier(String donorString) {
        for (int i = 0; i < qulsym.length; ++i) {
            if (!donorString.contains(qulsym[i])) continue;
            return true;
        }
        return false;
    }

    void copyFields(Builder builder) {
        builder.validateFields();
        this.species = builder.species;
        this.subSpecies = builder.subSpecies;
        this.genus = builder.genus;
        System.arraycopy(builder.qualifiers, 0, this.qualifiers, 0, this.qualifiers.length);
        this.author = builder.author;
        this.year = builder.year;
        this.alphaCode = builder.alphaCode;
        this.audit = builder.audit;
        this.notes = builder.notes;
        this.reference = builder.reference;
        this.setChanged();
    }

    public void setAuthor(SBdb db, String author, int year) throws SQLException {
        if (db != null && this.specID > 0) {
            Audit tempAudit = new Audit(this.audit);
            Statement stmt = db.getDatabase().createStatement();
            String sql = "UPDATE " + db.DBTableName("species") + " SET author=" + SB.DBString((String)author);
            sql = year > 0 ? sql + ",year=" + year : sql + ",year=NULL";
            sql = sql + "," + tempAudit.sqlUpdate(db, stmt, false) + " WHERE spec_id=" + this.specID;
            sql = db.modQuery(sql);
            stmt.executeUpdate(sql);
            stmt.close();
            this.audit = tempAudit;
        }
        this.author = author;
        this.year = year;
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlphaCode(String alphaCode) throws SQLException {
        if (this.sbdb.isConnected()) {
            Audit tempAudit = new Audit(this.audit);
            Statement stmt = this.sbdb.getDatabase().createStatement();
            String sql = "UPDATE " + this.sbdb.DBTableName("species") + " SET alphacode=" + SB.DBString((String)alphaCode) + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE spec_id=" + this.specID;
            try {
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
            this.audit = tempAudit;
        }
        this.alphaCode = alphaCode;
        this.setChanged();
    }

    Date getSpeciesUpdated() {
        return this.audit.updated;
    }

    static PreparedStatement getFillSpeciesStatement(SBdb db) throws SQLException {
        String sql = "SELECT gen_id,q1,species,q2,q3,sub_spec,q4,author,year,alphaCode," + Audit.sqlFieldString();
        sql = sql + " FROM " + db.DBTableName("species") + " s WHERE spec_id=?";
        sql = db.modQuery(sql);
        PreparedStatement pStmt = db.getDatabase().prepareStatement(sql);
        return pStmt;
    }

    static int fillSpecies(int specID, PreparedStatement pStmt, Builder builder) throws SQLException {
        pStmt.setInt(1, specID);
        int genID = 0;
        ResultSet rs = pStmt.executeQuery();
        if (rs.next()) {
            genID = rs.getInt("gen_id");
            builder.qual(4, rs.getString("q1"));
            builder.species(rs.getString("species"));
            builder.qual(5, rs.getString("q2"));
            builder.qual(6, rs.getString("q3"));
            builder.subSpecies(rs.getString("sub_spec"));
            builder.qual(7, rs.getString("q4"));
            builder.author(rs.getString("author"));
            builder.year(rs.getInt("year"));
            builder.alphaCode(rs.getString("alphacode"));
            builder.audit(new Audit(rs));
        }
        return genID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSipmCode(int dictionary) throws SQLException {
        if (this.sipmCode == null) {
            this.sipmCode = new HashMap();
            String sql = "SELECT ccode,sipm_code FROM " + this.sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + this.specID;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int ccode = rs.getInt("ccode");
                    int code = rs.getInt("sipm_code");
                    this.sipmCode.put(ccode, code);
                }
            }
            finally {
                stmt.close();
            }
        }
        if (this.sipmCode.get(dictionary) == null) {
            String sql = "SELECT sipm_code FROM " + this.sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + this.specID + " AND ccode=" + dictionary;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    int code = rs.getInt("SIPM_CODE");
                    this.sipmCode.put(dictionary, code);
                }
            }
            finally {
                stmt.close();
            }
        }
        return this.sipmCode.get(dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkCoOccurrences(SBdb sbdb, int donor, int target, int targetSpecType, int wellListID, int restrictToWellID) throws SBException, SQLException {
        if (wellListID > 0 && restrictToWellID > 0) {
            throw new IllegalArgumentException("Error in call to checkOccOccurrences - can't specify both well list and wellID");
        }
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT w.well_name,w.units,v.well_id,v.well_code,s.top_depth,s.base_depth,s.type,f1.samp_id,f1.analy_id,f1.ident_type,f1.status,f1.spec_type_id FROM " + sbdb.DBTableName("TAXONOCC") + " f1, " + sbdb.DBTableName("TAXONOCC") + " f2," + sbdb.DBTableName("WELLS") + " w," + sbdb.DBTableName("WELL_IDENT") + " v," + sbdb.DBTableName("SAMPLES") + " s ";
        if (wellListID > 0) {
            sql = sql + ", " + sbdb.DBTableName("SBWLMB") + " l ";
        }
        sql = sql + " WHERE  f1.samp_id=f2.samp_id AND f1.analy_id=f2.analy_id AND f1.spec_id=" + donor + " AND f2.spec_id=" + target + " AND ((f1.status=f2.status) or (f1.status is null and f2.status is null)) " + " AND f1.ident_type=f2.ident_type " + " AND f1.spec_type_id=f2.spec_type_id " + " AND f1.well_id=f2.well_id " + " AND f1.samp_id=s.samp_id AND f1.well_id=v.well_id AND v.well_id=s.well_id AND w.well_code=v.well_code";
        if (wellListID > 0) {
            sql = sql + " AND s.well_id = l.well_id AND l.id=" + wellListID;
        }
        if (restrictToWellID > 0) {
            sql = sql + " AND s.well_id=" + restrictToWellID;
        }
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            LinkedList<CoOccurrence> coOccurrences = new LinkedList<CoOccurrence>();
            String lastCode = "";
            while (rs.next()) {
                String wellName = rs.getString("well_name");
                char units = SB.getDBChar((ResultSet)rs, (String)"units");
                int wellID = rs.getInt("well_id");
                String wellCode = rs.getString("well_code");
                String item = "";
                if (!wellCode.equals(lastCode)) {
                    item = wellName;
                    item = item + "(";
                    item = item + wellCode;
                    item = item + ")";
                    item = item + ", ";
                    lastCode = wellCode;
                } else {
                    item = item + "  ...";
                }
                BigDecimal topDepth = SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (sbdb.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                BigDecimal baseDepth = SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (sbdb.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                if (topDepth != null) {
                    item = item + SB.getDepthString((double)topDepth.doubleValue(), (char)units, (int)2);
                }
                if (baseDepth != null) {
                    if (topDepth != null) {
                        item = item + "-";
                    }
                    item = item + SB.getDepthString((double)baseDepth.doubleValue(), (char)units, (int)2);
                }
                item = item + ", ";
                item = item + rs.getString("type");
                item = item + " (SampID=";
                int sampID = rs.getInt("samp_id");
                item = item + sampID;
                item = item + ")";
                int analyID = rs.getInt("analy_id");
                char identType = SB.getDBChar((ResultSet)rs, (String)"ident_type");
                boolean reworked = SB.getDBChar((ResultSet)rs, (String)"status") == 'R';
                int specType = rs.getInt("spec_type_id");
                CoOccurrence coOcc = new CoOccurrence();
                coOcc.wellID = wellID;
                coOcc.sampID = sampID;
                coOcc.analyID = analyID;
                coOcc.reason = item;
                coOcc.target = TaxonOcc.load(sbdb, wellID, sampID, analyID, sbdb.getTaxon(target), reworked, identType, specType);
                coOcc.donor = TaxonOcc.load(sbdb, wellID, sampID, analyID, sbdb.getTaxon(donor), reworked, identType, specType);
                coOccurrences.add(coOcc);
            }
            if (coOccurrences.size() > 0) {
                SBException e = new SBException("Cannot update/merge taxon (ID=" + donor + ", to ID=" + target + ") because it would create co-occurring data\nThe samples in which this happens are listed");
                e.setData(coOccurrences);
                throw e;
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOccSpecType(int newSpecType) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT w.well_name,f1.well_id,f1.samp_id,f1.analy_id,f1.ident_type,f1.status,f1.spec_type_id FROM " + this.sbdb.DBTableName("TAXONOCC") + " f1, " + this.sbdb.DBTableName("TAXONOCC") + " f2," + this.sbdb.DBTableName("WELLS") + " w," + this.sbdb.DBTableName("WELL_IDENT") + " v" + " WHERE " + " f1.well_id=f2.well_id AND f1.samp_id=f2.samp_id AND f1.analy_id=f2.analy_id" + " AND f1.spec_id=" + this.specID + " AND f2.spec_id=" + this.specID + " AND ((f1.status=f2.status) or (f1.status is null and f2.status is null)) " + " AND f1.ident_type=f2.ident_type " + " AND f1.spec_type_id<>f2.spec_type_id" + " AND f1.well_id=v.well_id AND w.well_code=v.well_code";
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            HashMap<String, Integer> occs = new HashMap<String, Integer>();
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int sampID = rs.getInt("samp_id");
                int analyID = rs.getInt("analy_id");
                char identType = rs.getString("ident_type").charAt(0);
                char status = rs.getString("status").charAt(0);
                int specType = rs.getInt("spec_type_id");
                String wellName = rs.getString("well_name");
                String key = "" + wellID + sampID + analyID + identType + status;
                if (occs.get(key) != null) {
                    throw new SBException("Cannot update sub-type for '" + this + "' because it would cause conflicting occurrences in well " + wellName + ".");
                }
                occs.put(key, specType);
            }
            sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET spec_type_id=" + newSpecType + " WHERE spec_id=" + this.specID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadAll(SBdb sbdb, HashMap<Integer, Taxon> set, HashMap<Integer, Genus> genera) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT gen_id,spec_id,q1,species,q2,q3,sub_spec,q4,author,year,alphacode," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("species") + " ORDER BY spec_id";
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int genID = rs.getInt("gen_id");
                int specID = rs.getInt("spec_id");
                if (set.get(specID) != null) continue;
                Builder builder = new Builder();
                builder.genus(genera.get(genID));
                builder.qual(4, rs.getString("q1"));
                builder.species(SB.getDBString((ResultSet)rs, (String)"species"));
                builder.qual(5, rs.getString("q2"));
                builder.qual(6, rs.getString("q3"));
                builder.subSpecies(rs.getString("sub_spec"));
                builder.qual(7, rs.getString("q4"));
                builder.year(rs.getInt("year"));
                builder.alphaCode(rs.getString("alphaCode"));
                builder.audit(new Audit(rs));
                try {
                    Taxon t = builder.build(specID, sbdb);
                    set.put(t.specID, t);
                }
                catch (RuntimeException re) {
                    SB.showStackError((String)"", (Exception)re);
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    static boolean merge(SBdb sbdb, boolean checkCoOccurrences, int donor, int target, int targetSpecType) throws SBException, SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        if (checkCoOccurrences) {
            Taxon.checkCoOccurrences(sbdb, donor, target, targetSpecType, 0, 0);
        }
        Statement stmt2 = sbdb.getDatabase().createStatement();
        String sql = "SELECT grp_id FROM " + sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=" + target;
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            int grpID = rs.getInt("grp_id");
            sql = "DELETE FROM ";
            sql = sql + sbdb.DBTableName("GROUPMBR");
            sql = sql + " WHERE spec_id=" + donor;
            sql = sql + " AND grp_id=" + grpID;
            stmt2.executeUpdate(sbdb.modQuery(sql));
        }
        sql = "UPDATE " + sbdb.DBTableName("GROUPMBR") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
        stmt.executeUpdate(sbdb.modQuery(sql));
        sql = "SELECT ovr_id FROM ";
        sql = sql + sbdb.DBTableName("OVR_MAP");
        sql = sql + " WHERE spec_id=" + target;
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            int ovrID = rs.getInt("ovr_id");
            sql = "DELETE FROM ";
            sql = sql + sbdb.DBTableName("OVR_MAP");
            sql = sql + " WHERE spec_id=" + donor;
            sql = sql + " AND ovr_id=" + ovrID;
            stmt2.executeUpdate(sbdb.modQuery(sql));
        }
        try {
            sql = "UPDATE " + sbdb.DBTableName("OVR_MAP") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        catch (SQLException ex) {
            sql = "DELETE FROM " + sbdb.DBTableName("OVR_MAP") + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        sql = "SELECT pref,sch_id FROM ";
        sql = sql + sbdb.DBTableName("SYNONYMY");
        sql = sql + " WHERE spec_id=" + target;
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            int prefID = rs.getInt("pref");
            int schID = rs.getInt("sch_id");
            sql = "DELETE FROM ";
            sql = sql + sbdb.DBTableName("SYNONYMY");
            sql = sql + " WHERE spec_id=" + donor;
            sql = sql + " AND pref=" + prefID;
            sql = sql + " AND sch_id=" + schID;
            stmt2.executeUpdate(sbdb.modQuery(sql));
        }
        stmt2.close();
        sql = "UPDATE " + sbdb.DBTableName("SYNONYMY") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
        stmt.executeUpdate(sbdb.modQuery(sql));
        try {
            sql = "UPDATE " + sbdb.DBTableName("SIPMCODE") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        catch (SQLException ex) {
            sql = "DELETE FROM " + sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        sql = "UPDATE " + sbdb.DBTableName("TAXONOCC") + " SET spec_id=" + target;
        if (targetSpecType > -1) {
            sql = sql + ",spec_type_id=" + targetSpecType;
        }
        sql = sql + " WHERE spec_id=" + donor;
        System.out.println("SQL: " + sbdb.modQuery(sql));
        stmt.executeUpdate(sbdb.modQuery(sql));
        int donorGenID = 0;
        sql = "SELECT gen_id FROM " + sbdb.DBTableName("species") + " WHERE spec_id=" + donor;
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            donorGenID = rs.getInt("gen_id");
        }
        try {
            sql = "UPDATE " + sbdb.DBTableName("TXLOAD") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        catch (SQLException ex) {
            sql = "DELETE FROM " + sbdb.DBTableName("TXLOAD") + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        try {
            sql = "UPDATE " + sbdb.DBTableName("TXDEPTH") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        catch (SQLException ex) {
            sql = "DELETE FROM " + sbdb.DBTableName("TXDEPTH") + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        try {
            sql = "UPDATE " + sbdb.DBTableName("TXNOTES") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        catch (SQLException ex) {
            sql = "DELETE FROM " + sbdb.DBTableName("TXNOTES") + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        try {
            sql = "UPDATE " + sbdb.DBTableName("TXREFS") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        catch (SQLException ex) {
            sql = "DELETE FROM " + sbdb.DBTableName("TXREFS") + " WHERE spec_id=" + donor;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        sql = "UPDATE " + sbdb.DBTableName("TXIMAGE") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
        stmt.executeUpdate(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=" + donor;
        stmt.executeUpdate(sbdb.modQuery(sql));
        boolean deleteGenus = true;
        sql = "SELECT gen_id FROM " + sbdb.DBTableName("species") + " WHERE gen_id=" + donorGenID;
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next()) {
            deleteGenus = false;
        }
        if (deleteGenus) {
            sql = "DELETE FROM " + sbdb.DBTableName("genus") + " WHERE gen_id=" + donorGenID;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        stmt.close();
        return deleteGenus;
    }

    public int checkNSpeciesOfGenus() throws SQLException {
        if (this.sbdb == null) {
            throw new IllegalStateException("database reference null in checkNspecies");
        }
        if (this.genus == null) {
            throw new IllegalStateException("Genus ID zero in checkNspecies");
        }
        return this.genus.checkNSpecies(this.sbdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(SBdb sbdb, Builder builder) throws SQLException {
        if (sbdb.isConnected()) {
            Statement stmt = sbdb.getDatabase().createStatement();
            String sql = "UPDATE " + sbdb.DBTableName("species") + " SET gen_id=" + builder.genus.getGenID() + ",q1=" + SB.DBString((String)builder.qualifiers[0].toString(null)) + ",q2=" + SB.DBString((String)builder.qualifiers[1].toString(null)) + ",q3=" + SB.DBString((String)builder.qualifiers[2].toString(null)) + ",q4=" + SB.DBString((String)builder.qualifiers[3].toString(null)) + ",species=" + SB.DBString((String)builder.species) + ",sub_spec=" + SB.DBString((String)builder.subSpecies) + ",author=" + SB.DBString((String)builder.author);
            sql = builder.year > 0 ? sql + ",year=" + builder.year : sql + ",year=NULL";
            sql = sql + ",alphacode=" + SB.DBString((String)builder.alphaCode) + "," + builder.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE spec_id=" + this.specID;
            try {
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
        }
        this.copyFields(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkOcc(boolean withSpecType) throws SQLException {
        if (this.specID < 1) {
            return 0;
        }
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkOcc()");
        }
        int nSpecies = 0;
        String sql = "SELECT count(spec_id) as nspecies FROM ";
        sql = sql + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.specID;
        if (withSpecType) {
            sql = sql + " AND spec_type_id > 0";
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                nSpecies += rs.getInt("nspecies");
            }
        }
        finally {
            stmt.close();
        }
        return nSpecies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkOcc(int specTypeID) throws SQLException {
        if (this.specID < 1) {
            return 0;
        }
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkOcc()");
        }
        int nSpecies = 0;
        String sql = "SELECT count(spec_id) as nspecies FROM ";
        sql = sql + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.specID + " AND spec_type_id=" + specTypeID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                nSpecies += rs.getInt("nspecies");
            }
        }
        finally {
            stmt.close();
        }
        return nSpecies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkGroupOcc() throws SQLException {
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkGroupOcc()");
        }
        int nGroups = 0;
        String sql = "SELECT count(grp_id) as ngroup FROM ";
        sql = sql + this.sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=" + this.specID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                nGroups += rs.getInt("ngroup");
            }
        }
        finally {
            stmt.close();
        }
        return nGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDB(SBdb sbdb) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "INSERT INTO " + sbdb.DBTableName("species") + " ( gen_id, species, spec_id ";
        if (this.qualifiers[0].hasQuals()) {
            sql = sql + ",q1";
        }
        if (this.qualifiers[1].hasQuals()) {
            sql = sql + ",q2";
        }
        if (this.qualifiers[2].hasQuals()) {
            sql = sql + ",q3";
        }
        if (!this.subSpecies.isEmpty()) {
            sql = sql + ",sub_spec";
        }
        if (this.qualifiers[3].hasQuals()) {
            sql = sql + ",q4";
        }
        if (!this.author.isEmpty()) {
            sql = sql + ",author";
        }
        if (this.year > 0) {
            sql = sql + ",year";
        }
        if (!this.alphaCode.isEmpty()) {
            sql = sql + ",alphacode";
        }
        sql = sql + "," + Audit.sqlFieldString();
        sql = sql + ") VALUES (" + this.genus.getGenID() + "," + SB.DBString((String)this.species) + "," + this.specID;
        if (this.qualifiers[0].hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.qualifiers[0].toString(null));
        }
        if (this.qualifiers[1].hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.qualifiers[1].toString(null));
        }
        if (this.qualifiers[2].hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.qualifiers[2].toString(null));
        }
        if (!this.subSpecies.isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.subSpecies);
        }
        if (this.qualifiers[3].hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.qualifiers[3].toString(null));
        }
        if (!this.author.isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.author);
        }
        if (this.year > 0) {
            sql = sql + "," + this.year;
        }
        if (!this.alphaCode.isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.alphaCode);
        }
        sql = sql + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNoteRefs(String notes, String reference) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.sbdb.DBTableName("TXNOTES") + " WHERE spec_id=" + this.specID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (notes.length() > 0) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("TXNOTES") + " (spec_id,notes) VALUES (" + this.specID + "," + SB.DBString((String)notes) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            sql = "DELETE FROM " + this.sbdb.DBTableName("TXREFS") + " WHERE spec_id=" + this.specID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (reference.length() > 0) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("TXREFS") + " (spec_id,reference) VALUES (" + this.specID + "," + SB.DBString((String)reference) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        finally {
            stmt.close();
        }
        this.notes = notes;
        this.reference = reference;
    }

    void clean(boolean convertSpeciesCase, Boolean spSpp) {
        if (convertSpeciesCase) {
            this.species = Taxon.toSpeciesCase(this.species);
            this.subSpecies = Taxon.toSpeciesCase(this.subSpecies);
        }
        if (spSpp.booleanValue()) {
            if ((this.species.equals("sp") || this.species.equals("sp.")) && this.subSpecies.isEmpty()) {
                this.species = "spp.";
            }
            if (this.species.equals("spp")) {
                this.species = "spp.";
            }
        } else {
            if (this.species.equals("sp") && this.subSpecies.isEmpty()) {
                this.species = "sp.";
            }
            if (this.species.equals("spp")) {
                this.species = "spp.";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List lookupSpecies(SBdb sbdb, String catMnem, String genus, String species) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String sql = "SELECT s.species, s.sub_spec FROM " + sbdb.DBTableName("GENUS") + " g," + sbdb.DBTableName("SPECIES") + " s WHERE ";
        if (!catMnem.isEmpty()) {
            sql = sql + "g.cat_mnem='" + catMnem + "' AND ";
        }
        if (!genus.isEmpty()) {
            sql = sql + " ucase(g.genus)='" + genus.toUpperCase() + "' AND ";
        }
        if (!species.isEmpty()) {
            sql = sql + " ucase(s.species) like '" + species.toUpperCase() + "%' AND";
        }
        sql = sql + " g.gen_id=s.gen_id ORDER by species";
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                String item = rs.getString("species");
                String subSpec = rs.getString("sub_spec");
                if (subSpec != null && subSpec.length() > 0) {
                    item = item + " subsp. " + subSpec;
                }
                list.add(item);
            }
        }
        finally {
            stmt.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void loadNotesAndRefs() throws SQLException {
        if (this.notes != null && this.reference != null) {
            return;
        }
        if (this.sbdb.isConnected()) {
            String sql = "SELECT notes FROM " + this.sbdb.DBTableName("TXNOTES") + " WHERE spec_id=" + this.specID;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    this.notes = rs.getString("notes");
                }
                if (!(rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT reference FROM " + this.sbdb.DBTableName("TXREFS") + " WHERE spec_id=" + this.specID))).next()) return;
                this.reference = rs.getString("reference");
                return;
            }
            finally {
                stmt.close();
            }
        } else {
            this.notes = "";
            this.reference = "";
        }
    }

    public Discipline getDisc() {
        return this.genus.getDisc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Taxon[] load(SBdb sbdb, Genus g, String species, String subSpecies, Qualifier sq1, Qualifier sq2, Qualifier sq3, Qualifier sq4) throws SQLException {
        String sql = "SELECT spec_id, species, q1, q2, q3, sub_spec, q4, author, year, alphacode," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("SPECIES");
        sql = sql + " WHERE ucase(species)=" + SB.DBString((String)species.toUpperCase()) + " AND gen_id=" + g.getGenID();
        if (sq1 != null) {
            sql = sq1.hasQuals() ? sql + " AND lcase(q1)='" + sq1 + "'" : sql + " AND (q1 IS NULL or q1='')";
        }
        if (sq2 != null) {
            sql = sq2.hasQuals() ? sql + " AND lcase(q2)='" + sq2 + "'" : sql + " AND (q2 IS NULL or q2='')";
        }
        if (sq3 != null) {
            sql = sq3.hasQuals() ? sql + " AND lcase(q3)='" + sq3 + "'" : sql + " AND (q3 IS NULL or q3='')";
        }
        if (subSpecies != null) {
            sql = !subSpecies.isEmpty() ? sql + " AND ucase(sub_spec)=" + SB.DBString((String)subSpecies.toUpperCase()) : sql + " AND (sub_spec IS NULL or sub_spec='')";
        }
        if (sq4 != null) {
            sql = sq4.hasQuals() ? sql + " AND lcase(q4)='" + sq4 + "'" : sql + " AND (q4 IS NULL or q4='')";
        }
        LinkedList<Taxon> results = new LinkedList<Taxon>();
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                Builder builder = new Builder();
                int specID = rs.getInt("spec_id");
                builder.genus(g);
                builder.species(rs.getString("species"));
                builder.qual(4, rs.getString("q1"));
                builder.qual(5, rs.getString("q2"));
                builder.qual(6, rs.getString("q3"));
                builder.subSpecies(rs.getString("sub_spec"));
                builder.qual(7, rs.getString("q4"));
                builder.author(rs.getString("author"));
                builder.year(rs.getInt("year"));
                builder.alphaCode(rs.getString("alphacode"));
                results.add(builder.build(specID, sbdb));
            }
        }
        finally {
            stmt.close();
        }
        if (!results.isEmpty()) {
            return results.toArray(new Taxon[results.size()]);
        }
        return null;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.toString(includeAuthorInString, includeAlphaInString, includeCategoryInString);
    }

    public AttributedString toAttributedString(boolean useAuthor, boolean includeCat) {
        return this.toAttributedString(useAuthor, includeCat, null, null);
    }

    public AttributedString toAttributedString(boolean useAuthor, boolean includeCat, Integer synschID) {
        return this.toAttributedString(useAuthor, includeCat, null, synschID);
    }

    public AttributedString toAttributedString(boolean useAuthor, boolean includeCat, String suffix, Integer synschID) {
        LinkedList<Integer> italicsPos = new LinkedList<Integer>();
        String string = this.toString(useAuthor, includeCat, italicsPos, false);
        if (suffix != null) {
            string = string + suffix;
        }
        if (synschID != null) {
            try {
                Taxon pref = this.getPreferred(synschID);
                if (pref != null) {
                    LinkedList<Integer> italicsPos2 = new LinkedList<Integer>();
                    String prefString = pref.toString(useAuthor, includeCat, italicsPos2, false);
                    string = string + "  (";
                    for (Integer i : italicsPos2) {
                        italicsPos.add(i + string.length());
                    }
                    string = string + prefString + ")";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AttributedString ats = new AttributedString(string);
        Iterator it = italicsPos.iterator();
        while (it.hasNext()) {
            ats.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, (Integer)it.next(), (Integer)it.next());
        }
        return ats;
    }

    public String toQuotedString(boolean useAuthor) {
        String strg = this.toString(useAuthor, false, null, true);
        if (strg.indexOf(44) >= 0) {
            if (strg.indexOf(34) >= 0) {
                strg = strg.replace('\"', '\'');
            }
            strg = "\"" + strg + "\"";
        }
        return strg;
    }

    public String toString(boolean useAuthor, boolean useAlphaCode, boolean includeCat) {
        String name = this.toString(useAuthor, includeCat, null, false);
        if (useAlphaCode && this.alphaCode != null && this.alphaCode.length() > 0) {
            name = name + " (" + this.alphaCode + ")";
        }
        return name;
    }

    public String toString(boolean useAuthor) {
        return this.toString(useAuthor, false, true);
    }

    public String toString(boolean useAuthor, boolean includeCat) {
        return this.toString(useAuthor, false, includeCat);
    }

    public String toGenString(boolean abr, boolean includeCat) {
        if (!abr) {
            return this.toString(false, includeCat, null, false);
        }
        String strg = "";
        if (includeCat) {
            strg = this.getCatMnem();
            while (strg.length() < 6) {
                strg = strg + ' ';
            }
        }
        String genString = this.species.equals("spp.") || this.species.startsWith("sp. ") || this.species.equals("fragments") || this.species.equals("group") || this.species.equals(".") ? this.getGenusName() : this.getGenusName().charAt(0) + ".";
        return strg + genString + " " + (this.species.equals(".") ? "" : this.species);
    }

    private String toString(boolean useAuthor, boolean includeCat, List<Integer> italics, boolean includeDotSpecName) {
        String name = this.genus.toString(includeCat, italics);
        boolean italicsFlag = false;
        if (!(this.species.isEmpty() || !includeDotSpecName && this.species.equals("."))) {
            name = name + " ";
            if (this.qualifiers[0].hasQuals()) {
                name = name + this.qualifiers[0].toString(true);
            }
            if (!this.species.startsWith("sp.") && !this.species.startsWith("spp.") && italics != null) {
                italics.add(name.length());
                italicsFlag = true;
            }
            name = name + this.species;
            if (italicsFlag) {
                italics.add(name.length());
            }
            if (this.qualifiers[1].hasQuals()) {
                name = name + this.qualifiers[1].toString(false);
            }
        }
        name = name.trim();
        if (this.qualifiers[2].hasQuals()) {
            name = name + " " + this.qualifiers[2].toString(true);
        }
        if (this.subSpecies != null && this.subSpecies.length() > 0) {
            if (italicsFlag && this.qualifiers[1].hasQual(TaxonQual.SENSU)) {
                italicsFlag = false;
            }
            if (italicsFlag) {
                italics.add(name.length());
            }
            name = name + " " + this.subSpecies;
            if (italicsFlag) {
                italics.add(name.length());
            }
        }
        if (this.qualifiers[3].hasQuals()) {
            name = name + this.qualifiers[3].toString(false);
        }
        if (this.qualifiers[3].hasQuals()) {
            name = name + this.qualifiers[3].toString(false);
        }
        if ((name = name + this.getAuthorString(useAuthor)).length() == 0 && this.donorString != null && this.donorString.length() > 0) {
            name = this.donorString;
        }
        return name.trim();
    }

    public String getAuthorString(boolean useAuthor) {
        String name = "";
        if (useAuthor || this.qualifiers[1].hasQual(TaxonQual.SENSU) && this.subSpecies.isEmpty() || this.qualifiers[3].hasQual(TaxonQual.SENSU)) {
            if (this.author != null && !this.author.isEmpty()) {
                name = name + " " + this.author;
            }
            if (this.year != 0) {
                name = name + ", " + String.valueOf(this.year);
            }
        }
        return name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != Taxon.class) {
            return false;
        }
        return ((Taxon)o).specID == this.specID && ((Taxon)o).sbdb == this.sbdb;
    }

    public int compareTo(Object rhs) {
        return this.compareTo((Taxon)rhs);
    }

    public int compareTo(Taxon rhs) {
        int result = this.getGenusName().compareToIgnoreCase(rhs.getGenusName());
        if (result != 0) {
            return result;
        }
        if (!this.getSubGenus().isEmpty() && (result = this.getSubGenus().compareToIgnoreCase(rhs.getSubGenus())) != 0) {
            return result;
        }
        result = this.species.compareToIgnoreCase(rhs.species);
        if (result != 0) {
            return result;
        }
        result = this.subSpecies.compareToIgnoreCase(rhs.subSpecies);
        if (result != 0) {
            return result;
        }
        result = this.genus.getQ1().toString().compareTo(rhs.genus.getQ1().toString());
        if (result != 0) {
            return result;
        }
        result = this.genus.getQ2().toString().compareTo(rhs.genus.getQ2().toString());
        if (result != 0) {
            return result;
        }
        result = this.genus.getQ3().toString().compareTo(rhs.genus.getQ3().toString());
        if (result != 0) {
            return result;
        }
        result = this.genus.getQ4().toString().compareTo(rhs.genus.getQ4().toString());
        if (result != 0) {
            return result;
        }
        result = this.getQ1().toString().compareTo(rhs.getQ1().toString());
        if (result != 0) {
            return result;
        }
        result = this.getQ2().toString().compareTo(rhs.getQ2().toString());
        if (result != 0) {
            return result;
        }
        result = this.getQ3().toString().compareTo(rhs.getQ3().toString());
        if (result != 0) {
            return result;
        }
        result = this.getQ4().toString().compareTo(rhs.getQ4().toString());
        return result;
    }

    public int hashCode() {
        return this.specID;
    }

    public void setFssOccType(TaxonOcc fss) throws SBException, SQLException {
        if (this.donorOccType != null && !this.donorOccType.isEmpty()) {
            if (this.donorOccType.equalsIgnoreCase(REWORKED_OCC)) {
                fss.setReworked(true, true);
            } else if (this.donorOccType.equalsIgnoreCase(CAVED_OCC)) {
                fss.setCaved(true, true);
            } else if (this.donorOccType.equalsIgnoreCase(QUESTIONABLE_OCC)) {
                fss.setIdentType('?', true);
            } else {
                String existing = "";
                if (fss.getSpecType() > 0 && !(existing = existing + fss.getSpecTypeString()).isEmpty()) {
                    existing = existing + "/";
                }
                int specType = this.sbdb.getAddSpecType(existing + this.donorOccType);
                fss.setSpecType(specType);
            }
        }
    }

    public void writeDEX(FileWriter out, String eol, boolean usePreferredTerm, int synScheme) throws IOException, SQLException, SBException {
        Taxon taxon;
        if (usePreferredTerm && (taxon = this.getPreferred(synScheme)) != null) {
            taxon.writeDEX(out, eol, usePreferredTerm, synScheme);
            return;
        }
        out.write("Species = " + this.toString(true, false, false) + eol);
        out.write("   ID : " + this.getSpecID() + eol);
        this.genus.writeDEX(out, eol);
        if (this.getQ1().hasQuals()) {
            out.write("   Pre-Species qualifier : " + this.getQ1().toString() + eol);
        }
        out.write("   Species : " + this.species + eol);
        if (this.getQ2().hasQuals()) {
            out.write("   Post-Species qualifier : " + this.getQ2().toString() + eol);
        }
        if (this.getQ3().hasQuals()) {
            out.write("   Pre-Subspecies qualifier : " + this.getQ3().toString() + eol);
        }
        if (this.subSpecies != null && this.subSpecies.length() > 0) {
            out.write("   Subspecies : " + this.subSpecies + eol);
        }
        if (this.getQ4().hasQuals()) {
            out.write("   Post-Subspecies qualifier : " + this.getQ4().toString() + eol);
        }
        if (this.author != null && this.author.length() > 0) {
            out.write("   Author : " + this.author + eol);
        }
        if (this.year > 0) {
            out.write("   Year : " + this.year + eol);
        }
        if (this.alphaCode != null && this.alphaCode.length() > 0) {
            out.write("   Alphanumeric Code : " + this.alphaCode + eol);
        }
        out.write(eol);
    }

    @Deprecated
    public void writeSbugs(FileWriter out) throws IOException {
        out.write(String.valueOf(this.specID) + '\t' + this.toString() + '\n');
        out.write(this.getCatMnem() + '\t' + this.genus.getQ1().toString(true) + '\t' + this.getGenusName() + '\t' + this.genus.getQ2().toString(false) + '\t' + this.genus.getQ3().toString(true) + '\t' + this.getSubGenus() + '\t' + this.genus.getQ4().toString(false) + '\t' + this.getQ1().toString() + '\t' + this.species + '\t' + this.getQ2().toString() + '\t' + this.getQ3().toString() + '\t' + this.subSpecies + '\t' + this.getQ4().toString() + '\t' + this.author + '\t');
        if (this.year > 0) {
            out.write(this.year);
        }
        out.write("\t\n");
    }

    public void writeXMLSpecies(BufferedWriter out, int indent) throws IOException, SQLException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        if (this.specID > 0) {
            out.write(ind + "<SpeciesID>" + this.specID + "</SpeciesID>\n");
        }
        if (this.getQ1().hasQuals()) {
            out.write(ind);
            out.write("<SQ1>");
            out.write(this.getQ1().toString());
            out.write("</SQ1>\n");
        }
        out.write(ind);
        out.write("<Species>");
        out.write(SB.getXMLstring((String)this.species));
        out.write("</Species>\n");
        if (this.getQ2().hasQuals()) {
            out.write(ind);
            out.write("<SQ2>");
            out.write(this.getQ2().toString());
            out.write("</SQ2>\n");
        }
        if (this.getQ3().hasQuals()) {
            out.write(ind);
            out.write("<SQ3>");
            out.write(this.getQ3().toString());
            out.write("</SQ3>\n");
        }
        if (this.subSpecies != null && this.subSpecies.length() > 0) {
            out.write(ind);
            out.write("<SubSpecies>");
            out.write(SB.getXMLstring((String)this.subSpecies));
            out.write("</SubSpecies>\n");
        }
        if (this.getQ4().hasQuals()) {
            out.write(ind);
            out.write("<SQ4>");
            out.write(this.getQ4().toString());
            out.write("</SQ4>\n");
        }
        if (this.author != null && this.author.length() > 0) {
            out.write(ind);
            out.write("<Author>");
            out.write(SB.getXMLstring((String)this.author));
            out.write("</Author>\n");
        }
        if (this.year > 0) {
            out.write(ind);
            out.write("<Year>");
            out.write(String.valueOf(this.year));
            out.write("</Year>\n");
        }
        if (this.alphaCode != null && this.alphaCode.length() > 0) {
            out.write(ind);
            out.write("<Alphacode>");
            out.write(SB.getXMLstring((String)this.alphaCode));
            out.write("</Alphacode>\n");
        }
        if (this.reference != null && this.reference.length() > 0) {
            out.write(ind);
            out.write("<Reference>");
            out.write(SB.getXMLstring((String)this.reference));
            out.write("</Reference>\n");
        }
        if (this.notes != null && this.notes.length() > 0) {
            out.write(ind);
            out.write("<Notes>");
            out.write(SB.getXMLstring((String)this.notes));
            out.write("</Notes>\n");
        }
    }

    public void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        this.genus.writeXML(out, indent, files);
        this.writeXMLSpecies(out, indent);
        if (files != null) {
            String ind = new String();
            while (ind.length() < indent) {
                ind = ind + ' ';
            }
            List<ImageSet> types = this.getImageTypes();
            if (types != null) {
                for (ImageSet set : types) {
                    set.writeXML(out, ind, files, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSipmCode(int dictionary, Integer code) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT COUNT(*) FROM " + this.sbdb.DBTableName("sipmcode") + " WHERE ccode=" + dictionary + " AND sipm_code=" + code + " AND spec_id<>" + this.specID;
        try {
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int count = rs.getInt(1);
                if (count <= 0) continue;
                throw new SBException("SIPM code is not unique to dictionary");
            }
            sql = "DELETE FROM " + this.sbdb.DBTableName("sipmcode") + " WHERE ccode=" + dictionary + " AND spec_id=" + this.specID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (code != null) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("sipmcode") + "(spec_ID,ccode,sipm_code) VALUES (" + this.specID + "," + dictionary + "," + code + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        finally {
            stmt.close();
        }
        if (this.sipmCode != null) {
            this.sipmCode.remove(dictionary);
        } else {
            this.sipmCode = new HashMap();
        }
        if (code != null) {
            this.sipmCode.put(dictionary, code);
        }
    }

    public Taxon getPreferred(int synSch) throws SQLException, SBException {
        if (this.specID > 0) {
            return this.sbdb.getPreferredTerm(synSch, this.specID);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEvents() throws SQLException {
        String sql = "SELECT count(spec_id) AS total FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=" + this.specID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        int nRows = 0;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                nRows = rs.getInt("total");
            }
        }
        finally {
            stmt.close();
        }
        return nRows > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStats(int[] stats) throws SQLException {
        String sql = "SELECT status,ident_type,caved FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.specID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            for (int i = 0; i < stats.length; ++i) {
                stats[i] = 0;
            }
            while (rs.next()) {
                char status = SB.getDBChar((ResultSet)rs, (String)"status");
                char identType = SB.getDBChar((ResultSet)rs, (String)"ident_type");
                char caved = SB.getDBChar((ResultSet)rs, (String)"caved");
                stats[0] = stats[0] + 1;
                if (status == 'R') {
                    stats[2] = stats[2] + 1;
                } else {
                    stats[1] = stats[1] + 1;
                }
                if (identType == '?') {
                    stats[4] = stats[4] + 1;
                } else {
                    stats[3] = stats[3] + 1;
                }
                if (caved == 'Y') {
                    stats[5] = stats[5] + 1;
                    continue;
                }
                stats[6] = stats[6] + 1;
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateOcc(String field, char value) throws SQLException {
        String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET " + field + "='" + value + "' WHERE spec_id=" + this.specID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            int nUpdated;
            int n = nUpdated = stmt.executeUpdate(this.sbdb.modQuery(sql));
            return n;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeMatch(String sourceID, String donorString, String donorOccType, SBdb db) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        try {
            String sql = "DELETE FROM " + db.DBTableName("TXLOAD") + " WHERE source_id='" + sourceID + "' AND ucase(txt)=" + SB.DBString((String)donorString.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5'));
            int nRows = stmt.executeUpdate(db.modQuery(sql));
            if (nRows == 0) {
                sql = "DELETE FROM " + db.DBTableName("TXLOAD") + " WHERE source_id='" + sourceID + "' AND txt=" + SB.DBString((String)donorString);
                stmt.executeUpdate(db.modQuery(sql));
            }
            if (this.link != null && (!donorString.equals(this.link.toString(false, false, null, true)) || !this.link.getCatMnem().equals(this.getCatMnem()) || Taxon.containsQualifier(donorString) || !this.link.getSubGenus().isEmpty() || this.link.subSpecies != null && this.link.subSpecies.length() > 0)) {
                sql = "INSERT INTO " + db.DBTableName("TXLOAD") + " (source_id,spec_id,txt,occ_type";
                sql = sql + ") VALUES('" + sourceID + "'," + this.link.specID + "," + SB.DBString((String)donorString);
                sql = sql + "," + SB.DBString((String)donorOccType);
                sql = sql + ")";
                stmt.executeUpdate(db.modQuery(sql));
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void deleteSpecies(SBdb sbdb, Collection<Integer> specIDs, boolean delFss, ProgressBarMonitor prog) throws SQLException {
        PreparedStatement[] pStmt = new PreparedStatement[13];
        int n = 0;
        String sql = "DELETE FROM " + sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXIMAGE") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("OVR_MAP") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE pref=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXDEPTH") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXLOAD") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXNOTES") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXREFS") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        if (prog != null) {
            prog.getProgressBar().setMinimum(0);
            prog.getProgressBar().setMaximum(specIDs.size());
        }
        int i = 0;
        Iterator<Integer> it = specIDs.iterator();
        try {
            while (it.hasNext()) {
                int specID = it.next();
                int n2 = n = delFss ? 0 : 1;
                while (n < pStmt.length) {
                    pStmt[n].setInt(1, specID);
                    pStmt[n].execute();
                    ++n;
                }
                if (prog == null) continue;
                if (prog.getInterrupt()) {
                    return;
                }
                prog.getProgressBar().setValue(i++);
            }
            return;
        }
        finally {
            n = 0;
            while (true) {
                if (n >= pStmt.length) {
                }
                pStmt[n].close();
                ++n;
            }
        }
    }

    public static List<Taxon> search(SBdb SB2, String catMnem, boolean includeSubCategories, String genus, String subGenus, String species, String subSpecies, String alphaCode, String gq1, String gq2, String gq3, String gq4, String sq1, String sq2, String sq3, String sq4) throws SQLException, SBException {
        String text;
        String sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g," + SB2.DBTableName("species") + " s WHERE s.gen_id=g.gen_id ";
        if (catMnem.length() > 0) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = includeSubCategories ? sql + "g.cat_mnem like '" + catMnem + "%'" : sql + "g.cat_mnem='" + catMnem + "'";
        }
        if ((text = genus.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(g.genus) like '" + text + "'" : sql + "ucase(g.genus)='" + text + "'";
        }
        if ((text = subGenus.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(g.sub_genus) like '" + text + "'" : sql + "ucase(g.sub_genus)='" + text + "'";
        }
        if ((text = species.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(s.species) like '" + text + "'" : sql + "ucase(s.species)='" + text + "'";
        }
        if ((text = subSpecies.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(s.sub_spec) like '" + text + "'" : sql + "ucase(s.sub_spec)='" + text + "'";
        }
        if ((text = alphaCode.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(s.alphaCode) like '" + text + "'" : sql + "ucase(s.alphaCode)='" + text + "'";
        }
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            Taxon taxon = SB2.getTaxon(rs.getInt("spec_id"));
            boolean toAdd = true;
            if (gq1 != null && !taxon.getQualifier(0).toString().equalsIgnoreCase(gq1)) {
                toAdd = false;
            }
            if (gq2 != null && !taxon.getQualifier(1).toString().equalsIgnoreCase(gq2)) {
                toAdd = false;
            }
            if (gq3 != null && !taxon.getQualifier(2).toString().equalsIgnoreCase(gq3)) {
                toAdd = false;
            }
            if (gq4 != null && !taxon.getQualifier(3).toString().equalsIgnoreCase(gq4)) {
                toAdd = false;
            }
            if (sq1 != null && !taxon.getQualifier(4).toString().equalsIgnoreCase(sq1)) {
                toAdd = false;
            }
            if (sq2 != null && !taxon.getQualifier(5).toString().equalsIgnoreCase(sq2)) {
                toAdd = false;
            }
            if (sq3 != null && !taxon.getQualifier(6).toString().equalsIgnoreCase(sq3)) {
                toAdd = false;
            }
            if (sq4 != null && !taxon.getQualifier(7).toString().equalsIgnoreCase(sq4)) {
                toAdd = false;
            }
            if (!toAdd) continue;
            resultList.add(taxon);
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    public static List<Taxon> searchSoundex(SBdb SB2, String genus, String subGenus, String species, String subSpecies) throws SQLException, SBException {
        String sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g," + SB2.DBTableName("species") + " s WHERE s.gen_id=g.gen_id ";
        String text = genus.toUpperCase();
        if (text.length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "soundex(g.genus)=soundex('" + text + "')";
        }
        if ((text = subGenus.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "soundex(g.sub_genus)=soundex('" + text + "')";
        }
        if ((text = species.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "soundex(s.species)=soundex('" + text + "')";
        }
        if ((text = subSpecies.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "soundex(s.sub_spec)=soundex('" + text + "')";
        }
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            Taxon taxon = SB2.getTaxon(rs.getInt("spec_id"));
            resultList.add(taxon);
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getUnusedSpecies(SBdb sbdb, List<Integer> taxaToDie) throws SQLException {
        String sql = "SELECT spec_id FROM " + sbdb.DBTableName("species");
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            int specID;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                taxaToDie.add(new Integer(rs.getInt("spec_id")));
            }
            sql = "SELECT distinct(spec_id) FROM " + sbdb.DBTableName("taxonocc");
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                if (taxaToDie.remove(new Integer(specID))) continue;
                System.out.println("TAXONOCC SpecID with no corresponding species record: " + specID);
            }
            sql = "SELECT distinct(spec_id) FROM " + sbdb.DBTableName("eventdic");
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                if (taxaToDie.remove(new Integer(specID))) continue;
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> search(SBdb db, Project project, Double upper, Double lower, int abund, String addSql) throws SQLException {
        String sql = "SELECT DISTINCT f.well_id FROM ";
        sql = sql + this.sbdb.DBTableName("TAXONOCC");
        sql = sql + " f, ";
        if (project != null && project.getID() > 0) {
            sql = sql + this.sbdb.DBTableName("SBWLMB");
            sql = sql + " w, ";
        }
        sql = sql + this.sbdb.DBTableName("SAMPLES");
        sql = sql + " s WHERE f.well_id=s.well_id AND f.samp_id=s.samp_id AND f.spec_id=" + this.specID;
        if (abund > 0) {
            sql = sql + " AND (f.coarse>" + abund + " OR f.medium>" + abund + " OR f.fine>" + abund + ")";
        }
        if (upper != null) {
            sql = this.sbdb.dbType == SBdb.DBType.ACCESS ? sql + " AND IIF(IsNull(s.top_depth),s.base_depth,s.top_depth)>=" + upper : sql + " AND NVL(s.top_depth,s.base_depth)>=" + upper;
        }
        if (lower != null) {
            sql = this.sbdb.dbType == SBdb.DBType.ACCESS ? sql + " AND IIF(IsNull(s.base_depth),s.top_depth,s.base_depth)<=" + lower : sql + " AND NVL(s.base_depth,s.top_depth)<=" + lower;
        }
        if (project != null && project.getID() > 0) {
            sql = sql + " AND f.well_id=w.well_id AND w.id=" + project.getID();
        }
        if (addSql != null) {
            sql = sql + addSql;
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            LinkedList<Integer> resultList = new LinkedList<Integer>();
            while (rs.next()) {
                resultList.add(rs.getInt("well_id"));
            }
            Collections.sort(resultList);
            LinkedList<Integer> linkedList = resultList;
            return linkedList;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Taxon> search(SBdb db, int upperCode, int lowerCode, int dictID) throws SQLException {
        if (upperCode < lowerCode) {
            int temp = upperCode;
            upperCode = lowerCode;
            lowerCode = temp;
        }
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        Statement stmt = db.getDatabase().createStatement();
        String sql = "SELECT DISTINCT spec_id FROM " + db.DBTableName("SIPMCODE") + " WHERE sipm_code";
        sql = upperCode < 0 ? sql + "=" + lowerCode : (lowerCode < 0 ? sql + "=" + upperCode : sql + ">=" + lowerCode + " AND sipm_code<=" + upperCode);
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                resultList.add(db.getTaxon(rs.getInt("spec_id")));
            }
            Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
            LinkedList<Taxon> linkedList = resultList;
            return linkedList;
        }
        finally {
            stmt.close();
        }
    }

    public static List<Taxon> search(SBdb SB2, String discs, TxGroup group, Project project, IGDUnit unit, int abund, String addSql) throws SQLException, SBException {
        Statement stmt = SB2.getDatabase().createStatement();
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        String sql = "SELECT i.well_id,min(s1." + (SB2.useSampleTops() ? "top_depth" : "base_depth") + ") AS upper,max(s2." + (SB2.useSampleTops() ? "top_depth" : "base_depth") + ") AS lower ";
        sql = sql + "FROM " + SB2.DBTableName("IGD") + " i, " + SB2.DBTableName("SAMPLES") + " s1, " + SB2.DBTableName("SAMPLES") + " s2";
        if (project != null && project.getID() > 0) {
            sql = sql + ",";
            sql = sql + SB2.DBTableName("SBWLMB");
            sql = sql + " w ";
        }
        sql = sql + " WHERE (i.upp_zone=" + unit.getUnitID() + " OR i.low_zone=" + unit.getUnitID() + ") AND " + "s1.well_id=i.well_id AND s2.well_id=i.well_id AND s1.samp_id=i.top_id AND s2.samp_id=i.base_id ";
        if (project != null && project.getID() > 0) {
            sql = sql + " AND i.well_id=w.well_id AND w.id=" + project.getID();
        }
        sql = sql + " GROUP BY i.well_id";
        System.out.println(sql);
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            BigDecimal upper = rs.getBigDecimal("upper");
            BigDecimal lower = rs.getBigDecimal("lower");
            if (upper == null || lower == null) continue;
            System.out.println("Executing query for wellID=" + wellID + " upper=" + upper + ", lower=" + lower);
            List<Taxon> wellResultList = Taxon.search(SB2, discs, group, null, wellID, upper.doubleValue(), lower.doubleValue(), abund, addSql);
            for (Taxon taxon : wellResultList) {
                if (resultList.contains(taxon)) continue;
                resultList.add(taxon);
            }
        }
        stmt.close();
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        return resultList;
    }

    public static List<Taxon> search(SBdb SB2, String discs, TxGroup group, Project project, int wellID, Double upper, Double lower, int abund, String addSql) throws SQLException, SBException {
        String sql = "SELECT DISTINCT f.spec_id FROM ";
        sql = sql + SB2.DBTableName("TAXONOCC");
        sql = sql + " f, ";
        sql = sql + SB2.DBTableName("ANALY_HDR");
        sql = sql + " a, ";
        if (group != null) {
            sql = sql + SB2.DBTableName("GROUPMBR");
            sql = sql + " g, ";
        }
        if (project != null && project.getID() > 0) {
            sql = sql + SB2.DBTableName("SBWLMB");
            sql = sql + " w, ";
        }
        sql = sql + SB2.DBTableName("SAMPLES");
        sql = sql + " s WHERE f.analy_id=a.analy_id AND a.well_id=f.well_id AND f.samp_id=s.samp_id AND f.well_id=s.well_id";
        sql = sql + " AND (";
        for (int i = 0; i < discs.length(); ++i) {
            if (i > 0) {
                sql = sql + " OR ";
            }
            sql = sql + "a.disc_id='" + discs.charAt(i) + "'";
        }
        sql = sql + ")";
        if (abund > 0) {
            sql = sql + " AND (f.coarse>" + abund + " OR f.medium>" + abund + " OR f.fine>" + abund + ")";
        }
        if (upper != null) {
            sql = sql + " AND (s.top_depth>" + upper + " OR s.base_depth > " + upper + ")";
        }
        if (lower != null) {
            sql = sql + " AND (s.base_depth<" + lower + " OR s.top_depth < " + lower + ")";
        }
        if (group != null) {
            sql = sql + " AND f.spec_id=g.spec_id AND g.grp_id=" + group.getID();
        }
        if (project != null && project.getID() > 0) {
            sql = sql + " AND f.well_id=w.well_id AND w.id=" + project.getID();
        }
        if (wellID > 0) {
            sql = sql + " AND f.well_id=" + wellID;
        }
        if (addSql != null) {
            sql = sql + addSql;
        }
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            resultList.add(SB2.getTaxon(rs.getInt("spec_id")));
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    public static List<Taxon> search(SBdb sbdb, Date dateFrom, Date dateTo) throws SQLException, SBException {
        if (dateFrom == null && dateTo == null) {
            throw new SBException("No dates to search on");
        }
        if (dateFrom == null && dateTo != null) {
            throw new SBException("Date from null in between date search");
        }
        String sql = "SELECT distinct spec_id from " + sbdb.DBTableName("SPECIES");
        sql = dateTo != null ? sql + " WHERE modified BETWEEN " + sbdb.DBDate(dateFrom) + " AND " + sbdb.DBDate(dateTo) : sql + " WHERE modified > " + sbdb.DBDate(dateFrom);
        Statement stmt = sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            resultList.add(sbdb.getTaxon(rs.getInt("spec_id")));
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    private boolean checkQualField(String field) {
        if (field == null || field.length() == 0) {
            return true;
        }
        if (field.startsWith("?") || field.endsWith("?")) {
            return false;
        }
        for (int i = 0; i < preqal.length; ++i) {
            if (preqal[i] > 0 && field.startsWith(qulsym[i])) {
                return false;
            }
            if (preqal[i] != 0 || !field.endsWith(qulsym[i])) continue;
            return false;
        }
        return true;
    }

    void removeImageType(int imageSetID) {
        if (this.imageType != null && this.imageType.getID() == imageSetID) {
            this.imageType = null;
        }
    }

    public String getNwsImages() {
        if (this.wsImages != null && this.wsImages.size() > 0) {
            return "" + this.wsImages.size();
        }
        return null;
    }

    public List<ImageSet> getWsImageSets() {
        return this.wsImages;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs == this.genus) {
            this.setChanged();
            this.notifyObservers(this.genus);
        }
    }

    public static void sort(List<Taxon> list, SortOrder order) {
        switch (order) {
            case SORT_GENUS: {
                Collections.sort(list, new TaxonCompareGenus(new TaxonCompareSpecies()));
                break;
            }
            case SORT_SPECIES: {
                Collections.sort(list, new TaxonCompareSpecies());
                break;
            }
            case SORT_CATEGORY: {
                Collections.sort(list, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
                break;
            }
            case SORT_ALPHACODE: {
                Collections.sort(list, new TaxonCompareAlphaCode(new TaxonCompareGenus(new TaxonCompareSpecies())));
            }
        }
    }

    public static void sort(List<Taxon> list, SortOrder order, int sipmDictID) {
        switch (order) {
            case SORT_SIPMCODE: {
                Collections.sort(list, new TaxonCompareSIPMCode(sipmDictID, new TaxonCompareGenus(new TaxonCompareSpecies())));
                break;
            }
            default: {
                Taxon.sort(list, order);
            }
        }
    }

    public static String toSpeciesCase(String strg) {
        if ((strg = strg.toLowerCase()).startsWith("sp.") || strg.startsWith("sp ") || strg.startsWith("var ")) {
            String upper = strg.substring(3);
            upper = upper.toUpperCase();
            strg = strg.substring(0, 3) + upper;
        }
        String[] replacers = new String[]{" spt", " rri", " ms"};
        for (int j = 0; j < replacers.length; ++j) {
            String replacer = replacers[j];
            int i = strg.indexOf(replacer + " ");
            if (i >= 0) {
                strg = strg.substring(0, i) + replacer.toUpperCase() + " " + strg.substring(i + replacer.length(), strg.length());
            }
            if (!strg.endsWith(replacer) || (i = strg.indexOf(replacer)) < 0) continue;
            strg = strg.substring(0, i) + replacer.toUpperCase();
        }
        return strg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNSpecies(SBdb sbdb) throws SQLException {
        String sql = "SELECT count(spec_id) AS nspecies FROM " + sbdb.DBTableName("species");
        sql = sbdb.modQuery(sql);
        Statement stmt = sbdb.getDatabase().createStatement();
        int nSpecies = 0;
        try {
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                nSpecies = rs.getInt("nspecies");
            }
        }
        finally {
            stmt.close();
        }
        return nSpecies;
    }

    public List<TxGroup> getGroups() throws SQLException, SBException {
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            throw new SBException("Taxon.getGroups(). Not connected to database.");
        }
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT grp_id FROM " + this.sbdb.DBTableName("groupmbr") + " WHERE spec_id=" + this.specID;
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        while (rs.next()) {
            groups.add(this.sbdb.getTxGroup(rs.getInt("grp_id")));
        }
        stmt.close();
        return groups;
    }

    public int getImageSetCount(boolean refresh) throws SQLException {
        if (refresh || this.imageSetCount < 0) {
            this.imageSetCount = 0;
            String sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("tximage") + " WHERE spec_id=" + this.specID + " AND image_set_id > 0";
            sql = this.sbdb.modQuery(sql);
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            LinkedList<Integer> imageSets = new LinkedList<Integer>();
            while (rs.next()) {
                imageSets.add(rs.getInt("image_set_id"));
            }
            this.imageSetCount = imageSets.size();
            sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("taxonocc") + " WHERE spec_id=" + this.specID + " AND image_set_id IS NOT NULL";
            sql = this.sbdb.modQuery(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (imageSets.contains(rs.getInt("image_set_id"))) continue;
                ++this.imageSetCount;
            }
            stmt.close();
            if (this.hasUnreferencedImages()) {
                ++this.imageSetCount;
            }
        }
        return this.imageSetCount;
    }

    ImageSet getUnreferencedImages() throws SQLException, SBException {
        ImageSet unreferenced;
        if (this.sbdb.getImageFolder() != null && (unreferenced = new ImageSet(this.sbdb, this.subsFileNameChars(this.toString(false, false)))).getSize(false) > 0) {
            this.hasTypeImage = this.hasTypeImage > 0 ? (this.hasTypeImage += unreferenced.getSize()) : (this.hasTypeImage() ? (this.hasTypeImage += unreferenced.getSize()) : unreferenced.getSize());
            return unreferenced;
        }
        return null;
    }

    private boolean hasUnreferencedImages() throws SQLException {
        String imageFolder = this.sbdb.getImageFolder();
        if (imageFolder == null || imageFolder.isEmpty()) {
            return false;
        }
        File dir = new File(imageFolder);
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getPath().toLowerCase().startsWith((imageFolder + "\\" + this.subsFileNameChars(this.toString(false, false))).toLowerCase() + "_")) continue;
            return true;
        }
        return false;
    }

    private String subsFileNameChars(String name) {
        char[] ILLEGAL_CHARACTERS = new char[]{'/', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
        String newName = "";
        for (int n : name.toCharArray()) {
            for (char ill : ILLEGAL_CHARACTERS) {
                if (ill != n) continue;
                n = ill == '\"' ? 39 : 45;
                break;
            }
            newName = newName + (char)n;
        }
        return newName;
    }

    public boolean hasTypeImage() throws SQLException {
        if (this.hasTypeImage < 0) {
            String sql = "SELECT count(image_set_id) AS nset FROM " + this.sbdb.DBTableName("tximage") + " WHERE spec_id=" + this.specID + " AND image_set_id > 0 and type='Y'";
            sql = this.sbdb.modQuery(sql);
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            this.hasTypeImage = 0;
            while (rs.next()) {
                this.hasTypeImage = rs.getInt("nset");
            }
            stmt.close();
            if (this.hasUnreferencedImages()) {
                this.hasTypeImage = 1;
                return true;
            }
        }
        return this.hasTypeImage > 0;
    }

    public void incrementTypeImage() {
        ++this.hasTypeImage;
    }

    public void decrementTypeImage() {
        --this.hasTypeImage;
    }

    public ImageSet getImageType() throws SQLException, SBException {
        if (this.imageSetCount != 0 && this.imageType == null) {
            this.getImageSetCount(true);
            List<ImageSet> sets = this.getImageTypes();
            if (sets != null && sets.size() > 0) {
                this.imageType = sets.get(0);
            }
        }
        return this.imageType;
    }

    public void decrementImageSetCount() {
        --this.imageSetCount;
        this.setChanged();
    }

    public List<ImageSet> getImageTypes() throws SQLException, SBException {
        LinkedList<ImageSet> sets = null;
        String sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("tximage") + " WHERE spec_id=" + this.specID + " AND image_set_id > 0 AND type='Y'";
        sql = this.sbdb.modQuery(sql);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int imageSetID = rs.getInt("image_set_id");
            if (sets == null) {
                sets = new LinkedList<ImageSet>();
            }
            sets.add(new ImageSet(this.sbdb, imageSetID));
        }
        stmt.close();
        if (sets != null) {
            return sets;
        }
        ImageSet unref = this.getUnreferencedImages();
        if (unref != null) {
            sets = new LinkedList();
            sets.add(unref);
        }
        return sets;
    }

    public boolean equalsBuilder(Builder builder) {
        if (builder.genus != null && this.genus != builder.genus) {
            return false;
        }
        if (!this.species.equals(builder.species)) {
            return false;
        }
        if (!this.subSpecies.equals(builder.subSpecies)) {
            return false;
        }
        for (int i = 0; i < this.qualifiers.length; ++i) {
            if (this.qualifiers[i].equals(builder.qualifiers[i])) continue;
            return false;
        }
        if (!this.author.equals(builder.author)) {
            return false;
        }
        if (!this.alphaCode.equals(builder.alphaCode)) {
            return false;
        }
        return this.year == builder.year;
    }

    private Taxon(Builder builder, int specID, SBdb sbdb) {
        this.specID = specID;
        this.sbdb = sbdb;
        this.genus = builder.genus;
        this.genus.addObserver(this);
        this.species = builder.species;
        this.subSpecies = builder.subSpecies;
        this.qualifiers = builder.qualifiers;
        this.alphaCode = builder.alphaCode;
        this.author = builder.author;
        this.year = builder.year;
        this.notes = builder.notes;
        this.reference = builder.reference;
        this.audit = builder.audit;
    }

    public static class Builder {
        private Genus genus;
        private String species = "";
        private String subSpecies = "";
        private Qualifier[] qualifiers = new Qualifier[4];
        private String alphaCode = "";
        private String author = "";
        private int year;
        Audit audit = new Audit();
        String notes = null;
        String reference = null;

        public Builder() {
            for (int i = 0; i < this.qualifiers.length; ++i) {
                this.qualifiers[i] = new Qualifier(i + 4);
            }
        }

        static Builder copyOf(Taxon taxon) {
            Builder builder = new Builder();
            builder.species(taxon.species).subSpecies(taxon.subSpecies);
            for (int i = 0; i < builder.qualifiers.length; ++i) {
                Qualifier q = taxon.getQualifierSpecies(i);
                if (q == null) continue;
                builder.qualifiers[i] = q.copy();
            }
            builder.alphaCode(taxon.getAlphaCode()).author(taxon.author).year(taxon.year).notes(taxon.notes).reference(taxon.reference);
            return builder;
        }

        public void verify() throws InvalidFieldException {
            if (this.qualifiers[0].hasQual(TaxonQual.QUOTE) || this.qualifiers[1].hasQual(TaxonQual.QUOTE)) {
                this.qualifiers[0].addQual(TaxonQual.QUOTE);
                this.qualifiers[1].addQual(TaxonQual.QUOTE);
            }
            if (this.qualifiers[2].hasQual(TaxonQual.QUOTE) || this.qualifiers[3].hasQual(TaxonQual.QUOTE)) {
                this.qualifiers[2].addQual(TaxonQual.QUOTE);
                this.qualifiers[3].addQual(TaxonQual.QUOTE);
            }
            if (this.qualifiers[1].hasQual(TaxonQual.SENSU) && this.qualifiers[3].hasQual(TaxonQual.SENSU)) {
                throw new InvalidFieldException("You may not use the 'sensu' qualifier twice.");
            }
            if (this.qualifiers[1].hasQual(TaxonQual.SENSU) && this.subSpecies.isEmpty() && this.author.isEmpty()) {
                throw new InvalidFieldException("You must enter an author name in the sub-species or author fields if you use the 'sensu' qualifier.");
            }
            if (this.qualifiers[3].hasQual(TaxonQual.SENSU) && this.author.isEmpty()) {
                throw new InvalidFieldException("You must enter an author name if you use the 'sensu' qualifier.");
            }
        }

        private void validateFields() {
            if (this.genus == null) {
                throw new IllegalStateException("Attempt to build Taxon with no Genus: " + this.species);
            }
            if (this.species.isEmpty()) {
                throw new IllegalStateException("Attempt to build Taxon with no name: " + this.genus);
            }
        }

        Taxon build(int specID, SBdb sbdb) {
            if (specID < 1) {
                throw new IllegalArgumentException("Attempt to build Taxon with illegal specID: " + specID);
            }
            if (sbdb == null) {
                throw new IllegalArgumentException("Attempt to build Taxon with null data model");
            }
            this.validateFields();
            return new Taxon(this, specID, sbdb);
        }

        Taxon store(SBdb sbdb) throws SQLException {
            int specID = sbdb.nextControl("SPECIES", "spec_id");
            Taxon taxon = this.build(specID, sbdb);
            taxon.storeDB(sbdb);
            return taxon;
        }

        public Builder genus(Genus g) {
            this.genus = g;
            return this;
        }

        public Builder qual(int qual, String s) {
            if (s == null || s.isEmpty() || qual < 4 || qual > 7) {
                return this;
            }
            this.qualifiers[qual - 4] = new Qualifier(s.trim(), qual);
            return this;
        }

        public Builder qual(int qual, Qualifier q) {
            if (qual < 4 || qual > 7) {
                return this;
            }
            this.qualifiers[qual - 4] = q == null ? new Qualifier(qual - 4) : q;
            return this;
        }

        public Builder qual(int qual, TaxonQual q) {
            if (q == null || qual < 4 || qual > 7) {
                return this;
            }
            this.qualifiers[qual - 4].addQual(q);
            return this;
        }

        public Builder speciesAdd(String species) {
            if (species != null) {
                if (!this.species.isEmpty()) {
                    this.species = this.species + " ";
                }
                this.species = this.species + species;
            }
            return this;
        }

        public Builder species(String species) {
            this.species = species != null ? species.trim() : "";
            return this;
        }

        public Builder subSpecies(String subSpecies) {
            this.subSpecies = subSpecies != null ? subSpecies.trim() : "";
            return this;
        }

        public Builder author(String author) {
            if (author == null) {
                author = "";
            }
            this.author = author.trim();
            return this;
        }

        public Builder alphaCode(String alphaCode) {
            if (alphaCode == null) {
                alphaCode = "";
            }
            this.alphaCode = alphaCode.trim();
            return this;
        }

        public Builder year(int year) {
            if (year < 1000 || year > 3000) {
                year = 0;
            }
            this.year = year;
            return this;
        }

        public boolean hasQual(TaxonQual qual) {
            for (Qualifier q : this.qualifiers) {
                if (!q.hasQual(qual)) continue;
                return true;
            }
            return false;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        Qualifier getQualifier(int i) {
            return this.qualifiers[i];
        }

        public String getName() {
            return this.species;
        }

        public String getSubSpecies() {
            return this.subSpecies;
        }

        public String getAlphaCode() {
            return this.alphaCode;
        }

        String getAuthor() {
            return this.author;
        }

        Genus getGenus() {
            return this.genus;
        }
    }

    public static enum SortOrder {
        SORT_GENUS,
        SORT_SPECIES,
        SORT_CATEGORY,
        SORT_ALPHACODE,
        SORT_SIPMCODE;

    }

    public static enum OccType {
        INSITU("In-situ"),
        REWORKED("Reworked"),
        CAVED("Caved"),
        QUESTIONABLE("Questionable");

        String name;

        private OccType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static OccType getType(String type) {
            for (OccType val : OccType.values()) {
                if (!val.toString().equalsIgnoreCase(type)) continue;
                return val;
            }
            return null;
        }
    }
}

