/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import model2.Audit;
import model2.SBdb;
import model2.Taxon;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class TxGroup
extends Observable
implements Comparable<TxGroup>,
SortEntry,
SbugsStatus {
    private final SBdb sbdb;
    private final int ID;
    private String name = "";
    private String abr = "";
    private Color colour = Color.WHITE;
    private Audit audit = new Audit();
    private Set<Integer> specIDs;
    Color status = UNKNOWN;

    private TxGroup(SBdb sbdb, int ID, String name, String abr, Color colour, Audit audit) throws SQLException {
        if (ID <= 0) {
            throw new IllegalArgumentException("Attempt to create group with ID: " + ID);
        }
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create group with null data model");
        }
        this.sbdb = sbdb;
        this.ID = ID;
        if (name != null) {
            this.name = name;
        }
        if (abr != null) {
            this.abr = abr;
        }
        if (colour != null) {
            this.colour = colour;
        }
        this.audit = audit != null ? audit : new Audit();
        this.loadColour();
    }

    TxGroup(SBdb sbdb, String name, String abr, int ID) throws SQLException {
        if (ID <= 0) {
            throw new IllegalArgumentException("Attempt to create group with ID: " + ID);
        }
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create group with null data model");
        }
        this.sbdb = sbdb;
        this.ID = ID;
        this.name = name;
        this.abr = abr;
        this.specIDs = new TreeSet<Integer>();
        if (sbdb.isConnected()) {
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws SQLException {
        if (this.ID <= 0) {
            throw new IllegalArgumentException("Attempt to store TxGroup with ID: " + this.ID);
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "INSERT INTO " + this.sbdb.DBTableName("TXGROUP") + " (grp_id,name," + Audit.sqlFieldString() + ") VALUES (" + this.ID + "," + SB.DBString((String)this.name) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    static TxGroup copyToDatabase(SBdb ws, SBdb db, TxGroup wsGroup) throws SQLException, SBException {
        if (ws.isConnected() || !db.isConnected()) {
            throw new IllegalArgumentException("Incorrect data model arguments to TxGroup.copyToDatabase");
        }
        int ID = TxGroup.nextControl(db);
        TxGroup dbGroup = new TxGroup(db, ID, wsGroup.getName(), wsGroup.getAbr(), wsGroup.getColour(), new Audit(db, ws, wsGroup.getAudit()));
        LinkedList<Taxon> groupTaxa = new LinkedList<Taxon>(ws.getTxGroupTaxa(wsGroup));
        LinkedList<Taxon> dbTaxa = new LinkedList<Taxon>();
        for (Taxon taxon : groupTaxa) {
            if (taxon.getStatus() == Taxon.NOTSTORED) {
                throw new SBException("Cannot save: taxon: " + taxon + " not in database");
            }
            dbTaxa.add(taxon.getLink());
        }
        dbGroup.store();
        dbGroup.addTaxa(dbTaxa);
        dbGroup.storeColour(wsGroup.getColour());
        return dbGroup;
    }

    public TxGroup(SBdb SB2, int ID, String name, String abr, Color colour) throws SQLException, SBException {
        this.sbdb = SB2;
        this.ID = ID;
        this.colour = colour;
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "INSERT INTO " + SB2.DBTableName("TXGROUP") + " (grp_id,name,abr) VALUES (" + ID + "," + SB.DBString((String)name) + "," + SB.DBString((String)abr) + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.name = name;
        this.abr = abr;
        stmt.close();
        this.storeColour(colour);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxGroup(SBdb SB2, int ID) throws SQLException {
        this.ID = ID;
        this.sbdb = SB2;
        String sql = "SELECT name, abr, " + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("TXGROUP") + " WHERE grp_id=" + ID;
        Statement stmt = SB2.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                this.name = rs.getString("name");
                this.abr = rs.getString("abr");
                this.audit = new Audit(rs);
            }
        }
        finally {
            stmt.close();
        }
        this.loadColour();
    }

    public int getID() {
        return this.ID;
    }

    public String statusString() {
        return this.name;
    }

    public Color getStatus() {
        return this.status;
    }

    @Override
    public int compareTo(TxGroup rhs) {
        return this.name.compareToIgnoreCase(rhs.name);
    }

    public int getSize() throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return this.specIDs.size();
    }

    Set<Integer> getSpecIDs() throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return new HashSet<Integer>(this.specIDs);
    }

    public String getName() {
        return this.name;
    }

    public String getSortEntry() {
        return this.name;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    public String toString() {
        return this.name;
    }

    public void setColour(Color colour) throws SQLException {
        if (this.colour == null && colour != null || this.colour != null && !this.colour.equals(colour)) {
            if (this.sbdb != null && this.sbdb.isConnected()) {
                this.storeColour(colour);
            }
            this.colour = colour;
            this.setChanged();
            this.notifyObservers(colour);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeColour(Color colour) throws SQLException {
        if (colour == null) {
            return;
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("CATCOL") + " WHERE abr='" + this.ID + "'";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "INSERT INTO " + this.sbdb.DBTableName("CATCOL") + " (abr,red,green,blue) VALUES ('" + this.ID + "'," + colour.getRed() + "," + colour.getGreen() + "," + colour.getBlue() + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() throws SQLException, SBException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("CATCOL") + " WHERE abr='" + this.ID + "'";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("TXGROUP") + " WHERE grp_id=" + this.ID;
            int nDel = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nDel != 1) {
                throw new SBException("Error deleting TxGroup : no group deleted");
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String newName) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            Audit temp = new Audit(this.audit);
            String sql = "UPDATE " + this.sbdb.DBTableName("txgroup") + " SET name=" + SB.DBString((String)newName) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE grp_id=" + this.ID;
            try {
                if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1) {
                    throw new SBException("Cannot update group: " + this.name);
                }
                this.audit = temp;
            }
            finally {
                stmt.close();
            }
        }
        this.name = newName;
        this.setChanged();
        this.notifyObservers(this.name);
    }

    public String getAbr() {
        if (this.abr != null) {
            return this.abr;
        }
        return "";
    }

    public SBdb getDatabase() {
        if (this.sbdb == null) {
            throw new IllegalStateException("Null database pointer in class TxGroup");
        }
        return this.sbdb;
    }

    public Color getColour() {
        return this.colour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColour() throws SQLException {
        if (this.ID == 0) {
            return;
        }
        if (this.sbdb.isConnected()) {
            String sql = "SELECT red,green,blue FROM " + this.sbdb.DBTableName("CATCOL") + " WHERE abr='" + this.ID + "'";
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    int red = rs.getInt("red");
                    int green = rs.getInt("green");
                    int blue = rs.getInt("blue");
                    this.colour = new Color(red, green, blue);
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    static TxGroup parseTxGroup(Element xml, SBdb sbdb) throws SBException, ParseException, SQLException {
        String strgID = xml.getChildTextNormalize("GroupID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int groupID = Integer.parseInt(strgID);
        String name = xml.getChildText("GroupName");
        String abr = xml.getChildText("Abbreviation");
        Color colour = Color.WHITE;
        Element elc = xml.getChild("Colour");
        if (elc != null) {
            colour = SB.parseColour((Element)elc);
        }
        Audit audit = null;
        Element ela = xml.getChild("Audit");
        if (ela != null) {
            try {
                audit = new Audit(sbdb, ela);
            }
            catch (SBException sbe) {
                System.out.println("Message from Audit in TxGroup (ignored): " + sbe.getMessage());
            }
        } else {
            System.out.println("Warning: no audit info for TxGroup: " + name);
        }
        TxGroup group = new TxGroup(sbdb, groupID, name, abr, colour, audit);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(SBdb sbdb, HashMap txGroups) throws SQLException {
        String sql = "SELECT grp_id, name, abr, " + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("TXGROUP") + " ORDER BY name";
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("grp_id");
                if (sbdb.getTxGroup(ID) != null) continue;
                TxGroup group = new TxGroup(sbdb, ID, rs.getString("name"), rs.getString("abr"), null, new Audit(rs));
                txGroups.put(ID, group);
            }
        }
        finally {
            stmt.close();
        }
    }

    static synchronized TxGroup refresh(SBdb SB2, HashMap<Integer, TxGroup> txGroups) throws SQLException {
        String sql = "SELECT grp_id, updated FROM " + SB2.DBTableName("TXGROUP");
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        HashSet<Integer> keys = new HashSet<Integer>();
        TxGroup notifier = null;
        while (rs.next()) {
            TxGroup g;
            int ID = rs.getInt("grp_id");
            keys.add(ID);
            Timestamp time = rs.getTimestamp("updated");
            TxGroup group = txGroups.get(ID);
            if (group == null) {
                g = new TxGroup(SB2, ID);
                txGroups.put(ID, g);
                notifier = g;
                continue;
            }
            if (time == null || group.audit.updated != null && !time.after(group.audit.updated)) continue;
            System.out.println("Found updated group - copying..." + group);
            g = new TxGroup(SB2, ID);
            group.name = g.name;
            group.abr = g.abr;
            group.audit = new Audit(g.audit);
            g.getSpecIDs();
            group.specIDs = new TreeSet<Integer>(g.specIDs);
            group.setChanged();
            group.notifyObservers();
        }
        if (txGroups.size() != keys.size()) {
            Iterator<TxGroup> it = txGroups.values().iterator();
            while (it.hasNext()) {
                TxGroup group = it.next();
                if (keys.contains(group.ID)) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = group;
            }
        }
        stmt.close();
        return notifier;
    }

    public boolean isMember(int specID) throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return this.specIDs.contains(new Integer(specID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaxa(List<Taxon> taxa) throws SQLException {
        if (this.sbdb.isConnected()) {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                for (Taxon taxon : taxa) {
                    if (this.isMember(taxon.getSpecID())) continue;
                    String sql = "INSERT INTO " + this.sbdb.DBTableName("GROUPMBR") + " (grp_id,spec_id) VALUES (";
                    sql = sql + this.ID + "," + taxon.getSpecID() + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
            finally {
                stmt.close();
            }
            this.updateAudit();
        }
        for (Taxon taxon : taxa) {
            if (this.isMember(taxon.getSpecID())) continue;
            this.specIDs.add(taxon.getSpecID());
            this.setChanged();
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAudit() throws SQLException {
        Audit temp = new Audit(this.audit);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("TXGROUP") + " SET " + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE grp_id=" + this.ID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.audit = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllTaxa() throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.sbdb.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        if (this.specIDs.size() > 0) {
            this.specIDs.clear();
            this.setChanged();
            this.updateAudit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTaxa(List<Taxon> taxa) throws SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                for (Taxon taxon : taxa) {
                    if (!this.isMember(taxon.getSpecID())) {
                        System.out.println("Taxon: " + taxon.getSpecID() + " to be deleted does not exist in group: " + this.ID);
                    }
                    String sql = "DELETE FROM " + this.sbdb.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID + " AND spec_id=" + taxon.getSpecID();
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
            finally {
                stmt.close();
            }
        }
        for (Taxon taxon : taxa) {
            if (!this.isMember(taxon.getSpecID())) continue;
            this.specIDs.remove(taxon.getSpecID());
            this.setChanged();
        }
        if (this.hasChanged() && this.sbdb != null && this.sbdb.isConnected()) {
            this.updateAudit();
        }
        this.notifyObservers();
    }

    boolean removeSpecies(int specID) {
        if (this.specIDs != null) {
            try {
                if (this.isMember(specID)) {
                    boolean retVal = this.specIDs.remove(specID);
                    this.setChanged();
                    return retVal;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    void insertSpecies(int specID) {
        if (this.specIDs != null) {
            try {
                if (!this.isMember(specID)) {
                    this.specIDs.add(specID);
                    this.setChanged();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() throws SQLException {
        boolean load = false;
        if (this.specIDs == null) {
            this.specIDs = new TreeSet<Integer>();
            load = true;
        }
        if (this.sbdb.isConnected() && load) {
            String sql = "SELECT spec_id FROM " + this.sbdb.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int specID = rs.getInt("spec_id");
                    if (this.specIDs.contains(specID)) continue;
                    this.specIDs.add(specID);
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    public void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<TaxonGroup Name=\"" + SB.getXMLstring((String)this.name) + "\">\n");
        if (this.name != null && this.name.length() > 0) {
            out.write("<GroupName>" + SB.getXMLstring((String)this.name) + "</GroupName>\n");
        }
        if (this.ID > 0) {
            out.write("<GroupID>" + this.ID + "</GroupID>\n");
        }
        if (this.abr != null && this.abr.length() > 0) {
            out.write("<Abbreviation>" + this.abr + "</Abbreviation>\n");
        }
        if (this.colour != null) {
            SB.writeXMLColour((Color)this.colour, (BufferedWriter)out, (String)"");
        }
        this.audit.writeXML(out, 0);
        out.write("<TaxonList>\n");
        this.load();
        for (int specID : this.specIDs) {
            Taxon taxon = this.sbdb.getTaxon(specID);
            out.write("   <Taxon Species=\"" + SB.getXMLstring((String)taxon.toString()) + "\">\n");
            taxon.writeXML(out, 9, files);
            out.write("   </Taxon>\n");
        }
        out.write("</TaxonList>\n");
        out.write("</TaxonGroup>\n");
    }

    public void updateStatus(TxGroup txGroup) throws SQLException, SBException {
        this.status = UNKNOWN;
        if (txGroup == null) {
            this.status = NOTSTORED;
            return;
        }
        txGroup.load();
        this.status = txGroup.specIDs.size() != this.specIDs.size() ? CONFLICT : STORED;
        for (int specID : this.specIDs) {
            Taxon taxon = this.sbdb.getTaxon(specID);
            if (taxon.getLink() == null) {
                txGroup.getDatabase().lookupTaxonLink(taxon);
                if (taxon.getStatus() == Taxon.NOTSTORED) {
                    this.status = CONFLICT;
                    break;
                }
            }
            if (txGroup.isMember(taxon.getLink().getSpecID())) continue;
            this.status = CONFLICT;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSets() throws SQLException {
        LinkedList<String> setNames = new LinkedList<String>();
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT s.name FROM " + this.sbdb.DBTableName("GROUPSET") + " s, " + this.sbdb.DBTableName("SETMBR") + " m" + " WHERE s.grpset_id=m.grpset_id AND grp_id=" + this.ID;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                setNames.add(rs.getString("name"));
            }
        }
        finally {
            stmt.close();
        }
        return setNames;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public static int nextControl(SBdb sbdb) throws SQLException {
        return sbdb.nextControl("TXGROUP", "grp_id");
    }
}

