/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import model2.Audit;
import model2.SBdb;
import model2.TxGroup;
import util.SB;
import util.SBException;

public class TxGroupSet
extends Observable
implements Comparable {
    private final SBdb sbdb;
    private int grpSetID;
    private String name;
    private Set<Integer> grpIDs = null;
    private Audit audit = new Audit();

    TxGroupSet(SBdb sbdb, int ID, String name, Audit audit) {
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create group set with no data model");
        }
        if (ID <= 0) {
            throw new IllegalArgumentException("Attempt to create group set with illegal ID: " + ID);
        }
        this.sbdb = sbdb;
        this.grpSetID = ID;
        this.name = name;
        this.audit = audit;
    }

    TxGroupSet(SBdb sbdb, String name, Set<Integer> groupIDs, int setID) throws SQLException, SBException {
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create group set with no data model");
        }
        if (setID <= 0) {
            throw new IllegalArgumentException("Attempt to create group set with illegal ID: " + setID);
        }
        this.sbdb = sbdb;
        this.grpSetID = setID;
        this.name = name;
        this.grpIDs = groupIDs;
        if (sbdb.isConnected()) {
            this.store();
        }
    }

    TxGroupSet(SBdb ws, String setName) {
        this.sbdb = ws;
        this.name = setName;
        this.grpSetID = 0;
    }

    public TxGroupSet(SBdb SB2, int ID, String name, boolean flag) throws SQLException {
        this.sbdb = SB2;
        this.grpSetID = ID;
        this.name = name;
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "INSERT INTO " + SB2.DBTableName("GROUPSET") + " (grpset_id,name," + Audit.sqlFieldString() + ") VALUES (" + this.grpSetID + "," + SB.DBString((String)name) + "," + this.audit.sqlInsert(SB2, stmt) + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxGroupSet(SBdb sbdb, int ID) throws SQLException {
        this.sbdb = sbdb;
        this.grpSetID = ID;
        String sql = "SELECT name," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("GROUPSET") + " WHERE grpset_id=" + ID;
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                this.name = rs.getString("name");
                this.audit = new Audit(rs);
            }
        }
        finally {
            stmt.close();
        }
    }

    public List<TxGroup> getGroups() throws SQLException {
        if (this.grpIDs == null) {
            this.loadGroups();
        }
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
        for (int grpId : this.grpIDs) {
            groups.add(this.sbdb.getTxGroup(grpId));
        }
        Collections.sort(groups);
        return groups;
    }

    public String toString() {
        return this.name;
    }

    public int getID() {
        return this.grpSetID;
    }

    public String getName() {
        return this.name;
    }

    void loadGroups() throws SQLException {
        if (this.grpSetID == 0) {
            return;
        }
        if (this.grpIDs == null) {
            this.grpIDs = new TreeSet<Integer>();
        }
        if (this.grpIDs.size() > 0) {
            return;
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT grp_id FROM " + this.sbdb.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        while (rs.next()) {
            int grpID = rs.getInt("grp_id");
            if (grpID <= 0) continue;
            this.grpIDs.add(grpID);
        }
        stmt.close();
    }

    public boolean isMember(int specID) throws SBException, SQLException {
        if (this.grpIDs == null) {
            throw new SBException("Groups in set: " + this + " not loaded");
        }
        for (int grpID : this.grpIDs) {
            TxGroup group = this.sbdb.getTxGroup(grpID);
            if (group == null) {
                throw new SBException("Cannot find group, ID " + grpID + " in set " + this.name);
            }
            group.load();
            if (!group.isMember(specID)) continue;
            return true;
        }
        return false;
    }

    boolean isGroupMember(int grpID) throws SBException, SQLException {
        if (this.grpIDs == null) {
            throw new SBException("Groups in set: " + this + " not loaded");
        }
        return this.grpIDs.contains(grpID);
    }

    void delete() throws SQLException {
        if (this.grpSetID == 0) {
            return;
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.sbdb.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "DELETE FROM " + this.sbdb.DBTableName("GROUPSET") + " WHERE grpset_id=" + this.grpSetID;
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        stmt.close();
    }

    public void update(String newName, Collection<TxGroup> groups) throws SQLException, SBException {
        String sql;
        if (this.grpSetID == 0) {
            throw new SBException("Cannot update null group set");
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit tempAudit = new Audit(this.audit);
        if (!newName.equals(this.name)) {
            sql = "UPDATE " + this.sbdb.DBTableName("GROUPSET") + " SET name=" + SB.DBString((String)newName) + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE grpset_id=" + this.grpSetID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        sql = "DELETE FROM " + this.sbdb.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        for (TxGroup group : groups) {
            sql = "INSERT INTO " + this.sbdb.DBTableName("SETMBR") + " (grpset_id,grp_id) VALUES (" + this.grpSetID + "," + group.getID() + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.name = newName;
        this.audit = tempAudit;
        this.grpIDs.clear();
        for (TxGroup group : groups) {
            this.grpIDs.add(group.getID());
        }
        stmt.close();
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws SQLException, SBException {
        ResultSet rs;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT grpset_id FROM " + this.sbdb.DBTableName("GROUPSET") + " WHERE ucase(name)=" + SB.DBString((String)this.name.toUpperCase());
        if (this.grpSetID > 0) {
            sql = sql + " AND grpset_id <> " + this.grpSetID;
        }
        if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql))).next()) {
            stmt.close();
            throw new SBException("Group set name is not unique");
        }
        rs.close();
        sql = "INSERT INTO " + this.sbdb.DBTableName("GROUPSET") + " (grpset_id,name," + Audit.sqlFieldString() + ") VALUES (" + this.grpSetID + "," + SB.DBString((String)this.name) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            for (int grpID : this.grpIDs) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("SETMBR") + " (grpset_id,grp_id) VALUES (" + this.grpSetID + "," + grpID + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TreeMap<Integer, TxGroupSet> loadAll(SBdb sbdb) throws SQLException {
        TreeMap<Integer, TxGroupSet> sets = new TreeMap<Integer, TxGroupSet>();
        if (sbdb.isConnected()) {
            String sql = "SELECT grpset_id,name," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("GROUPSET") + " order by name";
            Statement stmt = sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                while (rs.next()) {
                    int grpSetID = rs.getInt("grpset_id");
                    String name = rs.getString("name");
                    TxGroupSet set = new TxGroupSet(sbdb, grpSetID, name, new Audit(rs));
                    sets.put(grpSetID, set);
                }
            }
            finally {
                stmt.close();
            }
        }
        return sets;
    }

    static synchronized TxGroupSet refresh(SBdb SB2, TreeMap<Integer, TxGroupSet> sets) throws SQLException {
        String sql = "SELECT grpset_id, updated FROM " + SB2.DBTableName("GROUPSET");
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        HashSet<Integer> keys = new HashSet<Integer>();
        TxGroupSet notifier = null;
        while (rs.next()) {
            TxGroupSet s;
            int ID = rs.getInt("grpset_id");
            keys.add(ID);
            Timestamp time = rs.getTimestamp("updated");
            TxGroupSet set = sets.get(ID);
            if (set == null) {
                s = new TxGroupSet(SB2, ID);
                sets.put(ID, s);
                notifier = s;
                continue;
            }
            if (time == null || set.audit.updated != null && !time.after(set.audit.updated)) continue;
            s = new TxGroupSet(SB2, ID);
            set.name = s.name;
            set.grpIDs = s.grpIDs;
            set.audit = new Audit(s.audit);
            set.setChanged();
            set.notifyObservers();
        }
        if (sets.size() != keys.size()) {
            Iterator<TxGroupSet> it = sets.values().iterator();
            while (it.hasNext()) {
                TxGroupSet set = it.next();
                if (keys.contains(set.grpSetID)) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = set;
            }
        }
        stmt.close();
        return notifier;
    }

    public void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<GroupSet>\n");
        if (this.name != null && this.name.length() > 0) {
            out.write("<SetName>" + this.name + "</SetName>\n");
        }
        if (this.grpSetID > 0) {
            out.write("<SetID>" + this.grpSetID + "</SetID>\n");
        }
        this.audit.writeXML(out, 0);
        for (TxGroup group : this.getGroups()) {
            group.writeXML(out, indent, files);
        }
        out.write("</GroupSet>\n");
    }

    public void removeGroup(int ID) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to remove database group from set: use update");
        }
        this.grpIDs.remove(ID);
    }

    void addGroupID(int groupID) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to add database group to set: use update");
        }
        if (this.grpIDs == null) {
            this.grpIDs = new TreeSet<Integer>();
        }
        this.grpIDs.add(groupID);
    }

    public int compareTo(Object o) {
        if (o instanceof TxGroupSet) {
            return this.name.compareToIgnoreCase(((TxGroupSet)o).name);
        }
        return 0;
    }

    public int compareTo(TxGroupSet o) {
        return this.name.compareToIgnoreCase(o.name);
    }
}

