/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model2.Audit;
import model2.Discipline;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Well;
import model2.WellInterp;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;

public final class Userdef
implements SbugsStatus,
Comparable {
    private static final String NO_PWD = "NOPASSWORD";
    static boolean showName = false;
    private final SBdb sbdb;
    private final int userID;
    private String name = "";
    private String abr = "";
    private String sys_name = "";
    private String pwd = "NOPASSWORD";
    private Discipline discID = Discipline.MICRO;
    private Userdef link;
    private int priv = 0;
    private Color colour = Color.BLACK;
    public static final int STBROW = 1;
    public static final int STADDOCC = 2;
    public static final int STDISCONLY = 4;
    public static final int STADDDIC = 8;
    public static final int STADDWELL = 16;
    public static final int STDELWELL = 32;
    public static final int STADDUSR = 64;
    public static final int STADDSPE = 128;
    public static final int STDELSPE = 256;
    public static final int STADDREF = 512;
    public static final int STEDITSCH = 1024;
    public static final int STCONTR = 2048;
    public static final int STIGDINF = 4096;
    public static final int STIMPORT = 8192;
    public static final int STEXPORT = 16384;

    Userdef(SBdb db, Userdef user) {
        this.sbdb = db;
        this.abr = user.abr;
        this.name = user.name;
        this.userID = user.userID;
        this.discID = user.discID;
        this.link = user;
    }

    public Userdef getLink() {
        return this.link;
    }

    public static Userdef copyToWorkspace(SBdb ws, Userdef rhs) throws SQLException {
        if (ws.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy userdef to connected workspace");
        }
        Userdef userdef = ws.getUser(rhs.abr);
        if (userdef == null) {
            userdef = new Userdef(ws, rhs);
            ws.putUser(userdef);
        }
        return userdef;
    }

    public Discipline getDiscipline() {
        return this.discID;
    }

    public int getPriv() {
        return this.priv;
    }

    public Color getColour() {
        return this.colour;
    }

    Userdef(SBdb sbdb, int userID, String abr, String name, String sysName, Discipline discID, Color colour, String pwd, int priv) {
        this.sbdb = sbdb;
        this.userID = userID;
        this.abr = abr;
        this.name = name;
        this.sys_name = sysName;
        this.colour = colour;
        this.priv = priv;
        this.discID = discID;
        this.pwd = pwd == null || pwd.isEmpty() ? NO_PWD : pwd;
    }

    Userdef(SBdb SB2, String abr, String name, String sysName, Discipline discID, Color colour, String pwd, int priv) throws SQLException, SBException {
        this.sbdb = SB2;
        this.abr = abr;
        this.name = name;
        this.sys_name = sysName;
        this.colour = colour;
        this.priv = priv;
        this.discID = discID;
        if (pwd != null) {
            this.pwd = SB.crypt((boolean)true, (String)"SBPW", (String)pwd);
        }
        int usrID = this.sbdb.nextControl("USERDEF", "USER_ID");
        this.store(usrID);
        this.userID = usrID;
    }

    public void setFromLink() {
        this.abr = this.link.abr;
        this.name = this.link.name;
        this.discID = this.link.discID;
        this.sys_name = this.link.sys_name;
        this.colour = this.link.colour;
        this.pwd = this.link.pwd;
        this.priv = this.link.priv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String abr, String name, String sysName, Discipline discID, Color colour, String pwd, int priv) throws SQLException, SBException {
        if (discID == null) {
            throw new SBException("Can't update Userdef to null discipline");
        }
        if (abr == null || abr.isEmpty()) {
            throw new SBException("Can't update Userdef to empty abr");
        }
        if (name == null) {
            name = abr;
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("USERDEF") + " SET name='" + name + "',abr='" + abr + "',sys_name='" + sysName + "',disc='" + Discipline.getChar(discID) + "',user_priv=" + priv + ",red=" + colour.getRed() + ",green=" + colour.getGreen() + ",blue=" + colour.getBlue();
        if (this.sbdb.hasUserPassword) {
            sql = sql + ",password='" + (pwd == null ? NO_PWD : SB.crypt((boolean)true, (String)"SBPW", (String)pwd)) + "'";
        }
        sql = sql + " WHERE user_id=" + this.userID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1 && this.sbdb.dbType != SBdb.DBType.MYSQL) {
                throw new SBException("Update statement failed: " + sql);
            }
        }
        finally {
            stmt.close();
        }
        this.name = name;
        this.abr = abr;
        this.sys_name = sysName;
        this.colour = colour;
        this.priv = priv;
        this.discID = discID;
        this.pwd = pwd != null ? SB.crypt((boolean)true, (String)"SBPW", (String)pwd) : null;
    }

    public void setShowName(boolean showName) {
        Userdef.showName = showName;
    }

    public String toString() {
        if (!showName) {
            return this.abr;
        }
        String strg = this.name;
        strg = strg + " (" + this.abr + ')';
        return strg;
    }

    public String getName() {
        return this.name;
    }

    public String getNameID() {
        return this.name + " (" + this.abr + ")";
    }

    public String getAbr() {
        return this.abr;
    }

    public int getUsrID() {
        return this.userID;
    }

    public String getSysName() {
        return this.sys_name;
    }

    public String getPwd() {
        String retVal = null;
        if (this.pwd != null && !this.pwd.equals(NO_PWD)) {
            try {
                retVal = SB.crypt((boolean)false, (String)"SBPW", (String)this.pwd);
            }
            catch (NumberFormatException ex) {
                System.out.println("Cannot decrypt password for: " + this.toString() + ",password was: " + this.pwd);
            }
        }
        return retVal;
    }

    public void setLink(Userdef user) {
        this.link = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(int userID) throws SQLException {
        String sql = "INSERT INTO " + this.sbdb.DBTableName("USERDEF") + " (user_id,name,abr,sys_name,disc,user_priv,red,green,blue";
        if (this.sbdb.hasUserPassword) {
            sql = sql + ",password";
        }
        sql = sql + ") VALUES (" + userID + ",'" + this.name + "','" + this.abr + "'," + SB.DBString((String)this.sys_name) + ",'" + Discipline.getChar(this.discID) + "'," + this.priv;
        if (this.colour == null) {
            this.colour = Color.BLACK;
        }
        sql = sql + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue();
        if (this.sbdb.hasUserPassword) {
            sql = sql + ",'" + (this.pwd == null ? NO_PWD : this.pwd) + "'";
        }
        sql = sql + ")";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWellIGDInterps(Well well) throws SQLException, SBException {
        well.loadInterps();
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT DISTINCT i.interp_id FROM " + this.sbdb.DBTableName("IGD") + " i" + " WHERE (i.top_analy=" + this.userID + " OR i.base_analy=" + this.userID + ") AND well_id=" + well.wellID;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            ArrayList<WellInterp> occs = new ArrayList<WellInterp>();
            while (rs.next()) {
                int interpID = rs.getInt("interp_id");
                occs.add(well.getInterp(interpID));
            }
            ArrayList<WellInterp> arrayList = occs;
            return arrayList;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWellBiocomInterps(Well well) throws SQLException, SBException {
        well.loadInterps();
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT DISTINCT interp_id FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE analyst=" + this.userID + " AND well_id=" + well.wellID;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            ArrayList<WellInterp> occs = new ArrayList<WellInterp>();
            while (rs.next()) {
                int interpID = rs.getInt("interp_id");
                occs.add(well.getInterp(interpID));
            }
            ArrayList<WellInterp> arrayList = occs;
            return arrayList;
        }
        finally {
            stmt.close();
        }
    }

    public List getWellAnalyses(Well well) throws SQLException, SBException {
        LinkedList<Smpdtl> analyses = new LinkedList<Smpdtl>();
        well.loadAnalyses();
        for (Sample sample : well.getSamples()) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (smpdtl.getHeader().getAnalystUsrid() != this.userID) continue;
                analyses.add(smpdtl);
            }
        }
        return analyses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWellOccs() throws SQLException, SBException {
        LinkedList<Integer> wellIDs = new LinkedList<Integer>();
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            Integer wellID;
            String sql = "SELECT DISTINCT (well_id) FROM " + this.sbdb.DBTableName("analy_hdr") + " WHERE analyst=" + this.userID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                wellIDs.add(new Integer(rs.getInt("well_id")));
            }
            sql = "SELECT DISTINCT (well_id) FROM " + this.sbdb.DBTableName("igd") + " WHERE top_analy=" + this.userID + " OR base_analy=" + this.userID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                wellID = new Integer(rs.getInt("well_id"));
                if (wellIDs.contains(wellID)) continue;
                wellIDs.add(wellID);
            }
            sql = "SELECT DISTINCT (well_id) FROM " + this.sbdb.DBTableName("bcmmnts") + " WHERE analyst=" + this.userID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                wellID = new Integer(rs.getInt("well_id"));
                if (wellIDs.contains(wellID)) continue;
                wellIDs.add(wellID);
            }
            LinkedList<Well> wells = new LinkedList<Well>();
            Iterator it = wellIDs.iterator();
            while (it.hasNext()) {
                wells.add(this.sbdb.getAddWell((Integer)it.next()));
            }
            LinkedList<Well> linkedList = wells;
            return linkedList;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Well> getAnalystHeaders() throws SQLException, SBException {
        ArrayList<Well> suites = new ArrayList<Well>();
        String sql = "SELECT DISTINCT(v.well_id) FROM " + this.sbdb.DBTableName("ANALY_HDR") + " a," + this.sbdb.DBTableName("WELL_IDENT") + " v WHERE a.analyst=" + this.userID + " AND a.well_id=v.well_id";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                Well well = this.sbdb.getAddWell(wellID);
                well.getAnalystHeaders();
                suites.add(well);
            }
            ArrayList<Well> arrayList = suites;
            return arrayList;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnalyses() throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("analy_hdr") + " WHERE analyst=" + this.userID;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            boolean hasData = false;
            if (rs.next()) {
                hasData = true;
            }
            boolean bl = hasData;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIGD() throws SQLException {
        boolean hasData = false;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT DISTINCT (top_analy) FROM " + this.sbdb.DBTableName("igd") + " WHERE top_analy=" + this.userID;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                hasData = true;
            }
            if (!hasData && (rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT DISTINCT (base_analy) FROM " + this.sbdb.DBTableName("igd") + " WHERE base_analy=" + this.userID))).next()) {
                hasData = true;
            }
            if (!hasData && (rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("bcmmnts") + " WHERE analyst=" + this.userID))).next()) {
                hasData = true;
            }
            if (!hasData && (rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("events") + " WHERE analyst=" + this.userID))).next()) {
                hasData = true;
            }
            boolean bl = hasData;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountAudit() throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        int nAudits = 0;
        String[] fields = new String[]{"updater", "modifier", "creator"};
        try {
            for (String table : Audit.AUDIT_TABLES) {
                for (String field : fields) {
                    String sql = "SELECT count(" + field + ") as n FROM " + this.sbdb.DBTableName(table) + " WHERE " + field + "=" + this.userID;
                    ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                    if (rs.next()) {
                        nAudits += rs.getInt("n");
                    }
                    rs.close();
                }
            }
            int n = nAudits;
            return n;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            String[] fields = new String[]{"updater", "modifier", "creator"};
            for (String table : Audit.AUDIT_TABLES) {
                for (String field : fields) {
                    String sql = "UPDATE " + this.sbdb.DBTableName(table) + " SET " + field + "=null WHERE " + field + "=" + this.userID;
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
            String sql = "DELETE FROM " + this.sbdb.DBTableName("PREF_USER") + " WHERE user_id=" + this.userID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("USERDEF") + " WHERE user_id=" + this.userID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Userdef> getUsers(SBdb sbdb) throws SQLException {
        LinkedList<Userdef> list = new LinkedList<Userdef>();
        String sql = "SELECT user_id,name,abr,sys_name,disc,user_priv,red,green,blue";
        if (sbdb.hasUserPassword) {
            sql = sql + ",password";
        }
        sql = sql + " FROM " + sbdb.DBTableName("USERDEF") + " ORDER BY abr";
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                try {
                    int priv;
                    int usrID = rs.getInt("user_id");
                    String name = rs.getString("name");
                    String abr = rs.getString("abr");
                    if (abr == null) {
                        throw new SBException("User ID is null for user: " + name);
                    }
                    String sys_name = rs.getString("sys_name");
                    String strg = rs.getString("disc");
                    Discipline discID = Discipline.MICRO;
                    if (strg != null && strg.length() > 0) {
                        discID = Discipline.getDisc(strg);
                    }
                    if (((priv = rs.getInt("user_priv")) & 0x40) > 0) {
                        if ((priv & 0x4000) > 0) {
                            System.out.println("Setting export priv for super-user");
                            priv ^= 0x4000;
                        }
                        if ((priv & 4) > 0) {
                            System.out.println("Setting discipline priv for super-user");
                            priv ^= 4;
                        }
                    }
                    Color colour = Color.BLACK;
                    try {
                        colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
                    }
                    catch (Exception n) {
                        // empty catch block
                    }
                    String pwd = "";
                    if (sbdb.hasUserPassword) {
                        if (abr == null) {
                            System.out.println("Warning: USERDEF entry has no user ID");
                        } else {
                            pwd = rs.getString("password");
                        }
                    }
                    list.add(new Userdef(sbdb, usrID, abr, name, sys_name, discID, colour, pwd, priv));
                }
                catch (SBException sbe) {
                    System.out.println("Warning: " + sbe.getMessage());
                }
            }
        }
        finally {
            stmt.close();
        }
        return list;
    }

    static boolean checkUsrid(List users, String usrid) {
        for (Userdef user : users) {
            if (!user.abr.equalsIgnoreCase(usrid)) continue;
            return true;
        }
        return false;
    }

    public Color getStatus() {
        if (this.link != null) {
            return STORED;
        }
        return NOTSTORED;
    }

    public String statusString() {
        return this.abr;
    }

    void writeXML(BufferedWriter out, int indent) throws IOException, SQLException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        Userdef user = this;
        out.write(ind + "<User Name=\"" + SB.getXMLstring((String)user.getName()) + "\">\n");
        out.write(ind + ind + "<UserID>" + user.getUsrID() + "</UserID>\n");
        out.write(ind + ind + "<UserName>" + SB.getXMLstring((String)user.getName()) + "</UserName>\n");
        out.write(ind + ind + "<Abbreviation>" + user.getAbr() + "</Abbreviation>\n");
        out.write(ind + ind + "<DisciplineID>" + user.getDiscipline().getChar() + "</DisciplineID>\n");
        out.write(ind + "</User>\n");
    }

    Userdef(SBdb db, Element xml) throws SBException {
        this.sbdb = db;
        String strgID = xml.getChildTextNormalize("UserID");
        if (strgID == null) {
            throw new SBException("User ID null in XML - invalid");
        }
        this.userID = Integer.parseInt(strgID);
        this.name = xml.getChildText("UserName");
        this.abr = xml.getChildTextNormalize("Abbreviation");
        String discipline = xml.getChildTextNormalize("DisciplineID");
        if (discipline != null && discipline.length() > 0) {
            this.discID = Discipline.getDisc(discipline);
        }
    }

    public int compareTo(Object o) {
        if (o instanceof Userdef) {
            return this.abr.compareTo(((Userdef)o).abr);
        }
        return 0;
    }
}

