/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.Audit;
import model2.Biocom;
import model2.Casing;
import model2.CasingPoint;
import model2.CoOccurrence;
import model2.CoreImage;
import model2.CoredInterval;
import model2.Cores;
import model2.Coreshift;
import model2.Curves;
import model2.DiscAnalyst;
import model2.Discipline;
import model2.EnvScheme;
import model2.GrainSizeList;
import model2.IGDInterval;
import model2.IGDIntervalEnv;
import model2.IGDIntervalZone;
import model2.ImageSet;
import model2.InterpHdr;
import model2.LithBase;
import model2.LithInterval;
import model2.LithQualifier;
import model2.Lithdesc;
import model2.Lithology;
import model2.Markers;
import model2.SBImage;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.SampleLithologyUnit;
import model2.SeismicMarker;
import model2.Smpdtl;
import model2.SmpdtlCompare;
import model2.TVDList;
import model2.TVDepth;
import model2.TWTDepth;
import model2.TWTList;
import model2.Taxon;
import model2.TaxonCompareGenus;
import model2.TaxonCompareSpecies;
import model2.TaxonOcc;
import model2.Userdef;
import model2.WellEvent;
import model2.WellHeader;
import model2.WellInterp;
import util.DTMonitor;
import util.InvalidFieldException;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsCompoundEdit;
import util.SbugsEdit;
import util.SbugsStatus;

public class Well
extends Observable
implements Comparable {
    final SBdb db;
    Coreshift coreShift;
    public static final int SORTDOWNHOLE = 0;
    public static final int SORTUPHOLE = 1;
    public static final int SORTALPHA = 3;
    public static int speciesRecord;
    int wellID = 0;
    WellHeader header = new WellHeader();
    int environmentScheme = 1;
    private List<Sample> samples = null;
    private boolean analysesLoaded = false;
    private List<AnalystHeader> analystHeaders = null;
    List<WellInterp> interps = new LinkedList<WellInterp>();
    private boolean interpsLoaded = false;
    List evProjects = new LinkedList();
    boolean evProjectsLoaded = false;
    List<LithBase> lithIntervals = null;
    GrainSizeList grainSize = new GrainSizeList();
    Cores cores = null;
    List<CoreImage> coreImages = null;
    Casing casing = null;
    Markers markers = null;
    TVDList TVD = null;
    TVDList TVDplan = null;
    TWTList TWT = null;
    boolean useDonorSamples = false;
    boolean useDonorTaxa = false;
    Curves curves = null;

    public SBdb getDataModel() {
        return this.db;
    }

    void updateHeader(WellHeader header) throws SQLException, SBException {
        this.header.update(this.db, header);
    }

    public int getWellID() {
        return this.wellID;
    }

    public String getWellName() {
        return this.header.getWellName();
    }

    public String getWellCode() {
        return this.header.getWellCode();
    }

    public char getType() {
        return this.header.getType();
    }

    public char getWellUnits() {
        return this.header.getWellUnits();
    }

    public double getTD() {
        return this.header.getTD();
    }

    public WellHeader getHeader() {
        return this.header;
    }

    public List<Sample> getSamples(boolean load) throws SQLException, SBException {
        if (this.samples == null) {
            if (load) {
                return this.getSamples();
            }
            this.samples = new LinkedList<Sample>();
        }
        return this.samples;
    }

    public List<Sample> getSamples() throws SQLException, SBException {
        if (this.samples == null) {
            this.samples = new LinkedList<Sample>();
            this.loadSamples();
        }
        return this.samples;
    }

    public List<Sample> getSamples(boolean corrected, boolean correctCuttings) throws SQLException, SBException {
        List<Sample> samps = this.getSamples();
        if (!corrected) {
            return samps;
        }
        LinkedList<CorrectedSample> corrSamps = new LinkedList<CorrectedSample>();
        for (Sample sample : samps) {
            double corrDepth = this.getDepth(sample, corrected, correctCuttings);
            corrSamps.add(new CorrectedSample(corrDepth, sample));
        }
        Collections.sort(corrSamps);
        LinkedList<Sample> list = new LinkedList<Sample>();
        for (CorrectedSample cs : corrSamps) {
            list.add(cs.sample);
        }
        return list;
    }

    public List<LithBase> getLithIntervals() throws SQLException, SBException {
        if (this.lithIntervals == null) {
            this.lithIntervals = new LinkedList<LithBase>();
            if (this.db != null && this.db.isConnected()) {
                this.db.getLithdesc();
                this.loadLithIntervals(this.lithIntervals, this.db.lithdesc);
                this.loadLithQualifiers(this.lithIntervals, this.db.lithdesc);
            }
        }
        return this.lithIntervals;
    }

    public void loadLithology() throws SQLException {
        this.lithIntervals = new LinkedList<LithBase>();
        this.loadLithIntervals(this.lithIntervals, this.db.lithdesc);
        this.loadLithQualifiers(this.lithIntervals, this.db.lithdesc);
    }

    public Cores getCores() throws SQLException, SBException {
        if (this.cores == null) {
            this.cores = new Cores(this.db);
            if (this.db != null && this.db.isConnected()) {
                this.cores.load(this.wellID);
            }
        }
        return this.cores;
    }

    public List<CoreImage> getCoreImages() throws SQLException {
        if (this.coreImages == null) {
            this.coreImages = new LinkedList<CoreImage>();
            if (this.db != null && this.db.isConnected()) {
                CoreImage.load(this.wellID, this.db, this.coreImages);
                System.out.println("Loaded core images");
            }
        }
        return this.coreImages;
    }

    public void deleteCoreImage(CoreImage coreImage) throws SBException, SQLException {
        if (this.coreImages == null) {
            throw new SBException("Attempt to delete core image when no images loaded");
        }
        coreImage.delete(this.wellID);
        this.coreImages.remove(coreImage);
        this.setChanged();
        this.notifyObservers(coreImage);
    }

    public CoreImage addCoreImage(double topDepth, double baseDepth, SBImage image) throws SBException, SQLException, FileNotFoundException, IOException {
        if (this.coreImages == null) {
            throw new SBException("Attempt to add core image when no images loaded");
        }
        CoreImage coreImage = new CoreImage(this.db, this.wellID, topDepth, baseDepth, image);
        int insertPoint = 0;
        for (CoreImage ci : this.coreImages) {
            if (ci.getTopDepth() > coreImage.getTopDepth()) break;
            ++insertPoint;
        }
        this.coreImages.add(insertPoint, coreImage);
        this.setChanged();
        this.notifyObservers(coreImage);
        return coreImage;
    }

    public Casing getCasing() throws SQLException {
        if (this.casing == null) {
            this.casing = new Casing(this.db);
            if (this.db != null && this.db.isConnected()) {
                this.casing.load(this.wellID);
            }
        }
        return this.casing;
    }

    public Casing getCasing(boolean refresh) throws SQLException {
        if (refresh && this.casing != null) {
            this.casing.deleteObservers();
            this.casing = null;
        }
        return this.getCasing();
    }

    public Markers getMarkers() throws SQLException {
        if (this.markers == null) {
            this.markers = new Markers(this.db);
            if (this.db != null && this.db.isConnected()) {
                this.markers.load(this.wellID);
            }
        }
        return this.markers;
    }

    void init() {
    }

    public TVDList getTVDlist(boolean isPlan) throws SQLException {
        if (isPlan) {
            if (this.TVDplan == null) {
                this.TVDplan = new TVDList(this.db, true);
                if (this.db != null && this.db.isConnected()) {
                    this.TVDplan.load(this.wellID);
                }
            }
            return this.TVDplan;
        }
        if (this.TVD == null) {
            this.TVD = new TVDList(this.db, false);
            if (this.db != null && this.db.isConnected()) {
                this.TVD.load(this.wellID);
            }
        }
        return this.TVD;
    }

    public TWTList getTWTlist() throws SQLException {
        if (this.TWT == null) {
            this.TWT = new TWTList(this.db);
            if (this.db != null && this.db.isConnected()) {
                this.TWT.load(this.wellID);
            }
        }
        return this.TWT;
    }

    void removeInterp(WellInterp wellInterp) {
        if (this.interps.remove(wellInterp)) {
            this.setChanged();
        }
    }

    public Iterator<WellInterp> getInterpIterator() {
        return this.interps.iterator();
    }

    public WellInterp getInterp(int interpID) throws SBException {
        Iterator<WellInterp> i$ = this.interps.iterator();
        while (i$.hasNext()) {
            WellInterp interp;
            WellInterp thisInterp = interp = i$.next();
            if (interpID != thisInterp.interpID) continue;
            return thisInterp;
        }
        throw new SBException("InterpID: " + interpID + " not found in well: " + this);
    }

    public WellInterp getAddInterp(int interpID, HashMap<Integer, InterpHdr> interpHdrs) throws SBException, SQLException {
        WellInterp thisInterp = null;
        for (int i = 0; i < this.interps.size(); ++i) {
            thisInterp = this.interps.get(i);
            if (interpID != thisInterp.interpID) continue;
            return thisInterp;
        }
        thisInterp = new WellInterp(this.db, interpID, interpHdrs, this.header.getType(), true);
        this.interps.add(thisInterp);
        this.setChanged();
        this.notifyObservers(thisInterp);
        return thisInterp;
    }

    public WellInterp getAddInterp(InterpHdr interpHdr) throws SBException, SQLException {
        WellInterp thisInterp = null;
        for (int i = 0; i < this.interps.size(); ++i) {
            thisInterp = this.interps.get(i);
            if (interpHdr.getInterpID() != thisInterp.interpID) continue;
            return thisInterp;
        }
        thisInterp = new WellInterp(this.db, interpHdr.getInterpID(), this.db.getInterpHdrs(), this.header.getType(), true);
        this.interps.add(thisInterp);
        this.setChanged();
        this.notifyObservers(thisInterp);
        return thisInterp;
    }

    public boolean hasInterpLoaded(int interpID) {
        WellInterp thisInterp = null;
        for (int i = 0; i < this.interps.size(); ++i) {
            thisInterp = this.interps.get(i);
            if (interpID != thisInterp.interpID) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.wellID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAnalyses(AnalystHeader hdr) throws SQLException {
        Statement stmt = this.db.getDatabase().createStatement();
        try {
            String sql = "SELECT DISTINCT image_set_id FROM " + this.db.DBTableName("TAXONOCC") + " WHERE well_id=" + this.wellID + " AND analy_id=" + hdr.getAnalyID();
            LinkedList<Integer> imageSetIDs = new LinkedList<Integer>();
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                imageSetIDs.add(rs.getInt("image_set_id"));
            }
            sql = "DELETE FROM " + this.db.DBTableName("TAXONOCC") + " WHERE well_id=" + this.wellID + " AND analy_id=" + hdr.getAnalyID();
            stmt.executeUpdate(this.db.modQuery(sql));
            for (Integer i : imageSetIDs) {
                System.out.println("Deleting imageSet: " + i);
                ImageSet.deleteWithTypeCheck(this.db, i, this.wellID);
            }
            sql = "DELETE FROM " + this.db.DBTableName("SMPDTL") + " WHERE well_id=" + this.wellID + " AND analy_id=" + hdr.getAnalyID();
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "DELETE FROM " + this.db.DBTableName("ANALY_HDR") + " WHERE well_id=" + this.wellID + " AND analy_id=" + hdr.getAnalyID();
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        Iterator<Sample> it = this.samples.iterator();
        Sample changedSample = null;
        while (it.hasNext()) {
            Sample sample = it.next();
            sample.removeDtl(hdr.getAnalyID());
            if (!sample.hasChanged()) continue;
            changedSample = sample;
        }
        Iterator<AnalystHeader> itH = this.analystHeaders.iterator();
        while (itH.hasNext()) {
            if (itH.next() != hdr) continue;
            itH.remove();
        }
        this.setChanged();
        this.notifyObservers();
        if (changedSample != null) {
            changedSample.notifyObservers();
        }
    }

    public int getAnalysesOccs(AnalystHeader hdr) throws SBException, SQLException {
        int nOccs = 0;
        for (Smpdtl dtl : this.getAnalyses(hdr.getDiscID(), hdr.getAnalyst(), hdr.getAnalyNumber())) {
            if (dtl.getAnalyID() != hdr.getAnalyID()) continue;
            ++nOccs;
        }
        return nOccs;
    }

    public boolean setAnalystHeader(AnalystHeader hdr, double top, double base, Date from, Date to, String comments, int envSchID, int abnSchID, Color colour) throws SQLException, SBException {
        boolean updated = false;
        EnvScheme envSch = null;
        if (envSchID > 0) {
            envSch = this.db.getEnvScheme(envSchID);
        }
        AbnScheme abnSch = null;
        if (abnSchID > 0) {
            abnSch = this.db.getAbnScheme(abnSchID, true);
        }
        Iterator<Smpdtl> it = this.getAnalyses(hdr.getDiscID(), hdr.getAnalyst(), hdr.getAnalyNumber()).iterator();
        double topTemp = 99999.0;
        double baseTemp = 0.0;
        while (it.hasNext()) {
            double depth;
            Smpdtl dtl = it.next();
            if (dtl.getAnalyID() != hdr.getAnalyID()) continue;
            if (dtl.getCreated() != null && (from == null || dtl.getCreated().before(from))) {
                updated = true;
                from = dtl.getCreated();
            }
            if (dtl.getCreated() != null && (to == null || dtl.getCreated().after(to))) {
                updated = true;
                to = dtl.getCreated();
            }
            if ((depth = dtl.getSample().getDepth()) < topTemp) {
                topTemp = depth;
            }
            if (depth > baseTemp) {
                baseTemp = depth;
            }
            if (envSch != null) {
                if (dtl.getProximal() > envSch.getNClasses()) {
                    throw new SBException("Cannot assign palaeoenvironment scheme because sample data environment falls outside new scheme");
                }
                if (dtl.getDistal() > envSch.getNClasses()) {
                    throw new SBException("Cannot assign palaeoenvironment scheme because sample data environment falls outside new scheme");
                }
            }
            if (dtl.checkSubjAbunds(abnSch)) continue;
            throw new SBException("Abundance scheme not appropriate for existing abundance data in sample set in depth: " + dtl.getSample());
        }
        if (topTemp < 99999.0 && topTemp > top) {
            updated = true;
            top = topTemp;
        }
        if (baseTemp > base) {
            updated = true;
            base = baseTemp;
        }
        hdr.update(this.wellID, top, base, from, to, comments, envSchID, abnSchID, colour);
        return updated;
    }

    void loadAnalystHeaders() throws SQLException {
        if (this.analystHeaders == null) {
            this.analystHeaders = new LinkedList<AnalystHeader>();
            if (this.db != null && this.db.isConnected()) {
                AnalystHeader.loadAll(this.db, this.wellID, this.analystHeaders);
            }
        }
    }

    public List<AnalystHeader> getAnalystHeaders() throws SQLException {
        this.loadAnalystHeaders();
        return new LinkedList<AnalystHeader>(this.analystHeaders);
    }

    public Iterator<AnalystHeader> getAnalystHeaderIterator() throws SQLException {
        return this.getAnalystHeaders().iterator();
    }

    public AnalystHeader addAnalystHeader(String analyst, char discID, int analyNumber, Double top, Double base, Date from, Date to, String comments, int envSchID, int abnSchID, Color colour) throws SQLException, SBException {
        if (this.getAnalystHeader(analyst, discID, analyNumber, false) != null) {
            throw new SBException("Analyst Header already exists");
        }
        AnalystHeader hdr = new AnalystHeader(this.db, this.wellID, analyst, Discipline.getDisc(discID), analyNumber, from, to, top, base, comments, envSchID, abnSchID, colour);
        this.analystHeaders.add(hdr);
        this.setChanged();
        this.notifyObservers(hdr);
        return hdr;
    }

    void addAnalystHeader(AnalystHeader hdr) throws SBException, SQLException {
        if (this.getAnalystHeader(hdr.getAnalyst(), hdr.getDiscID(), hdr.getAnalyNumber(), false) != null) {
            throw new SBException("Analyst Header already exists");
        }
        this.analystHeaders.add(hdr);
    }

    public void setAnalystHeader(AnalystHeader hdr, String analyst, char discID, int analyNumber) throws SQLException, SBException {
        AnalystHeader existing = this.getAnalystHeader(analyst, discID, analyNumber, false);
        if (existing != null && existing.getAnalyID() != hdr.getAnalyID()) {
            throw new SBException("Cannot update analyst header details - header already exists");
        }
        hdr.updateDetails(this.wellID, this.db.getUserID(analyst), Discipline.getDisc(discID), analyNumber);
        this.setChanged();
        this.notifyObservers(hdr);
    }

    public AnalystHeader getAnalystHeader(String analyst, char discID, int analyNo, boolean create) throws SQLException, SBException {
        this.loadAnalystHeaders();
        Iterator<AnalystHeader> it = this.analystHeaders.iterator();
        AnalystHeader aHead = null;
        while (it.hasNext()) {
            AnalystHeader aHeader = it.next();
            if (!analyst.equals(aHeader.getAnalyst()) || discID != aHeader.getDiscID() || analyNo != aHeader.getAnalyNumber()) continue;
            aHead = aHeader;
            break;
        }
        if (aHead == null && create) {
            aHead = new AnalystHeader(this.db, this.wellID, analyst, Discipline.getDisc(discID), analyNo, this.analystHeaders.size());
            this.analystHeaders.add(aHead);
        }
        return aHead;
    }

    AnalystHeader getAnalystHeader(int analyID, boolean load) throws SQLException, SBException {
        this.loadAnalystHeaders();
        Iterator<AnalystHeader> it = this.analystHeaders.iterator();
        AnalystHeader analystHeader = null;
        while (it.hasNext()) {
            AnalystHeader aHeader = it.next();
            if (aHeader.getAnalyID() != analyID) continue;
            analystHeader = aHeader;
            break;
        }
        if (analystHeader == null && load) {
            analystHeader = new AnalystHeader(this.db, this.wellID, analyID);
            this.analystHeaders.add(analystHeader);
        }
        return analystHeader;
    }

    public char getPrefUnits(char units) {
        if (units == 'D') {
            units = this.header.getWellUnits();
        }
        return units;
    }

    String wellCode() {
        return this.header.getWellCode();
    }

    char type() {
        return this.header.getType();
    }

    void updateSampleAnalyst(boolean saveToDatabase, int sampID, char discID, int analyst, int newAnalyst) throws SQLException, SBException {
        if (saveToDatabase) {
            Statement stmt = this.db.getDatabase().createStatement();
            String sql = "UPDATE " + this.db.DBTableName("igd") + " SET top_analy=" + newAnalyst + " WHERE top_id=" + sampID + " AND top_analy=" + analyst;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("igd") + " SET base_analy=" + newAnalyst + " WHERE base_id=" + sampID + " AND base_analy=" + analyst;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("bcmmnts") + " SET analyst=" + newAnalyst + " WHERE usamp_id=" + sampID + " AND disc_id='" + discID + "' AND analyst=" + analyst;
            sql = "UPDATE " + this.db.DBTableName("bcmmnts") + " SET analyst=" + newAnalyst + " WHERE lsamp_id=" + sampID + " AND disc_id='" + discID + "' AND analyst=" + analyst;
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        for (WellInterp interp : this.interps) {
            for (Biocom biocom : interp.comments) {
                if (biocom.getTopID() != sampID && biocom.getBaseID() != sampID || biocom.getDiscID() != discID || biocom.getAnalyst() != analyst) continue;
                throw new SBException("Can't update biocom analyst");
            }
            List<IGDIntervalZone> igdVec = interp.getIGDList(4, 0);
            for (IGDIntervalZone zone : igdVec) {
                if (zone.getTopID() == sampID && zone.getTopAnalyst() == analyst) {
                    throw new SBException("Can't update zonal analyst");
                }
                if (zone.getBaseID() != sampID || zone.getBaseAnalyst() != analyst) continue;
                throw new SBException("Can't update zonal analyst");
            }
        }
    }

    public void fillInterpCombo(JComboBox combo) {
        combo.removeAllItems();
        Iterator<WellInterp> it = this.interps.iterator();
        while (it.hasNext()) {
            combo.addItem(it.next());
        }
    }

    public void loadInterps() throws SQLException, SBException {
        this.loadInterps(this.db.getInterpHdrs());
    }

    public void loadInterp(WellInterp wellInterp) throws SQLException, SBException {
        this.getSamples();
        wellInterp.load(this);
        this.loadSampleAges(wellInterp.interpID);
    }

    private void queryInterp(Statement stmt, HashMap<Integer, InterpHdr> interpHdrs, String tableName) throws SQLException {
        String sql = "SELECT DISTINCT interp_id FROM " + this.db.DBTableName(tableName) + " WHERE well_id=" + this.wellID;
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        int interpID = 0;
        while (rs.next()) {
            try {
                interpID = rs.getInt("interp_id");
                this.getInterp(interpID);
            }
            catch (SBException se) {
                this.interps.add(new WellInterp(this.db, interpID, interpHdrs, this.type(), false));
            }
        }
    }

    void loadInterps(HashMap<Integer, InterpHdr> interpHdrs) throws SQLException, SBException {
        if (!this.interpsLoaded && this.wellID > 0 && this.db.isConnected()) {
            Statement stmt = this.db.getDatabase().createStatement();
            this.queryInterp(stmt, interpHdrs, "IGD");
            this.queryInterp(stmt, interpHdrs, "IGD_ENV");
            this.queryInterp(stmt, interpHdrs, "BCMMNTS");
            this.queryInterp(stmt, interpHdrs, "EVENTS");
            this.queryInterp(stmt, interpHdrs, "SQPICK");
            this.queryInterp(stmt, interpHdrs, "INTCMMNTS");
            this.queryInterp(stmt, interpHdrs, "LOC");
            this.interpsLoaded = true;
            stmt.close();
        }
        this.getAddInterp(0, interpHdrs);
    }

    public void loadGrainSize() throws SQLException {
        if (this.wellID > 0 && this.grainSize.size() == 0 && this.db != null && this.db.isConnected()) {
            this.grainSize.load(this.db, this.wellID);
        }
    }

    public GrainSizeList getGrainSize() {
        return this.grainSize;
    }

    public void mergeCoOcc(List coOcc, boolean addAbund) throws SQLException, SBException, FileNotFoundException, IOException {
        for (CoOccurrence occ : coOcc) {
            TaxonOcc donor = null;
            TaxonOcc target = null;
            Sample sample = null;
            Smpdtl dtl = null;
            for (Sample s : this.samples) {
                if (s.getSampID() != occ.sampID) continue;
                for (Smpdtl smpdtl : s.getAnalyses()) {
                    if (smpdtl.getAnalyID() != occ.analyID) continue;
                    dtl = smpdtl;
                    sample = s;
                    for (TaxonOcc to : smpdtl.getOccur()) {
                        if (to.getTaxon() == occ.donor.getTaxon() && to.getIdentType() == occ.donor.getIdentType() && to.getReworked() == occ.donor.getReworked() && to.getSpecType() == occ.donor.getSpecType()) {
                            donor = to;
                        }
                        if (to.getTaxon() != occ.target.getTaxon() || to.getIdentType() != occ.target.getIdentType() || to.getReworked() != occ.target.getReworked() || to.getSpecType() != occ.target.getSpecType()) continue;
                        target = to;
                    }
                }
            }
            if (donor == null || target == null) {
                throw new SBException("Cannot relocate donor/target in merge CoOccurrences");
            }
            if (addAbund) {
                String comments;
                String colour;
                String preserv;
                int coarse = target.getCoarse() + donor.getCoarse();
                int medium = target.getMedium() + donor.getMedium();
                int fine = target.getFine() + donor.getFine();
                String subjAbund = target.getSubAbund();
                if (donor.getSubAbund() != null && donor.getSubAbund().length() > 0) {
                    if (subjAbund == null || subjAbund.length() == 0) {
                        subjAbund = donor.getSubAbund();
                    } else {
                        int schID = this.getAnalystHeader(occ.analyID, false).getAbnSchID();
                        if (schID == 0) {
                            throw new SBException("Cannot merge semi-quantitative abundance: abundance scheme not set.");
                        }
                        AbnScheme scheme = this.db.getAbnScheme(schID, false);
                        if (scheme == null) {
                            throw new SBException("Cannot merge semi-quantitative abundance: abundance scheme not found.");
                        }
                        subjAbund = scheme.getAbr(scheme.getCount(subjAbund) + scheme.getCount(donor.getSubAbund()));
                    }
                }
                boolean marker = target.isMarker();
                if (donor.isMarker()) {
                    marker = true;
                }
                boolean caved = target.getCaved();
                if (donor.getCaved()) {
                    caved = true;
                }
                if ((preserv = target.getPreservation()) == null || preserv.length() == 0) {
                    preserv = donor.getPreservation();
                }
                if ((colour = target.getColour()) == null || colour.length() == 0) {
                    colour = donor.getColour();
                }
                if ((comments = target.getComment()) == null || comments.length() == 0) {
                    comments = donor.getComment();
                }
                ImageSet imageSet = null;
                if (target.hasImageSet()) {
                    imageSet = target.getImageSet();
                }
                if (imageSet == null && donor.hasImageSet()) {
                    imageSet = donor.getImageSet();
                    donor.deleteImageSet(this.wellID, occ.sampID, occ.analyID);
                }
                dtl.deleteOcc(this.wellID, target);
                dtl.insertOccurrence(new TaxonOcc.Builder(this.db, target.getTaxon(), target.getReworked(), target.getQuestionable(), target.getSpecType()).count(coarse, medium, fine).subjAbund(subjAbund).caved(caved).marker(marker).preservation(preserv).colour(colour).comment(comments).imageSet(imageSet), this.wellID, true);
            }
            dtl.deleteOcc(this.wellID, donor);
            dtl.notifyObservers();
        }
    }

    public void mergeTaxa(Taxon donor, Taxon target) throws SQLException, SBException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "UPDATE " + this.db.DBTableName("taxonocc") + " SET spec_id=" + target.getSpecID() + " WHERE spec_id=" + donor.getSpecID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        this.updateTaxonRef(donor, target);
        stmt.close();
    }

    void updateTaxonRef(Taxon donor, Taxon target) throws SBException {
        if (this.samples != null) {
            Iterator<Sample> i$ = this.samples.iterator();
            while (i$.hasNext()) {
                Sample o;
                Sample s = o = i$.next();
                for (Smpdtl od : s.analyses) {
                    Smpdtl d = od;
                    if (!d.updateTaxonRef(donor, target)) continue;
                    d.notifyObservers();
                }
            }
        }
    }

    public Well(SBdb SB2) throws SQLException {
        this.db = SB2;
        this.init();
    }

    public Well(SBdb db, Well well) {
        this.db = db;
    }

    public Well(SBdb SB2, int i) throws SQLException, SBException {
        this.db = SB2;
        this.wellID = i;
        this.init();
        this.header.load(SB2, this.wellID);
    }

    public Well(SBdb SB2, int i, boolean loadSamp, boolean loadFss) throws SQLException, SBException {
        this.db = SB2;
        this.wellID = i;
        this.init();
        this.header.load(SB2, this.wellID);
        if (loadSamp) {
            this.loadSamples();
        }
    }

    public int compareTo(Object o) {
        Well rhs = (Well)o;
        return this.header.compareTo(rhs.header);
    }

    public Sample getSampleNearestBelow(double depth) throws SBException {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            if (!(depth <= sample.getDepth())) continue;
            return sample;
        }
        return null;
    }

    public Sample getSampleNearestAbove(double depth, boolean correctDepths, boolean correctCuttings) throws SBException, SQLException {
        for (int i = this.samples.size() - 1; i >= 0; --i) {
            Sample sample = this.samples.get(i);
            if (!(depth >= this.getDepth(sample, correctDepths, correctCuttings))) continue;
            return sample;
        }
        return null;
    }

    public Sample getSampleNearest(double depth, float withinRange, boolean correctDepths, boolean correctCuttings) throws SBException, SQLException {
        Sample sample = null;
        for (int i = 0; i < this.samples.size(); ++i) {
            double distAbove;
            sample = this.samples.get(i);
            double sampleDepth = this.getDepth(sample, correctDepths, correctCuttings);
            if (!(depth <= sampleDepth)) continue;
            double distBelow = sampleDepth - depth;
            Sample sampleAbove = this.getSampleNearestAbove(depth, correctDepths, correctCuttings);
            if (sampleAbove != null && (distAbove = depth - this.getDepth(sampleAbove, correctDepths, correctCuttings)) < distBelow && distAbove < (double)withinRange) {
                return sampleAbove;
            }
            if (distBelow < (double)withinRange) {
                return sample;
            }
            return null;
        }
        if (sample != null && this.getDepth(sample, correctDepths, correctCuttings) - depth < (double)withinRange) {
            return sample;
        }
        return null;
    }

    public Sample getSample(double depth, String type, boolean useAnyType) {
        if (!useAnyType && type == null) {
            type = "CU";
        }
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            try {
                if (!useAnyType && !sample.getTypeString().equals(type) || !(this.db.useSampleTops() ? sample.getTopDepth() != null && Math.abs(depth - sample.getTopDepth('M')) < (double)0.0029f : sample.getBaseDepth() != null && Math.abs(depth - sample.getBaseDepth('M')) < (double)0.0029f)) continue;
                return sample;
            }
            catch (SBException se) {
                // empty catch block
            }
        }
        return null;
    }

    public Sample getSample(Double topDepth, Double baseDepth, String type, boolean useAnyType) {
        if (!useAnyType && type == null) {
            type = "CU";
        }
        Sample bestMatch = null;
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            try {
                if (!useAnyType && !sample.getTypeString().equals(type) || !sample.compareDepth(topDepth, baseDepth)) continue;
                if (bestMatch != null) {
                    if ((topDepth != null || sample.hasTopDepth()) && (baseDepth != null || sample.hasBaseDepth())) continue;
                    bestMatch = sample;
                    continue;
                }
                bestMatch = sample;
                continue;
            }
            catch (SBException se) {
                // empty catch block
            }
        }
        return bestMatch;
    }

    public Sample getSample(Double topDepth, Double baseDepth, String type) {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            try {
                if (!sample.getTypeString().equals(type) || !sample.compareDepth(topDepth, baseDepth)) continue;
                return sample;
            }
            catch (SBException se) {
                // empty catch block
            }
        }
        return null;
    }

    Sample getTopSample(double topDepth, String type, boolean useAnyType) {
        if (!useAnyType && type == null) {
            type = "CU";
        }
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            try {
                if (!useAnyType && !sample.getType().equals(type) || !(Math.abs(topDepth - sample.getTopDepth()) < (double)0.0029f)) continue;
                return sample;
            }
            catch (SBException se) {
                // empty catch block
            }
        }
        return null;
    }

    public void deleteSample(Sample sample) throws SQLException {
        if (this.db != null && this.db.isConnected()) {
            sample.delete(this.wellID);
        }
        this.samples.remove(sample);
        this.setChanged();
    }

    public int hasSampleIGD(Sample sample) throws SQLException, SBException {
        Iterator<WellInterp> it = this.interps.iterator();
        int sampID = sample.getSampID();
        while (it.hasNext()) {
            WellInterp in = it.next();
            for (int i = 0; i < in.zoneTypes.length; ++i) {
                List vect = in.zoneTypes[i];
                for (IGDInterval zone : vect) {
                    if (zone.getTopSample() == sample || zone.getBaseSample() == sample) {
                        return IGDInterval.igdType2dType(WellInterp.zoneType2IGDType(i));
                    }
                    if (sampID > 0 && zone.getTopID() > 0 && sampID == zone.getTopID()) {
                        return IGDInterval.igdType2dType(WellInterp.zoneType2IGDType(i));
                    }
                    if (sampID <= 0 || zone.getBaseID() <= 0 || sampID != zone.getBaseID()) continue;
                    return IGDInterval.igdType2dType(WellInterp.zoneType2IGDType(i));
                }
            }
            for (Biocom biocom : in.comments) {
                if (biocom.getTopSample() == sample || biocom.getBaseSample() == sample) {
                    return SBdb.did2comType(biocom.getDiscID());
                }
                if (sampID > 0 && biocom.getTopID() > 0 && sampID == biocom.getTopID()) {
                    return SBdb.did2comType(biocom.getDiscID());
                }
                if (sampID <= 0 || biocom.getBaseID() <= 0 || sampID != biocom.getBaseID()) continue;
                return SBdb.did2comType(biocom.getDiscID());
            }
            if (in.picks == null) continue;
            for (SQPick pick : in.picks) {
                if (pick.getSample() != sample) continue;
                return 14;
            }
        }
        if (sample.sampleLithology.getLithology().size() > 0) {
            return 22;
        }
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = this.interps.get(ni);
            if (sample.hasAgeData(in.interpID)) {
                return 1;
            }
            if (in.events == null) continue;
            for (WellEvent event : in.events) {
                if (event.getSample() == sample) {
                    return 16;
                }
                if (event.getSampID() <= 0 || sampID <= 0 || event.getSampID() != sampID) continue;
                return 16;
            }
        }
        if (this.db != null && this.db.isConnected()) {
            return sample.hasIGDdataInDB(this.wellID);
        }
        return 0;
    }

    public boolean hasSampleLithology() throws SQLException, SBException {
        for (Sample s : this.getSamples()) {
            if (s.getLithology().lithology.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Sample getSample(int sampID) {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            if (sample.getSampID() != sampID) continue;
            return sample;
        }
        return null;
    }

    public Sample addSample(Double topDepth, Double baseDepth, String sampleType, String label) throws SBException, SQLException {
        Sample sample = new Sample(this.db, this.type(), topDepth, baseDepth, sampleType, label);
        Statement stmt = this.db.getDatabase().createStatement();
        this.addSample(stmt, sample);
        stmt.close();
        return sample;
    }

    public Sample addWsSample(Statement stmt, Sample wsSample) throws SBException, SQLException {
        Sample sample = new Sample(this.db, this.type(), wsSample.getTopDepth(), wsSample.getBaseDepth(), wsSample.getType(), wsSample.getLabel());
        wsSample.setLink(sample);
        this.addSample(stmt, sample);
        return sample;
    }

    public void updateSample(Sample sample, Double topDepth, Double baseDepth, String sampleType, String label) throws SBException, SQLException {
        boolean baseChanged;
        boolean depthChanged = false;
        boolean detailsChanged = false;
        boolean topChanged = topDepth != null != sample.hasTopDepth() || topDepth != null && Math.abs(sample.getTopDepth() - topDepth) > 9.0E-4;
        boolean bl = baseChanged = baseDepth != null != sample.hasBaseDepth() || baseDepth != null && Math.abs(sample.getBaseDepth() - baseDepth) > 9.0E-4;
        if (topChanged || baseChanged) {
            depthChanged = true;
        }
        if (!sampleType.equals(sample.getType()) || !label.equals(sample.getLabel())) {
            detailsChanged = true;
        }
        if (depthChanged || detailsChanged) {
            sample.update(this.wellID, topDepth, baseDepth, sampleType, label);
        }
        if (depthChanged) {
            this.samples.remove(sample);
            Sample.insert(this.samples, sample, this.getWellUnits());
            this.setChanged();
            return;
        }
        if (detailsChanged) {
            this.setChanged();
        }
    }

    public void refresh(Statement stmt) throws SQLException, SBException {
        this.header.refresh(this.db, this.wellID, stmt);
        AnalystHeader.refresh(stmt, this.db, this.wellID, this.analystHeaders);
        this.refreshSamples(stmt);
        this.refreshAnalyses(stmt);
        this.refreshCores(stmt);
        this.refreshMarkers(stmt);
        for (WellInterp wellInterp : this.interps) {
            wellInterp.refresh(stmt, this);
        }
    }

    synchronized void refreshCores(Statement stmt) throws SQLException, SBException {
        if (this.cores != null) {
            this.cores.refresh(stmt, this.wellID);
        }
    }

    synchronized void refreshMarkers(Statement stmt) throws SQLException, SBException {
        if (this.markers != null) {
            this.markers.refresh(stmt, this.wellID);
        }
    }

    synchronized void refreshSamples(Statement stmt) throws SQLException, SBException {
        if (this.samples == null) {
            return;
        }
        String sql = "SELECT samp_id,updated ";
        sql = sql + " FROM " + this.db.DBTableName("SAMPLES") + " WHERE well_id=" + this.wellID;
        sql = this.db.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        Sample notifier = null;
        HashSet<Integer> sampleIDs = new HashSet<Integer>();
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            sampleIDs.add(sampID);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Sample s : this.samples) {
                if (s.getSampID() != sampID) continue;
                found = true;
                if (time == null || !time.after(s.getUpdated())) break;
                Sample sample = new Sample(this.db, this.wellID, sampID, this.type());
                s.copy(sample);
                notifier = s;
                break;
            }
            if (found) continue;
            notifier = new Sample(this.db, this.wellID, sampID, this.type());
            Sample.insert(this.samples, notifier, this.type());
        }
        if (sampleIDs.size() < this.samples.size()) {
            Iterator<Sample> it = this.samples.iterator();
            while (it.hasNext()) {
                Sample s = it.next();
                if (sampleIDs.contains(s.getSampID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = s;
            }
        }
        sql = "SELECT samp_id,interp_id,updated ";
        sql = sql + " FROM " + this.db.DBTableName("SBSSR") + " WHERE well_id=" + this.wellID;
        sql = this.db.modQuery(sql);
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            int interpID = rs.getInt("interp_id");
            Timestamp time = rs.getTimestamp("updated");
            Sample sample = this.getSample(sampID);
            if (time == null || sample.getAgeUpdated(interpID) != null && !time.after(sample.getAgeUpdated(interpID))) continue;
            sample.loadAges(this.wellID, interpID);
            if (notifier != null) continue;
            notifier = sample;
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    public void loadSamples() throws SQLException, SBException {
        try {
            if (this.db == null || !this.db.isConnected()) {
                return;
            }
            System.out.println("WellID: " + this.wellID + " Loading samples...");
            if (this.samples == null) {
                this.samples = new LinkedList<Sample>();
            }
            if (this.wellID > 0) {
                String sql = "SELECT samp_id,top_depth,base_depth,type,grid_x,grid_y,label," + Audit.sqlFieldString();
                sql = sql + " FROM " + this.db.DBTableName("SAMPLES") + " WHERE well_id=" + this.wellID;
                sql = sql + " ORDER BY base_depth, top_depth, type, samp_id";
                sql = this.db.modQuery(sql);
                Statement stmt = this.db.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                boolean askDuplicates = false;
                boolean mergeDuplicates = false;
                while (rs.next()) {
                    int sampID = rs.getInt("samp_id");
                    BigDecimal topDepth = SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (this.db.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                    BigDecimal baseDepth = SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (this.db.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                    String sampleType = rs.getString("type");
                    int gridX = rs.getInt("grid_x");
                    int gridY = rs.getInt("grid_y");
                    String strg = rs.getString("label");
                    Audit audit = new Audit(rs);
                    Sample sample = new Sample(this.db, this.type(), sampID, topDepth == null ? null : Double.valueOf(topDepth.doubleValue()), baseDepth == null ? null : Double.valueOf(baseDepth.doubleValue()), sampleType, gridX, gridY, strg, audit);
                    boolean exists = false;
                    for (int i = 0; i < this.samples.size(); ++i) {
                        Sample exist = this.samples.get(i);
                        if (sample.compareTo(exist) != 0) continue;
                        if (exist.getSampID() != sample.getSampID() && exist.getSampID() > 0) {
                            if (SB.hasGUI) {
                                if (!askDuplicates) {
                                    int opt = JOptionPane.showConfirmDialog(null, "Warning: Duplicate sample found at depth: " + sample.toString(this.header.getWellUnits()) + "\nDo you want to attempt to auto-merge ALL such duplicates?", "Duplicates", 0, 3);
                                    if (opt == 0) {
                                        mergeDuplicates = true;
                                    }
                                    askDuplicates = true;
                                }
                                if (mergeDuplicates) {
                                    String reason = this.mergeSampleCheckConflicts(exist, sample);
                                    if (reason == null) {
                                        this.mergeSamples(sample, exist);
                                        exists = true;
                                        break;
                                    }
                                    JOptionPane.showMessageDialog(null, "Duplicate sample at depth: " + sample.toString(this.header.getWellUnits()) + "\ncannot be merged because: " + reason, "Well: " + this.getWellName(), 2);
                                } else {
                                    JOptionPane.showMessageDialog(null, "Warning: Duplicate sample found.\nYou must merge sample labelled as DUPLICATE at depth: " + sample.toString(this.header.getWellUnits()) + "\nUse Samples menu: merge.", "Well: " + this.getWellName(), 2);
                                }
                            }
                            System.out.println("Warning: Duplicate sample for well: " + this + ", sample: " + sample + ", ID: " + sample.getSampID() + " Original sample ID: " + exist.getSampID());
                            sample.setLabel(sample.getLabel() + "DUPLICATE");
                            continue;
                        }
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    Sample.insert(this.samples, sample, this.header.getWellUnits());
                }
                stmt.close();
                this.loadSampleLithology();
                this.loadSampleAges(0);
                if (mergeDuplicates) {
                    this.getDataModel().commit();
                }
            }
            for (int i = 0; i < this.samples.size(); ++i) {
                Sample sample = this.samples.get(i);
            }
        }
        catch (SBException se) {
            throw new SBException("Well : " + this + ". Loading samples:" + se.getMessage());
        }
    }

    public double getMinAge(int interpID) {
        double age = 99999.0;
        for (Sample s : this.samples) {
            if (s == null) {
                System.out.println("Warning: null sample pointer in Well.getMinAge");
                continue;
            }
            if (s.getAge(interpID) == null || !(s.getAge(interpID) < age)) continue;
            age = s.getAge(interpID);
        }
        if (age > 1000.0) {
            age = 0.0;
        }
        return age;
    }

    public double getMaxAge(int interpID) {
        double age = 0.0;
        for (Sample s : this.samples) {
            if (s == null) {
                System.out.println("Warning: null sample pointer in Well.getMaxAge");
                continue;
            }
            if (s.getAge(interpID) == null || !(s.getAge(interpID) > age)) continue;
            age = s.getAge(interpID);
        }
        return age;
    }

    public void loadSampleAges(WellInterp wellInterp) throws SQLException, SBException {
        this.loadSampleAges(wellInterp.interpID);
    }

    public void loadSampleAges(int interpID) throws SQLException, SBException {
        String sql = "SELECT samp_id,age,age_below,ageplus,ageminus,ratio FROM " + this.db.DBTableName("SBSSR") + " WHERE well_id=" + this.wellID;
        sql = sql + " AND interp_id=" + interpID;
        sql = this.db.modQuery(sql);
        Statement stmt = this.db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        this.getSamples();
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            Sample sample = this.getSample(sampID);
            if (sample != null) {
                Double age = rs.getDouble("age");
                Double ageBelow = rs.getDouble("age_below");
                Float ageErrorPlus = Float.valueOf(rs.getFloat("ageplus"));
                Float ageErrorMinus = Float.valueOf(rs.getFloat("ageminus"));
                Double ratio = rs.getDouble("ratio");
                sample.setAge(interpID, age, ageBelow, ageErrorPlus, ageErrorMinus, ratio, this.wellID);
                continue;
            }
            System.out.println("Cannot find sample: " + sampID + " in loadSampleAges");
        }
        stmt.close();
    }

    public void deleteSampleAges(int interpID) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.db.DBTableName("SBSSR") + " WHERE well_id=" + this.wellID;
        sql = sql + " AND interp_id=" + interpID;
        sql = this.db.modQuery(sql);
        Statement stmt = this.db.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        for (Sample o : this.samples) {
            Sample sample = o;
            if (!sample.hasAgeData(interpID)) continue;
            sample.removeAgeData(interpID);
        }
        stmt.close();
    }

    public double getTopSampleDepth() throws SBException, SQLException {
        if (this.getSamples().size() > 0) {
            Sample sample = this.samples.get(0);
            return sample.getDepth('M');
        }
        return 0.0;
    }

    public double getBaseSampleDepth() throws SBException, SQLException {
        if (this.getSamples().size() > 0) {
            Sample sample = this.samples.get(this.samples.size() - 1);
            return sample.getDepth('M');
        }
        return 0.0;
    }

    public Sample getBaseSample(boolean correctDepths, boolean correctCuttings) throws SBException, SQLException {
        if (this.getSamples().isEmpty()) {
            return null;
        }
        if (!correctDepths && !correctCuttings) {
            this.samples.get(this.samples.size() - 1);
        }
        double deepestCorrDepth = -1.0;
        Sample deepestSample = null;
        for (Sample sample : this.getSamples()) {
            double corrDepth = this.getCorrectedDepth(sample.getDepth());
            if (!(corrDepth > deepestCorrDepth)) continue;
            deepestCorrDepth = corrDepth;
            deepestSample = sample;
        }
        return deepestSample;
    }

    void loadSampleLithology() throws SQLException, SBException {
        String sql = "SELECT samp_id,lith_id,percnt FROM " + this.db.DBTableName("SBSLITH") + " WHERE well_id=" + this.wellID + " ORDER BY samp_id";
        Statement stmt = this.db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        int lastID = 0;
        Sample sample = null;
        while (rs.next()) {
            int lithID;
            int sampID = rs.getInt("samp_id");
            if (sampID != lastID) {
                sample = this.getSample(sampID);
                if (sample == null) {
                    throw new SBException("Cannot find sample: " + sampID + " in loadSampleAges");
                }
                sample.sampleLithology.getLithology().clear();
                lastID = sampID;
            }
            if ((lithID = rs.getInt("lith_id")) == 0) continue;
            SampleLithologyUnit lith = new SampleLithologyUnit(this.db, this.db.getLithdesc().getLithology(lithID), rs.getInt("percnt"));
            sample.sampleLithology.add(lith);
        }
        stmt.close();
    }

    void loadHeader() throws SQLException, SBException {
        if (this.wellID == 0) {
            return;
        }
        this.header.load(this.db, this.wellID);
    }

    public String statusString() {
        return this.header.statusString();
    }

    public String toString() {
        return this.header.toString();
    }

    public void update(String code, WellHeader header) throws SQLException, SBException {
        header.update(this.db);
        this.header.copy(header);
        this.updateCode(code);
        this.notifyObservers(header);
    }

    void updateCode(String newCode) throws SQLException, SBException {
        if ((newCode = newCode.trim()).equals(this.wellCode())) {
            return;
        }
        if (Well.getWellID(this.db, newCode) > 0) {
            throw new SBException("Well of code: '" + newCode + "' already exists");
        }
        if (this.db != null && this.db.isConnected()) {
            Statement stmt = this.db.getDatabase().createStatement();
            String sql = "UPDATE " + this.db.DBTableName("well_ident") + " SET well_code=NULL WHERE well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("wells") + " SET well_code='" + newCode + "' WHERE well_code='" + this.wellCode() + "'";
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("well_ident") + " SET well_code='" + newCode + "' WHERE well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            stmt.close();
            this.db.getDatabase().commit();
        }
        this.header.setWellCode(newCode);
        this.setChanged();
    }

    public boolean hasDisciplineData(char discID) {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            if (!sample.hasDisciplineData(discID)) continue;
            return true;
        }
        return false;
    }

    public String hasSemiQuantData(char discID, String analyst, int analyNo) throws SQLException, SBException {
        AnalystHeader hdr = null;
        if (analyst != null) {
            hdr = this.getAnalystHeader(analyst, discID, analyNo, false);
        }
        return this.hasSemiQuantData(hdr);
    }

    public String hasSemiQuantData(AnalystHeader hdr) throws SQLException, SBException {
        String semiQuant = null;
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            semiQuant = sample.hasSemiQuantData(hdr, semiQuant);
        }
        return semiQuant;
    }

    public boolean hasSampleEnvData(AnalystHeader hdr) {
        Sample sample;
        boolean hasData = false;
        for (int i = 0; i < this.samples.size() && !(hasData = (sample = this.samples.get(i)).hasEnvData(hdr)); ++i) {
        }
        return hasData;
    }

    public List<EnvScheme> getEnvSchemes() throws SQLException, SBException {
        HashSet<EnvScheme> set = new HashSet<EnvScheme>();
        LinkedList<EnvScheme> list = new LinkedList<EnvScheme>();
        this.loadAnalystHeaders();
        for (AnalystHeader hdr : this.analystHeaders) {
            if (!this.hasSampleEnvData(hdr)) continue;
            EnvScheme scheme = this.db.getEnvScheme(hdr.getEnvSchID());
            set.add(scheme);
        }
        for (EnvScheme scheme : set) {
            list.add(scheme);
        }
        return list;
    }

    public void fillTaxonList(List taxa, char discID, int analyst, int analyNo) {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            sample.fillTaxa(taxa, discID, analyst, analyNo);
        }
    }

    public void sortTaxonList(List taxa, char discID, int sort) throws SBException {
        Collections.sort(taxa, new TaxonCompareGenus(new TaxonCompareSpecies()));
        double[] depths = new double[taxa.size()];
        for (int i = 0; i < taxa.size(); ++i) {
            Taxon taxon = (Taxon)taxa.get(i);
            depths[i] = this.getEndSampleDepth(taxon.getSpecID(), discID, sort);
        }
        boolean swap = true;
        block1: while (swap) {
            swap = false;
            for (int i = 1; i < depths.length; ++i) {
                if (!(sort == 0 && depths[i] < depths[i - 1]) && (sort != 1 || !(depths[i] > depths[i - 1]))) continue;
                swap = true;
                double tempDepth = depths[i];
                depths[i] = depths[i - 1];
                depths[i - 1] = tempDepth;
                Taxon tempTaxon = (Taxon)taxa.get(i);
                taxa.remove(i);
                taxa.add(i - 1, tempTaxon);
                continue block1;
            }
        }
    }

    double getEndSampleDepth(int specID, char discID, int sort) throws SBException {
        double depth = 0.0;
        if (sort == 0) {
            for (int i = 0; i < this.samples.size(); ++i) {
                Sample sample = this.samples.get(i);
                if (sample.hasInSituSpecies(discID, specID, 'R')) {
                    depth = sample.getDepth('M');
                    break;
                }
                if (!sample.hasSpecies(discID, specID) || !(depth < (double)0.0029f)) continue;
                depth = sample.getDepth('M');
            }
        } else {
            for (int i = this.samples.size() - 1; i >= 0; --i) {
                Sample sample = this.samples.get(i);
                if (sample.hasInSituSpecies(discID, specID, 'C')) {
                    depth = sample.getDepth('M');
                    break;
                }
                if (!sample.hasSpecies(discID, specID) || !(depth < (double)0.0029f)) continue;
                depth = sample.getDepth('M');
            }
        }
        return depth;
    }

    boolean hasExistingData() throws SQLException, SBException {
        for (int i = 0; i < this.interps.size(); ++i) {
            WellInterp interpretation = this.interps.get(i);
            for (int list = 0; list < interpretation.zoneTypes.length; ++list) {
                if (interpretation.zoneTypes[i].size() <= 0 || !interpretation.hasExistingIGDData(WellInterp.zoneType2IGDType(i), this.wellID)) continue;
                return true;
            }
            LinkedList<DiscAnalyst> discAnalystList = new LinkedList<DiscAnalyst>();
            List<Biocom> comments = interpretation.comments;
            for (int iComm = 0; iComm < comments.size(); ++iComm) {
                Biocom comment = comments.get(iComm);
                DiscAnalyst discAnalyst = new DiscAnalyst(comment.getDiscID(), comment.getAnalyst());
                if (discAnalystList.contains(discAnalyst)) continue;
                discAnalystList.add(discAnalyst);
            }
            for (DiscAnalyst discAnalyst : discAnalystList) {
                if (!interpretation.hasExistingBiocomData(discAnalyst, this.wellID)) continue;
                return true;
            }
            if (interpretation.envs.size() <= 0 || !interpretation.hasExistingEnvData(this.wellID)) continue;
            return true;
        }
        LinkedList<DiscAnalyst> discAnalystList = new LinkedList<DiscAnalyst>();
        for (Sample sample : this.samples) {
            for (Smpdtl smpdtl : sample.analyses) {
                DiscAnalyst discAnalyst;
                discAnalyst = new DiscAnalyst(smpdtl.getDiscID(), this.db.getUser(smpdtl.getAnalyst()).getUsrID());
                if (discAnalystList.contains(discAnalyst)) continue;
                discAnalystList.add(discAnalyst);
            }
        }
        for (DiscAnalyst discAnalyst : discAnalystList) {
            if (!this.hasExistingAnalyses(discAnalyst)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    void deleteExistingData() throws SQLException, SBException {
        for (int i = 0; i < this.interps.size(); ++i) {
            WellInterp interpretation = this.interps.get(i);
            for (int list = 0; list < interpretation.zoneTypes.length; ++list) {
                if (interpretation.zoneTypes[i].size() <= 0) continue;
                interpretation.deleteExistingIGDData(WellInterp.zoneType2IGDType(i), this.wellID);
            }
            LinkedList<DiscAnalyst> discAnalystList = new LinkedList<DiscAnalyst>();
            List<Biocom> comments = interpretation.comments;
            for (int iComm = 0; iComm < comments.size(); ++iComm) {
                Biocom comment = comments.get(iComm);
                DiscAnalyst discAnalyst = new DiscAnalyst(comment.getDiscID(), comment.getAnalyst());
                if (discAnalystList.contains(discAnalyst)) continue;
                discAnalystList.add(discAnalyst);
            }
            for (DiscAnalyst discAnalyst : discAnalystList) {
                interpretation.deleteExistingBiocomData(discAnalyst, this.wellID);
            }
            if (interpretation.envs.size() <= 0) continue;
            interpretation.deleteExistingEnvData(this.wellID);
        }
        LinkedList<DiscAnalyst> discAnalystList = new LinkedList<DiscAnalyst>();
        for (Sample sample : this.samples) {
            for (Smpdtl smpdtl : sample.analyses) {
                DiscAnalyst discAnalyst;
                discAnalyst = new DiscAnalyst(smpdtl.getDiscID(), this.db.getUser(smpdtl.getAnalyst()).getUsrID());
                if (discAnalystList.contains(discAnalyst)) continue;
                discAnalystList.add(discAnalyst);
            }
        }
        for (DiscAnalyst discAnalyst : discAnalystList) {
            this.deleteExistingAnalyses(discAnalyst);
        }
    }

    boolean hasExistingAnalyses(DiscAnalyst discAnalyst) throws SQLException {
        String sql = "SELECT samp_id FROM " + this.db.DBTableName("TAXONOCC") + " WHERE disc_id=" + SB.DBChar((char)discAnalyst.discID);
        sql = sql + " AND analyst='" + discAnalyst.analyst + "' ";
        sql = sql + " AND well_id =" + this.wellID;
        Statement stmt = this.db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    void deleteExistingAnalyses(DiscAnalyst discAnalyst) throws SQLException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.db.DBTableName("TAXONOCC") + " WHERE disc_id=" + SB.DBChar((char)discAnalyst.discID);
        sql = sql + " AND analyst='" + discAnalyst.analyst + "' ";
        sql = sql + " AND well_id =" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "DELETE FROM " + this.db.DBTableName("SMPDTL") + " WHERE disc_id=" + SB.DBChar((char)discAnalyst.discID);
        sql = sql + " AND analyst='" + discAnalyst.analyst + "' ";
        sql = sql + " AND well_id =" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        stmt.close();
    }

    public synchronized void addSample(Statement stmt, Sample sample) throws SBException, SQLException {
        if (stmt == null) {
            throw new SBException("Statement null in Well.addSample");
        }
        Sample.checkOverlap(this.samples, sample, this.getWellUnits());
        String sql = "SELECT max(samp_id) AS noof_samp FROM " + this.db.DBTableName("samples") + " WHERE well_id=" + this.wellID;
        sql = this.db.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        int noofSamp = 0;
        if (rs.next()) {
            noofSamp = rs.getInt("noof_samp");
        }
        rs.close();
        sample.store(stmt, this.wellID, noofSamp);
        Sample.insert(this.samples, sample, this.getWellUnits());
        this.setChanged();
    }

    public Well(SBdb SB2, int wellID, WellHeader header) throws SQLException, SBException {
        this.header = header;
        this.wellID = wellID;
        this.db = SB2;
        this.add(header.getWellCode());
    }

    public Well(SBdb SB2, String wellCode, WellHeader header) throws SQLException, SBException {
        this.header = new WellHeader(header);
        this.db = SB2;
        this.add(wellCode);
    }

    public List<Smpdtl> getAnalyses(char discID, String analyst, int analyNo) throws SQLException, SBException {
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        if (!this.analysesLoaded) {
            this.loadAnalyses();
        }
        for (Sample sample : this.samples) {
            Collections.sort(sample.analyses, new SmpdtlCompare());
            for (Smpdtl smpdtl : sample.analyses) {
                boolean required = true;
                if (discID > '\u0000' && discID != smpdtl.getDiscID()) {
                    required = false;
                }
                if (analyst != null && analyst.length() > 0 && !analyst.equals(smpdtl.getAnalyst())) {
                    required = false;
                }
                if (analyNo > 0 && smpdtl.getAnalyNo() != analyNo) {
                    required = false;
                }
                if (!required) continue;
                smpdtls.add(smpdtl);
            }
        }
        return smpdtls;
    }

    public List<Smpdtl> getAnalyses(Discipline discID, String analyst, int analyNo) throws SQLException, SBException {
        return this.getAnalyses(discID.getChar(), analyst, analyNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refreshAnalyses(Statement stmt) throws SQLException, SBException {
        if (!this.analysesLoaded) {
            return;
        }
        String sql = "SELECT samp_id,analy_id,updated ";
        sql = sql + " FROM " + this.db.DBTableName("SMPDTL") + " WHERE well_id=" + this.wellID + " ORDER BY samp_id";
        sql = this.db.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        Smpdtl notifier = null;
        HashSet<String> keys = new HashSet<String>();
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            int analyID = rs.getInt("analy_id");
            keys.add("" + sampID + "|" + analyID);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Sample o : this.samples) {
                if (o.getSampID() != sampID) continue;
                for (Smpdtl d : o.getAnalyses()) {
                    if (d.getAnalyID() != analyID) continue;
                    found = true;
                    if (time == null || !time.after(d.getUpdated())) break;
                    Smpdtl smpdtl = new Smpdtl(this.db, this.wellID, o, this.getAnalystHeader(analyID, true));
                    d.copyAll(smpdtl);
                    d.copyOccs(smpdtl);
                    notifier = d;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) continue;
            Sample sample = this.getSample(sampID);
            Smpdtl smpdtl = new Smpdtl(this.db, this.wellID, sample, this.getAnalystHeader(analyID, true));
            sample.insert(smpdtl);
            notifier = smpdtl;
        }
        for (Sample o : this.samples) {
            for (Smpdtl d : o.getAnalyses()) {
                for (TaxonOcc t : d.getUnsortedOccur()) {
                    if (this.db.hasTaxon(t.getTaxon())) continue;
                    Smpdtl smpdtl = new Smpdtl(this.db, this.wellID, o, this.getAnalystHeader(d.getAnalyID(), true));
                    d.copyAll(smpdtl);
                    d.copyOccs(smpdtl);
                    notifier = d;
                }
            }
        }
        List<Sample> list = this.samples;
        synchronized (list) {
            for (Sample sample : this.samples) {
                for (Smpdtl dtl : sample.getAnalyses()) {
                    if (keys.contains("" + sample.getSampID() + "|" + dtl.getAnalyID())) continue;
                    sample.removeDtl(dtl.getAnalyID());
                    if (notifier != null) continue;
                    notifier = dtl;
                }
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    public void loadAnalyses() throws SQLException, SBException {
        if (this.analysesLoaded) {
            return;
        }
        this.getSamples();
        if (this.db == null || !this.db.isConnected()) {
            return;
        }
        System.out.println("Loading analyses...");
        PreparedStatement pStmtTaxonOcc = Smpdtl.getLoadPrepStmt(this.db);
        this.db.loadTaxa(this.wellID);
        String sql = "SELECT samp_id,analy_id,picker,source,barren,notes,proximal,distal,fov,weight,coarse,medium,fine," + Audit.sqlFieldString();
        sql = sql + " FROM " + this.db.DBTableName("SMPDTL") + " WHERE well_id=" + this.wellID;
        Statement stmt = this.db.getDatabase().createStatement();
        sql = this.db.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            int analyID = rs.getInt("analy_id");
            String picker = rs.getString("picker");
            String source = rs.getString("source");
            Smpdtl.AnalysisType analysisType = Smpdtl.AnalysisType.getTypeFromDB(rs.getString("barren"));
            String notes = rs.getString("notes");
            int proximal = rs.getInt("proximal");
            int distal = rs.getInt("distal");
            int fov = rs.getInt("fov");
            float weight = rs.getFloat("weight");
            float coarse = rs.getFloat("coarse");
            float medium = rs.getFloat("medium");
            float fine = rs.getFloat("fine");
            Sample sample = this.getSample(sampID);
            if (sample == null) {
                System.out.println("Null sample for sampID =" + sampID + ", wellID=" + this.wellID + " in Well.loadAnalyses");
                continue;
            }
            Smpdtl dtl = new Smpdtl(this.db, sample, this.getAnalystHeader(analyID, true), picker, source, notes, proximal, distal, fov, weight, coarse, medium, fine, new Audit(rs), analysisType);
            dtl.load(this.wellID, pStmtTaxonOcc);
            Iterator<Smpdtl> it = sample.analyses.iterator();
            boolean toAdd = true;
            while (it.hasNext()) {
                Smpdtl analysis = it.next();
                if (analysis.getAnalyID() != analyID) continue;
                String message = "Duplicate analyst for discID: " + analysis.getDiscID() + ", analyst:" + analysis.getAnalyst() + ", sample ID: " + sampID + ", analyID: " + analyID;
                if (dtl.getOccSize() > 0 && analysis.getOccSize() == 0) {
                    System.out.println(message + ", sample details: " + analysis + " removed.");
                    it.remove();
                    break;
                }
                if (dtl.getOccSize() == analysis.getOccSize()) {
                    System.out.println(message + ", sample details: " + dtl + " ignored.");
                    toAdd = false;
                    continue;
                }
                throw new SBException(message + ", analyses have different occurrence records");
            }
            if (!toAdd) continue;
            sample.analyses.add(dtl);
            sample.detailsLoaded[SBdb.did2i((char)this.getAnalystHeader((int)analyID, (boolean)true).getDiscID())] = true;
        }
        rs.close();
        stmt.close();
        pStmtTaxonOcc.close();
        this.analysesLoaded = true;
    }

    void add(String wellCode) throws SQLException, SBException {
        String sql = "SELECT well_code FROM " + this.db.DBTableName("WELL_IDENT") + " WHERE well_code='" + wellCode + "'";
        sql = this.db.modQuery(sql);
        Statement stmt = this.db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            throw new SBException("Well code: '" + wellCode + "' Already exists. Well not saved");
        }
        if (this.wellID == 0) {
            this.wellID = this.db.nextControl("WELL_IDENT", "WELL_ID");
        }
        if (this.wellID == 0) {
            throw new SBException("Cannot get new well ID");
        }
        if (this.header.getCountry() == null || this.header.getCountry().length() == 0) {
            throw new SBException("Country name missing for well: " + wellCode);
        }
        if (this.header.getDescrip() == null || this.header.getDescrip().trim().length() == 0) {
            this.header.setDescrip("Created: " + SB.DBdf.format(new Date()));
        }
        sql = "INSERT INTO " + this.db.DBTableName("WELLS") + " (well_name,well_code,country," + Audit.sqlFieldString() + ") VALUES (" + SB.DBString((String)this.header.getWellName()) + "," + SB.DBString((String)wellCode) + "," + SB.DBString((String)this.header.getCountry()) + "," + this.header.audit.sqlInsert(this.db, stmt) + ")";
        sql = this.db.modQuery(sql);
        stmt.executeUpdate(sql);
        this.header.setWellCode(wellCode);
        this.header.updateFromMaster(this.db, SB.DBdf, true);
        this.header.update(this.db);
        sql = "INSERT INTO " + this.db.DBTableName("WELL_IDENT") + " (well_id,well_code,descrip) VALUES (";
        sql = sql + this.wellID + "," + SB.DBString((String)wellCode) + "," + SB.DBString((String)this.header.getDescrip()) + ")";
        sql = this.db.modQuery(sql);
        stmt.executeUpdate(sql);
        stmt.close();
        this.header.setWellCode(wellCode);
    }

    @Deprecated
    void store(boolean headerOnly, boolean headerAnalysesOnly, Lithdesc lithdesc, List envSchemes, List users) throws SBException, SQLException, Exception {
        int i;
        if (this.header.checkPerm(this.db) != 1) {
            throw new SBException("No privilege to write data for well: " + this.toString());
        }
        if (this.header.getWellCode() == null || this.header.getWellCode().length() == 0) {
            throw new SBException("Well code blank for well: " + this.header.getWellName());
        }
        if (this.wellID == 0) {
            if (this.header.getWellName().trim().length() == 0) {
                throw new SBException("Well name blank for well code: " + this.header.getWellCode());
            }
            this.add(this.header.getWellCode());
        }
        this.header.update(this.db);
        String sql = "UPDATE " + this.db.DBTableName("VERSION") + " SET descrip=" + SB.DBString((String)this.header.getDescrip()) + " WHERE code='" + this.header.getWellCode() + "'";
        Statement stmt = this.db.getDatabase().createStatement();
        stmt.executeUpdate(this.db.modQuery(sql));
        stmt.close();
        if (headerOnly) {
            return;
        }
        sql = "SELECT noof_samp FROM " + this.db.DBTableName("version") + " WHERE well_id=" + this.wellID;
        sql = this.db.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        int noofSamp = 0;
        if (rs.next()) {
            noofSamp = rs.getInt("noof_samp");
        }
        rs.close();
        for (i = 0; i < this.samples.size(); ++i) {
            Smpdtl smpdtl;
            int j;
            Sample sample = this.samples.get(i);
            Sample existingSample = this.getSample(sample.getTopDepth(), sample.getBaseDepth(), sample.getType(), false);
            if (existingSample == null) {
                noofSamp = sample.store(null, this.wellID, noofSamp);
                continue;
            }
            for (j = 0; j < sample.analyses.size(); ++j) {
                smpdtl = sample.analyses.get(j);
                if (smpdtl.status != Smpdtl.NOTSTORED && smpdtl.status != Smpdtl.PARTSTORED) continue;
                if (users == null) {
                    throw new SBException("Usrid list null in Well.store()");
                }
                if (Userdef.checkUsrid(users, smpdtl.getAnalyst())) continue;
                throw new SBException("Cannot save sample with unkown analyst: " + smpdtl.getAnalyst() + "\n(Use Match | Analyst)");
            }
            if (existingSample.getSampID() == 0) {
                noofSamp = existingSample.store(null, this.wellID, noofSamp);
            } else if (sample.getSampID() > 0) {
                for (j = 0; j < sample.analyses.size(); ++j) {
                    smpdtl = sample.analyses.get(j);
                    if (smpdtl.status != Smpdtl.NOTSTORED && smpdtl.status != Smpdtl.PARTSTORED) continue;
                    AnalystHeader hdr = this.getAnalystHeader(this.wellID, true);
                    smpdtl.store(null, this.wellID, sample.getSampID(), hdr.getAnalyID());
                }
            }
            if (sample.getSampID() == existingSample.getSampID()) continue;
            throw new SBException("Duplicate samples found");
        }
        this.storeAbn(stmt, '\u0000');
        stmt.close();
        if (headerAnalysesOnly) {
            return;
        }
        for (i = 0; i < this.interps.size(); ++i) {
            this.interps.get(i).store(this.wellID);
        }
        try {
            for (int i2 = 0; i2 < this.lithIntervals.size(); ++i2) {
                LithInterval lith = (LithInterval)this.lithIntervals.get(i2);
                lith.store(this.db, this.wellID);
            }
        }
        catch (SQLException se) {
            // empty catch block
        }
        this.cores.store(this.wellID);
        this.casing.store(this.wellID);
        this.markers.store(this.wellID);
        this.TVD.store(this.wellID);
        this.TWT.store(this.wellID);
    }

    @Deprecated
    public boolean checkAbnScheme(AbnScheme scheme, char discID) throws SQLException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "SELECT DISTINCT (abund) FROM " + this.db.DBTableName("TAXONOCC") + " WHERE well_id=" + this.wellID + " AND disc_id='" + discID + "'";
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        while (rs.next()) {
            String subjAbund = rs.getString("abund");
            if (subjAbund == null || subjAbund.length() <= 0 || scheme.getIndex(subjAbund) >= 0) continue;
            stmt.close();
            System.out.println("Well subj abund trapped: " + subjAbund);
            return false;
        }
        stmt.close();
        return true;
    }

    public int updateSubjAbund(String donor, String target, int analyID) throws SQLException, SBException {
        int nUpdated = 0;
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "UPDATE " + this.db.DBTableName("TAXONOCC") + " SET abund=" + SB.DBString((String)target) + " WHERE well_id=" + this.wellID + " AND analy_id=" + analyID;
        sql = sql + " AND abund=" + SB.DBString((String)donor);
        nUpdated = stmt.executeUpdate(this.db.modQuery(sql));
        stmt.close();
        for (Sample sample : this.samples) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (smpdtl.getAnalyID() != analyID) continue;
                smpdtl.replaceSubjAbund(donor, target);
                if (!smpdtl.hasChanged()) continue;
                smpdtl.notifyObservers();
            }
        }
        return nUpdated;
    }

    @Deprecated
    void storeAbn(Statement stmt, char discID) throws SQLException, SBException {
        throw new SBException("Attempt to use StoreAbn");
    }

    void saveSample(Sample sample) throws SQLException, SBException, FileNotFoundException, IOException {
        if (this.samples == null) {
            throw new SBException("Attempt to save sample when not all samples loaded for well - can produce duplicates");
        }
        if (sample.status == Sample.STORED) {
            return;
        }
        String sql = "SELECT max(samp_id) AS noof_samp FROM " + this.db.DBTableName("samples") + " WHERE well_id=" + this.wellID;
        Statement stmt = this.db.getDatabase().createStatement();
        sql = this.db.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        int noofSamp = 0;
        if (rs.next()) {
            noofSamp = rs.getInt("noof_samp");
        }
        ++noofSamp;
        rs.close();
        noofSamp = sample.store(null, this.wellID, noofSamp);
    }

    void loadLithIntervals(List<LithBase> lithology, Lithdesc lithdesc) throws SQLException {
        if (this.db != null && this.db.isConnected()) {
            Statement stmt = this.db.getDatabase().createStatement();
            String sql = "SELECT top_depth,base_depth,lith_id FROM " + this.db.DBTableName("SBILITH") + " WHERE well_id=" + this.wellID + " ORDER BY top_depth";
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                LithInterval lithInt = new LithInterval(this.db);
                lithInt.topDepth = rs.getDouble("top_depth");
                lithInt.baseDepth = rs.getDouble("base_depth");
                lithInt.desc = lithdesc.getLithology(rs.getInt("lith_id"));
                assert (lithInt.desc != null);
                lithInt.status = SbugsStatus.STORED;
                this.insertLithInterval(lithInt);
            }
            stmt.close();
        }
    }

    void loadLithQualifiers(List<LithBase> lithology, Lithdesc lithdesc) throws SQLException {
        if (this.db != null && this.db.isConnected()) {
            Statement stmt = this.db.getDatabase().createStatement();
            String sql = "SELECT top_depth,type,alignment,plotpos,lith_id FROM " + this.db.DBTableName("SBQLITH") + " WHERE well_id=" + this.wellID + " ORDER BY top_depth";
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                LithQualifier lithQual = new LithQualifier(this.db);
                lithQual.topDepth = rs.getDouble("top_depth");
                lithQual.qType = rs.getString("type").charAt(0);
                lithQual.alignment = rs.getString("alignment").charAt(0);
                lithQual.xPlotPos = rs.getFloat("plotpos");
                int lithCode = rs.getInt("lith_id");
                if (lithCode != 0) {
                    lithQual.desc = lithdesc.getLithology(lithCode);
                }
                this.insertLithInterval(lithQual);
            }
            stmt.close();
        }
    }

    static int getWellID(SBdb SB2, String code) throws SQLException, SBException {
        if (SB2 != null && SB2.isConnected()) {
            String sql = "SELECT well_id FROM " + SB2.DBTableName("WELL_IDENT") + " WHERE well_code='" + code + "'";
            sql = SB2.modQuery(sql);
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int id = 0;
            if (rs.next()) {
                id = rs.getInt("well_id");
            }
            return id;
        }
        Iterator<Well> it = SB2.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            if (!well.getWellCode().equalsIgnoreCase(code)) continue;
            return well.getWellID();
        }
        return 0;
    }

    static int getWellIDFromName(SBdb SB2, String name) throws SQLException, SBException {
        String sql = "SELECT well_id FROM " + SB2.DBTableName("WELL_IDENT") + " v, " + SB2.DBTableName("WELLS") + " w WHERE w.well_name=" + SB.DBString((String)name) + " AND w.well_code=v.well_code";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int id = 0;
        boolean first = true;
        while (rs.next()) {
            id = rs.getInt("well_id");
            if (first) {
                first = false;
                continue;
            }
            throw new SBException("Cannot get well ID for well: " + name + ". More than one well with ID exists");
        }
        return id;
    }

    static int getWellIDFromNameCountry(SBdb SB2, String name, String iCountry) throws SQLException, SBException {
        String sql = "SELECT well_id FROM " + SB2.DBTableName("WELL_IDENT") + " v, " + SB2.DBTableName("WELLS") + " w WHERE w.well_name=" + SB.DBString((String)name) + " AND w.well_code=v.well_code AND w.country=" + SB.DBString((String)iCountry);
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int id = 0;
        boolean first = true;
        while (rs.next()) {
            id = rs.getInt("well_id");
            if (first) {
                first = false;
                continue;
            }
            throw new SBException("Cannot get well ID for well: " + name + ",country: " + iCountry + ". More than one well with ID exists");
        }
        return id;
    }

    void delete() throws SQLException, SBException {
        if (this.header.checkPerm(this.db) != 1) {
            throw new SBException("No privilege to write data for well: " + this.toString());
        }
        if (this.wellID != 0) {
            Well.deleteWell(this.db, this.wellCode());
        }
    }

    public void storeGrainSize(GrainSizeList list) throws SQLException {
        list.store(this.db, this.wellID);
        this.grainSize.clear();
        this.grainSize.addAll(list);
        this.setChanged();
    }

    public void storeLithology(List<LithBase> newList) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.db.DBTableName("SBILITH") + " WHERE well_id=" + this.wellID;
        Statement stmt = this.db.getDatabase().createStatement();
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "DELETE FROM " + this.db.DBTableName("SBQLITH") + " WHERE well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        stmt.close();
        this.lithIntervals.clear();
        for (LithBase lithBase : newList) {
            LithBase copy = null;
            if (lithBase instanceof LithInterval) {
                copy = new LithInterval(this.db, this.wellID, (LithInterval)lithBase);
            } else if (lithBase instanceof LithQualifier) {
                copy = new LithQualifier(this.db, this.wellID, (LithQualifier)lithBase);
            }
            assert (copy != null);
            this.lithIntervals.add(copy);
        }
        this.setChanged();
    }

    boolean sampleLoaded(Sample sample) {
        for (int i = 0; i < this.interps.size(); ++i) {
            WellInterp interpretation = this.interps.get(i);
            for (int list = 0; list < interpretation.zoneTypes.length; ++list) {
                List igdList = interpretation.zoneTypes[list];
                for (int iZone = 0; iZone < igdList.size(); ++iZone) {
                    IGDIntervalZone zone = (IGDIntervalZone)igdList.get(iZone);
                    if (zone.getTopSample() == sample) {
                        return true;
                    }
                    if (zone.getBaseSample() != sample) continue;
                    return true;
                }
            }
            List<Biocom> comments = interpretation.comments;
            for (int iComm = 0; iComm < comments.size(); ++iComm) {
                Biocom comment = comments.get(iComm);
                if (comment.getTopSample() != sample && comment.getBaseSample() != sample) continue;
                return true;
            }
            for (int iEnv = 0; iEnv < interpretation.envs.size(); ++iEnv) {
                IGDIntervalEnv env = interpretation.envs.get(iEnv);
                if (env.getTopSample() != sample && env.getBaseSample() != sample) continue;
                return true;
            }
        }
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = this.interps.get(ni);
            List<WellEvent> events = in.events;
            for (int iEvent = 0; iEvent < events.size(); ++iEvent) {
                WellEvent event = events.get(iEvent);
                if (event.getSample() != sample) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getAnalysts(char discID) throws SQLException, SBException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "SELECT distinct (analyst) FROM " + this.db.DBTableName("ANALY_HDR") + " WHERE disc_id='" + discID + "' AND well_id=" + this.wellID;
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            list.add(this.db.getUser(rs.getInt("analyst")).getAbr());
        }
        return list;
    }

    void writeDEX(FileWriter out, String eol, boolean fullHeader, SimpleDateFormat df, List dataTypes, char units) throws IOException, SQLException, SBException {
        Iterator en2 = dataTypes.iterator();
        boolean wantCores = false;
        boolean wantCasing = false;
        boolean wantLithology = false;
        boolean wantMarkers = false;
        boolean wantTVD = false;
        boolean wantTWT = false;
        this.header.writeDEX(out, eol, fullHeader, df, units);
        while (en2.hasNext()) {
            int columnType = (Integer)en2.next();
            char discID = '\u0000';
            switch (columnType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    discID = SBdb.dt2discID(columnType);
                    break;
                }
                case 19: {
                    wantCores = true;
                    break;
                }
                case 20: {
                    wantCasing = true;
                    break;
                }
                case 24: {
                    wantMarkers = true;
                    break;
                }
                case 21: {
                    wantLithology = true;
                    break;
                }
                case 25: {
                    wantTVD = true;
                    break;
                }
                case 26: {
                    wantTWT = true;
                    break;
                }
            }
            if (discID <= '\u0000') continue;
            Iterator<AnalystHeader> itra = this.getAnalystHeaderIterator();
            int[] abnDiscID = new int[4];
            for (int i = 0; i < 4; ++i) {
                abnDiscID[i] = 0;
            }
            while (itra.hasNext()) {
                AnalystHeader h = itra.next();
                if (h.getAbnSchID() <= 0 || h.getDiscID() != discID || abnDiscID[SBdb.did2i(discID)] == h.getAbnSchID()) continue;
                if (abnDiscID[SBdb.did2i(discID)] > 0) {
                    throw new SBException("Cannot export multiple analysts with different Abundance Schemes to DEX file");
                }
                out.write("Abundance scheme ID = ");
                out.write("" + h.getAbnSchID());
                out.write(eol + "  Discipline : " + discID + eol);
                abnDiscID[SBdb.did2i((char)discID)] = h.getAbnSchID();
            }
        }
        out.write(eol);
        if (wantCores) {
            this.cores.writeDEX(out, eol, units, this);
        }
        if (wantCasing) {
            this.casing.writeDEX(out, eol, units);
        }
        if (wantMarkers) {
            this.markers.writeDEX(out, eol, units);
        }
        if (wantTVD) {
            this.TVD.writeDEX(out, eol, units);
        }
        if (wantTWT) {
            this.TWT.writeDEX(out, eol, units);
        }
        if (wantLithology) {
            for (LithBase zone : this.lithIntervals) {
                zone.writeDEX(out, eol, units);
            }
        }
    }

    void writeSbugsSamples(FileWriter out, char discID) throws IOException, SQLException, SBException {
        out.write("SAMPLES\n");
        for (Sample sample : this.getSamples()) {
            sample.writeSbugs(out, discID);
        }
    }

    void writeText(FileWriter out, int dType, char delim, char units) throws IOException, SBException {
        DecimalFormat nFormat = new DecimalFormat("#####0.0##");
        switch (dType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                for (int ni = 0; ni < this.interps.size(); ++ni) {
                    WellInterp in = this.interps.get(ni);
                    List<IGDIntervalZone> vect = in.getIGDList(IGDInterval.dType2IGDtype(dType), 0);
                    if (vect.size() <= 0) continue;
                    for (int i = 0; i < vect.size(); ++i) {
                        IGDIntervalZone zone = vect.get(i);
                        out.write(this.header.getWellName() + delim + nFormat.format(zone.getTopSample().getDepth(units)) + delim + zone.getTopBnd() + delim + nFormat.format(zone.getBaseSample().getDepth(units)) + delim + zone.getBaseBnd() + delim + zone.toString() + "\r\n");
                    }
                }
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                for (int ni = 0; ni < this.interps.size(); ++ni) {
                    WellInterp in = this.interps.get(ni);
                    List<Biocom> vect = in.comments;
                    if (vect.size() <= 0) continue;
                    for (int i = 0; i < vect.size(); ++i) {
                        Biocom comm = vect.get(i);
                        if (comm.getDiscID() != SBdb.dt2discID(dType)) continue;
                        out.write(this.header.getWellName() + delim + nFormat.format(comm.getTopSample().getDepth(units)) + delim + "-" + delim + nFormat.format(comm.getBaseSample() != null ? comm.getBaseSample().getDepth(units) : comm.getTopSample().getDepth(units)) + delim + "-" + delim + comm.getText().replace('\n', delim).replace('\r', ' ') + "\r\n");
                    }
                }
                break;
            }
            default: {
                throw new SBException("Export for data type: " + SBdb.dTypeNames[dType] + " is not currently supported");
            }
        }
    }

    String stripHydroName() {
        String name = this.header.getWellName();
        if (this.header.getWellName().lastIndexOf("_SUMLOG") > 0) {
            name = this.header.getWellName().substring(0, this.header.getWellName().lastIndexOf("_SUMLOG"));
        }
        if (name.lastIndexOf("/0") > 0) {
            name = name.substring(0, name.lastIndexOf("/0")) + "/" + name.substring(name.lastIndexOf("/0") + 2);
        }
        if (name.lastIndexOf("-0") > 0) {
            name = name.substring(0, name.lastIndexOf("-0")) + "-" + name.substring(name.lastIndexOf("-0") + 2);
        }
        return name;
    }

    void writeHydroText(FileWriter out, int dType) throws IOException, SBException {
        DecimalFormat nFormat = new DecimalFormat("###0.00000");
        char delim = ',';
        switch (dType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                for (int ni = 0; ni < this.interps.size(); ++ni) {
                    WellInterp in = this.interps.get(ni);
                    List<IGDIntervalZone> vect = in.getIGDList(IGDInterval.dType2IGDtype(dType), 0);
                    if (vect.size() <= 0) continue;
                    for (int i = 0; i < vect.size(); ++i) {
                        IGDIntervalZone zone = vect.get(i);
                        out.write(nFormat.format(zone.getTopSample().getDepth('M')) + delim + zone.toString().toUpperCase() + "\r\n");
                    }
                }
                break;
            }
            default: {
                throw new SBException("Hydro export for data type: " + SBdb.dTypeNames[dType] + " is not currently supported");
            }
        }
    }

    void refreshDataRange(int dType, DTMonitor monitor) throws SQLException, SBException {
        monitor.setStatus(DTMonitor.UNKNOWN);
        switch (dType) {
            case 1: {
                this.refreshSampleRange(monitor);
                break;
            }
            case 22: {
                this.refreshSampleLithologyRange(monitor);
                break;
            }
            case 8: {
                this.refreshOccRange('A', monitor);
                break;
            }
            case 2: {
                this.refreshOccRange('M', monitor);
                break;
            }
            case 4: {
                this.refreshOccRange('N', monitor);
                break;
            }
            case 6: {
                this.refreshOccRange('P', monitor);
                break;
            }
            case 21: {
                this.refreshLithologyRange(monitor);
                break;
            }
            case 19: {
                this.refreshCoreRange(monitor);
                break;
            }
            case 20: {
                this.refreshCasingRange(monitor);
                break;
            }
            case 24: {
                this.refreshMarkersRange(monitor);
                break;
            }
            case 25: {
                this.refreshTVDRange(monitor);
                break;
            }
            case 26: {
                this.refreshTWTRange(monitor);
                break;
            }
            case 23: {
                break;
            }
            default: {
                throw new SBException("No status for data type: " + dType);
            }
        }
        if (monitor.getDepthFrom() > 99990.0 && monitor.getDepthTo() < -99990.0) {
            monitor.setDepthFrom(0.0);
            monitor.setDepthTo(0.0);
            monitor.setHasData(false);
        }
    }

    void refreshSampleRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean depthAssigned = false;
        if (this.samples != null) {
            for (Sample sample : this.getSamples()) {
                try {
                    if (sample.getBaseDepth() != null) {
                        double baseDepth = sample.getBaseDepth();
                        if (baseDepth < monitor.getDepthFrom()) {
                            monitor.setDepthFrom(baseDepth);
                        }
                        if (baseDepth > monitor.getDepthTo()) {
                            monitor.setDepthTo(baseDepth);
                        }
                    }
                }
                catch (SBException se) {
                    // empty catch block
                }
                try {
                    if (sample.getTopDepth() != null) {
                        double topDepth = sample.getTopDepth();
                        if (topDepth < monitor.getDepthFrom()) {
                            monitor.setDepthFrom(topDepth);
                        }
                        if (topDepth > monitor.getDepthTo()) {
                            monitor.setDepthTo(topDepth);
                        }
                    }
                }
                catch (SBException se) {
                    // empty catch block
                }
                monitor.setHasData(true);
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)sample.status));
            }
        } else if (this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT max(top_depth) as maxtop, max(base_depth) as maxbot, min(top_depth) as mintop, min(base_depth) as minbot FROM " + this.db.DBTableName("samples") + " WHERE well_id=" + this.wellID;
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            monitor.setDepthFrom(99999.0);
            monitor.setDepthTo(-99999.0);
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (rs.next()) {
                monitor.setDataRanges(rs, "maxtop", "maxbot", "mintop", "minbot", this.db.getDBType() == SBdb.DBType.SQLITE);
            }
            stmt.close();
        }
    }

    void refreshSampleLithologyRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        if (this.samples != null) {
            for (Sample sample : this.getSamples()) {
                if (sample.getLithology() == null || sample.getLithology().getLithology().isEmpty()) continue;
                try {
                    if (sample.getBaseDepth() != null) {
                        double baseDepth = sample.getBaseDepth();
                        if (baseDepth < monitor.getDepthFrom()) {
                            monitor.setDepthFrom(baseDepth);
                        }
                        if (baseDepth > monitor.getDepthTo()) {
                            monitor.setDepthTo(baseDepth);
                        }
                    }
                }
                catch (SBException se) {
                    // empty catch block
                }
                try {
                    if (sample.getTopDepth() != null) {
                        double topDepth = sample.getTopDepth();
                        if (topDepth < monitor.getDepthFrom()) {
                            monitor.setDepthFrom(topDepth);
                        }
                        if (topDepth > monitor.getDepthTo()) {
                            monitor.setDepthTo(topDepth);
                        }
                    }
                }
                catch (SBException se) {
                    // empty catch block
                }
                monitor.setHasData(true);
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)sample.getLithology().getStatus()));
            }
        } else if (this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.db.DBTableName("samples") + " s," + this.db.DBTableName("sbslith") + " l " + " WHERE s.well_id=" + this.wellID + " AND s.well_id=l.well_id AND s.samp_id=l.samp_id";
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            monitor.setDepthFrom(99999.0);
            monitor.setDepthTo(-99999.0);
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (rs.next()) {
                monitor.setDataRanges(rs, "maxtop", "maxbot", "minbot", "mintop", this.db.getDBType() == SBdb.DBType.SQLITE);
            }
            stmt.close();
        }
    }

    void refreshLithologyRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        this.getLithIntervals();
        for (int i = 0; i < this.lithIntervals.size(); ++i) {
            LithBase lithInt = this.lithIntervals.get(i);
            hasDataLoaded = true;
            double topDepth = lithInt.topDepth;
            double baseDepth = lithInt instanceof LithInterval ? ((LithInterval)lithInt).baseDepth : topDepth;
            if (topDepth < monitor.getDepthFrom()) {
                monitor.setDepthFrom(topDepth);
            }
            if (baseDepth > monitor.getDepthTo()) {
                monitor.setDepthTo(baseDepth);
            }
            monitor.setHasData(true);
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)lithInt.status));
        }
        if (!hasDataLoaded && this.db != null && this.db.isConnected() && this.wellID > 0) {
            monitor.setHasData(false);
            String sql = "SELECT min(top_depth) as mintop,max(base_depth) as maxbot FROM " + this.db.DBTableName("sbilith") + " b WHERE well_id=" + this.wellID;
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDepthFrom(rs.getDouble("mintop"));
                monitor.setDepthTo(rs.getDouble("maxbot"));
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            }
            sql = "SELECT min(top_depth) as mintop FROM " + this.db.DBTableName("sbqlith") + " b WHERE well_id=" + this.wellID;
            rs = stmt.executeQuery(sql = this.db.modQuery(sql));
            if (rs.next()) {
                double mintop = rs.getDouble("mintop");
                if (mintop < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(mintop);
                }
                if (mintop > monitor.getDepthTo()) {
                    monitor.setDepthTo(mintop);
                }
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            }
            stmt.close();
        }
    }

    void refreshOccRange(char discID, DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        if (this.samples != null) {
            for (Sample sample : this.getSamples()) {
                double topDepth;
                if (!sample.hasDisciplineData(discID)) continue;
                double baseDepth = sample.getBaseDepth() != null ? sample.getBaseDepth().doubleValue() : sample.getDepth();
                double d = topDepth = sample.getTopDepth() != null ? sample.getTopDepth().doubleValue() : sample.getDepth();
                if (baseDepth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(baseDepth);
                }
                if (baseDepth > monitor.getDepthTo()) {
                    monitor.setDepthTo(baseDepth);
                }
                if (topDepth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(topDepth);
                }
                if (topDepth > monitor.getDepthTo()) {
                    monitor.setDepthTo(topDepth);
                }
                monitor.setHasData(true);
            }
        } else if (this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.db.DBTableName("samples") + " s," + this.db.DBTableName("smpdtl") + " d, " + this.db.DBTableName("analy_hdr") + " h " + " WHERE s.well_id=" + this.wellID + " AND s.samp_id=d.samp_id AND s.well_id=d.well_id" + " AND h.disc_id='" + discID + "'" + " AND h.analy_id=d.analy_id AND h.well_id=s.well_id";
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDataRanges(rs, "maxtop", "maxbot", "minbot", "mintop", this.db.getDBType() == SBdb.DBType.SQLITE);
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshCoreRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(0.0);
        boolean hasDataLoaded = false;
        this.getCores();
        for (int i = 0; i < this.cores.getSize(); ++i) {
            CoredInterval core = this.cores.getCore(i);
            hasDataLoaded = true;
            double topDepth = core.getTopDepth();
            double baseDepth = core.getBaseDepth();
            if (topDepth < monitor.getDepthFrom()) {
                monitor.setDepthFrom(topDepth);
            }
            if (baseDepth > monitor.getDepthTo()) {
                monitor.setDepthTo(baseDepth);
            }
            monitor.setHasData(true);
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)core.status));
        }
        if (!hasDataLoaded && this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT min(top_depth) as mintop,max(base_depth) as maxbot FROM " + this.db.DBTableName("cores") + " b WHERE well_id=" + this.wellID;
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDepthFrom(rs.getDouble("mintop"));
                monitor.setDepthTo(rs.getDouble("maxbot"));
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshEventsRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = this.interps.get(ni);
            List<WellEvent> list = in.events;
            Iterator<WellEvent> it = in.events.iterator();
            while (it.hasNext()) {
                WellEvent event = it.next();
                if (event.getSample() == null) {
                    System.out.println("Warning: null sample found for event: " + event + " in well: " + this);
                    it.remove();
                    continue;
                }
                hasDataLoaded = true;
                double depth = event.getSample().getDepth('M');
                if (depth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(depth);
                }
                if (depth > monitor.getDepthTo()) {
                    monitor.setDepthTo(depth);
                }
                monitor.setHasData(true);
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)event.status));
            }
        }
        if (!hasDataLoaded && this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.db.DBTableName("samples") + " s," + this.db.DBTableName("events") + " e WHERE s.well_id=" + this.wellID + " and e.well_id=" + this.wellID + " AND s.samp_id=e.samp_id";
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDataRanges(rs, "maxtop", "maxbot", "minbot", "mintop", this.db.getDBType() == SBdb.DBType.SQLITE);
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshLOCRange(DTMonitor monitor) throws SQLException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
    }

    void refreshCasingRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(0.0);
        boolean hasDataLoaded = false;
        this.getCasing();
        for (int i = 0; i < this.casing.getSize(); ++i) {
            CasingPoint casingPoint = this.casing.getCasingPoint(i);
            hasDataLoaded = true;
            double depth = casingPoint.getDepth();
            if (depth < monitor.getDepthFrom()) {
                monitor.setDepthFrom(depth);
            }
            if (depth > monitor.getDepthTo()) {
                monitor.setDepthTo(depth);
            }
            monitor.setHasData(true);
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)casingPoint.status));
        }
        if (!hasDataLoaded && this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT min(depth) as mintop,max(depth) as maxbot FROM " + this.db.DBTableName("casing") + " b WHERE well_id=" + this.wellID;
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDepthFrom(rs.getDouble("mintop"));
                monitor.setDepthTo(rs.getDouble("maxbot"));
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshMarkersRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(0.0);
        boolean hasDataLoaded = false;
        this.getMarkers();
        for (int i = 0; i < this.markers.getSize(); ++i) {
            SeismicMarker marker = this.markers.get(i);
            hasDataLoaded = true;
            double depth = marker.getDepth();
            if (depth < monitor.getDepthFrom()) {
                monitor.setDepthFrom(depth);
            }
            if (depth > monitor.getDepthTo()) {
                monitor.setDepthTo(depth);
            }
            monitor.setHasData(true);
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)marker.status));
        }
        if (!hasDataLoaded && this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT min(depth) as mintop,max(depth) as maxbot FROM " + this.db.DBTableName("wellsmark") + " b WHERE well_id=" + this.wellID;
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDepthFrom(rs.getDouble("mintop"));
                monitor.setDepthTo(rs.getDouble("maxbot"));
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshTVDRange(DTMonitor monitor) throws SQLException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(0.0);
        boolean hasDataLoaded = false;
        this.getTVDlist(false);
        for (int i = 0; i < this.TVD.getSize(); ++i) {
            TVDepth tvd = this.TVD.get(i);
            hasDataLoaded = true;
            double depth = tvd.getDDepth();
            if (depth < monitor.getDepthFrom()) {
                monitor.setDepthFrom(depth);
            }
            if (depth > monitor.getDepthTo()) {
                monitor.setDepthTo(depth);
            }
            monitor.setHasData(true);
            if (this.wellID <= 0) continue;
        }
        monitor.setStatus(this.TVD.getStatus());
        if (!hasDataLoaded && this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT min(ddepth) as mintop,max(ddepth) as maxbot FROM " + this.db.DBTableName("welltvd") + " b WHERE well_id=" + this.wellID;
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDepthFrom(rs.getDouble("mintop"));
                monitor.setDepthTo(rs.getDouble("maxbot"));
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshTWTRange(DTMonitor monitor) throws SQLException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(0.0);
        boolean hasDataLoaded = false;
        this.getTWTlist();
        for (int i = 0; i < this.TWT.getSize(); ++i) {
            TWTDepth twt = this.TWT.get(i);
            hasDataLoaded = true;
            double depth = twt.getDepth();
            if (depth < monitor.getDepthFrom()) {
                monitor.setDepthFrom(depth);
            }
            if (depth > monitor.getDepthTo()) {
                monitor.setDepthTo(depth);
            }
            monitor.setHasData(true);
            if (this.wellID <= 0) continue;
        }
        if (!hasDataLoaded && this.db != null && this.db.isConnected() && this.wellID > 0) {
            String sql = "SELECT min(ddepth) as mintop,max(ddepth) as maxbot FROM " + this.db.DBTableName("welltwt") + " b WHERE well_id" + this.wellID;
            sql = this.db.modQuery(sql);
            Statement stmt = this.db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDepthFrom(rs.getDouble("mintop"));
                monitor.setDepthTo(rs.getDouble("maxbot"));
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    static void deleteWell(SBdb SB2, String wellCode) throws SQLException, SBException {
        if (wellCode.length() == 0) {
            return;
        }
        String sql = "SELECT well_id FROM " + SB2.DBTableName("well_ident") + " WHERE well_code='" + wellCode + "'";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int id = 0;
        if (rs.next()) {
            id = rs.getInt("well_id");
        }
        sql = "DELETE FROM " + SB2.DBTableName("SBSSR") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("BCMMNTS") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "SELECT image_set_id FROM " + SB2.DBTableName("TAXONOCC") + " WHERE well_id=" + id + " AND image_set_id IS NOT NULL";
        rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Integer> setids = new LinkedList<Integer>();
        while (rs.next()) {
            setids.add(rs.getInt("image_set_id"));
        }
        sql = "DELETE FROM " + SB2.DBTableName("TAXONOCC") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        Iterator it = setids.iterator();
        while (it.hasNext()) {
            ImageSet.deleteWithTypeCheck(SB2, (Integer)it.next(), id);
        }
        sql = "DELETE FROM " + SB2.DBTableName("TAXONOCC") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SMPDTL") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IGD") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IGD_ENV") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SQPICK") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("INTCMMNTS") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IGD_HDR") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("LOCNODE") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("LOC") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SBILITH") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SBQLITH") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SBGS") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        if (!SB2.sbwlIsView) {
            sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        sql = "DELETE FROM " + SB2.DBTableName("ANALY_HDR") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IGD_COLMAP") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IGD_HDR") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SBSLITH") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("EVENTS") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SAMPLES") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("CASING") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("CORES") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("CORESHIFT") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        HashSet<Integer> imageDeletions = new HashSet<Integer>();
        sql = "SELECT image_id FROM " + SB2.DBTableName("COREIMAGE") + " WHERE well_id=" + id;
        rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int imageID = rs.getInt("image_id");
            imageDeletions.add(imageID);
        }
        sql = "DELETE FROM " + SB2.DBTableName("COREIMAGE") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        Iterator itr = imageDeletions.iterator();
        while (itr.hasNext()) {
            SB2.deleteImage((Integer)itr.next());
        }
        imageDeletions.clear();
        sql = "DELETE FROM " + SB2.DBTableName("WELLSMARK") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("WELLTVD") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("TVDHDR") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("WELLTWT") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "SELECT curve_id FROM " + SB2.DBTableName("LOG_CURVE") + " WHERE well_id=" + id;
        rs = stmt.executeQuery(SB2.modQuery(sql));
        Statement stmt3 = SB2.getDatabase().createStatement();
        while (rs.next()) {
            int curveID = rs.getInt("curve_id");
            sql = "DELETE FROM " + SB2.DBTableName("LOG_TRACE") + " WHERE curve_id=" + curveID;
            stmt3.executeUpdate(SB2.modQuery(sql));
        }
        sql = "DELETE FROM " + SB2.DBTableName("LOG_CURVE") + " WHERE well_id=" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        if (id > 0) {
            sql = "SELECT chart_id FROM " + SB2.DBTableName("SBCHARTS") + " WHERE well_id=" + id;
            rs = stmt.executeQuery(SB2.modQuery(sql));
            Statement stmt4 = SB2.getDatabase().createStatement();
            while (rs.next()) {
                int chartID = rs.getInt("chart_id");
                sql = "DELETE FROM " + SB2.DBTableName("SBCHCLIN") + " WHERE chart_id =" + chartID;
                stmt4.executeUpdate(SB2.modQuery(sql));
                sql = "DELETE FROM " + SB2.DBTableName("SBCHPANL") + " WHERE chart_id =" + chartID;
                stmt4.executeUpdate(SB2.modQuery(sql));
                sql = "DELETE FROM " + SB2.DBTableName("SBLOGTRC") + " WHERE chart_id =" + chartID;
                stmt4.executeUpdate(SB2.modQuery(sql));
            }
            sql = "DELETE FROM " + SB2.DBTableName("SBCHARTS") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        sql = "DELETE FROM " + SB2.DBTableName("WELL_IDENT") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("WELLS") + " WHERE well_code =" + SB.DBString((String)wellCode);
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    static void loadWellMasterFields(SBdb SB2, List wellMasterFields) throws SQLException {
        if (SB2.hasWellsMaster) {
            DatabaseMetaData meta = SB2.getDatabase().getMetaData();
            String schema = SB2.getSchema();
            ResultSet rs = meta.getColumns(null, schema, "WELLS_MASTER", null);
            while (rs.next()) {
                wellMasterFields.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
        }
    }

    static String getName(SBdb SB2, int wellID) throws SQLException {
        String wellName = null;
        if (wellID > 0) {
            String sql = "SELECT w.well_name FROM " + SB2.DBTableName("WELL_IDENT") + " v, " + SB2.DBTableName("WELLS") + " w " + " WHERE v.well_id=" + wellID + " AND v.well_code=w.well_code";
            sql = SB2.modQuery(sql);
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                wellName = rs.getString("well_name");
            }
            stmt.close();
        }
        return wellName;
    }

    public static String makeCode(String name) {
        String code = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                code = code + c;
                continue;
            }
            if (c == '-' || c == '_') {
                code = code + c;
                continue;
            }
            if (c != '/') continue;
            code = code + "-";
        }
        if ((code = code.toUpperCase()).length() > 25) {
            code = code.substring(0, 24);
            System.out.println("Warning: well code truncated");
        }
        return code;
    }

    public void deleteCoredInterval(CoredInterval coredInterval) throws SQLException, SBException {
        this.cores.delete(this.db, this.wellID, coredInterval);
    }

    public LinkedList<Integer> getAbnSchemeList() throws SQLException, SBException {
        LinkedList<Integer> abnSchemeList = new LinkedList<Integer>();
        Well well = this;
        Iterator<AnalystHeader> itAn = well.getAnalystHeaderIterator();
        while (itAn.hasNext()) {
            AnalystHeader anHdr = itAn.next();
            abnSchemeList.add(anHdr.getAbnSchID());
        }
        return abnSchemeList;
    }

    public LinkedList<Integer> getEnvSchemeList() throws SQLException, SBException {
        LinkedList<Integer> envSchemeList = new LinkedList<Integer>();
        Well well = this;
        Iterator<AnalystHeader> itAn = well.getAnalystHeaderIterator();
        block0: while (itAn.hasNext()) {
            AnalystHeader anHdr = itAn.next();
            for (Smpdtl dtl : this.getAnalyses(anHdr.getDiscID(), anHdr.getAnalyst(), anHdr.getAnalyNumber())) {
                if (dtl.getProximal() <= 0) continue;
                envSchemeList.add(anHdr.getEnvSchID());
                continue block0;
            }
        }
        return envSchemeList;
    }

    public void insertLithInterval(LithInterval newLith) {
        if (this.lithIntervals == null) {
            try {
                this.getLithIntervals();
            }
            catch (Exception e) {
                System.out.println("Exception in add lith interval: " + e.getMessage());
            }
        }
        int insertPoint = 0;
        for (LithBase lith : this.lithIntervals) {
            if (newLith.getSortEntry().compareTo(lith.getSortEntry()) < 0) break;
            ++insertPoint;
        }
        this.lithIntervals.add(insertPoint, newLith);
        this.notifyObservers(newLith);
    }

    void insertLithInterval(LithQualifier newLith) {
        if (this.lithIntervals == null) {
            try {
                this.getLithIntervals();
            }
            catch (Exception e) {
                System.out.println("Exception in add lith interval: " + e.getMessage());
            }
        }
        int insertPoint = 0;
        for (LithBase lith : this.lithIntervals) {
            if (newLith.getSortEntry().compareTo(lith.getSortEntry()) < 0) break;
            ++insertPoint;
        }
        this.lithIntervals.add(insertPoint, newLith);
    }

    public LithBaseEdit deleteLithBase(LithBase lithBase) throws SQLException, SBException {
        LithBaseEdit edit = new LithBaseEdit(lithBase, null);
        edit.doEdit();
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteLithIntervals() throws SQLException {
        String sql = "DELETE FROM " + this.db.DBTableName("SBILITH") + " WHERE well_id=" + this.wellID;
        Statement stmt = this.db.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.lithIntervals.clear();
        this.setChanged();
    }

    public void deleteLithBases(LinkedList<LithBase> bases) throws SQLException {
        boolean connected = this.db.isConnected();
        Statement stmt = null;
        if (connected) {
            stmt = this.db.getDatabase().createStatement();
        }
        for (LithBase base : bases) {
            if (connected) {
                base.delete(this.wellID, stmt);
            }
            if (this.lithIntervals.remove(base)) continue;
            throw new IllegalArgumentException("Attempt to remove lithology which was not in well: " + base);
        }
        if (connected) {
            stmt.close();
        }
        this.setChanged();
    }

    public double getDepth(Sample sample, char units, boolean correctCores, boolean correctCuttings) throws SQLException, SBException {
        if (sample.getType().equals("CU") && correctCuttings || sample.getType().equals("CO") && correctCores) {
            return SB.convFromM((double)this.getCorrectedDepth(sample.getDepth()), (char)units);
        }
        return sample.getDepth(units);
    }

    public double getDepth(Sample sample, boolean correctCores, boolean correctCuttings) throws SQLException {
        if (sample.getType().equals("CU") && correctCuttings || sample.getType().equals("CO") && correctCores) {
            return this.getCorrectedDepth(sample.getDepth());
        }
        return sample.getDepth();
    }

    public double getSampleTopDepth(Sample sample, char units, boolean correctCores, boolean correctCuttings) throws SQLException, SBException {
        if (sample.getType().equals("CU") && correctCuttings || sample.getType().equals("CO") && correctCores) {
            return SB.convFromM((double)this.getCorrectedDepth(sample.getTopDepth()), (char)units);
        }
        return sample.getTopDepth(units);
    }

    public double getSampleBaseDepth(Sample sample, char units, boolean correctCores, boolean correctCuttings) throws SQLException, SBException {
        if (sample.getType().equals("CU") && correctCuttings || sample.getType().equals("CO") && correctCores) {
            return SB.convFromM((double)this.getCorrectedDepth(sample.getBaseDepth()), (char)units);
        }
        return sample.getBaseDepth(units);
    }

    public double getCorrectedDepth(double depth) throws SQLException {
        if (this.header.getType() != 'W') {
            return depth;
        }
        return this.getCoreShift().getCorrectedDepth(depth);
    }

    void storeCasing(SBdb ws, Casing wsCasing) throws SQLException, SBException {
        this.getCasing();
        for (CasingPoint wsCasingPoint : wsCasing.getList()) {
            boolean found = false;
            for (CasingPoint dbCasingPoint : this.casing.getList()) {
                if (!dbCasingPoint.getSortEntry().equals(wsCasingPoint.getSortEntry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.casing.add(new CasingPoint(this.db, ws, this.wellID, wsCasingPoint));
        }
        this.casing.notifyObservers();
    }

    void storeTVD(SBdb ws, TVDList wsTVDList) throws SQLException, SBException {
        this.getTVDlist(false);
        for (TVDepth wsTVDepth : wsTVDList.getList()) {
            boolean found = false;
            for (TVDepth dbTVDepth : this.TVD.getList()) {
                if (!(Math.abs(dbTVDepth.getDDepth() - wsTVDepth.getDDepth()) < (double)0.0029f)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.TVD.add(new TVDepth(wsTVDepth), this.wellID);
        }
    }

    void storeCores(SBdb ws, Cores wsCores) throws SQLException, SBException {
        this.getCores();
        for (CoredInterval wsCore : wsCores.getList()) {
            boolean found = false;
            for (CoredInterval dbCore : this.cores.getList()) {
                if (!dbCore.getSortEntry().equals(wsCore.getSortEntry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.cores.add(new CoredInterval(this.db, ws, this.wellID, wsCore));
        }
        this.cores.notifyObservers();
    }

    void storeCoreshift(SBdb ws, Coreshift wsCoreshift) throws SQLException {
        if (this.coreShift == null) {
            this.coreShift = new Coreshift(this.db, wsCoreshift);
        } else {
            for (int i = 0; i < wsCoreshift.getSize(); ++i) {
                Coreshift.CoreShiftDepth d = wsCoreshift.get(i);
                this.coreShift.add(this.wellID, d.depth, d.shift);
            }
        }
        this.coreShift.store(this.wellID);
    }

    void storeMarkers(SBdb ws, Markers wsMarkers) throws SQLException, SBException {
        this.getMarkers();
        for (int i = 0; i < wsMarkers.getSize(); ++i) {
            SeismicMarker wsMarker = wsMarkers.get(i);
            boolean found = false;
            for (int j = 0; j < this.markers.getSize(); ++j) {
                SeismicMarker dbMarker = this.markers.get(j);
                if (!dbMarker.getSortEntry().equals(wsMarker.getSortEntry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.markers.add(new SeismicMarker(this.db, ws, this.wellID, wsMarker));
        }
        this.markers.notifyObservers();
    }

    void checkLithInterval(LithInterval lithInt) throws InvalidFieldException {
        for (LithBase base : this.lithIntervals) {
            LithInterval i;
            if (!(base instanceof LithInterval) || (i = (LithInterval)base) == lithInt) continue;
            int nzTD = (int)(i.getTopDepth() * 1000.0);
            int nzBD = (int)(i.getBaseDepth() * 1000.0);
            int cTD = (int)(lithInt.getTopDepth() * 1000.0);
            int cBD = (int)(lithInt.getBaseDepth() * 1000.0);
            try {
                SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD);
            }
            catch (SBException sbe) {
                throw new InvalidFieldException(sbe.getMessage() + i);
            }
        }
    }

    void storeLithology(SBdb ws, List<LithBase> wsLiths) throws SQLException, SBException, InvalidFieldException {
        LithBase dbLith;
        int j;
        LithBase wsLith;
        int i;
        this.getLithIntervals();
        LinkedList toAdd = new LinkedList();
        for (i = 0; i < wsLiths.size(); ++i) {
            wsLith = wsLiths.get(i);
            if (wsLith instanceof LithQualifier) continue;
            boolean found = false;
            LithInterval wsLithInterval = (LithInterval)wsLith;
            for (j = 0; j < this.lithIntervals.size(); ++j) {
                dbLith = this.lithIntervals.get(j);
                if (dbLith instanceof LithQualifier || !dbLith.getSortEntry().equals(wsLithInterval.getSortEntry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            try {
                this.checkLithInterval(wsLithInterval);
            }
            catch (InvalidFieldException e) {
                throw new InvalidFieldException("Error storing interval: " + wsLithInterval + ": " + e.getMessage() + "\nCheck for overlapping intervals.");
            }
            this.insertLithInterval(new LithInterval(this.db, this.wellID, wsLithInterval));
        }
        for (i = 0; i < wsLiths.size(); ++i) {
            wsLith = wsLiths.get(i);
            if (!(wsLith instanceof LithQualifier)) continue;
            LithQualifier wsQual = (LithQualifier)wsLith;
            boolean found = false;
            for (j = 0; j < this.lithIntervals.size(); ++j) {
                LithQualifier dbQual;
                dbLith = this.lithIntervals.get(j);
                if (!(dbLith instanceof LithQualifier) || !(dbQual = (LithQualifier)dbLith).getSortEntry().equals(wsQual.getSortEntry()) || dbQual.getLithCode() != wsQual.getLithCode() || dbQual.alignment != wsQual.alignment || dbQual.qType != wsQual.qType || wsQual.xPlotPos != dbQual.xPlotPos) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.insertLithInterval(new LithQualifier(this.db, this.wellID, wsQual));
        }
        if (wsLiths.size() > 0) {
            this.setChanged();
            this.notifyObservers(wsLiths.get(0));
        }
    }

    public Coreshift getCoreShift() throws SQLException {
        if (this.coreShift == null) {
            this.coreShift = new Coreshift(this.db, this.wellID);
        }
        return this.coreShift;
    }

    public String getCoreNumber(double depth) {
        if (this.cores != null) {
            CoredInterval foundCore = null;
            for (CoredInterval core : this.cores.getList()) {
                if (core.getTopDepth() <= depth && core.getBaseDepth() >= depth) {
                    foundCore = core;
                }
                if (!(core.getBaseDepth() > depth)) continue;
                break;
            }
            if (foundCore != null) {
                return foundCore.getCorenum();
            }
        }
        return "";
    }

    void setAnalysesLoaded() {
        this.analysesLoaded = true;
    }

    public Curves getCurves() throws SQLException {
        if (this.curves == null) {
            this.curves = new Curves(this.db, this);
        }
        return this.curves;
    }

    public void setDataChanged() {
        this.setChanged();
    }

    public void mergeSamples(Sample donor, Sample target) throws SQLException, SBException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "INSERT INTO " + this.db.DBTableName("SMPDTL") + " (well_id,samp_id,analy_id,picker,source,barren,fov,weight,coarse,medium,fine,notes,proximal,distal," + Audit.sqlFieldString() + ") SELECT well_id," + target.getSampID() + ",analy_id,picker,source,barren,fov,weight,coarse,medium,fine,notes,proximal,distal," + Audit.sqlFieldString() + " FROM " + this.db.DBTableName("SMPDTL") + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("TAXONOCC") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "DELETE FROM " + this.db.DBTableName("SMPDTL") + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("IGD") + " SET top_id=" + target.getSampID() + " WHERE top_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("IGD") + " SET base_id=" + target.getSampID() + " WHERE base_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("IGD_ENV") + " SET top_id=" + target.getSampID() + " WHERE top_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("IGD_ENV") + " SET base_id=" + target.getSampID() + " WHERE base_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("BCMMNTS") + " SET usamp_id=" + target.getSampID() + " WHERE usamp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("BCMMNTS") + " SET lsamp_id=" + target.getSampID() + " WHERE lsamp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("EVENTS") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("SQPICK") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("FAULTS") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("SBSLITH") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("SBSSR") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        stmt.close();
        donor.delete(this.wellID);
        target.mergeAnalyses(donor);
        this.samples.remove(donor);
        for (WellInterp wellInterp : this.interps) {
            wellInterp.mergeSamples(donor, target);
        }
        this.setChanged();
    }

    public String mergeSampleCheckConflicts(Sample sample1, Sample sample2) throws SQLException {
        Statement stmt = this.db.getDatabase().createStatement();
        String table = this.db.DBTableName("SMPDTL");
        String sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1.getSampID() + " AND d2.samp_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id " + " AND d1.analy_id=d2.analy_id";
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            return "Both samples contain analyses from the same suite";
        }
        table = this.db.DBTableName("IGD");
        sql = "SELECT d1.top_id, d1.igd_type, d1.sch_id AS sch_id1, d2.sch_id AS sch_id2 FROM " + table + " d1," + table + " d2 WHERE d1.top_id=" + sample1.getSampID() + " AND d2.top_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id " + " AND d1.igd_type=d2.igd_type" + " AND d1.interp_id=d2.interp_id";
        rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            int igdType = rs.getInt("igd_type");
            int schID1 = rs.getInt("sch_id1");
            int schID2 = rs.getInt("sch_id2");
            if (igdType != 4) {
                return "Both samples contain " + IGDInterval.getIGDName(igdType) + " intervals";
            }
            if (schID1 == schID2) {
                return "Both samples contain biozone intervals of the same scheme.";
            }
        }
        table = this.db.DBTableName("IGD_ENV");
        sql = "SELECT d1.top_id FROM " + table + " d1," + table + " d2 WHERE d1.top_id=" + sample1.getSampID() + " AND d2.top_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.interp_id=d2.interp_id" + " AND d1.well_id=d2.well_id ";
        rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            return "Both samples contain palaeoenvironments of the same type";
        }
        table = this.db.DBTableName("BCMMNTS");
        sql = "SELECT d1.usamp_id FROM " + table + " d1," + table + " d2 WHERE d1.usamp_id=" + sample1.getSampID() + " AND d2.usamp_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id " + " AND d1.interp_id=d2.interp_id" + " AND d1.analyst=d2.analyst";
        rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            return "Both samples contain comments of the same analyst";
        }
        table = this.db.DBTableName("EVENTS");
        sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1.getSampID() + " AND d2.samp_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id " + " AND d1.interp_id=d2.interp_id" + " AND d1.ev_id=d2.ev_id";
        rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            return "Both samples contain the same events";
        }
        table = this.db.DBTableName("FAULTS");
        sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1.getSampID() + " AND d2.samp_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id " + " AND d1.interp_id=d2.interp_id";
        rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            return "Both samples contain fault data";
        }
        table = this.db.DBTableName("SBSLITH");
        sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1.getSampID() + " AND d2.samp_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id ";
        rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            return "Both samples contain sample lithologies";
        }
        table = this.db.DBTableName("SBSSR");
        sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1.getSampID() + " AND d2.samp_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id ";
        rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            return "Both samples contain sample age data";
        }
        table = this.db.DBTableName("SQPICK");
        sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1.getSampID() + " AND d2.samp_id=" + sample2.getSampID() + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id " + " AND d1.interp_id=d2.interp_id";
        rs = stmt.executeQuery(this.db.modQuery(sql));
        if (rs.next()) {
            return "Both samples contain sequence pick data";
        }
        stmt.close();
        return null;
    }

    public boolean hasDepthData() throws SQLException {
        String[] tables;
        boolean hasDepth = false;
        if (this.db == null || !this.db.isConnected()) {
            return false;
        }
        Statement stmt = this.db.getDatabase().createStatement();
        for (String table : tables = new String[]{"SAMPLES", "CASING", "COREIMAGE", "CORES", "CORESHIFT", "INTCMMNTS", "LOCNODE", "SBGS", "SBILITH", "SBQLITH", "WELLSMARK", "WELLTVD", "WELLTWT"}) {
            String sql = "SELECT well_id FROM " + this.db.DBTableName(table) + " WHERE well_id=" + this.wellID;
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            if (!rs.next()) continue;
            hasDepth = true;
            break;
        }
        stmt.close();
        return hasDepth;
    }

    public void updateDepthUnits() throws SQLException, SBException {
        boolean hasDepth = false;
        Statement stmt = this.db.getDatabase().createStatement();
        int rows = 0;
        String factor = this.header.getWellUnits() == 'F' ? "/" : "*";
        factor = factor + "0.3048";
        String[] tables = new String[]{"SAMPLES", "CASING", "COREIMAGE", "CORES", "CORESHIFT", "INTCMMNTS", "LOCNODE", "SBGS", "SBILITH", "SBQLITH", "WELLSMARK", "WELLTVD", "WELLTWT"};
        String sql = "UPDATE " + this.db.DBTableName("samples") + " SET top_depth=top_depth" + factor + ", base_depth=base_depth" + factor + "," + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
        rows = stmt.executeUpdate(this.db.modQuery(sql));
        if (rows > 0) {
            this.refreshSamples(stmt);
        }
        sql = "UPDATE " + this.db.DBTableName("cores") + " SET top_depth=top_depth" + factor + ", base_depth=base_depth" + factor + "," + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
        rows = stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("coreimage") + " SET top_depth=top_depth" + factor + ", base_depth=base_depth" + factor + " WHERE well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("coreshift") + " SET depth=depth" + factor + " WHERE well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        if (rows > 0) {
            this.refreshCores(stmt);
        }
        boolean interpRefresh = false;
        sql = "UPDATE " + this.db.DBTableName("intcmmnts") + " SET top_depth=top_depth" + factor + ", base_depth=base_depth" + factor + "," + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
        rows = stmt.executeUpdate(this.db.modQuery(sql));
        if (rows > 0) {
            interpRefresh = true;
        }
        if ((rows = stmt.executeUpdate(this.db.modQuery(sql = "UPDATE " + this.db.DBTableName("locnode") + " SET depth=depth" + factor + " WHERE well_id=" + this.wellID))) > 0) {
            sql = "UPDATE " + this.db.DBTableName("loc") + " SET " + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
            rows = stmt.executeUpdate(this.db.modQuery(sql));
            interpRefresh = true;
        }
        this.lithIntervals = null;
        sql = "UPDATE " + this.db.DBTableName("sbgs") + " SET depth=depth" + factor + " WHERE well_id=" + this.wellID;
        rows = stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("sbilith") + " SET top_depth=top_depth" + factor + ", base_depth=base_depth" + factor + " WHERE well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("sbqlith") + " SET top_depth=top_depth" + factor + " WHERE well_id=" + this.wellID;
        stmt.executeUpdate(this.db.modQuery(sql));
        sql = "UPDATE " + this.db.DBTableName("wellsmark") + " SET depth=depth" + factor + "," + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
        rows = stmt.executeUpdate(this.db.modQuery(sql));
        if (rows > 0) {
            this.refreshMarkers(stmt);
        }
        if ((rows = stmt.executeUpdate(this.db.modQuery(sql = "UPDATE " + this.db.DBTableName("welltvd") + " SET ddepth=ddepth" + factor + ",tvdepth=tvdepth" + factor + ",incrvs=incrvs" + factor + " WHERE well_id=" + this.wellID))) > 0) {
            this.TVD = null;
            this.TVDplan = null;
        }
        if ((rows = stmt.executeUpdate(this.db.modQuery(sql = "UPDATE " + this.db.DBTableName("welltwt") + " SET ddepth=ddepth" + factor + " WHERE well_id=" + this.wellID))) > 0) {
            this.TWT = null;
        }
        if (interpRefresh) {
            for (WellInterp wellInterp : this.interps) {
                wellInterp.refresh(stmt, this);
                wellInterp.loc = null;
            }
        }
        stmt.close();
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for well: " + this);
        }
        this.header.audit.setAnalyst(analyst.getUsrID());
    }

    public SbugsCompoundEdit addLithInterval(LithBase.Builder b) throws SBException, SQLException {
        assert (b != null);
        LithBase base = null;
        if (b instanceof LithInterval.Builder) {
            double snapScale;
            LithInterval.Builder builder = (LithInterval.Builder)b;
            double nearestTop = snapScale = Math.min(0.5, builder.getBaseDepth() - builder.getTopDepth());
            double nearestBase = snapScale;
            double origTop = b.getTopDepth();
            double origBase = builder.getBaseDepth();
            for (LithBase l : this.lithIntervals) {
                if (!(l instanceof LithInterval)) continue;
                LithInterval existing = (LithInterval)l;
                if (Math.abs(existing.getTopDepth() - origBase) < nearestTop && existing.getTopDepth() - builder.getBaseDepth() < -snapScale && existing.getTopDepth() > builder.getBaseDepth()) {
                    builder = new LithInterval.Builder(this.db, builder.getTopDepth(), builder.getLithology(), existing.getTopDepth());
                    nearestTop = Math.abs(existing.getTopDepth() - origBase);
                }
                if (!(Math.abs(existing.getBaseDepth() - builder.getTopDepth()) < nearestBase) || !(existing.getBaseDepth() - builder.getTopDepth() < snapScale) || !(existing.getBaseDepth() < builder.getTopDepth())) continue;
                builder = new LithInterval.Builder(this.db, existing.getBaseDepth(), builder.getLithology(), builder.getBaseDepth());
                nearestBase = Math.abs(existing.getBaseDepth() - origTop);
            }
            LithInterval interval = builder.build();
            base = interval;
            try {
                this.checkLithInterval(interval);
            }
            catch (InvalidFieldException e) {
                throw new SBException(e.getMessage());
            }
            LithInterval above = null;
            LithInterval below = null;
            for (LithBase l : this.lithIntervals) {
                if (!(l instanceof LithInterval)) continue;
                LithInterval lith = (LithInterval)l;
                if (lith.isNeighbourAbove(interval) && lith.getLithCode() == interval.getLithCode()) {
                    above = lith;
                }
                if (!lith.isNeighbourBelow(interval) || lith.getLithCode() != interval.getLithCode()) continue;
                below = lith;
            }
            SbugsCompoundEdit edit = new SbugsCompoundEdit("Add lithology interval: " + base.getLithology().getDescr());
            if (above != null ^ below != null) {
                if (above != null) {
                    edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(above, new LithInterval.Builder(this.db, above.getTopDepth(), above.getLithology(), interval.getBaseDepth()).build())));
                }
                if (below != null) {
                    edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(below, new LithInterval.Builder(this.db, interval.getTopDepth(), base.getLithology(), below.getBaseDepth()).build())));
                }
                return edit;
            }
            if (above != null && below != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(below, null)));
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(above, null)));
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(null, new LithInterval.Builder(this.db, above.getTopDepth(), base.getLithology(), below.getBaseDepth()).build())));
                return edit;
            }
        }
        if (base == null) {
            base = b.build();
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Add lithology interval: " + base.getLithology().getDescr());
        edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(null, base)));
        return edit;
    }

    public AbstractUndoableEdit addLithInterval(Lithology lith, double topDepth, double baseDepth) throws SBException, SQLException {
        assert (!lith.isQual());
        if (topDepth > baseDepth) {
            double temp = baseDepth;
            baseDepth = topDepth;
            topDepth = temp;
        }
        LinkedList<LithInterval> intervals = new LinkedList<LithInterval>();
        for (LithBase l : this.getLithIntervals()) {
            if (!(l instanceof LithInterval)) continue;
            intervals.add((LithInterval)l);
        }
        ListIterator it = intervals.listIterator(0);
        while (it.hasNext()) {
            LithInterval existing = (LithInterval)it.next();
            if (topDepth > existing.getTopDepth() && topDepth < existing.getBaseDepth()) {
                if (it.hasNext() && !(((LithInterval)it.next()).getBaseDepth() > baseDepth)) break;
                topDepth = existing.getBaseDepth();
                break;
            }
            if (!(baseDepth > existing.getTopDepth()) || !(baseDepth < existing.getBaseDepth())) continue;
            it.previous();
            if (it.hasPrevious() && !(((LithInterval)it.previous()).getTopDepth() < topDepth)) break;
            baseDepth = existing.getTopDepth();
            break;
        }
        LithInterval.Builder builder = new LithInterval.Builder(this.db, topDepth, lith, baseDepth);
        SbugsCompoundEdit edit = this.addLithInterval(builder);
        edit.doEdits();
        return edit;
    }

    public AbstractUndoableEdit insertInterval(Lithology lith, double depth) throws SBException, SQLException {
        assert (!lith.isQual());
        LithInterval.Builder builder = null;
        LithInterval lastInterval = null;
        for (LithBase base : this.getLithIntervals()) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval interval = (LithInterval)base;
            if (lastInterval == null) {
                lastInterval = interval;
                continue;
            }
            if (depth > lastInterval.getBaseDepth() && depth < interval.getTopDepth()) {
                builder = new LithInterval.Builder(this.db, lastInterval.getBaseDepth(), lith, interval.getTopDepth());
            }
            lastInterval = interval;
        }
        if (builder == null) {
            return null;
        }
        SbugsCompoundEdit edit = this.addLithInterval(builder);
        edit.doEdits();
        return edit;
    }

    public AbstractUndoableEdit updateLithInterval(LithInterval interval, Lithology newLithology) throws SBException, SQLException {
        assert (newLithology != null && !newLithology.isQual());
        LithBaseEdit deletion = new LithBaseEdit(interval, null);
        deletion.doEdit();
        SbugsCompoundEdit addition = this.addLithInterval(LithInterval.Builder.copyOf(interval, newLithology));
        addition.doEdits();
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Update lithology");
        edit.addEdit((UndoableEdit)((Object)deletion));
        edit.addEdit((UndoableEdit)addition);
        return edit;
    }

    public SbugsCompoundEdit updateLithInterval(double currentDepth, double newDepth) throws SBException, SQLException {
        LithBase above = null;
        LithInterval below = null;
        for (LithBase base : this.lithIntervals) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval lith = (LithInterval)base;
            if (Math.abs(lith.getTopDepth() - currentDepth) < 0.5) {
                below = lith;
            } else if (Math.abs(lith.getBaseDepth() - currentDepth) < 0.5) {
                above = lith;
            }
            if (Math.abs(lith.getTopDepth() - newDepth) < 0.5) {
                newDepth = lith.getTopDepth();
                continue;
            }
            if (!(Math.abs(lith.getBaseDepth() - newDepth) < 0.5)) continue;
            newDepth = lith.getBaseDepth();
        }
        if (above == null && below == null) {
            return null;
        }
        if (above != null && newDepth < above.getTopDepth()) {
            throw new SBException("Cannot update lithology interval boundary: new depth obscures " + above);
        }
        if (below != null && newDepth > below.getBaseDepth()) {
            throw new SBException("Cannot update lithology interval boundary: new depth obscures " + below);
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Edit lithology boundary");
        if (above == null ^ below == null) {
            LithInterval.Builder temp = null;
            if (!(above == null || newDepth > above.getTopDepth() && newDepth < ((LithInterval)above).getBaseDepth())) {
                temp = new LithInterval.Builder(this.db, currentDepth, above.getLithology(), newDepth);
            } else if (!(below == null || newDepth > below.getTopDepth() && newDepth < below.getBaseDepth())) {
                temp = new LithInterval.Builder(this.db, newDepth, below.getLithology(), currentDepth);
            }
            if (temp != null) {
                return this.addLithInterval(temp);
            }
        }
        if (newDepth < currentDepth) {
            if (above != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(above, new LithInterval(this.db, above.getTopDepth(), newDepth, above.getLithology()))));
            }
            if (below != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(below, new LithInterval(this.db, newDepth, below.getBaseDepth(), below.getLithology()))));
            }
        } else {
            if (below != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(below, new LithInterval(this.db, newDepth, below.getBaseDepth(), below.getLithology()))));
            }
            if (above != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(above, new LithInterval(this.db, above.getTopDepth(), newDepth, above.getLithology()))));
            }
        }
        return edit;
    }

    public AbstractUndoableEdit fillLithIntervals(Lithology lithology) throws SBException, SQLException {
        assert (lithology != null);
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Fill lithology intervals with " + lithology.getDescr());
        LithInterval lastLith = null;
        for (LithBase base : this.lithIntervals) {
            if (base instanceof LithQualifier) continue;
            LithInterval interval = (LithInterval)base;
            if (lastLith == null) {
                lastLith = interval;
                continue;
            }
            if (Math.abs(lastLith.getBaseDepth() - interval.getTopDepth()) > 0.1) {
                edit.addEdit((UndoableEdit)this.addLithInterval(new LithInterval.Builder(this.db, lastLith.getBaseDepth(), lithology, interval.getTopDepth())));
            }
            lastLith = interval;
        }
        edit.doEdits();
        return edit;
    }

    class LithBaseEdit
    extends SbugsEdit {
        final LithBase originalLith;
        final LithBase newLith;
        final String presentationName;

        private LithBaseEdit(LithBase originalInterval, LithBase newInterval) {
            this.originalLith = originalInterval;
            this.newLith = newInterval;
            String s = originalInterval != null && newInterval != null ? "update lithology interval" : (originalInterval != null ? "delete lithology (" + originalInterval.toString() + ")" : "new lithology (" + newInterval.toString() + ")");
            this.presentationName = s;
        }

        public void undo() {
            try {
                if (this.newLith != null) {
                    this.deleteAction(this.newLith);
                }
                if (this.originalLith != null) {
                    this.insertAction(this.originalLith);
                }
                Well.this.db.commit();
                Well.this.setChanged();
                Well.this.notifyObservers(this.originalLith != null ? this.originalLith : this.newLith);
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQLException in lith interval undo", (SQLException)sql);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error in lith interval undo", (Exception)((Object)sbe));
            }
            super.undo();
        }

        public void redo() {
            try {
                if (this.originalLith != null) {
                    this.deleteAction(this.originalLith);
                }
                if (this.newLith != null) {
                    this.insertAction(this.newLith);
                }
                Well.this.db.commit();
                Well.this.setChanged();
                Well.this.notifyObservers(this.newLith != null ? this.newLith : this.originalLith);
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQLException in lith interval redo", (SQLException)sql);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error in lith interval redo", (Exception)((Object)sbe));
            }
            super.redo();
        }

        private void deleteAction(LithBase lithBase) throws SQLException, SBException {
            lithBase.delete(Well.this.wellID, null);
            Well.this.lithIntervals.remove(lithBase);
        }

        private void insertAction(LithBase lithBase) throws SQLException {
            lithBase.status = SbugsStatus.NOTSTORED;
            if (lithBase instanceof LithInterval) {
                Well.this.insertLithInterval((LithInterval)lithBase);
            } else if (lithBase instanceof LithQualifier) {
                Well.this.insertLithInterval((LithQualifier)lithBase);
            }
            lithBase.store(Well.this.wellID);
        }

        public void doEdit() throws SBException, SQLException {
            this.redo();
        }

        public String getPresentationName() {
            return this.presentationName;
        }
    }

    class CorrectedSample
    implements Comparable {
        double correctedDepth;
        Sample sample;

        CorrectedSample(double correctedDepth, Sample sample) {
            this.correctedDepth = correctedDepth;
            this.sample = sample;
        }

        public int compareTo(Object o) {
            if (o instanceof CorrectedSample) {
                CorrectedSample cs = (CorrectedSample)o;
                int depth = (int)(this.correctedDepth * 1000.0);
                int comp = (int)(cs.correctedDepth * 1000.0);
                return depth - comp;
            }
            return -1;
        }
    }
}

