/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import model2.Audit;
import model2.DEXFile;
import model2.Discipline;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.SbugsSampleObject;
import model2.Userdef;
import model2.Well;
import model2.WsWell;
import org.jdom.Element;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class WellEvent
implements SbugsStatus,
SortEntry,
SbugsSampleObject {
    private final SBdb sbdb;
    private SBEvent sbEvent;
    private Sample sample;
    private SBEvent.EventType type = SBEvent.EventType.TOP;
    private Discipline discID;
    private int analyst;
    private String qualifier;
    private String comments;
    private String source;
    private String company;
    Color status = UNKNOWN;
    private Audit audit = new Audit();
    private static String PREFIX_F = "Top";
    private static String PREFIX_L = "Base";

    public WellEvent(SBdb v2sbdb, int interpID, int evID, char evType, int wellID, int sampID, char discID, int analystID, String qualifier, String comments, String source, String company, Date modified) throws SBException, SQLException {
        this.sbdb = v2sbdb;
        this.sbEvent = this.sbdb.getSBEvent(evID);
        if (this.sbEvent == null) {
            throw new SBException("Null sbevent for event ID: " + evID);
        }
        this.type = SBEvent.EventType.getType("" + evType);
        this.discID = Discipline.getDisc(discID);
        this.analyst = analystID;
        this.qualifier = qualifier;
        this.comments = comments;
        this.source = source;
        this.company = company;
        this.audit.created = this.audit.modified = modified;
        this.audit.creator = this.audit.modifier = this.sbdb.getUser().getUsrID();
        this.status = NOTSTORED;
        this.store(wellID, interpID, sampID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WellEvent load(SBdb sbdb, Well well, int interpID, int evID, int sampID, SBEvent.EventType type, WellEvent e) throws SQLException, SBException {
        Builder builder = new Builder().event(sbdb.getSBEvent(evID)).sample(well.getSample(sampID)).type(type);
        String sql = "SELECT disc_id,analyst,qualifier,comments,source,company," + Audit.sqlFieldString();
        sql = sql + " FROM " + sbdb.DBTableName("EVENTS") + " WHERE interp_id=" + interpID + " AND well_id=" + well.getWellID() + " AND samp_id=" + sampID + " AND ev_id=" + evID + " AND ev_type=" + SB.DBChar((char)type.getChar());
        sql = sbdb.modQuery(sql);
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                String strg = rs.getString("disc_id");
                if (strg != null) {
                    builder.discID(Discipline.getDisc(strg.charAt(0)));
                }
                builder.analyst(rs.getInt("analyst"));
                builder.qualifier(rs.getString("qualifier"));
                builder.comments(rs.getString("comments"));
                builder.source(rs.getString("source"));
                builder.company(rs.getString("company"));
                builder.audit(new Audit(rs));
                builder.status = STORED;
            }
        }
        finally {
            stmt.close();
        }
        if (e == null) {
            return builder.build(sbdb);
        }
        if (e.sample != builder.sample || e.sbEvent != builder.sbEvent || e.type != type) {
            throw new IllegalArgumentException("Attempt to copy fields to unequivalent Well Event object");
        }
        e.analyst = builder.analyst;
        e.qualifier = builder.qualifier;
        e.comments = builder.comments;
        e.company = builder.company;
        e.source = builder.source;
        e.discID = builder.discID;
        e.status = builder.status;
        return e;
    }

    static Builder parse(DEXFile.DEXsection section, SBdb db, Well well) throws SQLException, SBException {
        Builder builder = new Builder();
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Type")) {
                builder.type(SBEvent.EventType.getType(value));
                continue;
            }
            if (label.equalsIgnoreCase("Event ID")) continue;
            if (label.equalsIgnoreCase("Sample ID")) {
                builder.sample(well.getSample(Integer.parseInt(value)));
                continue;
            }
            if (label.equalsIgnoreCase("Discipline")) {
                builder.discID(Discipline.getDisc(value));
                continue;
            }
            if (label.equalsIgnoreCase("Analyst")) {
                builder.analyst(db.getAddUserID(value));
                continue;
            }
            if (label.equalsIgnoreCase("Qualifier")) {
                builder.qualifier(value);
                continue;
            }
            if (label.equalsIgnoreCase("Comments")) {
                builder.comments(value);
                continue;
            }
            if (label.equalsIgnoreCase("Source")) {
                builder.source(value);
                continue;
            }
            if (label.equalsIgnoreCase("Company")) {
                builder.company(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Modified")) continue;
            try {
                ((Builder)builder).audit.modified = SB.df.parse(value);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return builder;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public String getComments() {
        return this.comments;
    }

    public String getModifierAbr() {
        if (this.sbdb == null) {
            return "" + this.audit.modifier;
        }
        try {
            return this.sbdb.getUser(this.audit.modifier).getAbr();
        }
        catch (Exception e) {
            return "Not found: " + this.audit.modifier;
        }
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public Sample getSample() {
        return this.sample;
    }

    public SBEvent getEvent() {
        return this.sbEvent;
    }

    public int getAnalyst() {
        return this.analyst;
    }

    public char getDiscID() {
        return Discipline.getChar(this.discID);
    }

    public Discipline getDiscipline() {
        return this.discID;
    }

    public Discipline getDiscIDTaxon() {
        if (this.discID != null) {
            return this.discID;
        }
        if (this.sbEvent.getTaxon() == null) {
            return null;
        }
        return this.sbEvent.getTaxon().getDisc();
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.sample.toString() + " " + this.getType() + " " + this.sbEvent.toString();
    }

    public String toString(boolean type, boolean qual, boolean depth) {
        return this.toString(type, qual, depth, this.sample.displayUnits);
    }

    public String toString(boolean type, boolean qual, boolean depth, char units) {
        String string = "";
        if (depth) {
            string = string + this.sample.toString(units);
        }
        if (qual && this.qualifier != null && !this.qualifier.isEmpty()) {
            if (!string.isEmpty()) {
                string = string + " ";
            }
            string = string + this.qualifier;
        }
        if (type) {
            if (!string.isEmpty()) {
                string = string + " ";
            }
            string = string + this.getType();
        }
        if (!string.isEmpty()) {
            string = string + " ";
        }
        string = string + this.sbEvent.toString();
        return string;
    }

    public char getCharType() {
        return this.type.getChar();
    }

    public SBEvent.EventType getTypeObj() {
        return this.type;
    }

    public String getType() {
        switch (this.type) {
            case TOP: {
                return PREFIX_F;
            }
            case BASE: {
                return PREFIX_L;
            }
            case SINGLE: {
                return "Single";
            }
        }
        assert (false);
        return null;
    }

    public static String getType(char type) {
        if (type == 'F') {
            return PREFIX_F;
        }
        if (type == 'L') {
            return PREFIX_L;
        }
        return "Single";
    }

    public static String getPrefixF() {
        return PREFIX_F;
    }

    public static void setPrefixes(String f, String l) {
        if (f != null && !f.isEmpty()) {
            PREFIX_F = f;
        }
        if (l != null && !l.isEmpty()) {
            PREFIX_L = l;
        }
    }

    public static String getPrefixL() {
        return PREFIX_L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, int interpID) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to event deletion from well: " + wellID + ", interp: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE interp_id=" + interpID + " AND samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND ev_id=" + this.sbEvent.getEvID() + " AND (ev_type";
        switch (this.type) {
            case SINGLE: {
                sql = sql + " is NULL or ev_type=' ' or ev_type";
            }
            case TOP: 
            case BASE: {
                sql = sql + "=" + SB.DBChar((char)this.type.getChar()) + ")";
            }
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nRows != 1) {
                throw new SBException("The statement: " + SB.sql + " updated: " + nRows + " rows.");
            }
        }
        finally {
            stmt.close();
        }
        this.status = NOTSTORED;
    }

    void updateStatus(List<WellEvent> events) throws SBException, SQLException {
        this.status = NOTSTORED;
        for (WellEvent event : events) {
            if (event == this || !this.isFuncEquivalent(event)) continue;
            this.status = STORED;
            MergeStatus m = new MergeStatus(this.status);
            m.compareStringField("Analyst", event.getAnalystString(), this.getAnalystString(), false);
            m.compareStringField("Comments", event.comments, this.comments, false);
            m.compareStringField("Company", event.company, this.company, false);
            m.compareCharField("DiscID", Discipline.getChar(event.discID), Discipline.getChar(this.discID));
            m.compareStringField("Qualifier", event.qualifier, this.qualifier, false);
            m.compareStringField("Source", event.source, this.source, false);
            this.status = m.getStatus();
            break;
        }
    }

    final void store(int wellID, int interpID) throws SBException, SQLException {
        this.store(wellID, interpID, this.sample.getSampID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void store(int wellID, int interpID, int sampID) throws SBException, SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal argument to WellEvent.store: wellID is " + wellID + ", interpID is " + interpID);
        }
        if (this.status == NOTSTORED) {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            String sql = "INSERT INTO " + this.sbdb.DBTableName("EVENTS") + " (interp_id,ev_id,ev_type,well_id,samp_id,disc_id,analyst,qualifier,comments,source,company," + Audit.sqlFieldString();
            sql = sql + ") VALUES (" + interpID + "," + this.sbEvent.getEvID() + "," + SB.DBChar((char)this.type.getChar()) + "," + wellID + "," + sampID;
            sql = sql + "," + SB.DBChar((char)Discipline.getChar(this.discID)) + "," + (this.analyst > 0 ? Integer.valueOf(this.analyst) : "NULL") + "," + SB.DBString((String)this.qualifier) + "," + SB.DBString((String)this.comments) + "," + SB.DBString((String)this.source) + "," + SB.DBString((String)this.company) + ",";
            sql = sql + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            try {
                int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
                if (nRows != 1) {
                    throw new SBException("The statement: " + SB.sql + " updated: " + nRows + " rows.");
                }
            }
            finally {
                stmt.close();
            }
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            throw new SBException("Attempt to update SBEvent");
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getCompany() {
        return this.company;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public Date getUpdated() {
        return this.audit.updated;
    }

    public SBEvent getSbEvent() {
        return this.sbEvent;
    }

    public int getSampID() {
        return this.sample.getSampID();
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public int getUpdater() {
        return this.audit.updater;
    }

    public String getSortEntry() {
        return this.sample.getSortEntry() + '-' + (Object)((Object)this.type) + '-' + this.sbEvent.getName().toUpperCase();
    }

    public Audit getAudit() {
        return this.audit;
    }

    public String getAnalystString() {
        if (this.analyst > 0) {
            try {
                return this.sbdb.getUser(this.analyst).getAbr();
            }
            catch (Exception ex) {
                return "" + ex.getMessage();
            }
        }
        return "";
    }

    static Builder parse(SBdb ws, WsWell well, Element xml) throws SQLException, SBException, ParseException {
        Element el;
        Builder builder = new Builder();
        String strg = xml.getChildTextNormalize("EventID");
        if (strg != null) {
            int eventID = Integer.parseInt(strg);
            SBEvent sbEvent = ws.getSBEvent(eventID);
            if (sbEvent == null) {
                throw new SBException("Event null for ID: " + eventID + " in WellEvent constructor.");
            }
            builder.event(sbEvent);
        }
        if ((strg = xml.getChildTextNormalize("SampleID")) != null) {
            int sampID = Integer.parseInt(strg);
            builder.sample(well.getSample(sampID));
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null && strg.length() > 0) {
            builder.type(SBEvent.EventType.getType(strg));
        }
        if ((strg = xml.getChildTextNormalize("Qualifier")) != null) {
            builder.qualifier(strg);
        }
        if ((strg = xml.getChildTextNormalize("Analyst")) != null) {
            builder.analyst(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("Source")) != null) {
            builder.source(strg);
        }
        if ((strg = xml.getChildTextNormalize("Comments")) != null) {
            builder.comments(strg);
        }
        if ((strg = xml.getChildTextNormalize("Company")) != null) {
            builder.company(strg);
        }
        if ((strg = xml.getChildTextNormalize("DisciplineID")) != null && strg.length() > 0) {
            builder.discID(Discipline.getDisc(strg.charAt(0)));
        }
        if ((el = xml.getChild("Audit")) != null) {
            builder.audit(new Audit(ws, el));
        }
        builder.status = NOTSTORED;
        return builder;
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<WellEvent Event=\"" + SB.getXMLstring((String)this.toString()) + "\">\n");
        out.write(ind + "<EventID>" + this.sbEvent.getEvID() + "</EventID>\n");
        out.write(ind + "<SampleID>" + this.sample.getSampID() + "</SampleID>\n");
        out.write(ind + "<Type>" + this.getType() + "</Type>\n");
        if (this.qualifier != null && this.qualifier.length() > 0) {
            out.write(ind + "<Qualifier>" + this.qualifier + "</Qualifier>\n");
        }
        if (this.analyst > 0) {
            out.write(ind + "<Analyst>" + this.analyst + "</Analyst>\n");
        }
        if (this.source != null && this.source.length() > 0) {
            out.write(ind + "<Source>" + this.source + "</Source>\n");
        }
        if (this.comments != null && this.comments.length() > 0) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.comments) + "</Comments>\n");
        }
        if (this.company != null && this.company.length() > 0) {
            out.write(ind + "<Company>" + this.company + "</Company>\n");
        }
        if (this.discID != null) {
            out.write(ind + "<DisciplineID>" + this.discID.getChar() + "</DisciplineID>\n");
        }
        this.audit.writeXML(out, ind.length());
        out.write("</WellEvent>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(int wellID, int interpID, int newInterpID) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0 || newInterpID < 0) {
            throw new IllegalArgumentException("Illegal argument to WellEvent.move: wellID is " + wellID + ", interpID is " + interpID + ", newInterpID is " + newInterpID);
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit tempAudit = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("events") + " SET interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND ev_id=" + this.sbEvent.getEvID() + " AND interp_id=" + interpID + " AND (ev_type";
        switch (this.type) {
            case SINGLE: {
                sql = sql + " is NULL or ev_type";
            }
            case TOP: 
            case BASE: {
                sql = sql + "=" + SB.DBChar((char)this.type.getChar()) + ")";
            }
        }
        try {
            int nRow = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nRow != 1) {
                throw new SBException("Error moving event: " + this + ". Number returned from update: " + nRow);
            }
        }
        finally {
            stmt.close();
        }
        this.audit = tempAudit;
    }

    boolean mergeSamples(Sample donor, Sample target) {
        if (this.sample == donor) {
            this.sample = target;
            return true;
        }
        return false;
    }

    void setEvent(SBEvent event) {
        this.sbEvent = event;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException {
        if (e instanceof WellEvent) {
            if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
                return true;
            }
            WellEvent comp = (WellEvent)e;
            if (this.sample.isFuncEquivalent(comp.sample) && this.type == comp.type && this.sbEvent.getName().toUpperCase().equals(comp.sbEvent.getName().toUpperCase())) {
                return true;
            }
        }
        return false;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for event: " + this);
        }
        if (this.analyst > 0) {
            this.analyst = analyst.getUsrID();
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private WellEvent(Builder builder, SBdb sbdb) {
        this.sbdb = sbdb;
        this.sbEvent = builder.sbEvent;
        this.sample = builder.sample;
        this.type = builder.type;
        this.discID = builder.discID;
        this.analyst = builder.analyst;
        this.qualifier = builder.qualifier;
        this.comments = builder.comments;
        this.source = builder.source;
        this.company = builder.company;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    public static class Builder {
        private SBEvent sbEvent;
        private Sample sample;
        private SBEvent.EventType type;
        private Discipline discID = null;
        private int analyst = 0;
        private String qualifier = "";
        private String comments = "";
        private String source = "";
        private String company = "";
        Color status = SbugsStatus.UNKNOWN;
        private Audit audit = new Audit();

        WellEvent build(SBdb sbdb) {
            if (sbdb == null) {
                throw new IllegalArgumentException("Attempt to build WellEvent with null data model");
            }
            if (this.sbEvent == null) {
                throw new IllegalStateException("Attempt to build WellEvent with null event");
            }
            if (this.sample == null) {
                throw new IllegalStateException("Attempt to build WellEvent with null sample");
            }
            if (this.type == null || this.sbEvent.isSingle() != this.type.isSingle()) {
                if (this.sbEvent.isSingle()) {
                    this.type = SBEvent.EventType.SINGLE;
                } else {
                    throw new IllegalStateException("Attempt to build WellEvent with invalid event type");
                }
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new WellEvent(this, sbdb);
        }

        WellEvent build(SBdb sbdb, int wellID, int interpID) throws SBException, SQLException {
            WellEvent event = this.build(sbdb);
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            event.store(wellID, interpID);
            return event;
        }

        public Builder type(SBEvent.EventType type) {
            this.type = type;
            return this;
        }

        public Builder qualifier(String q) {
            if (q != null) {
                this.qualifier = q.trim();
            }
            return this;
        }

        public Builder comments(String q) {
            if (q != null) {
                this.comments = q.trim();
            }
            return this;
        }

        public Builder source(String q) {
            if (q != null) {
                this.source = q.trim();
            }
            return this;
        }

        public Builder company(String q) {
            if (q != null) {
                this.company = q.trim();
            }
            return this;
        }

        public Builder discID(Discipline discID) {
            this.discID = discID;
            return this;
        }

        public Builder analyst(int analyst) {
            if (analyst >= 0) {
                this.analyst = analyst;
            }
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = new Audit(audit);
            }
            return this;
        }

        public Builder event(SBEvent event) {
            this.sbEvent = event;
            return this;
        }

        public Builder sample(Sample sample) {
            this.sample = sample;
            return this;
        }

        public static Builder copyOf(WellEvent rhs) {
            Builder builder = new Builder().type(rhs.getTypeObj());
            builder.discID(rhs.discID).audit(new Audit(rhs.audit));
            builder.source(rhs.source).comments(rhs.comments).company(rhs.company).qualifier(rhs.qualifier);
            return builder;
        }

        public Sample getSample() {
            return this.sample;
        }

        public SBEvent getSBEvent() {
            return this.sbEvent;
        }

        public char getType() {
            return this.type.getChar();
        }
    }
}

