/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2.Audit;
import model2.DEXFile;
import model2.SBdb;
import model2.Well;
import org.jdom.Element;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsStatus;

public class WellHeader
extends Observable
implements SbugsStatus,
Comparable {
    private boolean isUpdateable = false;
    WellHeader link;
    private String wellName = "";
    private String wellCode = "";
    private char type = (char)87;
    private char wellUnits = (char)77;
    private String oper = "";
    private String country = "";
    private String field = "";
    private double gridX = 0.0;
    private double gridY = 0.0;
    private java.util.Date spud;
    private java.util.Date comp;
    private double td = 0.0;
    private double sl = 0.0;
    private double sb = 0.0;
    private double rte = 0.0;
    private double kicko = 0.0;
    private String ocs = "";
    private String county = "";
    Audit audit = new Audit();
    public static final int DATUMRTE = 1;
    public static final int DATUMSL = 2;
    public static final int DATUMSB = 3;
    private int datum;
    private Double lat_dec;
    private Double long_dec;
    private String geoDatum = "";
    private String descrip;
    static boolean permissionsLoaded = false;
    int wellPermission = -1;
    static List permissions = new ArrayList();
    static final int NOACCESS = 0;
    static final int FULLACCESS = 1;
    static final int READONLY = 2;
    Color status = NOTSTORED;
    MergeStatus headerMergeStatus = null;

    public WellHeader(SBdb SB2, String wellName, String wellCode, char type, char wellUnits, String oper, String country, String field, double gridX, double gridY, java.util.Date spud, java.util.Date comp, double td, double sl, double sb, double rte, double kicko, String ocs, String county, String usrid, java.util.Date userDate, int datum, Double lat_dec, Double long_dec, String geoDatum, String descrip) throws SQLException {
        this.isUpdateable = true;
        this.wellName = wellName;
        this.wellCode = wellCode;
        this.type = type;
        this.wellUnits = wellUnits;
        this.oper = oper;
        this.country = country;
        this.field = field;
        this.gridX = gridX;
        this.gridY = gridY;
        this.spud = spud;
        this.comp = comp;
        this.td = td;
        this.sl = sl;
        this.sb = sb;
        this.rte = rte;
        this.kicko = kicko;
        this.ocs = ocs;
        this.county = county;
        this.audit.creator = SB2.getUserID(usrid);
        this.audit.created = userDate;
        this.audit.modifier = SB2.getUserID(usrid);
        this.audit.modified = userDate;
        this.datum = datum;
        this.lat_dec = lat_dec;
        this.long_dec = long_dec;
        this.geoDatum = geoDatum;
        this.descrip = descrip;
    }

    public WellHeader() {
        this.isUpdateable = true;
    }

    public WellHeader(WellHeader rhs) {
        this.copy(rhs);
        this.isUpdateable = true;
    }

    public final void copy(WellHeader rhs) {
        this.isUpdateable = false;
        this.wellName = rhs.wellName;
        this.wellCode = rhs.wellCode;
        this.type = rhs.type;
        this.wellUnits = rhs.wellUnits;
        this.oper = rhs.oper;
        this.country = rhs.country;
        this.field = rhs.field;
        this.gridX = rhs.gridX;
        this.gridY = rhs.gridY;
        this.spud = rhs.spud;
        this.comp = rhs.comp;
        this.td = rhs.td;
        this.sl = rhs.sl;
        this.sb = rhs.sb;
        this.rte = rhs.rte;
        this.kicko = rhs.kicko;
        this.ocs = rhs.ocs;
        this.county = rhs.county;
        this.audit = new Audit(rhs.audit);
        this.datum = rhs.datum;
        this.lat_dec = rhs.lat_dec;
        this.long_dec = rhs.long_dec;
        this.geoDatum = rhs.geoDatum;
        this.descrip = rhs.descrip;
        this.status = STORED;
    }

    public String toString() {
        return this.wellName + " (" + this.wellCode + ')';
    }

    public String statusString() {
        if (!(this.link == null || this.link.wellName.equals(this.wellName) && this.link.wellCode.equals(this.wellCode))) {
            return this.toString() + " / " + this.link.toString();
        }
        return this.toString();
    }

    public Color getStatus() {
        return this.status;
    }

    public String getWellName() {
        return this.wellName;
    }

    public String getWellCode() {
        return this.wellCode;
    }

    public char getType() {
        return this.type;
    }

    public char getWellUnits() {
        return this.wellUnits;
    }

    public String getOper() {
        return this.oper;
    }

    public String getCountry() {
        return this.country;
    }

    public String getField() {
        return this.field;
    }

    public double getGridX() {
        return this.gridX;
    }

    public double getGridY() {
        return this.gridY;
    }

    public java.util.Date getSpud() {
        return this.spud;
    }

    public java.util.Date getComp() {
        return this.comp;
    }

    public double getTD() {
        return this.td;
    }

    public double getSL() {
        return this.sl;
    }

    public double getSB() {
        return this.sb;
    }

    public double getRTE() {
        return this.rte;
    }

    public double getKicko() {
        return this.kicko;
    }

    public String getOCS() {
        return this.ocs;
    }

    public String getCounty() {
        return this.county;
    }

    public java.util.Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public java.util.Date getModified() {
        return this.audit.modified;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public int getDatum() {
        return this.datum;
    }

    public Double getLat_dec() {
        return this.lat_dec;
    }

    public char getLat_ind() {
        if (this.lat_dec == null || this.lat_dec >= 0.0) {
            return 'N';
        }
        return 'S';
    }

    public short getLat_deg() {
        if (this.lat_dec == null) {
            return 0;
        }
        return (short)Math.abs(this.lat_dec);
    }

    public short getLat_min() {
        if (this.lat_dec == null) {
            return 0;
        }
        double dec = Math.abs(this.lat_dec - (double)this.lat_dec.intValue());
        return (short)(dec *= 60.0);
    }

    public float getLat_sec() {
        if (this.lat_dec == null) {
            return 0.0f;
        }
        double dec = Math.abs(this.lat_dec - (double)this.lat_dec.intValue());
        dec *= 60.0;
        dec -= (double)((int)dec);
        return (float)(dec *= 60.0);
    }

    public String getLatString(boolean decimal) {
        if (this.lat_dec == null) {
            return null;
        }
        if (decimal) {
            return String.valueOf(this.lat_dec);
        }
        String s = String.valueOf(this.getLat_deg()) + "\u00b0";
        s = s + String.valueOf(this.getLat_min()) + "'";
        s = s + String.valueOf(this.getLat_sec()) + "\"";
        s = s + this.getLat_ind();
        return s;
    }

    public String getLongString(boolean decimal) {
        if (this.long_dec == null) {
            return null;
        }
        if (decimal) {
            return String.valueOf(this.long_dec);
        }
        String s = String.valueOf(this.getLong_deg()) + "\u00b0";
        s = s + String.valueOf(this.getLong_min()) + "'";
        s = s + String.valueOf(this.getLong_sec()) + "\"";
        s = s + this.getLong_ind();
        return s;
    }

    public Double getLong_dec() {
        return this.long_dec;
    }

    public char getLong_ind() {
        if (this.long_dec == null || this.long_dec < 0.0) {
            return 'W';
        }
        return 'E';
    }

    public short getLong_deg() {
        if (this.long_dec == null) {
            return 0;
        }
        return (short)Math.abs(this.long_dec);
    }

    public short getLong_min() {
        if (this.long_dec == null) {
            return 0;
        }
        double dec = Math.abs(this.long_dec - (double)this.long_dec.intValue());
        return (short)(dec *= 60.0);
    }

    public float getLong_sec() {
        if (this.long_dec == null) {
            return 0.0f;
        }
        double dec = Math.abs(this.long_dec - (double)this.long_dec.intValue());
        dec *= 60.0;
        dec -= (double)((int)dec);
        return (float)(dec *= 60.0);
    }

    public String getGeoDatum() {
        return this.geoDatum;
    }

    public String getDescrip() {
        return this.descrip;
    }

    public String getDatumString() {
        switch (this.datum) {
            default: {
                return "RT/KB";
            }
            case 2: {
                return "SL";
            }
            case 3: 
        }
        return "SB";
    }

    public void setWellName(String wellName) throws SBException {
        if (!wellName.equals(this.wellName)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update well name");
            }
            this.wellName = wellName;
            this.setChanged();
        }
    }

    Color getWsStatus() {
        return this.status;
    }

    void setWellCode(String wellCode) {
        this.wellCode = wellCode;
    }

    public void setType(char type) throws SBException {
        if (type != 'W' && type != 'O') {
            throw new SBException("Unrecognised section type: " + type);
        }
        if (type != this.type) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update type");
            }
            this.type = type;
            this.setChanged();
        }
    }

    public void setType(SBdb db, char type) throws SBException, SQLException {
        if (type != 'W' && type != 'O') {
            throw new SBException("Unrecognised section type: " + type);
        }
        if (type != this.type) {
            this.updateWellHeaderField(db, "TYPE", "" + type);
            this.type = type;
            this.setChanged();
        }
    }

    public void setWellUnits(char wellUnits) throws SBException {
        if (wellUnits != 'F' && wellUnits != 'M') {
            throw new SBException("Unrecognised section wellUnits: " + wellUnits);
        }
        if (wellUnits != this.wellUnits) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update wellUnits");
            }
            this.wellUnits = wellUnits;
            this.setChanged();
        }
    }

    public void setWellUnits(SBdb db, char wellUnits) throws SBException, SQLException {
        if (wellUnits != 'F' && wellUnits != 'M') {
            throw new SBException("Unrecognised section wellUnits: " + wellUnits);
        }
        if (wellUnits != this.wellUnits) {
            this.updateWellHeaderField(db, "UNITS", "" + wellUnits);
            this.wellUnits = wellUnits;
            this.setChanged();
        }
    }

    void updateWellHeaderField(SBdb db, String field, String value) throws SQLException {
        String sql = "UPDATE " + db.DBTableName("WELLS") + " SET " + field + "=" + SB.DBString((String)value);
        sql = sql + " WHERE well_code='" + this.wellCode + "'";
        Statement stmt = db.getDatabase().createStatement();
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
    }

    void updateWellHeaderField(SBdb db, String field, double value) throws SQLException {
        String sql = "UPDATE " + db.DBTableName("WELLS") + " SET " + field + "=" + value;
        sql = sql + " WHERE well_code='" + this.wellCode + "'";
        Statement stmt = db.getDatabase().createStatement();
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
    }

    public void setOper(String oper) throws SBException {
        if (!oper.equals(this.oper)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update operator");
            }
            this.oper = oper;
            this.setChanged();
        }
    }

    public void setOper(SBdb db, String oper) throws SBException, SQLException {
        if (!oper.equals(this.oper)) {
            this.updateWellHeaderField(db, "OPERATOR", oper);
            this.oper = oper;
            this.setChanged();
        }
    }

    public void setCountry(String country) throws SBException {
        if (!country.equals(this.country)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update country");
            }
            this.country = country;
            this.setChanged();
        }
    }

    public void setCountry(SBdb db, String country) throws SBException, SQLException {
        if (!country.equals(this.country)) {
            this.updateWellHeaderField(db, "COUNTRY", country);
            this.country = country;
            this.setChanged();
        }
    }

    public static List<String> getCountries(SBdb sbdb) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String sql = "SELECT DISTINCT (country) FROM " + sbdb.DBTableName("WELLS") + " ORDER BY COUNTRY";
        Statement stmt = sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            list.add(rs.getString("country"));
        }
        stmt.close();
        return list;
    }

    public void setField(String field) throws SBException {
        if (!field.equals(this.field)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update field");
            }
            this.field = field;
            this.setChanged();
        }
    }

    public void setField(SBdb db, String field) throws SBException, SQLException {
        if (!field.equals(this.field)) {
            this.updateWellHeaderField(db, "FIELD", field);
            this.field = field;
            this.setChanged();
        }
    }

    public void setGrid(double gridX, double gridY) throws SBException {
        if (gridX != this.gridX || gridY != this.gridY) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update gridX/Y");
            }
            this.gridX = gridX;
            this.gridY = gridY;
            this.setChanged();
        }
    }

    public void setGridX(SBdb db, double gridX) throws SBException, SQLException {
        if (gridX != this.gridX) {
            this.updateWellHeaderField(db, "GRID_X", gridX);
            this.gridX = gridX;
            this.setChanged();
        }
    }

    public void setGridY(SBdb db, double gridY) throws SBException, SQLException {
        if (gridY != this.gridY) {
            this.updateWellHeaderField(db, "GRID_Y", gridY);
            this.gridY = gridY;
            this.setChanged();
        }
    }

    public void setSpud(java.util.Date spud) throws SBException {
        if (spud != null || this.spud != null || spud != null && !spud.equals(this.spud)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update spud date");
            }
            this.spud = spud;
            this.setChanged();
        }
    }

    public void setSpud(SBdb db, java.util.Date spud) throws SBException, SQLException {
        if (spud != null || this.spud != null || spud != null && !spud.equals(this.spud)) {
            this.updateWellHeaderField(db, "spud_date", SB.DBdf.format(spud));
            this.spud = spud;
            this.setChanged();
        }
    }

    public void setComp(java.util.Date comp) throws SBException {
        if (comp != null || this.comp != null || comp != null && !comp.equals(this.comp)) {
            if (comp != null && this.spud != null && comp.compareTo(this.spud) < 0) {
                throw new SBException("Completion date is before spud date for well: " + this.wellName + "/" + this.wellCode);
            }
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update comp");
            }
            this.comp = comp;
            this.setChanged();
        }
    }

    public void setComp(SBdb db, java.util.Date comp) throws SBException, SQLException {
        if (comp != null || this.comp != null || comp != null && !comp.equals(this.comp)) {
            this.updateWellHeaderField(db, "comp_date", SB.DBdf.format(comp));
            this.comp = comp;
            this.setChanged();
        }
    }

    public void setTD(double td) throws SBException {
        if (td != this.td) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Termination Depth");
            }
            this.td = td;
            this.setChanged();
        }
    }

    public void setTD(SBdb db, double td) throws SBException, SQLException {
        if (td != this.td) {
            this.updateWellHeaderField(db, "TD", td);
            this.td = td;
            this.setChanged();
        }
    }

    public void setSL(double sl) throws SBException {
        if (sl != this.sl) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Sea Level");
            }
            this.sl = sl;
            this.setChanged();
        }
    }

    public void setSL(SBdb db, double sl) throws SBException, SQLException {
        if (sl != this.sl) {
            this.updateWellHeaderField(db, "SL", sl);
            this.sl = sl;
            this.setChanged();
        }
    }

    public void setSB(double sb) throws SBException {
        if (sb != this.sb) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Sea Bed");
            }
            this.sb = sb;
            this.setChanged();
        }
    }

    public void setSB(SBdb db, double sb) throws SBException, SQLException {
        if (sb != this.sb) {
            this.updateWellHeaderField(db, "SB", sb);
            this.sb = sb;
            this.setChanged();
        }
    }

    public void setRTE(double rte) throws SBException {
        if (rte != this.rte) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update RTE");
            }
            this.rte = rte;
            this.setChanged();
        }
    }

    public void setRTE(SBdb db, double rte) throws SBException, SQLException {
        if (rte != this.rte) {
            this.updateWellHeaderField(db, "RTE", rte);
            this.rte = rte;
            this.setChanged();
        }
    }

    public void setKicko(double kicko) throws SBException {
        if (kicko != this.kicko) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Kick off Depth");
            }
            this.kicko = kicko;
            this.setChanged();
        }
    }

    public void setKicko(SBdb db, double kicko) throws SBException, SQLException {
        if (kicko != this.kicko) {
            this.updateWellHeaderField(db, "KICKO", kicko);
            this.kicko = kicko;
            this.setChanged();
        }
    }

    public void setOCS(String ocs) throws SBException {
        if (!ocs.equals(this.ocs)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update OCS number");
            }
            this.ocs = ocs;
            this.setChanged();
        }
    }

    public void setOCS(SBdb db, String ocs) throws SBException, SQLException {
        if (!ocs.equals(this.ocs)) {
            this.updateWellHeaderField(db, "OCS", ocs);
            this.ocs = ocs;
            this.setChanged();
        }
    }

    public void setCounty(String county) throws SBException {
        if (!county.equals(this.county)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update county");
            }
            this.county = county;
            this.setChanged();
        }
    }

    public void setCounty(SBdb db, String county) throws SBException, SQLException {
        if (!county.equals(this.county)) {
            this.updateWellHeaderField(db, "COUNTY", county);
            this.county = county;
            this.setChanged();
        }
    }

    public void setDatum(int datum) throws SBException {
        if (datum != this.datum) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update datum");
            }
            switch (datum) {
                case 1: 
                case 2: 
                case 3: {
                    this.datum = datum;
                    break;
                }
                default: {
                    throw new SBException("Unrecognised datum: " + datum);
                }
            }
            this.setChanged();
        }
    }

    public void setLat(Double temp) throws SBException {
        if (this.lat_dec != temp) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update latitude");
            }
            this.lat_dec = temp;
            this.setChanged();
        }
    }

    public void setLat(SBdb db, double temp) throws SBException, SQLException {
        if (this.lat_dec != temp) {
            this.updateWellHeaderField(db, "LAT_DEC", this.lat_dec);
            this.lat_dec = temp;
            this.setChanged();
        }
    }

    public void setLat(short lat_deg, short lat_min, float lat_sec, char lat_ind) throws SBException {
        double temp = (double)lat_deg + (double)lat_min / 60.0 + (double)lat_sec / 3600.0;
        if (lat_ind == 'S') {
            temp = -temp;
        }
        this.setLat(temp);
    }

    public static double getDecimalLat(short lat_deg, short lat_min, float lat_sec, char lat_ind) {
        double temp = (double)lat_deg + (double)lat_min / 60.0 + (double)lat_sec / 3600.0;
        if (lat_ind == 'S') {
            temp = -temp;
        }
        return temp;
    }

    public void setLong(Double temp) throws SBException {
        if (this.long_dec != temp) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update longitude");
            }
            this.long_dec = temp;
            this.setChanged();
        }
    }

    public void setLong(SBdb db, double temp) throws SBException, SQLException {
        if (this.long_dec != temp) {
            this.updateWellHeaderField(db, "LONG_DEC", this.long_dec);
            this.long_dec = temp;
            this.setChanged();
        }
    }

    public void setLong(short long_deg, short long_min, float long_sec, char long_ind) throws SBException {
        double temp = (double)long_deg + (double)long_min / 60.0 + (double)long_sec / 3600.0;
        if (long_ind == 'W') {
            temp = -temp;
        }
        this.setLong(temp);
    }

    public static double getDecimalLong(short long_deg, short long_min, float long_sec, char long_ind) {
        double temp = (double)long_deg + (double)long_min / 60.0 + (double)long_sec / 3600.0;
        if (long_ind == 'W') {
            temp = -temp;
        }
        return temp;
    }

    public void setGeoDatum(String geoDatum) throws SBException {
        if (!geoDatum.equals(this.geoDatum)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Geodetic Datum");
            }
            this.geoDatum = geoDatum;
            this.setChanged();
        }
    }

    public void setGeoDatum(SBdb db, String geoDatum) throws SBException, SQLException {
        if (!geoDatum.equals(this.geoDatum)) {
            this.updateWellHeaderField(db, "GEODATUM", geoDatum);
            this.geoDatum = geoDatum;
            this.setChanged();
        }
    }

    public void setDescrip(String descrip) throws SBException {
        if (!descrip.equals(this.descrip)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Description");
            }
            this.descrip = descrip;
            this.setChanged();
        }
    }

    public boolean updateFromMaster(SBdb SB2, SimpleDateFormat df, boolean updateTableData) throws SQLException, SBException {
        if (!SB2.hasWellsMaster) {
            return false;
        }
        String sql = "SELECT ";
        Iterator it = SB2.wellMasterFields.iterator();
        while (it.hasNext()) {
            sql = sql + it.next();
            if (!it.hasNext()) continue;
            sql = sql + ",";
        }
        sql = sql + " FROM " + SB2.DBTableName("WELLS_MASTER");
        sql = sql + " WHERE well_code=" + SB.DBString((String)this.wellCode);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        boolean needsUpdate = false;
        WellHeader temp = new WellHeader(this);
        if (rs.next()) {
            for (String fieldName : SB2.wellMasterFields) {
                Double fieldData;
                if (fieldName.equalsIgnoreCase("well_name")) {
                    String fieldData2 = rs.getString(fieldName);
                    temp.setWellName(fieldData2);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("operator")) {
                    String fieldData3 = SB.getDBString((ResultSet)rs, (String)fieldName);
                    temp.setOper(fieldData3);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("country")) {
                    String fieldData4 = SB.getDBString((ResultSet)rs, (String)fieldName);
                    temp.setCountry(fieldData4);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("county")) {
                    String fieldData5 = SB.getDBString((ResultSet)rs, (String)fieldName);
                    temp.setCounty(fieldData5);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("ocs")) {
                    String fieldData6 = SB.getDBString((ResultSet)rs, (String)fieldName);
                    temp.setOCS(fieldData6);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("field")) {
                    String fieldData7 = SB.getDBString((ResultSet)rs, (String)fieldName);
                    temp.setField(fieldData7);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("grid_x")) {
                    long fieldData8 = rs.getLong(fieldName);
                    if (temp.gridX == (double)fieldData8) continue;
                    temp.gridX = fieldData8;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("grid_y")) {
                    long fieldData9 = rs.getLong(fieldName);
                    if (temp.gridY == (double)fieldData9) continue;
                    temp.gridY = fieldData9;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("spud_date")) {
                    Date fieldData10 = rs.getDate(fieldName);
                    temp.setSpud(fieldData10);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("comp_date")) {
                    Date fieldData11 = rs.getDate(fieldName);
                    try {
                        temp.setComp(fieldData11);
                    }
                    catch (SBException sbe) {
                        System.out.println("Exception from setting in updateFromMaster: " + sbe.toString());
                        sbe.printStackTrace();
                    }
                    continue;
                }
                if (fieldName.equalsIgnoreCase("lat_dec")) {
                    BigDecimal BDfieldData = SB.getBigDecimal((ResultSet)rs, (String)fieldName, (SB2.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                    fieldData = BDfieldData == null ? null : Double.valueOf(BDfieldData.doubleValue());
                    if (temp.lat_dec == fieldData) continue;
                    temp.lat_dec = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("long_dec")) {
                    BigDecimal BDfieldData = SB.getBigDecimal((ResultSet)rs, (String)fieldName, (SB2.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                    fieldData = BDfieldData == null ? null : Double.valueOf(BDfieldData.doubleValue());
                    if (temp.long_dec == fieldData) continue;
                    temp.long_dec = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("td")) {
                    double fieldData12 = rs.getDouble(fieldName);
                    temp.setTD(fieldData12);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("sl")) {
                    double fieldData13 = rs.getDouble(fieldName);
                    temp.setSL(fieldData13);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("sb")) {
                    double fieldData14 = rs.getDouble(fieldName);
                    temp.setSB(fieldData14);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("rte")) {
                    double fieldData15 = rs.getDouble(fieldName);
                    temp.setRTE(fieldData15);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("kicko")) {
                    double fieldData16 = rs.getDouble(fieldName);
                    temp.setKicko(fieldData16);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("datum")) {
                    int fieldData17 = rs.getInt(fieldName);
                    temp.setDatum(fieldData17);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("type")) {
                    char fieldData18 = SB.getDBChar((ResultSet)rs, (String)fieldName);
                    temp.setType(fieldData18);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("units")) {
                    char fieldData19 = SB.getDBChar((ResultSet)rs, (String)fieldName);
                    temp.setWellUnits(fieldData19);
                    continue;
                }
                if (!fieldName.equalsIgnoreCase("geodatum")) continue;
                String fieldData20 = SB.getDBString((ResultSet)rs, (String)fieldName);
                temp.setGeoDatum(fieldData20);
            }
        }
        stmt.close();
        if (updateTableData && temp.hasChanged()) {
            temp.update(SB2);
            this.copy(temp);
            SB2.commit();
            return true;
        }
        return false;
    }

    void update(SBdb SB2) throws SQLException, SBException {
        if (this.checkPerm(SB2) != 1) {
            throw new SBException("No privilege to write data for well: " + this.toString());
        }
        if (!SB2.isConnected()) {
            return;
        }
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "UPDATE " + SB2.DBTableName("WELLS") + " SET well_name=" + SB.DBString((String)this.wellName) + ",operator=" + SB.DBString((String)this.oper) + ",country=" + SB.DBString((String)this.country) + " WHERE well_code=" + SB.DBString((String)this.wellCode);
        int rows = stmt.executeUpdate(sql = SB2.modQuery(sql));
        if (rows != 1) {
            if (SB2.dbType != SBdb.DBType.MYSQL) {
                throw new SBException("Error - in statement: " + sql + "\nNumber of rows updated: " + rows);
            }
            System.out.println("Possible error: " + sql + "\nNumber of rows updated: " + rows);
        }
        sql = "UPDATE " + SB2.DBTableName("WELLS") + " SET ";
        sql = sql + "county=" + SB.DBString((String)this.county) + ",";
        sql = sql + "ocs=" + SB.DBString((String)this.ocs) + ",";
        sql = sql + "field=" + SB.DBString((String)this.field) + ",";
        sql = sql + "grid_x=" + (this.gridX > 0.0 ? Double.valueOf(this.gridX) : "NULL") + ",";
        sql = sql + "grid_y=" + (this.gridY > 0.0 ? Double.valueOf(this.gridY) : "NULL") + ",";
        sql = sql + "spud_date=" + (this.spud == null ? "NULL" : SB.DBString((String)SB.DBdf.format(this.spud))) + ",";
        sql = sql + "comp_date=" + (this.comp == null ? "NULL" : SB.DBString((String)SB.DBdf.format(this.comp)));
        sql = sql + " WHERE well_code='" + this.wellCode + "'";
        sql = SB2.modQuery(sql);
        stmt.executeUpdate(sql);
        sql = "UPDATE " + SB2.DBTableName("WELLS") + " SET ";
        sql = this.lat_dec == null ? sql + "lat_dec=NULL" : sql + "lat_dec=" + this.lat_dec;
        sql = this.long_dec == null ? sql + ",long_dec=NULL" : sql + ",long_dec=" + this.long_dec;
        sql = this.type == 'O' || Math.abs(this.td) > 0.001 ? sql + ",td=" + this.td : sql + ",td=NULL";
        sql = Math.abs(this.sl) > 0.001 ? sql + ",sl=" + this.sl : sql + ",sl=NULL";
        sql = Math.abs(this.sb) > 0.001 ? sql + ",sb=" + this.sb : sql + ",sb=NULL";
        sql = Math.abs(this.rte) > 0.001 ? sql + ",rte=" + this.rte : sql + ",rte=NULL";
        sql = Math.abs(this.kicko) > 0.001 ? sql + ",kicko=" + this.kicko : sql + ",kicko=NULL";
        sql = sql + " WHERE well_code='" + this.wellCode + "'";
        sql = SB2.modQuery(sql);
        rows = stmt.executeUpdate(sql);
        if (rows != 1) {
            if (SB2.dbType != SBdb.DBType.MYSQL) {
                throw new SBException("Error - in statement: " + sql + "\nNumber of rows updated: " + rows);
            }
            System.out.println("Possible error: " + sql + "\nNumber of rows updated: " + rows);
        }
        sql = "UPDATE " + SB2.DBTableName("WELLS") + " SET ";
        sql = sql + "datum=" + this.datum + ",type='" + this.type + "',units='" + this.wellUnits + "'";
        sql = sql + "," + this.audit.sqlUpdate(SB2, stmt, false);
        sql = sql + ",geodatum=" + SB.DBString((String)this.geoDatum);
        sql = sql + " WHERE well_code='" + this.wellCode + "'";
        rows = stmt.executeUpdate(sql = SB2.modQuery(sql));
        if (rows != 1) {
            throw new SBException("Error - in statement: " + sql + "\nNumber of rows updated: " + rows);
        }
        this.updateDescrip(SB2, this.wellCode, stmt);
        this.status = STORED;
        stmt.close();
        this.isUpdateable = false;
    }

    String wsStatusString() {
        return this.statusString();
    }

    private void updateDescrip(SBdb SB2, String wellCode, Statement stmt) throws SQLException {
        String sql = "UPDATE " + SB2.DBTableName("well_ident") + " SET descrip=" + SB.DBString((String)this.descrip) + " WHERE well_code=" + SB.DBString((String)wellCode);
        stmt.executeUpdate(SB2.modQuery(sql));
    }

    int checkPerm(SBdb SB2) throws SQLException {
        if (this.wellPermission != -1) {
            return this.wellPermission;
        }
        this.wellPermission = WellHeader.checkWellPerm(SB2, this.country, this.field, this.oper);
        if (this.wellPermission == 0 || !SB2.hasWellPerm) {
            return this.wellPermission;
        }
        this.wellPermission = 1;
        String sql = "SELECT acctype, usrid FROM ";
        sql = sql + SB2.DBTableName("WELLPERM");
        sql = sql + " WHERE well_code=";
        sql = sql + SB.DBString((String)this.wellCode);
        sql = sql + " ORDER BY acctype";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int acctype = rs.getInt("acctype");
            String usrid = rs.getString("usrid");
            if (usrid != null && usrid.equals(SB2.user.getAbr())) {
                this.wellPermission = 1;
                break;
            }
            this.wellPermission = acctype;
        }
        stmt.close();
        return this.wellPermission;
    }

    static int checkWellPerm(SBdb SB2, String country, String field, String oper) throws SQLException {
        return 1;
    }

    static void loadPermissions(SBdb SB2) throws SQLException {
    }

    public int compareTo(Object o) {
        WellHeader rhs = (WellHeader)o;
        if (rhs.wellName.equalsIgnoreCase(this.wellName)) {
            return this.wellCode.compareToIgnoreCase(rhs.wellCode);
        }
        return this.wellName.compareToIgnoreCase(rhs.wellName);
    }

    void extendTD(double newTD) throws SBException {
        if (newTD > this.td) {
            this.setTD(newTD);
        }
    }

    synchronized void refresh(SBdb SB2, int wellID, Statement stmt) throws SQLException, SBException {
        Timestamp time;
        String sql = "SELECT w.updated  FROM " + SB2.DBTableName("WELLS") + " w," + SB2.DBTableName("WELL_IDENT") + " v WHERE w.well_code=v.well_code AND v.well_id=" + wellID;
        ResultSet rs = stmt.executeQuery(sql = SB2.modQuery(sql));
        if (rs.next() && (time = rs.getTimestamp("updated")) != null && time.after(this.audit.updated)) {
            this.load(SB2, wellID);
            this.setChanged();
            this.notifyObservers();
        }
    }

    void load(SBdb SB2, int wellID) throws SQLException, SBException {
        String sql = "SELECT well_name,w.well_code,v.descrip,operator,country,county,ocs,field,grid_x,grid_y,spud_date,comp_date,td,sl,sb,rte,kicko,datum,type,units," + Audit.sqlFieldString() + ",geodatum" + " FROM " + SB2.DBTableName("WELLS") + " w," + SB2.DBTableName("WELL_IDENT") + " v WHERE w.well_code=v.well_code AND v.well_id=" + wellID;
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            this.wellName = rs.getString("well_name");
            this.wellCode = rs.getString("well_code");
            this.descrip = SB.getDBString((ResultSet)rs, (String)"descrip");
            this.oper = SB.getDBString((ResultSet)rs, (String)"operator");
            this.country = SB.getDBString((ResultSet)rs, (String)"country");
            this.county = SB.getDBString((ResultSet)rs, (String)"county");
            this.ocs = SB.getDBString((ResultSet)rs, (String)"ocs");
            this.field = SB.getDBString((ResultSet)rs, (String)"field");
            this.gridX = rs.getDouble("grid_x");
            this.gridY = rs.getDouble("grid_y");
            this.spud = rs.getDate("spud_date");
            this.comp = rs.getDate("comp_date");
            this.td = rs.getDouble("td");
            this.sl = rs.getDouble("sl");
            this.sb = rs.getDouble("sb");
            this.rte = rs.getDouble("rte");
            this.kicko = rs.getDouble("kicko");
            this.datum = (char)rs.getInt("datum");
            String s = rs.getString("type");
            if (s != null && s.length() > 0) {
                this.type = s.charAt(0);
            }
            if ((s = rs.getString("units")) != null && s.length() > 0) {
                this.wellUnits = s.charAt(0);
            }
        } else {
            stmt.close();
            throw new SBException("Cannot create well with wellID: " + wellID);
        }
        this.audit = new Audit(rs);
        this.geoDatum = SB.getDBString((ResultSet)rs, (String)"geodatum");
        sql = "SELECT lat_dec,long_dec FROM " + SB2.DBTableName("WELLS") + " WHERE well_code='" + this.wellCode + "'";
        sql = SB2.modQuery(sql);
        rs = stmt.executeQuery(sql);
        if (rs.next()) {
            BigDecimal bdLongDec;
            BigDecimal bdLatDec = SB.getBigDecimal((ResultSet)rs, (String)"lat_dec", (SB2.dbType == SBdb.DBType.SQLITE ? 1 : 0) != 0);
            if (bdLatDec != null) {
                this.lat_dec = bdLatDec.doubleValue();
            }
            if ((bdLongDec = SB.getBigDecimal((ResultSet)rs, (String)"long_dec", (SB2.dbType == SBdb.DBType.SQLITE ? 1 : 0) != 0)) != null) {
                this.long_dec = bdLongDec.doubleValue();
            }
        }
        stmt.close();
        this.updateFromMaster(SB2, new SimpleDateFormat("yyyy-MM-dd"), true);
    }

    void updateStatus(SBdb SB2, Well well) throws SBException, SQLException {
        WellHeader tmp = well.header;
        MergeStatus m = new MergeStatus(STORED);
        m.compareStringField("Country", this.country, tmp.country, true);
        m.compareStringField("County", this.county, tmp.county, true);
        m.compareStringField("Field", this.field, tmp.field, true);
        m.compareDateField("Completion date", this.comp, tmp.comp);
        m.compareDateField("Spud date", this.spud, tmp.spud);
        m.compareIntField("Depth datum", this.datum, tmp.datum);
        m.compareStringField("Geodetic datum", this.geoDatum, tmp.geoDatum, true);
        m.compareDoubleField("Grid X", this.gridX, tmp.gridX);
        m.compareDoubleField("Grid Y", this.gridY, tmp.gridY);
        m.compareDoubleField("Kickoff depth", this.kicko, tmp.kicko);
        m.compareDoubleField("Latitude", this.lat_dec != null ? this.lat_dec : 0.0, tmp.lat_dec != null ? tmp.lat_dec : 0.0);
        m.compareDoubleField("Longitude", this.long_dec != null ? this.long_dec : 0.0, tmp.long_dec != null ? tmp.long_dec : 0.0);
        m.compareStringField("OCS number", this.ocs, tmp.ocs, true);
        m.compareStringField("Operator", this.oper, tmp.oper, true);
        m.compareDoubleField("RTE", this.rte, tmp.rte);
        m.compareDoubleField("Sea Bed", this.sb, tmp.sb);
        m.compareDoubleField("Sea Level", this.sl, tmp.sl);
        m.compareDoubleField("Termination depth", this.td, tmp.td);
        m.compareCharField("Well/outcrop", this.type, tmp.type);
        m.compareCharField("Depth units", this.wellUnits, tmp.wellUnits);
        this.status = m.getStatus();
        if (this.status == CONFLICT) {
            this.headerMergeStatus = m;
        }
        this.link = tmp;
    }

    void writeSbugs(FileWriter out) throws IOException {
        out.write(this.wellName + '\t' + this.wellCode + '\t' + this.oper + '\t' + this.country + '\t' + this.field + '\t' + '\t' + '\t' + '\t' + this.gridX + '\t' + this.gridY + '\t');
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        if (this.spud != null) {
            out.write(df.format(this.spud));
        } else {
            out.write("00-Jan-0000");
        }
        out.write(9);
        if (this.comp != null) {
            out.write(df.format(this.comp));
        } else {
            out.write("00-Jan-0000");
        }
        out.write("\t" + this.lat_dec + '\t' + this.getLat_ind() + '\t' + this.getLat_deg() + '\t' + this.getLat_min() + '\t' + this.getLat_sec() + '\t');
        out.write("\t" + this.long_dec + '\t' + this.getLong_ind() + '\t' + this.getLong_deg() + '\t' + this.getLong_min() + '\t' + this.getLong_sec() + '\t');
        out.write("\t" + this.td + '\t' + this.sl + '\t' + this.sb + '\t' + this.rte + '\t' + this.datum + '\t' + this.type + '\t' + this.wellUnits + '\n');
    }

    void writeDEX(FileWriter out, String eol, boolean fullHeader, SimpleDateFormat df, char units) throws IOException {
        out.write("[HEADER]" + eol);
        out.write("Well Name = " + this.wellName + eol);
        if (fullHeader) {
            out.write("Well Code = " + this.wellCode + eol);
            if (this.oper != null && this.oper.length() > 0) {
                out.write("Operator = " + this.oper + eol);
            }
            if (this.field != null && this.field.length() > 0) {
                out.write("Field = " + this.field + eol);
            }
            if (this.country != null && this.country.length() > 0) {
                out.write("Country = " + this.country + eol);
            }
            if (this.county != null && this.county.length() > 0) {
                out.write("County = " + this.county + eol);
            }
            out.write("Type = ");
            if (this.type == 'W') {
                out.write("Borehole");
            } else {
                out.write("Outcrop");
            }
            out.write(eol);
            out.write("Units = ");
            if (this.wellUnits == 'M') {
                out.write("metres");
            } else {
                out.write("feet");
            }
            out.write(eol);
            if (this.long_dec != null) {
                out.write("Longitude = " + this.long_dec + eol);
            }
            if (this.lat_dec != null) {
                out.write("Latitude = " + this.lat_dec + eol);
            }
            if (this.gridX > 0.0) {
                out.write("Grid X = " + this.gridX + eol);
            }
            if (this.gridY > 0.0) {
                out.write("Grid Y = " + this.gridY + eol);
            }
            if (this.spud != null) {
                out.write("Spud Date = " + df.format(this.spud) + eol);
            }
            if (this.comp != null) {
                out.write("Completion Date = " + df.format(this.comp) + eol);
            }
            if (this.td > 0.0) {
                out.write("Terminal depth = " + SB.getDepthString((double)this.td, (char)this.wellUnits, (int)2) + eol);
            }
            if (this.sl > 0.0) {
                out.write("SL = " + SB.getDepthString((double)this.sl, (char)this.wellUnits, (int)2) + eol);
            }
            if (this.sb > 0.0) {
                out.write("SB = " + SB.getDepthString((double)this.sb, (char)this.wellUnits, (int)2) + eol);
            }
            if (this.rte > 0.0) {
                out.write("RTE = " + SB.getDepthString((double)this.rte, (char)this.wellUnits, (int)2) + eol);
            }
            if (this.kicko > 0.0) {
                out.write("Kick off depth = " + SB.getDepthString((double)this.kicko, (char)this.wellUnits, (int)2) + eol);
            }
            out.write("Depth Datum = ");
            switch (this.datum) {
                default: {
                    out.write("RTE");
                    break;
                }
                case 2: {
                    out.write("SL");
                    break;
                }
                case 3: {
                    out.write("SB");
                }
            }
            out.write(eol);
        }
    }

    LinkedList<Integer> writeXML(BufferedWriter out, int indent) throws IOException {
        LinkedList<Integer> userIDList = new LinkedList();
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<WellCode>" + this.wellCode + "</WellCode>\n");
        out.write(ind + "<Country>" + SB.getXMLstring((String)this.country) + "</Country>\n");
        out.write(ind + "<Type>" + (this.type == 'O' ? "Outcrop" : "Borehole") + "</Type>\n");
        out.write(ind + "<Units>" + (this.wellUnits == 'F' ? "feet" : "metres") + "</Units>\n");
        if (this.oper != null && this.oper.length() > 0) {
            out.write(ind + "<Operator>" + SB.getXMLstring((String)this.oper) + "</Operator>\n");
        }
        if (this.ocs != null && this.ocs.length() > 0) {
            out.write(ind + "<Ocs>" + this.ocs + "</Ocs>\n");
        }
        if (this.field != null && this.field.length() > 0) {
            out.write(ind + "<Field>" + SB.getXMLstring((String)this.field) + "</Field>\n");
        }
        if (this.county != null && this.county.length() > 0) {
            out.write(ind + "<County>" + SB.getXMLstring((String)this.county) + "</County>\n");
        }
        if (this.lat_dec != null) {
            out.write(ind + "<Latitude>" + this.lat_dec + "</Latitude>\n");
        }
        if (this.long_dec != null) {
            out.write(ind + "<Longitude>" + this.long_dec + "</Longitude>\n");
        }
        if (this.geoDatum != null && this.geoDatum.length() > 0) {
            out.write(ind + "<GeodeticDatum>" + SB.getXMLstring((String)this.geoDatum) + "</GeodeticDatum>\n");
        }
        if (this.gridX > 0.0) {
            out.write(ind + "<GridX>" + this.gridX + "</GridX>\n");
        }
        if (this.gridY > 0.0) {
            out.write(ind + "<GridY>" + this.gridY + "</GridY>\n");
        }
        if (this.spud != null) {
            out.write(ind + "<SpudDate>" + SB.DBdf.format(this.spud) + "</SpudDate>\n");
        }
        if (this.comp != null) {
            out.write(ind + "<CompletionDate>" + SB.DBdf.format(this.comp) + "</CompletionDate>\n");
        }
        out.write(ind + "<TerminalDepth>" + SB.convFromM((double)this.td, (char)this.wellUnits, (char)this.getType()) + "</TerminalDepth>\n");
        switch (this.datum) {
            case 1: {
                out.write(ind + "<DepthDatum>RTE</DepthDatum>\n");
                break;
            }
            case 2: {
                out.write(ind + "<DepthDatum>SL</DepthDatum>\n");
                break;
            }
            case 3: {
                out.write(ind + "<DepthDatum>SB</DepthDatum>\n");
            }
        }
        if (Math.abs(this.rte) > 0.001) {
            out.write(ind + "<RotaryTableElevation>" + SB.convFromM((double)this.rte, (char)this.wellUnits, (char)this.getType()) + "</RotaryTableElevation>\n");
        }
        if (Math.abs(this.sl) > 0.001) {
            out.write(ind + "<SeaLevel>" + SB.convFromM((double)this.sl, (char)this.wellUnits, (char)this.getType()) + "</SeaLevel>\n");
        }
        if (Math.abs(this.sb) > 0.001) {
            out.write(ind + "<SeaBed>" + SB.convFromM((double)this.sb, (char)this.wellUnits, (char)this.getType()) + "</SeaBed>\n");
        }
        if (Math.abs(this.kicko) > 0.001) {
            out.write(ind + "<KickOffDepth>" + SB.convFromM((double)this.kicko, (char)this.wellUnits, (char)this.getType()) + "</KickOffDepth>\n");
        }
        userIDList = this.audit.writeXML(out, indent);
        return userIDList;
    }

    boolean parseDEX(DEXFile.DEXsection section, int[] wellAbn) throws SBException {
        int abnSchemeID = 0;
        boolean wellUnitsSet = false;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Operator")) {
                this.oper = value;
                continue;
            }
            if (label.equalsIgnoreCase("Well name")) {
                this.wellName = value;
                continue;
            }
            if (label.equalsIgnoreCase("Well code")) {
                this.wellCode = value;
                continue;
            }
            if (label.equalsIgnoreCase("Field")) {
                this.field = value;
                continue;
            }
            if (label.equalsIgnoreCase("Country")) {
                this.country = value;
                continue;
            }
            if (label.equalsIgnoreCase("County")) {
                this.county = value;
                continue;
            }
            if (label.equalsIgnoreCase("Type")) {
                if (value.equalsIgnoreCase("Outcrop")) {
                    this.type = (char)79;
                    continue;
                }
                this.type = (char)87;
                continue;
            }
            if (label.equalsIgnoreCase("Units")) {
                this.wellUnits = value.toUpperCase().charAt(0);
                wellUnitsSet = true;
                continue;
            }
            if (label.equalsIgnoreCase("Longtitude") || label.equalsIgnoreCase("Longitude")) {
                this.long_dec = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("Latitude")) {
                this.lat_dec = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("Grid X")) {
                this.gridX = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("Grid Y")) {
                this.gridY = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("Spud Date")) {
                try {
                    this.spud = SB.df.parse(value);
                }
                catch (ParseException pe) {}
                continue;
            }
            if (label.equalsIgnoreCase("Completion Date")) {
                try {
                    this.comp = SB.df.parse(value);
                }
                catch (ParseException pe) {}
                continue;
            }
            if (label.equalsIgnoreCase("Terminal depth")) {
                try {
                    this.td = SB.parseDepthString((String)value);
                }
                catch (SBException ue) {
                    System.out.println("Exception parsing td: " + (Object)((Object)ue));
                }
                continue;
            }
            if (label.equalsIgnoreCase("Total depth")) {
                this.td = SB.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("SL")) {
                this.sl = SB.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("SB")) {
                this.sb = SB.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("RTE")) {
                this.rte = SB.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("Kick off depth")) {
                this.kicko = SB.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("Depth Datum")) {
                if (value.equalsIgnoreCase("RTE")) {
                    this.datum = 1;
                } else if (value.equalsIgnoreCase("SL")) {
                    this.datum = 2;
                } else if (value.equalsIgnoreCase("SB")) {
                    this.datum = 3;
                }
                if (this.type != 'O') continue;
                this.datum = 2;
                continue;
            }
            if (label.equalsIgnoreCase("Abundance scheme ID")) {
                abnSchemeID = Integer.parseInt(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Discipline") || sepChar != ':') continue;
            wellAbn[SBdb.did2i((char)value.charAt((int)0))] = abnSchemeID;
            abnSchemeID = 0;
        }
        return wellUnitsSet;
    }

    void parseXML(String chars, String element) throws ParseException {
        if (element.compareTo("WellCode") == 0) {
            this.wellCode = chars;
        } else if (element.compareTo("Country") == 0) {
            this.country = chars;
        } else if (element.compareTo("County") == 0) {
            this.county = chars;
        } else if (element.compareTo("Field") == 0) {
            this.field = chars;
        } else if (element.compareTo("Type") == 0) {
            if (chars.compareToIgnoreCase("Outcrop") == 0) {
                this.type = (char)79;
            }
        } else if (element.compareTo("Operator") == 0) {
            this.oper = chars;
        } else if (element.compareTo("Ocs") == 0) {
            this.ocs = chars;
        } else if (element.compareTo("Longitude") == 0) {
            this.long_dec = Double.parseDouble(chars);
        } else if (element.compareTo("Latitude") == 0) {
            this.lat_dec = Double.parseDouble(chars);
        } else if (element.compareTo("GeodeticDatum") == 0) {
            this.geoDatum = chars;
        } else if (element.compareTo("GridX") == 0) {
            this.gridX = Double.parseDouble(chars);
        } else if (element.compareTo("GridY") == 0) {
            this.gridY = Double.parseDouble(chars);
        } else if (element.compareTo("SpudDate") == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.spud = df.parse(chars);
        } else if (element.compareTo("CompletionDate") == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.comp = df.parse(chars);
        } else if (element.compareTo("Units") == 0) {
            this.wellUnits = chars.toUpperCase().charAt(0);
        } else if (element.compareTo("TerminalDepth") == 0) {
            this.td = SB.convToM((double)Float.parseFloat(chars), (char)this.wellUnits, (char)this.type);
        } else if (element.compareTo("SeaLevel") == 0) {
            this.sl = SB.convToM((double)Float.parseFloat(chars), (char)this.wellUnits, (char)this.type);
        } else if (element.compareTo("SeaBed") == 0) {
            this.sb = SB.convToM((double)Float.parseFloat(chars), (char)this.wellUnits, (char)this.type);
        } else if (element.compareTo("KickOffDepth") == 0) {
            this.kicko = SB.convToM((double)Float.parseFloat(chars), (char)this.wellUnits, (char)this.type);
        } else if (element.compareTo("RotaryTableElevation") == 0) {
            this.rte = SB.convToM((double)Float.parseFloat(chars), (char)this.wellUnits, (char)this.type);
        } else if (element.compareTo("DepthDatum") == 0) {
            if (chars.compareTo("RTE") == 0) {
                this.datum = 1;
            } else if (chars.compareTo("SL") == 0) {
                this.datum = 2;
            } else if (chars.compareTo("SB") == 0) {
                this.datum = 3;
            }
        }
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    void update(SBdb db, WellHeader link) throws SQLException, SBException {
        MergeStatus m = new MergeStatus(this.status);
        m.compareStringField("Well Code", this.wellCode, link.wellCode, false);
        m.compareStringField("Well Name", this.wellName, link.wellName, false);
        this.country = m.compareStringField("Country", this.country, link.country, true);
        this.county = m.compareStringField("County", this.county, link.county, true);
        this.field = m.compareStringField("Field", this.field, link.field, true);
        this.comp = m.compareDateField("Completion date", this.comp, link.comp);
        this.spud = m.compareDateField("Spud date", this.spud, link.spud);
        this.datum = m.compareIntField("Depth datum", this.datum, link.datum);
        this.geoDatum = m.compareStringField("Geodetic datum", this.geoDatum, link.geoDatum, true);
        this.gridX = m.compareDoubleField("Grid X", this.gridX, link.gridX);
        this.gridY = m.compareDoubleField("Grid Y", this.gridY, link.gridY);
        this.kicko = m.compareDoubleField("Kickoff depth", this.kicko, link.kicko);
        if (link.lat_dec != null && Math.abs(link.lat_dec) > 0.0) {
            this.lat_dec = m.compareDoubleField("Latitude", this.lat_dec == null ? 0.0 : this.lat_dec, link.lat_dec.doubleValue());
        }
        if (link.long_dec != null && Math.abs(link.long_dec) > 0.0) {
            this.long_dec = m.compareDoubleField("Longitude", this.long_dec.doubleValue(), link.long_dec.doubleValue());
        }
        this.ocs = m.compareStringField("OCS number", this.ocs, link.ocs, true);
        this.oper = m.compareStringField("Operator", this.oper, link.oper, true);
        this.rte = m.compareDoubleField("RTE", this.rte, link.rte);
        this.sb = m.compareDoubleField("Sea Bed", this.sb, link.sb);
        this.sl = m.compareDoubleField("Sea Level", this.sl, link.sl);
        this.td = m.compareDoubleField("Termination depth", this.td, link.td);
        this.type = m.compareCharField("Well/outcrop", this.type, link.type);
        m.compareCharField("Depth units", this.wellUnits, link.wellUnits);
        if (m.getStatus() == PARTSTORED) {
            this.update(db);
        }
    }

    void parseXML(Element xml) throws ParseException {
        SimpleDateFormat df;
        String strg = xml.getChildTextNormalize("WellCode");
        if (strg != null) {
            this.wellCode = strg;
        }
        if ((strg = xml.getChildTextNormalize("Country")) != null) {
            this.country = strg;
        }
        if ((strg = xml.getChildTextNormalize("County")) != null) {
            this.county = strg;
        }
        if ((strg = xml.getChildTextNormalize("Field")) != null) {
            this.field = strg;
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null && strg.compareToIgnoreCase("Outcrop") == 0) {
            this.type = (char)79;
        }
        if ((strg = xml.getChildTextNormalize("Operator")) != null) {
            this.oper = strg;
        }
        if ((strg = xml.getChildTextNormalize("Ocs")) != null) {
            this.ocs = strg;
        }
        if ((strg = xml.getChildTextNormalize("Longitude")) != null) {
            this.long_dec = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("Latitude")) != null) {
            this.lat_dec = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("GeodeticDatum")) != null) {
            this.geoDatum = strg;
        }
        if ((strg = xml.getChildTextNormalize("GridX")) != null) {
            this.gridX = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("GridY")) != null) {
            this.gridY = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("SpudDate")) != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            this.spud = df.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("CompletionDate")) != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            this.comp = df.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("Units")) != null) {
            this.wellUnits = strg.toUpperCase().charAt(0);
        }
        if ((strg = xml.getChildTextNormalize("TerminalDepth")) != null) {
            this.td = SB.convToM((double)Double.parseDouble(strg), (char)this.wellUnits, (char)this.type);
        }
        if ((strg = xml.getChildTextNormalize("SeaLevel")) != null) {
            this.sl = SB.convToM((double)Double.parseDouble(strg), (char)this.wellUnits, (char)this.type);
        }
        if ((strg = xml.getChildTextNormalize("SeaBed")) != null) {
            this.sb = SB.convToM((double)Double.parseDouble(strg), (char)this.wellUnits, (char)this.type);
        }
        if ((strg = xml.getChildTextNormalize("KickOffDepth")) != null) {
            this.kicko = SB.convToM((double)Double.parseDouble(strg), (char)this.wellUnits, (char)this.type);
        }
        if ((strg = xml.getChildTextNormalize("RotaryTableElevation")) != null) {
            this.rte = SB.convToM((double)Double.parseDouble(strg), (char)this.wellUnits, (char)this.type);
        }
        if ((strg = xml.getChildTextNormalize("DepthDatum")) != null) {
            if (strg.compareTo("RTE") == 0) {
                this.datum = 1;
            } else if (strg.compareTo("SL") == 0) {
                this.datum = 2;
            } else if (strg.compareTo("SB") == 0) {
                this.datum = 3;
            }
        }
    }
}

