/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.undo.UndoableEdit;
import model2.AnalystHeader;
import model2.Audit;
import model2.Biocom;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.DiscAnalyst;
import model2.Discipline;
import model2.EnvScheme;
import model2.Fault;
import model2.IGDColMap;
import model2.IGDHdr;
import model2.IGDInterval;
import model2.IGDIntervalEnv;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.Intcom;
import model2.InterpHdr;
import model2.LOC;
import model2.SBEvent;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.Smpdtl;
import model2.Surface;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import model2.WellEvent;
import model2.WellEventCompareDepth;
import model2.WsWell;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.DTMonitor;
import util.InvalidFieldException;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsCompoundEdit;
import util.SbugsEdit;
import util.SbugsStatus;

public class WellInterp
extends Observable {
    SBdb SB;
    InterpHdr interp;
    int interpID;
    private char sectionType = (char)87;
    List<IGDIntervalZone> lstrat = new LinkedList<IGDIntervalZone>();
    List<IGDIntervalZone> chrono = new LinkedList<IGDIntervalZone>();
    List<IGDIntervalZone> biozone = new LinkedList<IGDIntervalZone>();
    List[] zoneTypes = new List[]{this.lstrat, this.chrono, this.biozone};
    List<Biocom> comments = new LinkedList<Biocom>();
    List<IGDIntervalEnv> envs = new LinkedList<IGDIntervalEnv>();
    List<IGDHdr> headers = null;
    List<WellEvent> events = null;
    List<SQPick> picks = null;
    List<Intcom> intcoms = null;
    HashMap<Integer, IGDColMap> colMap = new HashMap();
    List<Fault> faults = null;
    LOC loc = null;
    private boolean loaded = false;

    public InterpHdr getHeader() {
        return this.interp;
    }

    public IGDColMap getColMap(int wellID, int igdType) throws SQLException {
        IGDColMap map = this.colMap.get(igdType);
        if (map == null) {
            map = new IGDColMap(this.SB, wellID, this.interpID, igdType);
            this.colMap.put(igdType, map);
        }
        return map;
    }

    public WellInterp(SBdb SB2, char sectionType) {
        this.SB = SB2;
        this.sectionType = sectionType;
    }

    public String toString() {
        if (this.interp == null) {
            return "Null Interp";
        }
        return this.interp.toString();
    }

    WellInterp(SBdb SB2, int interpID, HashMap<Integer, InterpHdr> interps, char sectionType, boolean loaded) throws SQLException {
        this.SB = SB2;
        this.sectionType = sectionType;
        this.interpID = interpID;
        this.interp = interps.get(interpID);
        if (this.interp == null) {
            this.interp = new InterpHdr(SB2, interpID);
            interps.put(interpID, this.interp);
        }
        this.loaded = loaded;
    }

    WellInterp(SBdb db, WellInterp wellInterp) throws SBException, SQLException {
        this.SB = db;
        this.sectionType = wellInterp.sectionType;
        this.interpID = wellInterp.interpID;
    }

    WellInterp(SBdb ws, WellInterp wellInterp, InterpHdr hdr) {
        this.sectionType = wellInterp.sectionType;
        this.interpID = wellInterp.interpID;
        this.interp = hdr;
        this.SB = ws;
    }

    void fillWorkspace(List<Integer> dataTypes, WellInterp dbInterp, WsWell wsWell, Well well) throws SBException, SQLException {
        block9: for (int dType : dataTypes) {
            if (!SBdb.isInterpDataType(dType)) continue;
            switch (dType) {
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    IGDInterval wsZone;
                    dbInterp.loadZones(IGDInterval.dType2IGDtype(dType), well);
                    for (IGDIntervalZone zone : dbInterp.getIGDList(IGDInterval.dType2IGDtype(dType))) {
                        if (!dataTypes.contains(1)) {
                            this.checkSamples(zone.getTopSample(), zone.getBaseSample(), wsWell);
                        }
                        if (this.hasZone(zone, IGDInterval.dType2IGDtype(dType))) continue;
                        wsZone = new IGDIntervalZone(this.SB, zone, (Well)wsWell);
                        this.insertZone((IGDIntervalZone)wsZone);
                    }
                    continue block9;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    for (Biocom biocom : dbInterp.getComments(SBdb.dt2discID(dType))) {
                        if (!dataTypes.contains(1)) {
                            this.checkSamples(biocom.getTopSample(), biocom.getBaseSample(), wsWell);
                        }
                        if (this.hasBiocom(biocom)) continue;
                        Biocom wsBiocom = Biocom.copyToWorkspace(this.SB, biocom, wsWell);
                        this.insertBiocom(wsBiocom);
                    }
                    continue block9;
                }
                case 15: {
                    IGDInterval wsZone;
                    dbInterp.loadEnvs(well);
                    for (IGDIntervalEnv env : dbInterp.getEnvs()) {
                        if (!dataTypes.contains(1)) {
                            this.checkSamples(env.getTopSample(), env.getBaseSample(), wsWell);
                        }
                        if (this.hasEnv(env)) continue;
                        wsZone = new IGDIntervalEnv(this.SB, env, (Well)wsWell);
                        this.insertEnv((IGDIntervalEnv)wsZone);
                    }
                    continue block9;
                }
                case 18: {
                    if (dbInterp.intcoms == null) {
                        dbInterp.loadIntcoms(well);
                    }
                    this.getIntcoms();
                    for (Intcom intcom : dbInterp.getIntcoms()) {
                        Intcom wsIntcom = new Intcom(this.SB, intcom);
                        this.insert(wsIntcom);
                    }
                    continue block9;
                }
                case 14: {
                    if (dbInterp.picks == null) {
                        dbInterp.loadSQPicks(well);
                    }
                    this.getSQPicks();
                    for (SQPick pick : dbInterp.getSQPicks()) {
                        if (!dataTypes.contains(1)) {
                            this.checkSamples(pick.getSample(), null, wsWell);
                        }
                        SQPick wsPick = new SQPick(this.SB, pick, wsWell);
                        this.insertPick(wsPick);
                    }
                    continue block9;
                }
                case 16: {
                    if (dbInterp.events == null) {
                        dbInterp.loadEvents(well);
                    }
                    this.getEvents();
                    for (WellEvent event : dbInterp.getEvents()) {
                        if (!dataTypes.contains(1)) {
                            this.checkSamples(event.getSample(), null, wsWell);
                        }
                        this.copyToWorkspace(event, well.getDataModel(), wsWell);
                    }
                    continue block9;
                }
                case 17: {
                    if (dbInterp.loc == null) {
                        dbInterp.loadEvents(well);
                    }
                    if (dbInterp.loc == null) continue block9;
                    this.loc = new LOC(this.SB, dbInterp.loc);
                    break;
                }
                default: {
                    throw new SBException("Can't process data type in WellInterp.fillWorkspace: " + dType);
                }
            }
        }
    }

    private void checkSamples(Sample topSample, Sample baseSample, WsWell wsWell) throws SQLException, SBException {
        Sample wsSample;
        if (topSample != null && !wsWell.hasSample(topSample)) {
            wsSample = new Sample(wsWell.getDataModel(), topSample);
            Sample.insert(wsWell.getSamples(), wsSample, wsWell.getWellUnits());
        }
        if (baseSample != null && !wsWell.hasSample(baseSample)) {
            wsSample = new Sample(wsWell.getDataModel(), baseSample);
            Sample.insert(wsWell.getSamples(), wsSample, wsWell.getWellUnits());
        }
    }

    static int zoneType2IGDType(int zoneType) throws SBException {
        switch (zoneType) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 10;
            }
        }
        throw new SBException("Overrun of zone type in zoneType2IGDType");
    }

    public double getMinAge(IGDScheme scheme) throws SBException, SQLException {
        double age = -1.0;
        for (List zones : this.zoneTypes) {
            for (Object o : zones) {
                IGDUnit unit;
                IGDIntervalZone zone = (IGDIntervalZone)o;
                if (zone.getSchID() != scheme.getSchID() || (unit = scheme.findUnit(zone.getUppZone())) == null || !(age < 0.0) && !(unit.getUage() < age)) continue;
                age = unit.getUage();
            }
        }
        return age;
    }

    public double getMaxAge(IGDScheme scheme) throws SBException, SQLException {
        double age = -1.0;
        for (List zones : this.zoneTypes) {
            for (Object o : zones) {
                IGDUnit unit;
                IGDIntervalZone zone = (IGDIntervalZone)o;
                if (zone.getSchID() != scheme.getSchID()) continue;
                int zoneID = zone.getLowZone();
                if (zoneID <= 0) {
                    zoneID = zone.getUppZone();
                }
                if ((unit = scheme.findUnit(zoneID)) == null || !(age < 0.0) && !(unit.getLage() > age)) continue;
                age = unit.getLage();
            }
        }
        return age;
    }

    boolean hasExistingIGDData(int igdType, int wellID) throws SQLException {
        String sql = "SELECT top_id FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    @Deprecated
    void deleteExistingIGDData(int igdType, int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void deleteZones(int igdType, int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        List<IGDIntervalZone> igdList = this.getIGDList(igdType);
        if (igdList != null) {
            igdList.clear();
        }
        this.setChanged();
    }

    public void deleteZones(int igdType, int wellID, int schID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND interp_id=" + this.interpID + " AND well_id=" + wellID + " AND sch_id=" + schID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        Iterator<IGDIntervalZone> it = this.getIGDList(igdType).iterator();
        while (it.hasNext()) {
            IGDIntervalZone zone = it.next();
            if (zone.getSchID() != schID) continue;
            it.remove();
        }
        this.setChanged();
    }

    boolean hasExistingEnvData(int wellID) throws SQLException {
        String sql = "SELECT top_id FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    void deleteExistingEnvData(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    boolean hasExistingBiocomData(DiscAnalyst discAnalyst, int wellID) throws SQLException {
        String sql = "SELECT usamp_id FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE disc_id=" + util.SB.DBChar((char)discAnalyst.discID);
        if (discAnalyst.analyst > 0) {
            sql = sql + " AND analyst=" + discAnalyst.analyst;
        }
        sql = sql + " AND interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    void deleteExistingBiocomData(DiscAnalyst discAnalyst, int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE disc_id=" + util.SB.DBChar((char)discAnalyst.discID);
        if (discAnalyst.analyst > 0) {
            sql = sql + " AND analyst=" + discAnalyst.analyst;
        }
        sql = sql + " AND interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    IGDHdr getHeader(int wellID, int schID, boolean create) throws SBException, SQLException {
        if (this.headers == null) {
            this.loadHeaders(wellID);
        }
        Iterator<IGDHdr> it = this.headers.iterator();
        IGDHdr hdr = null;
        while (it.hasNext()) {
            hdr = it.next();
            if (hdr.getSchID() == schID) {
                return hdr;
            }
            hdr = null;
        }
        if (create) {
            throw new SBException("Attempt to create IGD header");
        }
        return hdr;
    }

    void loadHeaders(int wellID) throws SQLException, SBException {
        if (this.headers == null) {
            this.headers = new LinkedList<IGDHdr>();
        }
        IGDHdr.load(this.SB, wellID, this.interpID, this.headers);
    }

    synchronized void refreshHeaders(Statement stmt, Well well) throws SQLException, SBException {
        if (this.headers != null) {
            IGDHdr.refresh(stmt, this.SB, well.wellID, this.interpID, this.headers);
        }
    }

    public void deleteIGDHdr(int wellID, IGDHdr hdr) throws SBException, SQLException {
        hdr.delete(wellID, this.interpID);
        this.headers.remove(hdr);
    }

    public void removeIGDHdr(int schID) {
        if (this.headers != null) {
            Iterator<IGDHdr> it = this.headers.iterator();
            while (it.hasNext()) {
                if (it.next().getSchID() != schID) continue;
                it.remove();
            }
        }
    }

    public IGDHdr updateIGDHdr(int wellID, IGDHdr hdr, String comments, String source, String authorised) throws SBException, SQLException {
        hdr.delete(wellID, this.interpID);
        this.headers.remove(hdr);
        Audit audit = new Audit();
        audit.created = hdr.getCreated();
        audit.creator = hdr.getCreator();
        IGDHdr newHdr = new IGDHdr(this.SB, hdr.getSchID(), source, authorised, comments, audit);
        newHdr.store(wellID, this.interpID);
        this.addHeader(wellID, newHdr);
        return newHdr;
    }

    public IGDHdr addIGDHdr(int wellID, int schID, String comments, String source, String authorised) throws SBException, SQLException {
        IGDHdr hdr = new IGDHdr(this.SB, schID, source, authorised, comments, new Audit());
        hdr.store(wellID, this.interpID);
        this.addHeader(wellID, hdr);
        return hdr;
    }

    void addHeader(int wellID, IGDHdr hdr) throws SBException, SQLException {
        if (this.getHeader(wellID, hdr.getSchID(), false) != null) {
            throw new SBException("Attempt to add header that already exists");
        }
        this.headers.add(hdr);
    }

    public List<IGDHdr> getHeaders() throws SBException {
        if (this.headers == null) {
            throw new SBException("IGDHdrs not loaded in Wellinterp.getHeaders");
        }
        return this.headers;
    }

    public SBdb getDatabase() {
        return this.SB;
    }

    void refresh(Statement stmt, Well well) throws SBException, SQLException {
        if (this.loaded) {
            well.getSamples();
            this.refreshComments(stmt, well);
            for (int zoneType = 0; zoneType < this.zoneTypes.length; ++zoneType) {
                this.refreshZones(stmt, WellInterp.zoneType2IGDType(zoneType), well, 0);
            }
            this.refreshHeaders(stmt, well);
            this.refreshEnvs(stmt, well);
            this.refreshEvents(stmt, well);
            this.refreshSQPicks(stmt, well);
            this.refreshIntcoms(stmt, well);
            this.refreshFaults(stmt, well);
        }
    }

    void load(Well well) throws SBException, SQLException {
        if (!this.loaded && this.SB.isConnected()) {
            System.out.println(well + " : " + this + " : LOADING...");
            System.out.println("Loading interp zones...");
            for (int zoneType = 0; zoneType < this.zoneTypes.length; ++zoneType) {
                this.loadZones(WellInterp.zoneType2IGDType(zoneType), well);
            }
            System.out.println("Loading headers...");
            this.loadHeaders(well.wellID);
            System.out.println("Loading interp comments...");
            this.loadComments('\u0000', well);
            System.out.println("Loading interp envs...");
            this.loadEnvs(well);
            System.out.println("Loading interp events...");
            this.loadEvents(well);
            System.out.println("Loading sequence picks...");
            this.loadSQPicks(well);
            System.out.println("Loading interval comments...");
            this.loadIntcoms(well);
            System.out.println("Loading faults...");
            this.loadFaults(well);
            this.loaded = true;
        }
    }

    synchronized void refreshEvents(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded || this.events == null) {
            return;
        }
        String sql = "SELECT ev_id,samp_id,ev_type,updated ";
        sql = sql + " FROM " + this.SB.DBTableName("EVENTS") + " WHERE well_id=" + well.wellID + " AND interp_id=" + this.interpID;
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        WellEvent notifier = null;
        HashSet<String> keys = new HashSet<String>();
        while (rs.next()) {
            int evID = rs.getInt("ev_id");
            int sampID = rs.getInt("samp_id");
            SBEvent.EventType type = SBEvent.EventType.getType(rs.getString("ev_type"));
            String key = "" + sampID + "," + evID + "," + type.name();
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (WellEvent s : this.events) {
                if (!("" + s.getSampID() + "," + s.getEvent().getEvID() + "," + s.getTypeObj().name()).equals(key)) continue;
                found = true;
                if (time == null || s.getUpdated() != null && !time.after(s.getUpdated())) break;
                notifier = s = WellEvent.load(this.SB, well, this.interpID, evID, sampID, type, s);
                break;
            }
            if (found) continue;
            WellEvent event = WellEvent.load(this.SB, well, this.interpID, evID, sampID, type, null);
            this.insertEvent(event);
            notifier = event;
        }
        if (keys.size() < this.events.size()) {
            Iterator<WellEvent> it = this.events.iterator();
            while (it.hasNext()) {
                WellEvent s = it.next();
                if (keys.contains("" + s.getSampID() + "," + s.getEvent().getEvID() + "," + s.getTypeObj().name())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = s;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
        sql = "SELECT updated ";
        sql = sql + " FROM " + this.SB.DBTableName("LOC") + " WHERE well_id=" + well.wellID + " AND interp_id=" + this.interpID;
        sql = this.SB.modQuery(sql);
        rs = stmt.executeQuery(sql);
        boolean doNotify = false;
        if (rs.next()) {
            if (this.loc == null) {
                this.loc = new LOC(this.SB, well.wellID, this.interpID);
                doNotify = true;
            } else {
                Timestamp time = rs.getTimestamp("updated");
                if (time != null && time.after(this.loc.getUpdated())) {
                    System.out.println("Creating new LOC in wellInterp");
                    this.loc = new LOC(this.SB, well.wellID, this.interpID);
                    doNotify = true;
                }
            }
        }
        if (doNotify) {
            this.setChanged();
            System.out.println("Notifying in wellInterp.refresh");
            this.notifyObservers(this.loc);
        }
    }

    public void loadEvents(Well well) throws SQLException, SBException {
        this.loadEvents(well, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadEvents(Well well, List composites) throws SQLException, SBException {
        if (this.getEvents().size() > 0) {
            return;
        }
        String sql = "SELECT ev_id,samp_id,ev_type,disc_id,analyst,qualifier,comments,source,company," + Audit.sqlFieldString();
        sql = sql + " FROM " + this.SB.DBTableName("EVENTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + well.wellID;
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                WellEvent.Builder builder = new WellEvent.Builder();
                builder.event(this.SB.getSBEvent(rs.getInt("ev_id")));
                builder.sample(well.getSample(rs.getInt("samp_id")));
                builder.type(SBEvent.EventType.getType(rs.getString("ev_type")));
                String strg = rs.getString("disc_id");
                if (strg != null) {
                    builder.discID(Discipline.getDisc(strg.charAt(0)));
                }
                builder.analyst(rs.getInt("analyst"));
                builder.qualifier(rs.getString("qualifier"));
                builder.comments(rs.getString("comments"));
                builder.source(rs.getString("source"));
                builder.company(rs.getString("company"));
                builder.audit(new Audit(rs));
                builder.status = SbugsStatus.STORED;
                try {
                    this.insertEvent(builder.build(this.SB));
                }
                catch (RuntimeException e) {
                    util.SB.showStackError((String)("Error loading well event: " + e.getMessage()), (Exception)e);
                }
            }
            sql = "SELECT std_id,red,green,blue,linewidth," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("LOC") + " WHERE interp_id=" + this.interpID + " AND well_id=" + well.wellID;
            rs = stmt.executeQuery(sql = this.SB.modQuery(sql));
            if (rs.next()) {
                int stdID = rs.getInt("std_id");
                int r = rs.getInt("red");
                int g = rs.getInt("green");
                int b = rs.getInt("blue");
                Color colour = new Color(r, g, b);
                float lineWidth = rs.getFloat("linewidth");
                this.loc = new LOC(this.SB, stdID, this.interpID, well.wellID, colour, lineWidth, new Audit(rs));
            }
        }
        finally {
            stmt.close();
        }
    }

    public WellEvent addEvent(Well well, Sample sample, SBEvent event, SBEvent.EventType eventType, Discipline discID, String analyst, String comment, String qualifier, String source, String company) throws SBException, SQLException, InvalidFieldException {
        for (WellEvent we : this.getEventsByDepth()) {
            if (we.getSampID() == sample.getSampID() && we.getSbEvent().getEvID() == event.getEvID() && we.getTypeObj() == eventType) {
                throw new InvalidFieldException("Event '" + we + "' already exists");
            }
            if (!(we.getSample().getDepth() > sample.getDepth())) continue;
            break;
        }
        WellEvent.Builder builder = new WellEvent.Builder().type(eventType).sample(sample).event(event).discID(discID).analyst(this.SB.getUserID(analyst));
        builder.comments(comment).qualifier(qualifier).source(source).company(company);
        WellEvent wellEvent = builder.build(this.SB, well.getWellID(), this.interpID);
        this.insertEvent(wellEvent);
        this.setChanged();
        return wellEvent;
    }

    public WellEvent updateEvent(WellEvent original, WellEvent.Builder builder, int wellID) throws InvalidFieldException, SQLException, SBException {
        for (WellEvent we : this.getEventsByDepth()) {
            if (we != original && we.getSampID() == builder.getSample().getSampID() && we.getSbEvent().getEvID() == builder.getSBEvent().getEvID() && we.getCharType() == builder.getType()) {
                throw new InvalidFieldException("This event already exists");
            }
            if (!(we.getSample().getDepth() > builder.getSample().getDepth())) continue;
            break;
        }
        original.delete(wellID, this.interpID);
        WellEvent wellEvent = builder.build(this.SB, wellID, this.interpID);
        this.events.remove(original);
        this.insertEvent(wellEvent);
        this.setChanged();
        return wellEvent;
    }

    public void deleteEvent(WellEvent wellEvent, int wellID) throws SQLException, SBException {
        if (wellEvent == null) {
            throw new IllegalArgumentException("Illegal arguments to delete event from well " + wellID + wellEvent == null ? " (event is null)" : "");
        }
        if (this.SB != null && this.SB.isConnected()) {
            if (wellID < 1) {
                throw new IllegalArgumentException("Illegal arguments to delete event from well ID: " + wellID + wellEvent == null ? " (event is null)" : "");
            }
            wellEvent.delete(wellID, this.interpID);
        }
        this.events.remove(wellEvent);
        this.setChanged();
    }

    public void deleteEvents(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("EVENTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.events.clear();
        this.setChanged();
    }

    void sortEventsByDepth() throws SBException {
        boolean swap = true;
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < this.events.size(); ++i) {
                WellEvent event = this.events.get(i);
                WellEvent prevEvent = this.events.get(i - 1);
                if (event.getSample() == null || prevEvent.getSample() == null) {
                    throw new SBException("Null sample encountered during events sort");
                }
                if (!(event.getSample().getDepth('M') < prevEvent.getSample().getDepth('M'))) continue;
                this.events.add(i - 1, event);
                this.events.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    void insertEvent(WellEvent event) throws SBException {
        if (event == null || event.getSample() == null) {
            throw new IllegalArgumentException("Attempt to insert null event or event with null sample: " + event);
        }
        this.getEvents();
        Iterator<WellEvent> it = this.events.iterator();
        int i = 0;
        while (it.hasNext()) {
            WellEvent current = it.next();
            if (event.getSampID() == current.getSampID() && event.getEvent().getEvID() == current.getEvent().getEvID() && event.getTypeObj() == current.getTypeObj() && event.getSampID() > 0 && event.getEvent().getEvID() > 0) {
                throw new SBException("Attempt to insert duplicate event: " + event);
            }
            if (event.getSortEntry().compareToIgnoreCase(current.getSortEntry()) < 0) {
                this.events.add(i, event);
                this.setChanged();
                return;
            }
            ++i;
        }
        this.events.add(event);
        this.setChanged();
    }

    void copyToWorkspace(WellEvent dbEvent, SBdb db, Well wsWell) throws SQLException, SBException {
        if (this.SB.isConnected()) {
            throw new IllegalStateException("Attempt to copy WellEvent to workspace when connected");
        }
        WellEvent.Builder builder = WellEvent.Builder.copyOf(dbEvent);
        Audit audit = new Audit(dbEvent.getAudit());
        audit.fillWorkspace(db, this.SB);
        builder.audit(audit);
        builder.sample(wsWell.getSample(dbEvent.getSample().getSampID()));
        builder.event(this.SB.fillEvent(db, dbEvent.getEvent()));
        int analyst = dbEvent.getAnalyst();
        if (analyst > 0) {
            this.SB.fillUser(db, analyst);
            builder.analyst(analyst);
        }
        WellEvent event = builder.build(this.SB);
        event.status = SbugsStatus.STORED;
        this.insertEvent(event);
    }

    void copyToDatabase(WellEvent wsEvent, SBdb ws, int wellID) throws SQLException, SBException {
        if (!this.SB.isConnected()) {
            throw new IllegalStateException("Attempt to copy WellEvent to datavase when not connected");
        }
        WellEvent.Builder builder = WellEvent.Builder.copyOf(wsEvent);
        builder.audit(new Audit(this.SB, ws, wsEvent.getAudit()));
        builder.sample(wsEvent.getSample().getLink());
        builder.event(wsEvent.getEvent().getLink());
        if (wsEvent.getAnalyst() > 0) {
            builder.analyst(ws.getUser(wsEvent.getAnalyst()).getLink().getUsrID());
        }
        WellEvent event = builder.build(this.SB, wellID, this.interpID);
        this.insertEvent(event);
    }

    public List<Fault> getFaults() {
        if (this.faults == null) {
            this.faults = new LinkedList<Fault>();
        }
        return this.faults;
    }

    public List<WellEvent> getEvents() {
        if (this.events == null) {
            this.events = new LinkedList<WellEvent>();
        }
        return this.events;
    }

    public List<WellEvent> getEventsByDepth() {
        this.getEvents();
        Collections.sort(this.events, new WellEventCompareDepth(true));
        return this.events;
    }

    public void deleteLOC(int wellID) throws SQLException {
        if (this.loc != null && this.SB != null && this.SB.isConnected()) {
            this.loc.delete(wellID, this.interpID);
            this.setChanged();
        }
        this.loc = null;
    }

    public LOC getLOC() {
        return this.loc;
    }

    public SbugsCompoundEdit deleteLOCNode(LOC.LOCNode node, int wellID) throws SQLException, InvalidFieldException, SBException {
        if (this.loc != null && this.SB != null && this.SB.isConnected()) {
            SbugsCompoundEdit edit = this.loc.deleteNode(wellID, this.interpID, node);
            this.setChanged();
            return edit;
        }
        return null;
    }

    public LOC.LOCNodeEdit addLOCNode(int bnd, double depth, double csu, int wellID) throws SQLException, InvalidFieldException {
        if (this.loc != null && this.SB != null && this.SB.isConnected()) {
            LOC.LOCNodeEdit edit = this.loc.addNode(bnd, depth, csu, wellID, this.interpID);
            this.setChanged();
            return edit;
        }
        return null;
    }

    public void loadLOC(int wellID) throws SQLException, SBException {
        if (this.loc != null) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT std_id,red,green,blue,linewidth," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("LOC") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        ResultSet rs = stmt.executeQuery(sql = this.SB.modQuery(sql));
        if (rs.next()) {
            int stdID = rs.getInt("std_id");
            int r = rs.getInt("red");
            int g = rs.getInt("green");
            int b = rs.getInt("blue");
            Color colour = new Color(r, g, b);
            float lineWidth = rs.getFloat("linewidth");
            this.loc = new LOC(this.SB, stdID, this.interpID, wellID, colour, lineWidth, new Audit(rs));
        }
        stmt.close();
    }

    public void addLOC(Well well, CompositeStandard cmpStd, double csu1, double depth1, double csu2, double depth2) throws SBException, SQLException {
        if (this.loc != null) {
            throw new IllegalArgumentException("Attempt to create new LOC for well interpretation when it already exists");
        }
        this.loc = new LOC(this.SB, cmpStd, well.wellID, this.interpID, depth1, depth2, csu1, csu2);
        boolean first = true;
        for (Sample sample : well.getSamples()) {
            if (sample.getAge(this.interpID) == null || !(Math.abs(sample.getAge(this.interpID)) > (double)0.0029f) && !first) continue;
            this.loc.addNode(sample.getDepth(), (double)sample.getAge(this.interpID), 3, well.getWellID(), this.interpID);
            first = false;
        }
        this.setChanged();
        this.notifyObservers(this.loc);
    }

    public void deriveLOC(IGDScheme scheme, Well well, CompositeStandard cmpStd) throws SQLException, SBException {
        if (scheme == null) {
            throw new IllegalArgumentException("No Interpretation Scheme selected");
        }
        List<IGDIntervalZone> zones = this.getIGDList(scheme.getIGDType(), scheme.getSchID());
        double lastDepth = -1.0;
        double lastCsu = -1.0;
        this.loc = new LOC(this.SB, cmpStd != null ? cmpStd.getStdID() : 0, this.interpID, well.wellID, Color.BLACK, 1.0f);
        this.loc.store(well.getWellID(), this.interpID);
        for (IGDIntervalZone zone : zones) {
            double lowDepth;
            if (zone.getSchID() != scheme.getID()) continue;
            IGDUnit uppUnit = scheme.findUnit(zone.getUppZone());
            IGDUnit lowUnit = scheme.findUnit(zone.getLowZone());
            if (uppUnit == null) continue;
            if (lowUnit == null) {
                lowUnit = uppUnit;
            }
            if ((lowDepth = zone.getTopSample().getDepth()) > lastDepth || Math.abs(lastCsu - uppUnit.getUage()) > 0.001) {
                this.loc.addNode(lowDepth, uppUnit.getUage(), 3, well.getWellID(), this.interpID);
            }
            lastDepth = zone.getBaseSample().getDepth();
            lastCsu = lowUnit.getLage();
            this.loc.addNode(lastDepth, lastCsu, 3, well.getWellID(), this.interpID);
        }
        this.loc.setUncf(well.getWellID(), this.interpID);
        this.setChanged();
        this.notifyObservers(this.loc);
    }

    public UndoableEdit updateLOCNode(LOC.LOCNode node, double depth, double age, int bnd, int wellID) throws SQLException, InvalidFieldException {
        UndoableEdit edit = null;
        try {
            edit = this.loc.updateNode(depth, age, bnd, node, wellID, this.interpID);
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        this.setChanged();
        this.notifyObservers(this.loc);
        return edit;
    }

    public int generateEvents(Well well, List<AnalystHeader> suites, boolean inFDO, boolean inLDO, boolean incCU, boolean incCO, boolean incSC, boolean incOC, String discs, boolean incRW, boolean incCV, boolean incQuestionable, CompositeStandard std, boolean useSynonym, int synSch, List<SBEvent.Builder> nonInserts) throws SQLException, SBException {
        well.loadAnalyses();
        if (std != null) {
            std.loadEvents();
        }
        HashMap<Integer, Smpdtl> bases = new HashMap<Integer, Smpdtl>();
        LinkedList<WellEvent> stored = new LinkedList<WellEvent>();
        stored.addAll(this.events);
        for (Sample sample : well.getSamples()) {
            String type = sample.getType();
            if (!(type.equals("CU") && incCU || type.equals("SC") && incSC || type.equals("CO") && incCO) && (!type.equals("OC") || !incOC)) continue;
            Iterator<Smpdtl> i$ = sample.analyses.iterator();
            while (i$.hasNext()) {
                Smpdtl sd;
                Smpdtl smpdtl = sd = i$.next();
                if (suites != null && !suites.contains(smpdtl.getHeader()) || discs.indexOf(smpdtl.getDiscID()) < 0) continue;
                smpdtl.load(well.wellID);
                for (TaxonOcc fss : smpdtl.getOccurUnsorted()) {
                    SBEvent event;
                    Object builder;
                    boolean genBase;
                    boolean genTop;
                    if (fss.getReworked() && !incRW || fss.getCaved() && !incCV || fss.getQuestionable() && !incQuestionable) continue;
                    boolean bl = genTop = std == null;
                    if (!inFDO) {
                        genTop = false;
                    }
                    boolean bl2 = genBase = std == null;
                    if (!inLDO) {
                        genBase = false;
                    }
                    SBEvent topEvent = null;
                    SBEvent baseEvent = null;
                    if (std != null) {
                        for (CompositeStandardEvent evt : std.getEvents()) {
                            Taxon taxon = evt.getEvent().getTaxon();
                            if (taxon == null || !evt.getEvent().isGenerate() || taxon.getSpecID() != fss.getSpecID() && (!useSynonym || taxon != this.SB.getPreferredTerm(synSch, fss.getSpecID()))) continue;
                            if (evt.getEvType() == 'F' && inFDO) {
                                genTop = true;
                                topEvent = evt.getEvent();
                                continue;
                            }
                            if (evt.getEvType() != 'L' || !inLDO) continue;
                            genBase = true;
                            baseEvent = evt.getEvent();
                        }
                    }
                    for (WellEvent wellEvent : stored) {
                        if (wellEvent.getEvent().getSpecID() != fss.getSpecID() && (!useSynonym || wellEvent.getEvent().getTaxon() == null || wellEvent.getEvent().getTaxon() != this.SB.getPreferredTerm(synSch, fss.getSpecID()))) continue;
                        if (wellEvent.getCharType() == 'F') {
                            genTop = false;
                            continue;
                        }
                        if (wellEvent.getCharType() != 'L') continue;
                        genBase = false;
                    }
                    String eventName = fss.getTaxon().toString(false, false);
                    if (genTop) {
                        if (topEvent == null && (topEvent = this.SB.getSBEventGenerate(fss.getTaxon().getSpecID())) == null) {
                            builder = new SBEvent.Builder().name(eventName).taxon(fss.getTaxon());
                            ((SBEvent.Builder)builder).desc("Generated from well data").isGenerate(true).isSingle(false);
                            event = this.SB.getSBEvent(eventName);
                            if (event != null) {
                                nonInserts.add((SBEvent.Builder)builder);
                                continue;
                            }
                            topEvent = this.SB.addSBEvent((SBEvent.Builder)builder);
                        }
                        builder = new WellEvent.Builder().event(topEvent).sample(smpdtl.getSample()).type(SBEvent.EventType.TOP).discID(Discipline.getDisc(smpdtl.getDiscID())).analyst(this.SB.getUserID(smpdtl.getAnalyst()));
                        ((WellEvent.Builder)builder).comments(std != null ? "Generated using: " + std : "");
                        stored.add(((WellEvent.Builder)builder).build(this.SB, well.getWellID(), this.interpID));
                    }
                    if (!genBase) continue;
                    if (baseEvent == null && (baseEvent = this.SB.getSBEventGenerate(fss.getTaxon().getSpecID())) == null) {
                        builder = new SBEvent.Builder().name(eventName).taxon(fss.getTaxon());
                        ((SBEvent.Builder)builder).desc("Generated from well data").isGenerate(true).isSingle(false);
                        event = this.SB.getSBEvent(eventName);
                        if (event != null) {
                            nonInserts.add((SBEvent.Builder)builder);
                            continue;
                        }
                        baseEvent = this.SB.addSBEvent((SBEvent.Builder)builder);
                    }
                    if (bases.get(baseEvent.getEvID()) != null) {
                        bases.remove(baseEvent.getEvID());
                    }
                    bases.put(baseEvent.getEvID(), smpdtl);
                }
            }
        }
        Set baseSet = bases.entrySet();
        for (Map.Entry entry : baseSet) {
            Smpdtl smpdtl = (Smpdtl)entry.getValue();
            WellEvent.Builder builder = new WellEvent.Builder().event(this.SB.getSBEvent((Integer)entry.getKey())).sample(smpdtl.getSample()).type(SBEvent.EventType.BASE).discID(Discipline.getDisc(smpdtl.getDiscID())).analyst(this.SB.getUserID(smpdtl.getAnalyst()));
            builder.comments(std != null ? "Generated using: " + std : "");
            stored.add(builder.build(this.SB, well.getWellID(), this.interpID));
        }
        int nAdded = stored.size() - this.events.size();
        this.events.clear();
        for (WellEvent event : stored) {
            this.insertEvent(event);
        }
        return nAdded;
    }

    public void generateEventsFromComments(List<Biocom> toUse, CompositeStandard cmpStd, Well well) throws SBException, SQLException, InvalidFieldException {
        if (toUse.isEmpty()) {
            return;
        }
        if (!this.comments.containsAll(toUse)) {
            throw new IllegalStateException("Using wrong interp to parse events");
        }
        HashMap<String, CompositeStandardEvent> map = new HashMap<String, CompositeStandardEvent>();
        HashMap<String, CompositeStandardEvent> abrMap = new HashMap<String, CompositeStandardEvent>();
        cmpStd.loadEvents();
        for (CompositeStandardEvent e : cmpStd.getEvents()) {
            String name = e.getEvent().getName().toUpperCase();
            map.put(name, e);
            String[] split = name.split(" ");
            if (split.length != 2) continue;
            abrMap.put(split[0].charAt(0) + ". " + split[1], e);
        }
        WellEvent notifier = null;
        for (Biocom biocom : toUse) {
            String[] tokens;
            for (String token : tokens = biocom.getText().split(",")) {
                SBEvent.EventType type;
                String[] smallTokens = (token = token.trim()).split(" ");
                if (smallTokens.length < 2 || (type = SBEvent.EventType.parseType(smallTokens[0])) == null) continue;
                CompositeStandardEvent e = (CompositeStandardEvent)map.get((token = token.substring(smallTokens[0].length()).trim().toUpperCase()).trim());
                if (e == null) {
                    e = (CompositeStandardEvent)abrMap.get(token);
                }
                if (e == null) {
                    for (String key : map.keySet()) {
                        if (!key.startsWith(token)) continue;
                        e = (CompositeStandardEvent)abrMap.get(key);
                        break;
                    }
                }
                if (e == null) {
                    for (String key : abrMap.keySet()) {
                        if (!key.startsWith(token)) continue;
                        e = (CompositeStandardEvent)abrMap.get(key);
                        break;
                    }
                }
                if (e == null) continue;
                notifier = this.addEvent(well, biocom.getSample(), e.getEvent(), type, null, null, "Generated from comments", null, null, null);
                System.out.println("Added event: " + notifier);
            }
        }
        if (notifier != null) {
            this.notifyObservers(notifier);
        }
    }

    public void deriveSampleAges(Well well, CompositeStandard cmpStd, char displayUnits) throws SQLException, SBException {
        List<Sample> samples = well.getSamples();
        well.deleteSampleAges(this.interpID);
        for (Sample sample : samples) {
        }
    }

    public List<Intcom> getIntcoms() {
        if (this.intcoms == null) {
            this.intcoms = new LinkedList<Intcom>();
        }
        return this.intcoms;
    }

    public List<SQPick> getSQPicks() {
        if (this.picks == null) {
            this.picks = new LinkedList<SQPick>();
        }
        return this.picks;
    }

    public List<SQPick> getSQPicks(int schID) {
        LinkedList<SQPick> p = new LinkedList<SQPick>();
        for (SQPick pick : this.getSQPicks()) {
            if (pick.getSurface().getSchID() != schID) continue;
            p.add(pick);
        }
        return p;
    }

    synchronized void refreshSQPicks(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded || this.picks == null) {
            return;
        }
        String sql = "SELECT samp_id,surface_id,updated ";
        sql = sql + " FROM " + this.SB.DBTableName("SQPICK") + " WHERE well_id=" + well.wellID + " AND interp_id=" + this.interpID;
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        SQPick notifier = null;
        HashSet<String> keys = new HashSet<String>();
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            int surfaceID = rs.getInt("surface_id");
            String key = "" + sampID + "|" + surfaceID;
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (SQPick p : this.picks) {
                String oKey = "" + p.getSampID() + "|" + p.getSurfaceID();
                if (!oKey.equals(key)) continue;
                found = true;
                if (time == null || p.getUpdated() != null && !time.after(p.getUpdated())) break;
                notifier = p = SQPick.load(this.SB, well, this.interpID, p.getSampID(), p.getSurfaceID(), p);
                break;
            }
            if (found) continue;
            notifier = SQPick.load(this.SB, well, this.interpID, sampID, surfaceID, null);
            this.insertPick(notifier);
        }
        if (keys.size() < this.picks.size()) {
            Iterator<SQPick> it = this.picks.iterator();
            while (it.hasNext()) {
                SQPick o = it.next();
                String oKey = "" + o.getSampID() + "|" + o.getSurfaceID();
                if (keys.contains(oKey)) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    synchronized void refreshFaults(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded || this.faults == null) {
            return;
        }
        String sql = "SELECT samp_id,updated ";
        sql = sql + " FROM " + this.SB.DBTableName("FAULTS") + " WHERE well_id=" + well.wellID + " AND interp_id=" + this.interpID;
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        Fault notifier = null;
        HashSet<String> keys = new HashSet<String>();
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            String key = "" + sampID;
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Fault o : this.faults) {
                String oKey = "" + o.getSample().getSampID();
                if (!oKey.equals(key)) continue;
                found = true;
                if (time == null || !time.after(o.getUpdated())) break;
                Fault fault = new Fault(this.SB, well, this.interpID, sampID);
                o.copy(fault);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = new Fault(this.SB, well, this.interpID, sampID);
            this.faults.add(notifier);
        }
        if (keys.size() < this.faults.size()) {
            Iterator<Fault> it = this.faults.iterator();
            while (it.hasNext()) {
                Fault o = it.next();
                String oKey = "" + o.getSample().getSampID();
                if (keys.contains(oKey)) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    synchronized void refreshIntcoms(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded || this.intcoms == null) {
            return;
        }
        String sql = "SELECT top_depth,updated ";
        sql = sql + " FROM " + this.SB.DBTableName("INTCMMNTS") + " WHERE well_id=" + well.wellID + " AND interp_id=" + this.interpID;
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        Intcom notifier = null;
        HashSet<String> keys = new HashSet<String>();
        while (rs.next()) {
            double topDepth = rs.getDouble("top_depth");
            String key = "" + Math.round(topDepth * 100.0);
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Intcom o : this.intcoms) {
                String oKey = "" + Math.round(o.getTopDepth() * 100.0);
                if (!oKey.equals(key)) continue;
                found = true;
                if (time == null || !time.after(o.getUpdated())) break;
                notifier = o = Intcom.load(this.SB, well.wellID, this.interpID, topDepth, o);
                break;
            }
            if (found) continue;
            notifier = Intcom.load(this.SB, well.wellID, this.interpID, topDepth, null);
            Intcom.insert(this.intcoms, notifier);
        }
        if (keys.size() < this.intcoms.size()) {
            Iterator<Intcom> it = this.intcoms.iterator();
            while (it.hasNext()) {
                Intcom o = it.next();
                String oKey = "" + Math.round(o.getTopDepth() * 100.0);
                if (keys.contains(oKey)) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    void loadIntcoms(Well well) throws SQLException {
        if (this.intcoms == null) {
            this.intcoms = new LinkedList<Intcom>();
        }
        this.intcoms.clear();
        Intcom.load(this.intcoms, this.SB, well.wellID, this.interpID);
    }

    public void loadSQPicks(Well well) throws SQLException {
        if (this.picks == null) {
            this.picks = new LinkedList<SQPick>();
        }
        this.picks.clear();
        String sql = "SELECT samp_id,sch_id,p.surface_id,inf,bnd,qualifier," + Audit.sqlFieldString("p");
        sql = sql + " FROM " + this.SB.DBTableName("SQPICK") + " p, " + this.SB.DBTableName("SURFACE") + " s " + " WHERE interp_id=" + this.interpID + " AND well_id=" + well.wellID + " AND s.surface_id=p.surface_id";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            int schID = rs.getInt("sch_id");
            IGDScheme scheme = this.SB.getIGDScheme(schID);
            int surfaceID = rs.getInt("surface_id");
            Surface surface = scheme.getSurface(surfaceID);
            String inf = rs.getString("inf");
            int bnd = rs.getInt("bnd");
            String strg = rs.getString("qualifier");
            boolean questionable = false;
            if (strg != null && strg.length() > 0 && strg.equals("?")) {
                questionable = true;
            }
            if (surface != null) {
                SQPick pick = new SQPick.Builder(this.SB, surface, well.getSample(sampID), bnd).informalName(inf).questionable(questionable).audit(new Audit(rs, "p")).build();
                this.insertPick(pick);
                continue;
            }
            System.out.println("Unable to load pick with null surface, sample: " + sampID + " surface: " + surfaceID);
        }
        stmt.close();
    }

    void loadFaults(Well well) throws SQLException {
        if (this.faults == null) {
            this.faults = new LinkedList<Fault>();
        }
        this.faults.clear();
        String sql = "SELECT samp_id,throw,label," + Audit.sqlFieldString();
        sql = sql + " FROM " + this.SB.DBTableName("FAULTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + well.wellID;
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            int faultThrow = rs.getInt("throw");
            String strg = rs.getString("label");
            Fault fault = new Fault(this.SB, well.getSample(sampID), faultThrow, strg, new Audit(rs));
            this.insertFault(fault);
        }
        stmt.close();
    }

    void insertFault(Fault fault) {
        if (this.faults == null) {
            this.faults = new LinkedList<Fault>();
        }
        int insertPoint = 0;
        for (Fault f : this.faults) {
            if (f.getSample().getDepth() > fault.getSample().getDepth()) break;
            ++insertPoint;
        }
        this.faults.add(insertPoint, fault);
    }

    void insertPick(SQPick pick) {
        if (this.picks == null) {
            this.picks = new LinkedList<SQPick>();
        }
        int insertPoint = 0;
        for (SQPick p : this.picks) {
            if (p.getSample().getDepth() > pick.getSample().getDepth()) break;
            ++insertPoint;
        }
        this.picks.add(insertPoint, pick);
    }

    public void deleteSQPick(SQPick pick, int wellID) throws SQLException {
        if (pick == null) {
            throw new IllegalArgumentException("Illegal argument to deleteSQPick: pick is null");
        }
        if (this.SB != null && this.SB.isConnected()) {
            if (wellID < 1) {
                throw new IllegalArgumentException("Illegal argument to deleteSQPick: wellID is " + wellID + ", pick is " + pick);
            }
            pick.delete(wellID, this.interpID);
        }
        this.picks.remove(pick);
        this.setChanged();
    }

    public void deleteSQPicks(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("SQPICK") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.picks.clear();
        this.setChanged();
    }

    public void deleteFault(Fault fault, int wellID) throws SQLException {
        if (fault == null) {
            throw new IllegalArgumentException("Illegal argument to deleteFault: wellID is " + wellID + ", fault is " + fault);
        }
        if (this.SB != null && this.SB.isConnected()) {
            if (wellID < 1) {
                throw new IllegalArgumentException("Illegal argument to deleteFault: wellID is " + wellID + ", fault is " + fault);
            }
            fault.delete(wellID, this.interpID);
        }
        this.faults.remove(fault);
        this.setChanged();
    }

    public void deleteFaults(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("FAULTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.faults.clear();
        this.setChanged();
    }

    public SQPick addSQPick(Well well, Sample sample, Surface surface, String informal, boolean questionable, String bnd) throws InvalidFieldException, SQLException {
        for (SQPick pick : this.getSQPicks()) {
            if (pick.getSample() != sample) continue;
            throw new InvalidFieldException("This sample is already picked for surface '" + pick.getSurface().getName() + "'");
        }
        int bndInt = IGDIntervalZone.getBoundaryTypeFromString(bnd);
        SQPick.Builder pickBuilder = new SQPick.Builder(this.SB, surface, sample, bndInt).informalName(informal).questionable(questionable);
        SQPick pick = this.SB != null && this.SB.isConnected() ? pickBuilder.build(well.getWellID(), this.interpID) : pickBuilder.build();
        this.insertPick(pick);
        this.setChanged();
        return pick;
    }

    public SQPick updateSQPick(SQPick original, Well well, Sample sample, Surface surface, String informal, boolean questionable, String bnd) throws InvalidFieldException, SQLException {
        for (SQPick pick : this.picks) {
            if (pick == original || pick.getSample() != sample) continue;
            throw new InvalidFieldException("There is already a pick at sample '" + sample.toString() + "'");
        }
        original.delete(well.getWellID(), this.interpID);
        int bndInt = IGDIntervalZone.getBoundaryTypeFromString(bnd);
        SQPick newPick = new SQPick.Builder(this.SB, surface, sample, bndInt).informalName(informal).questionable(questionable).build(well.getWellID(), this.interpID);
        this.picks.remove(original);
        this.insertPick(newPick);
        this.setChanged();
        return newPick;
    }

    public BiocomEdit addBiocom(Biocom.Builder builder, int wellID) throws InvalidFieldException, SQLException {
        for (Biocom bc : this.comments) {
            if (bc.getTopID() != builder.getTopSample().getSampID() || bc.getDiscID() != builder.getDiscID() || bc.getAnalyst() != builder.getAnalyst()) continue;
            throw new InvalidFieldException("A comment of this discipline/depth/analyst already exists");
        }
        BiocomEdit edit = new BiocomEdit(wellID, null, builder);
        edit.doEdit();
        return edit;
    }

    public Fault addFault(Well well, Sample sample, double faultThrow, String label) throws SQLException, InvalidFieldException {
        for (Fault fault : this.getFaults()) {
            if (fault.getSample() != sample) continue;
            throw new InvalidFieldException("There is already a fault at sample '" + sample.toString() + "'");
        }
        Fault fault = new Fault(this.SB, sample, well.getWellID(), faultThrow, label, this.interpID);
        this.insertFault(fault);
        this.setChanged();
        return fault;
    }

    public Fault updateFault(Well well, Fault original, Sample sample, double faultThrow, String label) throws SQLException, InvalidFieldException {
        for (Fault ft : this.faults) {
            if (ft == original || ft.getSample() != sample) continue;
            throw new InvalidFieldException("There is already a fault at sample: " + sample.toString());
        }
        original.delete(well.getWellID(), this.interpID);
        Fault newFault = new Fault(this.SB, sample, well.getWellID(), faultThrow, label, this.interpID);
        this.faults.remove(original);
        this.insertFault(newFault);
        this.setChanged();
        return newFault;
    }

    public Biocom updateBiocom(Biocom biocom, int wellID, Discipline discID, Sample topSample, Sample baseSample, String analyst, String dataSource, String text) throws SQLException, InvalidFieldException {
        for (Biocom bc : this.comments) {
            if (bc == biocom || bc.getTopID() != topSample.getSampID() || bc.getDiscipline() != discID || bc.getAnalyst() != this.SB.getUser(analyst).getUsrID()) continue;
            throw new InvalidFieldException("A comment of this discipline/depth/analyst already exists");
        }
        biocom.delete(wellID, this.interpID);
        Biocom b = new Biocom.Builder(this.SB, discID, this.SB.getUser(analyst).getUsrID(), topSample, text).source(dataSource).baseSample(baseSample).build(wellID, this.interpID, null);
        this.comments.remove(biocom);
        this.insertBiocom(b);
        this.setChanged();
        return biocom;
    }

    public BiocomEdit updateBiocom(Biocom original, Biocom.Builder builder, int wellID) throws SBException, SQLException {
        if (original != null && (original.getAnalyst() != builder.getAnalyst() || original.getTopSample().getSampID() != builder.getTopSample().getSampID() || original.getDiscID() != builder.getDiscID())) {
            for (Biocom bc : this.comments) {
                if (bc.getTopID() != builder.getTopSample().getSampID() || bc.getDiscipline() != builder.getDiscipline() || bc.getAnalyst() != builder.getAnalyst()) continue;
                throw new SBException("A comment of this discipline/depth/analyst already exists");
            }
        }
        BiocomEdit edit = new BiocomEdit(wellID, original, builder);
        edit.doEdit();
        return edit;
    }

    public void deleteBiocom(int wellID, Biocom biocom) throws SQLException {
        if (biocom == null) {
            throw new IllegalArgumentException("Illegal arguments to delete biocom from well ID: " + wellID + (biocom == null ? " (biocom is null)" : ""));
        }
        if (this.SB != null && this.SB.isConnected()) {
            if (wellID < 1) {
                throw new IllegalArgumentException("Illegal wellID in deleteBiocom: " + wellID);
            }
            biocom.delete(wellID, this.interpID);
        }
        this.comments.remove(biocom);
        this.setChanged();
    }

    public BiocomEdit deleteBiocom(Biocom biocom, int wellID) throws SBException, SQLException {
        BiocomEdit edit = new BiocomEdit(wellID, biocom, null);
        edit.doEdit();
        return edit;
    }

    public void deleteBiocoms(int wellID, char discID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID + "AND disc_id='" + discID + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        for (Biocom comment : this.comments) {
            if (comment.getDiscID() != discID) continue;
            this.comments.remove(comment);
        }
        this.setChanged();
    }

    public int getBoundaryAtSample(int igdType, Sample sample) {
        for (IGDIntervalZone zone : this.getIGDList(igdType)) {
            if (zone.getBaseSample() == sample) {
                return zone.getBaseBndInt();
            }
            if (zone.getTopSample() != sample) continue;
            return zone.getTopBndInt();
        }
        return -1;
    }

    public IGDIntervalZone addZone(IGDIntervalZone.Builder builder, Well well) throws InvalidFieldException, SBException, SQLException {
        this.checkOverlap(builder, null, true);
        IGDIntervalZone zone = this.SB != null && this.SB.isConnected() ? builder.build(well.getWellID(), this.interpID) : builder.build();
        this.insertZone(zone);
        for (Sample sample : well.getSamples()) {
            if (!(sample.getDepth() >= builder.topSample.getDepth()) || !(sample.getDepth() <= builder.baseSample.getDepth())) continue;
            sample.getStratigraphy(this, true);
        }
        this.setChanged();
        return zone;
    }

    public IGDIntervalEnv addEnvInterval(IGDIntervalEnv.Builder builder, int wellID) throws InvalidFieldException, SBException, SQLException {
        this.checkOverlap(builder.topSample, builder.baseSample, null);
        EnvEdit edit = new EnvEdit(wellID, null, builder);
        edit.doEdit();
        return edit.getEnv();
    }

    public EnvEdit updateEnvInterval(IGDIntervalEnv original, IGDIntervalEnv.Builder builder, int wellID) throws SQLException, InvalidFieldException {
        this.checkOverlap(builder.topSample, builder.baseSample, original);
        EnvEdit edit = new EnvEdit(wellID, original, builder);
        edit.doEdit();
        return edit;
    }

    public UndoableEdit updateEnvBoundary(Sample oldSample, Sample newSample, int wellID) throws SBException, SQLException, InvalidFieldException {
        Object edit;
        IGDIntervalEnv moveTop = null;
        IGDIntervalEnv moveBase = null;
        for (IGDIntervalEnv env : this.envs) {
            if (env.getTopSample() == oldSample) {
                moveTop = env;
                continue;
            }
            if (env.getBaseSample() == oldSample) {
                moveBase = env;
            }
            if (moveTop == null || moveBase == null) continue;
            break;
        }
        if (moveTop == null && moveBase == null) {
            System.out.println("Cannot find env interval to update");
            return null;
        }
        if (moveTop != null ^ moveBase != null) {
            edit = moveTop != null ? this.updateEnvInterval(moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), wellID) : this.updateEnvInterval(moveBase, IGDIntervalEnv.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), wellID);
        } else {
            boolean moveDown;
            edit = new SbugsCompoundEdit("Update env boundary");
            boolean bl = moveDown = newSample.getDepth() - oldSample.getDepth() > 0.0;
            if (moveDown) {
                if (newSample.getDepth() > moveTop.getBaseSample().getDepth()) {
                    throw new InvalidFieldException("New top is below base");
                }
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()))));
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveBase, IGDIntervalEnv.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample))));
            } else {
                if (newSample.getDepth() < moveBase.getTopSample().getDepth()) {
                    throw new InvalidFieldException("New base is above top");
                }
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveBase, IGDIntervalEnv.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample))));
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()))));
            }
            ((SbugsCompoundEdit)edit).doEdits();
        }
        return edit;
    }

    public IGDIntervalZone updateZone(IGDIntervalZone original, IGDIntervalZone.Builder builder, Well well) throws InvalidFieldException, SBException, SQLException {
        boolean boundaryChange = false;
        if (builder.getTopBndInt() != original.getTopBndInt() || builder.getBaseBndInt() != original.getBaseBndInt()) {
            if (builder.topSample.getSampID() == builder.baseSample.getSampID()) {
                if (builder.getTopBndInt() == builder.getBaseBndInt()) {
                    boundaryChange = true;
                }
            } else {
                boundaryChange = true;
            }
        }
        this.checkOverlap(builder, original, false);
        original.delete(well.getWellID(), this.interpID);
        IGDIntervalZone zone = builder.build(well.getWellID(), this.interpID);
        this.SB.commit();
        this.replaceZone(well, zone, original);
        if (boundaryChange) {
            List<IGDIntervalZone> list = this.getIGDList(builder.igdType);
            for (IGDIntervalZone z : list) {
                if (z.getTopID() == builder.topSample.getSampID() && z.getTopBndInt() != builder.getTopBndInt() && (!z.isSpotZone() || z.isSpotZone() && z.getTopBndInt() == z.getBaseBndInt())) {
                    z.setTopBnd(this.SB, well.wellID, this.interpID, builder.igdType, builder.getTopBndInt());
                    if (z.isSpotZone()) {
                        z.setBaseBnd(this.SB, well.wellID, this.interpID, builder.igdType, builder.getTopBndInt());
                    }
                }
                if (z.getBaseID() == builder.topSample.getSampID() && z.getBaseBndInt() != builder.getTopBndInt() && (!z.isSpotZone() || z.isSpotZone() && z.getTopBndInt() == z.getBaseBndInt())) {
                    z.setBaseBnd(this.SB, well.wellID, this.interpID, builder.igdType, builder.getTopBndInt());
                    if (z.isSpotZone()) {
                        z.setTopBnd(this.SB, well.wellID, this.interpID, builder.igdType, builder.getTopBndInt());
                    }
                }
                if (z.getBaseID() == builder.baseSample.getSampID() && z.getBaseBndInt() != builder.getBaseBndInt() && (!z.isSpotZone() || z.isSpotZone() && z.getTopBndInt() == z.getBaseBndInt())) {
                    z.setBaseBnd(this.SB, well.wellID, this.interpID, builder.igdType, builder.getBaseBndInt());
                    if (z.isSpotZone()) {
                        z.setTopBnd(this.SB, well.wellID, this.interpID, builder.igdType, builder.getBaseBndInt());
                    }
                }
                if (z.getTopID() != builder.baseSample.getSampID() || z.getTopBndInt() == builder.getBaseBndInt() || z.isSpotZone() && (!z.isSpotZone() || z.getTopBndInt() != z.getBaseBndInt())) continue;
                z.setTopBnd(this.SB, well.wellID, this.interpID, builder.igdType, builder.getBaseBndInt());
                if (!z.isSpotZone()) continue;
                z.setBaseBnd(this.SB, well.wellID, this.interpID, builder.igdType, builder.getBaseBndInt());
            }
        }
        this.setChanged();
        return zone;
    }

    public UndoableEdit updateIntervalBoundary(Sample oldSample, Sample newSample, int wellID, int igdType, int schID) throws InvalidFieldException, SBException, SQLException {
        boolean moveDown = newSample.getDepth() - oldSample.getDepth() > 0.0;
        Iterator<IGDIntervalZone> it = this.getIGDList(igdType, schID).iterator();
        IGDIntervalZone[] moveTops = new IGDIntervalZone[IGDIntervalZone.getNHier(igdType, true)];
        IGDIntervalZone[] moveBases = new IGDIntervalZone[IGDIntervalZone.getNHier(igdType, true)];
        while (it.hasNext()) {
            IGDIntervalZone zone = it.next();
            if (zone.getTopSample() == oldSample && (zone.getTopSample() != zone.getBaseSample() || !moveDown) && zone.getBaseSample().getDepth() > newSample.getDepth()) {
                moveTops[zone.getHier() - 1] = zone;
            }
            if (zone.getBaseSample() != oldSample || zone.getTopSample() == zone.getBaseSample() && !moveDown || !(zone.getTopSample().getDepth() < newSample.getDepth())) continue;
            moveBases[zone.getHier() - 1] = zone;
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Update interval boundary");
        try {
            for (int i = 0; i < moveTops.length; ++i) {
                IGDIntervalZone moveTop = moveTops[i];
                IGDIntervalZone moveBase = moveBases[i];
                if (moveTop == null && moveBase == null) continue;
                if (moveTop != null ^ moveBase != null) {
                    if (moveTop != null) {
                        edit.addEdit((UndoableEdit)((Object)this.updateInterval(moveTop, IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), wellID)));
                        continue;
                    }
                    edit.addEdit((UndoableEdit)((Object)this.updateInterval(moveBase, IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), wellID)));
                    continue;
                }
                SbugsCompoundEdit innerEdit = new SbugsCompoundEdit("Update interval boundary");
                if (moveDown) {
                    if (newSample.getDepth() > moveTop.getBaseSample().getDepth()) {
                        throw new InvalidFieldException("New top is below base");
                    }
                    innerEdit.addEdit((UndoableEdit)((Object)new ZoneEdit(wellID, moveTop, IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()))));
                    innerEdit.addEdit((UndoableEdit)((Object)new ZoneEdit(wellID, moveBase, IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample))));
                } else {
                    if (newSample.getDepth() < moveBase.getTopSample().getDepth()) {
                        throw new InvalidFieldException("New base is above top");
                    }
                    innerEdit.addEdit((UndoableEdit)((Object)new ZoneEdit(wellID, moveBase, IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample))));
                    innerEdit.addEdit((UndoableEdit)((Object)new ZoneEdit(wellID, moveTop, IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()))));
                }
                innerEdit.doEdits();
                edit.addEdit((UndoableEdit)innerEdit);
            }
        }
        catch (InvalidFieldException e) {
            if (edit.canRedo()) {
                edit.undo();
            }
            throw e;
        }
        catch (SBException e) {
            if (edit.canRedo()) {
                edit.undo();
            }
            throw e;
        }
        catch (SQLException e) {
            if (edit.canRedo()) {
                edit.undo();
            }
            throw e;
        }
        edit.end();
        return edit;
    }

    private ZoneEdit updateInterval(IGDIntervalZone original, IGDIntervalZone.Builder builder, int wellID) throws SQLException, InvalidFieldException, SBException {
        this.checkOverlap(builder, original, false);
        Boolean topSample = null;
        if (builder.topSample != original.getTopSample()) {
            topSample = true;
        } else if (builder.getBaseSample() != original.getBaseSample()) {
            topSample = false;
        }
        if (topSample != null) {
            List<IGDIntervalZone> zones = this.getIGDList(original.igdType, original.igdType == 4 ? original.getSchID() : 0);
            for (IGDIntervalZone zone : zones) {
                int builderBnd;
                if (zone == original) continue;
                Sample builderSample = topSample != false ? builder.topSample : builder.baseSample;
                int n = builderBnd = topSample != false ? builder.getTopBndInt() : builder.getBaseBndInt();
                if (zone.getTopSample() == builderSample && zone.getTopBndInt() != builderBnd) {
                    if (topSample.booleanValue()) {
                        builder.topBnd(zone.getTopBndInt());
                    } else {
                        builder.baseBnd(zone.getTopBndInt());
                    }
                }
                if (zone.getBaseSample() != builderSample || zone.getBaseBndInt() == builderBnd) continue;
                if (topSample.booleanValue()) {
                    builder.topBnd(zone.getBaseBndInt());
                    continue;
                }
                builder.baseBnd(zone.getBaseBndInt());
            }
        }
        ZoneEdit edit = new ZoneEdit(wellID, original, builder);
        edit.doEdit();
        return edit;
    }

    public void checkOverlap(IGDIntervalZone.Builder zone, IGDIntervalZone original, boolean checkBoundaries) throws InvalidFieldException, SBException, SQLException {
        List<IGDIntervalZone> zones = this.getIGDList(zone.igdType, 0);
        WellInterp.checkOverlap(zones, zone, original, checkBoundaries);
    }

    public static IGDIntervalZone checkOverlap(List<IGDIntervalZone> zones, IGDIntervalZone.Builder zone, IGDIntervalZone original, boolean checkBoundaries) throws InvalidFieldException, SBException, SQLException {
        if (zone.topSample == null || zone.baseSample == null) {
            throw new SBException("Zone passed to checkOverlap has null top/base sample: " + zone);
        }
        int nzTD = (int)(zone.topSample.getDepth('M') * 100.0);
        int nzBD = (int)(zone.baseSample.getDepth('M') * 100.0);
        for (int i = 0; i < zones.size(); ++i) {
            IGDIntervalZone compareWith = zones.get(i);
            if (compareWith == original || compareWith.getHier() != zone.getHier()) continue;
            int cTD = (int)(compareWith.topSample.getDepth('M') * 100.0);
            int cBD = (int)(compareWith.baseSample.getDepth('M') * 100.0);
            if (zone.igdType == 4 && zone.getSchID() != compareWith.getSchID()) continue;
            try {
                util.SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
            }
            catch (SBException sbe) {
                throw new InvalidFieldException("Error inserting interval : " + zone.getName() + " " + sbe.getMessage() + " " + compareWith.toString());
            }
            if (!checkBoundaries) continue;
            if (cBD == nzTD && compareWith.getBaseBndInt() != zone.getTopBndInt()) {
                throw new InvalidFieldException(zone.toString() + " " + "New interval boundary clashes with: " + compareWith.toString());
            }
            if (cTD != nzBD || compareWith.getTopBndInt() == zone.getBaseBndInt()) continue;
            throw new InvalidFieldException(zone.toString() + " " + "New interval boundary clashes with: " + compareWith.toString());
        }
        return zone.build();
    }

    public static IGDIntervalEnv checkOverlap(List<IGDIntervalEnv> zones, IGDIntervalEnv.Builder zone, IGDIntervalEnv original, boolean checkBoundaries) throws InvalidFieldException, SBException, SQLException {
        if (zone.topSample == null || zone.baseSample == null) {
            throw new SBException("Zone passed to checkOverlap has null top/base sample: " + zone);
        }
        int nzTD = (int)(zone.topSample.getDepth('M') * 100.0);
        int nzBD = (int)(zone.baseSample.getDepth('M') * 100.0);
        for (int i = 0; i < zones.size(); ++i) {
            IGDIntervalEnv compareWith = zones.get(i);
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.topSample.getDepth('M') * 100.0);
            int cBD = (int)(compareWith.baseSample.getDepth('M') * 100.0);
            try {
                util.SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
                continue;
            }
            catch (SBException sbe) {
                throw new InvalidFieldException("Error inserting interval : " + zone.toString() + " " + sbe.getMessage() + " " + compareWith.toString());
            }
        }
        return zone.build();
    }

    public void checkOverlap(Sample topSample, Sample baseSample, IGDIntervalEnv original) throws InvalidFieldException {
        int nzTD = (int)(topSample.getDepth('M') * 100.0);
        int nzBD = (int)(baseSample.getDepth('M') * 100.0);
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv compareWith = this.envs.get(i);
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.topSample.getDepth('M') * 100.0);
            int cBD = (int)(compareWith.baseSample.getDepth('M') * 100.0);
            try {
                util.SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
                continue;
            }
            catch (SBException sbe) {
                throw new InvalidFieldException("Error inserting palaeoenvironment: " + sbe.getMessage() + " " + compareWith.toString());
            }
        }
    }

    public void checkOverlap(Intcom.Builder intcomBuilder, Intcom original) throws InvalidFieldException {
        int nzTD = (int)(intcomBuilder.getTopDepth() * 100.0);
        int nzBD = (int)(intcomBuilder.getBaseDepth() * 100.0);
        for (int i = 0; i < this.intcoms.size(); ++i) {
            Intcom compareWith = this.intcoms.get(i);
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.getTopDepth() * 100.0);
            int cBD = (int)(compareWith.getBaseDepth() * 100.0);
            try {
                util.SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
                continue;
            }
            catch (SBException sbe) {
                String compareWithString = compareWith.toString().length() > 90 ? compareWith.toString().substring(0, 89) + "..." : compareWith.toString();
                throw new InvalidFieldException("Error inserting interval: " + sbe.getMessage() + " " + compareWithString);
            }
        }
    }

    public void replaceZone(Well well, IGDIntervalZone zone, IGDIntervalZone original) throws SBException, SQLException {
        this.removeZone(original);
        this.insertZone(zone);
        for (Sample sample : well.getSamples()) {
            if (!(sample.getDepth() >= zone.getTopSample().getDepth() && sample.getDepth() <= zone.getBaseSample().getDepth()) && (!(sample.getDepth() >= original.getTopSample().getDepth()) || !(sample.getDepth() <= original.getBaseSample().getDepth()))) continue;
            sample.getStratigraphy(this, true);
        }
    }

    public void deleteZone(Well well, IGDIntervalZone zone) throws SQLException, SBException {
        if (well == null || zone == null) {
            throw new IllegalArgumentException("Illegal argument to delete zone: well is " + well + " , zone is " + zone);
        }
        if (this.SB != null && this.SB.isConnected()) {
            zone.delete(well.getWellID(), this.interpID);
        }
        this.removeZone(zone);
        for (Sample sample : well.getSamples()) {
            if (!(sample.getDepth() >= zone.getTopSample().getDepth()) || !(sample.getDepth() <= zone.getBaseSample().getDepth())) continue;
            sample.getStratigraphy(this, true);
        }
    }

    public void deleteEnv(IGDIntervalEnv env, int wellID) throws SQLException {
        if (env == null) {
            throw new IllegalArgumentException("Illegal argument to deleteEnv: wellID is " + wellID + ", env is " + env);
        }
        if (this.SB != null && this.SB.isConnected()) {
            if (wellID < 1) {
                throw new IllegalArgumentException("Illegal argument to deleteEnv: wellID is " + wellID + ", env is " + env);
            }
            env.delete(wellID, this.interpID);
        }
        this.envs.remove(env);
        this.setChanged();
    }

    public void deleteEnvs(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.envs.clear();
        this.setChanged();
    }

    public void removeZone(IGDIntervalZone zone) {
        List<IGDIntervalZone> zones = this.getIGDList(zone.igdType, 0);
        zones.remove(zone);
        this.setChanged();
    }

    public void remove(IGDIntervalEnv zone) {
        this.envs.remove(zone);
        this.setChanged();
    }

    public void remove(Biocom biocom) {
        this.comments.remove(biocom);
        this.setChanged();
    }

    public void remove(Intcom intcom) {
        this.intcoms.remove(intcom);
        this.setChanged();
    }

    public void insertEnv(IGDIntervalEnv zone) {
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv insertPoint = this.envs.get(i);
            if (zone.topSample == null) break;
            if (!(zone.topSample.getDepth('M') < insertPoint.topSample.getDepth('M'))) continue;
            this.envs.add(i, zone);
            return;
        }
        this.envs.add(zone);
    }

    private static void insertZone(List<IGDIntervalZone> zones, IGDIntervalZone zone) throws SBException {
        for (int i = 0; i < zones.size(); ++i) {
            IGDIntervalZone insertPoint = zones.get(i);
            if (zone.topSample == null) break;
            if (insertPoint.topSample == null) continue;
            if (zone.topSample.getDepth('M') < insertPoint.topSample.getDepth('M')) {
                zones.add(i, zone);
                return;
            }
            if (zone.topSample.getDepth('M') != insertPoint.topSample.getDepth('M') || zone.getHier() > insertPoint.getHier()) continue;
            zones.add(i, zone);
            return;
        }
        zones.add(zone);
    }

    public void insertZone(IGDIntervalZone zone) throws SBException {
        List<IGDIntervalZone> zones = this.getIGDList(zone.igdType, 0);
        if (zones == null) {
            throw new SBException("Unrecognised IGD type in interval: '" + zone.toString() + "'");
        }
        WellInterp.insertZone(zones, zone);
    }

    public void insert(Intcom zone) {
        Intcom.insert(this.intcoms, zone);
    }

    public void store(int wellID) throws SQLException, SBException {
        IGDIntervalZone zone;
        int i;
        if (this.interpID == 0 && !this.interp.getDescription().equals("Default Version")) {
            throw new SBException("Attempt to store interpretation '" + this.interp.getDescription() + "' with zero ID");
        }
        for (i = 0; i < this.chrono.size(); ++i) {
            zone = this.chrono.get(i);
            zone.store(wellID, this.interpID);
        }
        for (i = 0; i < this.lstrat.size(); ++i) {
            zone = this.lstrat.get(i);
            zone.store(wellID, this.interpID);
        }
        for (i = 0; i < this.biozone.size(); ++i) {
            zone = this.biozone.get(i);
            zone.store(wellID, this.interpID);
        }
        this.storeComments(wellID);
        for (i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv env = this.envs.get(i);
            env.store(null, wellID, this.interpID);
        }
    }

    void storeComments(int wellID) throws SQLException {
        for (int i = 0; i < this.comments.size(); ++i) {
            Biocom comment = this.comments.get(i);
            comment.store(wellID, this.interpID);
        }
    }

    synchronized void refreshComments(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded || this.comments == null) {
            return;
        }
        String sql = "SELECT usamp_id,disc_id,analyst,updated ";
        sql = sql + " FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE well_id=" + well.wellID + " AND interp_id=" + this.interpID;
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        Biocom doNotify = null;
        HashSet<String> keyIDs = new HashSet<String>();
        while (rs.next()) {
            int sampID = rs.getInt("usamp_id");
            Discipline discID = Discipline.getDisc(util.SB.getDBChar((ResultSet)rs, (String)"disc_id"));
            int analystID = rs.getInt("analyst");
            keyIDs.add("" + (Object)((Object)discID) + sampID + analystID);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Biocom b : this.comments) {
                if (b.getTopID() != sampID || b.getDiscipline() != discID || b.getAnalyst() != analystID) continue;
                found = true;
                if (time == null || b.getUpdated() != null && !time.after(b.getUpdated())) break;
                doNotify = b = Biocom.load(this.SB, well, this.interpID, sampID, discID, analystID, b);
                break;
            }
            if (found) continue;
            doNotify = Biocom.load(this.SB, well, this.interpID, sampID, discID, analystID, null);
            this.insertBiocom(doNotify);
        }
        if (keyIDs.size() < this.comments.size()) {
            Iterator<Biocom> it = this.comments.iterator();
            while (it.hasNext()) {
                Biocom b = it.next();
                if (keyIDs.contains("" + b.getDiscID() + b.getTopID() + b.getAnalyst())) continue;
                it.remove();
                if (doNotify != null) continue;
                doNotify = b;
            }
        }
        if (doNotify != null) {
            this.setChanged();
            this.notifyObservers(doNotify);
        }
    }

    void loadComments(char discID, Well well) throws SQLException, SBException {
        if (well.wellID == 0) {
            return;
        }
        String sql = "SELECT usamp_id,lsamp_id,disc_id,analyst,comments,source," + Audit.sqlFieldString();
        sql = sql + " FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE well_id=" + well.wellID + " AND interp_id=" + this.interpID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        Iterator<Biocom> en = this.comments.iterator();
        while (en.hasNext()) {
            Biocom comment = en.next();
            if (comment.getDiscID() != discID) continue;
            en.remove();
        }
        well.getSamples();
        while (rs.next()) {
            int topID = rs.getInt("usamp_id");
            int baseID = rs.getInt("lsamp_id");
            if (baseID == topID) {
                baseID = 0;
            }
            Discipline d = Discipline.getDisc(util.SB.getDBChar((ResultSet)rs, (String)"disc_id"));
            int analyst = rs.getInt("analyst");
            String text = rs.getString("comments");
            if (text == null) {
                text = "";
            }
            String source = rs.getString("source");
            Sample topSample = well.getSample(topID);
            Sample baseSample = null;
            if (baseID > 0) {
                baseSample = well.getSample(baseID);
            }
            if (topSample != null) {
                try {
                    Biocom.Builder builder = new Biocom.Builder(this.SB, d, analyst, topSample, text);
                    builder.source(source).baseSample(baseSample).audit(new Audit(rs)).status(SbugsStatus.STORED);
                    this.insertBiocom(builder.build());
                }
                catch (IllegalStateException e) {
                    util.SB.showStackError((String)("Error loading comment: " + e.getMessage()), (Exception)e);
                }
                continue;
            }
            System.out.println("Error Loading: " + text + ", Sample ID: " + topID);
        }
        stmt.close();
    }

    void insertBiocom(Biocom biocom) {
        Iterator<Biocom> en = this.comments.iterator();
        int i = 0;
        while (en.hasNext()) {
            Biocom current = en.next();
            if (biocom.getTopSample().getDepth('M') < current.getTopSample().getDepth('M')) {
                this.comments.add(i, biocom);
                return;
            }
            ++i;
        }
        this.comments.add(biocom);
    }

    boolean hasBiocom(Biocom biocom) throws SBException {
        for (Biocom current : this.comments) {
            if (biocom.getTopID() != current.getTopID() || biocom.getDiscID() != current.getDiscID() || biocom.getAnalyst() != current.getAnalyst()) continue;
            return true;
        }
        return false;
    }

    boolean hasZone(IGDIntervalZone zone, int igdType) throws SBException {
        for (IGDIntervalZone current : this.getIGDList(igdType)) {
            if (zone.getTopID() != current.getTopID() || zone.getSchID() != current.getSchID() || zone.getHier() != current.getHier()) continue;
            return true;
        }
        return false;
    }

    synchronized void refreshZones(Statement stmt, int igdType, Well well, int schemeID) throws SQLException, SBException {
        if (!this.loaded) {
            return;
        }
        String sql = "SELECT top_id,sch_id,hier,updated FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND " + "interp_id=" + this.interpID + " AND well_id=" + well.wellID;
        if (schemeID > 0) {
            sql = sql + " AND sch_id=" + schemeID;
        }
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        IGDIntervalZone notifier = null;
        HashSet<String> keys = new HashSet<String>();
        List<IGDIntervalZone> zones = this.getIGDList(igdType);
        if (zones == null) {
            return;
        }
        while (rs.next()) {
            int topID = rs.getInt("top_id");
            int schID = rs.getInt("sch_id");
            int hier = rs.getInt("hier");
            String key = "" + topID + "|" + schID + "|" + hier;
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDIntervalZone o : zones) {
                if (!key.equals("" + o.getTopID() + "|" + o.getSchID() + "|" + o.getHier())) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                notifier = o = IGDIntervalZone.load(this.SB, igdType, topID, schID, this.interpID, well, hier, o);
                break;
            }
            if (found) continue;
            IGDIntervalZone zone = IGDIntervalZone.load(this.SB, igdType, topID, schID, this.interpID, well, hier, null);
            this.insertZone(zone);
            notifier = zone;
        }
        if (keys.size() < zones.size()) {
            Iterator<IGDIntervalZone> it = zones.iterator();
            while (it.hasNext()) {
                IGDIntervalZone zone = it.next();
                if (schemeID != 0 && zone.getSchID() != schemeID || keys.contains("" + zone.getTopID() + "|" + zone.getSchID() + "|" + zone.getHier())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = zone;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadZones(int igdType, Well well) throws SQLException, SBException {
        if (well.wellID == 0) {
            return;
        }
        this.getIGDList(igdType, 0).clear();
        String sql = "SELECT hier,top_id,base_id,top_analy,base_analy,top_bnd,base_bnd,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf,sep," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND " + " interp_id=" + this.interpID + " AND well_id=" + well.wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                int hier = rs.getInt("hier");
                int topID = rs.getInt("top_id");
                int baseID = rs.getInt("base_id");
                if (baseID == 0) {
                    System.out.println("Warning: baseID null in IGD for topID: " + topID + ", wellID: " + well.wellID + ", interpID: " + this.interpID + ", type: " + igdType);
                    baseID = topID;
                }
                int topAnalyst = rs.getInt("top_analy");
                int baseAnalyst = rs.getInt("base_analy");
                int topBnd = rs.getInt("top_bnd");
                int baseBnd = rs.getInt("base_bnd");
                int schID = rs.getInt("sch_id");
                String strg = rs.getString("q_uzone");
                boolean qUzone = strg != null && strg.charAt(0) == 'Y';
                int uppZone = rs.getInt("upp_zone");
                if (uppZone < 0) {
                    uppZone = 0;
                }
                String uppInf = rs.getString("upp_inf");
                strg = rs.getString("q_lzone");
                boolean qLzone = strg != null && strg.charAt(0) == 'Y';
                int lowZone = rs.getInt("low_zone");
                if (lowZone < 0) {
                    lowZone = 0;
                }
                String lowInf = rs.getString("low_inf");
                String sep = rs.getString("sep");
                IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.SB, igdType, well.getSample(topID), well.getSample(baseID), hier, schID);
                builder.topAnalyst(topAnalyst).baseAnalyst(baseAnalyst).topBnd(topBnd).baseBnd(baseBnd);
                builder.uppZone(uppZone).uppInf(uppInf).lowZone(lowZone).lowInf(lowInf).qUzone(qUzone).qLzone(qLzone).sep(sep).audit(new Audit(rs));
                builder.status = SbugsStatus.STORED;
                try {
                    this.insertZone(builder.build());
                }
                catch (IllegalStateException ise) {
                    if (ise.getMessage().startsWith("Reset Units: ")) {
                        try {
                            util.SB.showStackError((String)("Error building interval in well " + well.getWellName() + " - edit and re-save interval to reset this error."), (Exception)ise);
                            builder.uppZone(0).lowZone(0);
                            this.insertZone(builder.build());
                        }
                        catch (IllegalStateException ise2) {
                            util.SB.showStackError((String)("Error building Interval in well " + well.getWellName() + ": "), (Exception)ise2);
                        }
                        continue;
                    }
                    util.SB.showStackError((String)("Error building Interval in well " + well.getWellName() + ": "), (Exception)ise);
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    synchronized void refreshEnvs(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded || this.envs == null) {
            return;
        }
        String sql = "SELECT top_id,updated ";
        sql = sql + " FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE " + " interp_id=" + this.interpID + " AND well_id=" + well.wellID;
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        IGDIntervalEnv notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("top_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDIntervalEnv o : this.envs) {
                if (key != o.getTopID()) continue;
                found = true;
                if (time == null || !time.after(o.getUpdated())) break;
                notifier = o = IGDIntervalEnv.load(this.SB, o.getTopID(), this.interpID, well, o);
                break;
            }
            if (found) continue;
            IGDIntervalEnv zone = IGDIntervalEnv.load(this.SB, key, this.interpID, well, null);
            this.insertEnv(zone);
            notifier = zone;
        }
        if (keys.size() < this.envs.size()) {
            Iterator<IGDIntervalEnv> it = this.envs.iterator();
            while (it.hasNext()) {
                IGDIntervalEnv env = it.next();
                if (keys.contains(env.getTopID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = env;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    public void loadEnvs(Well well) throws SQLException, SBException {
        if (well.wellID == 0) {
            return;
        }
        this.envs.clear();
        String sql = "SELECT top_id,base_id,envsch_id,up,ud,lp,ld,qual," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE " + " interp_id=" + this.interpID + " AND well_id=" + well.wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int topID = rs.getInt("top_id");
            int baseID = rs.getInt("base_id");
            int schID = rs.getInt("envsch_id");
            EnvScheme scheme = null;
            if (schID > 0) {
                scheme = this.SB.getEnvScheme(schID);
            }
            int up = rs.getInt("up");
            int ud = rs.getInt("ud");
            int lp = rs.getInt("lp");
            int ld = rs.getInt("ld");
            int qual = rs.getInt("qual");
            Sample topSample = well.getSample(topID);
            Sample baseSample = well.getSample(baseID);
            IGDIntervalEnv.Builder builder = new IGDIntervalEnv.Builder(this.SB, topSample, baseSample, schID).up(up).ud(ud).lp(lp).ld(ld).qual(qual).audit(new Audit(rs));
            builder.status = IGDIntervalEnv.STORED;
            try {
                this.insertEnv(builder.build());
            }
            catch (IllegalStateException sbe) {
                if (sbe.getMessage().startsWith("Attempt to build env interval")) {
                    util.SB.showStackError((String)("Error building Environent Interval: interval reset: check interval at: " + topSample.toString() + " - " + baseSample.toString()), (Exception)sbe);
                    do {
                        if (ld == 0) {
                            ld = lp;
                        }
                        if (lp == 0) {
                            lp = up;
                        }
                        if (ud == 0) {
                            ud = up;
                        }
                        if (up != 0) continue;
                        up = 1;
                    } while (ld == 0 || lp == 0 || ud == 0 || up == 0);
                    builder.up(up).ud(ud).lp(lp).ld(ld);
                    this.insertEnv(builder.build());
                    continue;
                }
                throw sbe;
            }
        }
    }

    Sample getSample(List samples, int wellID, int ID, char units, char sectionType) throws SQLException, SBException {
        Sample sample2 = null;
        for (Sample sample2 : samples) {
            if (ID != sample2.getSampID()) continue;
            return sample2;
        }
        sample2 = new Sample(this.SB, wellID, ID, sectionType);
        Sample.insert(samples, sample2, units);
        return sample2;
    }

    void sortByDepth(int igdType) throws SBException {
        boolean swap = true;
        List<IGDIntervalZone> igd = this.getIGDList(igdType, 0);
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < igd.size(); ++i) {
                IGDInterval zone = igd.get(i);
                IGDInterval prevZone = igd.get(i - 1);
                if (zone.topSample == null || prevZone.topSample == null) {
                    throw new SBException("Null sample encountered during IGD sort");
                }
                if (!(zone.topSample.getDepth('M') < prevZone.topSample.getDepth('M'))) continue;
                igd.add(i - 1, (IGDIntervalZone)zone);
                igd.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    void sortEnvByDepth() throws SBException {
        boolean swap = true;
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < this.envs.size(); ++i) {
                IGDIntervalEnv zone = this.envs.get(i);
                IGDIntervalEnv prevZone = this.envs.get(i - 1);
                if (zone.topSample == null || prevZone.topSample == null) {
                    throw new SBException("Null sample encountered during palaeoenvironments sort");
                }
                if (!(zone.topSample.getDepth('M') < prevZone.topSample.getDepth('M'))) continue;
                this.envs.add(i - 1, zone);
                this.envs.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    void sortComments() throws SBException {
        boolean swap = true;
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < this.comments.size(); ++i) {
                Biocom comment = this.comments.get(i);
                Biocom prevComment = this.comments.get(i - 1);
                if (comment.getTopSample() == null || prevComment.getTopSample() == null) {
                    throw new SBException("Null sample encountered during comment sort");
                }
                if (!(comment.getTopSample().getDepth('M') < prevComment.getTopSample().getDepth('M'))) continue;
                this.comments.add(i - 1, comment);
                this.comments.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    public List<Biocom> getComments() {
        return this.comments;
    }

    public List<Biocom> getComments(char discID) {
        LinkedList<Biocom> discList = new LinkedList<Biocom>();
        for (Biocom biocom : this.comments) {
            if (biocom.getDiscID() != discID) continue;
            discList.add(biocom);
        }
        return discList;
    }

    public List<IGDIntervalEnv> getEnvs() {
        return this.envs;
    }

    public List<IGDIntervalZone> getIGDList(int igdType) {
        switch (igdType) {
            case 3: {
                return this.chrono;
            }
            case 2: {
                return this.lstrat;
            }
            case 4: {
                return this.biozone;
            }
        }
        return null;
    }

    public List<IGDIntervalZone> getIGDList(int igdType, int schID) {
        LinkedList<IGDIntervalZone> list;
        if (igdType == 10) {
            return null;
        }
        if (schID > 0) {
            list = new LinkedList();
            for (IGDIntervalZone zone : this.getIGDList(igdType)) {
                if (zone.getSchID() != schID) continue;
                list.add(zone);
            }
        } else {
            list = this.getIGDList(igdType);
        }
        return list;
    }

    public boolean hasData(int igdType) {
        if (igdType == 3 || igdType == 4 || igdType == 2) {
            return !this.getIGDList(igdType, 0).isEmpty();
        }
        if (igdType == 21) {
            return !this.getSQPicks().isEmpty();
        }
        if (igdType == 20) {
            return !this.getEvents().isEmpty();
        }
        if (igdType == 5) {
            return !this.getEnvs().isEmpty();
        }
        if (igdType == 19) {
            return !this.getComments().isEmpty();
        }
        if (igdType == 22) {
            return !this.getIntcoms().isEmpty();
        }
        System.out.println("WellInterp.hasData: Given data type did not match");
        return false;
    }

    public List<IGDIntervalZone> getIGDList(int igdType, int schID, int minHier, int maxHier) throws SBException, SQLException {
        LinkedList<IGDIntervalZone> list = new LinkedList<IGDIntervalZone>();
        for (int hier = maxHier; hier >= minHier; --hier) {
            for (IGDIntervalZone zone : this.getIGDList(igdType, schID)) {
                if (zone.getHier() != hier) continue;
                boolean toAdd = true;
                for (IGDIntervalZone zoneInList : list) {
                    if (zoneInList.checkDepthBracketing(zone)) continue;
                    toAdd = false;
                    break;
                }
                if (!toAdd) continue;
                WellInterp.insertZone(list, zone);
            }
        }
        return list;
    }

    @Deprecated
    public List<IGDIntervalZone> getIGDList(int igdType, int schID, int hier) throws SBException, SQLException {
        if (hier == 0) {
            return this.getIGDList(igdType, schID);
        }
        IGDScheme scheme = null;
        if (schID > 0) {
            this.SB.getIGDScheme(schID);
        }
        LinkedList list = new LinkedList();
        for (IGDIntervalZone zone : this.getIGDList(igdType, schID)) {
            double uAge;
            if (zone.getUppZone() <= 0) continue;
            if (scheme == null || scheme.getSchID() != schID) {
                scheme = this.SB.getIGDScheme(zone.getSchID());
            }
            double lAge = uAge = scheme.findUnit(zone.getUppZone()).getUage();
            lAge = zone.getLowZone() > 0 ? scheme.findUnit(zone.getLowZone()).getLage() : scheme.findUnit(zone.getUppZone()).getLage();
            IGDUnit unit = scheme.findUnit(uAge, lAge, hier);
            if (unit == null) continue;
        }
        LinkedList<IGDIntervalZone> zoneList = new LinkedList<IGDIntervalZone>();
        for (IGDIntervalZone.Builder builder : list) {
            zoneList.add(builder.build());
        }
        return zoneList;
    }

    public List<IGDScheme> getSequenceSchemes() throws SQLException {
        LinkedList<IGDScheme> list = new LinkedList<IGDScheme>();
        for (SQPick pick : this.getSQPicks()) {
            IGDScheme scheme;
            if (pick.getSurface().getSchID() <= 0) continue;
            boolean found = false;
            Iterator itS = list.iterator();
            while (itS.hasNext()) {
                if (((IGDScheme)itS.next()).getSchID() != pick.getSurface().getSchID()) continue;
                found = true;
                break;
            }
            if (found || (scheme = this.SB.getIGDScheme(pick.getSurface().getSchID())) == null) continue;
            list.add(scheme);
        }
        return list;
    }

    public EnvScheme getEnvScheme() throws SQLException, SBException {
        if (this.envs == null || this.envs.isEmpty()) {
            return null;
        }
        return this.SB.getEnvScheme(this.envs.get(0).getSchID());
    }

    public List<EnvScheme> getEnvSchemes() throws SQLException, SBException {
        this.SB.getEnvSchemes();
        LinkedList<EnvScheme> list = new LinkedList<EnvScheme>();
        for (IGDIntervalEnv env : this.getEnvs()) {
            EnvScheme scheme;
            if (env.getSchID() <= 0) continue;
            boolean found = false;
            Iterator itS = list.iterator();
            while (itS.hasNext()) {
                if (((EnvScheme)itS.next()).getID() != env.getSchID()) continue;
                found = true;
                break;
            }
            if (found || (scheme = this.SB.getEnvScheme(env.getSchID())) == null) continue;
            list.add(scheme);
        }
        return list;
    }

    public List<IGDScheme> getIGDSchemes(int igdType) throws SQLException {
        if (igdType == 10) {
            return this.getSequenceSchemes();
        }
        this.SB.getIGDSchemes(igdType);
        LinkedList<IGDScheme> list = new LinkedList<IGDScheme>();
        for (IGDIntervalZone zone : this.getIGDList(igdType)) {
            IGDScheme scheme;
            if (zone.getSchID() <= 0) continue;
            boolean found = false;
            Iterator itS = list.iterator();
            while (itS.hasNext()) {
                if (((IGDScheme)itS.next()).getSchID() != zone.getSchID()) continue;
                found = true;
                break;
            }
            if (found || (scheme = this.SB.getIGDScheme(zone.getSchID())) == null) continue;
            list.add(scheme);
        }
        return list;
    }

    boolean sampleIsUsed(int sampOrDonorID, List dataTypes) throws SBException {
        if (sampOrDonorID == 0) {
            return false;
        }
        Iterator it = dataTypes.iterator();
        while (it.hasNext()) {
            int columnType = (Integer)it.next();
            switch (columnType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    if (!this.sampleInComments(sampOrDonorID, SBdb.dt2discID(columnType))) break;
                    return true;
                }
                case 10: 
                case 11: 
                case 12: {
                    if (!this.sampleInIGD(sampOrDonorID, IGDInterval.dType2IGDtype(columnType))) break;
                    return true;
                }
                case 15: {
                    if (!this.sampleInEnv(sampOrDonorID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    void writeDEX(FileWriter out, char units, String eol, List dataTypes) throws IOException, SBException, SQLException {
        Iterator en = dataTypes.iterator();
        while (en.hasNext()) {
            int columnType = (Integer)en.next();
            switch (columnType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    this.writeDEXComments(out, eol, SBdb.dt2discID(columnType));
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    this.writeDEXIGDIntervals(out, units, eol, IGDInterval.dType2IGDtype(columnType));
                    break;
                }
                case 15: {
                    this.writeDEXEnvIntervals(out, units, eol);
                }
            }
        }
    }

    public LinkedList<Integer> writeXML(BufferedWriter out, char units, int ind, List<Integer> dataTypes) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        out.write("<WellInterpretationID>" + this.interpID + "</WellInterpretationID>\n");
        block9: for (int columnType : dataTypes) {
            switch (columnType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    userIDs.addAll(this.writeXMLComments(out, ind, SBdb.dt2discID(columnType), units));
                    continue block9;
                }
                case 10: 
                case 11: 
                case 12: {
                    userIDs.addAll(this.writeXMLIGDIntervals(out, units, ind, IGDInterval.dType2IGDtype(columnType)));
                    continue block9;
                }
                case 15: {
                    userIDs.addAll(this.writeXMLEnvIntervals(out, ind, units));
                    continue block9;
                }
                case 18: {
                    this.writeXMLIntcom(out, ind, units);
                    continue block9;
                }
                case 14: {
                    this.writeXMLPicks(out, ind, units);
                    continue block9;
                }
                case 17: {
                    this.writeXMLloc(out, ind, units);
                    continue block9;
                }
                case 16: {
                    this.writeXMLEvents(out, ind, units);
                    continue block9;
                }
            }
            if (!SBdb.isInterpDataType(columnType)) continue;
            System.out.println("WellInterp.writeXML:Cannot write XML for data type: " + columnType);
        }
        return userIDs;
    }

    WellInterp(SBdb db, WsWell well, Element xml, List<Integer> dataTypes) throws SQLException, SBException, ParseException {
        this.SB = db;
        this.sectionType = well.getType();
        String strg = xml.getChildTextNormalize("WellInterpretationID");
        if (strg != null) {
            this.interpID = Integer.parseInt(strg);
        }
        this.interp = db.getInterp(this.interpID);
        if (this.interp == null) {
            this.interp = new InterpHdr(db, this.interpID, xml.getAttributeValue("Description"));
        }
        Iterator it = xml.getContent((Filter)new ElementFilter("BiostratigraphicComment")).iterator();
        while (it.hasNext()) {
            Biocom biocom = Biocom.parse(db, well, (Element)it.next(), dataTypes);
            if (biocom.getText() == null || biocom.getText().length() <= 0) continue;
            this.comments.add(biocom);
        }
        it = xml.getContent((Filter)new ElementFilter("IGDInterval")).iterator();
        while (it.hasNext()) {
            IGDIntervalZone zone = new IGDIntervalZone(db, well, (Element)it.next());
            if (!dataTypes.contains(IGDInterval.igdType2dType(zone.getIGDType()))) {
                dataTypes.add(IGDInterval.igdType2dType(zone.getIGDType()));
            }
            this.insertZone(zone);
        }
        it = xml.getContent((Filter)new ElementFilter("EnvironmentInterval")).iterator();
        while (it.hasNext()) {
            IGDIntervalEnv env = IGDIntervalEnv.parse(db, well, (Element)it.next());
            if (!dataTypes.contains(15)) {
                dataTypes.add(15);
            }
            this.insertEnv(env);
        }
        it = xml.getContent((Filter)new ElementFilter("IntervalComment")).iterator();
        while (it.hasNext()) {
            Intcom intcom = new Intcom(db, (Element)it.next());
            if (!dataTypes.contains(18)) {
                dataTypes.add(18);
            }
            if (this.intcoms == null) {
                this.getIntcoms();
            }
            this.insert(intcom);
        }
        it = xml.getContent((Filter)new ElementFilter("SequencePick")).iterator();
        while (it.hasNext()) {
            SQPick pick = new SQPick(db, well, (Element)it.next());
            if (!dataTypes.contains(14)) {
                dataTypes.add(14);
            }
            if (this.picks == null) {
                this.getSQPicks();
            }
            this.insertPick(pick);
        }
        Element el = xml.getChild("LOC");
        if (el != null) {
            this.loc = new LOC(db, el);
            if (!dataTypes.contains(17)) {
                dataTypes.add(17);
            }
        }
        it = xml.getContent((Filter)new ElementFilter("WellEvent")).iterator();
        while (it.hasNext()) {
            WellEvent.Builder eventBuilder = WellEvent.parse(db, well, (Element)it.next());
            if (!dataTypes.contains(16)) {
                dataTypes.add(16);
            }
            if (this.events == null) {
                this.getEvents();
            }
            this.insertEvent(eventBuilder.build(db));
        }
    }

    void writeDEXComments(FileWriter out, String eol, char discID) throws IOException, SBException, SQLException {
        for (int i = 0; i < this.comments.size(); ++i) {
            Biocom comment = this.comments.get(i);
            if (comment.getDiscID() != discID) continue;
            comment.writeDEX(out, eol);
        }
    }

    LinkedList<Integer> writeXMLComments(BufferedWriter out, int indent, char discID, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        for (int i = 0; i < this.comments.size(); ++i) {
            Biocom comment = this.comments.get(i);
            if (comment.getDiscID() != discID || comment.getText().trim().isEmpty()) continue;
            userIDs.addAll(comment.writeXML(out, indent, units));
        }
        return userIDs;
    }

    void writeXMLIntcom(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        if (this.intcoms == null) {
            return;
        }
        for (Intcom intcom : this.intcoms) {
            intcom.writeXML(out, indent, units);
        }
    }

    void writeXMLPicks(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        if (this.picks == null) {
            return;
        }
        for (SQPick pick : this.picks) {
            pick.writeXML(out, indent, units);
        }
    }

    void writeXMLEvents(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        if (this.events == null) {
            return;
        }
        for (WellEvent event : this.events) {
            event.writeXML(out, indent, units);
        }
    }

    void writeXMLloc(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        if (this.loc == null) {
            return;
        }
        this.loc.writeXML(out, indent, units);
    }

    boolean sampleInComments(int sampOrDonorID, char discID) throws SBException {
        for (int i = 0; i < this.comments.size(); ++i) {
            Biocom comment = this.comments.get(i);
            if (comment.getDiscID() != discID) continue;
            if (comment.getTopSample() == null) {
                throw new SBException("Sample null in comment : " + comment);
            }
            if (comment.getTopSample().getSampID() != sampOrDonorID && (comment.getBaseSample() == null || comment.getBaseSample().getSampID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    void writeDEXIGDIntervals(FileWriter out, char units, String eol, int igdType) throws IOException, SBException, SQLException {
        List<IGDIntervalZone> igd = this.getIGDList(igdType, 0);
        for (int i = 0; i < igd.size(); ++i) {
            IGDIntervalZone zone = igd.get(i);
            zone.writeDEX(out, eol, units, util.SB.df);
            out.write(eol);
        }
    }

    LinkedList<Integer> writeXMLIGDIntervals(BufferedWriter out, char units, int ind, int igdType) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        List<IGDIntervalZone> igd = this.getIGDList(igdType, 0);
        for (int i = 0; i < igd.size(); ++i) {
            IGDIntervalZone zone = igd.get(i);
            userIDs.addAll(zone.writeXML(out, ind, units, this.SB));
        }
        return userIDs;
    }

    void writeDEXEnvIntervals(FileWriter out, char units, String eol) throws IOException, SBException, SQLException {
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv env = this.envs.get(i);
            env.writeDEX(out, eol, units, util.SB.df);
            out.write(eol);
        }
    }

    LinkedList<Integer> writeXMLEnvIntervals(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv env = this.envs.get(i);
            userIDs.addAll(env.writeXML(out, indent, units));
        }
        return userIDs;
    }

    boolean sampleInIGD(int sampOrDonorID, int igdType) throws SBException {
        List<IGDIntervalZone> igd = this.getIGDList(igdType, 0);
        for (int i = 0; i < igd.size(); ++i) {
            IGDIntervalZone zone = igd.get(i);
            if (zone.topSample.getSampID() != sampOrDonorID && (zone.baseSample == null || zone.baseSample.getSampID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    boolean sampleInEnv(int sampOrDonorID) throws SBException {
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv zone = this.envs.get(i);
            if (zone.topSample.getSampID() != sampOrDonorID && (zone.baseSample == null || zone.baseSample.getSampID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    void refreshDataRange(int wellID, int dType, DTMonitor monitor) throws SQLException, SBException {
        monitor.setStatus(DTMonitor.UNKNOWN);
        switch (dType) {
            case 3: {
                this.refreshBCMRange(wellID, 'M', monitor);
                break;
            }
            case 5: {
                this.refreshBCMRange(wellID, 'N', monitor);
                break;
            }
            case 7: {
                this.refreshBCMRange(wellID, 'P', monitor);
                break;
            }
            case 9: {
                this.refreshBCMRange(wellID, 'A', monitor);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this.refreshIGDRange(wellID, IGDInterval.dType2IGDtype(dType), monitor);
                break;
            }
            case 15: {
                this.refreshEnvRange(wellID, monitor);
                break;
            }
            case 18: {
                this.refreshIntcomRange(wellID, monitor);
                break;
            }
            case 14: {
                this.refreshSqpickRange(wellID, monitor);
                break;
            }
            case 17: {
                this.refreshLOCRange(wellID, monitor);
                break;
            }
            case 16: {
                this.refreshEventsRange(wellID, monitor);
                break;
            }
            default: {
                throw new SBException("No WellInterp status for data type: " + dType);
            }
        }
        if (monitor.getDepthFrom() > 99990.0 && monitor.getDepthTo() < -99990.0) {
            monitor.setDepthFrom(0.0);
            monitor.setDepthTo(0.0);
            monitor.setHasData(false);
        }
    }

    void refreshIGDRange(int wellID, int igdType, DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        List<IGDIntervalZone> list = this.getIGDList(igdType, 0);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                double topDepth;
                IGDInterval zone = list.get(i);
                hasDataLoaded = true;
                double baseDepth = topDepth = zone.getTopSample().getDepth('M');
                if (zone.getBaseSample() != null) {
                    baseDepth = zone.getBaseSample().getDepth('M');
                }
                if (baseDepth < topDepth) {
                    baseDepth = topDepth;
                }
                if (topDepth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(topDepth);
                }
                if (baseDepth > monitor.getDepthTo()) {
                    monitor.setDepthTo(baseDepth);
                }
                monitor.setHasData(true);
            }
        }
        if (!hasDataLoaded && wellID > 0 && this.SB.isConnected()) {
            String sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("igd") + " i WHERE s.well_id=" + wellID + " AND i.well_id=" + wellID + " AND i.igd_type=" + igdType + " AND (s.samp_id=i.top_id" + " OR s.samp_id=i.base_id)" + " AND interp_id=" + this.interpID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDataRanges(rs, "maxtop", "maxbot", "minbot", "mintop", this.SB.getDBType() == SBdb.DBType.SQLITE);
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshBCMRange(int wellID, char discID, DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        monitor.setHasData(false);
        boolean hasDataLoaded = false;
        if (this.comments.size() > 0) {
            for (int i = 0; i < this.comments.size(); ++i) {
                double topDepth;
                Biocom comment = this.comments.get(i);
                if (comment.getDiscID() != discID) continue;
                hasDataLoaded = true;
                double baseDepth = topDepth = comment.getTopSample().getDepth('M');
                if (comment.getBaseSample() != null) {
                    baseDepth = comment.getBaseSample().getDepth('M');
                }
                if (baseDepth < topDepth) {
                    baseDepth = topDepth;
                }
                if (topDepth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(topDepth);
                }
                if (baseDepth > monitor.getDepthTo()) {
                    monitor.setDepthTo(baseDepth);
                }
                monitor.setHasData(true);
            }
        }
        if (!hasDataLoaded && wellID > 0 && this.SB.isConnected()) {
            String sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("BCMMNTS") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.usamp_id AND s.well_id=b.well_id" + " AND b.disc_id='" + discID + "'" + " AND interp_id=" + this.interpID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDataRanges(rs, "maxtop", "maxbot", "minbot", "mintop", this.SB.getDBType() == SBdb.DBType.SQLITE);
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshEnvRange(int wellID, DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        if (this.envs.size() > 0) {
            for (int i = 0; i < this.envs.size(); ++i) {
                double topDepth;
                IGDIntervalEnv env = this.envs.get(i);
                hasDataLoaded = true;
                double baseDepth = topDepth = env.getTopSample().getDepth('M');
                if (env.getBaseSample() != null) {
                    baseDepth = env.getBaseSample().getDepth('M');
                }
                if (baseDepth < topDepth) {
                    baseDepth = topDepth;
                }
                if (topDepth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(topDepth);
                }
                if (baseDepth > monitor.getDepthTo()) {
                    monitor.setDepthTo(baseDepth);
                }
                monitor.setHasData(true);
            }
        }
        if (!hasDataLoaded && wellID > 0 && this.SB.isConnected()) {
            String sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("IGD_ENV") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.top_id AND s.well_id=b.well_id AND interp_id=" + this.interpID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.setDataRanges(rs, "maxtop", "maxbot", "minbot", "mintop", this.SB.getDBType() == SBdb.DBType.SQLITE);
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void getIGDschemes(List dataTypes, List igdSchemes, List envSchemes) throws SBException, SQLException {
        Iterator dtIt = dataTypes.iterator();
        while (dtIt.hasNext()) {
            int columnType = (Integer)dtIt.next();
            switch (columnType) {
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    List<IGDIntervalZone> igdList = this.getIGDList(IGDInterval.dType2IGDtype(columnType), 0);
                    for (IGDIntervalZone zone : igdList) {
                        if (zone.getSchID() <= 0) continue;
                        Iterator sch = igdSchemes.iterator();
                        boolean found = false;
                        while (sch.hasNext()) {
                            IGDScheme scheme = (IGDScheme)sch.next();
                            if (scheme.getSchID() != zone.getSchID()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        try {
                            igdSchemes.add(new IGDScheme(this.SB, zone.getSchID()));
                        }
                        catch (SBException sb) {
                            sb.printStackTrace();
                            throw new SBException("Zone: " + zone + ", " + sb.getMessage());
                        }
                    }
                    break;
                }
                case 15: {
                    for (IGDIntervalEnv env : this.envs) {
                        if (env.getSchID() <= 0) continue;
                        Iterator sch = envSchemes.iterator();
                        boolean found = false;
                        while (sch.hasNext()) {
                            EnvScheme scheme = (EnvScheme)sch.next();
                            if (scheme.getID() != env.getSchID()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        envSchemes.add(new EnvScheme(this.SB, env.getSchID()));
                    }
                    break;
                }
            }
        }
    }

    public static void loadCombo(SBdb SB2, DefaultComboBoxModel interps, boolean wellOnly, int wellID, char sectionType) throws SQLException {
        LinkedList list = new LinkedList();
        WellInterp.loadInterps(SB2, list, wellOnly, wellID, sectionType);
        interps.removeAllElements();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            interps.addElement(it.next());
        }
    }

    static void loadList(SBdb SB2, DefaultListModel interps, boolean wellOnly, int wellID, char sectionType) throws SQLException {
        LinkedList list = new LinkedList();
        WellInterp.loadInterps(SB2, list, wellOnly, wellID, sectionType);
        interps.removeAllElements();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            interps.addElement(it.next());
        }
    }

    static void loadInterps(SBdb SB2, List interps, boolean wellOnly, int wellID, char sectionType) throws SQLException {
        String description;
        boolean match;
        Iterator en;
        int interpID;
        interps.clear();
        String sql = !wellOnly || wellID == 0 ? "SELECT interp_id, descrip, created, creator FROM " + SB2.DBTableName("INTERP") : "SELECT DISTINCT i.interp_id, i.descrip, i.created, i.creator FROM " + SB2.DBTableName("INTERP") + " i," + SB2.DBTableName("IGD") + " g WHERE i.interp_id=g.interp_id" + " AND g.well_id=" + wellID;
        sql = sql + " ORDER BY descrip";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        InterpHdr interp = new InterpHdr(SB2, 0);
        interps.add(interp);
        while (rs.next()) {
            interpID = rs.getInt("interp_id");
            String description2 = rs.getString("descrip");
            interp = new InterpHdr(SB2, interpID, description2, new Audit(rs));
            interps.add(interp);
        }
        if (wellOnly && wellID != 0) {
            sql = "SELECT DISTINCT i.interp_id, i.descrip, i.created, i.creator FROM " + SB2.DBTableName("INTERP") + " i," + SB2.DBTableName("IGD_ENV") + " g WHERE i.interp_id=g.interp_id" + " AND g.well_id=" + wellID;
            sql = sql + " ORDER BY descrip";
            rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                interpID = rs.getInt("interp_id");
                en = interps.iterator();
                match = false;
                while (en.hasNext()) {
                    if (((WellInterp)en.next()).interpID != interpID) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                description = rs.getString("descrip");
                interp = new InterpHdr(SB2, interpID, description, new Audit(rs));
                interps.add(interp);
            }
        }
        if (wellOnly && wellID != 0) {
            sql = "SELECT DISTINCT i.interp_id, i.descrip, i.created, i.creator FROM " + SB2.DBTableName("INTERP") + " i," + SB2.DBTableName("BCMMNTS") + " g WHERE i.interp_id=g.interp_id" + " AND g.well_id=" + wellID + " ORDER BY descrip";
            rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                interpID = rs.getInt("interp_id");
                en = interps.iterator();
                match = false;
                while (en.hasNext()) {
                    if (((WellInterp)en.next()).interpID != interpID) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                description = rs.getString("descrip");
                interp = new InterpHdr(SB2, interpID, description, new Audit(rs));
                interps.add(interp);
            }
        }
        stmt.close();
    }

    void unloadEnv() {
        this.envs.clear();
    }

    void unloadBCM(char discID) {
        Iterator<Biocom> it = this.comments.iterator();
        while (it.hasNext()) {
            Biocom comm = it.next();
            if (comm.getDiscID() != discID) continue;
            it.remove();
        }
    }

    void unloadData(int dType) throws SBException {
        switch (dType) {
            case 3: {
                this.unloadBCM('M');
                break;
            }
            case 5: {
                this.unloadBCM('N');
                break;
            }
            case 7: {
                this.unloadBCM('P');
                break;
            }
            case 9: {
                this.unloadBCM('A');
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this.unloadIGD(IGDInterval.dType2IGDtype(dType));
                break;
            }
            case 15: {
                this.unloadEnv();
                break;
            }
            case 16: {
                this.unloadEvents();
                break;
            }
            case 17: {
                this.unloadLOCs();
                break;
            }
            case 18: {
                this.unloadIntcoms();
                break;
            }
            case 14: {
                this.unloadPicks();
            }
        }
    }

    void unloadIGD(int igdType) {
        this.getIGDList(igdType, 0).clear();
    }

    void unloadEvents() {
        if (this.events != null) {
            this.events.clear();
        }
    }

    void unloadLOCs() {
        this.loc = null;
    }

    void unloadIntcoms() {
        if (this.intcoms != null) {
            this.intcoms.clear();
            this.intcoms = null;
        }
    }

    void unloadPicks() {
        if (this.picks != null) {
            this.picks.clear();
            this.picks = null;
        }
    }

    public Intcom addIntcom(Well well, Intcom.Builder builder) throws InvalidFieldException, SQLException {
        this.checkOverlap(builder, null);
        Intcom intcom = this.SB.isConnected() ? builder.build(well.wellID, this.interpID) : builder.build();
        this.insert(intcom);
        this.setChanged();
        return intcom;
    }

    public Intcom updateIntcom(Intcom original, int wellID, double topDepth, double baseDepth, String comment) throws InvalidFieldException, SQLException {
        Intcom.Builder builder = new Intcom.Builder(this.SB, topDepth).baseDepth(baseDepth).comments(comment);
        this.checkOverlap(builder, original);
        original.delete(wellID, this.interpID);
        Intcom intcom = builder.build(wellID, this.interpID);
        this.intcoms.remove(original);
        this.insert(intcom);
        this.setChanged();
        return intcom;
    }

    public void deleteIntcom(int wellID, Intcom intcom) throws SQLException {
        if (intcom == null) {
            throw new IllegalArgumentException("Illegal argument to deleteIntcom: wellID is " + wellID + intcom == null ? ", intcom is " + intcom : "");
        }
        if (this.SB != null && this.SB.isConnected()) {
            if (wellID < 1) {
                throw new IllegalArgumentException("Illegal argument to deleteIntcom: wellID is " + wellID + intcom == null ? ", intcom is " + intcom : "");
            }
            intcom.delete(wellID, this.interpID);
        }
        this.intcoms.remove(intcom);
        this.setChanged();
    }

    public void deleteIntcoms(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("INTCMMNTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.intcoms.clear();
        this.setChanged();
    }

    String getStratigraphy(double depth) throws SBException {
        String strat = "";
        int hier = 0;
        for (IGDIntervalZone zone : this.chrono) {
            if (!(zone.getTopSample().getDepth() <= depth) || !(zone.getBaseSample().getDepth() >= depth) || zone.getHier() <= hier) continue;
            strat = zone.toString();
            hier = zone.getHier();
        }
        hier = 0;
        String bzString = "";
        for (IGDIntervalZone zone : this.biozone) {
            if (!(zone.getTopSample().getDepth() >= depth) || !(zone.getBaseSample().getDepth() <= depth) || zone.getHier() <= hier) continue;
            bzString = zone.toString();
            hier = zone.getHier();
        }
        if (!bzString.isEmpty()) {
            if (!strat.isEmpty()) {
                strat = strat + ",";
            }
            strat = strat + bzString;
        }
        if (!bzString.isEmpty()) {
            if (!strat.isEmpty()) {
                strat = strat + ",";
            }
            strat = strat + bzString;
        }
        return strat;
    }

    void store(WellInterp wellInterp, int wellID, List<Integer> dataTypes, SBdb ws) throws SBException, SQLException {
        block12: for (int dType : dataTypes) {
            switch (dType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    this.storeComments(wellInterp, wellID, SBdb.dt2discID(dType));
                    continue block12;
                }
                case 10: {
                    this.storeZones(wellInterp, wellID, dType);
                    continue block12;
                }
                case 12: {
                    this.storeZones(wellInterp, wellID, dType);
                    continue block12;
                }
                case 11: {
                    this.storeZones(wellInterp, wellID, dType);
                    continue block12;
                }
                case 13: {
                    throw new SBException("Attempt by wellInterp to store DTSEQUENCE type");
                }
                case 15: {
                    this.storeEnvs(wellInterp, wellID);
                    continue block12;
                }
                case 18: {
                    this.storeIntcom(wellInterp, wellID);
                    continue block12;
                }
                case 14: {
                    this.storeSqpicks(wellInterp, wellID);
                    continue block12;
                }
                case 17: {
                    this.storeLOC(wellInterp, wellID);
                    continue block12;
                }
                case 16: {
                    this.storeEvents(wellInterp, wellID, ws);
                    continue block12;
                }
            }
            if (!SBdb.isInterpDataType(dType)) continue;
            System.out.println("Cannot store interpeted data type: " + dType);
        }
    }

    public void storeComments(WellInterp wsWellInterp, int wellID, char discID) throws SBException, SQLException {
        for (Biocom wsBiocom : wsWellInterp.getComments()) {
            if (wsBiocom.getDiscID() != discID) continue;
            Biocom dbBiocom = null;
            for (Biocom db : this.comments) {
                if (!wsBiocom.isFuncEquivalent(db)) continue;
                dbBiocom = db;
                break;
            }
            if (dbBiocom != null) {
                if (wsBiocom.getStatus() != Biocom.PARTSTORED) continue;
                Biocom dbNewBiocom = Biocom.copyToDatabase(wsBiocom, this.SB);
                dbBiocom.update(dbNewBiocom, wellID, this.interpID);
                this.setChanged();
                continue;
            }
            dbBiocom = Biocom.copyToDatabase(wsBiocom, this.SB);
            dbBiocom.store(wellID, this.interpID);
            this.insertBiocom(dbBiocom);
            wsBiocom.status = Biocom.STORED;
            this.setChanged();
        }
    }

    public void storeZones(WellInterp wsWellInterp, int wellID, int dType) throws SBException, SQLException {
        this.storeZones(wsWellInterp.getIGDList(IGDInterval.dType2IGDtype(dType)), wellID, dType);
    }

    public void storeZones(List<IGDIntervalZone> wsZones, int wellID, int dType) throws SBException, SQLException {
        LinkedList<IGDIntervalZone> toStore = new LinkedList<IGDIntervalZone>();
        LinkedList<IGDIntervalZone> toCheck = new LinkedList<IGDIntervalZone>(this.getIGDList(IGDInterval.dType2IGDtype(dType)));
        for (IGDIntervalZone wsZone : wsZones) {
            IGDIntervalZone dbZone = null;
            for (IGDIntervalZone db : this.getIGDList(IGDInterval.dType2IGDtype(dType))) {
                if (!wsZone.isFuncEquivalent(db)) continue;
                dbZone = db;
                break;
            }
            if (dbZone != null) {
                if (wsZone.getStatus() != SbugsStatus.PARTSTORED) continue;
                dbZone.update(wsZone, wellID, this.interpID);
                wsZone.status = IGDInterval.STORED;
                this.setChanged();
                continue;
            }
            dbZone = new IGDIntervalZone(this.SB, wsZone);
            try {
                WellInterp.checkOverlap(toCheck, IGDIntervalZone.Builder.copyOf(dbZone), null, true);
            }
            catch (InvalidFieldException e) {
                throw new SBException(e.getMessage());
            }
            toCheck.add(dbZone);
            toStore.add(dbZone);
        }
        for (IGDIntervalZone zone : toStore) {
            zone.store(wellID, this.interpID);
            zone.status = IGDInterval.STORED;
        }
        for (IGDIntervalZone zone : toStore) {
            this.insertZone(zone);
            this.setChanged();
        }
    }

    void storeEnvs(WellInterp wsWellInterp, int wellID) throws SBException, SQLException {
        for (IGDIntervalEnv ws : wsWellInterp.envs) {
            IGDIntervalEnv dbEnv = null;
            for (IGDIntervalEnv db : this.envs) {
                if (!db.isFuncEquivalent(ws)) continue;
                dbEnv = db;
                break;
            }
            if (dbEnv != null) {
                if (ws.getStatus() != IGDInterval.PARTSTORED) continue;
                dbEnv.update(ws, wellID, this.interpID);
                ws.status = IGDInterval.STORED;
                this.setChanged();
                continue;
            }
            dbEnv = new IGDIntervalEnv(this.SB, ws);
            dbEnv.store(null, wellID, this.interpID);
            this.insertEnv(dbEnv);
            dbEnv.status = IGDInterval.STORED;
            this.setChanged();
        }
    }

    public void storeEnvs(List<IGDIntervalEnv> envs, int wellID) throws SBException, SQLException {
        LinkedList<IGDIntervalEnv> toStore = new LinkedList<IGDIntervalEnv>();
        LinkedList<IGDIntervalEnv> toCheck = new LinkedList<IGDIntervalEnv>();
        for (IGDIntervalEnv wsZone : envs) {
            IGDIntervalEnv dbZone = null;
            for (IGDIntervalEnv db : this.getEnvs()) {
                if (!wsZone.isFuncEquivalent(db)) continue;
                dbZone = db;
                break;
            }
            if (dbZone != null) {
                if (wsZone.getStatus() != SbugsStatus.PARTSTORED) continue;
                dbZone.update(wsZone, wellID, this.interpID);
                wsZone.status = IGDInterval.STORED;
                this.setChanged();
                continue;
            }
            dbZone = new IGDIntervalEnv(this.SB, wsZone);
            try {
                WellInterp.checkOverlap(toCheck, IGDIntervalEnv.Builder.copyOf(dbZone), null, true);
            }
            catch (InvalidFieldException e) {
                throw new SBException(e.getMessage());
            }
            toCheck.add(dbZone);
            toStore.add(dbZone);
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        for (IGDIntervalEnv zone : toStore) {
            zone.store(stmt, wellID, this.interpID);
            zone.status = IGDInterval.STORED;
        }
        for (IGDIntervalEnv zone : toStore) {
            this.insertEnv(zone);
            this.setChanged();
        }
        stmt.close();
    }

    void storeIntcom(WellInterp wsWellInterp, int wellID) throws SBException, SQLException {
        if (wsWellInterp.intcoms != null) {
            this.getIntcoms();
            for (Intcom ws : wsWellInterp.intcoms) {
                Intcom dbIntcom = null;
                for (Intcom db : this.intcoms) {
                    if (!db.getSortEntry().equals(ws.getSortEntry())) continue;
                    dbIntcom = db;
                    break;
                }
                if (dbIntcom != null) {
                    System.out.println("WellInterp.storeIntcom:attempt to udpate");
                    continue;
                }
                dbIntcom = new Intcom(ws, this.SB);
                dbIntcom.store(wellID, this.interpID);
                this.insert(dbIntcom);
                this.setChanged();
            }
        }
    }

    void storeSqpicks(WellInterp wsWellInterp, int wellID) throws SBException, SQLException {
        if (wsWellInterp.picks != null) {
            this.getSQPicks();
            for (SQPick ws : wsWellInterp.picks) {
                SQPick dbPick = null;
                for (SQPick db : this.picks) {
                    if (!ws.isFuncEquivalent(db)) continue;
                    dbPick = db;
                    break;
                }
                if (dbPick != null) {
                    System.out.println("WellInterp.storeSqpick:attempt to udpate");
                    continue;
                }
                if (ws.getSurface() == null || ws.getSurface().getLink() == null) {
                    throw new SBException("Attempt to store sequence pick with no matched surface: " + ws);
                }
                dbPick = new SQPick(this.SB, ws);
                dbPick.store(wellID, this.interpID);
                this.insertPick(dbPick);
                ws.status = SQPick.STORED;
                this.setChanged();
            }
        }
    }

    public void storeEvents(WellInterp wsWellInterp, int wellID, SBdb ws) throws SBException, SQLException {
        if (wsWellInterp.events != null) {
            this.getEvents();
            for (WellEvent wsEvent : wsWellInterp.events) {
                WellEvent dbEvent = null;
                for (WellEvent dbE : this.events) {
                    if (!wsEvent.isFuncEquivalent(dbE)) continue;
                    dbEvent = dbE;
                    break;
                }
                if (dbEvent != null) {
                    System.out.println("WellInterp.storeEvents:attempt to udpate");
                    continue;
                }
                if (wsEvent.getEvent().getLink() != null) {
                    this.copyToDatabase(wsEvent, ws, wellID);
                    continue;
                }
                System.out.println("WellInterp.storeEvents:Can't store unlinked event: " + ws);
            }
        }
    }

    void storeLOC(WellInterp wsWellInterp, int wellID) throws SBException, SQLException {
        if (wsWellInterp.loc == null) {
            return;
        }
        if (this.loc != null) {
            if (wsWellInterp.loc.equals(this.loc)) {
                return;
            }
            this.loc.delete(wellID, this.interpID);
        }
        this.loc = new LOC(wsWellInterp.loc, this.SB);
        this.loc.store(wellID, this.interpID);
        this.setChanged();
    }

    void refreshIntcomRange(int wellID, DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        if (this.intcoms != null && this.intcoms.size() > 0) {
            for (int i = 0; i < this.intcoms.size(); ++i) {
                Intcom intcom = this.intcoms.get(i);
                hasDataLoaded = true;
                double topDepth = intcom.getTopDepth();
                double baseDepth = intcom.getBaseDepth();
                if (baseDepth < topDepth) {
                    baseDepth = topDepth;
                }
                if (topDepth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(topDepth);
                }
                if (baseDepth > monitor.getDepthTo()) {
                    monitor.setDepthTo(baseDepth);
                }
                monitor.setHasData(true);
            }
        }
        if (!hasDataLoaded && wellID > 0 && this.SB.isConnected()) {
            String sql = "SELECT max(top_depth) as maxtop,max(base_depth) as maxbot,min(base_depth) as minbot,min(top_depth) as mintop FROM " + this.SB.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + this.interpID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double depth = rs.getDouble("maxtop");
                monitor.setDepthTo(rs.getDouble("maxbot"));
                if (depth > monitor.getDepthTo()) {
                    monitor.setDepthTo(depth);
                }
                depth = rs.getDouble("minbot");
                monitor.setDepthFrom(rs.getDouble("mintop"));
                if (depth > 0.0 && depth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(depth);
                }
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshSqpickRange(int wellID, DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        if (this.picks != null && this.picks.size() > 0) {
            for (int i = 0; i < this.picks.size(); ++i) {
                SQPick pick = this.picks.get(i);
                hasDataLoaded = true;
                double depth = pick.getSample().getDepth('M');
                if (depth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(depth);
                }
                if (depth > monitor.getDepthTo()) {
                    monitor.setDepthTo(depth);
                }
                monitor.setHasData(true);
            }
        }
        if (!hasDataLoaded && wellID > 0 && this.SB.isConnected()) {
            String sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("SQPICK") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.samp_id AND s.well_id=b.well_id AND interp_id=" + this.interpID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double depth = rs.getDouble("maxtop");
                monitor.setDepthTo(rs.getDouble("maxbot"));
                if (depth > monitor.getDepthTo()) {
                    monitor.setDepthTo(depth);
                }
                depth = rs.getDouble("minbot");
                monitor.setDepthFrom(rs.getDouble("mintop"));
                if (depth > 0.0 && depth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(depth);
                }
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    void refreshLOCRange(int wellID, DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        if (this.loc != null) {
            hasDataLoaded = true;
            monitor.setDepthFrom(this.loc.getTopDepth());
            monitor.setDepthTo(this.loc.getBaseDepth());
            monitor.setHasData(true);
        }
        if (!hasDataLoaded && wellID > 0 && this.SB.isConnected()) {
            String sql = "SELECT max(depth) as max,min(depth) as min FROM " + this.SB.DBTableName("LOCNODE") + " WHERE well_id=" + wellID + " AND interp_id=" + this.interpID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                BigDecimal depth = util.SB.getBigDecimal((ResultSet)rs, (String)"max", (this.SB.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                if (depth != null && depth.doubleValue() > monitor.getDepthTo()) {
                    monitor.setDepthTo(depth.doubleValue());
                    monitor.setHasData(true);
                }
                if ((depth = util.SB.getBigDecimal((ResultSet)rs, (String)"min", (this.SB.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0)) != null && depth.doubleValue() < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(depth.doubleValue());
                    monitor.setHasData(true);
                }
            }
            stmt.close();
        }
    }

    void refreshEventsRange(int wellID, DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        if (this.events != null && this.events.size() > 0) {
            for (int i = 0; i < this.events.size(); ++i) {
                WellEvent event = this.events.get(i);
                hasDataLoaded = true;
                double depth = event.getSample().getDepth('M');
                if (depth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(depth);
                }
                if (depth > monitor.getDepthTo()) {
                    monitor.setDepthTo(depth);
                }
                monitor.setHasData(true);
            }
        }
        if (!hasDataLoaded && wellID > 0 && this.SB.isConnected()) {
            String sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("EVENTS") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.samp_id AND s.well_id=b.well_id AND interp_id=" + this.interpID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double depth = rs.getDouble("maxtop");
                monitor.setDepthTo(rs.getDouble("maxbot"));
                if (depth > monitor.getDepthTo()) {
                    monitor.setDepthTo(depth);
                }
                depth = rs.getDouble("minbot");
                monitor.setDepthFrom(rs.getDouble("mintop"));
                if (depth > 0.0 && depth < monitor.getDepthFrom()) {
                    monitor.setDepthFrom(depth);
                }
                monitor.setHasData(true);
                if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                    monitor.setHasData(false);
                }
            } else {
                monitor.setHasData(false);
            }
            stmt.close();
        }
    }

    public void updateSQPickStatus(DTMonitor monitor, Well link, char wellUnits) throws SBException, SQLException {
        if (monitor == null) {
            throw new SBException("Data type monitor null in updateSQPickStatus");
        }
        monitor.setStatus(SbugsStatus.UNKNOWN);
        this.refreshSqpickRange(this.interpID, monitor);
        System.out.println("After SQPick refresh range: " + monitor.getStatusString());
        for (int iPick = 0; iPick < this.picks.size(); ++iPick) {
            SQPick pick = this.picks.get(iPick);
            if (monitor == null) continue;
            monitor.setHasData(true);
            if (link != null && link.wellID != 0) {
                pick.updateStatus(link.getInterp(this.interpID).getSQPicks());
            } else {
                pick.updateStatus(this.picks);
            }
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)pick.getStatus()));
        }
    }

    private boolean hasEnv(IGDIntervalEnv env) {
        for (IGDIntervalEnv current : this.envs) {
            if (env.getTopID() != current.getTopID()) continue;
            return true;
        }
        return false;
    }

    public void moveBiocom(Well well, Biocom biocom, WellInterp newWellInterp) throws SQLException, SBException {
        biocom.move(well.getWellID(), this.interpID, newWellInterp.interpID);
        this.remove(biocom);
        newWellInterp.insertBiocom(biocom);
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void copyBiocom(Well well, Biocom biocom, WellInterp newWellInterp) throws SQLException, SBException {
        newWellInterp.insertBiocom(Biocom.Builder.copyOf(biocom, newWellInterp.SB).build(well.getWellID(), newWellInterp.interpID, null));
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void copyIntcom(Well well, Intcom intcom, WellInterp newWellInterp, boolean deleteOriginal) throws SQLException, SBException, InvalidFieldException {
        if (newWellInterp == this) {
            throw new IllegalArgumentException("Illegal attempt to move interval comment: new version is the same as original version");
        }
        if (!this.intcoms.contains(intcom)) {
            throw new IllegalArgumentException("Illegal attempt to move interval comment: comment is not in version");
        }
        Intcom.Builder builder = Intcom.Builder.copyOf(intcom);
        newWellInterp.checkOverlap(builder, null);
        if (deleteOriginal) {
            intcom.move(well.getWellID(), this.interpID, newWellInterp.interpID);
            this.intcoms.remove(intcom);
        } else {
            intcom = builder.build(well.getWellID(), newWellInterp.interpID);
        }
        newWellInterp.insert(intcom);
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void copyLOC(int wellID, WellInterp newWellInterp, boolean deleteOriginal) throws SQLException, SBException {
        if (newWellInterp == this) {
            throw new IllegalArgumentException("Illegal attempt to move LOC: new version is the same as original version");
        }
        if (this.loc == null || newWellInterp.getLOC() != null && !newWellInterp.getLOC().getNodes().isEmpty()) {
            throw new IllegalArgumentException("Illegal attempt to move LOC: original is null or new interp already contains LOC");
        }
        LOC copy = new LOC(this.loc);
        copy.store(wellID, newWellInterp.getHeader().getInterpID());
        newWellInterp.loc = copy;
        if (deleteOriginal) {
            this.deleteLOC(wellID);
        }
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void moveZone(Well well, IGDIntervalZone zone, WellInterp newWellInterp) throws SQLException, SBException {
        zone.move(well.getWellID(), this.interpID, newWellInterp.interpID);
        this.removeZone(zone);
        newWellInterp.insertZone(zone);
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void moveEnv(Well well, IGDIntervalEnv zone, WellInterp newWellInterp) throws SQLException, SBException {
        zone.move(well.getWellID(), this.interpID, newWellInterp.interpID);
        this.remove(zone);
        newWellInterp.insertEnv(zone);
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void copyZone(int wellID, IGDIntervalZone zone, WellInterp newWellInterp) throws SQLException, SBException {
        newWellInterp.insertZone(IGDIntervalZone.Builder.copyOf(zone).build(wellID, newWellInterp.interpID));
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void copyEnv(Well well, IGDIntervalEnv zone, WellInterp newWellInterp) throws SQLException, SBException {
        newWellInterp.insertEnv(IGDIntervalEnv.Builder.copyOf(zone).build(well.getWellID(), newWellInterp.interpID, null));
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void copySQPick(Well well, SQPick pick, WellInterp newWellInterp, boolean deleteOriginal) throws InvalidFieldException, SQLException, SBException {
        if (newWellInterp == this) {
            throw new IllegalArgumentException("Illegal attempt to copy pick: new version is the same as original version");
        }
        if (!this.picks.contains(pick)) {
            throw new IllegalArgumentException("Illegal attempt to copy pick: event is not in version");
        }
        for (SQPick p : newWellInterp.getSQPicks()) {
            if (p.getSampID() != pick.getSampID()) continue;
            throw new InvalidFieldException("Sample '" + p.getSample() + "' already has a sequence pick");
        }
        if (deleteOriginal) {
            pick.move(well.getWellID(), this.interpID, newWellInterp.interpID);
            this.picks.remove(pick);
        } else {
            pick = SQPick.Builder.copyOf(pick).build(well.getWellID(), newWellInterp.interpID);
        }
        newWellInterp.insertPick(pick);
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void copyEvent(Well well, WellEvent event, WellInterp newWellInterp, boolean deleteOriginal) throws SBException, SQLException, InvalidFieldException {
        if (newWellInterp == this) {
            throw new IllegalArgumentException("Illegal attempt to move event: new version is the same as original version");
        }
        if (!this.events.contains(event)) {
            throw new IllegalArgumentException("Illegal attempt to move event: event is not in version");
        }
        for (WellEvent we : newWellInterp.getEventsByDepth()) {
            if (we.getSampID() == event.getSample().getSampID() && we.getSbEvent().getEvID() == event.getEvent().getEvID() && we.getCharType() == event.getCharType()) {
                throw new InvalidFieldException("Event '" + we + "' already exists");
            }
            if (!(we.getSample().getDepth() > event.getSample().getDepth())) continue;
            break;
        }
        if (deleteOriginal) {
            event.move(well.getWellID(), this.interpID, newWellInterp.interpID);
            this.events.remove(event);
        } else {
            WellEvent.Builder builder = WellEvent.Builder.copyOf(event).event(event.getEvent()).sample(event.getSample()).analyst(event.getAnalyst());
            event = builder.build(this.SB, well.getWellID(), newWellInterp.getHeader().getInterpID());
        }
        newWellInterp.insertEvent(event);
        newWellInterp.setChanged();
        this.setChanged();
    }

    public SQPick getSQPick(Sample sample) {
        if (this.picks != null) {
            for (SQPick pick : this.picks) {
                if (pick.getSample() != sample) continue;
                return pick;
            }
        }
        return null;
    }

    public void setColMap(int wellID, int igdType, IGDColMap colmap) throws SBException, SQLException {
        colmap.store(this.SB, wellID, this.interpID, igdType);
        this.colMap.remove(igdType);
        this.colMap.put(igdType, colmap);
        this.setChanged();
    }

    public void setChanged(IGDIntervalZone zone) {
        this.setChanged();
    }

    void mergeSamples(Sample donor, Sample target) {
        boolean hasChanged = false;
        if (this.chrono != null) {
            for (IGDIntervalZone iGDIntervalZone : this.chrono) {
                if (!iGDIntervalZone.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (this.biozone != null) {
            for (IGDIntervalZone iGDIntervalZone : this.biozone) {
                if (!iGDIntervalZone.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (this.lstrat != null) {
            for (IGDIntervalZone iGDIntervalZone : this.lstrat) {
                if (!iGDIntervalZone.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (this.envs != null) {
            for (IGDIntervalEnv iGDIntervalEnv : this.envs) {
                if (!iGDIntervalEnv.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (this.picks != null) {
            for (SQPick sQPick : this.picks) {
                if (!sQPick.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (this.events != null) {
            for (WellEvent wellEvent : this.events) {
                if (!wellEvent.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (this.comments != null) {
            for (Biocom biocom : this.comments) {
                if (!biocom.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (this.faults != null) {
            for (Fault fault : this.faults) {
                if (!fault.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (hasChanged) {
            this.setChanged();
        }
    }

    public void deleteLinkData(int dType, int wellID) throws SBException, SQLException {
        switch (dType) {
            case 10: 
            case 11: 
            case 12: {
                this.deleteZones(dType, wellID);
                break;
            }
            case 16: {
                this.deleteEvents(wellID);
                break;
            }
            case 15: {
                this.deleteEnvs(wellID);
                break;
            }
            case 3: {
                this.deleteBiocoms(wellID, 'M');
                break;
            }
            case 9: {
                this.deleteBiocoms(wellID, 'A');
                break;
            }
            case 7: {
                this.deleteBiocoms(wellID, 'P');
                break;
            }
            case 5: {
                this.deleteBiocoms(wellID, 'N');
                break;
            }
            case 14: {
                this.deleteSQPicks(wellID);
                break;
            }
            case 18: {
                this.deleteIntcoms(wellID);
                break;
            }
            case 27: {
                this.deleteFaults(wellID);
                break;
            }
            case 17: {
                this.deleteLOC(wellID);
                break;
            }
            default: {
                throw new SBException("Interp tried to delete unrecognised data type: " + dType);
            }
        }
    }

    public class ZoneEdit
    extends SbugsEdit {
        final IGDIntervalZone originalZone;
        final int wellID;
        IGDIntervalZone.Builder builder;
        IGDIntervalZone newZone;
        final String presentationName;

        private ZoneEdit(int wellID, IGDIntervalZone originalZone, IGDIntervalZone.Builder builder) {
            this.originalZone = originalZone;
            this.builder = builder;
            this.wellID = wellID;
            String s = originalZone != null && builder != null ? "update interval" : (originalZone != null ? "delete interval" : "new interval");
            this.presentationName = s;
        }

        public void undo() {
            try {
                if (this.newZone != null) {
                    this.deleteActionDB(this.newZone);
                }
                if (this.originalZone != null) {
                    this.insertActionDB(this.originalZone);
                }
                WellInterp.this.SB.commit();
                if (this.newZone != null) {
                    this.deleteActionModel(this.newZone);
                }
                if (this.originalZone != null) {
                    this.insertActionModel(this.originalZone);
                }
            }
            catch (Exception e) {
                WellInterp.this.SB.doRollback();
                e.printStackTrace();
                throw new RuntimeException("Error undoing interval edit", e);
            }
            WellInterp.this.setChanged();
            WellInterp.this.notifyObservers(this.originalZone != null ? this.originalZone : this.newZone);
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalZone != null) {
                    this.deleteActionDB(this.originalZone);
                }
                if (!(built = this.buildNewZone()) && this.newZone != null) {
                    this.insertActionDB(this.newZone);
                }
                WellInterp.this.SB.commit();
                if (this.originalZone != null) {
                    this.deleteActionModel(this.originalZone);
                }
                if (this.newZone != null) {
                    this.insertActionModel(this.newZone);
                }
            }
            catch (Exception e) {
                WellInterp.this.SB.doRollback();
                e.printStackTrace();
                throw new RuntimeException("Error redoing interval edit", e);
            }
            WellInterp.this.setChanged();
            WellInterp.this.notifyObservers(this.newZone != null ? this.newZone : this.originalZone);
            super.redo();
        }

        private boolean buildNewZone() throws SQLException, SBException {
            if (this.builder == null) {
                return false;
            }
            this.newZone = this.builder.build(this.wellID, WellInterp.this.interpID);
            this.builder = null;
            return true;
        }

        private void insertActionDB(IGDIntervalZone zone) throws SQLException, SBException {
            zone.store(this.wellID, WellInterp.this.interpID);
        }

        private void insertActionModel(IGDIntervalZone zone) throws SBException {
            WellInterp.this.insertZone(zone);
        }

        private void deleteActionDB(IGDIntervalZone zone) throws SQLException, SBException {
            zone.delete(this.wellID, WellInterp.this.interpID);
        }

        private void deleteActionModel(IGDIntervalZone zone) {
            if (!WellInterp.this.getIGDList(zone.igdType).remove(zone)) {
                System.out.println("WARNING: did deleteActionModel did not work");
            }
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public IGDIntervalZone getZone() {
            return this.newZone;
        }
    }

    public class EnvEdit
    extends SbugsEdit {
        final IGDIntervalEnv originalEnv;
        final int wellID;
        IGDIntervalEnv.Builder builder;
        IGDIntervalEnv newEnv;
        final String presentationName;

        private EnvEdit(int wellID, IGDIntervalEnv originalEnv, IGDIntervalEnv.Builder builder) {
            this.originalEnv = originalEnv;
            this.builder = builder;
            this.wellID = wellID;
            String s = originalEnv != null && builder != null ? "update environment" : (originalEnv != null ? "delete environment" : "new environment");
            this.presentationName = s;
        }

        public void undo() {
            try {
                if (this.newEnv != null) {
                    this.deleteActionDB(this.newEnv);
                }
                if (this.originalEnv != null) {
                    this.insertActionDB(this.originalEnv);
                }
                WellInterp.this.SB.commit();
            }
            catch (Exception e) {
                WellInterp.this.SB.doRollback();
                throw new RuntimeException("Error undoing environment edit", e);
            }
            if (this.newEnv != null) {
                this.deleteActionModel(this.newEnv);
            }
            if (this.originalEnv != null) {
                this.insertActionModel(this.originalEnv);
            }
            WellInterp.this.setChanged();
            WellInterp.this.notifyObservers(this.originalEnv != null ? this.originalEnv : this.newEnv);
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalEnv != null) {
                    this.deleteActionDB(this.originalEnv);
                }
                if (!(built = this.buildNewEnv()) && this.newEnv != null) {
                    this.insertActionDB(this.newEnv);
                }
                WellInterp.this.SB.commit();
            }
            catch (Exception e) {
                WellInterp.this.SB.doRollback();
                throw new RuntimeException("Error redoing environment edit", e);
            }
            if (this.originalEnv != null) {
                this.deleteActionModel(this.originalEnv);
            }
            if (this.newEnv != null) {
                this.insertActionModel(this.newEnv);
            }
            WellInterp.this.setChanged();
            WellInterp.this.notifyObservers(this.newEnv != null ? this.newEnv : this.originalEnv);
            super.redo();
        }

        private boolean buildNewEnv() throws SQLException, SBException {
            if (this.builder == null) {
                return false;
            }
            this.newEnv = this.builder.build(this.wellID, WellInterp.this.interpID, null);
            this.builder = null;
            return true;
        }

        private void insertActionDB(IGDIntervalEnv env) throws SQLException, SBException {
            env.store(null, this.wellID, WellInterp.this.interpID);
        }

        private void insertActionModel(IGDIntervalEnv env) {
            WellInterp.this.insertEnv(env);
        }

        private void deleteActionDB(IGDIntervalEnv env) throws SQLException {
            env.delete(this.wellID, WellInterp.this.interpID);
        }

        private void deleteActionModel(IGDIntervalEnv env) {
            WellInterp.this.envs.remove(env);
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public IGDIntervalEnv getEnv() {
            return this.newEnv;
        }
    }

    public class BiocomEdit
    extends SbugsEdit {
        final Biocom originalComment;
        final int wellID;
        Biocom.Builder builder;
        Biocom newComment;
        final String presentationName;

        private BiocomEdit(int wellID, Biocom originalComment, Biocom.Builder builder) {
            this.originalComment = originalComment;
            this.builder = builder;
            this.wellID = wellID;
            String s = originalComment != null && builder != null ? "update comment" : (originalComment != null ? "delete comment" : "new comment");
            this.presentationName = s;
        }

        public void undo() {
            try {
                if (this.newComment != null) {
                    this.deleteActionDB(this.newComment);
                }
                if (this.originalComment != null) {
                    this.insertActionDB(this.originalComment);
                }
                WellInterp.this.SB.commit();
                WellInterp.this.setChanged();
                WellInterp.this.notifyObservers(this.originalComment != null ? this.originalComment : this.newComment);
            }
            catch (Exception e) {
                WellInterp.this.SB.doRollback();
                throw new RuntimeException("Error undoing biocom edit", e);
            }
            if (this.newComment != null) {
                this.deleteActionModel(this.newComment);
            }
            if (this.originalComment != null) {
                this.insertActionModel(this.originalComment);
            }
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalComment != null) {
                    this.deleteActionDB(this.originalComment);
                }
                if (!(built = this.buildNewComment()) && this.newComment != null) {
                    this.insertActionDB(this.newComment);
                }
                WellInterp.this.SB.commit();
            }
            catch (SQLException e) {
                WellInterp.this.SB.doRollback();
                throw new RuntimeException("Error redoing biocom edit", e);
            }
            if (this.originalComment != null) {
                this.deleteActionModel(this.originalComment);
            }
            if (this.newComment != null) {
                this.insertActionModel(this.newComment);
            }
            WellInterp.this.setChanged();
            WellInterp.this.notifyObservers(this.newComment != null ? this.newComment : this.originalComment);
            super.redo();
        }

        private boolean buildNewComment() throws SQLException {
            if (this.builder == null) {
                return false;
            }
            this.newComment = this.builder.build(this.wellID, WellInterp.this.interpID, null);
            this.builder = null;
            return true;
        }

        private void insertActionDB(Biocom bc) throws SQLException {
            bc.store(this.wellID, WellInterp.this.interpID);
        }

        private void insertActionModel(Biocom bc) {
            WellInterp.this.insertBiocom(bc);
        }

        private void deleteActionDB(Biocom bc) throws SQLException {
            bc.delete(this.wellID, WellInterp.this.interpID);
        }

        private void deleteActionModel(Biocom bc) {
            WellInterp.this.comments.remove(bc);
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public Biocom getBiocom() {
            return this.newComment;
        }
    }
}

