/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import model2.SBdb;
import model2.WellHeader;
import util.SBException;

public class WellSearchResult {
    String wellName;
    String wellCode;
    String country;
    String field;
    String oper;
    String county;
    String location;
    char units;
    int wellID;

    public String getWellName() {
        return this.wellName;
    }

    public String getWellCode() {
        return this.wellCode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCounty() {
        return this.county;
    }

    public String getField() {
        return this.field;
    }

    public String getOperator() {
        return this.oper;
    }

    public int getWellID() {
        return this.wellID;
    }

    public char getUnits() {
        return this.units;
    }

    public static List search(SBdb SB2, String wellName, String wellCode, String country, String field, String oper, String county) throws SQLException {
        LinkedList<WellSearchResult> results = new LinkedList<WellSearchResult>();
        String sql = "SELECT well_name,w.well_code,country,field,operator,county,well_id FROM " + SB2.DBTableName("WELLS") + " w," + SB2.DBTableName("WELL_IDENT") + " v WHERE w.well_code=v.well_code ";
        if (wellName.compareTo("%") > 0) {
            sql = sql + " AND ucase(well_name) like '" + wellName.trim().toUpperCase() + "'";
        }
        if (wellCode.compareTo("%") > 0) {
            sql = sql + " AND ucase(w.well_code) like '" + wellCode.trim().toUpperCase() + "'";
        }
        if (country.compareTo("%") > 0) {
            sql = sql + " AND ucase(country) like '" + country.trim().toUpperCase() + "'";
        }
        if (field.compareTo("%") > 0) {
            sql = sql + " AND ucase(field) like '" + field.trim().toUpperCase() + "'";
        }
        if (county.compareTo("%") > 0) {
            sql = sql + " AND ucase(county) like '" + county.trim().toUpperCase() + "'";
        }
        if (oper.compareTo("%") > 0) {
            sql = sql + " AND ucase(operator) like '" + oper.trim().toUpperCase() + "'";
        }
        sql = sql + " ORDER BY ucase(well_name),ucase(w.well_code),ucase(country),ucase(field)";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            WellSearchResult result = new WellSearchResult();
            result.wellName = rs.getString("well_name");
            result.wellCode = rs.getString("well_code");
            result.country = rs.getString("country");
            result.field = rs.getString("field");
            result.oper = rs.getString("operator");
            result.county = rs.getString("county");
            result.wellID = rs.getInt("well_id");
            if (WellHeader.checkWellPerm(SB2, result.country, result.field, result.oper) == 0) continue;
            results.add(result);
        }
        stmt.close();
        return new ArrayList(results);
    }

    public static List searchMaster(SBdb SB2, String wellName, String wellCode, String country) throws SQLException, SBException {
        LinkedList<WellSearchResult> results = new LinkedList<WellSearchResult>();
        boolean clauseAdded = false;
        String sql = "SELECT well_name,well_code,country FROM " + SB2.DBTableName("WELLS_MASTER") + " WHERE ";
        if (wellName.compareTo("%") > 0) {
            clauseAdded = true;
            sql = sql + " ucase(well_name) like '" + wellName.trim().toUpperCase() + "'";
        }
        if (wellCode.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = sql + " AND ";
            }
            clauseAdded = true;
            sql = sql + " ucase(well_code) like '" + wellCode.trim().toUpperCase() + "'";
        }
        if (country.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = sql + " AND ";
            }
            clauseAdded = true;
            sql = sql + " ucase(country) like '" + country.trim().toUpperCase() + "'";
        }
        if (!clauseAdded) {
            throw new SBException("No search terms specified.");
        }
        sql = sql + " ORDER BY ucase(well_name),ucase(well_code),ucase(country)";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            WellSearchResult result = new WellSearchResult();
            result.wellName = rs.getString("well_name");
            result.wellCode = rs.getString("well_code");
            result.country = rs.getString("country");
            results.add(result);
        }
        stmt.close();
        return new ArrayList(results);
    }
}

