/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.zip.ZipFile;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.Biocom;
import model2.Casing;
import model2.CasingPoint;
import model2.CoreImage;
import model2.CoredInterval;
import model2.Cores;
import model2.Coreshift;
import model2.Discipline;
import model2.EnvScheme;
import model2.IGDInterval;
import model2.IGDIntervalEnv;
import model2.IGDIntervalZone;
import model2.Intcom;
import model2.InterpHdr;
import model2.LOC;
import model2.LithBase;
import model2.LithInterval;
import model2.LithQualifier;
import model2.Markers;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.SampleLithology;
import model2.SeismicMarker;
import model2.Smpdtl;
import model2.TVDList;
import model2.TVDepth;
import model2.TWTList;
import model2.Well;
import model2.WellEvent;
import model2.WellHeader;
import model2.WellInterp;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.DTMonitor;
import util.InvalidFieldException;
import util.MatchData;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.SbugsStatus;

public final class WsWell
extends Well
implements SbugsStatus {
    Well link = null;
    HashMap<Integer, HashMap> monitors = new HashMap();
    public String fileName;

    public WsWell(SBdb ws, String filePath) throws SQLException {
        super(ws);
        String temp = filePath.contains("\\") ? filePath.substring(filePath.lastIndexOf(92)) : filePath;
        this.fileName = temp.length() > 0 ? ".." + temp : filePath;
    }

    public WsWell(SBdb ws) throws SQLException {
        super(ws);
    }

    public Well getLink() {
        return this.link;
    }

    public DTMonitor getMonitor(int interpID, int dataType) throws SBException {
        DTMonitor monitor;
        HashMap<Integer, DTMonitor> map;
        if (!SBdb.isInterpDataType(dataType)) {
            interpID = 0;
        }
        if ((map = this.monitors.get(interpID)) == null) {
            map = new HashMap<Integer, DTMonitor>();
            this.monitors.put(interpID, map);
        }
        if ((monitor = (DTMonitor)map.get(dataType)) == null) {
            monitor = new DTMonitor();
            map.put(dataType, monitor);
        }
        return monitor;
    }

    void removeMonitor(int interpID, int dataType) throws SBException {
        HashMap map;
        if (!SBdb.isInterpDataType(dataType)) {
            interpID = 0;
        }
        if ((map = this.monitors.get(interpID)) == null) {
            return;
        }
        map.remove(dataType);
    }

    public void removeInterp(InterpHdr hdr) throws SBException {
        WellInterp wellInterp = super.getInterp(hdr.getInterpID());
        super.removeInterp(wellInterp);
    }

    public WsWell(SBdb ws, Well well) throws SQLException, SBException {
        super(ws, well);
        this.link = well;
        this.wellID = well.getWellID();
        this.header.copy(well.header);
        this.loadInterps();
        for (WellInterp wellInterp : this.interps) {
            wellInterp.getHeader().link = this.link.getInterp(wellInterp.interpID).getHeader();
        }
    }

    public void updateLithologyStatus(boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(0, 21);
        if (this.lithIntervals == null) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating lithology status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(21, this.getWellUnits());
        if (this.lithIntervals.size() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.lithIntervals.size(); ++i) {
                LithBase lith = (LithBase)this.lithIntervals.get(i);
                if (lith instanceof LithQualifier) {
                    LithQualifier qual = (LithQualifier)lith;
                    qual.updateStatus(this.lithIntervals, false);
                    if (qual.status != CONFLICT && this.link != null && this.link.getLithIntervals().size() > 0) {
                        qual.updateStatus(this.link.getLithIntervals(), true);
                    }
                } else {
                    lith.updateStatus(this.lithIntervals, false);
                    if (lith.status != CONFLICT && this.link != null && this.link.getLithIntervals().size() > 0) {
                        lith.updateStatus(this.link.getLithIntervals(), true);
                    }
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)lith.status));
            }
        }
    }

    public void updateCoreStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.cores == null) {
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating Cores status...");
        DTMonitor monitor = this.getMonitor(0, 19);
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (this.link != null && monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(19, this.getWellUnits());
        if (this.cores.getSize() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.cores.getSize(); ++i) {
                CoredInterval core = this.cores.getCore(i);
                core.updateStatus(this.cores);
                if (this.link != null && core.status != CONFLICT) {
                    core.updateStatus(this.link.getCores());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)core.status));
            }
        }
    }

    public void updateAnalystHeadersStatus() throws SQLException, SBException {
        if (this.link == null) {
            return;
        }
        List<AnalystHeader> dbHdrs = this.link.getAnalystHeaders();
        this.loadAnalystHeaders();
        if (!this.getAnalystHeaders().isEmpty()) {
            System.out.println("WsWell " + this.getWellName() + " updating analyst header status...");
        }
        for (AnalystHeader hdr : this.getAnalystHeaders()) {
            if (hdr.getAbnSchID() > 0 || hdr.getEnvSchID() > 0) {
                boolean hasAbn = false;
                boolean hasEnv = false;
                for (Smpdtl dtl : this.getAnalyses(hdr.getDiscID(), hdr.getAnalyst(), hdr.getAnalyNumber())) {
                    if (dtl.getProximal() > 0 || dtl.getDistal() > 0) {
                        hasEnv = true;
                    }
                    if (dtl.hasSemiQuantData(null) != null) {
                        hasAbn = true;
                    }
                    if (!hasAbn || !hasEnv) continue;
                    break;
                }
                if (!hasAbn) {
                    hdr.setAbnScheme(-1);
                }
                if (!hasEnv) {
                    hdr.setEnvScheme(-1);
                }
            }
            hdr.updateStatus(dbHdrs);
        }
    }

    public void updateTVDStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.TVD == null) {
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating TVD status...");
        DTMonitor monitor = this.getMonitor(0, 25);
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(25, this.getWellUnits());
        boolean stored = false;
        boolean conflict = false;
        boolean notstored = false;
        if (this.link != null && this.link.getTVDlist(false) != null && !this.link.getTVDlist(false).getList().isEmpty()) {
            block0: for (TVDepth wsTVDepth : this.TVD.getList()) {
                for (TVDepth dbTVDepth : this.link.getTVDlist(false).getList()) {
                    if (Math.abs(dbTVDepth.getDDepth() - wsTVDepth.getDDepth()) < (double)0.0029f) {
                        if (wsTVDepth.getTVDepth() - dbTVDepth.getTVDepth() < (double)0.0029f) {
                            stored = true;
                            break block0;
                        }
                        conflict = true;
                        break block0;
                    }
                    notstored = true;
                }
            }
            if (conflict) {
                this.TVD.setStatus(CONFLICT);
            } else if (stored && notstored) {
                this.TVD.setStatus(PARTSTORED);
            } else if (notstored && !stored) {
                this.TVD.setStatus(NOTSTORED);
            } else if (stored && !notstored) {
                this.TVD.setStatus(STORED);
            }
        } else if (this.TVD.getSize() > 0) {
            this.TVD.setStatus(NOTSTORED);
        }
        monitor.setStatus(this.TVD.getStatus());
    }

    public void updateCasingStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.casing == null) {
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating Casing status...");
        DTMonitor monitor = this.getMonitor(0, 20);
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (this.link != null && monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(20, this.getWellUnits());
        if (this.casing.getSize() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.casing.getSize(); ++i) {
                CasingPoint casingPoint = this.casing.getCasingPoint(i);
                casingPoint.updateStatus(this.casing);
                if (this.link != null && casingPoint.status != CONFLICT) {
                    casingPoint.updateStatus(this.link.getCasing());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)casingPoint.status));
            }
        }
    }

    public void updateSampleLithologyStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.getSamples() == null) {
            return;
        }
        boolean found = false;
        for (Sample sample : this.getSamples()) {
            if (sample.getLithology() == null || sample.getLithology().lithology.isEmpty()) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating sample lithology status...");
        DTMonitor monitor = this.getMonitor(0, 22);
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (this.link != null && monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(22, this.getWellUnits());
        if (this.getSamples().size() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.getSamples().size(); ++i) {
                Sample sample = this.getSamples().get(i);
                if (sample.getLithology() == null || sample.getLithology().getLithology().isEmpty()) continue;
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)sample.getLithology().getStatus(this.link != null && sample.link != null ? sample.link.getLithology() : null)));
            }
        }
    }

    public void updateMarkersStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.markers == null) {
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating marker status...");
        DTMonitor monitor = this.getMonitor(0, 24);
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getNonInterpDataRange(24, this.getWellUnits());
        if (this.markers.getSize() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.markers.getSize(); ++i) {
                SeismicMarker marker = this.markers.get(i);
                marker.updateStatus(this.markers);
                if (this.link != null && marker.status != CONFLICT) {
                    marker.updateStatus(this.link.markers);
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)marker.status));
            }
        }
    }

    public void updateStatus() throws SQLException, SBException {
        System.out.println("Full update status");
        this.updateHeaderStatus();
        this.updateAnalystHeadersStatus();
        this.updateSampleStatus(true);
        if (this.link != null) {
            this.link.loadInterps();
        }
        for (int i = 0; i < this.interps.size(); ++i) {
            WellInterp interp = (WellInterp)this.interps.get(i);
            this.updateInterpStatus(interp, this.getWellUnits());
        }
        this.updateCoreStatus(true);
        this.updateCasingStatus(true);
        this.updateMarkersStatus(true);
        this.updateTVDStatus(true);
        this.updateLithologyStatus(true);
        this.updateSampleLithologyStatus(true);
    }

    public void updateStatus(List<Integer> dTypes) throws SQLException, SBException {
        boolean samplesUpdated = false;
        boolean allBCMUpdated = false;
        boolean allZonesUpdated = false;
        block13: for (Integer i : dTypes) {
            if (SBdb.isInterpDataType(i)) {
                switch (i) {
                    case 10: 
                    case 11: 
                    case 12: {
                        if (allZonesUpdated) continue block13;
                        allZonesUpdated = true;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        if (allBCMUpdated) continue block13;
                        allBCMUpdated = true;
                        break;
                    }
                }
                for (int j = 0; j < this.interps.size(); ++j) {
                    WellInterp interp = (WellInterp)this.interps.get(j);
                    this.updateInterpTypeStatus(interp, i, this.getWellUnits());
                }
                continue;
            }
            switch (i) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    if (samplesUpdated) continue block13;
                    this.updateSampleStatus(true);
                    samplesUpdated = true;
                    continue block13;
                }
                case 19: {
                    this.updateCoreStatus(true);
                    continue block13;
                }
                case 20: {
                    this.updateCasingStatus(true);
                    continue block13;
                }
                case 24: {
                    this.updateMarkersStatus(true);
                    continue block13;
                }
                case 25: {
                    this.updateTVDStatus(true);
                    continue block13;
                }
                case 21: {
                    this.updateLithologyStatus(true);
                    continue block13;
                }
                case 22: {
                    this.updateSampleLithologyStatus(true);
                    continue block13;
                }
            }
            throw new SBException("Unrecognised data type is WsWell.updateStatus: " + i);
        }
    }

    public void updateSampleStatus(boolean refreshRange) throws SBException, SQLException {
        DTMonitor monitor;
        if (this.getSamples().isEmpty()) {
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating Sample status...");
        if (refreshRange) {
            monitor = this.getMonitor(0, 1);
            monitor.setStatus(UNKNOWN);
            monitor = this.getMonitor(0, 2);
            monitor.setStatus(UNKNOWN);
            monitor = this.getMonitor(0, 4);
            monitor.setStatus(UNKNOWN);
            monitor = this.getMonitor(0, 6);
            monitor.setStatus(UNKNOWN);
            monitor = this.getMonitor(0, 8);
            monitor.setStatus(UNKNOWN);
        }
        this.getNonInterpDataRange(1, this.getWellUnits());
        this.getNonInterpDataRange(2, this.getWellUnits());
        this.getNonInterpDataRange(4, this.getWellUnits());
        this.getNonInterpDataRange(6, this.getWellUnits());
        this.getNonInterpDataRange(8, this.getWellUnits());
        if (this.link != null) {
            this.link.loadAnalyses();
        }
        this.getMonitor(0, 1).setStatus(UNKNOWN);
        for (Sample sample : this.getSamples()) {
            sample.status = Sample.NOTSTORED;
            for (Sample comp : this.getSamples()) {
                if (sample == comp || !comp.getSortEntry().equals(sample.getSortEntry())) continue;
                sample.status = Sample.CONFLICT;
                break;
            }
            if (this.link != null && sample.status != Sample.CONFLICT) {
                for (Sample comp : this.link.getSamples()) {
                    if (!sample.isFuncEquivalent(comp)) continue;
                    sample.status = SbugsStatus.STORED;
                    sample.updateStatus(comp);
                    sample.setLink(comp);
                }
                if (sample.status == Sample.NOTSTORED) {
                    sample.setLink(null);
                }
            } else if (this.link == null) {
                sample.setLink(null);
            }
            monitor = this.getMonitor(0, 1);
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)sample.getStatus()));
            monitor.setHasData(true);
            for (int j = 0; j < sample.analyses.size(); ++j) {
                Smpdtl smpdtl = sample.analyses.get(j);
                if (sample.link == null || sample.link != null && smpdtl.link == null) {
                    smpdtl.status = Smpdtl.NOTSTORED;
                    smpdtl.updateStatus();
                } else {
                    smpdtl.updateStatus(smpdtl.link);
                }
                monitor = this.getMonitor(0, SBdb.did2dtype(smpdtl.getDiscID()));
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)smpdtl.getStatus()));
                monitor.setHasData(true);
            }
        }
    }

    public void resetDataMonitors() {
        this.monitors.clear();
    }

    public void resetInterpDataMonitors(List<Integer> dataTypes, int interpID) throws SBException {
        for (int dType : dataTypes) {
            if (dType == 0 || !SBdb.isInterpDataType(dType)) continue;
            this.removeMonitor(interpID, dType);
        }
    }

    public DTMonitor getDataMonitor(int dType, char units, int interpID) throws SQLException, SBException {
        if (units == 'D') {
            units = this.header.getWellUnits();
        }
        DTMonitor monitor = this.getMonitor(interpID, dType);
        if (SBdb.isInterpDataType(dType)) {
            WellInterp interp = this.getInterp(interpID);
            this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, dType, units);
        } else {
            this.getNonInterpDataRange(dType, units);
        }
        return monitor;
    }

    public DTMonitor getInterpDataRange(WellInterp interp, int wellID, int dType, char units) throws SQLException, SBException {
        DTMonitor monitor = this.getMonitor(interp.interpID, dType);
        if (monitor.getStatus() == UNKNOWN) {
            interp.refreshDataRange(wellID, dType, monitor);
        }
        if (!monitor.isHasData()) {
            monitor.setStatusString("(No data)");
            monitor.setStatus(SbugsStatus.UNKNOWN);
        } else {
            String range = SB.getDepthString((double)monitor.getDepthFrom(), (char)units, (int)2, (char)this.getType()) + " - " + SB.getDepthString((double)monitor.getDepthTo(), (char)units, (int)2, (char)this.getType());
            monitor.setStatusString(range);
        }
        if (this.link != null) {
            InterpHdr linkInterpHdr;
            if (monitor.getLink() == null) {
                monitor.setLink(new DTMonitor());
            }
            if ((linkInterpHdr = interp.getHeader().getLink()) != null && monitor.getLink().getStatus() == UNKNOWN) {
                try {
                    this.link.getInterp(linkInterpHdr.getInterpID()).refreshDataRange(wellID, dType, monitor.getLink());
                }
                catch (SBException ex) {
                    monitor.getLink().setHasData(false);
                }
            } else {
                System.out.println("Attempt to get data range from null linkInterp");
            }
            if (!monitor.getLink().isHasData()) {
                monitor.getLink().setStatusString("(No data)");
                monitor.getLink().setStatus(SbugsStatus.UNKNOWN);
            } else {
                String range = SB.getDepthString((double)monitor.getLink().getDepthFrom(), (char)units, (int)2, (char)this.getType()) + " - " + SB.getDepthString((double)monitor.getLink().getDepthTo(), (char)units, (int)2, (char)this.getType());
                monitor.getLink().setStatusString(range);
            }
        }
        return monitor;
    }

    public DTMonitor getNonInterpDataRange(int dType, char units) throws SQLException, SBException {
        String range;
        DTMonitor monitor = this.getMonitor(0, dType);
        if (monitor.getStatus() == UNKNOWN) {
            this.refreshDataRange(dType, monitor);
        }
        if (!monitor.isHasData()) {
            monitor.setStatusString("(No data)");
            monitor.setStatus(SbugsStatus.UNKNOWN);
        } else {
            range = SB.getDepthString((double)monitor.getDepthFrom(), (char)units, (int)2, (char)this.getType()) + " - " + SB.getDepthString((double)monitor.getDepthTo(), (char)units, (int)2, (char)this.getType());
            monitor.setStatusString(range);
        }
        if (this.link != null) {
            if (monitor.getLink() == null) {
                monitor.setLink(new DTMonitor());
            }
            if (monitor.getLink().getStatus() == UNKNOWN) {
                try {
                    this.link.refreshDataRange(dType, monitor.getLink());
                }
                catch (SBException ex) {
                    monitor.getLink().setHasData(false);
                }
            }
            if (!monitor.getLink().isHasData()) {
                monitor.getLink().setStatusString("(No data)");
                monitor.getLink().setStatus(SbugsStatus.UNKNOWN);
            } else {
                range = SB.getDepthString((double)monitor.getLink().getDepthFrom(), (char)units, (int)2, (char)this.getType()) + " - " + SB.getDepthString((double)monitor.getLink().getDepthTo(), (char)units, (int)2, (char)this.getType());
                monitor.getLink().setStatusString(range);
            }
        }
        return monitor;
    }

    public List<Integer> writeXML(BufferedWriter out, int indent, char units, List<Integer> dataTypes, List<File> files) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDList = new LinkedList<Integer>();
        boolean wantCores = false;
        boolean wantCasing = false;
        boolean wantLithology = false;
        boolean wantMarkers = false;
        boolean wantTVD = false;
        boolean wantTWT = false;
        boolean wantCoreImages = true;
        boolean wantSampleLithology = false;
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        Iterator<Integer> it = dataTypes.iterator();
        out.write("<WellHeader>\n");
        userIDList.addAll(this.getHeader().writeXML(out, indent + 3));
        out.write("</WellHeader>\n");
        while (it.hasNext()) {
            int columnType = it.next();
            char discID = '\u0000';
            switch (columnType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    discID = SBdb.dt2discID(columnType);
                    break;
                }
                case 19: {
                    wantCores = true;
                    break;
                }
                case 20: {
                    wantCasing = true;
                    break;
                }
                case 24: {
                    wantMarkers = true;
                    break;
                }
                case 21: {
                    wantLithology = true;
                    break;
                }
                case 25: {
                    wantTVD = true;
                    break;
                }
                case 26: {
                    wantTWT = true;
                    break;
                }
                case 22: {
                    wantSampleLithology = true;
                    break;
                }
            }
        }
        Iterator<AnalystHeader> ita = this.getAnalystHeaderIterator();
        while (ita.hasNext()) {
            AnalystHeader analyHdr = ita.next();
            out.write(ind + "<AnalystHeader DisciplineID=\"" + analyHdr.getDiscipline().getChar() + "\">\n");
            userIDList.addAll(analyHdr.writeXML(out, indent + 3, units));
            out.write(ind + "</AnalystHeader>\n");
        }
        for (int i = 0; i < this.getSamples().size(); ++i) {
            Sample sample = this.getSamples().get(i);
            out.write(ind + "<Sample Label=\"" + SB.getXMLstring((String)sample.toString(this.getWellUnits())) + "\">\n");
            userIDList.addAll(sample.writeXML(out, indent + 3, this.getWellUnits(), files));
            out.write(ind + "</Sample>\n");
        }
        Iterator<WellInterp> itWellInterp = this.getInterpIterator();
        while (itWellInterp.hasNext()) {
            WellInterp wellInterp = itWellInterp.next();
            out.write("<WellInterpretation Description=\"" + wellInterp.getHeader().getDescription() + "\">\n");
            userIDList.addAll(wellInterp.writeXML(out, units, indent + 3, dataTypes));
            out.write("</WellInterpretation>\n");
        }
        if (wantCasing) {
            this.getCasing().writeXML(out, indent, units);
        }
        if (wantCores) {
            this.getCores().writeXML(out, indent, units);
            this.getCoreShift().writeXML(out, indent, units);
        }
        if (wantMarkers) {
            this.getMarkers().writeXML(out, indent, units);
        }
        if (wantTVD) {
            System.out.println("Calling writeXML...");
            this.getTVDlist(false).writeXML(out, indent, units);
        }
        if (wantTWT) {
            this.getTWTlist().writeXML(out, indent, units);
        }
        if (wantLithology) {
            for (LithBase zone : this.getLithIntervals()) {
                if (zone instanceof LithQualifier) continue;
                zone.writeXML(out, indent, units);
            }
            for (LithBase zone : this.getLithIntervals()) {
                if (!(zone instanceof LithQualifier)) continue;
                LithQualifier qual = (LithQualifier)zone;
                qual.writeXML(out, indent, units);
            }
        }
        return userIDList;
    }

    WsWell(SBdb db, Element xml, List<Integer> dataTypes, ZipFile zip, String fileName) throws SQLException, SBException, ParseException, FileNotFoundException, IOException {
        super(db);
        this.header.setWellName(xml.getAttributeValue("Name"));
        this.header.parseXML(xml.getChild("WellHeader"));
        this.fileName = fileName;
        Iterator it = xml.getDescendants((Filter)new ElementFilter("AnalystHeader"));
        while (it.hasNext()) {
            this.addAnalystHeader(new AnalystHeader(db, (Element)it.next()));
        }
        this.resetDataMonitors();
        it = xml.getDescendants((Filter)new ElementFilter("Sample"));
        this.getSamples();
        while (it.hasNext()) {
            Sample.insert(this.getSamples(), new Sample(db, this, this.getType(), (Element)it.next(), dataTypes, zip), this.getWellUnits());
        }
        it = xml.getDescendants((Filter)new ElementFilter("CoredInterval"));
        while (it.hasNext()) {
            if (this.cores == null) {
                this.getCores();
            }
            this.cores.add(new CoredInterval(db, (Element)it.next()));
            if (dataTypes.contains(19)) continue;
            dataTypes.add(19);
        }
        Element element = xml.getChild("CoreShift");
        if (element != null) {
            this.coreShift = new Coreshift(db, element);
        }
        it = xml.getDescendants((Filter)new ElementFilter("CasingPoint"));
        while (it.hasNext()) {
            if (this.casing == null) {
                this.getCasing();
            }
            this.casing.add(new CasingPoint(db, (Element)it.next()));
            if (dataTypes.contains(20)) continue;
            dataTypes.add(20);
        }
        it = xml.getDescendants((Filter)new ElementFilter("SeismicMarker"));
        while (it.hasNext()) {
            if (this.markers == null) {
                this.getMarkers();
            }
            this.markers.add(new SeismicMarker(db, (Element)it.next()));
            if (dataTypes.contains(24)) continue;
            dataTypes.add(24);
        }
        it = xml.getDescendants((Filter)new ElementFilter("WellInterpretation"));
        while (it.hasNext()) {
            WellInterp wellInterp = new WellInterp(db, this, (Element)it.next(), dataTypes);
            System.out.println("Processing interp: " + wellInterp);
            Iterator wit = this.interps.iterator();
            while (wit.hasNext()) {
                WellInterp interp = (WellInterp)wit.next();
                if (interp.interpID != wellInterp.interpID) continue;
                wit.remove();
                break;
            }
            this.interps.add(wellInterp);
            for (int dType : dataTypes) {
                if (!SBdb.isInterpDataType(dType)) continue;
                wellInterp.refreshDataRange(this.wellID, dType, this.getMonitor(wellInterp.interpID, dType));
            }
        }
        it = xml.getDescendants((Filter)new ElementFilter("LithologyInterval"));
        while (it.hasNext()) {
            if (this.lithIntervals == null) {
                this.getLithIntervals();
            }
            this.insertLithInterval(new LithInterval(db, (Element)it.next()));
            if (dataTypes.contains(21)) continue;
            dataTypes.add(21);
        }
        it = xml.getDescendants((Filter)new ElementFilter("LithologyQualifier"));
        while (it.hasNext()) {
            if (this.lithIntervals == null) {
                this.getLithIntervals();
            }
            LithQualifier qual = new LithQualifier(db, (Element)it.next());
            this.insertLithInterval(qual);
            if (dataTypes.contains(21)) continue;
            dataTypes.add(21);
        }
        it = xml.getDescendants((Filter)new ElementFilter("DeviationSurvey"));
        while (it.hasNext()) {
            this.TVD = new TVDList(db, false);
            it = xml.getDescendants((Filter)new ElementFilter("TVDData"));
            while (it.hasNext()) {
                TVDepth tvd = new TVDepth((Element)it.next());
                this.TVD.add(tvd);
            }
            if (dataTypes.contains(25)) continue;
            dataTypes.add(25);
        }
        this.updateStatus(dataTypes);
    }

    void parseXML(String chars, String element) throws ParseException {
        this.header.parseXML(chars, element);
    }

    public Color getStatus() {
        return this.header.getStatus();
    }

    public void updateHeaderStatus() throws SBException, SQLException {
        System.out.println("WsWell " + this.getWellName() + " updating header status...");
        if (this.link != null) {
            this.header.updateStatus(this.db, this.link);
        } else {
            this.header.status = WellHeader.NOTSTORED;
        }
    }

    public void setSectionType(char type) throws SBException, SQLException {
        if (this.getType() != type) {
            this.header.setType(type);
            for (Sample sample : this.getSamples()) {
                System.out.println("Sample depth before switch: " + sample.getDepth());
                sample.setSectionType('O');
                System.out.println("Sample depth after switch: " + sample.getDepth());
            }
            LinkedList<Sample> tempSamples = new LinkedList<Sample>(this.getSamples());
            this.getSamples().clear();
            for (Sample sample : tempSamples) {
                Sample.insert(this.getSamples(), sample, this.getWellUnits());
            }
            for (Sample sample : this.getSamples()) {
                System.out.println("Sample depth after sort: " + sample.getDepth());
            }
        }
    }

    public void setLink(Well linkWell) throws SQLException, SBException {
        if (linkWell != this.link) {
            this.link = linkWell;
            this.resetDataMonitors();
            this.updateStatus();
        }
    }

    public void match(SBdb db) throws SQLException, SBException {
        ResultSet rs;
        Statement stmt = db.getDatabase().createStatement();
        String sql = "SELECT well_id FROM " + db.DBTableName("wells") + " w, " + db.DBTableName("well_ident") + " v WHERE w.well_name=" + SB.DBString((String)this.getWellName());
        if (this.getWellCode().length() > 0) {
            sql = sql + " AND w.well_code=" + SB.DBString((String)this.getWellCode());
        }
        if ((rs = stmt.executeQuery(sql = sql + " AND w.well_code = v.well_code")).next()) {
            this.setLink(db.getAddWell(rs.getInt("well_id")));
        }
        rs.close();
        stmt.close();
    }

    public void unMatch() {
        this.link = null;
    }

    public void unloadData(int dType, int interpID) throws SBException, SQLException {
        if (SBdb.isInterpDataType(dType)) {
            if (this.hasInterpLoaded(interpID)) {
                WellInterp interp = this.getInterp(interpID);
                interp.unloadData(dType);
            }
            return;
        }
        if (!this.getMonitor(interpID, dType).isHasData()) {
            return;
        }
        switch (dType) {
            case 1: {
                throw new SBException("Attempt to unload Samples data");
            }
            case 8: {
                this.unloadOccs('A');
                break;
            }
            case 2: {
                this.unloadOccs('M');
                break;
            }
            case 4: {
                this.unloadOccs('N');
                break;
            }
            case 6: {
                this.unloadOccs('P');
                break;
            }
            case 21: {
                this.unloadLithology();
                break;
            }
            case 19: {
                this.cores.clear();
                break;
            }
            case 20: {
                this.casing.clear();
                break;
            }
            case 24: {
                this.markers.clear();
                break;
            }
            case 25: {
                this.unloadTVDs();
                break;
            }
            case 26: {
                this.unloadTWTs();
                break;
            }
            case 22: {
                this.unloadSampleLithology();
                break;
            }
            case 23: {
                break;
            }
            default: {
                throw new SBException("No status for data type: " + dType);
            }
        }
        this.removeMonitor(interpID, dType);
    }

    public void deleteLinkData(List<Integer> dataTypes) throws SQLException, SBException {
        block9: for (int i : dataTypes) {
            if (SBdb.isInterpDataType(i)) {
                for (WellInterp interp : this.interps) {
                    WellInterp linkInterp = this.link.getAddInterp(interp.getHeader());
                    if (linkInterp == null) {
                        throw new SBException("Attempt to delete linked data for interp: " + interp + " - not linked");
                    }
                    linkInterp.deleteLinkData(i, this.link.getWellID());
                }
                continue;
            }
            switch (i) {
                case 1: 
                case 22: {
                    continue block9;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    Observable s = null;
                    Smpdtl d = null;
                    Iterator<Smpdtl> i$ = this.link.getAnalyses(SBdb.dt2discID(i), null, 0).iterator();
                    while (i$.hasNext()) {
                        Smpdtl dtl;
                        d = dtl = i$.next();
                        s = dtl.getSample();
                        ((Sample)s).deleteDtl(this.link.wellID, dtl.getAnalyID(), dtl);
                    }
                    if (s == null || d == null) continue block9;
                    s.notifyObservers(d);
                    continue block9;
                }
                case 21: {
                    this.link.deleteLithIntervals();
                    continue block9;
                }
                case 19: {
                    Cores.deleteAll(this.link.db, this.link.wellID);
                    this.link.cores = null;
                    continue block9;
                }
                case 20: {
                    if (this.link.casing == null) continue block9;
                    this.link.casing.deleteAll(this.link.wellID);
                    this.link.casing = null;
                    continue block9;
                }
                case 24: {
                    if (this.link.markers == null) continue block9;
                    this.link.markers.deleteAll(this.link.wellID);
                    this.link.casing = null;
                    continue block9;
                }
                case 25: {
                    if (this.link.TVD == null) continue block9;
                    this.link.TVD.deleteAll(this.link.wellID);
                    this.link.TVD = null;
                    continue block9;
                }
            }
            System.out.println("Unrecognised data type in WsWell.deleteLinkData(): " + SBdb.dTypeNames[i]);
        }
        this.link.db.commit();
    }

    public void store(List<Integer> dataTypes) throws SBException, SQLException, FileNotFoundException, IOException {
        if (this.link == null) {
            throw new SBException("Attempt to store well with no linked well");
        }
        if (this.header.getStatus() == WellHeader.PARTSTORED) {
            this.link.updateHeader(this.header);
        }
        Statement stmt = this.link.db.getDatabase().createStatement();
        MatchData matchSamples = new MatchData();
        matchSamples.init(this.getSamples(), this.link.getSamples());
        boolean storeLiths = dataTypes.contains(22);
        SampleLithology notifier = null;
        for (int row = 0; row < matchSamples.size(); ++row) {
            MatchData.MatchPair pair = matchSamples.get(row);
            Sample ws = (Sample)pair.getWs();
            Sample dbSample = (Sample)pair.getDb();
            if (ws == null) continue;
            if (dbSample == null) {
                dbSample = new Sample(this.link.getDataModel(), ws, true);
                this.link.addSample(stmt, dbSample);
                ws.status = Sample.STORED;
            } else if (ws.getStatus() == Sample.PARTSTORED) {
                dbSample.update(this.link, ws);
            }
            if (!storeLiths || ws.getLithology() == null || dbSample == null) continue;
            dbSample.updateLithology(ws.getLithology().lithology, this.link.wellID);
            notifier = dbSample.getLithology();
        }
        if (storeLiths) {
            this.link.setDataChanged();
            this.link.notifyObservers(notifier);
        }
        MatchData matchSmpdtls = new MatchData();
        for (int i = 0; i < SBdb.discArr.length; ++i) {
            char discID = SBdb.discArr[i];
            int dType = SBdb.did2dtype(discID);
            if (!dataTypes.contains(dType)) continue;
            matchSmpdtls.init(this.getAnalyses(discID, null, 0), this.link.getAnalyses(discID, null, 0));
            for (int row = 0; row < matchSmpdtls.size(); ++row) {
                MatchData.MatchPair pair = matchSmpdtls.get(row);
                Smpdtl ws = (Smpdtl)pair.getWs();
                if (ws == null) continue;
                Smpdtl dbSmpdtl = (Smpdtl)pair.getDb();
                AnalystHeader hdr = this.link.getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), false);
                if (dbSmpdtl == null) {
                    AnalystHeader wsHdr;
                    Sample wsSample = ws.getSample();
                    Sample dbSample = this.link.getSample(wsSample.getTopDepth(), wsSample.getBaseDepth(), wsSample.getType(), false);
                    if (dbSample == null) {
                        dbSample = new Sample(this.link.getDataModel(), wsSample, true);
                        this.link.addSample(stmt, dbSample);
                    }
                    if (hdr == null) {
                        wsHdr = this.getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), false);
                        if (wsHdr == null) {
                            hdr = this.link.getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), true);
                        } else {
                            int envSchID = -1;
                            int abnSchID = -1;
                            if (wsHdr.getEnvSchID() > 0) {
                                EnvScheme envScheme = this.db.getEnvScheme(wsHdr.getEnvSchID());
                                if (envScheme == null) {
                                    throw new SBException("Error in well: " + this.getWellName() + ". Palaeoeonvironment scheme from analyst header not found in workspace: " + wsHdr.getEnvSchID());
                                }
                                if (envScheme.getLink() == null) {
                                    throw new SBException("Cannot store well: " + this.getWellName() + ". Palaeoenvironment scheme not matched: " + envScheme.toString());
                                }
                                envSchID = envScheme.getLink().getID();
                            }
                            if (wsHdr.getAbnSchID() > 0) {
                                AbnScheme abnScheme = this.db.getAbnScheme(wsHdr.getAbnSchID(), false);
                                if (abnScheme == null) {
                                    throw new SBException("Error in well: " + this.getWellName() + ". Abundance scheme from analyst header not found in workspace: " + wsHdr.getAbnSchID());
                                }
                                if (abnScheme.getLink() == null) {
                                    throw new SBException("Cannot store well: " + this.getWellName() + ". Abundance scheme not matched: " + abnScheme.toString());
                                }
                                abnSchID = abnScheme.getLink().getID();
                            }
                            hdr = this.link.addAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), wsHdr.getDepthFrom(), wsHdr.getDepthTo(), wsHdr.getDateFrom(), wsHdr.getDateTo(), wsHdr.getComments(), envSchID, abnSchID, Color.BLACK);
                        }
                    } else {
                        wsHdr = this.getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), false);
                        if (wsHdr.getStatus() == SbugsStatus.CONFLICT) {
                            throw new SBException("Cannot save analyses due to conflict in analyst headers");
                        }
                        if (wsHdr.getAbnSchID() > 0 && hdr.getAbnSchID() == 0) {
                            hdr.setAbnScheme(this.link.wellID, this.db.getAbnScheme(wsHdr.getAbnSchID(), false).getID());
                        }
                    }
                    dbSmpdtl = new Smpdtl(stmt, this.link.getDataModel(), this.db, ws, this.link.getWellID(), dbSample.getSampID(), hdr);
                    dbSample.addDtl(dbSmpdtl);
                } else if (ws.getStatus() == Smpdtl.PARTSTORED) {
                    dbSmpdtl.update(this.link.getWellID(), ws);
                }
                ws.status = Smpdtl.STORED;
            }
        }
        this.link.notifyObservers(Sample.class);
        stmt.close();
        Iterator<WellInterp> it = this.getInterpIterator();
        while (it.hasNext()) {
            WellInterp wellInterp = it.next();
            if (wellInterp.getHeader().getLink() == null) {
                System.out.println("Can't store wellInterp - not linked. (or no interpreted data)");
                continue;
            }
            WellInterp linkedInterp = this.link.getAddInterp(wellInterp.getHeader().getLink());
            linkedInterp.store(wellInterp, this.link.wellID, dataTypes, this.getDataModel());
            linkedInterp.notifyObservers(linkedInterp);
        }
        block14: for (int dType : dataTypes) {
            switch (dType) {
                case 20: {
                    if (this.casing == null) continue block14;
                    this.link.storeCasing(this.db, this.casing);
                    continue block14;
                }
                case 19: {
                    if (this.cores != null) {
                        this.link.storeCores(this.db, this.cores);
                    }
                    if (this.coreShift != null) {
                        this.link.storeCoreshift(this.db, this.coreShift);
                    }
                }
                case 24: {
                    if (this.markers != null) {
                        this.link.storeMarkers(this.db, this.markers);
                    }
                }
                case 21: {
                    if (this.lithIntervals != null) {
                        try {
                            this.link.storeLithology(this.db, this.lithIntervals);
                        }
                        catch (InvalidFieldException e) {
                            throw new SBException(e.getMessage());
                        }
                    }
                }
                case 25: {
                    if (this.TVD != null) {
                        this.link.storeTVD(this.db, this.TVD);
                    }
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 22: {
                    continue block14;
                }
            }
            if (SBdb.isInterpDataType(dType)) continue;
            System.out.println("WsWell: Cannot store data type: " + dType);
        }
        this.resetDataMonitors();
        this.updateStatus();
        this.link.notifyObservers();
    }

    public void storeLithology() throws SQLException, SBException, InvalidFieldException {
        if (this.lithIntervals != null) {
            this.link.storeLithology(this.db, this.lithIntervals);
        }
    }

    void unloadIGD(int igdType) {
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            List<IGDIntervalZone> vect = in.getIGDList(igdType, 0);
            vect.clear();
        }
    }

    void unloadEvents() {
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            in.events.clear();
        }
    }

    void unloadLOCs() {
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            in.loc = null;
        }
    }

    void unloadTVDs() {
        this.TVD.clear();
    }

    void unloadTWTs() {
        this.TWT.clear();
    }

    void unloadLithology() {
        this.lithIntervals.clear();
    }

    @Override
    public void loadSamples() {
        if (this.link != null) {
            // empty if block
        }
    }

    void unloadOccs(char discID) throws SQLException, SBException {
        for (Sample sample : this.getSamples()) {
            Iterator<Smpdtl> it = sample.analyses.iterator();
            while (it.hasNext()) {
                Smpdtl smpdtl = it.next();
                if (smpdtl.getDiscID() != discID) continue;
                it.remove();
            }
        }
    }

    void unloadSampleLithology() throws SQLException, SBException {
        for (Sample sample : this.getSamples()) {
            sample.deleteLithology(0);
        }
    }

    void unloadBCM(char discID) {
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            Iterator<Biocom> it = in.comments.iterator();
            while (it.hasNext()) {
                Biocom comm = it.next();
                if (comm.getDiscID() != discID) continue;
                it.remove();
            }
        }
    }

    public void updateInterpStatus(WellInterp interp, char units) throws SBException, SQLException {
        InterpHdr linkInterpHdr = interp.getHeader().getLink();
        if (this.link == null) {
            linkInterpHdr = null;
        }
        if (linkInterpHdr != null) {
            try {
                this.link.getInterp(linkInterpHdr.getInterpID()).load(this.link);
            }
            catch (Exception ex) {
                System.out.println("link well " + this.link + " did not have interp " + linkInterpHdr + "; updating interp status for internal consistency");
                linkInterpHdr = null;
            }
        }
        this.updateAllZonesStatus(interp, linkInterpHdr, units, true);
        this.updateAllBCMStatus(interp, linkInterpHdr, units, true);
        this.updateEnvStatus(interp, linkInterpHdr, units, true);
        this.updateSQPickStatus(interp, linkInterpHdr, units, true);
        this.updateEventsStatus(interp, linkInterpHdr, units, true);
        this.updateIntcomStatus(interp, linkInterpHdr, units, true);
        this.updateLOCStatus(interp, linkInterpHdr, units, true);
    }

    public void updateInterpTypeStatus(WellInterp interp, int dType, char units) throws SBException, SQLException {
        InterpHdr linkInterpHdr = interp.getHeader().getLink();
        if (this.link == null) {
            linkInterpHdr = null;
        }
        if (linkInterpHdr != null) {
            try {
                this.link.getInterp(linkInterpHdr.getInterpID()).load(this.link);
            }
            catch (Exception ex) {
                linkInterpHdr = null;
            }
        }
        switch (dType) {
            case 10: 
            case 11: 
            case 12: {
                this.updateAllZonesStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                this.updateAllBCMStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 15: {
                this.updateEnvStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 14: {
                this.updateSQPickStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 16: {
                this.updateEventsStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 18: {
                this.updateIntcomStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 17: {
                this.updateLOCStatus(interp, linkInterpHdr, units, true);
                break;
            }
            default: {
                throw new SBException("Unknown data type in updateInterpType: " + dType);
            }
        }
    }

    public void updateLOCStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        if (interp.loc == null) {
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating LOC status...");
        DTMonitor monitor = this.getMonitor(interp.interpID, 17);
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 17, units);
        if (interp.loc != null && monitor != null) {
            monitor.setStatus(UNKNOWN);
            if (linkInterpHdr != null && this.link.getInterp((int)linkInterpHdr.getInterpID()).loc != null) {
                interp.loc.updateStatus(this.link.getAddInterp((InterpHdr)linkInterpHdr).loc);
            } else {
                interp.loc.status = LOC.NOTSTORED;
            }
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)interp.loc.getStatus()));
        }
    }

    public void updateAllZonesStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        for (int list = 0; list < interp.zoneTypes.length; ++list) {
            int igdType = WellInterp.zoneType2IGDType(list);
            this.updateZoneStatus(interp, linkInterpHdr, igdType, units, reloadRange);
        }
    }

    public void updateZoneStatus(WellInterp interp, InterpHdr linkInterpHdr, int igdType, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, IGDInterval.igdType2dType(igdType));
        if (interp.getIGDList(igdType).isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating " + SBdb.dTypeNames[IGDInterval.igdType2dType(igdType)] + " status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, IGDInterval.igdType2dType(igdType), units);
        if (!interp.getIGDList(igdType).isEmpty()) {
            monitor.setStatus(UNKNOWN);
            for (IGDIntervalZone zone : interp.getIGDList(igdType)) {
                zone.updateStatus(interp.getIGDList(igdType));
                if (this.link != null && linkInterpHdr != null && zone.status != CONFLICT) {
                    zone.updateStatus(this.link.getAddInterp(linkInterpHdr).getIGDList(igdType, 0));
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)zone.getStatus()));
            }
        }
    }

    public void updateAllBCMStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        for (int i = 0; i < 4; ++i) {
            char discID = SBdb.discArr[i];
            this.updateBCMStatus(interp, linkInterpHdr, discID, units, true);
        }
    }

    public void updateBCMStatus(WellInterp interp, InterpHdr linkInterpHdr, char discID, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, SBdb.did2comType(discID));
        if (interp.getComments(discID).isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating " + SBdb.getDiscAdj(discID) + " comments...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, SBdb.did2comType(discID), units);
        if (interp.comments.size() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int iComm = 0; iComm < interp.comments.size(); ++iComm) {
                Biocom comment = interp.comments.get(iComm);
                if (comment.getDiscID() != discID) continue;
                comment.updateStatus(interp.comments);
                if (linkInterpHdr != null && comment.status != CONFLICT) {
                    comment.updateStatus(this.link.getAddInterp(linkInterpHdr).getComments());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)comment.getStatus()));
            }
        }
    }

    public void updateEnvStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 15);
        if (interp.getEnvs() == null || interp.getEnvs().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating Envs status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 15, units);
        if (interp.envs.size() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int iEnv = 0; iEnv < interp.envs.size(); ++iEnv) {
                IGDIntervalEnv env = interp.envs.get(iEnv);
                env.updateStatus(interp.envs);
                if (linkInterpHdr != null && env.status != CONFLICT) {
                    env.updateStatus(this.link.getAddInterp(linkInterpHdr).getEnvs());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)env.status));
            }
        }
    }

    public void updateSQPickStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 14);
        if (interp.getSQPicks().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating SQPick status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 14, units);
        if (interp.picks != null) {
            monitor.setStatus(UNKNOWN);
            for (SQPick pick : interp.picks) {
                pick.updateStatus(interp.picks);
                if (linkInterpHdr != null && pick.status != CONFLICT) {
                    pick.updateStatus(this.link.getAddInterp(linkInterpHdr).getSQPicks());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)pick.getStatus()));
            }
        }
    }

    public void updateEventsStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 16);
        if (interp.getEvents().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating Events status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 16, units);
        if (interp.events != null && interp.events.size() > 0) {
            monitor.setStatus(UNKNOWN);
            for (WellEvent event : interp.events) {
                event.updateStatus(interp.events);
                if (linkInterpHdr != null && event.status != CONFLICT) {
                    event.updateStatus(this.link.getAddInterp(linkInterpHdr).getEvents());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)event.getStatus()));
            }
        }
    }

    public void updateIntcomStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 18);
        if (interp.intcoms == null || interp.intcoms.isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        System.out.println("WsWell " + this.getWellName() + " updating intcom status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 18, units);
        if (interp.intcoms != null) {
            monitor.setStatus(UNKNOWN);
            for (Intcom intcom : interp.intcoms) {
                intcom.updateStatus(interp.intcoms);
                if (linkInterpHdr != null && intcom.getStatus() != CONFLICT) {
                    intcom.updateStatus(this.link.getAddInterp(linkInterpHdr).getIntcoms());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)intcom.getStatus()));
            }
        }
    }

    public void fillData(List<Integer> dataTypes) throws SQLException, SBException {
        Sample wsSample;
        if (this.link == null) {
            return;
        }
        if (dataTypes.contains(4) || dataTypes.contains(2) || dataTypes.contains(6) || dataTypes.contains(8)) {
            this.link.loadAnalystHeaders();
            this.getAnalystHeaders();
            Iterator<AnalystHeader> itHdr = this.link.getAnalystHeaderIterator();
            while (itHdr.hasNext()) {
                AnalystHeader analyHdr = itHdr.next();
                if (!(dataTypes.contains(2) && analyHdr.getDiscipline() == Discipline.MICRO || dataTypes.contains(4) && analyHdr.getDiscipline() == Discipline.NANNO || dataTypes.contains(6) && analyHdr.getDiscipline() == Discipline.PALY) && (!dataTypes.contains(8) || analyHdr.getDiscipline() != Discipline.MACRO) || !analyHdr.hasData(this.link.wellID)) continue;
                AnalystHeader wsAnalyHdr = AnalystHeader.copyToWorkspace(this.db, analyHdr);
                this.addAnalystHeader(wsAnalyHdr);
            }
        }
        Iterator<Sample> it = this.link.getSamples().iterator();
        if (dataTypes.contains(1)) {
            while (it.hasNext()) {
                Sample sample = it.next();
                if (this.hasSample(sample)) continue;
                wsSample = new Sample(this.db, sample);
                Sample.insert(this.getSamples(), wsSample, this.getWellUnits());
            }
        }
        if (dataTypes.contains(2) || dataTypes.contains(4) || dataTypes.contains(6) || dataTypes.contains(8)) {
            this.link.loadAnalyses();
            for (Sample sample : this.link.getSamples()) {
                if (sample.getAnalyses().isEmpty()) continue;
                for (Smpdtl smpdtl : sample.getAnalyses()) {
                    Sample wsSample2;
                    if (!(dataTypes.contains(2) && smpdtl.getDiscID() == 'M' || dataTypes.contains(4) && smpdtl.getDiscID() == 'N' || dataTypes.contains(6) && smpdtl.getDiscID() == 'P') && (!dataTypes.contains(8) || smpdtl.getDiscID() != 'A')) continue;
                    if (!this.hasSample(sample)) {
                        wsSample2 = new Sample(this.db, sample);
                        Sample.insert(this.getSamples(), wsSample2, this.getWellUnits());
                    } else {
                        wsSample2 = this.getSample(sample.getSampID());
                    }
                    try {
                        AnalystHeader wsHeader = this.getAnalystHeader(smpdtl.getAnalyID(), false);
                        Smpdtl existing = wsSample2.getSmpdtl(smpdtl.getDiscID(), wsHeader.getAnalyst(), wsHeader.getAnalyNumber());
                        if (existing != null) {
                            wsSample2.deleteDtl(0, 0, existing);
                        }
                        Smpdtl wsSmpdtl = new Smpdtl(this.db, smpdtl, wsSample2, wsHeader);
                        wsSample2.insert(wsSmpdtl);
                    }
                    catch (Exception e) {
                        SB.showStackError((String)"Error creating sample detail", (Exception)e);
                    }
                }
            }
        }
        if (dataTypes.contains(22)) {
            for (Sample sample : this.link.getSamples()) {
                if (sample.getLithology() == null || sample.getLithology().getLithology().isEmpty()) continue;
                sample.loadLithology(this.link.wellID, this.link.getDataModel().getLithdesc());
                if (!this.hasSample(sample)) {
                    wsSample = new Sample(this.db, sample);
                    Sample.insert(this.getSamples(), wsSample, this.getWellUnits());
                } else {
                    wsSample = this.getSample(sample.getSampID());
                }
                wsSample.copyLithology(sample.getLithology());
            }
        }
        block16: for (int dType : dataTypes) {
            if (SBdb.isInterpDataType(dType)) continue;
            switch (dType) {
                default: {
                    throw new SBException("Cannot process data type: " + dType + " in WsWell.fillData");
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 22: {
                    break;
                }
                case 26: {
                    if (this.link.getTWTlist().getSize() <= 0) continue block16;
                    this.TWT = new TWTList(this.db);
                    for (int i = 0; i < this.link.getTWTlist().getSize(); ++i) {
                        this.TWT.add(this.link.getTWTlist().get(i));
                    }
                    continue block16;
                }
                case 20: {
                    Casing wsCasing = new Casing(this.db);
                    this.link.getCasing().load(this.link.getWellID());
                    Iterator<CasingPoint> itCasing = this.link.getCasing().getList().iterator();
                    if (this.link.getCasing().getList().isEmpty()) {
                        // empty if block
                    }
                    while (itCasing.hasNext()) {
                        CasingPoint casingPoint = itCasing.next();
                        CasingPoint wsCasingPoint = new CasingPoint(casingPoint);
                        wsCasing.add(wsCasingPoint);
                        this.casing = wsCasing;
                    }
                    continue block16;
                }
                case 19: {
                    Cores wsCores = new Cores(this.db);
                    Iterator itCores = this.link.getCores().getIterator();
                    if (this.link.getCores().getList().isEmpty()) {
                        // empty if block
                    }
                    while (itCores.hasNext()) {
                        CoredInterval coredInterval = (CoredInterval)itCores.next();
                        CoredInterval wsCoredInterval = new CoredInterval(coredInterval);
                        wsCores.add(wsCoredInterval);
                        this.cores = wsCores;
                    }
                    if (!this.link.getCoreImages().isEmpty()) {
                        this.coreImages = new LinkedList();
                        for (CoreImage coreImage : this.link.getCoreImages()) {
                            CoreImage wsCoreImage = new CoreImage(this.db, coreImage);
                            this.coreImages.add(wsCoreImage);
                        }
                    }
                    this.coreShift = this.link.getCoreShift();
                    break;
                }
                case 24: {
                    Markers wsMarkers = new Markers(this.db);
                    for (int i = 0; i < this.link.getMarkers().getSize(); ++i) {
                        wsMarkers.add(new SeismicMarker(this.link.getMarkers().get(i)));
                    }
                    this.markers = wsMarkers;
                    break;
                }
                case 25: {
                    if (this.link.getTVDlist(false).getSize() <= 0) continue block16;
                    this.TVD = new TVDList(this.db, false);
                    for (int i = 0; i < this.link.getTVDlist(false).getSize(); ++i) {
                        this.TVD.add(new TVDepth(this.link.getTVDlist(false).get(i)));
                    }
                    continue block16;
                }
                case 21: {
                    if (this.link.getLithIntervals().size() <= 0) continue block16;
                    this.lithIntervals = null;
                    this.getLithIntervals();
                    for (LithBase lithInterval : this.link.getLithIntervals()) {
                        LithBase wsLithInterval = lithInterval instanceof LithQualifier ? new LithQualifier(this.db, (LithQualifier)lithInterval) : new LithInterval(this.db, (LithInterval)lithInterval);
                        this.lithIntervals.add(wsLithInterval);
                    }
                    continue block16;
                }
            }
        }
        this.resetDataMonitors();
        this.updateStatus(dataTypes);
    }

    public void fillAnalyses(List<Smpdtl> dtls) throws SQLException, SBException {
        for (Smpdtl smpdtl : dtls) {
            Sample wsSample;
            Sample sample = smpdtl.getSample();
            if (!this.hasSample(sample)) {
                wsSample = new Sample(this.db, sample);
                Sample.insert(this.getSamples(), wsSample, this.getWellUnits());
            } else {
                wsSample = this.getSample(sample.getSampID());
            }
            try {
                AnalystHeader wsHeader = this.getAnalystHeader(smpdtl.getHeader().getAnalyst(), smpdtl.getDiscID(), smpdtl.getAnalyNo(), true);
                Smpdtl wsSmpdtl = new Smpdtl(this.db, smpdtl, wsSample, wsHeader);
                wsSample.insert(wsSmpdtl);
            }
            catch (Exception e) {
                SB.showStackError((String)"Error creating sample detail", (Exception)e);
            }
        }
    }

    public void fillData(List<Integer> dataTypes, InterpHdr wsHdr) throws SQLException, SBException {
        if (this.link == null) {
            return;
        }
        WellInterp wsWellInterp = null;
        for (WellInterp wsInterp : this.interps) {
            if (wsInterp.getHeader().getInterpID() != wsHdr.getInterpID()) continue;
            wsWellInterp = wsInterp;
            break;
        }
        if (wsWellInterp == null) {
            System.out.println("Adding Interp in wsWell.fillData: " + wsHdr.toString());
            wsWellInterp = new WellInterp(this.db, this.link.getInterp(wsHdr.getLink().getInterpID()), wsHdr);
            this.interps.add(wsWellInterp);
        }
        WellInterp dbWellInterp = this.link.getInterp(wsHdr.getLink().getInterpID());
        wsWellInterp.fillWorkspace(dataTypes, dbWellInterp, this, this.link);
        this.resetDataMonitors();
        this.updateStatus(dataTypes);
    }

    @Override
    public Sample addSample(Double topDepth, Double baseDepth, String sampleType, String label) throws SBException, SQLException {
        Sample sample = new Sample(this.db, this.type(), topDepth, baseDepth, sampleType, label);
        Sample.insert(this.getSamples(), sample, this.getWellUnits());
        return sample;
    }

    boolean hasSample(Sample sample) throws SQLException, SBException {
        for (Sample current : this.getSamples()) {
            if (sample.getSampID() != current.getSampID()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTDorTop() {
        if (this.getType() == 'W' && this.header.getTD() < (double)0.0029f) {
            return false;
        }
        return this.getType() != 'O' || !(this.header.getKicko() > (double)0.0029f);
    }
}

