/*
 * Decompiled with CFR 0.152.
 */
package sbconvert2_0;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import model1_8.AbnScheme;
import model1_8.SBdb;
import model1_8.Well;
import util.SB;

public class DialogAbnFix
extends JDialog {
    boolean isOK = false;
    DefaultListModel schemeModel = new DefaultListModel();
    DefaultListModel abrModel = new DefaultListModel();
    AbnScheme schemeUsed = null;
    Well well = null;
    char discID;
    SBdb db;
    List<String> abrs;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSkip;
    private JLabel jLabelAbr;
    private JLabel jLabelDiscipline;
    private JLabel jLabelWell;
    private JList jListAbr;
    private JList jListSchemes;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public DialogAbnFix(Frame parent, boolean modal, SBdb db, Well well, char discID, List<String> abrs) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.discID = discID;
        this.abrs = abrs;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Fix Semi-Quantitative Abundance in Well: " + this.well.getWellName());
        this.jLabelWell.setText("Well: " + this.well.getWellName() + " (" + this.well.getWellCode() + ") - " + this.well.getHeader().getCountry());
        this.jLabelDiscipline.setText(SBdb.discNounString[SBdb.did2i(this.discID)]);
        for (AbnScheme scheme : this.db.getAbnSchemes()) {
            this.schemeModel.addElement(scheme);
        }
        this.setAbrLabel(null);
        this.jListSchemes.repaint();
    }

    private void setAbrLabel(AbnScheme scheme) {
        String abrString = "Semi-quantitative entries in well/discipline: ";
        LinkedList<String> sortedAbrs = null;
        if (scheme == null) {
            Collections.sort(this.abrs);
        } else {
            sortedAbrs = new LinkedList<String>();
            for (int i = 0; i < scheme.getNClasses(); ++i) {
                String entry = scheme.getEntry(i);
                if (!this.abrs.contains(entry)) continue;
                sortedAbrs.add(entry);
            }
        }
        if (sortedAbrs != null) {
            for (String abr : sortedAbrs) {
                abrString = abrString + abr;
                abrString = abrString + ", ";
            }
            abrString = abrString.substring(0, abrString.length() - 2);
        }
        boolean first = true;
        for (String abr : this.abrs) {
            if (sortedAbrs != null && sortedAbrs.contains(abr)) continue;
            if (first) {
                abrString = abrString + " (";
                first = false;
            }
            abrString = abrString + abr;
            abrString = abrString + ", ";
        }
        if (!first) {
            abrString = abrString.substring(0, abrString.length() - 2);
            abrString = abrString + ")";
        }
        this.jLabelAbr.setText(abrString);
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelWell = new JLabel();
        this.jLabelDiscipline = new JLabel();
        this.jLabelAbr = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jListAbr = new JList();
        this.jButtonSkip = new JButton();
        this.setDefaultCloseOperation(2);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnFix.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnFix.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabelWell.setText("jLabel1");
        this.jLabelDiscipline.setText("jLabel2");
        this.jLabelAbr.setText("jLabel3");
        this.jListSchemes.setModel(this.schemeModel);
        this.jListSchemes.setSelectionMode(0);
        this.jListSchemes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogAbnFix.this.jListSchemesMouseClicked(evt);
            }
        });
        this.jListSchemes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DialogAbnFix.this.jListSchemesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jListAbr.setModel(this.abrModel);
        this.jScrollPane2.setViewportView(this.jListAbr);
        this.jButtonSkip.setText("Skip");
        this.jButtonSkip.setToolTipText("Leave entry and go to next well/discipline.");
        this.jButtonSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnFix.this.jButtonSkipActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 179, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSkip).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jLabelWell).addComponent(this.jLabelDiscipline).addComponent(this.jLabelAbr)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelWell).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDiscipline).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelAbr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 177, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 177, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonSkip).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "no scheme selected");
            return;
        }
        AbnScheme scheme = (AbnScheme)this.jListSchemes.getSelectedValue();
        if (!this.getMatch(scheme)) {
            JOptionPane.showMessageDialog(this, "Scheme entries do not match abbreviations in well.");
            return;
        }
        try {
            this.well.updateAbnScheme(this.discID, scheme);
            this.schemeUsed = scheme;
            this.isOK = true;
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error updating: " + ex.getMessage() + "\n" + SB.sql);
            ex.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private boolean getMatch(AbnScheme scheme) {
        boolean matches = true;
        for (String abr : this.abrs) {
            if (scheme.getIndex(abr) >= 0) continue;
            matches = false;
            break;
        }
        return matches;
    }

    private void jListSchemesValueChanged(ListSelectionEvent evt) {
        AbnScheme scheme = (AbnScheme)this.jListSchemes.getSelectedValue();
        this.abrModel.clear();
        for (int i = 0; i < scheme.getNClasses(); ++i) {
            this.abrModel.addElement(scheme.getClassName(i) + " (" + scheme.getEntry(i) + ")");
        }
        if (this.getMatch(scheme)) {
            this.jListAbr.setBackground(new Color(200, 255, 200));
        } else {
            this.jListAbr.setBackground(new Color(255, 200, 200));
        }
        this.jListAbr.repaint();
        this.setAbrLabel(scheme);
    }

    private void jListSchemesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonSkipActionPerformed(ActionEvent evt) {
        this.isOK = true;
        this.dispose();
    }
}

