/*
 * Decompiled with CFR 0.152.
 */
package sbconvert2_0;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import model1_8.InterpHdr;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Well;
import org.jdesktop.layout.GroupLayout;
import sbconvert2_0.RowEntry;
import sbconvert2_0.TableModelIGDUnassigned;
import util.SbugsFileFilter;
import util.TableSorter;

public class DialogIGDUnassigned
extends JDialog {
    TableModelIGDUnassigned model = new TableModelIGDUnassigned();
    TableSorter sorter = new TableSorter(this.model);
    private JButton jButtonClose;
    private JButton jButtonSaveAs;
    private JScrollPane jScrollPane1;
    private JTable jTableIGD;

    public DialogIGDUnassigned(Frame parent, boolean modal, String string, int igdType, SBdb v18sbdb) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.init(igdType, v18sbdb);
    }

    private void init(int igdType, SBdb v18sbdb) throws SQLException, SBException {
        for (int i = 0; i < TableModelIGDUnassigned.colTitles.length; ++i) {
            this.jTableIGD.getColumnModel().getColumn(i).setPreferredWidth(TableModelIGDUnassigned.colWidths[i]);
            this.jTableIGD.getColumnModel().getColumn(i).setHeaderValue(TableModelIGDUnassigned.colTitles[i]);
        }
        this.sorter.addMouseListenerToHeaderInTable(this.jTableIGD);
        Statement v18stmt = v18sbdb.getDatabase().createStatement();
        String sql = "SELECT top_id,base_id,interp_id,upp_inf,low_inf FROM " + v18sbdb.DBTableName("igd") + " WHERE (SCH_ID=0 OR SCH_ID is null) AND igd_type=" + igdType + " ORDER BY top_id, interp_id";
        ResultSet rs = v18stmt.executeQuery(v18sbdb.modQuery(sql));
        int lastWellID = 0;
        Well well = null;
        v18sbdb.loadInterps();
        while (rs.next()) {
            int topID = rs.getInt("top_id");
            int baseID = rs.getInt("base_id");
            int interpID = rs.getInt("interp_id");
            int wellID = topID / 65536;
            if (wellID != lastWellID) {
                lastWellID = wellID;
                well = v18sbdb.getAddWell(wellID);
                well.loadSamples(null);
            }
            String uppInf = rs.getString("upp_inf");
            String lowInf = rs.getString("low_inf");
            RowEntry rowEntry = new RowEntry();
            rowEntry.wellName = well.getWellName();
            rowEntry.wellCode = well.getWellCode();
            Sample sample = well.getSample(topID);
            rowEntry.topDepth = sample != null ? sample.toString(well.getWellUnits()) : "null: " + topID;
            sample = well.getSample(baseID);
            rowEntry.baseDepth = sample != null ? sample.toString(well.getWellUnits()) : "null: " + baseID;
            InterpHdr interp = v18sbdb.getInterp(interpID);
            rowEntry.interp = interp != null ? interp.toString() : "null: " + interpID;
            rowEntry.uppInf = uppInf;
            rowEntry.lowInf = lowInf;
            this.model.rows.add(rowEntry);
        }
        v18stmt.close();
        this.sorter.reallocateIndexes();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableIGD = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonSaveAs = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTableIGD.setModel(this.sorter);
        this.jScrollPane1.setViewportView(this.jTableIGD);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDUnassigned.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSaveAs.setText("Save As...");
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDUnassigned.this.jButtonSaveAsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 860, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSaveAs).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 499, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonClose).add((Component)this.jButtonSaveAs)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        File setDir = null;
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV files");
        jFileChooser1.addChoosableFileFilter(filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                String fileName = jFileChooser1.getSelectedFile().getPath();
                if (!fileName.toLowerCase().endsWith(".csv")) {
                    fileName = fileName + ".csv";
                }
                String filterString = jFileChooser1.getFileFilter().getDescription();
                FileWriter out = new FileWriter(fileName);
                out.write("StrataBugs output: " + df.format(date) + "\r\n\r\n");
                for (String title : TableModelIGDUnassigned.colTitles) {
                    out.write(title + ",");
                }
                out.write("\r\n");
                for (RowEntry row : this.model.rows) {
                    String text = row.wellName + "," + row.wellCode + "," + row.interp + "," + row.topDepth + "," + row.baseDepth;
                    out.write(text + "\r\n");
                }
                out.close();
                if (JOptionPane.showConfirmDialog(this, "File '" + fileName + "' written", "File Saved", 2) != 0) {
                    // empty if block
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }
}

