/*
 * Decompiled with CFR 0.152.
 */
package sbconvert2_0;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import model1_8.AbnScheme;
import model1_8.AnalystHeader;
import model1_8.Casing;
import model1_8.Categories;
import model1_8.Category;
import model1_8.Cores;
import model1_8.EvProject;
import model1_8.IGDInterval;
import model1_8.IGDIntervalEnv;
import model1_8.IGDIntervalSeq;
import model1_8.IGDIntervalZone;
import model1_8.IGDUnit;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.TxGroup;
import model1_8.Userdef;
import model1_8.Well;
import model1_8.WellInterp;
import model2.Audit;
import model2.Biocom;
import model2.CasingPoint;
import model2.CoredInterval;
import model2.Discipline;
import model2.EnvScheme;
import model2.IGDHdr;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.InterpHdr;
import model2.LOC;
import model2.Project;
import model2.ProjectList;
import model2.SBdb;
import model2.SQPick;
import model2.SampleInsertException;
import model2.Smpdtl;
import model2.Surface;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroupSet;
import model2.WellEvent;
import model2.WellHeader;
import org.jdesktop.layout.GroupLayout;
import sbconvert2_0.DialogAbnFix;
import sbconvert2_0.DialogAnalysts;
import sbconvert2_0.DialogIGDUnassigned;
import sbconvert2_0.DialogList;
import sbconvert2_0.DialogLogin;
import sbconvert2_0.DialogSBConvJdbc;
import sbconvert2_0.SBconv;
import util.SB;
import util.SbugsFileFilter;

public class FrameSBConv
extends JFrame {
    model1_8.SBdb v18sbdb;
    SBdb v2sbdb;
    JFileChooser fileChooser = new JFileChooser();
    Preferences prefRoot;
    SwingWorker task = null;
    int commitPoint = 0;
    int maxCommitPoint = 35;
    int nErrors = 0;
    final String DEFAULT_LOG_FILE = "SBUGS2-0.log";
    boolean checkedCategories = false;
    boolean cancelTask = false;
    private boolean abnAsked = false;
    private boolean abnSchemeToAdd = false;
    boolean SSB_RERUN = false;
    private ButtonGroup buttonGroupConnectionType18;
    private ButtonGroup buttonGroupConnectionType2;
    private ButtonGroup buttonGroupSampleTops;
    private JButton jButtonCheckSemiQuant;
    private JButton jButtonClose;
    private JButton jButtonConnect;
    private JButton jButtonDescribev2;
    private JButton jButtonFixCounties;
    private JButton jButtonHelp;
    private JButton jButtonSBChClinePicks;
    private JButton jButtonSelectv18File;
    private JButton jButtonSelectv2File;
    private JButton jButtonShowChrono;
    private JButton jButtonShowDSN;
    private JButton jButtonShowLstrat;
    private JButton jButtonShowPanel1;
    private JButton jButtonShowPanel2;
    private JButton jButtonShowPanel3;
    private JButton jButtonShowPanel4;
    private JButton jButtonShowSequence;
    private JButton jButtonShowWellsChrono;
    private JButton jButtonShowWellsLstrat;
    private JButton jButtonShowWellsPanel1;
    private JButton jButtonShowWellsPanel2;
    private JButton jButtonShowWellsPanel3;
    private JButton jButtonShowWellsPanel4;
    private JButton jButtonShowWellsSeq;
    private JButton jButtonStart;
    private JButton jButtonStop;
    private JButton jButtonv18liths;
    private JComboBox jComboBoxScheme1;
    private JComboBox jComboBoxScheme2;
    private JComboBox jComboBoxScheme3;
    private JComboBox jComboBoxScheme4;
    private JComboBox jComboBoxSchemeChrono;
    private JComboBox jComboBoxSchemeLstrat;
    private JComboBox jComboBoxSchemeSequence;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JRadioButton jRadioButtonJdbc18;
    private JRadioButton jRadioButtonJdbc2;
    private JRadioButton jRadioButtonOdbc18;
    private JRadioButton jRadioButtonOdbc2;
    private JRadioButton jRadioButtonSampleBases;
    private JRadioButton jRadioButtonSampleTops;
    private JRadioButton jRadioButtonSamplesBoth;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldCommitMax;
    private JTextField jTextFieldCommitPoint;
    private JTextField jTextFieldDSNv18;
    private JTextField jTextFieldDSNv2;
    private JTextField jTextFieldDefaultUser;
    private JTextField jTextFieldErrors;
    private JTextField jTextFieldLogFile;
    private JTextField jTextFieldTablePrefix18;
    private JTextField jTextFieldTablePrefix20;
    private JTextField jTextFieldWellIDFrom;
    private JTextField jTextFieldWellIDTo;
    private JTextPane jTextPaneProgress;

    public FrameSBConv() {
        this.initComponents();
        this.setTitle("StrataBugs v1.8 to v2.0 Conversion Application");
        this.setLocationRelativeTo(null);
        this.init();
    }

    private void init() {
        String isJdbc;
        this.prefRoot = Preferences.userNodeForPackage(SBconv.class).node("v2.0");
        String DSN1_8 = this.prefRoot.get("dsn1_8", "SBUGS1-8");
        this.jTextFieldDSNv18.setText(DSN1_8);
        String DSN = this.prefRoot.get("dsn", "SBUGS2-0");
        this.jTextFieldDSNv2.setText(DSN);
        this.commitPoint = this.prefRoot.getInt("commitpoint", 0);
        this.maxCommitPoint = this.prefRoot.getInt("maxcommitpoint", this.maxCommitPoint);
        this.jTextFieldCommitPoint.setText("" + this.commitPoint);
        this.jTextFieldCommitMax.setText("" + this.maxCommitPoint);
        this.jTextFieldErrors.setText("0");
        this.jTextFieldLogFile.setText("SBUGS2-0.log");
        String defAbr = this.prefRoot.get("userabr", null);
        if (defAbr != null) {
            this.jTextFieldDefaultUser.setText(defAbr);
        }
        if ((isJdbc = this.prefRoot.get("jdbc2", "false")).equalsIgnoreCase("true")) {
            this.jRadioButtonJdbc2.setSelected(true);
        }
        if ((isJdbc = this.prefRoot.get("jdbc18", "false")).equalsIgnoreCase("true")) {
            this.jRadioButtonJdbc18.setSelected(true);
        }
        this.jButtonSBChClinePicks.setVisible(false);
        this.jButtonFixCounties.setVisible(false);
        this.pack();
    }

    private void showUnassignedIGDWellIntervals(int igdType) throws SQLException, SBException {
        if (this.v18sbdb == null || this.v2sbdb == null) {
            JOptionPane.showMessageDialog(this, "Not connected to database(s)", "Error", 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogIGDUnassigned dialog = new DialogIGDUnassigned(this, true, "Unassigned IGD Intervals", igdType, this.v18sbdb);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
    }

    void showUnassignedIGDIntervals(int igdType) throws SQLException {
        if (this.v18sbdb == null || this.v2sbdb == null) {
            JOptionPane.showMessageDialog(this, "Not connected to database(s)", "Error", 2);
            return;
        }
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT distinct(upp_inf ";
        SBdb.DBType dBType = this.v18sbdb.getDBType();
        this.v18sbdb.getDBType();
        sql = dBType == SBdb.DBType.ACCESS ? sql + "& '-' &" : sql + "|| '-' ||";
        sql = sql + " low_inf) as inf FROM " + this.v18sbdb.DBTableName("igd") + " WHERE (SCH_ID=0 OR SCH_ID is null) AND igd_type=" + igdType;
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        LinkedList<String> list = new LinkedList<String>();
        while (rs.next()) {
            String strg = rs.getString("inf");
            System.out.println("IGD String is: " + strg);
            if (strg == null || strg.length() <= 0) continue;
            list.add(strg);
        }
        DialogList dialog = new DialogList(this, true, "Unassigned IGD Intervals", list);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        v18stmt.close();
    }

    void screenCP(BufferedWriter file) throws SQLException {
        if (this.v18sbdb == null || this.v2sbdb == null) {
            JOptionPane.showMessageDialog(this, "Not connected to database(s)", "Error", 2);
            return;
        }
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        int nCA = 0;
        int nCP = 0;
        String sql = "SELECT count(gen_id) as CA FROM " + this.v18sbdb.DBTableName("genus") + " WHERE cat_mnem='CA'";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            nCA = rs.getInt("CA");
        }
        sql = "SELECT count(gen_id) as CP FROM " + this.v18sbdb.DBTableName("genus") + " WHERE cat_mnem='CP'";
        rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            nCP = rs.getInt("CP");
        }
        if (nCP == 0 && nCA > 0) {
            sql = "UPDATE " + this.v18sbdb.DBTableName("genus") + " SET cat_mnem='CP' WHERE cat_mnem='CA'";
            int nUpdated = v18stmt.executeUpdate(this.v18sbdb.modQuery(sql));
            this.outputProgress(false, "\nNumber of CA genera updated in v1.8 database: " + nUpdated);
        }
        v18stmt.close();
        this.v18sbdb.commit();
    }

    void checkCategories(BufferedWriter file, List<String> list) throws SQLException {
        if (this.v18sbdb == null || this.v2sbdb == null) {
            JOptionPane.showMessageDialog(this, "Not connected to database(s)", "Error", 2);
            return;
        }
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT distinct(cat_mnem";
        sql = this.v18sbdb.getDBType() == SBdb.DBType.ACCESS ? sql + "& '-' &" : sql + "|| '-' ||";
        sql = sql + "genus) as gencat FROM " + this.v18sbdb.DBTableName("genus") + " WHERE cat_mnem not in " + "(SELECT cat_mnem FROM " + this.v18sbdb.DBTableName("category") + ")";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            list.add(rs.getString("gencat"));
        }
        v18stmt.close();
    }

    private void saveScheme(int igdType) {
        Component combo = null;
        switch (igdType) {
            case 41: {
                combo = this.jComboBoxScheme1;
                break;
            }
            case 42: {
                combo = this.jComboBoxScheme2;
                break;
            }
            case 43: {
                combo = this.jComboBoxScheme3;
                break;
            }
            case 44: {
                combo = this.jComboBoxScheme4;
                break;
            }
            case 2: {
                combo = this.jComboBoxSchemeLstrat;
                break;
            }
            case 3: {
                combo = this.jComboBoxSchemeChrono;
                break;
            }
            case 10: {
                combo = this.jComboBoxSchemeSequence;
            }
        }
        if (combo.isEnabled() && ((JComboBox)combo).getSelectedIndex() > 0) {
            this.prefRoot.put("scheme" + igdType, ((JComboBox)combo).getSelectedItem().toString());
        }
    }

    private int checkIGDSchemeCombo(int igdType, boolean create) throws SQLException, util.SBException {
        Component combo = null;
        switch (igdType) {
            case 41: {
                combo = this.jComboBoxScheme1;
                break;
            }
            case 42: {
                combo = this.jComboBoxScheme2;
                break;
            }
            case 43: {
                combo = this.jComboBoxScheme3;
                break;
            }
            case 44: {
                combo = this.jComboBoxScheme4;
                break;
            }
            case 2: {
                combo = this.jComboBoxSchemeLstrat;
                break;
            }
            case 3: {
                combo = this.jComboBoxSchemeChrono;
                break;
            }
            case 10: {
                combo = this.jComboBoxSchemeSequence;
            }
        }
        if (combo.isEnabled()) {
            Object obj = ((JComboBox)combo).getSelectedItem();
            if (obj == null) {
                return -1;
            }
            if (obj instanceof model1_8.IGDScheme) {
                model1_8.IGDScheme selectedScheme = (model1_8.IGDScheme)obj;
                return selectedScheme.getID();
            }
            IGDScheme selectedScheme = (IGDScheme)obj;
            if (selectedScheme.getID() == 0 && create) {
                selectedScheme.storeDetails();
                this.v2sbdb.addIGDScheme(selectedScheme);
            }
            return selectedScheme.getID();
        }
        return 0;
    }

    void setIGDSchemeCombo(int igdType) throws SQLException, util.SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT count(top_id) as no_sch FROM " + this.v18sbdb.DBTableName("igd") + " WHERE (SCH_ID=0 OR SCH_ID is null) AND igd_type=" + igdType;
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        Object strg = null;
        if (rs.next()) {
            int noSch = rs.getInt("no_sch");
            System.out.println("Number of zones for igdType " + igdType + " is " + noSch);
            JComboBox combo = null;
            JButton button = null;
            JButton button2 = null;
            String schemeText = "Unassigned ";
            Discipline disc = null;
            switch (igdType) {
                case 41: {
                    combo = this.jComboBoxScheme1;
                    button = this.jButtonShowPanel1;
                    button2 = this.jButtonShowWellsPanel1;
                    schemeText = schemeText + "Panel 1";
                    disc = Discipline.MICRO;
                    break;
                }
                case 42: {
                    combo = this.jComboBoxScheme2;
                    button = this.jButtonShowPanel2;
                    button2 = this.jButtonShowWellsPanel2;
                    schemeText = schemeText + "Panel 2";
                    disc = Discipline.NANNO;
                    break;
                }
                case 43: {
                    combo = this.jComboBoxScheme3;
                    button = this.jButtonShowPanel3;
                    button2 = this.jButtonShowWellsPanel3;
                    schemeText = schemeText + "Panel 3";
                    disc = Discipline.PALY;
                    break;
                }
                case 44: {
                    combo = this.jComboBoxScheme4;
                    button = this.jButtonShowPanel4;
                    button2 = this.jButtonShowWellsPanel4;
                    schemeText = schemeText + "Panel 4";
                    disc = Discipline.MACRO;
                    break;
                }
                case 2: {
                    combo = this.jComboBoxSchemeLstrat;
                    button = this.jButtonShowLstrat;
                    button2 = this.jButtonShowWellsLstrat;
                    schemeText = schemeText + "Lithostratigraphy";
                    break;
                }
                case 3: {
                    combo = this.jComboBoxSchemeChrono;
                    button = this.jButtonShowChrono;
                    button2 = this.jButtonShowWellsChrono;
                    schemeText = schemeText + "Chronostratigraphy";
                    break;
                }
                case 10: {
                    combo = this.jComboBoxSchemeSequence;
                    button = this.jButtonShowSequence;
                    button2 = this.jButtonShowWellsSeq;
                    schemeText = schemeText + "Sequences";
                }
            }
            combo.removeAllItems();
            if (noSch > 0) {
                String selection = this.prefRoot.get("scheme" + igdType, null);
                model1_8.IGDScheme selectedScheme = null;
                ArrayList<model1_8.IGDScheme> list = new ArrayList<model1_8.IGDScheme>();
                if (igdType > 40) {
                    list.addAll(this.v18sbdb.getIGDSchemes(4));
                } else {
                    list.addAll(this.v18sbdb.getIGDSchemes(igdType));
                }
                Collections.sort(list);
                Iterator it = list.iterator();
                int v2igdType = igdType >= 40 ? 4 : igdType;
                IGDScheme v2Scheme = this.v2sbdb.getIGDScheme(schemeText, v2igdType);
                if (v2Scheme == null) {
                    v2Scheme = new IGDScheme(this.v2sbdb, v2igdType, schemeText, disc, igdType == 10 ? IGDScheme.SequenceType.DEPOSITIONAL : null);
                }
                combo.addItem(v2Scheme);
                while (it.hasNext()) {
                    model1_8.IGDScheme scheme = (model1_8.IGDScheme)it.next();
                    combo.addItem(scheme);
                    if (!scheme.toString().equals(selection)) continue;
                    selectedScheme = scheme;
                }
                combo.updateUI();
                if (selectedScheme != null) {
                    combo.setSelectedItem(selectedScheme);
                }
            } else {
                combo.setEnabled(false);
                button.setEnabled(false);
                button2.setEnabled(false);
            }
        }
        v18stmt.close();
    }

    void populateIGDDef() throws SQLException, util.SBException, IOException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        block3: for (int i = 0; i < model2.IGDInterval.igdTypes.length; ++i) {
            String name = model2.IGDInterval.igdTypes[i];
            int igdType = model2.IGDInterval.getIGDType(name);
            switch (igdType) {
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    String sql = "INSERT INTO " + this.v2sbdb.DBTableName("IGD_DEF") + " (NAME, IGD_TYPE, PARENT, HIER) VALUES ('" + name + "'," + igdType + ",0,0)";
                    v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
                    int nHier = model2.IGDIntervalZone.getNHier(igdType, true);
                    for (int j = 1; j <= nHier; ++j) {
                        sql = "INSERT INTO " + this.v2sbdb.DBTableName("IGD_DEF") + " (NAME, IGD_TYPE, PARENT, HIER) VALUES ('" + model2.IGDIntervalZone.getHierName(igdType, j, true) + "'," + igdType + "," + igdType + "," + j + ")";
                        v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
                    }
                    continue block3;
                }
            }
        }
    }

    void copyLithSchemes(BufferedWriter file) throws SQLException, IOException {
        String fileName = "v2Lithology.dat";
        try {
            BufferedReader ifile = new BufferedReader(new FileReader(fileName));
            Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
            String sql = "DELETE FROM " + this.v2sbdb.DBTableName("SBLTHMBR");
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.v2sbdb.DBTableName("SBLTHSCH");
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.v2sbdb.DBTableName("SBLTHPAT");
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.v2sbdb.DBTableName("LITHDESC");
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            String[] fields = new String[]{"lith_id", "descr", "abr", "cmp", "grain_size", "sort_order"};
            ifile.readLine();
            this.readDataFile(ifile, file, "LITHDESC", fields);
            fields = new String[]{"lith_id", "line", "descr"};
            this.readDataFile(ifile, file, "SBLTHPAT", fields);
            fields = new String[]{"lthsch_id", "descr"};
            this.readDataFile(ifile, file, "SBLTHSCH", fields);
            fields = new String[]{"lthsch_id", "lith_id"};
            this.readDataFile(ifile, file, "SBLTHMBR", fields);
            ifile.close();
        }
        catch (FileNotFoundException fnf) {
            ++this.nErrors;
            file.write("\nCannot open lithology file '" + fileName + "' for reading - continuing with no scheme refresh");
        }
    }

    void readDataFile(BufferedReader ifile, BufferedWriter file, String tableName, String[] fields) throws SQLException, IOException {
        int i;
        String sql = "INSERT INTO " + this.v2sbdb.DBTableName(tableName) + " (";
        for (i = 0; i < fields.length; ++i) {
            if (i > 0) {
                sql = sql + ",";
            }
            sql = sql + fields[i];
        }
        sql = sql + ") VALUES (";
        for (i = 0; i < fields.length; ++i) {
            if (i > 0) {
                sql = sql + ",";
            }
            sql = sql + "?";
        }
        sql = sql + ")";
        PreparedStatement pStmt = this.v2sbdb.getDatabase().prepareStatement(sql);
        String line = ifile.readLine();
        while (line != null && line.charAt(0) != '~') {
            int fieldIndex = 1;
            int charIndex = 0;
            if (this.v2sbdb.getDBType() != SBdb.DBType.ORACLE) {
                pStmt.clearParameters();
            }
            while (charIndex < line.length()) {
                String field = "";
                boolean inQuote = false;
                while (charIndex < line.length() && (line.charAt(charIndex) != ',' || inQuote)) {
                    if (line.charAt(charIndex) == '\"') {
                        inQuote = !inQuote;
                    } else {
                        field = field + line.charAt(charIndex);
                    }
                    ++charIndex;
                }
                if (field.length() > 0) {
                    pStmt.setString(fieldIndex, field);
                } else {
                    pStmt.setNull(fieldIndex, 12);
                }
                ++fieldIndex;
                ++charIndex;
            }
            while (fieldIndex <= fields.length) {
                pStmt.setNull(fieldIndex, 12);
                ++fieldIndex;
            }
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException se) {
                if (se.getMessage().equalsIgnoreCase("GENERAL ERROR") || se.getMessage().indexOf("ORA-00001") > 0) {
                    ++this.nErrors;
                    String msg = "Duplicate record error when inserting into " + tableName + ": " + line;
                    System.out.println(msg);
                    file.write("\n" + msg);
                }
                if (se.getMessage().indexOf("You cannot add or change a record") > 0 || se.getMessage().indexOf("ORA-02291") > 0) {
                    ++this.nErrors;
                    String msg = "Related record error when inserting into " + tableName + ": " + line;
                    System.out.println(msg);
                    file.write("\n" + msg);
                }
                System.out.println("SQL :" + sql);
                file.write("\n" + sql + ",line=" + line);
                throw se;
            }
            line = ifile.readLine();
        }
    }

    void createLithFile() throws SQLException, IOException {
        BufferedWriter file = new BufferedWriter(new FileWriter("v2Lithology.dat", false));
        this.createDataFile("LITHDESC", file, " ORDER BY lithcode");
        this.createDataFile("SBLTHPAT", file, " ORDER BY lithcode,line");
        this.createDataFile("SBLTHSCH", file, " ORDER BY lthsch_id");
        this.createDataFile("SBLTHMBR", file, " ORDER BY lthsch_id,lith_id");
        file.close();
    }

    void createDataFile(String tableName, BufferedWriter file, String clause) throws SQLException, IOException {
        SB.sql = "";
        String selectQuery = "SELECT * FROM " + this.v18sbdb.DBTableName(tableName);
        if (clause != null) {
            selectQuery = selectQuery + " " + clause;
        }
        Statement stmt = this.v18sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(selectQuery);
        ResultSetMetaData meta = rs.getMetaData();
        int nCols = meta.getColumnCount();
        file.write("~" + tableName + "\n");
        while (rs.next()) {
            for (int col = 1; col <= nCols; ++col) {
                Object obj = rs.getObject(col);
                if (obj != null) {
                    int type = meta.getColumnType(col);
                    int prec = meta.getScale(col);
                    if ((type == 3 || type == 4 || type == 6 || type == 8 || type == -5) && prec == 0) {
                        double val = Double.parseDouble(obj.toString());
                        int intVal = (int)val;
                        file.write("" + intVal);
                    } else if (type == 1 || type == 12) {
                        file.write("\"" + obj.toString() + "\"");
                    } else {
                        file.write(obj.toString());
                    }
                }
                if (col >= nCols) continue;
                file.write(",");
            }
            file.write("\n");
        }
        stmt.close();
    }

    void copyIGDHdr(BufferedWriter file) throws SQLException, util.SBException, IOException {
        if (!this.v18sbdb.hasIGDHdr()) {
            file.write("\nNo IGD Header table in v1.8 database");
            return;
        }
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT well_id,interp_id,igd_type,source,modified,authorised,comments FROM " + this.v18sbdb.DBTableName("igd_hdr");
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        Object strg = null;
        block5: while (rs.next()) {
            int wellID = rs.getInt("well_id");
            int interpID = rs.getInt("interp_id");
            int igdType = rs.getInt("igd_type");
            String source = rs.getString("source");
            java.sql.Date modified = rs.getDate("modified");
            String authorised = rs.getString("authorised");
            String comments = rs.getString("comments");
            int schID = 0;
            switch (igdType) {
                case 2: 
                case 3: 
                case 10: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    try {
                        sql = "SELECT distinct(sch_id) FROM " + this.v18sbdb.DBTableName("igd") + " WHERE top_id>=" + wellID * 65536 + " AND top_id<" + (wellID + 1) * 65536;
                        sql = igdType == 4 ? sql + " AND igd_type >=41 AND igd_type <=44" : sql + " AND igd_type=" + igdType;
                        ResultSet rs2 = v18stmt2.executeQuery(this.v18sbdb.modQuery(sql));
                        boolean processed = false;
                        while (rs2.next()) {
                            schID = rs2.getInt("sch_id");
                            if (schID > 0) {
                                IGDHdr hdr = new IGDHdr(this.v2sbdb, wellID, interpID, schID, source, modified, authorised, comments);
                            } else {
                                System.out.print("\nCannot process null SCH_ID IGD header for well: " + wellID + " igd type: " + igdType);
                                file.write("\nCannot process  null SCH_ID IGD header for well: " + wellID + " igd type: " + igdType);
                            }
                            processed = true;
                        }
                        if (processed) continue block5;
                        System.out.print("\nCannot process IGD header for well: " + wellID + " igd type: " + igdType);
                        file.write("\nCannot process IGD header for well: " + wellID + " igd type: " + igdType);
                        break;
                    }
                    catch (SQLException sqle) {
                        ++this.nErrors;
                        System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                        file.write("\n" + sqle.getMessage() + "\n" + SB.sql);
                        sqle.printStackTrace();
                    }
                }
            }
        }
    }

    void copyIGDEnv(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        List<model1_8.EnvScheme> envSchemes = this.v18sbdb.getEnvSchemes();
        String sql = "SELECT distinct floor(top_id/65536) AS well_id FROM " + this.v18sbdb.DBTableName("igd_env");
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            try {
                int wellID = rs.getInt("well_id");
                Well well = this.v18sbdb.getAddWell(wellID);
                if (well == null) {
                    throw new util.SBException("\nUnknown well for IGD_ENV : " + wellID);
                }
                well.loadSamples(null);
                System.out.println("IGD_ENV Processing well: " + well);
                well.loadSamples(null);
                well.loadInterps();
                for (WellInterp wellInterp : well.interps) {
                    if (wellInterp == null) continue;
                    try {
                        wellInterp.loadEnvs(well, envSchemes);
                        Iterator<IGDIntervalEnv> zit = wellInterp.getEnvs().iterator();
                        while (zit.hasNext() && !this.cancelTask) {
                            IGDIntervalEnv zone = zit.next();
                            int schID = zone.getSchID();
                            int topID18 = zone.getTopID();
                            int topID = topID18 - wellID * 65536;
                            topID = this.checkSampID(v18stmt2, v2stmt, wellID, topID, topID18);
                            int baseID18 = zone.getBaseID();
                            int baseID = baseID18 - wellID * 65536;
                            baseID = this.checkSampID(v18stmt2, v2stmt, wellID, baseID, baseID18);
                            try {
                                model2.IGDIntervalEnv zone2 = new model2.IGDIntervalEnv(this.v2sbdb, v2stmt, wellID, wellInterp.getInterpID(), topID, baseID, zone.getUp(), zone.getUd(), zone.getLp(), zone.getLd(), zone.getQual(), schID, zone.getModified(), zone.getModifier());
                            }
                            catch (SQLException sqle) {
                                file.write("\n" + sqle.getMessage() + "\n" + SB.sql);
                            }
                            catch (util.SBException sbe) {
                                this.outputProgress(false, "\n" + sbe.getMessage());
                                file.write("\n" + sbe.getMessage() + "\n");
                                ++this.nErrors;
                            }
                            catch (RuntimeException ex) {
                                ++this.nErrors;
                                this.outputProgress(false, "\n" + ex.getMessage());
                                file.write("\n" + ex.getMessage());
                            }
                        }
                    }
                    catch (util.SBException sbe) {
                        ++this.nErrors;
                        file.write("\nCannot load envs for well: " + wellID + "," + sbe.getMessage());
                        sbe.printStackTrace();
                    }
                    catch (RuntimeException ex) {
                        ++this.nErrors;
                        file.write("\n" + ex.getMessage());
                    }
                }
            }
            catch (SBException sbe) {
                ++this.nErrors;
                System.out.print("\n" + sbe.getMessage() + "\n");
                file.write("\n" + sbe.getMessage() + "\n");
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                file.write("\n" + sqle.getMessage() + "\n" + SB.sql);
            }
            catch (RuntimeException ex) {
                ++this.nErrors;
                file.write("\n" + ex.getMessage());
            }
        }
        v18stmt.close();
        v18stmt2.close();
        v2stmt.close();
    }

    void copyIGD(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT distinct floor(top_id/65536) AS well_id, igd_type FROM " + this.v18sbdb.DBTableName("igd");
        SBdb.DBType dBType = this.v18sbdb.getDBType();
        this.v18sbdb.getDBType();
        if (dBType != SBdb.DBType.ACCESS) {
            sql = sql + " ORDER BY well_id, igd_type";
        }
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        Object strg = null;
        int[] defaultSchID = new int[15];
        defaultSchID[2] = this.checkIGDSchemeCombo(2, true);
        defaultSchID[3] = this.checkIGDSchemeCombo(3, true);
        defaultSchID[10] = this.checkIGDSchemeCombo(10, true);
        defaultSchID[11] = this.checkIGDSchemeCombo(41, true);
        defaultSchID[12] = this.checkIGDSchemeCombo(42, true);
        defaultSchID[13] = this.checkIGDSchemeCombo(43, true);
        defaultSchID[14] = this.checkIGDSchemeCombo(44, true);
        while (rs.next() && !this.cancelTask) {
            int wellID = rs.getInt("well_id");
            int igdType = rs.getInt("igd_type");
            Well well = null;
            try {
                well = this.v18sbdb.getAddWell(wellID);
            }
            catch (Exception ex) {
                System.out.println("Exception in copyIGD: " + ex.getMessage());
            }
            if (well == null) {
                file.write("\nUnknown well for IGD : " + wellID);
                continue;
            }
            well.loadSamples(null);
            try {
                well.loadInterps();
                Iterator itr = well.interps.iterator();
                while (itr.hasNext() && !this.cancelTask) {
                    WellInterp wellInterp = (WellInterp)itr.next();
                    if (wellInterp == null) continue;
                    try {
                        List allZones;
                        wellInterp.loadZones(igdType, wellID, well);
                        if (igdType == 10) {
                            wellInterp.loadSQTracts(wellID);
                        }
                        if ((allZones = wellInterp.getIGDList(igdType)) == null) continue;
                        Iterator zit = allZones.iterator();
                        while (zit.hasNext() && !this.cancelTask) {
                            int lowZone;
                            IGDScheme scheme;
                            IGDIntervalZone zone = (IGDIntervalZone)zit.next();
                            int schID = zone.getSchID();
                            if (schID == 0) {
                                if (igdType > 40) {
                                    String title = well.getBzTitles()[igdType - 41];
                                    if (title != null && title.length() > 0) {
                                        try {
                                            schID = this.v2sbdb.getAddIGDScheme(title, 4, SBdb.discArr[igdType - 41]);
                                        }
                                        catch (util.SBException sbe) {
                                            schID = defaultSchID[igdType - 30];
                                        }
                                    } else {
                                        schID = defaultSchID[igdType - 30];
                                    }
                                } else {
                                    schID = defaultSchID[igdType];
                                }
                            }
                            if ((scheme = this.v2sbdb.getIGDScheme(schID)) == null) {
                                file.write("\n++++++++ Scheme ID not found in database: " + schID + " for interval: " + zone);
                                schID = this.getDefaultSchID(igdType, well, defaultSchID);
                            }
                            scheme = this.v2sbdb.getIGDScheme(schID);
                            scheme.loadUnits();
                            int topID18 = zone.getTopID();
                            int topID = topID18 - wellID * 65536;
                            topID = this.checkSampID(v18stmt2, v2stmt, wellID, topID, topID18);
                            int baseID18 = zone.getBaseID();
                            int baseID = baseID18 - wellID * 65536;
                            baseID = this.checkSampID(v18stmt2, v2stmt, wellID, baseID, baseID18);
                            int uppZone = zone.getUppZone();
                            if (uppZone > 0 && scheme.findUnit(uppZone) == null) {
                                uppZone = 0;
                                file.write("\nReset upper Unit ID for zone:" + zone + " for well: " + well + ", igd_type=" + igdType);
                            }
                            if ((lowZone = zone.getLowZone()) > 0 && scheme.findUnit(lowZone) == null) {
                                lowZone = 0;
                                file.write("\nReset lower Unit ID for zone:" + zone + " for well: " + well + ", igd_type=" + igdType);
                            }
                            try {
                                if (igdType == 10) {
                                    SQPick pick;
                                    IGDIntervalSeq seq = (IGDIntervalSeq)zone;
                                    int surfaceID = 0;
                                    if (seq.getMfsID() > 0 && (surfaceID = this.getSurface(file, schID, seq, Surface.SurfaceType.MFS)) > 0) {
                                        int mfsID = seq.getMfsID() - wellID * 65536;
                                        mfsID = this.checkSampID(v18stmt2, v2stmt, wellID, mfsID, seq.getMfsID());
                                        pick = new SQPick(v2stmt, this.v2sbdb, wellID, wellInterp.getInterpID(), surfaceID, seq.getUppInf(), mfsID, 3, seq.getQUzone() || seq.getQLzone(), true);
                                    }
                                    if (seq.getTsID() > 0 && (surfaceID = this.getSurface(file, schID, seq, Surface.SurfaceType.TS)) > 0) {
                                        int tsID = seq.getTsID() - wellID * 65536;
                                        tsID = this.checkSampID(v18stmt2, v2stmt, wellID, tsID, seq.getTsID());
                                        try {
                                            pick = new SQPick(v2stmt, this.v2sbdb, wellID, wellInterp.getInterpID(), surfaceID, seq.getLowInf() != null && seq.getLowInf().length() > 0 ? seq.getLowInf() : seq.getUppInf(), tsID, 3, seq.getQUzone() || seq.getQLzone(), false);
                                        }
                                        catch (SQLException pickerror) {
                                            System.out.println("Non-insert of sequence TS.");
                                        }
                                    }
                                    if (seq.getBaseID() > 0 && (surfaceID = this.getSurface(file, schID, seq, Surface.SurfaceType.SB)) > 0) {
                                        SQPick pick2 = new SQPick(v2stmt, this.v2sbdb, wellID, wellInterp.getInterpID(), surfaceID, seq.getLowInf() != null && seq.getLowInf().length() > 0 ? seq.getLowInf() : seq.getUppInf(), baseID, seq.getBaseBndID(), seq.getQUzone() || seq.getQLzone(), true);
                                    }
                                    if (seq.getTopID() <= 0 || (surfaceID = this.getSurface(file, schID, seq, Surface.SurfaceType.SB)) <= 0) continue;
                                    try {
                                        SQPick pick3 = new SQPick(v2stmt, this.v2sbdb, wellID, wellInterp.getInterpID(), surfaceID, seq.getUppInf(), topID, seq.getTopBndID(), seq.getQUzone(), false);
                                    }
                                    catch (SQLException pickerror) {
                                        System.out.println("Non-insert of sequence top.");
                                    }
                                    continue;
                                }
                                int hier = zone.getPlotPos();
                                switch (igdType) {
                                    case 3: {
                                        model2.IGDUnit unit;
                                        hier = hier == 1 ? 6 : 7;
                                        if (uppZone > 0 && (unit = scheme.findUnit(uppZone)) != null && unit.getName().equalsIgnoreCase(zone.getUppInf())) {
                                            hier = unit.getHier();
                                        }
                                        if (lowZone <= 0 || (unit = scheme.findUnit(lowZone)).getHier() == hier) break;
                                        hier = zone.getPlotPos() == 1 ? 6 : 7;
                                        break;
                                    }
                                    case 41: 
                                    case 42: 
                                    case 43: 
                                    case 44: {
                                        if (hier <= 1) break;
                                        --hier;
                                    }
                                }
                                try {
                                    model2.IGDIntervalZone zone2 = new model2.IGDIntervalZone(v2stmt, this.v2sbdb, wellID, igdType, wellInterp.getInterpID(), hier, topID, baseID, zone.getTopBndID(), zone.getBaseBndID(), zone.getTopAnalyst(), zone.getBaseAnalyst(), schID, zone.getQUzone(), uppZone, zone.getUppInf(), zone.getQLzone(), lowZone, zone.getLowInf(), zone.getSep(), zone.getModified(), zone.getModifier());
                                }
                                catch (SQLException ex) {
                                    if (ex.getMessage().equalsIgnoreCase("General Error") || ex.getMessage().indexOf("ORA-00001") > 0) {
                                        try {
                                            schID = this.getDefaultSchID(igdType, well, defaultSchID);
                                        }
                                        catch (util.SBException sbe) {
                                            throw ex;
                                        }
                                        uppZone = 0;
                                        lowZone = 0;
                                        model2.IGDIntervalZone zone2 = new model2.IGDIntervalZone(v2stmt, this.v2sbdb, wellID, igdType, wellInterp.getInterpID(), hier, topID, baseID, zone.getTopBndID(), zone.getBaseBndID(), zone.getTopAnalyst(), zone.getBaseAnalyst(), schID, zone.getQUzone(), uppZone, zone.getUppInf(), zone.getQLzone(), lowZone, zone.getLowInf(), zone.getSep(), zone.getModified(), zone.getModifier());
                                        continue;
                                    }
                                    throw ex;
                                }
                            }
                            catch (SQLException sqle) {
                                ++this.nErrors;
                                file.write("\nWell: " + well + " : " + " Version: " + wellInterp.toString() + " Type: " + IGDInterval.getIGDName(igdType) + " Interval: " + zone.toString() + "\n.." + sqle.getMessage() + "\n.." + SB.sql + "\n");
                            }
                            catch (IllegalArgumentException iae) {
                                ++this.nErrors;
                                file.write("\nWell: " + well + " : " + " Version: " + wellInterp.toString() + " Type: " + IGDInterval.getIGDName(igdType) + " Interval: " + zone.toString() + "\n.." + iae.getMessage() + "\n");
                            }
                        }
                    }
                    catch (util.SBException sbe) {
                        ++this.nErrors;
                        file.write("\nCannot load zones for well: " + well + "," + sbe.getMessage());
                        sbe.printStackTrace();
                    }
                    catch (RuntimeException ex) {
                        ++this.nErrors;
                        file.write("\nCannot load zones for well: " + well + "," + ex.getMessage());
                        file.write("\n" + ex.getMessage());
                    }
                }
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                file.write("\nWell: " + well + sqle.getMessage() + "\n" + SB.sql);
            }
        }
        v18stmt.close();
        v18stmt2.close();
        v2stmt.close();
    }

    int getDefaultSchID(int igdType, Well well, int[] defaultSchID) throws SQLException, util.SBException {
        int schID;
        if (igdType > 40) {
            String title = well.getBzTitles()[igdType - 41];
            if (title != null && title.length() > 0) {
                try {
                    schID = this.v2sbdb.getAddIGDScheme(title, 4, SBdb.discArr[igdType - 41]);
                }
                catch (util.SBException sbe) {
                    schID = defaultSchID[igdType - 30];
                }
            } else {
                schID = defaultSchID[igdType - 30];
            }
        } else {
            schID = defaultSchID[igdType];
        }
        IGDScheme scheme = this.v2sbdb.getIGDScheme(schID);
        if (scheme == null) {
            throw new util.SBException("Can't find v2 IGD scheme for ID: " + schID);
        }
        return schID;
    }

    int getSurface(BufferedWriter file, int schID, IGDIntervalSeq zone, Surface.SurfaceType type) throws SQLException, util.SBException, IOException {
        int surfaceID = 0;
        IGDScheme scheme2 = this.v2sbdb.getIGDScheme(schID);
        if (scheme2 == null) {
            throw new util.SBException("Attempt to get surface for scheme which does not exist: schID is " + schID);
        }
        if (zone.getUppZone() > 0) {
            int unitID = zone.getUppZone();
            if (type == Surface.SurfaceType.SB && zone.getLowZone() > 0 && zone.getLowZone() != zone.getUppZone()) {
                unitID = zone.getLowZone();
            }
            surfaceID = scheme2.findSurfaceID(unitID, type);
        } else {
            String igdUnitName = zone.getUppInf();
            if (igdUnitName == null || igdUnitName.length() == 0) {
                file.write("\nCannot create SQ Tract surface for sequence: " + zone);
                System.out.print("\nCannot create SQ Tract surface for sequence: " + zone);
            } else {
                if (type == Surface.SurfaceType.SB && !zone.getUppInf().equals(zone.getLowInf()) && zone.getLowInf() != null && zone.getLowInf().length() > 0) {
                    igdUnitName = zone.getLowInf();
                }
                surfaceID = scheme2.findSurfaceID(igdUnitName, type, true);
            }
        }
        return surfaceID;
    }

    void copyLastval(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT usrid, name, intval, fltval, charval FROM " + this.v18sbdb.DBTableName("lastval");
        ResultSet rs = v18stmt.executeQuery(sql);
        String strg = null;
        while (rs.next()) {
            String abr = rs.getString("usrid");
            if (this.v2sbdb.getUser(abr) == null) continue;
            int userID = this.v2sbdb.getUser(abr).getUsrID();
            String name = rs.getString("name");
            if (name == null) continue;
            name = name.toUpperCase().trim();
            int intVal = rs.getInt("intval");
            double fltVal = rs.getDouble("fltval");
            String str = rs.getString("charval");
            if (str != null) {
                str = str.trim();
            }
            if (intVal > 0) {
                str = "" + intVal;
            } else if (fltVal > 0.001) {
                str = "" + fltVal;
            }
            if (str == null || str.length() <= 0) continue;
            try {
                strg = "INSERT INTO " + this.v2sbdb.DBTableName("pref_user") + " (user_id, pref_key, pref_value) VALUES (" + userID + ",'" + name + "'," + SB.DBString(str) + ")";
                v2stmt.executeUpdate(this.v2sbdb.modQuery(strg));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                file.write("\n" + sqle.getMessage() + "\n" + SB.sql);
            }
        }
        v18stmt.close();
        v2stmt.close();
    }

    void copyBcmmnts(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT usamp_id,lsamp_id,analyst";
        if (this.v18sbdb.hasBiocomSource()) {
            sql = sql + ",source";
        }
        sql = sql + ",interp_id,disc_id,comments FROM " + this.v18sbdb.DBTableName("bcmmnts") + " ORDER BY usamp_id";
        ResultSet rs = v18stmt.executeQuery(sql);
        Object strg = null;
        while (rs.next()) {
            int v18usampID = 0;
            int v18lsampID = 0;
            try {
                v18usampID = rs.getInt("usamp_id");
                v18lsampID = rs.getInt("lsamp_id");
            }
            catch (SQLException sqle) {
                file.write("\nError reading top/base sampID for biocom : " + sqle.getMessage());
                System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                continue;
            }
            String analyst = rs.getString("analyst");
            String source = "";
            if (this.v18sbdb.hasBiocomSource()) {
                source = rs.getString("source");
            }
            int interpID = rs.getInt("interp_id");
            char discID = SB.getDBChar(rs, "disc_id");
            String comments = rs.getString("comments");
            int wellID = v18usampID / 65536;
            int usampID = v18usampID - wellID * 65536;
            try {
                int analystID;
                int lsampID;
                usampID = this.checkSampID(v18stmt2, v2stmt, wellID, usampID, v18usampID);
                if (v18lsampID > 0) {
                    if (v18lsampID < wellID * 65536 || v18lsampID > (wellID + 1) * 65536) {
                        lsampID = usampID;
                    } else {
                        lsampID = v18lsampID - wellID * 65536;
                        lsampID = this.checkSampID(v18stmt2, v2stmt, wellID, lsampID, v18lsampID);
                    }
                } else {
                    lsampID = usampID;
                }
                if (this.v2sbdb.getUser(analyst) == null) {
                    if (analyst != null && analyst.length() > 0) {
                        comments = analyst + " " + comments;
                    }
                    analystID = this.v2sbdb.getUser().getUsrID();
                } else {
                    analystID = this.v2sbdb.getUser(analyst).getUsrID();
                }
                model2.Well well = this.v2sbdb.getAddWell(wellID);
                if (well == null) {
                    file.write("\nUnknown well for biocom : " + usampID + " wellID: " + wellID);
                    continue;
                }
                try {
                    Biocom.Builder.conversionStore(this.v2sbdb, discID, usampID, lsampID, analystID, comments, source, wellID, interpID, v2stmt);
                }
                catch (SQLException sqle) {
                    ++this.nErrors;
                    System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                    file.write("\nWell: " + well + sqle.getMessage() + "\n" + SB.sql);
                }
                catch (RuntimeException ex) {
                    ++this.nErrors;
                    file.write("\nCannot add biocom for well: " + well + "," + ex.getMessage());
                    file.write("\n" + ex.getMessage());
                }
            }
            catch (util.SBException se) {
                file.write("\nUnknown well for biocom : " + usampID + " wellID: " + wellID);
            }
        }
        v18stmt.close();
        v18stmt2.close();
        v2stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copySchemes3(BufferedWriter file) throws SQLException, util.SBException, SBException, IOException {
        int[] igdTypes = new int[]{2, 3, 4, 10};
        this.v18sbdb.unloadIGDSchemes();
        for (int igdType : igdTypes) {
            Collection<model1_8.IGDScheme> schemes = this.v18sbdb.getIGDSchemes(igdType);
            this.v2sbdb.getIGDSchemes(igdType);
            for (model1_8.IGDScheme scheme : schemes) {
                scheme.loadUnits();
                char discID = '\u0000';
                switch (scheme.getIGDType()) {
                    case 41: {
                        discID = 'M';
                        break;
                    }
                    case 42: {
                        discID = 'N';
                        break;
                    }
                    case 43: {
                        discID = 'P';
                        break;
                    }
                    case 44: {
                        discID = 'A';
                    }
                }
                IGDScheme scheme2 = new IGDScheme(this.v2sbdb, scheme.getID(), igdType, discID, scheme.toString(), igdType == 10 ? IGDScheme.SequenceType.DEPOSITIONAL : null, scheme.getCreated(), this.v2sbdb.getUser(scheme.getCreator()));
                Iterator<IGDUnit> itU = scheme.getUnits().iterator();
                Statement unitAdderStmt = this.v2sbdb.getDatabase().createStatement();
                try {
                    while (itU.hasNext()) {
                        IGDUnit unit = itU.next();
                        if (unit.getUage() > (double)0.0029f && unit.getLage() < (double)0.0029f) {
                            unit.setLageSpecial(unit.getUage());
                        }
                        int hier = unit.getHier();
                        if (igdType == 4) {
                            if (hier == 1) {
                                boolean skip = false;
                                for (IGDUnit overlapUnit : scheme.getUnits()) {
                                    if (overlapUnit == unit || overlapUnit.getHier() != 2 || !(overlapUnit.getUage() < unit.getLage()) || !(overlapUnit.getLage() > unit.getUage())) continue;
                                    skip = true;
                                    break;
                                }
                                if (skip) {
                                    file.write("\nWarning, dropping 'Scheme' from hierarchy for : " + unit.getName());
                                    continue;
                                }
                            } else {
                                --hier;
                            }
                        }
                        IGDUnit.Builder builder = new IGDUnit.Builder(this.v2sbdb).name(unit.getName()).abr(unit.getAbr()).hier(hier).colour(unit.getColour());
                        builder.age((double)Math.round(unit.getUage() * 1000.0) / 1000.0, (double)Math.round(unit.getLage() * 1000.0) / 1000.0);
                        scheme2.getUnits().add(model2.IGDUnit.convert(builder, unit.getID(), scheme2.getID(), igdType, unit.getCreated(), this.v2sbdb.getUser(unit.getCreator()), unitAdderStmt));
                    }
                }
                finally {
                    unitAdderStmt.close();
                }
                this.v2sbdb.addIGDScheme(scheme2);
                if (igdType != 10) continue;
                for (model2.IGDUnit unit : scheme2.getUnits()) {
                    String name = "";
                    if (unit.getName() != null) {
                        name = unit.getName().trim().length() > 76 ? unit.getName().trim().substring(0, 76) : unit.getName().trim();
                    }
                    Surface.convert(new Surface.Builder(this.v2sbdb).name(name + " MFS").type(Surface.SurfaceType.MFS), scheme.getID());
                    Surface.convert(new Surface.Builder(this.v2sbdb).name(name + " TS").type(Surface.SurfaceType.TS), scheme.getID());
                    Surface.convert(new Surface.Builder(this.v2sbdb).age(unit.getLage()).name(name + " SB").type(Surface.SurfaceType.SB), scheme.getID());
                }
            }
        }
    }

    void copyCmpStd(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT std_id, name, topcsu, basecsu, units, creator, created FROM " + this.v18sbdb.DBTableName("cmpstd");
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            double baseCsu;
            double topCsu;
            int stdId = rs.getInt("std_id");
            String name = rs.getString("name");
            double minage = topCsu = rs.getDouble("topcsu");
            double maxage = baseCsu = rs.getDouble("basecsu");
            String units = rs.getString("units");
            units = units != null ? (units.startsWith("C") ? "C" : "A") : "A";
            String creator = rs.getString("creator");
            Date created = rs.getDate("created");
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("cmpstd") + " (std_id, name, minage, maxage, topcsu, basecsu, units, created, creator, modified, modifier) VALUES (";
            sql = sql + stdId + ",";
            sql = sql + SB.DBString(name) + ",";
            sql = sql + minage + "," + maxage + "," + topCsu + "," + baseCsu + "," + SB.DBString(units) + ",";
            if (created == null) {
                created = new Date();
            }
            sql = sql + SB.DBString(SB.DBdf.format(created)) + ",";
            model2.Userdef cUser = this.v2sbdb.getUser(creator);
            if (cUser == null) {
                cUser = this.v2sbdb.getUser();
            }
            sql = sql + cUser.getUsrID() + ",";
            sql = sql + SB.DBString(SB.DBdf.format(created)) + ",";
            sql = sql + cUser.getUsrID() + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                String msg = "Error inserting: " + sqle + " SQL: " + sql;
                System.out.println(msg);
                file.write("\n" + msg);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copyCmpStdEv(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT std_id, ev_id, ev_type, csu FROM " + this.v18sbdb.DBTableName("cmpstdev");
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            int stdId = rs.getInt("std_id");
            int evID = rs.getInt("ev_id");
            char evType = SB.getDBChar(rs, "ev_type");
            switch (evType) {
                case 'F': 
                case 'L': 
                case 'S': {
                    break;
                }
                default: {
                    evType = 'S';
                }
            }
            double csu = rs.getDouble("csu");
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("cmpstdev") + " (std_id, ev_id, ev_type, csu) VALUES (";
            sql = sql + stdId + "," + evID + "," + SB.DBChar(evType) + "," + csu + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                String msg = "Error inserting: " + sqle + " SQL: " + sql;
                System.out.println(msg);
                file.write("\n" + msg);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void checkSemiQuant() throws SQLException {
        if (this.v18sbdb == null || this.v2sbdb == null) {
            JOptionPane.showMessageDialog(this, "Not connected to database(s)", "Error", 2);
            return;
        }
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        List<AbnScheme> v18abnSchemes = this.v18sbdb.getAbnSchemes();
        LinkedList<AbnScheme> usedSchemes = new LinkedList<AbnScheme>();
        Well lastWell = null;
        String lastDiscID = null;
        LinkedList<String> abrs = new LinkedList<String>();
        String sql = "SELECT DISTINCT floor(samp_id/65536) AS well_id,disc_id,subj_abund";
        sql = sql + " FROM " + this.v18sbdb.DBTableName("FSSABND") + " WHERE (counts IS NULL OR counts=0) AND subj_abund IS NOT NULL ORDER BY floor(samp_id/65536), disc_id";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            String discID = rs.getString("disc_id");
            String subjAbund = rs.getString("subj_abund");
            if (subjAbund.length() <= 0 || subjAbund.equals("+")) continue;
            subjAbund = subjAbund.toUpperCase().trim();
            try {
                Well well18 = this.v18sbdb.getAddWell(wellID);
                if (well18 != lastWell || !discID.equals(lastDiscID)) {
                    if (lastWell != null && !this.fixv18AbnScheme(v18abnSchemes, usedSchemes, lastWell, lastDiscID, abrs)) {
                        lastWell = null;
                        break;
                    }
                    lastWell = well18;
                    lastDiscID = discID;
                    abrs.clear();
                }
                if (abrs.contains(subjAbund)) continue;
                abrs.add(subjAbund);
            }
            catch (SBException se) {
                System.out.print("\n" + se.getMessage() + "\n");
            }
        }
        if (lastWell != null) {
            this.fixv18AbnScheme(v18abnSchemes, usedSchemes, lastWell, lastDiscID, abrs);
        }
        this.v18sbdb.commit();
        if (lastWell != null) {
            JOptionPane.showMessageDialog(this, "Check complete", this.getTitle(), 1);
        } else {
            JOptionPane.showMessageDialog(this, "No semi-quant well data found.", this.getTitle(), 1);
        }
    }

    private boolean fixv18AbnScheme(List v18abnSchemes, List<AbnScheme> usedSchemes, Well lastWell, String lastDiscID, LinkedList<String> abrs) throws SQLException {
        AbnScheme abnScheme = null;
        abnScheme = lastWell.fillAbnScheme(v18abnSchemes, lastDiscID.charAt(0), true);
        boolean OK = true;
        if (abnScheme == null) {
            OK = false;
        } else {
            for (String subjAbund : abrs) {
                if (abnScheme.getIndex(subjAbund) >= 0) continue;
                OK = false;
                break;
            }
        }
        if (!OK) {
            for (AbnScheme scheme : usedSchemes) {
                boolean matches = true;
                for (String abr : abrs) {
                    if (scheme.getIndex(abr) >= 0) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                lastWell.updateAbnScheme(lastDiscID.charAt(0), scheme);
                return true;
            }
            DialogAbnFix dialog = new DialogAbnFix(this, true, this.v18sbdb, lastWell, lastDiscID.charAt(0), abrs);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK) {
                return false;
            }
            if (dialog.schemeUsed != null) {
                if (!this.abnAsked) {
                    int opt = JOptionPane.showConfirmDialog(this, "Do you want to use the same matched schemes for all future matches which contain the same classes?", "SBConvert", 1, 3);
                    if (opt == 2) {
                        return false;
                    }
                    if (opt == 0) {
                        this.abnSchemeToAdd = true;
                    }
                    this.abnAsked = true;
                }
                if (this.abnSchemeToAdd) {
                    usedSchemes.add(dialog.schemeUsed);
                }
            }
        }
        return true;
    }

    int getWellFrom() {
        int wellIDFrom = 0;
        if (this.jTextFieldWellIDFrom.getText().length() > 0) {
            wellIDFrom = Integer.parseInt(this.jTextFieldWellIDFrom.getText());
            this.outputProgress(false, "\nProcess restricted from well ID: " + wellIDFrom);
        }
        return wellIDFrom;
    }

    int getWellTo(boolean setMax) {
        int wellIDTo = 999999;
        if (this.jTextFieldWellIDTo.getText().length() > 0) {
            wellIDTo = Integer.parseInt(this.jTextFieldWellIDTo.getText());
            this.outputProgress(false, "\nProcess restricted to well ID: " + wellIDTo);
            if (setMax) {
                this.maxCommitPoint = 16;
                this.jTextFieldCommitMax.setText("" + this.maxCommitPoint);
            }
        }
        return wellIDTo;
    }

    void copyFssabnd(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt2 = this.v2sbdb.getDatabase().createStatement();
        Statement v2stmtFss = this.v2sbdb.getDatabase().createStatement();
        Statement v2stmtSmpdtl = this.v2sbdb.getDatabase().createStatement();
        LinkedList abnSchemes = new LinkedList();
        int totalRecords = 0;
        int recordsProcessed = 0;
        int batchRecords = 0;
        int nBatches = 0;
        int wellIDFrom = this.getWellFrom();
        int wellIDTo = this.getWellTo(true);
        String sql = "SELECT count(*) AS total FROM " + this.v18sbdb.DBTableName("FSSABND");
        ResultSet rs1 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        if (rs1.next()) {
            totalRecords = rs1.getInt("total");
        }
        this.outputProgress(false, "\nTotal Records to process: " + totalRecords + "\n");
        sql = "SELECT samp_id,disc_id,analyst,spec_id,status,ident_type,marker,subj_abund,counts,caved,coarse,fine,form,growth,preserv,colour,comments";
        sql = sql + " FROM " + this.v18sbdb.DBTableName("FSSABND") + " ORDER BY samp_id";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        this.v2sbdb.getDefaultAbnScheme();
        this.v2sbdb.getSpecType(0);
        LinkedList v18abnSchemes = new LinkedList();
        int lastWell = -1;
        Well well18 = null;
        model2.Well well = null;
        model2.AnalystHeader header = null;
        System.out.println("Starting fssabnd loop: " + new Date());
        int unknownWellID = -1;
        while (rs.next() && !this.cancelTask) {
            Observable abnScheme;
            String comments;
            String colour;
            String preserv;
            char growth;
            char form;
            int fine;
            int medium;
            char caved;
            int counts;
            String subjAbund;
            char marker;
            char identType;
            char status;
            int specID;
            int sampID;
            int wellID;
            int v18sampID;
            block38: {
                v18sampID = rs.getInt("samp_id");
                char discID = SB.getDBChar(rs, "disc_id");
                wellID = v18sampID / 65536;
                if (wellID < wellIDFrom) continue;
                if (wellID > wellIDTo) break;
                if (batchRecords >= 1000) {
                    batchRecords = 0;
                    this.outputProgress(false, ".." + recordsProcessed);
                    if (++nBatches >= 10) {
                        this.outputProgress(false, "\n");
                        nBatches = 0;
                    }
                }
                ++batchRecords;
                ++recordsProcessed;
                sampID = v18sampID - wellID * 65536;
                String analyst = rs.getString("analyst");
                if (analyst != null) {
                    analyst = analyst.toUpperCase();
                }
                specID = rs.getInt("spec_id");
                status = SB.getDBChar(rs, "status");
                identType = SB.getDBChar(rs, "ident_type");
                marker = SB.getDBChar(rs, "marker");
                subjAbund = rs.getString("subj_abund");
                if (subjAbund != null) {
                    subjAbund = subjAbund.toUpperCase().trim();
                }
                counts = rs.getInt("counts");
                caved = SB.getDBChar(rs, "caved");
                medium = rs.getInt("coarse");
                fine = rs.getInt("fine");
                form = SB.getDBChar(rs, "form");
                growth = SB.getDBChar(rs, "growth");
                preserv = rs.getString("preserv");
                colour = rs.getString("colour");
                comments = rs.getString("comments");
                boolean abnNotDoubleChecked = true;
                if (analyst == null || analyst.length() == 0 || this.v2sbdb.getUser(analyst) == null) {
                    file.write("\nUnrecognised analyst: " + analyst + " from SMPDTL, reverting to " + this.v2sbdb.getUser() + " sampID: " + sampID);
                    analyst = this.v2sbdb.getUser().getAbr();
                }
                if (wellID != lastWell) {
                    Audit.setServerDate(this.v2sbdb, v2stmt);
                    if (wellID == unknownWellID) {
                        ++this.nErrors;
                        file.write("\nSkipping fssabnd record for unknown well" + wellID + "\n");
                        continue;
                    }
                    well = null;
                    well18 = null;
                    try {
                        well = this.v2sbdb.getAddWell(wellID);
                        well18 = this.v18sbdb.getAddWell(wellID);
                    }
                    catch (Exception se) {
                        ++this.nErrors;
                        System.out.print("\n" + se.getMessage() + "\n");
                        file.write("\n" + se.getMessage() + "\n");
                        this.outputProgress(false, "\nUnknown well for fssabnd entry : " + sampID + " wellID: " + wellID);
                        unknownWellID = wellID;
                        continue;
                    }
                    System.out.println("Processing well: " + well + " ID: " + wellID);
                    lastWell = wellID;
                    unknownWellID = -1;
                }
                if ((header = well.getAnalystHeader(analyst, discID, 1, true)) == null) {
                    abnScheme = null;
                    if (subjAbund != null && subjAbund.length() > 0 && subjAbund.charAt(0) != '+') {
                        abnScheme = well18.fillAbnScheme(v18abnSchemes, discID, false);
                    }
                    well.addAnalystHeader(analyst, discID, 1, null, null, null, null, "", 0, abnScheme != null ? ((AbnScheme)abnScheme).getID() : 0, null);
                    abnNotDoubleChecked = true;
                }
                if (subjAbund != null && subjAbund.length() == 0) {
                    subjAbund = null;
                }
                abnScheme = null;
                if (subjAbund != null) {
                    if (medium + counts + fine > 0 || subjAbund.equals("+")) {
                        subjAbund = null;
                    } else {
                        try {
                            int tempCount;
                            counts = tempCount = Integer.parseInt(subjAbund);
                            subjAbund = null;
                        }
                        catch (NumberFormatException ne) {
                            if (header.getAbnSchID() == 0 && abnNotDoubleChecked) {
                                AbnScheme abnScheme18 = null;
                                abnScheme18 = well18.fillAbnScheme(v18abnSchemes, discID, false);
                                if (abnScheme18 != null && abnScheme18.getID() > 0) {
                                    header.setAbnScheme(wellID, abnScheme18.getID());
                                }
                                abnNotDoubleChecked = false;
                            }
                            if ((abnScheme = this.v2sbdb.getAbnScheme(header.getAbnSchID(), false)) == null || ((model2.AbnScheme)abnScheme).getNClasses() == 0) {
                                AbnScheme v18abnScheme = well18.fillAbnScheme(v18abnSchemes, discID, false);
                                if (v18abnScheme != null) {
                                    abnScheme = this.v2sbdb.getAbnScheme(v18abnScheme.getID(), true);
                                }
                                if (abnScheme == null) {
                                    model2.AbnScheme v2s = this.v2sbdb.getDefaultAbnScheme();
                                    if (v2s.getIndex(subjAbund) >= 0) {
                                        abnScheme = v2s;
                                    } else {
                                        for (model2.AbnScheme v2scheme : this.v2sbdb.getAbnSchemes()) {
                                            if (v2scheme.getIndex(subjAbund) < 0) continue;
                                            abnScheme = v2scheme;
                                            break;
                                        }
                                    }
                                    if (abnScheme == null) {
                                        abnScheme = v2s;
                                    }
                                }
                                header.setAbnScheme(wellID, ((model2.AbnScheme)abnScheme).getID());
                            }
                            if (((model2.AbnScheme)abnScheme).getIndex(subjAbund) >= 0) break block38;
                            file.write("\nWarning: for well: " + well.toString() + " Sample: " + sampID + " DiscID: " + discID + " Subj abund: " + subjAbund + " is not in abundance scheme: " + abnScheme + ". Abundance reset");
                            if (counts == 0 && medium == 0 && fine == 0) {
                                if (comments == null) {
                                    comments = "";
                                }
                                comments = comments + "Abundance reset from " + subjAbund;
                                subjAbund = ((model2.AbnScheme)abnScheme).getEntry(0);
                                ++this.nErrors;
                            }
                            subjAbund = null;
                        }
                    }
                }
            }
            String specTypeString = this.v2sbdb.getSpecTypeStringv18(form, growth);
            int specType = this.v2sbdb.getAddSpecType(specTypeString);
            sampID = this.checkSampID(v18stmt2, v2stmt2, wellID, sampID, v18sampID);
            try {
                sql = "SELECT samp_id FROM " + this.v2sbdb.DBTableName("SMPDTL") + " WHERE well_ID=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + header.getAnalyID();
                ResultSet rsSmpdtl = v2stmtSmpdtl.executeQuery(this.v2sbdb.modQuery(sql));
                if (!rsSmpdtl.next()) {
                    sql = "INSERT INTO " + this.v2sbdb.DBTableName("SMPDTL") + " (well_id, samp_id, analy_id) VALUES (" + wellID + "," + sampID + "," + header.getAnalyID() + ")";
                    v2stmtSmpdtl.executeUpdate(this.v2sbdb.modQuery(sql));
                } else {
                    rsSmpdtl.close();
                }
                TaxonOcc fssabnd = new TaxonOcc(v2stmtFss, this.v2sbdb, wellID, sampID, header.getAnalyID(), specID, status == 'R', identType, specType, subjAbund, medium, counts, fine, caved == 'C', marker == 'Y', preserv, colour, comments, (model2.AbnScheme)abnScheme);
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.println(sqle.getMessage() + "\n" + SB.sql);
                file.write("\nWell: " + well + sqle.getMessage() + "\n" + SB.sql);
            }
            catch (Exception e) {
                ++this.nErrors;
                System.out.println(e.getMessage());
                file.write("\nWell: " + well + e.getMessage() + "\n");
            }
        }
        if (!this.cancelTask) {
            if (wellIDTo < 99999) {
                this.jTextFieldWellIDFrom.setText("" + (wellIDTo + 1));
                this.jTextFieldWellIDTo.setText("");
            } else {
                this.jTextFieldWellIDFrom.setText("");
            }
        }
        Audit.setServerDate(this.v2sbdb, null);
        v2stmtFss.close();
        v2stmtSmpdtl.close();
    }

    int checkSampID(Statement v18stmt, Statement v2stmt, int wellID, int sampID, int v18sampID) throws SQLException, util.SBException, SBException {
        if (sampID == 0) {
            String sql = "SELECT depth,bot_depth,type FROM " + this.v18sbdb.DBTableName("samples") + " WHERE samp_id=" + v18sampID;
            ResultSet rs3 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            if (rs3.next()) {
                Double topDepth = rs3.getDouble("depth");
                Double baseDepth = rs3.getDouble("bot_depth");
                String type = rs3.getString("type");
                sql = "SELECT max(samp_id) AS zeroID FROM " + this.v2sbdb.DBTableName("samples") + " WHERE well_id=" + wellID;
                ResultSet rs4 = v2stmt.executeQuery(this.v2sbdb.modQuery(sql));
                if (rs4.next()) {
                    int zeroID = rs4.getInt("zeroID");
                    sql = "SELECT top_depth, base_depth, type FROM " + this.v2sbdb.DBTableName("samples") + " WHERE well_id=" + wellID + " AND samp_id=" + zeroID;
                    ResultSet rs5 = v2stmt.executeQuery(this.v2sbdb.modQuery(sql));
                    if (rs5.next()) {
                        Double topDepth2 = rs5.getDouble("top_depth");
                        Double baseDepth2 = rs5.getDouble("base_depth");
                        String type2 = rs5.getString("type");
                        if (!type2.equals(type)) {
                            System.out.println("Sample types differ for sampID 0 and sampID=" + zeroID);
                            return 0;
                        }
                        if (topDepth != null && topDepth2 != null && Math.abs(Math.abs(topDepth2) - topDepth) > 0.003048) {
                            System.out.println("Sample depths differ for sampID 0 and sampID=" + zeroID + " topDepth=" + topDepth + ",topDepth2=" + topDepth2);
                            return 0;
                        }
                        if (baseDepth != null && baseDepth2 != null && Math.abs(Math.abs(baseDepth2) - baseDepth) > 0.003048) {
                            System.out.println("Sample depths differ for sampID 0 and sampID=" + zeroID + " baseDepth=" + topDepth + ",baseDepth2=" + topDepth2);
                            return 0;
                        }
                        sampID = zeroID;
                    }
                }
            }
        } else {
            model2.Well well = this.v2sbdb.getAddWell(wellID);
            well.getSamples();
            model2.Sample v2sample = well.getSample(sampID);
            if (v2sample == null) {
                Well well18 = this.v18sbdb.getAddWell(wellID);
                well18.loadSamples(null);
                Sample v18sample = well18.getSample(v18sampID);
                if (v18sample != null) {
                    sampID = v18sample.getSampID() - wellID * 65536;
                }
            }
        }
        return sampID;
    }

    void copyAnalyses(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v2SmpdtlStmt = this.v2sbdb.getDatabase().createStatement();
        int lastWellID = -1;
        int wellIDFrom = this.getWellFrom();
        int wellIDTo = this.getWellTo(false);
        if (this.v18sbdb.hasAnalystHeader()) {
            String sql = "SELECT well_id,disc_id,analyst FROM " + this.v18sbdb.DBTableName("ANALY_HDR");
            ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            while (rs.next() && !this.cancelTask) {
                int wellID = rs.getInt("well_id");
                if (wellID < wellIDFrom) continue;
                if (wellID > wellIDTo) break;
                char discID = SB.getDBChar(rs, "disc_id");
                String analyst = rs.getString("analyst");
                if (SBdb.did2dtype(discID) == 0 || analyst == null || analyst.equals("NULL")) continue;
                AnalystHeader header = new AnalystHeader(this.v18sbdb, analyst, discID);
                header.load(wellID, analyst, discID);
                model2.Well well = null;
                try {
                    well = this.v2sbdb.getAddWell(wellID);
                }
                catch (util.SBException sbe) {
                    file.write("\n" + sbe.getMessage());
                    continue;
                }
                if (well != null) {
                    System.out.println("Putting analyst header: " + well + "," + analyst + "," + discID);
                    try {
                        well.addAnalystHeader(analyst, discID, 1, well.getType() == 'O' ? -header.getDepthFrom() : header.getDepthFrom(), well.getType() == 'O' ? -header.getDepthTo() : header.getDepthTo(), header.getDateFrom(), header.getDateTo(), header.getComments(), header.getEnvSchID(), 0, null);
                    }
                    catch (util.SBException sbe) {
                        this.outputProgress(false, "Error putting analyst header: " + sbe.toString());
                        file.write("\nError putting analyst header: " + sbe.toString() + " Well: " + well + "," + analyst + "," + discID);
                    }
                    continue;
                }
                file.write("\nCannot find well for analyst header: " + wellID);
            }
        }
        LinkedList abnSchemes = new LinkedList();
        String sql = "SELECT samp_id,disc_id,analyst,picker,source,modified,modifier,barren,notes";
        sql = sql + ",weight,coarse,medium,fine";
        if (this.v18sbdb.hasSampleEnv()) {
            sql = sql + ",proximal,distal";
        }
        sql = sql + " FROM " + this.v18sbdb.DBTableName("SMPDTL") + " ORDER BY samp_id";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        String strg = null;
        while (rs.next() && !this.cancelTask) {
            int v18sampID = rs.getInt("samp_id");
            char discID = SB.getDBChar(rs, "disc_id");
            int wellID = v18sampID / 65536;
            if (wellID < wellIDFrom) continue;
            if (wellID > wellIDTo) break;
            if (wellID != lastWellID) {
                System.out.println("Processing well: " + wellID);
                lastWellID = wellID;
            }
            int sampID = v18sampID - wellID * 65536;
            String analyst = rs.getString("analyst");
            if (analyst != null) {
                analyst = analyst.toUpperCase();
            }
            String picker = rs.getString("picker");
            String source = rs.getString("source");
            Timestamp modified = rs.getTimestamp("modified");
            String modifier = rs.getString("modifier");
            boolean barren = false;
            strg = rs.getString("barren");
            if (strg != null && strg.length() > 0 && strg.charAt(0) == 'Y') {
                barren = true;
            }
            String notes = rs.getString("notes");
            float weight = 0.0f;
            float coarse = 0.0f;
            float medium = 0.0f;
            float fine = 0.0f;
            weight = rs.getFloat("weight");
            coarse = rs.getFloat("coarse");
            medium = rs.getFloat("medium");
            fine = rs.getFloat("fine");
            int proximal = 0;
            int distal = 0;
            if (this.v18sbdb.hasSampleEnv()) {
                proximal = rs.getInt("proximal");
                distal = rs.getInt("distal");
            }
            if (analyst == null || analyst.length() == 0) {
                ++this.nErrors;
                file.write("\nAnalyst null for sample : " + sampID);
                continue;
            }
            if (this.v2sbdb.getUser(analyst) == null) {
                ++this.nErrors;
                file.write("\nUnrecognised analyst: " + analyst + " from SMPDTL, reverting to " + this.v2sbdb.getUser() + " sampID: " + sampID);
                analyst = this.v2sbdb.getUser().getAbr();
                continue;
            }
            Well well18 = null;
            try {
                well18 = this.v18sbdb.getAddWell(wellID);
            }
            catch (Exception se) {
                ++this.nErrors;
                System.out.print("\n" + se.getMessage() + "\n");
                file.write("\n" + se.getMessage() + "\n");
                this.outputProgress(false, "\nWarning: analyses exist for missing wellID: " + wellID);
            }
            if (well18 == null) continue;
            model2.Well well = this.v2sbdb.getAddWell(wellID);
            if (well == null) {
                file.write("\nUnknown well for smpdtl : " + sampID + " wellID: " + wellID);
                continue;
            }
            model2.AnalystHeader header = well.getAnalystHeader(analyst, discID, 1, true);
            if (header == null) {
                System.out.println("Adding analyst header for well: " + well);
                well.addAnalystHeader(analyst, discID, 1, null, null, null, null, "", 0, 0, null);
            }
            try {
                sampID = this.checkSampID(v18stmt2, v2stmt, wellID, sampID, v18sampID);
                Smpdtl smpdtl = new Smpdtl(v2SmpdtlStmt, this.v2sbdb, wellID, sampID, header.getAnalyID(), picker, source, this.v2sbdb.getUser(modifier), (Date)modified, barren, notes, weight, coarse, medium, fine, proximal, distal, 0);
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                file.write("\nWell: " + well + sqle.getMessage() + "\n" + SB.sql);
            }
        }
        v2SmpdtlStmt.close();
    }

    void copySamples(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT w.well_name,w.well_code,v.well_id,s.samp_id,s.depth,s.bot_depth,s.type from  " + this.v18sbdb.DBTableName("samples") + " s," + this.v18sbdb.DBTableName("version") + " v," + this.v18sbdb.DBTableName("wells") + " w " + "where v.well_id=floor(s.samp_id/65536) and v.code=w.well_code and s.bot_depth is not null and s.depth is not null and s.bot_depth < s.depth and s.type <> 'OC'";
        ResultSet rs1 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        boolean hasSampleErrors = false;
        while (rs1.next()) {
            if (!hasSampleErrors) {
                String strg = "\nThere are samples where the base depth is less than top depth. This must be corrected before proceeding. Wells/samples are:";
                this.outputProgress(false, strg);
                file.write(strg);
                hasSampleErrors = true;
            }
            String wellName = rs1.getString("well_name");
            String wellCode = rs1.getString("well_code");
            int wellID = rs1.getInt("well_id");
            int sampID = rs1.getInt("samp_id");
            double topDepth = rs1.getDouble("depth");
            double baseDepth = rs1.getDouble("bot_depth");
            String type = rs1.getString("type");
            String strg = "\n" + wellName + "," + wellCode + "," + wellID + "," + sampID + "," + topDepth + "," + baseDepth + "," + type;
            this.outputProgress(false, strg);
            file.write(strg);
        }
        if (hasSampleErrors) {
            v18stmt.close();
            this.cancelTask = true;
            throw new util.SBException("Process stopped due to sample errors.");
        }
        Statement v2stmtSample = this.v2sbdb.getDatabase().createStatement();
        String sClause = "floor(samp_id/65536)";
        sql = "SELECT distinct " + sClause + " AS well_id FROM " + this.v18sbdb.DBTableName("samples") + " ORDER BY " + sClause;
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        int wellCount = 0;
        int wellIDFrom = this.getWellFrom();
        int wellIDTo = this.getWellTo(false);
        while (rs.next() && !this.cancelTask) {
            int wellID = rs.getInt("well_id");
            System.out.println("WellID: " + wellID);
            if (wellID < wellIDFrom) continue;
            if (wellID > wellIDTo) break;
            Well well = null;
            try {
                well = this.v18sbdb.getAddWell(wellID);
            }
            catch (Exception se) {
                ++this.nErrors;
                System.out.print("\n" + se.getMessage() + "\n");
                file.write("\n" + se.getMessage() + "\n");
                this.outputProgress(false, "\nWarning: samples exist for missing wellID: " + wellID);
            }
            if (well != null) {
                well.loadSamples(null);
                System.out.print("" + ++wellCount + " Processing well: " + well + " ");
                if (well.getSamples() != null) {
                    System.out.println("no. samples=" + well.getSamples().size());
                } else {
                    System.out.println("Well samples NULL");
                }
                model2.Well well2 = this.v2sbdb.getAddWell(wellID);
                if (well2 != null) {
                    well2.getSamples();
                    Iterator it = well.getSamples().iterator();
                    Sample zeroSample = null;
                    int maxID = 0;
                    while (it.hasNext()) {
                        Sample sample = (Sample)it.next();
                        int sampID = sample.getSampID() - wellID * 65536;
                        if (sampID > maxID) {
                            maxID = sampID;
                        }
                        if (sampID == 0) {
                            System.out.println("Zero sampID will be renumbered for well: " + well + " original sampID: " + sample.getSampID());
                            zeroSample = sample;
                            continue;
                        }
                        String sampleType = sample.getType();
                        if (sampleType == null || sampleType.length() == 0) {
                            sampleType = "CU";
                        }
                        try {
                            Double topDepth = well.getType() == 'O' ? -sample.getTopDepth() : sample.getTopDepth();
                            Double baseDepth = well.getType() == 'O' ? -sample.getBaseDepth() : sample.getBaseDepth();
                            if (topDepth != null && baseDepth != null && Math.abs(topDepth - baseDepth) < (double)0.0029f) {
                                if (this.jRadioButtonSampleBases.isSelected()) {
                                    topDepth = null;
                                } else if (this.jRadioButtonSampleTops.isSelected()) {
                                    baseDepth = null;
                                }
                            }
                            model2.Sample sample2 = new model2.Sample(v2stmtSample, this.v2sbdb, well.getType(), wellID, sampID, topDepth, baseDepth, sampleType, sample.getLabel(), sample.getGridX(), sample.getGridY(), sample.getCreated(), this.v2sbdb.getUser(sample.getCreator()), sample.getModified(), this.v2sbdb.getUser(sample.getModifier()));
                            model2.Sample.insert(well2.getSamples(), sample2, well2.getWellUnits());
                        }
                        catch (SampleInsertException se) {
                            ++this.nErrors;
                            System.out.print("\n" + se.getMessage() + "/" + sample.getSampID() + "," + well.getWellName() + "/" + well.getWellCode() + "\n");
                            file.write("\n" + se.getMessage() + "/" + sample.getSampID() + "," + well.getWellName() + "/" + well.getWellCode() + "\n");
                        }
                        catch (SQLException sqle) {
                            ++this.nErrors;
                            System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                            file.write("\n" + sqle.getMessage() + "\n" + SB.sql);
                        }
                    }
                    if (zeroSample == null) continue;
                    model2.Sample sample2 = new model2.Sample(v2stmtSample, this.v2sbdb, well.getType(), wellID, maxID + 1, zeroSample.getTopDepth(), zeroSample.getBaseDepth(), zeroSample.getType(), zeroSample.getLabel(), zeroSample.getGridX(), zeroSample.getGridY(), zeroSample.getCreated(), this.v2sbdb.getUser(zeroSample.getCreator()), zeroSample.getModified(), this.v2sbdb.getUser(zeroSample.getModifier()));
                    model2.Sample.insert(well2.getSamples(), sample2, well2.getWellUnits());
                    continue;
                }
                ++this.nErrors;
                file.write("\nWarning: no v2 well found for samples with well_id: " + wellID);
                continue;
            }
            ++this.nErrors;
            file.write("\nWarning: no v1.8 well found for samples with well_id: " + wellID);
        }
        v2stmtSample.close();
    }

    void copyQSProj(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT qs_id, name, creator, created FROM " + this.v18sbdb.DBTableName("QSPROJ");
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        ProjectList projects = this.v2sbdb.getProjects();
        Project p = this.v2sbdb.getProject(0);
        System.out.println("Project 0 is: " + p);
        while (rs.next()) {
            int qsID = rs.getInt("qs_id");
            String name = rs.getString("name");
            if (name != null) {
                name = name.trim();
            }
            String creator = rs.getString("creator");
            java.sql.Date created = rs.getDate("created");
            Project project = projects.getProject(name);
            if (project == null) {
                model2.Userdef cUser = this.v2sbdb.getUser(creator);
                if (cUser == null) {
                    cUser = this.v2sbdb.getUser();
                }
                project = projects.add(name, cUser, created);
            }
            if (qsID > 0 && this.v2sbdb.getInterp(name) == null) {
                new InterpHdr(this.v2sbdb, name);
            }
            project.loadWells(this.v2sbdb, v2stmt);
            sql = "SELECT well_id FROM " + this.v18sbdb.DBTableName("QSSECT") + " WHERE qs_id=" + qsID;
            ResultSet rs2 = v18stmt2.executeQuery(this.v18sbdb.modQuery(sql));
            while (rs2.next()) {
                int wellID = rs2.getInt("well_id");
                if (project.contains(wellID)) continue;
                try {
                    model2.Well well = this.v2sbdb.getAddWell(wellID);
                    project.addWell(this.v2sbdb, well);
                }
                catch (Exception e) {
                    ++this.nErrors;
                    file.write("\nCannot add well to well list from QSProject: " + wellID);
                }
            }
        }
    }

    void copyEvents(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        HashMap<Integer, String> qsProjects = new HashMap<Integer, String>();
        String sql = "SELECT qs_id,ev_id,ev_type,samp_id";
        if (this.v18sbdb.hasEventExtensions()) {
            sql = sql + ",disc_id,analyst,qualifier,comments,source,company,modified";
        }
        sql = sql + " FROM " + this.v18sbdb.DBTableName("EVENTS") + " ORDER BY qs_id,samp_id";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next() && !this.cancelTask) {
            InterpHdr hdr;
            int qsID = rs.getInt("qs_id");
            String name = (String)qsProjects.get(qsID);
            if (name != null) {
                name = name.trim();
                Project project = this.v2sbdb.getProjects().getProject(name);
                if (project == null) {
                    System.out.println("Cannot find event project: " + name + ", qs_id=" + qsID);
                    ++this.nErrors;
                    file.write("\nCannot find event project: " + name + ", qs_id=" + qsID);
                    continue;
                }
            } else if (qsID > 0) {
                sql = "SELECT name FROM " + this.v18sbdb.DBTableName("QSPROJ") + " WHERE qs_id=" + qsID;
                ResultSet rs2 = v18stmt2.executeQuery(sql);
                if (rs2.next()) {
                    name = rs2.getString("name");
                    if (name == null) {
                        ++this.nErrors;
                        file.write("\nCannot find QS event project: " + name + ", qs_id=" + qsID);
                        continue;
                    }
                    name = name.trim();
                    qsProjects.put(qsID, name);
                }
                rs2.close();
            }
            int interpID = 0;
            if (qsID > 0 && (hdr = this.v2sbdb.getInterp(name)) != null) {
                interpID = hdr.getInterpID();
            }
            int evID = rs.getInt("ev_id");
            char evType = SB.getDBChar(rs, "ev_type");
            int v18sampID = rs.getInt("samp_id");
            char discID = '\u0000';
            String analyst = null;
            String qualifier = null;
            String comments = null;
            String source = null;
            String company = null;
            Date modified = new Date();
            int analystID = 0;
            if (this.v18sbdb.hasEventExtensions()) {
                discID = SB.getDBChar(rs, "disc_id");
                analyst = rs.getString("analyst");
                if (analyst != null && this.v2sbdb.getUser(analyst) != null) {
                    analystID = this.v2sbdb.getUser(analyst).getUsrID();
                }
                qualifier = rs.getString("qualifier");
                comments = rs.getString("comments");
                source = rs.getString("source");
                company = rs.getString("company");
                modified = rs.getDate("modified");
            }
            int wellID = v18sampID / 65536;
            int sampID = v18sampID - wellID * 65536;
            try {
                sampID = this.checkSampID(v18stmt2, v2stmt, wellID, sampID, v18sampID);
                new WellEvent(this.v2sbdb, interpID, evID, evType, wellID, sampID, discID, analystID, qualifier, comments, source, company, modified);
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                file.write("\n" + sqle.getMessage() + "\n" + SB.sql);
            }
            catch (util.SBException sbe) {
                ++this.nErrors;
                file.write("\n" + sbe.getMessage());
            }
            catch (RuntimeException ex) {
                ++this.nErrors;
                file.write("\n" + ex.getMessage());
            }
        }
    }

    void copyQSLOC(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT well_id,std_id,qs_id,depth1,depth2,csu1,csu2,r,g,b,linewidth";
        sql = sql + " FROM " + this.v18sbdb.DBTableName("QSLOC") + " ORDER BY well_id,std_id,qs_id,depth1,depth2";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        LOC loc = null;
        int lastLOCWellID = 0;
        int lastLOCInterpID = 0;
        while (rs.next() && !this.cancelTask) {
            int wellID = rs.getInt("well_id");
            int stdID = rs.getInt("std_id");
            int qsID = rs.getInt("qs_id");
            double depth1 = rs.getDouble("depth1");
            double depth2 = rs.getDouble("depth2");
            double csu1 = rs.getDouble("csu1");
            double csu2 = rs.getDouble("csu2");
            Color colour = new Color(rs.getInt("r"), rs.getInt("g"), rs.getInt("b"));
            float lineWidth = rs.getFloat("linewidth");
            try {
                InterpHdr hdr;
                EvProject project;
                Well well = this.v18sbdb.getAddWell(wellID);
                if (well.getType() == 'O') {
                    depth1 = -depth1;
                    depth2 = -depth2;
                }
                if ((project = this.v18sbdb.getEvProject(qsID)) == null) {
                    file.write("\nCannot find event project");
                    continue;
                }
                int interpID = 0;
                if (qsID > 0 && (hdr = this.v2sbdb.getInterp(project.toString())) != null) {
                    interpID = hdr.getInterpID();
                }
                if (loc != null && (wellID != lastLOCWellID || lastLOCInterpID != interpID)) {
                    try {
                        loc.store(lastLOCWellID, lastLOCInterpID);
                    }
                    catch (Exception sqle) {
                        ++this.nErrors;
                        System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                        file.write("\n" + sqle.getMessage() + "\n" + SB.sql);
                    }
                    loc = null;
                }
                if (loc == null) {
                    if (stdID > 0 && this.v2sbdb.getCompositeStandard(stdID) == null) {
                        stdID = 0;
                    }
                    loc = new LOC(this.v2sbdb, stdID, interpID, wellID, colour, lineWidth);
                    loc.addNode(depth2, csu2, 3);
                    lastLOCWellID = wellID;
                    lastLOCInterpID = interpID;
                }
                loc.addNode(depth1, csu1, 3);
            }
            catch (Exception ex) {
                System.out.println("Exception in LOC copy: " + ex.getMessage());
            }
        }
        if (loc != null) {
            try {
                loc.store(lastLOCWellID, lastLOCInterpID);
            }
            catch (Exception sqle) {
                ++this.nErrors;
                System.out.print("\n" + sqle.getMessage() + "\n" + SB.sql);
                file.write("\n" + sqle.getMessage() + "\n" + SB.sql);
            }
        }
    }

    void copyWells(BufferedWriter file) throws SQLException, util.SBException, IOException, SBException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT well_id FROM " + this.v18sbdb.DBTableName("version") + " ORDER BY well_id";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        file.write("\nWell Headers : ");
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            Well well = this.v18sbdb.getAddWell(wellID);
            model1_8.WellHeader h = well.getHeader();
            double lat_dec = h.getLat_dec();
            if (h.getLat_ind() == 'S') {
                lat_dec = -lat_dec;
            }
            double long_dec = h.getLong_dec();
            if (h.getLong_ind() == 'W') {
                long_dec = -long_dec;
            }
            if (h.getCountry() == null || h.getCountry().length() == 0) {
                file.write("\nWarning: country blank for well: " + well.getWellName() + "/" + well.getWellCode() + ", setting to UNKNOWN");
            }
            WellHeader header = new WellHeader(this.v2sbdb, h.getWellName(), h.getWellCode(), h.getType(), h.getWellUnits(), h.getOper(), h.getCountry() == null || h.getCountry().length() == 0 ? "UNKNOWN" : h.getCountry().toUpperCase(), h.getField(), h.getGridX(), h.getGridY(), h.getSpud(), h.getComp(), h.getTD(), h.getSL(), h.getSB(), h.getRTE(), h.getKicko(), h.getOCS(), h.getCounty(), h.getUsrid(), h.getUserDate(), h.getDatum(), lat_dec > 0.0 ? new Double(lat_dec) : null, long_dec > 0.0 ? new Double(long_dec) : null, h.getGeoDatum(), h.getDescrip());
            model2.Well well2 = new model2.Well(this.v2sbdb, wellID, header);
            file.write("\nWellID: " + wellID + " : " + well);
        }
        v2stmt.close();
        v18stmt.close();
    }

    void setv18ChartSynSch(BufferedWriter file) throws SQLException, util.SBException, IOException {
        try {
            Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
            String sql = "SELECT max(sch_id) AS max_sch_id FROM " + this.v18sbdb.DBTableName("synsch");
            int schID = 0;
            try {
                ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
                if (rs.next()) {
                    schID = rs.getInt("max_sch_id");
                }
            }
            catch (SQLException sqle) {
                String msg = "Error: " + sqle + " SQL: " + SB.sql;
                System.out.println(msg);
                file.write("\n" + msg);
            }
            sql = "UPDATE " + this.v18sbdb.DBTableName("sbcharts") + " SET syn_sch = NULL WHERE syn_sch > " + schID;
            int rows = v18stmt.executeUpdate(this.v18sbdb.modQuery(sql));
            System.out.print("\nSynSch entries in SBCharts updated in v1.8 database: " + rows);
            file.write("\nSynSch entries in SBCharts updated in v1.8 database: " + rows);
            sql = "UPDATE " + this.v18sbdb.DBTableName("sbcharts") + " SET asyn_sch = NULL WHERE asyn_sch > " + schID;
            rows = v18stmt.executeUpdate(this.v18sbdb.modQuery(sql));
            System.out.print("\nASynSch entries in SBCharts updated in v1.8 database: " + rows);
            file.write("\nASynSch entries in SBCharts updated in v1.8 database: " + rows);
            v18stmt.close();
            this.v18sbdb.commit();
        }
        catch (SQLException sqle) {
            String msg = "Error: " + sqle + " SQL: " + SB.sql;
            System.out.println(msg);
            file.write("\n" + msg);
            this.v18sbdb.doRollback();
        }
    }

    void copyInterp(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT interp_id, descrip, creator, created FROM " + this.v18sbdb.DBTableName("interp");
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        sql = "INSERT INTO " + this.v2sbdb.DBTableName("interp") + " (interp_id, descrip) VALUES (0,'Default Version')";
        try {
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
        }
        catch (SQLException sqle) {
            String msg = "Error inserting: " + sqle + " SQL: " + sql;
            System.out.println(msg);
            file.write("\n" + msg);
        }
        while (rs.next()) {
            int interpID = rs.getInt("interp_id");
            String descrip = rs.getString("descrip");
            String creator = rs.getString("creator");
            Date created = rs.getDate("created");
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("interp") + " (interp_id, descrip, created, creator, modified, modifier) VALUES (";
            sql = sql + interpID + ",";
            sql = sql + SB.DBString(descrip) + ",";
            if (created == null) {
                created = new Date();
            }
            sql = sql + SB.DBString(SB.DBdf.format(created)) + ",";
            model2.Userdef cUser = this.v2sbdb.getUser(creator);
            if (cUser == null) {
                cUser = this.v2sbdb.getUser();
            }
            sql = sql + cUser.getUsrID() + ",";
            sql = sql + SB.DBString(SB.DBdf.format(created)) + ",";
            sql = sql + cUser.getUsrID() + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                String msg = "Error inserting: " + sqle + " SQL: " + sql;
                System.out.println(msg);
                file.write("\n" + msg);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copyEvDict(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT ev_id, spec_id, ev_type, generate, name,  creator, created";
        if (this.v18sbdb.hasEventExtensions()) {
            sql = sql + ",ev_extent, ev_desc";
        }
        sql = sql + " FROM " + this.v18sbdb.DBTableName("eventdic");
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            int ev_id = rs.getInt("ev_id");
            int specID = rs.getInt("spec_id");
            String evType = rs.getString("ev_type");
            String generate = rs.getString("generate");
            String name = rs.getString("name");
            String creator = rs.getString("creator");
            Date created = rs.getDate("created");
            String extent = null;
            String desc = null;
            if (this.v18sbdb.hasEventExtensions()) {
                extent = rs.getString("ev_extent");
                desc = rs.getString("ev_desc");
            }
            if (specID > 0) {
                Taxon taxon = this.v2sbdb.getTaxon(specID);
                if (taxon == null) {
                    file.write("\nError getting taxon for ID: " + specID);
                } else if (taxon.toString(false).equals(name)) {
                    name = "";
                }
            }
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("eventdic") + " (ev_id, ";
            sql = sql + "spec_id,";
            sql = sql + "ev_type, ev_extent, ev_desc, generate, name, created, creator, modified, modifier) VALUES (";
            sql = sql + ev_id + ",";
            sql = specID > 0 ? sql + specID + "," : sql + "NULL,";
            sql = sql + SB.DBString(evType) + ",";
            sql = sql + SB.DBString(extent) + ",";
            sql = sql + SB.DBString(desc) + ",";
            sql = sql + SB.DBString(generate) + ",";
            sql = sql + SB.DBString(name) + ",";
            if (created == null) {
                created = new Date();
            }
            sql = sql + SB.DBString(SB.DBdf.format(created)) + ",";
            model2.Userdef cUser = this.v2sbdb.getUser(creator);
            if (cUser == null) {
                cUser = this.v2sbdb.getUser();
            }
            sql = sql + cUser.getUsrID() + ",";
            sql = sql + SB.DBString(SB.DBdf.format(created)) + ",";
            sql = sql + cUser.getUsrID() + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                String msg = "Error inserting: " + sqle + " SQL: " + sql;
                System.out.println(msg);
                file.write("\n" + msg);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copyTaxa1(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT gen_id,cat_mnem,genus,sub_genus,q1,q2,q3,q4";
        sql = sql + " FROM " + this.v18sbdb.DBTableName("genus") + " ORDER BY gen_id";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            int genID = rs.getInt("gen_id");
            String cat_mnem = SB.getDBString(rs, "cat_mnem");
            String genus = SB.getDBString(rs, "genus");
            String subGenus = SB.getDBString(rs, "sub_genus");
            String q1 = SB.getDBString(rs, "q1").toLowerCase();
            String q2 = SB.getDBString(rs, "q2").toLowerCase();
            String q3 = SB.getDBString(rs, "q3").toLowerCase();
            String q4 = SB.getDBString(rs, "q4").toLowerCase();
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("genus") + " (gen_id,cat_mnem,genus";
            if (subGenus != null && subGenus.length() > 0) {
                sql = sql + ",sub_genus";
            }
            if (q1 != null && q1.length() > 0) {
                sql = sql + ",q1";
            }
            if (q2 != null && q2.length() > 0) {
                sql = sql + ",q2";
            }
            if (q3 != null && q3.length() > 0) {
                sql = sql + ",q3";
            }
            if (q4 != null && q4.length() > 0) {
                sql = sql + ",q4";
            }
            sql = sql + ") VALUES (" + genID + "," + SB.DBString(cat_mnem) + "," + SB.DBString(genus);
            if (subGenus != null && subGenus.length() > 0) {
                sql = sql + "," + SB.DBString(subGenus);
            }
            if (q1 != null && q1.length() > 0) {
                sql = sql + "," + SB.DBString(q1);
            }
            if (q2 != null && q2.length() > 0) {
                sql = sql + "," + SB.DBString(q2);
            }
            if (q3 != null && q3.length() > 0) {
                sql = sql + "," + SB.DBString(q3);
            }
            if (q4 != null && q4.length() > 0) {
                sql = sql + "," + SB.DBString(q4);
            }
            sql = sql + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.println("Error inserting genus: " + sqle + " SQL: " + sql);
                file.write("\nError inserting genus: " + sqle + " SQL: " + sql);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copyTaxa4(BufferedWriter file) throws SQLException, util.SBException, IOException {
        int ccode;
        ResultSet rs;
        String sql;
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        boolean hasDefaultCcode = false;
        if (this.v18sbdb.hasSipmDict()) {
            sql = "SELECT ccode,txt FROM " + this.v18sbdb.DBTableName("SIPMDICT");
            rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            while (rs.next()) {
                ccode = rs.getInt("ccode");
                String txt = rs.getString("txt");
                sql = "INSERT INTO " + this.v2sbdb.DBTableName("SIPMDICT") + " (ccode, txt) VALUES (";
                sql = sql + ccode + "," + SB.DBString(txt) + ")";
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
                if (ccode != 1) continue;
                hasDefaultCcode = true;
            }
        }
        if (!hasDefaultCcode) {
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("SIPMDICT") + " (ccode, txt) VALUES (1,'Default')";
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
        }
        sql = "SELECT ";
        if (this.v18sbdb.hasSipmDict()) {
            sql = sql + "ccode,";
        }
        sql = sql + "spec_id,sipm_code FROM " + this.v18sbdb.DBTableName("SIPMCODE");
        rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            int tempCcode;
            ccode = 1;
            if (this.v18sbdb.hasSipmDict() && (tempCcode = rs.getInt("ccode")) > 0) {
                ccode = tempCcode;
            }
            int specID = rs.getInt("spec_id");
            int sipmCode = rs.getInt("sipm_code");
            try {
                sql = "INSERT INTO " + this.v2sbdb.DBTableName("SIPMCODE") + " (ccode,spec_id,sipm_code) VALUES (";
                sql = sql + ccode + "," + specID + "," + sipmCode + ")";
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.println("Error inserting: " + sqle + " SQL: " + sql);
                file.write("\nError inserting: " + sqle + " SQL: " + sql);
            }
        }
    }

    void copyTaxa3(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = null;
        try {
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("SYNSCH") + " (sch_id, name) VALUES (1,'Default Scheme')";
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
        }
        catch (SQLException sqle) {
            System.out.println("Error inserting: " + sqle + " SQL: " + sql);
            file.write("\nError inserting: " + sqle + " SQL: " + sql);
        }
        sql = "SELECT ";
        if (this.v18sbdb.hasSynonymSchemes()) {
            sql = sql + "sch_id,";
        }
        sql = sql + "spec_id,pref FROM " + this.v18sbdb.DBTableName("SYNONYMY");
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            int tempSchID;
            int schID = 1;
            if (this.v18sbdb.hasSynonymSchemes() && (tempSchID = rs.getInt("sch_id")) > 0) {
                schID = tempSchID;
            }
            int specID = rs.getInt("spec_id");
            int pref = rs.getInt("pref");
            try {
                sql = "INSERT INTO " + this.v2sbdb.DBTableName("SYNONYMY") + " (sch_id, spec_id, pref) VALUES (";
                sql = sql + schID + "," + specID + "," + pref + ")";
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.println("Error inserting: " + sqle + " SQL: " + sql);
                file.write("\nError inserting: " + sqle + " SQL: " + sql);
            }
        }
        try {
            boolean oldStyle = true;
            sql = "SELECT spec_id,references FROM " + this.v18sbdb.DBTableName("TXREFS");
            try {
                rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                sql = "SELECT spec_id,reference FROM " + this.v18sbdb.DBTableName("TXREFS");
                rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
                oldStyle = false;
            }
            while (rs.next()) {
                int specID = rs.getInt("spec_id");
                String refs = rs.getString(oldStyle ? "references" : "reference");
                try {
                    sql = "INSERT INTO " + this.v2sbdb.DBTableName("TXREFS") + " (spec_id, reference) VALUES (";
                    sql = sql + specID + "," + SB.DBString(refs) + ")";
                    v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
                }
                catch (SQLException sqle) {
                    ++this.nErrors;
                    System.out.println("Error inserting: " + sqle + " SQL: " + sql);
                    file.write("\nError inserting: " + sqle + " SQL: " + sql);
                }
            }
        }
        catch (SQLException sqle) {
            ++this.nErrors;
            System.out.println("Error executing: " + sqle + " SQL: " + sql);
            file.write("\nError executing: " + sqle + " SQL: " + sql);
        }
    }

    void copyTaxa2(BufferedWriter file) throws SQLException, util.SBException, IOException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT gen_id,spec_id,q1,species,q2,q3,sub_spec,q4,author,year";
        if (this.v18sbdb.hasAlphaCode()) {
            sql = sql + ",alphaCode";
        }
        sql = sql + " FROM " + this.v18sbdb.DBTableName("species") + " ORDER BY spec_id";
        ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs.next()) {
            int genID = rs.getInt("gen_id");
            int specID = rs.getInt("spec_id");
            String q1 = SB.getDBString(rs, "q1").toLowerCase();
            String species = SB.getDBString(rs, "species");
            String q2 = SB.getDBString(rs, "q2").toLowerCase();
            String q3 = SB.getDBString(rs, "q3").toLowerCase();
            String subSpecies = SB.getDBString(rs, "sub_spec");
            String q4 = SB.getDBString(rs, "q4").toLowerCase();
            String author = SB.getDBString(rs, "author");
            int year = rs.getInt("year");
            String alphaCode = null;
            if (this.v18sbdb.hasAlphaCode()) {
                alphaCode = SB.getDBString(rs, "alphacode");
            }
            if (species == null || species.length() == 0) {
                species = "_";
                String msg = "Adding '_' as species name for species ID: " + specID + ", genus: " + genID;
                file.write("\n" + msg);
                System.out.println(msg);
            }
            if (species.startsWith("\"") && species.endsWith("\"") && (q1 == null || q1.length() == 0) && (q2 == null || q2.length() == 0)) {
                q1 = "\"";
                q2 = "\"";
                species = species.substring(1, species.length() - 1);
            }
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("species") + " ( gen_id,spec_id";
            if (q1 != null && q1.length() > 0) {
                sql = sql + ",q1";
            }
            sql = sql + ",species";
            if (q2 != null && q2.length() > 0) {
                sql = sql + ",q2";
            }
            if (q3 != null && q3.length() > 0) {
                sql = sql + ",q3";
            }
            if (subSpecies != null && subSpecies.length() > 0) {
                sql = sql + ",sub_spec";
            }
            if (q4 != null && q4.length() > 0) {
                sql = sql + ",q4";
            }
            if (author != null && author.length() > 0) {
                sql = sql + ",author";
            }
            if (year > 0) {
                sql = sql + ",year";
            }
            if (alphaCode != null && alphaCode.length() > 0) {
                sql = sql + ",alphacode";
            }
            sql = sql + " ) VALUES ( ";
            sql = sql + genID + "," + specID;
            if (q1 != null && q1.length() > 0) {
                sql = sql + "," + SB.DBString(q1);
            }
            sql = sql + "," + SB.DBString(species);
            if (q2 != null && q2.length() > 0) {
                sql = sql + "," + SB.DBString(q2);
            }
            if (q3 != null && q3.length() > 0) {
                sql = sql + "," + SB.DBString(q3);
            }
            if (subSpecies != null && subSpecies.length() > 0) {
                sql = sql + "," + SB.DBString(subSpecies);
            }
            if (q4 != null && q4.length() > 0) {
                sql = sql + "," + SB.DBString(q4);
            }
            if (author != null && author.length() > 0) {
                sql = sql + "," + SB.DBString(author);
            }
            if (year > 0) {
                if (year < 1000) {
                    year = year < 15 ? (year += 2000) : (year < 100 ? (year += 1900) : (year += 1000));
                }
                sql = sql + "," + year;
            }
            if (alphaCode != null && alphaCode.length() > 0) {
                sql = sql + "," + SB.DBString(alphaCode);
            }
            sql = sql + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\nError inserting Species: " + sqle.getMessage() + "\n" + sql);
                file.write("\nError inserting Species: " + sqle.getMessage() + "\n" + sql);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copyTxgroup() throws SQLException, util.SBException {
        for (TxGroup group : this.v18sbdb.getTxGroups()) {
            model2.TxGroup txGroup = new model2.TxGroup(this.v2sbdb, group.getID(), group.getName(), group.getAbr(), group.getColour());
        }
    }

    void copyGroupSet() throws SQLException, util.SBException {
        for (model1_8.TxGroupSet set : this.v18sbdb.getTxGroupSets()) {
            TxGroupSet txGroupSet = new TxGroupSet(this.v2sbdb, set.getID(), set.getName(), true);
        }
    }

    /*
     * Exception decompiling
     */
    void copySchemes2(BufferedWriter file) throws SQLException, util.SBException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void copyTable(BufferedWriter file, String tableName, String whereClause, boolean clearValues, boolean useNullZeros) throws SQLException, IOException {
        String columnName;
        int i;
        ResultSet rs;
        String v2tableName = this.v2sbdb.DBTableName(tableName);
        Statement newStmt = this.v2sbdb.getDatabase().createStatement();
        if (clearValues) {
            newStmt.executeUpdate("DELETE FROM " + v2tableName);
        }
        SB.sql = "";
        String selectQuery = "SELECT * FROM " + v2tableName;
        ResultSet rsNew = newStmt.executeQuery(selectQuery);
        ResultSetMetaData meta = rsNew.getMetaData();
        int nCols = meta.getColumnCount();
        selectQuery = "SELECT ";
        for (int i2 = 1; i2 <= nCols; ++i2) {
            String columnName2 = meta.getColumnName(i2);
            selectQuery = selectQuery + columnName2;
            if (i2 >= nCols) continue;
            selectQuery = selectQuery + ",";
        }
        selectQuery = selectQuery + " FROM " + this.v18sbdb.DBTableName(tableName);
        Statement stmt = this.v18sbdb.getDatabase().createStatement();
        if (whereClause != null) {
            selectQuery = selectQuery + whereClause;
        }
        try {
            rs = stmt.executeQuery(selectQuery);
        }
        catch (SQLException se) {
            System.out.println("Problem with select query from v1.8 database: " + selectQuery);
            selectQuery = "SELECT * FROM " + this.v18sbdb.DBTableName(tableName);
            if (whereClause != null) {
                selectQuery = selectQuery + whereClause;
            }
            rs = stmt.executeQuery(selectQuery);
            meta = rs.getMetaData();
            nCols = meta.getColumnCount();
        }
        String sql = "INSERT INTO " + v2tableName + "(";
        for (i = 1; i <= nCols; ++i) {
            columnName = meta.getColumnName(i);
            if (tableName.equalsIgnoreCase("LOGDEF") && columnName.equalsIgnoreCase("LUNITS")) continue;
            if (meta.getColumnType(i) == 1111) {
                System.out.println("Skipping column: " + columnName);
                continue;
            }
            sql = sql + columnName;
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + " ) VALUES (";
        for (i = 1; i <= nCols; ++i) {
            columnName = meta.getColumnName(i);
            if (tableName.equalsIgnoreCase("LOGDEF") && columnName.equalsIgnoreCase("LUNITS") || meta.getColumnType(i) == 1111) continue;
            sql = sql + "?";
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + ")";
        PreparedStatement pStmt = this.v2sbdb.getDatabase().prepareStatement(sql);
        while (rs.next()) {
            String paramString = "";
            if (this.v2sbdb.getDBType() != SBdb.DBType.ORACLE) {
                pStmt.clearParameters();
            }
            int colToSet = 0;
            for (int col = 1; col <= nCols; ++col) {
                int type = meta.getColumnType(col);
                String columnName3 = meta.getColumnName(col);
                if (tableName.equalsIgnoreCase("LOGDEF") && columnName3.equalsIgnoreCase("LUNITS") || meta.getColumnType(col) == 1111) continue;
                ++colToSet;
                Object obj = this.v18sbdb.getDBType() == SBdb.DBType.ORACLE && (meta.getColumnType(col) == 12 || meta.getColumnType(col) == -1) ? rs.getString(col) : rs.getObject(col);
                if (obj != null) {
                    if (useNullZeros && (type == 3 || type == 8 || type == 2) && (obj.toString().equals("0.0") || obj.toString().equals("0") || obj.toString().equals("0,0"))) {
                        type = 8;
                        pStmt.setNull(colToSet, type);
                    } else {
                        pStmt.setObject(colToSet, obj);
                    }
                } else if (meta.getColumnName(col).equalsIgnoreCase("INTERP_ID")) {
                    pStmt.setInt(colToSet, 0);
                } else {
                    if (type == 3) {
                        type = 8;
                    }
                    pStmt.setNull(colToSet, type);
                }
                paramString = paramString + obj + ",";
            }
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException se) {
                if (se.getMessage().equalsIgnoreCase("GENERAL ERROR")) {
                    ++this.nErrors;
                    String msg = "Duplicate record error when inserting into " + v2tableName + ": " + paramString;
                    System.out.println(msg);
                    file.write("\n" + msg);
                    continue;
                }
                if (se.getMessage().indexOf("You cannot add or change a record") >= 0) {
                    ++this.nErrors;
                    String msg = "Related record error when inserting into " + v2tableName + ": " + paramString;
                    System.out.println(msg);
                    file.write("\n" + msg);
                    continue;
                }
                if (se.getMessage().indexOf("ORA-02291") >= 0) {
                    ++this.nErrors;
                    String msg = "Integrity constraint violated when inserting into " + v2tableName + ": " + paramString;
                    System.out.println(msg);
                    file.write("\n" + msg);
                    continue;
                }
                if (se.getMessage().indexOf("ORA-00001") >= 0) {
                    ++this.nErrors;
                    String msg = "Unique constraint violated when inserting into " + v2tableName + ": " + paramString;
                    System.out.println(msg);
                    file.write("\n" + msg);
                    continue;
                }
                if (se.getMessage().indexOf("Numeric value out of range (null)") >= 0) {
                    ++this.nErrors;
                    String msg = "Numeric value out of range (null)" + v2tableName + ": " + paramString;
                    System.out.println(msg);
                    file.write("\n" + msg);
                    continue;
                }
                if (se.getMessage().indexOf("cannot be a zero-length string") >= 0) {
                    ++this.nErrors;
                    String msg = "Zero length string error when inserting into " + v2tableName + ": " + paramString;
                    System.out.println(msg);
                    file.write("\n" + msg);
                    continue;
                }
                if (se.getMessage().indexOf("cannot contain a Null value because the Required property for this field is set to True") > 0) {
                    ++this.nErrors;
                    String msg = "Required null value record error for " + v2tableName + ": " + paramString;
                    System.out.println(msg);
                    file.write("\n" + msg);
                    continue;
                }
                System.out.println("\nSQL :" + sql + "Parameters: " + paramString);
                file.write("\n" + sql);
                throw se;
            }
        }
        newStmt.close();
        pStmt.close();
        stmt.close();
    }

    void copySchemes1(BufferedWriter file, String userAbr) throws SQLException, util.SBException, IOException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        if (!this.SSB_RERUN) {
            Collection<Userdef> v18users = this.v18sbdb.getUsers();
            Iterator<Userdef> itU = v18users.iterator();
            this.v2sbdb.clearUsers();
            while (itU.hasNext()) {
                Userdef user = itU.next();
                String userName = user.getName();
                if (userName == null || userName.isEmpty()) {
                    userName = "<UNKNOWN>";
                }
                this.v2sbdb.addUser(user.getUsrID(), userName, user.getSysName(), Discipline.getDisc(user.getDiscID()), user.getColour(), user.getPwd(), user.getPriv());
            }
            this.v2sbdb.setUser(userAbr);
            this.v18sbdb.unloadAbnSchemes();
            for (AbnScheme scheme : this.v18sbdb.getAbnSchemes()) {
                model2.AbnScheme scheme2 = new model2.AbnScheme();
                try {
                    if (scheme.getName() == null || scheme.getName().length() == 0) {
                        scheme2.setName("Scheme ID " + scheme.getID());
                    } else {
                        scheme2.setName(scheme.getName());
                    }
                    for (int i = 0; i < scheme.getNClasses(); ++i) {
                        String className = scheme.getClassName(i);
                        if (className == null || className.length() == 0) {
                            className = scheme.getEntry(i);
                        }
                        if (scheme.getEntry(i) == null || scheme.getEntry(i).length() <= 0 || scheme.getEntry(i).charAt(0) == '+') continue;
                        scheme2.addClass(scheme.getEntry(i), className, scheme.getLowBound(i), scheme.getOutputValue(i));
                    }
                    this.v2sbdb.addAbnScheme(scheme2, scheme.getID());
                }
                catch (Exception e) {
                    String msg = "Problem adding abundance scheme: " + scheme;
                    System.out.println(msg);
                    file.write("\n" + msg);
                    int occs = scheme.getNoccs();
                    if (occs == 0) {
                        msg = "Scheme does not occur in wells - ignored";
                        System.out.println(msg);
                        file.write("\n" + msg);
                        continue;
                    }
                    e.printStackTrace();
                    throw new util.SBException("Problem adding abundance scheme: " + scheme + "\n" + e.getMessage());
                }
            }
        }
        this.v18sbdb.unloadEnvSchemes();
        for (model1_8.EnvScheme scheme : this.v18sbdb.getEnvSchemes()) {
            EnvScheme scheme2 = new EnvScheme();
            scheme2.setName(scheme.getName());
            for (int i = 1; i <= scheme.getNClasses(); ++i) {
                scheme2.addRow();
                scheme2.setTerm(i, scheme.getTerm(i));
                scheme2.setColour(i, scheme.getColour(i));
            }
            try {
                System.out.println("env scheme ID = " + scheme.getID() + ", env scheme name = " + scheme2.getName());
                this.v2sbdb.addEnvScheme(scheme2, scheme.getID());
            }
            catch (util.SBException e) {
                String msg = "Problem adding env scheme: " + scheme;
                System.out.println(msg);
                file.write("\n" + msg);
                int occs = scheme.getNoccs();
                if (occs == 0) {
                    msg = "Scheme does not occur in wells - ignored";
                    System.out.println(msg);
                    file.write("\n" + msg);
                    continue;
                }
                throw new util.SBException("Problem adding environment scheme: " + scheme);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copyLthtrn(BufferedWriter file) throws SQLException, IOException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT lithcode,descr,impcode,sch_id FROM " + this.v18sbdb.DBTableName("SBLTHTRN");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs18.next()) {
            int lithCode = rs18.getInt("lithcode");
            String descr = rs18.getString("descr");
            int impCode = rs18.getInt("impcode");
            int sch_id = rs18.getInt("sch_id");
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("SBLTHTRN") + " (lith_id,descr,impcode,sch_id) VALUES (";
            sql = sql + lithCode + ",";
            sql = sql + SB.DBString(descr) + ",";
            sql = sql + impCode + ",";
            sql = sql + sch_id + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                file.write("\nError inserting lthtrn: " + sqle.getMessage() + "\n" + sql);
            }
        }
        v18stmt.close();
        v2stmt.close();
    }

    void copyCores(BufferedWriter file) throws SQLException, IOException, util.SBException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT distinct(well_code) FROM " + this.v18sbdb.DBTableName("CORES");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs18.next()) {
            Cores cores;
            String wellCode = rs18.getString("well_code");
            if (wellCode != null) {
                wellCode = wellCode.trim();
            }
            Well well = null;
            try {
                well = this.v18sbdb.getAddWell(Well.getWellID(this.v18sbdb, wellCode));
            }
            catch (SBException sbe) {
                this.outputProgress(false, sbe.toString());
                file.write("\nError getting well for Cored interval for well code: " + wellCode);
                continue;
            }
            if (well == null) {
                System.out.print("\nError getting well for Cored interval for well code: " + wellCode);
                file.write("\nError getting well for Cored interval for well code: " + wellCode);
                continue;
            }
            this.outputProgress(false, "Processing well: " + well.getWellCode() + "\n");
            try {
                cores = well.getCores();
            }
            catch (SBException e) {
                throw new util.SBException(e.getMessage() + " in well: " + well.getWellCode());
            }
            model2.Well well2 = this.v2sbdb.getAddWell(well.getWellID());
            boolean coreShiftsAdded = false;
            if (cores != null && cores.getSize() > 0) {
                for (int i = 0; i < cores.getSize(); ++i) {
                    model1_8.CoredInterval core = cores.getCore(i);
                    try {
                        CoredInterval core2 = new CoredInterval(this.v2sbdb, well.getWellID(), core.getTopDepth(), core.getBaseDepth(), core.getCorenum(), core.getRecovered());
                        if (!core.getDeltaData()) continue;
                        well2.getCoreShift().add(well.getWellID(), core.getTopDepth(), (float)core.getDeltaTop());
                        well2.getCoreShift().add(well.getWellID(), core.getBaseDepth(), (float)core.getDeltaBase());
                        coreShiftsAdded = true;
                        continue;
                    }
                    catch (SQLException sqle) {
                        ++this.nErrors;
                        file.write("\nError inserting cored interval: " + sqle.getMessage() + "\n" + SB.sql);
                    }
                }
            }
            if (!coreShiftsAdded) continue;
            well2.getCoreShift().store(well2.getWellID());
        }
        v18stmt.close();
        v2stmt.close();
    }

    void setSbchclinCorrection() throws SQLException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.v2sbdb.DBTableName("SBCHCLIN") + " SET style=0 WHERE style=8 ";
        v2stmt.executeUpdate(sql);
        v2stmt.close();
    }

    void setSbchclinBasePicks() throws SQLException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT c.id,i.name,i.sch_id FROM " + this.v2sbdb.DBTableName("SBCHCLIN") + " c," + this.v2sbdb.DBTableName("IGD_DICT") + " i " + " WHERE surface='B' AND c.id=i.igd_id AND i.igd_type=10";
        ResultSet rs = v2stmt.executeQuery(this.v2sbdb.modQuery(sql));
        class IgdItem {
            int ID;
            String name;
            int schID;
            int surfaceID;

            IgdItem() {
            }
        }
        LinkedList<IgdItem> igdID = new LinkedList<IgdItem>();
        while (rs.next()) {
            IgdItem i = new IgdItem();
            i.ID = rs.getInt("id");
            i.name = rs.getString("name");
            i.schID = rs.getInt("sch_id");
            i.surfaceID = 0;
            igdID.add(i);
        }
        rs.close();
        for (IgdItem i : igdID) {
            sql = "SELECT surface_id FROM " + this.v2sbdb.DBTableName("SURFACE") + " WHERE sch_id=" + i.schID + " AND name='" + i.name + " SB" + "'";
            rs = v2stmt.executeQuery(this.v2sbdb.modQuery(sql));
            if (rs.next()) {
                i.surfaceID = rs.getInt("surface_id");
            }
            rs.close();
        }
        int nUpdated = 0;
        for (IgdItem i : igdID) {
            if (i.surfaceID <= 0) continue;
            sql = "UPDATE " + this.v2sbdb.DBTableName("SBCHCLIN") + " SET id=" + i.surfaceID + ",surface='P' WHERE id=" + i.ID + " AND surface='B'";
            v2stmt.executeUpdate(sql);
            ++nUpdated;
        }
        v2stmt.close();
        this.outputProgress(false, "\nNumber of correlation line bases updated for Sequence picks: " + nUpdated);
    }

    void setSbchclinInterpID(BufferedWriter file) throws SQLException, IOException, util.SBException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT chart_id, line_no, id, interp_id, surface FROM " + this.v2sbdb.DBTableName("SBCHCLIN") + " WHERE surface='F' OR surface='L' OR surface=' ' AND interp_id > 0";
        ResultSet rs = v2stmt.executeQuery(this.v2sbdb.modQuery(sql));
        HashMap<Integer, String> qsProjects = new HashMap<Integer, String>();
        class EvItem {
            int chartID;
            int line_no;
            int ID;
            int qsID;
            int interpID;
            String surface;

            EvItem() {
            }
        }
        LinkedList<EvItem> evID = new LinkedList<EvItem>();
        while (rs.next()) {
            InterpHdr interpHdr;
            EvItem e = new EvItem();
            e.chartID = rs.getInt("chart_id");
            e.line_no = rs.getInt("line_no");
            e.ID = rs.getInt("id");
            e.qsID = rs.getInt("interp_id");
            e.surface = rs.getString("surface");
            if (e.qsID <= 0) continue;
            String name = (String)qsProjects.get(e.qsID);
            if (name == null) {
                sql = "SELECT name FROM " + this.v18sbdb.DBTableName("QSPROJ") + " WHERE qs_id=" + e.qsID;
                ResultSet rs2 = v18stmt.executeQuery(sql);
                if (rs2.next()) {
                    name = rs2.getString("name");
                    if (name == null) {
                        ++this.nErrors;
                        file.write("\nIn setSbchclinInterpID Cannot find QS event project: " + name + ", qs_id=" + e.qsID);
                        continue;
                    }
                    name = name.trim();
                    qsProjects.put(e.qsID, name);
                }
                rs2.close();
            }
            if ((interpHdr = this.v2sbdb.getInterp(name)) == null) {
                ++this.nErrors;
                file.write("\nIn setSbchclinInterpID Cannot find interp name for qsID/interpID: " + e.qsID);
                continue;
            }
            if (interpHdr.getInterpID() == e.qsID) continue;
            e.interpID = interpHdr.getInterpID();
            evID.add(e);
        }
        rs.close();
        int nUpdated = 0;
        file.write("\nUpdating chart correlation lines based on event projects: " + evID.size());
        for (EvItem i : evID) {
            sql = "UPDATE " + this.v2sbdb.DBTableName("SBCHCLIN") + " SET interp_id=" + i.interpID + " WHERE id=" + i.ID + " AND surface='" + i.surface + "' AND chart_id=" + i.chartID + " AND line_no=" + i.line_no + " AND interp_id=" + i.qsID;
            v2stmt.executeUpdate(sql);
            ++nUpdated;
        }
        v2stmt.close();
        this.outputProgress(false, "\nNumber of correlation line event interp_ids updated: " + nUpdated);
    }

    void updateLithDepths() throws SQLException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.v2sbdb.DBTableName("SBILITH") + " SET top_depth=-top_depth, base_depth=-base_depth WHERE well_id in (SELECT well_id FROM " + this.v2sbdb.DBTableName("WELLS w") + ", " + this.v2sbdb.DBTableName("WELL_IDENT v") + " WHERE w.well_code=v.well_code AND w.type='O')";
        v2stmt.executeUpdate(sql);
        sql = "UPDATE " + this.v2sbdb.DBTableName("SBGS") + " SET depth=-depth WHERE well_id in (SELECT well_id FROM " + this.v2sbdb.DBTableName("WELLS w") + ", " + this.v2sbdb.DBTableName("WELL_IDENT v") + " WHERE w.well_code=v.well_code AND w.type='O')";
        v2stmt.executeUpdate(sql);
        v2stmt.close();
    }

    void updateQLithDepths() throws SQLException {
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.v2sbdb.DBTableName("SBQLITH") + " SET top_depth=-top_depth WHERE well_id in (SELECT well_id FROM " + this.v2sbdb.DBTableName("WELLS w") + ", " + this.v2sbdb.DBTableName("WELL_IDENT v") + " WHERE w.well_code=v.well_code AND w.type='O')";
        v2stmt.executeUpdate(sql);
        v2stmt.close();
    }

    void copyEnvTrn(BufferedWriter file) throws SQLException, IOException, util.SBException {
        if (!this.v18sbdb.hasEnvTrn()) {
            file.write("\nNo ENVTRN table in v1.8 database");
            return;
        }
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT source_id,env_sch,txt,prox_id,dist_id FROM " + this.v18sbdb.DBTableName("ENVTRN");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs18.next()) {
            String sourceID = rs18.getString("source_id");
            int envID = rs18.getInt("env_sch");
            String txt = rs18.getString("txt");
            int proxID = rs18.getInt("prox_id");
            int distID = rs18.getInt("dist_id");
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("ENVTRN") + " (source_id,envsch_id,txt,prox_id,dist_id) VALUES (" + SB.DBString(sourceID) + "," + envID + "," + SB.DBString(txt) + "," + proxID + "," + distID + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\nError inserting: " + sqle.getMessage() + "\n" + sql);
                file.write("\nError inserting: " + sqle.getMessage() + "\n" + sql);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copySmark(BufferedWriter file) throws SQLException, IOException, util.SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT well_code,depth,colour FROM " + this.v18sbdb.DBTableName("WELLSMARK");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs18.next()) {
            String wellCode = rs18.getString("well_code");
            double depth = rs18.getDouble("depth");
            String colour = rs18.getString("colour");
            int wellID = Well.getWellID(this.v18sbdb, wellCode);
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("WELLSMARK") + " (well_id,depth,name,created,creator,modified,modifier) VALUES (" + wellID + "," + depth + "," + SB.DBString(colour) + "," + this.v2sbdb.getUserObjectTimestamp() + "," + this.v2sbdb.getUserObjectTimestamp() + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\nError inserting: " + sqle.getMessage() + "\n" + sql);
                file.write("\nError inserting: " + sqle.getMessage() + "\n" + sql);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copySr(BufferedWriter file) throws SQLException, IOException, util.SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT samp_id,ratio,age,ageplus,ageminus,age_below,interp_id FROM " + this.v18sbdb.DBTableName("SBSSR");
        try {
            ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            while (rs18.next()) {
                int v18sampID = rs18.getInt("samp_id");
                double ratio = rs18.getDouble("ratio");
                double age = rs18.getDouble("age");
                float ageplus = rs18.getFloat("ageplus");
                float ageminus = rs18.getFloat("ageminus");
                double agebelow = rs18.getDouble("age_below");
                int interpID = rs18.getInt("interp_id");
                int wellID = v18sampID / 65536;
                int sampID = v18sampID - wellID * 65536;
                try {
                    sampID = this.checkSampID(v18stmt2, v2stmt, wellID, sampID, v18sampID);
                    sql = "INSERT INTO " + this.v2sbdb.DBTableName("SBSSR") + " (well_id,samp_id,ratio,age,ageplus,ageminus,age_below,interp_id,created,creator,modified,modifier) VALUES (" + wellID + "," + sampID + "," + ratio + "," + age + "," + ageplus + "," + ageminus + "," + agebelow + "," + interpID + "," + this.v2sbdb.getUserObjectTimestamp() + "," + this.v2sbdb.getUserObjectTimestamp() + ")";
                    try {
                        v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
                    }
                    catch (SQLException sqle) {
                        ++this.nErrors;
                        System.out.print("\nError inserting: " + sqle.getMessage() + "\n" + sql);
                        file.write("\nError inserting: " + sqle.getMessage() + "\n" + sql);
                    }
                }
                catch (Exception e) {
                    ++this.nErrors;
                    System.out.print("\nError processing SBSSR: " + e.getMessage() + " wellID: " + wellID + " sampID: " + sampID);
                    file.write("\nError processing SBSSR: " + e.getMessage() + " wellID: " + wellID + " sampID: " + sampID);
                }
            }
        }
        catch (SQLException sqle) {
            int nRows;
            sql = "SELECT count(*) as nRows FROM " + this.v18sbdb.DBTableName("SBSSR");
            ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            if (rs18.next() && (nRows = rs18.getInt("nRows")) == 0) {
                file.write("\nError querying SBSSR: " + sqle.getMessage() + "No rows in table - error ignored");
                return;
            }
            throw sqle;
        }
        finally {
            v2stmt.close();
            v18stmt.close();
        }
    }

    void copySampleLith(BufferedWriter file) throws SQLException, IOException, util.SBException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v18stmt2 = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT samp_id,lith_id,percnt FROM " + this.v18sbdb.DBTableName("SBSLITH");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs18.next()) {
            int v18sampID = rs18.getInt("samp_id");
            int lithID = rs18.getInt("lith_id");
            float percent = rs18.getFloat("percnt");
            int wellID = v18sampID / 65536;
            int sampID = v18sampID - wellID * 65536;
            sampID = this.checkSampID(v18stmt2, v2stmt, wellID, sampID, v18sampID);
            sql = "INSERT INTO " + this.v2sbdb.DBTableName("SBSLITH") + " (well_id,samp_id,lith_id,percnt,created,creator,modified,modifier) VALUES (" + wellID + "," + sampID + "," + lithID + "," + percent + "," + this.v2sbdb.getUserObjectTimestamp() + "," + this.v2sbdb.getUserObjectTimestamp() + ")";
            try {
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\nError inserting: " + sqle.getMessage() + "\n" + sql);
                file.write("\nError inserting: " + sqle.getMessage() + "\n" + sql);
            }
        }
        v2stmt.close();
        v18stmt.close();
    }

    void copyTwt(BufferedWriter file) throws SQLException, IOException, util.SBException {
        if (!this.v18sbdb.hasTWT()) {
            ++this.nErrors;
            file.write("\nNo TWT table in 1.8 database");
            this.outputProgress(false, "No WELLTWT table in 1.8 database");
            return;
        }
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT well_code,ddepth,twt FROM " + this.v18sbdb.DBTableName("WELLTWT");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        String lastCode = "";
        int wellID = 0;
        sql = "INSERT INTO " + this.v2sbdb.DBTableName("WELLTWT") + " (well_id,ddepth,twt) VALUES (?,?,?)";
        PreparedStatement pStmt = this.v2sbdb.getDatabase().prepareStatement(sql);
        while (rs18.next()) {
            if (this.v2sbdb.getDBType() != SBdb.DBType.ORACLE) {
                pStmt.clearParameters();
            }
            String params = "";
            String wellCode = rs18.getString("well_code");
            double depth = rs18.getDouble("ddepth");
            double twt = rs18.getDouble("twt");
            if (!lastCode.equals(wellCode)) {
                wellID = Well.getWellID(this.v18sbdb, wellCode);
                lastCode = wellCode;
            }
            pStmt.setInt(1, wellID);
            params = params + wellID + ",";
            pStmt.setDouble(2, depth);
            params = params + depth + ",";
            pStmt.setDouble(3, twt);
            params = params + twt;
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\nError inserting: " + sqle.getMessage() + "\n" + params);
                file.write("\nError inserting: " + sqle.getMessage() + "\n" + params);
            }
        }
        pStmt.close();
        v18stmt.close();
    }

    void copyTvd(BufferedWriter file) throws SQLException, IOException, util.SBException {
        if (!this.v18sbdb.hasTVD()) {
            ++this.nErrors;
            file.write("\nNo TVD table in 1.8 database");
            this.outputProgress(false, "No WELLTVD table in 1.8 database");
            return;
        }
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT well_code,ddepth,tvdepth FROM " + this.v18sbdb.DBTableName("WELLTVD");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        String lastCode = "";
        int wellID = 0;
        sql = "INSERT INTO " + this.v2sbdb.DBTableName("WELLTVD") + " (well_id,plan,ddepth,tvdepth) VALUES (?,0,?,?)";
        PreparedStatement pStmt = this.v2sbdb.getDatabase().prepareStatement(sql);
        while (rs18.next()) {
            SBdb.DBType dBType = this.v2sbdb.getDBType();
            this.v2sbdb.getDBType();
            if (dBType != SBdb.DBType.ORACLE) {
                pStmt.clearParameters();
            }
            String params = "";
            String wellCode = rs18.getString("well_code");
            double depth = rs18.getDouble("ddepth");
            double tvdepth = rs18.getDouble("tvdepth");
            if (!lastCode.equals(wellCode)) {
                wellID = Well.getWellID(this.v18sbdb, wellCode);
                lastCode = wellCode;
            }
            pStmt.setInt(1, wellID);
            params = params + wellID + ",";
            pStmt.setDouble(2, depth);
            params = params + depth + ",";
            pStmt.setDouble(3, tvdepth);
            params = params + tvdepth;
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\nError inserting: " + sqle.getMessage() + "\n" + params);
                file.write("\nError inserting: " + sqle.getMessage() + "\n" + params);
            }
        }
        pStmt.close();
        v18stmt.close();
    }

    void copyTxLoad(BufferedWriter file) throws SQLException, IOException, util.SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        String sql = "SELECT source_id,spec_id,txt";
        if (this.v18sbdb.hasTxLoadOccType()) {
            sql = sql + ",occ_type";
        }
        sql = sql + " FROM " + this.v18sbdb.DBTableName("TXLOAD");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        sql = "INSERT INTO " + this.v2sbdb.DBTableName("TXLOAD") + " (source_id,spec_id,txt,occ_type) VALUES (?,?,?,?)";
        PreparedStatement pStmt = this.v2sbdb.getDatabase().prepareStatement(sql);
        while (rs18.next()) {
            if (this.v2sbdb.getDBType() != SBdb.DBType.ORACLE) {
                pStmt.clearParameters();
            }
            String sourceID = rs18.getString("source_id");
            int specID = rs18.getInt("spec_id");
            String txt = rs18.getString("txt");
            String occType = null;
            if (this.v18sbdb.hasTxLoadOccType()) {
                occType = rs18.getString("occ_type");
            }
            if (occType == null || occType.length() == 0) {
                occType = "In-situ";
            }
            pStmt.setString(1, sourceID);
            pStmt.setInt(2, specID);
            pStmt.setString(3, txt);
            pStmt.setString(4, occType);
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException sqle) {
                ++this.nErrors;
                System.out.print("\nError inserting: " + sqle.getMessage() + "\n" + sql);
                file.write("\nError inserting: " + sqle.getMessage() + "\n" + sql);
            }
        }
        pStmt.close();
        v18stmt.close();
    }

    void copyCasing(BufferedWriter file) throws SQLException, IOException, util.SBException, SBException {
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        String sql = "SELECT distinct(well_code) FROM " + this.v18sbdb.DBTableName("CASING");
        ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
        while (rs18.next()) {
            String wellCode = rs18.getString("well_code");
            int wellID = Well.getWellID(this.v18sbdb, wellCode);
            if (wellID == 0) {
                System.out.print("\nError getting well for Casing for well code: " + wellCode);
                file.write("\nError getting well for Casing for well code: " + wellCode);
                continue;
            }
            Well well = this.v18sbdb.getAddWell(wellID);
            if (well == null) {
                System.out.print("\nError getting well for Casing for well code: " + wellCode);
                file.write("\nError getting well for Casing for well code: " + wellCode);
                continue;
            }
            Casing casing = well.getCasing();
            if (casing == null || casing.getSize() <= 0) continue;
            for (int i = 0; i < casing.getSize(); ++i) {
                model1_8.CasingPoint casingPoint = casing.getCasingPoint(i);
                try {
                    CasingPoint casingPoint2 = new CasingPoint(this.v2sbdb, well.getWellID(), casingPoint.getDepth(), casingPoint.getDiameter());
                    continue;
                }
                catch (SQLException sqle) {
                    ++this.nErrors;
                    file.write("\nError inserting: " + sqle.getMessage() + "\n" + SB.sql);
                }
            }
        }
        v18stmt.close();
        v2stmt.close();
    }

    void copyCategories(BufferedWriter file) throws SQLException, IOException {
        String msg;
        int nDiscs;
        String sql;
        Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
        Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
        ResultSet rs = v2stmt.executeQuery(this.v2sbdb.modQuery(sql = "SELECT count(disc_name) AS ndiscs FROM " + this.v2sbdb.DBTableName("DISCS")));
        if (rs.next() && (nDiscs = rs.getInt("ndiscs")) != 4) {
            sql = "DELETE FROM " + this.v2sbdb.DBTableName("DISCS");
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            sql = "SELECT DISTINCT disc_name,disc_abr,disc_adj,disc_id FROM " + this.v18sbdb.DBTableName("DISCS");
            ResultSet rs18 = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            while (rs18.next()) {
                sql = "INSERT INTO " + this.v2sbdb.DBTableName("DISCS") + " (disc_name, disc_abr,disc_adj,disc_id) VALUES (";
                sql = sql + SB.DBString(rs18.getString("disc_name")) + ",";
                sql = sql + SB.DBString(rs18.getString("disc_abr")) + ",";
                sql = sql + SB.DBString(rs18.getString("disc_adj")) + ",";
                sql = sql + SB.DBString(rs18.getString("disc_id")) + ")";
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
        }
        Categories v18Cats = this.v18sbdb.getCategories();
        sql = "DELETE FROM " + this.v2sbdb.DBTableName("CATEGORY");
        v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
        Iterator it = v18Cats.getIterator();
        while (it.hasNext()) {
            Category cat = (Category)it.next();
            this.v2sbdb.addCategory(cat.getMnem(), Discipline.getDisc(cat.getDiscID()), cat.getName(), cat.getColour());
        }
        this.copyTable(file, "CATCOL", " WHERE abr LIKE '*%'", false, false);
        sql = "DELETE FROM " + this.v2sbdb.DBTableName("CHLABELS");
        v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
        try {
            sql = "SELECT global, local FROM " + this.v18sbdb.DBTableName("CHLABELS");
            ResultSet rsChlabels = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            while (rsChlabels.next()) {
                sql = "INSERT INTO " + this.v2sbdb.DBTableName("CHLABELS") + " (global, local) VALUES (";
                sql = sql + SB.DBString(rsChlabels.getString("global"));
                sql = sql + ",";
                sql = sql + SB.DBString(rsChlabels.getString("local"));
                sql = sql + ")";
                v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
        }
        catch (SQLException sqle) {
            ++this.nErrors;
            msg = "Error getting/setting v1.8 labels: " + sqle.getMessage();
            System.out.println(msg);
            System.out.println("SQL: " + sql);
            file.write("\n" + msg + "\n" + sql);
        }
        try {
            sql = "SELECT scale FROM " + this.v18sbdb.DBTableName("SBSCALES");
            ResultSet rsChscales = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            while (rsChscales.next()) {
                try {
                    sql = "INSERT INTO " + this.v2sbdb.DBTableName("SBSCALES") + " (scale) VALUES (";
                    sql = sql + SB.DBString(rsChscales.getString("scale"));
                    sql = sql + ")";
                    v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().equalsIgnoreCase("GENERAL ERROR")) {
                        System.out.println("Error setting scale: " + sqle.getMessage());
                        continue;
                    }
                    ++this.nErrors;
                    System.out.println("Error setting scale: " + sqle.getMessage());
                    file.write("\nError setting scale: " + sqle.getMessage());
                }
            }
        }
        catch (SQLException sqle) {
            ++this.nErrors;
            msg = "Error getting/setting v1.8 scales: " + sqle.getMessage();
            System.out.println(msg);
            System.out.println("SQL: " + sql);
            file.write("\n" + msg + "\n" + sql);
        }
        v18stmt.close();
        v2stmt.close();
    }

    private void initComponents() {
        this.buttonGroupSampleTops = new ButtonGroup();
        this.buttonGroupConnectionType2 = new ButtonGroup();
        this.buttonGroupConnectionType18 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBoxScheme1 = new JComboBox();
        this.jComboBoxScheme2 = new JComboBox();
        this.jComboBoxScheme3 = new JComboBox();
        this.jComboBoxScheme4 = new JComboBox();
        this.jButtonShowPanel1 = new JButton();
        this.jButtonShowPanel2 = new JButton();
        this.jButtonShowPanel3 = new JButton();
        this.jButtonShowPanel4 = new JButton();
        this.jLabel10 = new JLabel();
        this.jComboBoxSchemeChrono = new JComboBox();
        this.jButtonShowChrono = new JButton();
        this.jLabel11 = new JLabel();
        this.jComboBoxSchemeLstrat = new JComboBox();
        this.jButtonShowLstrat = new JButton();
        this.jLabel12 = new JLabel();
        this.jComboBoxSchemeSequence = new JComboBox();
        this.jButtonShowSequence = new JButton();
        this.jButtonShowWellsPanel1 = new JButton();
        this.jButtonShowWellsPanel2 = new JButton();
        this.jButtonShowWellsPanel3 = new JButton();
        this.jButtonShowWellsPanel4 = new JButton();
        this.jButtonShowWellsChrono = new JButton();
        this.jButtonShowWellsLstrat = new JButton();
        this.jButtonShowWellsSeq = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPaneProgress = new JTextPane();
        this.jPanel1 = new JPanel();
        this.jButtonConnect = new JButton();
        this.jTextFieldDSNv18 = new JTextField();
        this.jTextFieldDSNv2 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonShowDSN = new JButton();
        this.jButtonSelectv18File = new JButton();
        this.jButtonSelectv2File = new JButton();
        this.jButtonFixCounties = new JButton();
        this.jRadioButtonOdbc2 = new JRadioButton();
        this.jRadioButtonJdbc2 = new JRadioButton();
        this.jRadioButtonOdbc18 = new JRadioButton();
        this.jRadioButtonJdbc18 = new JRadioButton();
        this.jTextFieldTablePrefix18 = new JTextField();
        this.jTextFieldTablePrefix20 = new JTextField();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jButtonClose = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldDefaultUser = new JTextField();
        this.jTextFieldLogFile = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButtonDescribev2 = new JButton();
        this.jButtonv18liths = new JButton();
        this.jRadioButtonSampleTops = new JRadioButton();
        this.jRadioButtonSampleBases = new JRadioButton();
        this.jRadioButtonSamplesBoth = new JRadioButton();
        this.jButtonCheckSemiQuant = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldCommitPoint = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextFieldCommitMax = new JTextField();
        this.jButtonStart = new JButton();
        this.jLabel13 = new JLabel();
        this.jTextFieldErrors = new JTextField();
        this.jButtonStop = new JButton();
        this.jTextFieldWellIDFrom = new JTextField();
        this.jTextFieldWellIDTo = new JTextField();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jButtonSBChClinePicks = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(800, 720));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrameSBConv.this.formWindowClosing(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "2. Set interpreted data scheme defaults for unassigned intervals", 0, 0, null, new Color(51, 102, 204)));
        this.jPanel2.setToolTipText("The scheme which will be assigned to intervals that have no current scheme assignment");
        this.jLabel6.setText("Panel 1:");
        this.jLabel7.setText("Panel 2:");
        this.jLabel8.setText("Panel 3:");
        this.jLabel9.setText("Panel 4:");
        this.jComboBoxScheme1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxScheme1.setToolTipText("Select default IGD Scheme for unassigned Biozone panel 1 data");
        this.jComboBoxScheme2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxScheme2.setToolTipText("Select default IGD Scheme for unassigned Biozone panel 2 data");
        this.jComboBoxScheme3.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxScheme3.setToolTipText("Select default IGD Scheme for unassigned Biozone panel 3 data");
        this.jComboBoxScheme4.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxScheme4.setToolTipText("Select default IGD Scheme for unassigned Biozone panel 4 data");
        this.jButtonShowPanel1.setText("Show units...");
        this.jButtonShowPanel1.setToolTipText("Show all intervals where Biozone panel 1 scheme not assigned");
        this.jButtonShowPanel1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowPanel1ActionPerformed(evt);
            }
        });
        this.jButtonShowPanel2.setText("Show units...");
        this.jButtonShowPanel2.setToolTipText("Show all intervals where Biozone panel 2 scheme not assigned");
        this.jButtonShowPanel2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowPanel2ActionPerformed(evt);
            }
        });
        this.jButtonShowPanel3.setText("Show units...");
        this.jButtonShowPanel3.setToolTipText("Show all intervals where Biozone panel 3 scheme not assigned");
        this.jButtonShowPanel3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowPanel3ActionPerformed(evt);
            }
        });
        this.jButtonShowPanel4.setText("Show units...");
        this.jButtonShowPanel4.setToolTipText("Show all intervals where Biozone panel 5 scheme not assigned");
        this.jButtonShowPanel4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowPanel4ActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Chrono:");
        this.jComboBoxSchemeChrono.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSchemeChrono.setToolTipText("Select default IGD Scheme for unassignedChronostratigraphy data");
        this.jButtonShowChrono.setText("Show units...");
        this.jButtonShowChrono.setToolTipText("Show all intervals where chronostrat scheme not assigned");
        this.jButtonShowChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowChronoActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Litho:");
        this.jComboBoxSchemeLstrat.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSchemeLstrat.setToolTipText("Select default IGD Scheme for unassigned Lithostratigraphy data");
        this.jButtonShowLstrat.setText("Show units...");
        this.jButtonShowLstrat.setToolTipText("Show all intervals where lithostrat scheme not assigned");
        this.jButtonShowLstrat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowLstratActionPerformed(evt);
            }
        });
        this.jLabel12.setText("Seq:");
        this.jComboBoxSchemeSequence.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSchemeSequence.setToolTipText("Select default IGD Scheme for unassigned Sequence data");
        this.jButtonShowSequence.setText("Show units...");
        this.jButtonShowSequence.setToolTipText("Show all intervals where sequence scheme not assigned");
        this.jButtonShowSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowSequenceActionPerformed(evt);
            }
        });
        this.jButtonShowWellsPanel1.setText("Show wells...");
        this.jButtonShowWellsPanel1.setToolTipText("");
        this.jButtonShowWellsPanel1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowWellsPanel1ActionPerformed(evt);
            }
        });
        this.jButtonShowWellsPanel2.setText("Show wells...");
        this.jButtonShowWellsPanel2.setToolTipText("");
        this.jButtonShowWellsPanel2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowWellsPanel2ActionPerformed(evt);
            }
        });
        this.jButtonShowWellsPanel3.setText("Show wells...");
        this.jButtonShowWellsPanel3.setToolTipText("");
        this.jButtonShowWellsPanel3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowWellsPanel3ActionPerformed(evt);
            }
        });
        this.jButtonShowWellsPanel4.setText("Show wells...");
        this.jButtonShowWellsPanel4.setToolTipText("");
        this.jButtonShowWellsPanel4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowWellsPanel4ActionPerformed(evt);
            }
        });
        this.jButtonShowWellsChrono.setText("Show wells...");
        this.jButtonShowWellsChrono.setToolTipText("");
        this.jButtonShowWellsChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowWellsChronoActionPerformed(evt);
            }
        });
        this.jButtonShowWellsLstrat.setText("Show wells...");
        this.jButtonShowWellsLstrat.setToolTipText("");
        this.jButtonShowWellsLstrat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowWellsLstratActionPerformed(evt);
            }
        });
        this.jButtonShowWellsSeq.setText("Show wells...");
        this.jButtonShowWellsSeq.setToolTipText("");
        this.jButtonShowWellsSeq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowWellsSeqActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel12).addPreferredGap(0).add((Component)this.jComboBoxSchemeSequence, -2, 192, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel6).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel8).add((Component)this.jLabel9)).add((Component)this.jLabel7).add((Component)this.jLabel10)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jComboBoxScheme2, -2, 192, -2).add((Component)this.jComboBoxScheme3, -2, 192, -2).add((Component)this.jComboBoxScheme1, -2, 192, -2).add((Component)this.jComboBoxScheme4, -2, 192, -2).add((Component)this.jComboBoxSchemeChrono, -2, 192, -2))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel11).addPreferredGap(0).add((Component)this.jComboBoxSchemeLstrat, -2, 204, -2))).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonShowPanel3).addPreferredGap(1).add((Component)this.jButtonShowWellsPanel3, -2, 109, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonShowPanel2).addPreferredGap(1).add((Component)this.jButtonShowWellsPanel2, -2, 109, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonShowPanel4).addPreferredGap(1).add((Component)this.jButtonShowWellsPanel4, -2, 109, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonShowChrono).addPreferredGap(1).add((Component)this.jButtonShowWellsChrono, -2, 109, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonShowLstrat).addPreferredGap(1).add((Component)this.jButtonShowWellsLstrat, -2, 109, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonShowSequence).addPreferredGap(1).add((Component)this.jButtonShowWellsSeq, -2, 109, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonShowPanel1, -2, 109, -2).addPreferredGap(1).add((Component)this.jButtonShowWellsPanel1, -2, 109, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.jComboBoxScheme1, this.jComboBoxScheme2, this.jComboBoxScheme3, this.jComboBoxScheme4, this.jComboBoxSchemeChrono, this.jComboBoxSchemeLstrat, this.jComboBoxSchemeSequence}, 1);
        jPanel2Layout.linkSize(new Component[]{this.jButtonShowChrono, this.jButtonShowLstrat, this.jButtonShowPanel1, this.jButtonShowPanel2, this.jButtonShowPanel3, this.jButtonShowPanel4, this.jButtonShowSequence}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jComboBoxScheme1, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.jButtonShowPanel1).add((Component)this.jButtonShowWellsPanel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jComboBoxScheme2, -2, -1, -2).add((Component)this.jLabel7).add((Component)this.jButtonShowPanel2).add((Component)this.jButtonShowWellsPanel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonShowPanel3).add((Component)this.jLabel8).add((Component)this.jComboBoxScheme3, -2, -1, -2).add((Component)this.jButtonShowWellsPanel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.jComboBoxScheme4, -2, -1, -2).add((Component)this.jButtonShowPanel4).add((Component)this.jButtonShowWellsPanel4)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jComboBoxSchemeChrono, -2, -1, -2).add((Component)this.jLabel10).add((Component)this.jButtonShowChrono).add((Component)this.jButtonShowWellsChrono)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jComboBoxSchemeLstrat, -2, -1, -2).add((Component)this.jLabel11).add((Component)this.jButtonShowLstrat).add((Component)this.jButtonShowWellsLstrat)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jComboBoxSchemeSequence, -2, -1, -2).add((Component)this.jLabel12).add((Component)this.jButtonShowSequence).add((Component)this.jButtonShowWellsSeq)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextPaneProgress.setEditable(false);
        this.jTextPaneProgress.setText("This application will copy and convert data from your v1.8 StrataBugs databse to v2.0.\nDuring the process, no data will be deleted from v1.8. \nAll possible data will be copied, in stages, to v2.0. \n\nConversion will start from the selected \"commit point\" and continue until complete, unless there are errors in conversion which cause the process to stop.\n\nProcess can be interrupted by pressing \"Stop\". It will stop processing after the current stage and the data will not be committed. It can be restarted at the appropriate commit point after correcting any database problems.\n\nData which are not able to be copied into v2.0 will be recorded in the log file. These may be duplicate or orphaned records.\n\nFirst you must \"Connect\" to your v1.8 and v2.0 databases, after confirming the data source names (DSN).\n\nThe default user ID is used to tag creation and modification times of data items where this information is not previously stored in the v1.8 database. It must be a user ID that already exists in the database.\n\n");
        this.jScrollPane1.setViewportView(this.jTextPaneProgress);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "1. Connect to data sources", 0, 0, null, new Color(51, 102, 204)));
        this.jButtonConnect.setText("Connect");
        this.jButtonConnect.setToolTipText("Connect to the data sources named above");
        this.jButtonConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonConnectActionPerformed(evt);
            }
        });
        this.jTextFieldDSNv18.setText("SBUGS1-8");
        this.jTextFieldDSNv18.setToolTipText("Data source name for version 1.8 database");
        this.jTextFieldDSNv2.setText("SBUGS2-0");
        this.jTextFieldDSNv2.setToolTipText("Data source name for version 2 database.");
        this.jLabel1.setText("v1.8 Data Source Name (DSN):");
        this.jLabel2.setText("v2 DSN:");
        this.jButtonShowDSN.setText("Show ODBC...");
        this.jButtonShowDSN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonShowDSNActionPerformed(evt);
            }
        });
        this.jButtonSelectv18File.setText("File...");
        this.jButtonSelectv18File.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonSelectv18FileActionPerformed(evt);
            }
        });
        this.jButtonSelectv2File.setText("File...");
        this.jButtonSelectv2File.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonSelectv2FileActionPerformed(evt);
            }
        });
        this.jButtonFixCounties.setText("Fix counties...");
        this.jButtonFixCounties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonFixCountiesActionPerformed(evt);
            }
        });
        this.buttonGroupConnectionType2.add(this.jRadioButtonOdbc2);
        this.jRadioButtonOdbc2.setSelected(true);
        this.jRadioButtonOdbc2.setText("odbc");
        this.buttonGroupConnectionType2.add(this.jRadioButtonJdbc2);
        this.jRadioButtonJdbc2.setText("jdbc");
        this.buttonGroupConnectionType18.add(this.jRadioButtonOdbc18);
        this.jRadioButtonOdbc18.setSelected(true);
        this.jRadioButtonOdbc18.setText("odbc");
        this.buttonGroupConnectionType18.add(this.jRadioButtonJdbc18);
        this.jRadioButtonJdbc18.setText("jdbc");
        this.jTextFieldTablePrefix18.setToolTipText("Scema/table prefix for v1.8 database (Oracle only)");
        this.jTextFieldTablePrefix20.setToolTipText("Schema/Table prefix for v2 database (Oracle only)");
        this.jLabel17.setText("Schema:");
        this.jLabel18.setText("Schema:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonFixCounties).addPreferredGap(0, 86, Short.MAX_VALUE).add((Component)this.jLabel2))).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldDSNv18, -1, 152, Short.MAX_VALUE).add((Component)this.jTextFieldDSNv2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jButtonSelectv18File).add((Component)this.jButtonSelectv2File)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel17).addPreferredGap(0).add((Component)this.jTextFieldTablePrefix18, -2, 55, -2).addPreferredGap(0).add((Component)this.jButtonShowDSN).addPreferredGap(0).add((Component)this.jRadioButtonOdbc18).addPreferredGap(1).add((Component)this.jRadioButtonJdbc18)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel18).addPreferredGap(0).add((Component)this.jTextFieldTablePrefix20, -2, 55, -2).addPreferredGap(0).add((Component)this.jButtonConnect).addPreferredGap(0).add((Component)this.jRadioButtonOdbc2).addPreferredGap(1).add((Component)this.jRadioButtonJdbc2))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jRadioButtonJdbc18, this.jRadioButtonJdbc2, this.jRadioButtonOdbc18, this.jRadioButtonOdbc2}, 1);
        jPanel1Layout.linkSize(new Component[]{this.jButtonConnect, this.jButtonShowDSN}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldDSNv18, -2, -1, -2).add((Component)this.jButtonSelectv18File).add((Component)this.jButtonShowDSN).add((Component)this.jRadioButtonJdbc18).add((Component)this.jRadioButtonOdbc18).add((Component)this.jTextFieldTablePrefix18, -2, -1, -2).add((Component)this.jLabel17)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jButtonConnect).add((Component)this.jRadioButtonJdbc2).add((Component)this.jRadioButtonOdbc2).add((Component)this.jTextFieldTablePrefix20, -2, -1, -2).add((Component)this.jButtonSelectv2File).add((Component)this.jTextFieldDSNv2, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jButtonFixCounties).add((Component)this.jLabel18)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "3. Specify defaults and log files", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel4.setText("Default user ID:");
        this.jLabel5.setText("Log file name:");
        this.jTextFieldDefaultUser.setText("SYS");
        this.jTextFieldDefaultUser.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FrameSBConv.this.jTextFieldDefaultUserKeyTyped(evt);
            }
        });
        this.jTextFieldLogFile.setText("SBUGS2-0.log");
        this.jTextFieldLogFile.setToolTipText("Enter name of log file. Repeat runs will be appended to file.");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextFieldLogFile, -2, 233, -2)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldDefaultUser, -2, 92, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jTextFieldDefaultUser, -2, -1, -2).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldLogFile, -2, -1, -2))));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Optional utilities", 0, 0, null, new Color(51, 102, 204)));
        this.jButtonDescribev2.setText("Describe v2 model...");
        this.jButtonDescribev2.setToolTipText("Utility to describe v2 data model from data source");
        this.jButtonDescribev2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonDescribev2ActionPerformed(evt);
            }
        });
        this.jButtonv18liths.setText("Describe v1.8 lith");
        this.jButtonv18liths.setToolTipText("Output a file of v1.8 lithology scheme tables");
        this.jButtonv18liths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonv18lithsActionPerformed(evt);
            }
        });
        this.buttonGroupSampleTops.add(this.jRadioButtonSampleTops);
        this.jRadioButtonSampleTops.setText("Assume TOP depth of sample range");
        this.buttonGroupSampleTops.add(this.jRadioButtonSampleBases);
        this.jRadioButtonSampleBases.setSelected(true);
        this.jRadioButtonSampleBases.setText("Assume BASE depth of sample range");
        this.buttonGroupSampleTops.add(this.jRadioButtonSamplesBoth);
        this.jRadioButtonSamplesBoth.setText("Assign top and base depth for cuttings if equal");
        this.jButtonCheckSemiQuant.setText("Check v1.8 Semi-quant");
        this.jButtonCheckSemiQuant.setToolTipText("Check and correct abundance schemes in v1.8 database");
        this.jButtonCheckSemiQuant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonCheckSemiQuantActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add(1, (Component)this.jButtonv18liths, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonDescribev2, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jRadioButtonSamplesBoth).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jRadioButtonSampleBases).add((Component)this.jRadioButtonSampleTops, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonCheckSemiQuant, -2, 139, -2).add(23, 23, 23))).add(154, 154, 154)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jButtonDescribev2).add((Component)this.jRadioButtonSampleTops).add((Component)this.jButtonCheckSemiQuant)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add((Component)this.jRadioButtonSampleBases).add((Component)this.jButtonv18liths)).addPreferredGap(0).add((Component)this.jRadioButtonSamplesBoth).addContainerGap(9, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "4. Run the conversion", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel3.setText("Begin this conversion run at commit point: (between 0 and 35):");
        this.jTextFieldCommitPoint.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FrameSBConv.this.jTextFieldCommitPointKeyTyped(evt);
            }
        });
        this.jLabel14.setText("End this conversion run at commit point:");
        this.jButtonStart.setForeground(new Color(204, 0, 0));
        this.jButtonStart.setText("Start conversion");
        this.jButtonStart.setToolTipText("Start conversion from indicated commit point");
        this.jButtonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonStartActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Number of rejected records or errors:");
        this.jTextFieldErrors.setEditable(false);
        this.jTextFieldErrors.setBackground(new Color(255, 204, 204));
        this.jTextFieldErrors.setText("0");
        this.jButtonStop.setText("Stop");
        this.jButtonStop.setToolTipText("Interrupt conversion process");
        this.jButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonStopActionPerformed(evt);
            }
        });
        this.jTextFieldWellIDFrom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FrameSBConv.this.jTextFieldWellIDFromKeyTyped(evt);
            }
        });
        this.jTextFieldWellIDTo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FrameSBConv.this.jTextFieldWellIDToKeyTyped(evt);
            }
        });
        this.jLabel15.setText("Well ID (samples,analyses,taxonocc):");
        this.jLabel16.setText("to:");
        this.jButtonSBChClinePicks.setText("base picks...");
        this.jButtonSBChClinePicks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonSBChClinePicksActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1, false).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jButtonStart, -2, 156, -2).add(29, 29, 29).add((Component)this.jLabel13, -2, 181, -2).addPreferredGap(1).add((Component)this.jTextFieldErrors, -2, 64, -2).addPreferredGap(1).add((Component)this.jButtonStop, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel14)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1, false).add((Component)this.jTextFieldCommitMax).add((Component)this.jTextFieldCommitPoint, -2, 109, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(2).add((Component)this.jLabel15).add((Component)this.jLabel16)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jTextFieldWellIDFrom, -2, 35, -2).add((Component)this.jTextFieldWellIDTo, -2, 36, -2)))).addPreferredGap(0).add((Component)this.jButtonSBChClinePicks)));
        jPanel5Layout.linkSize(new Component[]{this.jTextFieldWellIDFrom, this.jTextFieldWellIDTo}, 1);
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jTextFieldCommitPoint, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jLabel15)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jTextFieldCommitMax, -2, -1, -2).add((Component)this.jLabel14).add((Component)this.jLabel16))).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jTextFieldWellIDFrom, -2, -1, -2).addPreferredGap(0).add((Component)this.jTextFieldWellIDTo, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jButtonStart, -2, 28, -2).add((Component)this.jButtonStop).add((Component)this.jTextFieldErrors, -2, -1, -2).add((Component)this.jLabel13).add((Component)this.jButtonSBChClinePicks)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSBConv.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 464, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(19, 19, 19).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel4, -1, -1, Short.MAX_VALUE)).add((Component)this.jPanel5, -2, -1, -2))).add(2, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add(2, (Component)this.jPanel1, -2, -1, -2)).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).add(50, 50, 50).add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel5, -2, 112, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonHelp).add((Component)this.jButtonClose)))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.v18sbdb != null) {
            this.prefRoot.put("dsn1_8", this.jTextFieldDSNv18.getText());
            try {
                this.v18sbdb.doRollback();
                this.v18sbdb.close();
            }
            catch (Exception e) {
                System.out.println("Error closing database connection: " + e.getMessage());
            }
        }
        System.out.print("Max Memory       : ");
        System.out.format("%,d%n", Runtime.getRuntime().maxMemory());
        System.out.print("Total Memory: ");
        System.out.format("%,d%n", Runtime.getRuntime().totalMemory());
        System.out.print("Memory free: ");
        System.out.format("%,d%n", Runtime.getRuntime().freeMemory());
        System.out.print("Total memory used: ");
        System.out.format("%,d%n", Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        if (this.v2sbdb != null) {
            this.prefRoot.put("dsn", this.jTextFieldDSNv2.getText());
            this.prefRoot.putInt("commitpoint", this.commitPoint);
            this.prefRoot.putInt("maxcommitpoint", this.maxCommitPoint);
            this.prefRoot.put("userabr", this.jTextFieldDefaultUser.getText());
            this.prefRoot.put("jdbc2", "" + this.jRadioButtonJdbc2.isSelected());
            this.prefRoot.put("jdbc18", "" + this.jRadioButtonJdbc18.isSelected());
            this.saveScheme(41);
            this.saveScheme(42);
            this.saveScheme(43);
            this.saveScheme(44);
            this.saveScheme(2);
            this.saveScheme(3);
            this.saveScheme(10);
            try {
                this.v2sbdb.commit();
                this.v2sbdb.close();
            }
            catch (Exception e) {
                System.out.println("Error closing database connection: " + e.getMessage());
            }
        }
        try {
            this.prefRoot.flush();
        }
        catch (Exception e) {
            System.out.println("Error saving preferences: " + e.getMessage());
        }
        System.out.println("SBConvert closing");
        this.dispose();
    }

    private void jButtonStartActionPerformed(ActionEvent evt) {
        BufferedWriter file;
        if (this.v18sbdb == null || this.v2sbdb == null) {
            JOptionPane.showMessageDialog(this, "Not connected to database(s)", "Error", 2);
            return;
        }
        this.commitPoint = Integer.parseInt(this.jTextFieldCommitPoint.getText());
        this.maxCommitPoint = Integer.parseInt(this.jTextFieldCommitMax.getText());
        this.cancelTask = false;
        if (this.maxCommitPoint <= this.commitPoint) {
            JOptionPane.showMessageDialog(this, "Maximum commit point must be greater than current commit point", "Error", 2);
            return;
        }
        String fileName = this.jTextFieldLogFile.getText();
        if (fileName.length() == 0) {
            JOptionPane.showMessageDialog(this, "No log file name entered.", "Error", 2);
            return;
        }
        int[] igdSchemeTypes = new int[]{2, 3, 10, 41, 42, 43, 44};
        try {
            for (int i = 0; i < igdSchemeTypes.length; ++i) {
                if (this.checkIGDSchemeCombo(igdSchemeTypes[i], false) >= 0) continue;
                JOptionPane.showMessageDialog(this, "You must select default IGD schemes for unassigned zones.", "Error", 2);
                return;
            }
        }
        catch (Exception ex) {
            System.out.println("Should not get this exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        try {
            File logFile = new File(fileName);
            boolean toAppend = true;
            if (this.commitPoint == 0 && logFile.exists()) {
                int option = JOptionPane.showConfirmDialog(this, "Log file already exists, overwrite? (or append to existing file)", this.getTitle(), 1, 3);
                if (option == 2) {
                    return;
                }
                if (option == 0) {
                    toAppend = false;
                }
            }
            file = new BufferedWriter(new FileWriter(fileName, toAppend));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error opening log file: " + fileName + ". " + e.getMessage(), "Error", 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jTextPaneProgress.setCursor(Cursor.getPredefinedCursor(3));
        this.task = new SwingWorker(){
            Exception ex = null;

            public Object doInBackground() {
                String userAbr = FrameSBConv.this.jTextFieldDefaultUser.getText().trim();
                try {
                    if (FrameSBConv.this.commitPoint >= 2) {
                        FrameSBConv.this.v2sbdb.setUser(userAbr);
                    }
                    Audit.setServerDate(FrameSBConv.this.v2sbdb, null);
                    file.write("\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nStrataBugs v1.8 to v2 conversion on " + new Date().toString());
                    switch (FrameSBConv.this.commitPoint) {
                        case 0: {
                            file.write("\n");
                            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                                file.write("\n" + e.toString());
                            }
                            file.write("\n");
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Categories and static data...");
                            try {
                                if (FrameSBConv.this.jRadioButtonSampleBases.isSelected()) {
                                    FrameSBConv.this.v2sbdb.setSampleTops(false);
                                } else if (FrameSBConv.this.jRadioButtonSampleTops.isSelected()) {
                                    FrameSBConv.this.v2sbdb.setSampleTops(true);
                                }
                            }
                            catch (Exception ex) {
                                this.publishLog(file, "Error setting sample tops: " + ex.getMessage());
                                ex.printStackTrace();
                            }
                            if (!FrameSBConv.this.checkedCategories) {
                                FrameSBConv.this.screenCP(file);
                                LinkedList<String> list = new LinkedList<String>();
                                FrameSBConv.this.checkCategories(file, list);
                                if (list.size() > 0) {
                                    this.publishLog(file, "\nSome genus categories are not found in the database.");
                                    this.publishLog(file, "These entries will be ignored unless you stop and create new categories for them in your v1.8 database.");
                                    for (String s : list) {
                                        this.publishLog(file, s);
                                    }
                                    this.publishLog(file, "Press Start again to continue and ignore these entries.");
                                    FrameSBConv.this.checkedCategories = true;
                                    break;
                                }
                            }
                            FrameSBConv.this.copyCategories(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 1: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Schemes 1...");
                            FrameSBConv.this.copySchemes1(file, userAbr);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 2: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Checking analysts...");
                            if (!FrameSBConv.this.checkAnalysts()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            this.publishLog(file, "Schemes 2...");
                            FrameSBConv.this.copySchemes2(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 3: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "IGD Scheme Definitions...");
                            FrameSBConv.this.populateIGDDef();
                            this.publishLog(file, "IGD Schemes...");
                            FrameSBConv.this.copySchemes3(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 4: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Genera...");
                            FrameSBConv.this.copyTaxa1(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 5: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Species...");
                            FrameSBConv.this.copyTaxa2(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 6: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Groups...");
                            FrameSBConv.this.copyTxgroup();
                            this.publishLog(file, "Group members...");
                            FrameSBConv.this.copyTable(file, "GROUPMBR", null, false, false);
                            this.publishLog(file, "Sets...");
                            FrameSBConv.this.copyGroupSet();
                            this.publishLog(file, "Set members...");
                            FrameSBConv.this.copyTable(file, "SETMBR", null, false, false);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 7: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Txnotes...");
                            FrameSBConv.this.copyTable(file, "TXNOTES", null, false, false);
                            if (FrameSBConv.this.v18sbdb.hasSynonymSchemes()) {
                                this.publishLog(file, "SynSch...");
                                FrameSBConv.this.copyTable(file, "SYNSCH", null, false, false);
                            } else {
                                this.publishLog(file, "No synonym schemes.");
                            }
                            this.publishLog(file, "Synonymy & txrefs...");
                            FrameSBConv.this.copyTaxa3(file);
                            this.publishLog(file, "Source...");
                            FrameSBConv.this.copyTable(file, "SOURCE", null, false, false);
                            this.publishLog(file, "Txload...");
                            FrameSBConv.this.copyTxLoad(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 8: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Numeric codes...");
                            FrameSBConv.this.copyTaxa4(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 9: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Logdef...");
                            FrameSBConv.this.copyTable(file, "LOGDEF", null, true, false);
                            this.publishLog(file, "Templates...");
                            FrameSBConv.this.copyTable(file, "SBTEMPLT", null, false, false);
                            FrameSBConv.this.copyTable(file, "SBPANELS", null, false, false);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 10: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Event dictionary...");
                            FrameSBConv.this.copyEvDict(file);
                            this.publishLog(file, "Composite standards...");
                            FrameSBConv.this.copyCmpStd(file);
                            this.publishLog(file, "Composite standard events...");
                            FrameSBConv.this.copyCmpStdEv(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 11: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Interpretations/versions...");
                            FrameSBConv.this.copyInterp(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 12: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Wells...");
                            FrameSBConv.this.copyWells(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 13: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Well lists...");
                            FrameSBConv.this.copyTable(file, "SBWLLST", null, false, false);
                            this.publishLog(file, "Well list members...");
                            FrameSBConv.this.copyTable(file, "SBWLMB", null, false, false);
                            this.publishLog(file, "QS Projects...");
                            FrameSBConv.this.copyQSProj(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 14: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Samples...");
                            FrameSBConv.this.copySamples(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            if (FrameSBConv.this.jTextFieldWellIDFrom.getText().length() == 0) {
                                this.publishLog(file, ++FrameSBConv.this.commitPoint);
                                if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                            }
                            break;
                        }
                        case 15: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Analyses...");
                            FrameSBConv.this.copyAnalyses(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                FrameSBConv.this.v2sbdb.clearSpecType();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            if (FrameSBConv.this.jTextFieldWellIDFrom.getText().length() == 0) {
                                this.publishLog(file, ++FrameSBConv.this.commitPoint);
                                if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                            }
                            break;
                        }
                        case 16: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "TaxonOcc (Fssabnd)...(Warning this process is likely to be time consuming)");
                            FrameSBConv.this.copyFssabnd(file);
                            if (this.isCancelled()) {
                                this.publishLog(file, "Rolling back taxonocc..");
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            if (FrameSBConv.this.jTextFieldWellIDFrom.getText().length() == 0) {
                                this.publishLog(file, ++FrameSBConv.this.commitPoint);
                                if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                            }
                            break;
                        }
                        case 17: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Biostratigraphic comments...");
                            FrameSBConv.this.copyBcmmnts(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 18: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "IGD...");
                            FrameSBConv.this.copyIGD(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 19: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Palaeoenvironments...");
                            FrameSBConv.this.copyIGDEnv(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 20: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "IGD Header information...");
                            FrameSBConv.this.copyIGDHdr(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 21: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Cores...");
                            FrameSBConv.this.copyCores(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 22: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Casing points...");
                            FrameSBConv.this.copyCasing(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 23: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Events...");
                            FrameSBConv.this.copyEvents(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 24: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "LOCs...");
                            FrameSBConv.this.copyQSLOC(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 25: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "ENVTRN...");
                            FrameSBConv.this.copyEnvTrn(file);
                            this.publishLog(file, "LASTVAL...");
                            FrameSBConv.this.copyLastval(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 26: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Overlays...");
                            FrameSBConv.this.copyTable(file, "OVERLAY", null, false, false);
                            FrameSBConv.this.copyTable(file, "OVR_MAP", null, false, false);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 27: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Seismic markers...");
                            FrameSBConv.this.copySmark(file);
                            this.publishLog(file, "TWT...");
                            FrameSBConv.this.copyTwt(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 28: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "TVD...");
                            FrameSBConv.this.copyTvd(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 29: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "SBSSR - Sample ages...");
                            FrameSBConv.this.copySr(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 30: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Lithology Schemes...");
                            FrameSBConv.this.copyLithSchemes(file);
                            if (FrameSBConv.this.v18sbdb.hasLthTrnSch()) {
                                this.publishLog(file, "Lthtrn...");
                                FrameSBConv.this.copyTable(file, "LTHTRNSCH", null, false, false);
                                FrameSBConv.this.copyLthtrn(file);
                            }
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 31: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Well lithology...");
                            FrameSBConv.this.copyTable(file, "SBILITH", null, false, false);
                            this.publishLog(file, "Well grain size...");
                            FrameSBConv.this.copyTable(file, "SBGS", null, false, false);
                            this.publishLog(file, "Updating lithology depths for outcrops...");
                            FrameSBConv.this.updateLithDepths();
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 32: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Well lithology qualifiers...");
                            FrameSBConv.this.copyTable(file, "SBQLITH", null, false, false);
                            FrameSBConv.this.updateQLithDepths();
                            this.publishLog(file, "Sample lithology...");
                            FrameSBConv.this.copySampleLith(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 33: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Chart syn scheme tidying...");
                            FrameSBConv.this.setv18ChartSynSch(file);
                            this.publishLog(file, "Charts...");
                            FrameSBConv.this.copyTable(file, "SBCHARTS", null, false, true);
                            this.publishLog(file, "Chart panels...");
                            FrameSBConv.this.copyTable(file, "SBCHPANL", null, false, false);
                            this.publishLog(file, "Chart correlation lines...");
                            FrameSBConv.this.copyTable(file, "SBCHCLIN", null, false, false);
                            this.publishLog(file, "Correlation line table correction for inherited values...");
                            FrameSBConv.this.setSbchclinCorrection();
                            this.publishLog(file, "Correlation line base sequence surface pick corrections...");
                            FrameSBConv.this.setSbchclinBasePicks();
                            this.publishLog(file, "Correlation line qs_id -> interp_id translation for event picks...");
                            FrameSBConv.this.setSbchclinInterpID(file);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                            if (FrameSBConv.this.commitPoint >= FrameSBConv.this.maxCommitPoint) break;
                        }
                        case 34: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Chart log templates...");
                            FrameSBConv.this.copyTable(file, "SBLOGTPL", null, false, false);
                            this.publishLog(file, "Chart log traces...");
                            FrameSBConv.this.copyTable(file, "SBLOGTRC", null, false, false);
                            if (this.isCancelled()) {
                                FrameSBConv.this.v2sbdb.doRollback();
                                break;
                            }
                            FrameSBConv.this.v2sbdb.commit();
                            this.publishLog(file, ++FrameSBConv.this.commitPoint);
                        }
                        case 35: {
                            this.publishLog(file, FrameSBConv.this.commitPoint + "...");
                            this.publishLog(file, "Data conversion complete.\nYou may send your log file to StrataData for analysis.");
                            if (FrameSBConv.this.v2sbdb.getDBType() == SBdb.DBType.ACCESS) {
                                this.publishLog(file, "\nYou should Compact the new database.");
                            }
                            FrameSBConv.this.commitPoint = 0;
                            FrameSBConv.this.jTextFieldCommitPoint.setText("0");
                            break;
                        }
                        case 36: {
                            try {
                                Runtime.getRuntime().exec("jetcomp");
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                            }
                        }
                        default: {
                            this.publishLog(file, "Unrecognised commit point: " + FrameSBConv.this.commitPoint);
                        }
                    }
                }
                catch (Exception e) {
                    this.ex = e;
                    if (e.getClass() == SQLException.class) {
                        this.publishLog(file, "\n" + SB.sql);
                    }
                    this.publishLog(file, "\n" + e.getMessage());
                    System.out.println("Exception: " + e.getMessage());
                    e.printStackTrace();
                    System.out.println("Rolling back...");
                    FrameSBConv.this.v2sbdb.doRollback();
                    this.cancel(true);
                }
                FrameSBConv.this.setCursor(Cursor.getDefaultCursor());
                FrameSBConv.this.jTextPaneProgress.setCursor(Cursor.getDefaultCursor());
                return "ok";
            }

            private void publishLog(BufferedWriter file2, Object o) {
                try {
                    file2.write("\n" + o.toString());
                    file2.flush();
                }
                catch (IOException e) {
                    System.out.println("Error writing log file: " + e.getMessage());
                }
                this.publish(o);
            }

            @Override
            protected void done() {
                if (this.ex != null) {
                    FrameSBConv.this.outputProgress(false, "\r\nException during processing: " + this.ex.getMessage());
                    int numberedLines = 0;
                    StackTraceElement[] trace = this.ex.getStackTrace();
                    for (int i = 0; i < trace.length && numberedLines < 8; ++i) {
                        FrameSBConv.this.outputProgress(false, "\r\n" + trace[i]);
                        if (trace[i].getLineNumber() > 0) {
                            ++numberedLines;
                        }
                        if (trace[i].getClassName().startsWith("javax.swing.")) break;
                    }
                    this.ex.printStackTrace();
                } else {
                    FrameSBConv.this.outputProgress(false, "\r\n...background task has finished");
                }
                this.publishLog(file, "\n" + new Date().toString());
                try {
                    file.close();
                }
                catch (Exception e) {
                    System.out.println("Exception when closing file: " + e.getMessage());
                }
                FrameSBConv.this.jTextPaneProgress.setCursor(Cursor.getDefaultCursor());
                FrameSBConv.this.setCursor(Cursor.getDefaultCursor());
            }

            protected void process(List chunks) {
                for (Object o : chunks) {
                    FrameSBConv.this.outputProgress(false, "\n" + o.toString());
                    try {
                        int cp = Integer.parseInt(o.toString());
                        FrameSBConv.this.jTextFieldCommitPoint.setText("" + cp);
                        if (FrameSBConv.this.maxCommitPoint <= cp) {
                            FrameSBConv.this.jTextFieldCommitMax.setText("" + (cp + 1));
                        }
                        FrameSBConv.this.jTextFieldErrors.setText("" + FrameSBConv.this.nErrors);
                    }
                    catch (Exception e) {}
                }
                if (this.isCancelled() || this.isDone()) {
                    FrameSBConv.this.jTextPaneProgress.setCursor(Cursor.getDefaultCursor());
                    FrameSBConv.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        this.outputProgress(true, "\nStarting conversion");
        this.task.execute();
    }

    void outputProgress(boolean clear, String text) {
        if (clear) {
            this.jTextPaneProgress.setText("");
        }
        this.jTextPaneProgress.setText(this.jTextPaneProgress.getText() + text);
        this.jTextPaneProgress.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void formWindowClosing(WindowEvent evt) {
        System.out.println("In window closing...");
        this.jButtonCloseActionPerformed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jButtonConnectActionPerformed(ActionEvent evt) {
        if (this.v18sbdb != null) {
            try {
                if (this.v18sbdb.getDatabase() != null) {
                    System.out.println("Closing previous v1.8 connection...");
                    this.v18sbdb.close();
                }
            }
            catch (Exception ex) {
                System.out.println("Exception from closing previous connection: " + ex.getMessage());
                ex.printStackTrace();
            }
            this.v18sbdb = null;
        }
        if (this.v2sbdb != null) {
            try {
                if (this.v2sbdb.getDatabase() != null) {
                    System.out.println("Closing previous v2 connection...");
                    this.v2sbdb.close();
                }
            }
            catch (Exception ex) {
                System.out.println("Exception from closing previous connection: " + ex.getMessage());
                ex.printStackTrace();
            }
            this.v2sbdb = null;
        }
        System.out.println("Connecting.....");
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.v18sbdb = new model1_8.SBdb();
            int tries = 0;
            while (true) {
                JDialog dialog;
                try {
                    String connectionType = "odbc";
                    if (this.jRadioButtonJdbc18.isSelected()) {
                        connectionType = "jdbc";
                        dialog = new DialogSBConvJdbc(this, true, "v18", this.prefRoot.node(connectionType).get("v18host", ""), this.prefRoot.node(connectionType).get("v18instance", ""), this.prefRoot.node(connectionType).get("v18user", ""), this.prefRoot.node(connectionType).get("v18pwd", ""));
                        dialog.setLocationRelativeTo(this);
                        dialog.setVisible(true);
                        if (!((DialogSBConvJdbc)dialog).isOK) {
                            return;
                        }
                        this.prefRoot.node(connectionType).put("v18host", ((DialogSBConvJdbc)dialog).host);
                        this.prefRoot.node(connectionType).put("v18instance", ((DialogSBConvJdbc)dialog).instance);
                        this.prefRoot.node(connectionType).put("v18user", ((DialogSBConvJdbc)dialog).userID);
                        this.prefRoot.node(connectionType).put("v18pwd", ((DialogSBConvJdbc)dialog).password);
                        this.v18sbdb.connect(this.jTextFieldDSNv18.getText(), ((DialogSBConvJdbc)dialog).host, ((DialogSBConvJdbc)dialog).instance, ((DialogSBConvJdbc)dialog).userID, ((DialogSBConvJdbc)dialog).password);
                        break;
                    }
                    this.v18sbdb.Connect(this.jTextFieldDSNv18.getText().trim(), this.jTextFieldTablePrefix18.getText().trim().length() > 0 ? this.jTextFieldTablePrefix18.getText().trim() : null, null, null, false);
                }
                catch (SBException sbe) {
                    System.out.println("Exception from v1.8 connection: " + sbe);
                    dialog = new DialogLogin((Frame)this, true);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (((DialogLogin)dialog).isOK) continue;
                    System.exit(0);
                    if (++tries < 3) continue;
                }
                break;
            }
            if (this.jTextFieldLogFile.getText().equalsIgnoreCase("SBUGS2-0.log")) {
                String fileName = this.v18sbdb.licence.getCompany();
                StringTokenizer tok = new StringTokenizer(fileName, " ,.");
                if (tok.hasMoreTokens()) {
                    fileName = tok.nextToken();
                }
                this.jTextFieldLogFile.setText(fileName + "-" + "SBUGS2-0.log");
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error connecting to v1.8 database: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
            this.v18sbdb = null;
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        System.out.println("Connected to v1.8 database");
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.v2sbdb = new SBdb();
            System.out.println("Note: connecting with system NOT ORACLE to v2");
            String connectionType = "odbc";
            if (this.jRadioButtonJdbc2.isSelected()) {
                connectionType = "jdbc";
                DialogSBConvJdbc dialog = new DialogSBConvJdbc(this, true, "v2", this.prefRoot.node(connectionType).get("v2host", ""), this.prefRoot.node(connectionType).get("v2instance", ""), this.prefRoot.node(connectionType).get("v2user", ""), this.prefRoot.node(connectionType).get("v2pwd", ""));
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (!dialog.isOK) {
                    return;
                }
                this.prefRoot.node(connectionType).put("v2host", dialog.host);
                this.prefRoot.node(connectionType).put("v2instance", dialog.instance);
                this.prefRoot.node(connectionType).put("v2user", dialog.userID);
                this.prefRoot.node(connectionType).put("v2pwd", dialog.password);
                this.v2sbdb.connect(this.jTextFieldDSNv2.getText(), dialog.host, dialog.instance, dialog.userID, dialog.password);
            } else {
                this.v2sbdb.connect(connectionType, this.jTextFieldDSNv2.getText().trim(), this.jTextFieldTablePrefix20.getText().trim().length() > 0 ? this.jTextFieldTablePrefix20.getText().trim() : null, null, null);
            }
            SBdb.preserveAudit = true;
            System.out.println("Connected to v2 database");
            System.out.println("Supports batch updates? : " + this.v2sbdb.getDatabase().getMetaData().supportsBatchUpdates());
            this.setIGDSchemeCombo(41);
            this.setIGDSchemeCombo(42);
            this.setIGDSchemeCombo(43);
            this.setIGDSchemeCombo(44);
            this.setIGDSchemeCombo(2);
            this.setIGDSchemeCombo(3);
            this.setIGDSchemeCombo(10);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error connecting to v2 database: " + ex.toString(), "Error", 0);
            ex.printStackTrace();
            this.v2sbdb = null;
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.jTextPaneProgress.setText("Connected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDescribev2ActionPerformed(ActionEvent evt) {
        if (this.v2sbdb == null) {
            JOptionPane.showMessageDialog(this, "Not connected", "Error", 0);
            return;
        }
        try {
            if (this.fileChooser.showOpenDialog(this) == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.v2sbdb.describeText(file);
                this.jTextPaneProgress.setText("Text file: " + file + " written.");
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
            this.v2sbdb = null;
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTextFieldCommitPointKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal(this.jTextFieldCommitPoint, 3, evt, true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonStopActionPerformed(ActionEvent evt) {
        if (this.task != null && this.task.cancel(true)) {
            this.cancelTask = true;
            this.outputProgress(false, "\nProcess cancelling...");
        }
    }

    private void jButtonShowPanel1ActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDIntervals(41);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowPanel2ActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDIntervals(42);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowPanel3ActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDIntervals(43);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowPanel4ActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDIntervals(44);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowChronoActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDIntervals(3);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowLstratActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDIntervals(2);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowSequenceActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDIntervals(10);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonv18lithsActionPerformed(ActionEvent evt) {
        if (this.v18sbdb == null) {
            JOptionPane.showMessageDialog(this, "Not connected", "Error", 0);
            return;
        }
        try {
            this.createLithFile();
            this.outputProgress(false, "v1.8 Lithology file created: v18Lithology.dat");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
            System.out.println("Error in file writing: " + ex.getMessage());
        }
    }

    private void jButtonShowDSNActionPerformed(ActionEvent evt) {
        try {
            String[] cmd = new String[]{"cmd.exe", "/c", "odbcad32.exe"};
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error trying to invoke runtime :", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowWellsPanel1ActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDWellIntervals(41);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowWellsPanel2ActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDWellIntervals(42);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowWellsPanel3ActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDWellIntervals(43);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowWellsPanel4ActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDWellIntervals(44);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowWellsChronoActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDWellIntervals(3);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowWellsLstratActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDWellIntervals(2);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonShowWellsSeqActionPerformed(ActionEvent evt) {
        try {
            this.showUnassignedIGDWellIntervals(10);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private void jTextFieldDefaultUserKeyTyped(KeyEvent evt) {
        if (SB.uCaseField(this.jTextFieldDefaultUser, 5, evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonSelectv18FileActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter("mdb", "Access Files (*.mdb)");
        jFileChooser.setSelectedFile(new File(this.jTextFieldDSNv18.getText()));
        jFileChooser.setFileFilter(filter);
        jFileChooser.showOpenDialog(this);
        if (jFileChooser.getSelectedFile() != null) {
            File file = jFileChooser.getSelectedFile();
            this.jTextFieldDSNv18.setText(file.getPath());
        }
    }

    private void jButtonSelectv2FileActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter("mdb", "Access Files (*.mdb)");
        jFileChooser.setSelectedFile(new File(this.jTextFieldDSNv2.getText()));
        jFileChooser.setFileFilter(filter);
        jFileChooser.showOpenDialog(this);
        if (jFileChooser.getSelectedFile() != null) {
            File file = jFileChooser.getSelectedFile();
            this.jTextFieldDSNv2.setText(file.getPath());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        String page = "databaseconversion.html";
        try {
            String helpRoot = "http://www.stratadata.co.uk/StrataBugs/v2.0/help/";
            if (helpRoot.startsWith("file:///")) {
                String file = helpRoot.substring("file:///".length()) + page;
                if (!new File(file).exists()) {
                    JOptionPane.showMessageDialog(null, "Help page '" + file + "' does not exist.", "StrataBugs Help", 2);
                    return;
                }
            } else if (!helpRoot.startsWith("http://127.0.0.1:8082/resource/jar:file:/") && helpRoot.startsWith("jar:file:/")) {
                Runtime.getRuntime().exec("\"C:\\Program Files\\Mozilla firefox\\firefox.exe\" " + helpRoot + page);
                return;
            }
            URL url = new URL(helpRoot + page);
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (Exception ex) {
            SB.showStackError(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonCheckSemiQuantActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.checkSemiQuant();
        }
        catch (Exception ex) {
            SB.showStackError(ex.getMessage(), ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonFixCountiesActionPerformed(ActionEvent evt) {
        try {
            if (this.v2sbdb == null || !this.v2sbdb.isConnected()) {
                JOptionPane.showMessageDialog(this, "Not connected");
                return;
            }
            int opt = JOptionPane.showConfirmDialog(this, "Use this to fix a conversion error where countries were used for counties.\nYou will lose any county names added or edited in v2.\nContinue?", "County Fix", 0, 3);
            if (opt == 1) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
            Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
            String sql = "UPDATE " + this.v2sbdb.DBTableName("WELLS") + " SET county=NULL";
            v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            sql = "SELECT well_code,county FROM " + this.v18sbdb.DBTableName("WELLS") + " WHERE county IS NOT NULL";
            int nWells = 0;
            ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            while (rs.next()) {
                String wellCode = rs.getString("WELL_CODE");
                String county = rs.getString("COUNTY");
                sql = "UPDATE " + this.v2sbdb.DBTableName("WELLS") + " SET county=" + SB.DBString(county) + " WHERE well_code='" + wellCode + "'";
                nWells += v2stmt.executeUpdate(this.v2sbdb.modQuery(sql));
            }
            v2stmt.close();
            v18stmt.close();
            this.v2sbdb.commit();
            JOptionPane.showMessageDialog(this, "Process complete, table cleared and " + nWells + " updated.\nYou can close the converter now.");
        }
        catch (Exception ex) {
            this.v2sbdb.doRollback();
            SB.showStackError(ex.getMessage(), ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTextFieldWellIDFromKeyTyped(KeyEvent evt) {
        SB.intFieldVal(this.jTextFieldWellIDFrom, 5, evt, false);
    }

    private void jTextFieldWellIDToKeyTyped(KeyEvent evt) {
        SB.intFieldVal(this.jTextFieldWellIDTo, 5, evt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSBChClinePicksActionPerformed(ActionEvent evt) {
        try {
            if (this.v2sbdb == null || !this.v2sbdb.isConnected()) {
                JOptionPane.showMessageDialog(this, "Not connected");
                return;
            }
            int opt = JOptionPane.showConfirmDialog(this, "Use this to fix correlation line base picks.\nContinue?", "County Fix", 0, 3);
            if (opt == 1) {
                return;
            }
            this.setSbchclinBasePicks();
            this.v2sbdb.commit();
        }
        catch (Exception ex) {
            this.v2sbdb.doRollback();
            SB.showStackError(ex.getMessage(), ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAnalysts() {
        try {
            char discID;
            if (this.v2sbdb == null || !this.v2sbdb.isConnected()) {
                JOptionPane.showMessageDialog(this, "Not connected");
                boolean bl = false;
                return bl;
            }
            if (this.v2sbdb.getUsers().isEmpty()) {
                JOptionPane.showMessageDialog(this, "This must be run after conversion step 1.", "StrataBugs", 1);
                boolean bl = false;
                return bl;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            Statement v18stmt = this.v18sbdb.getDatabase().createStatement();
            Statement v2stmt = this.v2sbdb.getDatabase().createStatement();
            String sql = "SELECT DISTINCT analyst, disc_id FROM " + this.v18sbdb.DBTableName("SMPDTL") + " ORDER BY analyst";
            ResultSet rs = v18stmt.executeQuery(this.v18sbdb.modQuery(sql));
            HashMap<String, Character> map = new HashMap<String, Character>();
            while (rs.next()) {
                String analyst = rs.getString("analyst");
                if (analyst == null || analyst.isEmpty()) continue;
                analyst = analyst.toUpperCase();
                String disc = rs.getString("disc_id");
                if (disc == null || disc.isEmpty()) continue;
                discID = disc.charAt(0);
                if (this.v2sbdb.getUser(analyst) != null) continue;
                map.put(analyst, Character.valueOf(discID));
            }
            if (!map.isEmpty()) {
                Set<String> toAdd = map.keySet();
                DialogAnalysts dialog = new DialogAnalysts((Frame)this, true, toAdd);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (!dialog.isOK) {
                    discID = '\u0000';
                    return discID != '\u0000';
                }
                toAdd = dialog.analysts;
                if (!toAdd.isEmpty()) {
                    for (String analyst : toAdd) {
                        Character discID2 = (Character)map.get(analyst);
                        if (discID2 == null || discID2.charValue() == '\u0000') {
                            discID2 = Character.valueOf('M');
                        }
                        this.v2sbdb.addUser(analyst, analyst, null, Discipline.getDisc(discID2.charValue()), Color.BLACK, null, 0);
                    }
                }
            }
            v2stmt.close();
            v18stmt.close();
            this.v2sbdb.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.v2sbdb.doRollback();
            SB.showStackError(ex.getMessage(), ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

