/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.data.wfs.internal.parsers.EmfAppSchemaParser;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.xsd.Configuration;

public class DescribeFeatureTypeResponse
extends WFSResponse {
    private FeatureType parsed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescribeFeatureTypeResponse(DescribeFeatureTypeRequest request, HTTPResponse httpResponse) throws ServiceException, IOException {
        super(request, httpResponse);
        WFSStrategy strategy = request.getStrategy();
        Configuration wfsConfiguration = strategy.getWfsConfiguration();
        QName remoteTypeName = request.getTypeName();
        FeatureTypeInfo featureTypeInfo = strategy.getFeatureTypeInfo(remoteTypeName);
        CoordinateReferenceSystem defaultCrs = featureTypeInfo.getCRS();
        try (InputStream responseStream = httpResponse.getResponseStream();){
            Object prefix = remoteTypeName.getLocalPart();
            if (((String)prefix).length() < 3) {
                prefix = (String)prefix + "zzz";
            }
            File tmpSchemaFile = File.createTempFile((String)prefix, ".xsd");
            try (FileOutputStream output = new FileOutputStream(tmpSchemaFile);){
                IOUtils.copy((InputStream)responseStream, (OutputStream)output);
                output.flush();
            }
            try {
                URL schemaLocation = tmpSchemaFile.toURI().toURL();
                this.parsed = EmfAppSchemaParser.parse(wfsConfiguration, remoteTypeName, schemaLocation, defaultCrs, strategy.getFieldTypeMappings());
            }
            finally {
                tmpSchemaFile.delete();
            }
        }
        finally {
            httpResponse.dispose();
        }
    }

    public FeatureType getFeatureType() {
        return this.parsed;
    }
}

