/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v2_0.storedquery;

import java.io.Serializable;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterCQLExpressionFilterFactoryImpl;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMapping;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingContext;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;

public class ParameterMappingExpressionValue
implements ParameterMapping,
Serializable {
    private String expressionLanguage;
    private String expression;
    private transient Expression cqlExpression;
    private String parameterName;
    private boolean forcible;

    public ParameterMappingExpressionValue(String name, String language, String expression) {
        this.setParameterName(name);
        this.setExpressionLanguage(language);
        this.setExpression(expression);
    }

    public ParameterMappingExpressionValue() {
    }

    public void setForcible(boolean forcible) {
        this.forcible = forcible;
    }

    @Override
    public boolean isForcible() {
        return this.forcible;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    private Expression ensureExpression() {
        if (this.cqlExpression != null) {
            return this.cqlExpression;
        }
        try {
            this.cqlExpression = CQL.toExpression((String)this.expression, (FilterFactory)new ParameterCQLExpressionFilterFactoryImpl());
        }
        catch (CQLException ce) {
            throw new IllegalArgumentException("Illegal CQL expression", ce);
        }
        return this.cqlExpression;
    }

    public String evaluate(ParameterMappingContext mappingContext) {
        Object obj = this.ensureExpression().evaluate((Object)mappingContext);
        String ret = obj == null ? null : (obj instanceof String ? (String)obj : obj.toString());
        return ret;
    }
}

